/*
 * Decompiled with CFR 0.152.
 */
package app;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Path {
    public static final int LINE_INT = 1;
    public static final int BOX_INT = 2;
    public short numPoints;
    public short[] xy = new short[32];
    public short ix;
    public short iy;
    public short minX;
    public short minY;
    public short maxX;
    public short maxY;

    public Path() {
        this.clear();
    }

    private void grow() {
        short[] a = new short[this.xy.length + 32];
        System.arraycopy(this.xy, 0, a, 0, this.xy.length);
        this.xy = a;
        a = null;
    }

    public void addPoint(int x, int y) {
        if (this.numPoints == this.xy.length >> 1) {
            this.grow();
        }
        int i = this.numPoints << 1;
        if (this.numPoints == 0 || x != this.xy[i - 2] || y != this.xy[i - 1]) {
            this.xy[i] = (short)x;
            this.xy[i + 1] = (short)y;
            this.numPoints = (short)(this.numPoints + 1);
            if (x < this.minX) {
                this.minX = (short)x;
            }
            if (x > this.maxX) {
                this.maxX = (short)x;
            }
            if (y < this.minY) {
                this.minY = (short)y;
            }
            if (y > this.maxY) {
                this.maxY = (short)y;
            }
        }
    }

    public void clear() {
        this.numPoints = 0;
        this.minY = Short.MAX_VALUE;
        this.minX = Short.MAX_VALUE;
        this.maxY = Short.MIN_VALUE;
        this.maxX = Short.MIN_VALUE;
    }

    public int getArea() {
        int area = 0;
        int i = 0;
        for (int c = this.numPoints - 1; c > 0; --c) {
            area += this.xy[i] * this.xy[i + 3];
            area -= this.xy[i + 1] * this.xy[i + 2];
            i += 2;
        }
        return (area >>= 1) < 0 ? -area : area;
    }

    public static final boolean pointInSegment(int x, int y, int x0, int y0, int x1, int y1) {
        int aux;
        if (x0 > x1) {
            aux = x0;
            x0 = x1;
            x1 = aux;
        }
        if (y0 > y1) {
            aux = y0;
            y0 = y1;
            y1 = aux;
        }
        return x >= x0 && x <= x1 && y >= y0 && y <= y1;
    }

    public short intersects(int x, int y) {
        return this.intersects(x, y, x, y, 1);
    }

    public short intersects(int x0, int y0, int x1, int y1, int mode) {
        int aux;
        if (this.numPoints == 0) {
            return -1;
        }
        if (mode == 1) {
            if (x0 > x1) {
                aux = x0;
                x0 = x1;
                x1 = aux;
            }
            if (y0 > y1) {
                aux = y0;
                y0 = y1;
                y1 = aux;
            }
        }
        boolean hor0 = y0 == y1;
        int px0 = this.xy[0];
        int py0 = this.xy[1];
        int i = 2;
        for (int c = this.numPoints - 1; c > 0; --c) {
            boolean hor1;
            int px1 = this.xy[i];
            int py1 = this.xy[i + 1];
            if (px0 > px1) {
                aux = px0;
                px0 = px1;
                px1 = aux;
            }
            if (py0 > py1) {
                aux = py0;
                py0 = py1;
                py1 = aux;
            }
            boolean bl = hor1 = py0 == py1;
            if (x0 <= px1 && x1 >= px0 && y0 <= py1 && y1 >= py0) {
                if (mode == 1) {
                    if (hor0 != hor1) {
                        if (hor0) {
                            this.ix = (short)px0;
                            this.iy = (short)y0;
                        } else {
                            this.ix = (short)x0;
                            this.iy = (short)py0;
                        }
                    } else if (hor0) {
                        this.ix = (short)(x0 < px0 ? px0 : px1);
                        this.iy = (short)y0;
                    } else {
                        this.ix = (short)x0;
                        this.iy = (short)(y0 < py0 ? py0 : py1);
                    }
                }
                return (short)(i - 2 >> 1);
            }
            px0 = this.xy[i];
            py0 = this.xy[i + 1];
            i += 2;
        }
        return -1;
    }

    public boolean includes(int x, int y) {
        int cnt = 0;
        for (int i = this.numPoints - 2 << 1; i >= 0; i -= 2) {
            short x0 = this.xy[i];
            short y0 = this.xy[i + 1];
            short x1 = this.xy[i + 2];
            short y1 = this.xy[i + 3];
            if (x0 == x1 ? x == x0 && (y >= y0 && y <= y1 || y >= y1 && y <= y0) : y == y0 && (x >= x0 && x <= x1 || x >= x1 && x <= x0)) {
                return true;
            }
            if (x >= x0 && x >= x1 || (y0 > y || y1 <= y) && (y0 <= y || y1 > y)) continue;
            ++cnt;
        }
        return cnt & true;
    }

    public void draw(Graphics g) {
        if (this.numPoints < 2) {
            return;
        }
        short x0 = this.xy[0];
        short y0 = this.xy[1];
        int i = 2;
        for (int c = this.numPoints - 1; c > 0; --c) {
            g.drawLine((int)x0, (int)y0, (int)this.xy[i], (int)this.xy[i + 1]);
            x0 = this.xy[i];
            y0 = this.xy[i + 1];
            i += 2;
        }
    }

    private void addSort(short[] s, int size, int a, int b, int c) {
        int cnt;
        int pos = 0;
        for (cnt = size; cnt > 0 && a > s[pos]; --cnt) {
            pos += 3;
        }
        int j = (size - 1) * 3;
        while (cnt > 0) {
            s[j + 3] = s[j];
            s[j + 4] = s[j + 1];
            s[j + 5] = s[j + 2];
            --cnt;
            j -= 3;
        }
        s[pos] = (short)a;
        s[pos + 1] = (short)Math.min(b, c);
        s[pos + 2] = (short)Math.max(b, c);
    }

    public void fill(Graphics g, int x, int y, Image pattern, int patX, int patY) {
        int nH = 0;
        short[] h = new short[(this.numPoints - 1 >> 1) * 3];
        int nV = 0;
        short[] v = new short[(this.numPoints - 1 >> 1) * 3];
        int i = 0;
        for (int c = this.numPoints - 1; c > 0; --c) {
            if (this.xy[i] == this.xy[i + 2]) {
                this.addSort(v, nV, this.xy[i], this.xy[i + 1], this.xy[i + 3]);
                ++nV;
            } else {
                this.addSort(h, nH, this.xy[i + 1], this.xy[i], this.xy[i + 2]);
                ++nH;
            }
            i += 2;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        short x0 = 0;
        short x1 = 0;
        short y0 = h[0];
        i = 3;
        for (int ch = nH - 1; ch != 0; --ch) {
            short y1 = h[i];
            if (y0 != y1) {
                int cnt = 0;
                int j = 0;
                for (int cV = nV; cV != 0; --cV) {
                    if (v[j + 1] < y1 && v[j + 2] > y0) {
                        if (cnt == 0) {
                            x0 = v[j];
                        } else {
                            x1 = v[j];
                        }
                        if (++cnt == 2) {
                            if (pattern == null) {
                                g.fillRect(x + x0, y + y0, x1 - x0 + 1, y1 - y0 + 1);
                            } else {
                                g.setClip(x + x0, y + y0, x1 - x0 + 1, y1 - y0 + 1);
                                g.drawImage(pattern, patX, patY, 0);
                            }
                            cnt = 0;
                        }
                    }
                    j += 3;
                }
                y0 = y1;
            }
            i += 3;
        }
        if (pattern != null) {
            g.setClip(clipX, clipY, clipW, clipH);
        }
        v = null;
        h = null;
    }
}

