/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.App;
import app.Game;
import app.Sprite;
import app.SpriteLayer;
import com.movilenio.game.Kernel;
import java.io.IOException;
import movilib.ANIManager;
import movilib.SPRManager;
import movilib.SpriteImage;

public class Enemy {
    public static final byte MOAI = 1;
    public static final byte PLANTA = 2;
    public static final byte VACA = 3;
    public static final byte PEZ = 4;
    public static final byte PULPO = 5;
    byte id;
    byte diff;
    public static final byte ST_NORMAL = 0;
    public static final byte ST_CABREADO = 1;
    public static final byte ST_ATAQUE = 2;
    public static final byte ST_FIRE = 3;
    byte status;
    byte subStatus;
    int statusTime;
    public byte size;
    short maxPlayerDist;
    short blockCount;
    int frecCabreo;
    int frecTontos;
    byte maxTontos;
    byte numTontos;
    SPRManager sprman = new SPRManager();
    ANIManager animan = new ANIManager();
    int hBoss;
    int hAux;
    int _dx;
    int _dy;
    int vel;
    int mov_t;
    int radius;
    int _radius;
    short indRoca;
    short hRoca;
    short[] rocas;
    short zVaca;
    short dzVaca;
    short tmrVaca;
    SpriteLayer sprLayer1;
    SpriteLayer sprLayer2;
    static short[] clsn = new short[4];

    public void load(int id, int diff) {
        this.id = (byte)id;
        try {
            this.unload();
            System.gc();
            this.sprman.load("/e" + id + ".s");
            this.animan.load("/e" + id + ".a", this.sprman);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.size = (byte)2;
        switch (id) {
            case 1: {
                this.indRoca = (short)this.sprman.findSprite(201);
                this.rocas = new short[7];
            }
        }
        this.setDiff(diff);
    }

    public void setDiff(int diff) {
        diff = App.limit(diff, 1, 10);
        this.diff = (byte)diff;
        this.vel = 2 + (diff >> 2);
        this.maxPlayerDist = (short)(App.game.winW - (diff - 1) * 3 * App.game.winW / 100);
        this.frecCabreo = 50;
        this.frecTontos = (15 - diff) * 20;
        switch (this.id) {
            case 2: {
                this.frecTontos = (11 - diff) * 20;
                break;
            }
            case 4: {
                this.frecCabreo = 40;
                break;
            }
            case 3: {
                this.frecCabreo = 100;
                break;
            }
            case 5: {
                this.frecCabreo = 40;
                this.frecTontos = 10;
            }
        }
    }

    public void setSize(int newSize) {
        this.size = (byte)newSize;
        Sprite sprBoss = Game.sprLayer[3].sprites[this.hBoss];
        switch (this.id) {
            case 1: {
                if (this.status != 0) {
                    this.sprLayer2.sprites[this.hAux].ind = (short)this.sprman.findSprite((this.status == 2 ? 122 : 112) - this.size);
                }
                this._radius = 15 + 10 * this.size;
                this.indRoca = (short)this.sprman.findSprite(203 - this.size);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.sprLayer2.changeAnimation(this.hAux, this.animan, 102 - this.size, 0x10 | sprBoss.animFlags, 0, 3);
                break;
            }
            case 3: {
                this.sprLayer2.changeAnimation(this.hAux, this.animan, 102 - this.size, 0x10 | sprBoss.animFlags, 20, 3);
            }
        }
        this.sprLayer2.changeAnimation(this.hBoss, this.animan, 12 - this.size, 0x10 | sprBoss.animFlags, 20, 3);
        this.maxTontos = (byte)(2 + this.diff / 5 - (2 - newSize));
        byte cnt = 0;
        for (int i = this.sprLayer1.maxSprites - 1; i >= 0; --i) {
            Sprite spr = this.sprLayer1.sprites[i];
            if (spr.status != 2 || spr.code != 21) continue;
            if (++cnt > this.maxTontos) {
                this.sprLayer1.setMove(i, 0, 0);
                this.sprLayer1.changeAnimation(i, Game.aniGame, 20, 0, 0, 2);
                this.numTontos = (byte)(this.numTontos - 1);
                continue;
            }
            this.sprLayer1.changeAnimation(i, this.animan, this.size == 2 ? 300 : 301, spr.animFlags, 21, spr.speed);
        }
    }

    public void unload() {
        this.sprman.unload();
        this.animan.unload();
    }

    public void start() {
        this.sprLayer1 = Game.sprLayer[2];
        this.sprLayer2 = Game.sprLayer[3];
        this.blockCount = 0;
        this.numTontos = 0;
        this.hAux = -1;
        if (this.id == 1) {
            this.hRoca = 0;
            for (int i = 0; i < this.rocas.length; ++i) {
                this.rocas[i] = (short)(51 * i);
                this.sprLayer2.addSprite(this.sprman, -1, 202, 0, 0, 0, 20);
            }
        }
        int x = App.game.imgBg.getWidth() >> 1;
        int y = App.game.imgBg.getHeight() >> 1;
        if (this.id == 4) {
            this.hAux = this.sprLayer2.addAnimation(this.animan, -1, 100, x, y, 0, 0, 3);
        }
        this.hBoss = this.sprLayer2.addAnimation(this.animan, -1, 10, x, y, 0, 20, 3);
        if (this.id == 1) {
            this.hAux = this.sprLayer2.addSprite(this.sprman, -1, -1, x, y, 0, 0);
        }
        if (this.id == 3) {
            this.hAux = this.sprLayer2.addAnimation(this.animan, -1, 100, x, y, 0, 20, 3);
        }
        this.zVaca = 0;
        this.setSize(2);
        this.setStatus(0);
        if (this.id == 1) {
            this.radius = this._radius;
            this.MOAI_movRocas();
        }
        this.sprLayer2.setMove(this.hBoss, 0, 0);
        this._dy = 0;
        this._dx = 0;
        this.GEN_changeMov();
    }

    public void GEN_changeMov() {
        int V = this.vel;
        int maxPDist = this.maxPlayerDist;
        if (this.id == 3 && this.subStatus == 3) {
            this.sprLayer2.changeAnimation(this.hAux, this.animan, 102 - this.size, 16, 20, 3);
            this.subStatus = 0;
        }
        switch (this.status) {
            case 1: {
                if (this.id == 3) {
                    ++V;
                    maxPDist = 10;
                    break;
                }
                V += 2;
                maxPDist -= this.diff * 3;
                break;
            }
            case 2: {
                if (this.id == 1) {
                    V = 3;
                    maxPDist >>= 1;
                    break;
                }
                maxPDist -= this.diff * 3 / 2;
            }
        }
        if (App.game.player.isOut && (this.id != 3 || this.status != 1)) {
            maxPDist = (maxPDist << 1) / 3;
        }
        if (this.status == 0 && App.getRandom(3) == 0) {
            this._dy = 0;
            this._dx = 0;
            this.mov_t = (byte)App.getRandom(10, 20);
        } else {
            int destY;
            int destX;
            Sprite spr = this.sprLayer2.sprites[this.hBoss];
            if (!(this.status != 0 || App.game.player.isOut || this.blockCount <= 20 && App.getRandom(15) != 0)) {
                destX = App.getRandom(App.game.pathBg.minX, App.game.pathBg.maxX);
                destY = App.getRandom(App.game.pathBg.minY, App.game.pathBg.maxY);
            } else {
                short playerX = App.game.player.getX();
                short playerY = App.game.player.getY();
                destX = App.getRandom(Math.max(playerX - maxPDist, App.game.pathBg.minX), Math.min(playerX + maxPDist, App.game.pathBg.maxX));
                destY = App.getRandom(Math.max(playerY - (maxPDist >> 1), App.game.pathBg.minY), Math.min(playerY + (maxPDist >> 1), App.game.pathBg.maxY));
            }
            int dx = spr.dx;
            int dy = spr.dy;
            this.sprLayer2.setMoveTo(this.hBoss, destX, destY, V);
            this._dx = spr.dx;
            this._dy = spr.dy;
            spr.dx = dx;
            spr.dy = dy;
            if (this.id == 3 && this.status == 1) {
                spr.dx = this._dx;
                spr.dy = this._dy;
            }
            this.mov_t = Math.max(Math.abs((spr.x >> 8) - destX), Math.abs((spr.y >> 8) - destY)) / V;
        }
    }

    private void MOAI_movRocas() {
        if (this.radius != this._radius) {
            this.radius = this.radius > this._radius ? --this.radius : ++this.radius;
        } else {
            this._radius = this.status == 1 ? App.getRandom(15 + 10 * this.size + 10, 60 + 10 * this.size) : 15 + 10 * this.size;
        }
        this.radius += App.sgn(this._radius - this.radius);
        Sprite spr = this.sprLayer2.sprites[this.hBoss];
        for (int i = this.rocas.length - 1; i >= 0; --i) {
            Sprite sprite = this.sprLayer2.sprites[this.hRoca + i];
            this.rocas[i] = (short)((this.rocas[i] + 5) % 360);
            int xx = this.radius * App.st[this.rocas[i] + 90] >> 8;
            int yy = this.radius * App.st[this.rocas[i]] >> 8;
            sprite.ind = (short)(this.indRoca + yy * 3 / 2 / this.radius);
            sprite.x = spr.x + (xx << 8);
            sprite.y = spr.y - ((yy << 1) / 3 << 8);
        }
    }

    public void GEN_addTonto(int x, int y) {
        if (x == -1) {
            x = App.getRandom(App.game.pathBg.minX + 20, App.game.pathBg.maxX - 20);
            y = App.getRandom(App.game.pathBg.minY + 20, App.game.pathBg.maxY - 20);
        }
        if (App.game.pathBg.includes(x, y) && this.sprLayer1.addAnimation(Game.aniGame, -1, this.id == 2 || this.id == 3 ? 20 : 21, x, y, 16, 12, 2) != -1) {
            this.numTontos = (byte)(this.numTontos + 1);
        }
    }

    public void GEN_movTontos() {
        for (int layer = 2; layer <= 3; ++layer) {
            SpriteLayer sprLayer = Game.sprLayer[layer];
            block23: for (int i = sprLayer.maxSprites - 1; i >= 0; --i) {
                Sprite spr = sprLayer.sprites[i];
                if (spr.status == 1) {
                    switch (spr.code) {
                        case 13: {
                            sprLayer.changeAnimation(i, Game.aniGame, 50, spr.animFlags, 41, 2);
                            App.game.hMoco = i;
                            App.game.updateMoco(true);
                            break;
                        }
                        case 12: {
                            int vel = 1;
                            int ani_vel = 1;
                            switch (this.id) {
                                case 1: 
                                case 3: 
                                case 4: 
                                case 5: {
                                    vel = App.getRandom(1, 2) + this.diff / 5;
                                    ani_vel = 3;
                                    break;
                                }
                                case 2: {
                                    vel = App.getRandom(2, 3) + (this.diff >> 2);
                                    ani_vel = 6 - vel;
                                }
                            }
                            short playerX = App.game.player.getX();
                            short playerY = App.game.player.getY();
                            int distX = playerX - (spr.x >> 8);
                            int distY = playerY - (spr.y >> 8);
                            switch (this.id) {
                                case 1: 
                                case 3: 
                                case 4: {
                                    sprLayer.setMoveTo(i, playerX, playerY, vel);
                                    if (this.id == 3) {
                                        spr.dx = -spr.dx;
                                    }
                                    if (Math.abs(spr.dx) < 160) {
                                        spr.dx = 160 * App.sgn(distX);
                                    }
                                    if (Math.abs(spr.dy) >= 160) break;
                                    spr.dy = 160 * App.sgn(distY);
                                    break;
                                }
                                case 2: {
                                    spr.dx = vel << 8;
                                    if ((this.sprLayer2.sprites[this.hBoss].flags & 1) == 0) {
                                        spr.dx = -spr.dx;
                                    }
                                    spr.dy = App.getRandom(180, 230) * vel * App.sgn(distY);
                                    break;
                                }
                                case 5: {
                                    sprLayer.setMove(i, 0, vel << 8);
                                }
                            }
                            sprLayer.changeAnimation(i, this.animan, this.size == 2 ? 300 : 301, App.sgn(spr.dx) == 1 ? 1 : 0, 21, ani_vel);
                        }
                    }
                    continue;
                }
                block13 : switch (spr.code) {
                    case 21: {
                        if (this.id != 5 && !App.game.pathBg.includes(spr.x + spr.dx >> 8, spr.y >> 8)) {
                            spr.dx = -spr.dx;
                            spr.flags = (byte)(spr.flags ^ 1);
                            spr.animFlags = (byte)(spr.animFlags ^ 1);
                        }
                        if (App.game.pathBg.includes(spr.x >> 8, spr.y + spr.dy >> 8)) continue block23;
                        if (this.id == 5) {
                            sprLayer.setMove(i, 0, 0);
                            sprLayer.changeAnimation(i, Game.aniGame, 22, 0, 27, 2);
                            this.numTontos = (byte)(this.numTontos - 1);
                            continue block23;
                        }
                        spr.dy = -spr.dy;
                        continue block23;
                    }
                    case 22: 
                    case 24: 
                    case 25: {
                        if (App.game.pathBg.includes(spr.x >> 8, spr.y >> 8)) continue block23;
                        sprLayer.setMove(i, 0, 0);
                        switch (spr.code) {
                            case 25: {
                                sprLayer.changeAnimation(i, this.animan, 201, 0, 26, 2);
                                break block13;
                            }
                            case 24: {
                                sprLayer.changeAnimation(i, Game.aniGame, 20, 0, 0, 2);
                                break block13;
                            }
                            case 22: {
                                sprLayer.changeAnimation(i, Game.aniGame, 40, 0, 23, 2);
                            }
                        }
                    }
                }
            }
        }
    }

    public void setStatus(int status) {
        block25: {
            block0 : switch (status) {
                case 0: {
                    this.statusTime = App.getRandom(15 - this.diff, 30 - (this.diff << 1)) * 20;
                    if (this.status != status) {
                        this.sprLayer2.changeAnimation(this.hBoss, this.animan, 12 - this.size, 16, 20, 3);
                    }
                    switch (this.id) {
                        case 1: {
                            this.sprLayer2.sprites[this.hAux].status = 1;
                            break;
                        }
                        case 3: {
                            if (this.status == status && this.subStatus != 3) break;
                            this.sprLayer2.changeAnimation(this.hAux, this.animan, 102 - this.size, 16, 20, 3);
                            break;
                        }
                        case 4: {
                            this.sprLayer2.sprites[this.hAux].status = (byte)2;
                        }
                    }
                    break;
                }
                case 1: {
                    App.game.addFloatingText(0, 0, App.texts[3], 15, 2);
                    this.statusTime = (App.getRandom(2, 4) + (this.diff >> 2)) * 20;
                    if (this.status != status) {
                        this.sprLayer2.changeAnimation(this.hBoss, this.animan, 22 - this.size, 16, 20, 3);
                    }
                    switch (this.id) {
                        case 1: {
                            this.sprLayer2.sprites[this.hAux].status = (byte)2;
                            this.sprLayer2.sprites[this.hAux].ind = (short)this.sprman.findSprite(112 - this.size);
                            break;
                        }
                        case 3: {
                            if (this.status != status || this.subStatus == 3) {
                                this.sprLayer2.changeAnimation(this.hAux, this.animan, 102 - this.size, 16, 20, 3);
                            }
                            this.statusTime = App.getRandom(1, 1 + (this.diff >> 1)) * 20;
                            break;
                        }
                        case 4: {
                            this.sprLayer2.sprites[this.hAux].status = 1;
                        }
                    }
                    break;
                }
                case 2: {
                    this.statusTime = (App.getRandom(2, 4) + (this.diff >> 2)) * 20;
                    if (this.status != status) {
                        this.sprLayer2.changeAnimation(this.hBoss, this.animan, 32 - this.size, 16, 20, 3);
                    }
                    switch (this.id) {
                        case 1: {
                            this.sprLayer2.sprites[this.hAux].status = (byte)2;
                            this.sprLayer2.sprites[this.hAux].ind = (short)this.sprman.findSprite(122 - this.size);
                            break block0;
                        }
                        case 3: {
                            if (this.status != status || this.subStatus == 3) {
                                this.sprLayer2.changeAnimation(this.hAux, this.animan, 102 - this.size, 16, 20, 3);
                                break block0;
                            }
                            break block25;
                        }
                        case 4: {
                            this.sprLayer2.sprites[this.hAux].status = (byte)2;
                        }
                    }
                }
            }
        }
        this.status = (byte)status;
        this.subStatus = 0;
    }

    public void playAI() {
        Sprite[] spr = this.sprLayer2.sprites;
        Sprite sprBoss = spr[this.hBoss];
        if (sprBoss.status != 2) {
            int baseId = 0;
            switch (this.status) {
                case 0: {
                    baseId = 12;
                    break;
                }
                case 1: {
                    baseId = 22;
                    break;
                }
                case 2: {
                    baseId = 32;
                }
            }
            this.sprLayer2.changeAnimation(this.hBoss, this.animan, baseId - this.size, 16, 20, 3);
        }
        if (this.mov_t > 0) {
            --this.mov_t;
        }
        if (this.mov_t == 0) {
            if (this.zVaca == 0) {
                this.GEN_changeMov();
            } else {
                this._dy = 0;
                this._dx = 0;
                this.sprLayer2.setMove(this.hBoss, 0, 0);
            }
            if (this.blockCount > 0) {
                this.blockCount = (short)(this.blockCount - 5);
            }
        }
        sprBoss.dx += this._dx - sprBoss.dx >> 2;
        sprBoss.dy += this._dy - sprBoss.dy >> 2;
        int x = sprBoss.x >> 8;
        int y = sprBoss.y >> 8;
        int dx = sprBoss.dx >> 8;
        int dy = sprBoss.dy >> 8;
        SpriteImage sprImg = this.sprLayer2.getSpriteImage(this.hBoss);
        SPRManager.getClsn(sprImg.clsnList[0], 0, x, y, sprBoss.flags, clsn);
        if (this.id != 3) {
            if (App.game.pathBg.intersects(clsn[0] + dx, clsn[1], clsn[2] + dx, clsn[3], 2) != -1) {
                this._dx = -this._dx;
                sprBoss.dx = -sprBoss.dx;
                this.mov_t = 5;
                if (this.blockCount < 100) {
                    this.blockCount = (short)(this.blockCount + 10);
                }
            }
            if (App.game.pathBg.intersects(clsn[0], clsn[1] + dy, clsn[2], clsn[3] + dy, 2) != -1) {
                this._dy = -this._dy;
                sprBoss.dy = -sprBoss.dy;
                this.mov_t = 5;
                if (this.blockCount < 100) {
                    this.blockCount = (short)(this.blockCount + 10);
                }
            }
        }
        if (this.statusTime > 0) {
            --this.statusTime;
        }
        if (this.statusTime == 0 && this.zVaca == 0 && this.tmrVaca == 0) {
            this.mov_t = 0;
            if (this.status == 0) {
                if (App.getRandom(100) < this.frecCabreo) {
                    this.setStatus(1);
                } else {
                    this.setStatus(2);
                }
            } else {
                this.setStatus(0);
            }
        }
        byte flags = 0;
        boolean invH = false;
        if (x < App.game.player.getX()) {
            flags = (byte)(flags | 1);
            invH = true;
        }
        boolean bGenTonto = this.numTontos < this.maxTontos && this.status == 0 && App.getRandom(this.frecTontos) == 0;
        sprBoss.flags = flags;
        sprBoss.animFlags = (byte)(sprBoss.animFlags & 0xF0 | flags);
        if (this.hAux != -1) {
            if (this.id == 3) {
                this.zVaca = (short)(this.zVaca + this.dzVaca);
                if (this.zVaca <= 0) {
                    if (this.dzVaca < 0) {
                        if (App.bVibra) {
                            Kernel.instance.vibrate(400);
                        }
                        this._dy = 0;
                        this._dx = 0;
                        this.sprLayer2.setMove(this.hBoss, 0, 0);
                        this.sprLayer2.changeSprite(this.hAux, 145 - 20 * this.size, flags, 20);
                        this.tmrVaca = (short)10;
                        this.mov_t = this.tmrVaca;
                        SPRManager.getClsn(this.sprLayer2.getSpriteImage((int)this.hAux).clsnList[1], 0, x, y, spr[this.hAux].flags, clsn);
                        short playerX = App.game.player.getX();
                        short playerY = App.game.player.getY();
                        if (playerX >= clsn[0] && playerY >= clsn[1] && playerX <= clsn[2] && playerY <= clsn[3]) {
                            App.game.player.kill();
                            this.statusTime = 0;
                        }
                    }
                    this.dzVaca = 0;
                    this.zVaca = 0;
                } else {
                    this.dzVaca = (short)(this.dzVaca - 1);
                }
            }
            this.sprLayer2.moveSpriteTo(this.hAux, x, y - this.zVaca);
            spr[this.hAux].flags = flags;
        }
        switch (this.id) {
            case 1: {
                this.MOAI_movRocas();
                if (bGenTonto) {
                    this.GEN_addTonto(-1, -1);
                }
                if (this.status != 2 || (Game.counter & 3) != 0) break;
                this.sprLayer2.addAnimation(Game.aniGame, -1, 41, sprBoss.x >> 8, (sprBoss.y >> 8) - (10 + this.size * 10), 0, 0, 1);
                break;
            }
            case 3: {
                int _y;
                int _x;
                if (bGenTonto) {
                    this.subStatus = (byte)3;
                    this._dy = 0;
                    this._dx = 0;
                    this.sprLayer2.setMove(this.hBoss, 0, 0);
                    this.sprLayer2.setMove(this.hAux, 0, 0);
                    this.sprLayer2.changeSprite(this.hAux, 146 - 20 * this.size, flags, 20);
                    this.mov_t = 20;
                    _x = 7 + 7 * this.size;
                    _y = -(8 + 8 * this.size);
                    if (invH) {
                        _x = -_x;
                    }
                    this.GEN_addTonto(x + _x, y + _y);
                    break;
                }
                if (this.status != 1 || this.zVaca != 0) break;
                if (this.tmrVaca == 0) {
                    this.sprLayer2.changeSprite(this.hAux, 147 - 20 * this.size, flags, 20);
                    this.GEN_changeMov();
                    this.dzVaca = (short)(this.mov_t > 21 ? this.mov_t >> 1 : 10);
                    break;
                }
                this.tmrVaca = (short)(this.tmrVaca - 1);
                break;
            }
            case 4: 
            case 5: {
                int _y;
                int _x;
                if (bGenTonto) {
                    this.GEN_addTonto(-1, -1);
                }
                if (this.status != 2) break;
                switch (sprBoss.currentFrame) {
                    case 0: {
                        this.subStatus = (byte)3;
                        break;
                    }
                    case 2: {
                        short ind;
                        int codAni;
                        int idAni;
                        if (this.subStatus != 3) break;
                        if (this.id == 4) {
                            _x = -14 - 11 * this.size;
                            _y = 4 + 2 * this.size;
                            idAni = 200;
                            codAni = 25;
                        } else {
                            _x = -10 - 10 * this.size;
                            _y = 3 + 3 * this.size;
                            idAni = 102 - this.size;
                            codAni = 24;
                        }
                        if (invH) {
                            _x = -_x;
                        }
                        if ((ind = this.sprLayer2.addAnimation(this.animan, -1, idAni, x + _x, y + _y, sprBoss.flags, codAni, 1)) != -1) {
                            this.sprLayer2.setMove(ind, (invH ? 5 : -5) << 8, App.getRandom(-2, 2) << 8);
                        }
                        this.subStatus = 0;
                    }
                }
                break;
            }
            case 2: {
                int ind;
                int _y;
                int _x;
                if (this.subStatus == 2 && sprBoss.currentFrame == 3) {
                    this.subStatus = 0;
                    _x = 10 + 12 * this.size;
                    _y = -(8 + 10 * this.size);
                    if ((flags & 1) == 0) {
                        _x = -_x;
                    }
                    this.GEN_addTonto(x + _x, y + _y);
                }
                if (bGenTonto && this.subStatus == 0) {
                    this.subStatus = (byte)2;
                    this._dy = 0;
                    this._dx = 0;
                    sprBoss.dy = 0;
                    sprBoss.dx = 0;
                    this.mov_t = 25;
                    this.sprLayer2.changeAnimation(this.hBoss, this.animan, 22 - this.size, 16, 20, 4);
                }
                if (this.status != 2) break;
                if (sprBoss.currentFrame == 0) {
                    this.subStatus = (byte)3;
                    break;
                }
                if (this.subStatus != 3) break;
                _x = 10 + 12 * this.size;
                _y = -(8 + 10 * this.size);
                if ((flags & 1) == 0) {
                    _x = -_x;
                }
                if ((ind = this.sprLayer1.addSprite(Game.sprGame, -1, 200, x + _x, y + _y, 0, 22)) != -1) {
                    short playerX = App.game.player.getX();
                    short playerY = App.game.player.getY();
                    this.sprLayer1.setMoveTo(ind, App.getRandom(playerX - 10, playerX + 10), App.getRandom(playerY - 10, playerY + 10), 3);
                }
                this.subStatus = 0;
            }
        }
        this.GEN_movTontos();
    }
}

