/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.Game;
import app.MainMenu;
import com.movilenio.game.Kernel;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import movilib.BitmapFont;

public class App
extends MIDlet {
    public static final int KEY_U = 257;
    public static final int KEY_D = 514;
    public static final int KEY_L = 1028;
    public static final int KEY_R = 2056;
    public static final int KEY_FIRE = 4112;
    public static final int KEY_OK = 12304;
    public static final int KEY_CANCEL = 16384;
    public static final int FPS = 20;
    public static boolean bSound = true;
    public static boolean bVibra = true;
    public static final byte CTRL_MODE_NORMAL = 0;
    public static final byte CTRL_MODE_ADVANCED = 1;
    public static final byte CTRL_MODE_EXPERT = 2;
    public static byte ctrlMode = 0;
    public static final int BG_COLOR = 3485569;
    public static byte lastScorePos = (byte)-1;
    public static int lastScore = 0;
    public static int[] topScore = new int[]{50000, 20000, 5000};
    public static String[] topScoreNames = new String[]{"ses", "ses", "ses"};
    public static byte lastLevel = 0;
    public static MainMenu mainMenu;
    public static Game game;
    public static BitmapFont font;
    public static String[] texts;
    public static Random rand;
    public static final String MUSIC_MAIN = "/title";
    public static Object music;
    private static String idMusic;
    public static boolean bLoading;
    public static short[] st;
    public static short LINES_num;
    public static short[] LINES_x;
    public static String[] LINES_lines;
    public static int LINES_width;
    public static int LINES_height;
    public static int LINES_y;
    public static Image LINES_img;
    private static Graphics LINES_g;
    public static Image LINES_img2;
    private static Graphics LINES_g2;
    public static final int HINT_MOCO = 0;
    public static final int HINT_MODE1 = 1;
    public static final int HINT_MODE2 = 2;
    public static final int HINT_CUT = 3;
    public static final int HINT_CLOSE = 4;
    public static final int HINT_ITEM = 5;
    public static boolean HINT_visible;
    public static int HINT_flags;
    public static String[] HINT_text;

    public static final void playMusic(String id, int flags) {
        if (bSound && !id.equals(idMusic)) {
            App.stopMusic();
            idMusic = id;
            music = Kernel.instance.openMusic(idMusic, "audio/midi");
            Kernel.instance.playMusic(music, flags);
        }
    }

    public static final void stopMusic() {
        if (music != null) {
            idMusic = null;
            Kernel.instance.stopMusic(music);
            music = null;
        }
    }

    public static final void loadingScreen(Graphics g) {
        int KW = Kernel.instance.getWidth();
        int KH = Kernel.instance.getHeight();
        g.setColor(3485569);
        g.fillRect(0, 0, KW, KH);
        font.drawString(g, "Loading", KW >> 1, KH >> 1, 17);
    }

    public static int sgn(int a) {
        return a < 0 ? -1 : (a > 0 ? 1 : 0);
    }

    public static int limit(int v, int v0, int v1) {
        if (v0 > v1) {
            int aux = v0;
            v0 = v1;
            v1 = aux;
        }
        if (v < v0) {
            v = v0;
        }
        if (v > v1) {
            v = v1;
        }
        return v;
    }

    public static int toValue(int v0, int v1, int inc) {
        if (v0 != v1) {
            if (v0 < v1) {
                if ((v0 += inc) > v1) {
                    v0 = v1;
                }
            } else if ((v0 -= inc) < v1) {
                v0 = v1;
            }
        }
        return v0;
    }

    public static int getRandom(int n) {
        return (rand.nextInt() & Integer.MAX_VALUE) % n;
    }

    public static int getRandom(int min, int max) {
        return min + (rand.nextInt() & Integer.MAX_VALUE) % (max - min + 1);
    }

    public static void loadStatus() {
        byte[][] rmsData = Kernel.loadRMS("PUZZMANIAC", 0);
        if (rmsData != null) {
            byte[] b = rmsData[0];
            byte aux = b[0];
            ctrlMode = (byte)(aux & 3);
            bSound = (aux & 4) != 0;
            bVibra = (aux & 8) != 0;
            lastLevel = b[1];
            App.topScoreNames[0] = new String(b, 2, 3);
            App.topScoreNames[1] = new String(b, 5, 3);
            App.topScoreNames[2] = new String(b, 8, 3);
            App.topScore[0] = Kernel.readInt(b, 11);
            App.topScore[1] = Kernel.readInt(b, 15);
            App.topScore[2] = Kernel.readInt(b, 19);
            HINT_flags = Kernel.readInt(b, 23);
        }
    }

    public static void saveStatus() {
        byte[] b = new byte[27];
        b[0] = ctrlMode;
        if (bSound) {
            b[0] = (byte)(b[0] | 4);
        }
        if (bVibra) {
            b[0] = (byte)(b[0] | 8);
        }
        b[1] = lastLevel;
        System.arraycopy(topScoreNames[0].getBytes(), 0, b, 2, 3);
        System.arraycopy(topScoreNames[1].getBytes(), 0, b, 5, 3);
        System.arraycopy(topScoreNames[2].getBytes(), 0, b, 8, 3);
        Kernel.writeInt(topScore[0], b, 11);
        Kernel.writeInt(topScore[1], b, 15);
        Kernel.writeInt(topScore[2], b, 19);
        Kernel.writeInt(HINT_flags, b, 23);
        Kernel.saveRMS("PUZZMANIAC", new byte[][]{b}, 0);
    }

    public void startApp() throws MIDletStateChangeException {
        if (Kernel.instance == null) {
            try {
                st = new short[450];
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/st");
                for (int i = 0; i < 450; ++i) {
                    App.st[i] = (short)((is.read() & 0xFF) << 8 | is.read() & 0xFF);
                }
                is.close();
                font = new BitmapFont("/fnt.f");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Kernel.createInstance(this);
            Kernel.instance.frameTicks = 50L;
            mainMenu = new MainMenu();
            game = new Game();
            texts = App.loadLines("/texts.txt", null, 0);
            App.loadStatus();
            Kernel.instance.setGameSection(mainMenu);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean b) throws MIDletStateChangeException {
        Kernel.instance.stop(false);
        try {
            if (Kernel.instance.thread.isAlive()) {
                Kernel.instance.thread.join();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] loadLines(String fileName, BitmapFont font, int width) {
        int i = 0;
        char[] line = new char[256];
        Vector<String> v = new Vector<String>();
        Object[] texts = null;
        int lineW = 0;
        int lastSpace = 0;
        boolean bUnicode = false;
        InputStream is = Kernel.instance.getClass().getResourceAsStream(fileName);
        if (is != null) {
            DataInputStream dis = new DataInputStream(is);
            char ch = ' ';
            try {
                int c = dis.readByte() & 0xFF;
                if (c == 254) {
                    dis.readByte();
                    bUnicode = true;
                    ch = dis.readChar();
                } else {
                    ch = (char)c;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                while (true) {
                    int chW;
                    boolean bRead = true;
                    line[i] = ch;
                    if (ch == ' ' || ch == '\n') {
                        lastSpace = i;
                    }
                    int n = chW = width != 0 ? font.getAdvance(ch) : 0;
                    if (ch == '\n' || lineW + chW > width) {
                        v.addElement(new String(line, 0, lastSpace));
                        if (width != 0 && lastSpace < i) {
                            lineW = 0;
                            ++lastSpace;
                            int j = 0;
                            while (lastSpace < i) {
                                line[j] = line[lastSpace];
                                lineW += font.getAdvance(line[j]);
                                ++j;
                                ++lastSpace;
                            }
                            i = j;
                        } else {
                            i = 0;
                            lineW = 0;
                        }
                        lastSpace = 0;
                        bRead = ch == '\n';
                    } else {
                        ++i;
                        lineW += chW;
                    }
                    if (!bRead) continue;
                    ch = bUnicode ? dis.readChar() : (char)(dis.readByte() & 0xFF);
                }
            }
            catch (EOFException e) {
                v.addElement(new String(line, 0, i));
                texts = new String[v.size()];
                v.copyInto(texts);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                dis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        v.removeAllElements();
        v = null;
        line = null;
        return texts;
    }

    public static void LINES_init(String[] lines, int width, int height) {
        LINES_y = Integer.MAX_VALUE;
        LINES_width = width;
        LINES_height = height;
        LINES_lines = lines;
        LINES_num = (short)lines.length;
        if (LINES_x == null || LINES_x.length < lines.length) {
            LINES_x = new short[LINES_num];
        }
        for (int i = 0; i < LINES_num; ++i) {
            App.LINES_x[i] = (short)(width - font.stringWidth(LINES_lines[i]) >> 1);
        }
    }

    public static void LINES_done() {
        if (LINES_num != 0) {
            for (int i = 0; i < LINES_num; ++i) {
                App.LINES_lines[i] = null;
            }
            LINES_lines = null;
            LINES_img2 = null;
            LINES_img = null;
            LINES_g2 = null;
            LINES_g = null;
            LINES_num = 0;
        }
    }

    public static void LINES_draw(Graphics g, int x, int y, int posY, int bgColor) {
        if (LINES_num != 0) {
            if (posY != LINES_y) {
                int y0;
                int y1;
                if (LINES_img == null) {
                    LINES_img = Image.createImage((int)LINES_width, (int)LINES_height);
                    LINES_g = LINES_img.getGraphics();
                    LINES_img2 = Image.createImage((int)LINES_width, (int)LINES_height);
                    LINES_g2 = LINES_img2.getGraphics();
                }
                int dif_scr = Math.min(Math.abs(LINES_y - posY), LINES_height);
                if (posY < LINES_y) {
                    y1 = -posY + LINES_height - 1;
                    y0 = y1 - dif_scr + 1;
                } else {
                    y0 = -posY;
                    y1 = y0 + dif_scr - 1;
                }
                int line0 = y0 / App.font.fontHeight;
                int line1 = y1 / App.font.fontHeight;
                line1 = App.limit(line1, 0, LINES_num - 1);
                LINES_g2.drawImage(LINES_img, 0, posY - LINES_y, 0);
                LINES_y = posY;
                LINES_g2.setColor(bgColor);
                LINES_g2.fillRect(0, y0 + posY, LINES_width, y1 - y0 + 1);
                posY += line0 * App.font.fontHeight;
                for (line0 = App.limit(line0, 0, LINES_num - 1); line0 <= line1; ++line0) {
                    font.drawString(LINES_g2, LINES_lines[line0], LINES_x[line0], posY, 0);
                    posY += App.font.fontHeight;
                }
                Image aux = LINES_img;
                LINES_img = LINES_img2;
                LINES_img2 = aux;
                Graphics auxg = LINES_g;
                LINES_g = LINES_g2;
                LINES_g2 = auxg;
            }
            g.drawImage(LINES_img, x, y, 0);
        }
    }

    public static void HINT_show(int hint) {
        if (!HINT_visible && (HINT_flags & 1 << hint) == 0) {
            System.gc();
            HINT_text = App.loadLines("/tut" + hint, font, 151);
            HINT_flags |= 1 << hint;
            Kernel.instance.pause(true);
            HINT_visible = true;
        }
    }

    public static void HINT_hide() {
        HINT_visible = false;
    }

    public static void HINT_draw(Graphics g) {
        if (HINT_visible) {
            int KW = 176;
            int KH = Kernel.instance.getHeight();
            int wH = HINT_text.length * App.font.fontHeight + 10;
            int y = KH - wH >> 1;
            g.setColor(0);
            g.fillRect(10, y, KW - 20, wH);
            g.setColor(0xFFFFFF);
            g.drawRect(10, y, KW - 20, wH);
            y += 5;
            for (int i = 0; i < HINT_text.length; ++i) {
                font.drawString(g, HINT_text[i], KW >> 1, y, 1);
                y += App.font.fontHeight;
            }
        } else if (HINT_text != null) {
            for (int i = 0; i < HINT_text.length; ++i) {
                App.HINT_text[i] = null;
            }
            HINT_text = null;
        }
    }

    static {
        rand = new Random(System.currentTimeMillis());
        music = null;
        idMusic = null;
        bLoading = false;
        LINES_num = 0;
        LINES_x = null;
        LINES_lines = null;
        LINES_img = null;
        LINES_g = null;
        LINES_img2 = null;
        LINES_g2 = null;
        HINT_visible = false;
        HINT_flags = 0;
        HINT_text = null;
    }
}

