/*
 * Decompiled with CFR 0.152.
 */
public final class Building {
    public Anim building_anim = null;
    public int x = -1;
    public int y = -1;
    public int building_type = -1;
    public int roof_start_x = 0;
    public int roof_end_x = 0;
    public int health = 100;
    public int max_health = 100;

    public void disp(int cam_x, int cam_y, int slx, int sly, Anim flags) {
        if (this.building_anim != null) {
            int new_x = this.x - cam_x;
            int new_y = this.y - cam_y;
            if (new_x < slx && new_x + this.building_anim.lx >= 0 && new_y < sly && new_y + this.building_anim.ly >= 0) {
                this.building_anim.disp(new_x, new_y, 0, 0);
                int xOffset = 18;
                int yOffset = 0;
                switch (Ingame.scheme) {
                    case '\u0001': {
                        xOffset = 22;
                        yOffset = -5;
                        break;
                    }
                    case '\u0002': {
                        xOffset = 26;
                        yOffset = -10;
                        break;
                    }
                    case '\u0003': {
                        xOffset = -6;
                        yOffset = 0;
                    }
                }
                switch (this.building_type) {
                    case 6: {
                        flags.disp(new_x + xOffset, new_y + yOffset, 2, 0);
                        break;
                    }
                    case 5: {
                        flags.disp(new_x + xOffset, new_y + yOffset, 1, 0);
                        break;
                    }
                    case 7: {
                        flags.disp(new_x + xOffset, new_y + yOffset, 3, 0);
                        break;
                    }
                    case 8: {
                        flags.disp(new_x + xOffset, new_y + yOffset, 4, 0);
                        break;
                    }
                    case 4: {
                        flags.disp(new_x + xOffset, new_y + yOffset, 0, 0);
                    }
                }
            }
        }
    }

    public void disp_health(Game game, int cam_x, int cam_y) {
        int new_x = this.x - cam_x;
        int new_y = this.y - cam_y - 15;
        if (this.building_anim != null && new_x < game.slx && new_x + this.building_anim.lx >= 0 && new_y < game.sly && new_y + this.building_anim.ly >= 0) {
            game.update_clip();
            game.graphics.setColor(0);
            game.graphics.fillRect(new_x, new_y, this.building_anim.lx + 2, 7);
            game.graphics.setColor(0xFF0000);
            game.graphics.drawRect(new_x, new_y, this.building_anim.lx + 2, 7);
            long green = 51200 * ((this.health << 8) / this.max_health) >> 16;
            game.graphics.setColor((int)(255L - green), (int)green, 0);
            game.graphics.fillRect(new_x + 1, new_y + 1, (this.building_anim.lx + 1 << 8) * ((this.health << 8) / this.max_health) >> 16, 6);
        }
    }

    public void add_building(int _x, int _y, Anim _anim, int _type) {
        if (this.building_anim == null) {
            this.x = _x;
            this.y = _y;
            this.building_anim = _anim;
            this.building_type = _type;
            switch (this.building_type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.roof_start_x = this.x + Ingame.BUILDING_ROOF_X_OFFSET[Ingame.scheme][this.building_type][0];
                    this.roof_end_x = this.x + this.building_anim.lx - Ingame.BUILDING_ROOF_X_OFFSET[Ingame.scheme][this.building_type][1];
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.roof_start_x = 0;
                    this.roof_end_x = 0;
                    this.health = 150;
                }
            }
            this.max_health = this.health;
        }
    }

    public boolean check_collision(int start_x, int end_x, boolean ignore_utility, boolean check_y, int start_y, int end_y) {
        if ((ignore_utility || this.building_type != 4 && this.building_type != 5 && this.building_type != 6 && this.building_type != 7 && this.building_type != 8) && this.building_anim != null) {
            if (end_x - start_x > this.building_anim.lx) {
                if (this.x >= start_x && this.x < end_x || this.x + this.building_anim.lx > start_x && this.x + this.building_anim.lx <= end_x) {
                    if (!check_y) {
                        return true;
                    }
                    if (end_y - start_y > this.building_anim.ly ? this.y >= start_y && this.y < end_y && this.y + this.building_anim.ly > start_y && this.y + this.building_anim.ly <= end_y : start_y >= this.y && start_y < this.y + this.building_anim.ly && end_y > this.y && end_y <= this.y + this.building_anim.ly) {
                        return true;
                    }
                }
            } else if (start_x >= this.x && start_x < this.x + this.building_anim.lx || end_x > this.x && end_x <= this.x + this.building_anim.lx) {
                if (!check_y) {
                    return true;
                }
                if (end_y - start_y > this.building_anim.ly ? this.y >= start_y && this.y < end_y && this.y + this.building_anim.ly > start_y && this.y + this.building_anim.ly <= end_y : start_y >= this.y && start_y < this.y + this.building_anim.ly && end_y > this.y && end_y <= this.y + this.building_anim.ly) {
                    return true;
                }
            }
        }
        return false;
    }

    public Building get_collided_building(int check_x, boolean ignore_utility) {
        if ((ignore_utility || this.building_type != 4 && this.building_type != 5 && this.building_type != 6 && this.building_type != 7 && this.building_type != 8) && this.building_anim != null && check_x >= this.x && check_x <= this.x + this.building_anim.lx) {
            return this;
        }
        return null;
    }

    public boolean check_distance(int check_x, int clx, int building_len) {
        int map_x = this.x / clx;
        if (this.building_anim != null) {
            if (check_x > map_x) {
                map_x += this.building_anim.lx / clx;
            } else {
                --map_x;
                check_x += building_len - 1;
            }
            if (check_x > map_x ? check_x - map_x >= 0 && check_x - map_x <= 4 : map_x - check_x >= 0 && map_x - check_x <= 4) {
                return true;
            }
        }
        return false;
    }

    public Building check_roof_collision(int check_x, int check_y) {
        if (this.building_anim != null && this.building_type <= 3 && check_y >= this.y + Ingame.BUILDING_ROOF_Y_OFFSET[Ingame.scheme][this.building_type] - 4 && check_y <= this.y + Ingame.BUILDING_ROOF_Y_OFFSET[Ingame.scheme][this.building_type] + 4 && this.building_type != 4 && this.building_type != 5 && this.building_type != 6 && this.building_type != 7 && this.building_type != 8 && check_x >= this.roof_start_x && check_x <= this.roof_end_x) {
            return this;
        }
        return null;
    }

    public void hit(int check_x, int check_y, int radius, int strength, Ingame ingame) {
        if (this.health > 0 && this.building_anim != null) {
            long new_x = 0L;
            long new_y = 0L;
            new_x = check_x >> 8 > this.x + this.building_anim.lx ? (long)(this.x + this.building_anim.lx) : (check_x >> 8 < this.x ? (long)this.x : (long)(check_x >> 8));
            new_y = check_y >> 8 > this.y + this.building_anim.ly ? (long)(this.y + this.building_anim.ly) : (check_y >> 8 < this.y ? (long)this.y : (long)(check_y >> 8));
            long result = ((new_x = (new_x << 8) - (long)check_x) * new_x >> 8) + ((new_y = (new_y << 8) - (long)check_y) * new_y >> 8);
            long new_radius = radius * radius << 8;
            if (result <= new_radius) {
                if ((result = (new_radius - result << 8) / new_radius) >= 230L) {
                    result = 256L;
                } else if (result < 38L) {
                    result = 38L;
                }
                this.health = (int)((long)this.health - (result * (long)(strength << 8) >> 16));
                if (this.health <= this.max_health / 100 * 20) {
                    this.health = 0;
                    ingame.game.hdl_sound(92);
                }
            }
        }
    }

    public void check_flood(Ingame ingame) {
        if (this.building_anim != null) {
            int lx = this.building_anim.lx / ingame.game.bkgnd_clx;
            int ly = this.building_anim.ly / ingame.game.bkgnd_cly;
            int map_x = this.x / ingame.game.bkgnd_clx;
            int map_y = this.y / ingame.game.bkgnd_cly;
            boolean flooded = false;
            block0: for (int r = 0; r < ly; ++r) {
                for (int c = 0; c < lx; ++c) {
                    if (ingame.game.getMapTile(map_x + c, map_y + r) != ingame.TILE_WATER_1) continue;
                    flooded = true;
                    continue block0;
                }
            }
            if (!flooded && ingame.game.getMapTile(map_x, map_y + ly) == ingame.TILE_WATER_1 && ingame.game.getMapTile(map_x + lx - 1, map_y + ly) == ingame.TILE_WATER_1) {
                flooded = true;
            }
            if (flooded) {
                this.health = 0;
                ingame.game.hdl_sound(92);
            }
        }
    }
}

