/*
 * Decompiled with CFR 0.152.
 */
public final class Worm {
    public static int SPEED_FP = 256;
    public static int SPEED = 1;
    public static int SPEED_FPVX = 768;
    public static int MAX_FPVY = 2048;
    private Ingame ingame;
    public Anim worm_anim;
    public int x;
    public int y;
    public int fpx;
    public int fpy;
    public int fpvx;
    public int fpvy;
    public char frame;
    public boolean dir;
    public boolean falling;
    public boolean on_building;
    private int building_roof_start_x;
    private int building_roof_end_x;
    public char building_type;
    public int health;
    public boolean respawn;

    public Worm(int _x, int _y, Anim _worm_anim, boolean _dir, Ingame ing) {
        this.ingame = ing;
        this.x = _x;
        this.y = _y;
        this.fpx = this.x << 8;
        this.fpy = this.y << 8;
        this.fpvx = 0;
        this.fpvy = 0;
        this.falling = false;
        this.on_building = false;
        this.respawn = false;
        this.building_roof_start_x = 0;
        this.building_roof_end_x = 0;
        this.building_type = '\u0000';
        this.health = 100;
        this.worm_anim = _worm_anim;
        this.dir = _dir;
    }

    public void set_anim(int anim) {
        if (this.worm_anim.res_index != this.ingame.worm_anim[anim].res_index) {
            this.frame = '\u0000';
            this.fpy += (this.worm_anim.ly << 8) - (this.ingame.worm_anim[anim].ly << 8) >> 1;
            this.y = this.fpy >> 8;
            this.worm_anim = this.ingame.worm_anim[anim];
        }
    }

    public void disp(int cam_x, int cam_y) {
        this.x = this.fpx >> 8;
        this.y = this.fpy >> 8;
        int new_x = this.x - cam_x;
        int new_y = this.y - cam_y;
        if (this.health > 0 && new_x - this.worm_anim.lx < this.ingame.game.slx && new_x + this.worm_anim.lx >= 0 && new_y - this.worm_anim.ly < this.ingame.game.sly && new_y + this.worm_anim.ly >= 0) {
            this.worm_anim.disp(new_x - (this.worm_anim.lx >> 1), new_y - (this.worm_anim.ly >> 1), this.frame, this.dir ? 1 : 0);
        }
    }

    public void disp_health(int cam_x, int cam_y, int back_col, int border_col) {
        this.x = this.fpx >> 8;
        this.y = this.fpy >> 8;
        int new_x = this.x - cam_x;
        int new_y = this.y - (this.worm_anim.ly >> 1) - 5 - (this.ingame.game.font_get_height(this.ingame.ingame_font) >> 1) - cam_y;
        if (this.health > 0 && new_x - this.worm_anim.lx < this.ingame.game.slx && new_x + this.worm_anim.lx >= 0 && new_y - this.worm_anim.ly < this.ingame.game.sly && new_y + this.worm_anim.ly >= 0 && this.health > 0) {
            this.ingame.game.draw_bordered_text("" + this.health, new_x, new_y, this.ingame.ingame_font, back_col, border_col, false);
        }
    }

    public void move(int mx, int my) {
        int map_y;
        int map_x;
        if (this.dir) {
            map_x = (this.x - (this.worm_anim.lx >> 2)) / this.ingame.game.bkgnd_clx;
            map_y = this.y / this.ingame.game.bkgnd_cly;
        } else {
            map_x = (this.x + (this.worm_anim.lx >> 2)) / this.ingame.game.bkgnd_clx;
            map_y = this.y / this.ingame.game.bkgnd_cly;
        }
        byte tile = this.ingame.game.getMapTile(map_x, map_y);
        if (!this.ingame.blocking_tile(tile)) {
            this.fpx += mx;
            this.fpy += my;
            this.x = this.fpx >> 8;
            this.y = this.fpy >> 8;
            this.apply_gravity(true);
        }
        this.frame = (char)(this.frame + '\u0001');
        if (this.frame > '\u0005') {
            this.frame = '\u0000';
        }
        if (this.x <= 0 || this.x >= this.ingame.game.bkgnd_slx || this.y >= this.ingame.game.bkgnd_sly) {
            this.health = 0;
            this.stop_fall();
            this.ingame.change_state('\u0012');
        }
        this.ingame.check_crate_collision();
    }

    public void apply_gravity(boolean adjust_location) {
        if (this.x <= 0 || this.x >= this.ingame.game.bkgnd_slx || this.y + (this.worm_anim.ly >> 1) >= this.ingame.game.bkgnd_sly) {
            this.health = 0;
            this.stop_fall();
            if (!this.ingame.fling_worms) {
                this.ingame.change_state('\u0001');
            }
            return;
        }
        if (this.ingame.collides_with_ground(this.x, this.y, this.worm_anim.ly >> 1) != 0) {
            int map_x = this.x / this.ingame.game.bkgnd_clx;
            int map_y = this.y / this.ingame.game.bkgnd_cly;
            if (map_x < 0 || map_x >= this.ingame.game.bkgnd_mlx || map_y < 0 || map_y >= this.ingame.game.bkgnd_mly) {
                this.health = 0;
                this.stop_fall();
                if (!this.ingame.fling_worms) {
                    this.ingame.change_state('\u0001');
                }
                return;
            }
            byte tile = this.ingame.game.getMapTile(map_x, map_y);
            if (this.ingame.empty_tile(tile)) {
                tile = this.ingame.game.getMapTile(map_x, ++map_y);
            }
            if (this.ingame.empty_tile(tile) || tile == this.ingame.TILE_WATER_1) {
                if (tile == this.ingame.TILE_WATER_1) {
                    this.fpvx = 0;
                } else if (this.fpvx == 0) {
                    this.fpvx = this.dir ? -128 : 128;
                }
                this.falling = true;
                this.on_building = false;
                this.check_roof_collision();
                if (!this.on_building) {
                    this.set_anim(1);
                }
                return;
            }
            this.ingame.find_intersect_point(this.fpx, this.fpy, this.fpx, this.fpy + (this.ingame.game.bkgnd_cly << 8), map_x * this.ingame.game.bkgnd_clx, map_y * this.ingame.game.bkgnd_cly);
            if (this.ingame.intersect_y - (this.fpy + (this.worm_anim.ly >> 1 << 8)) >= 762) {
                this.set_anim(1);
                this.falling = true;
                this.on_building = false;
                this.check_roof_collision();
                return;
            }
            this.on_building = false;
            this.check_roof_collision();
            if (adjust_location) {
                this.fpx = this.ingame.intersect_x;
                if (this.dir) {
                    this.fpx -= SPEED_FP;
                }
                this.fpy = this.ingame.intersect_y - (this.worm_anim.ly >> 1 << 8);
                this.x = this.fpx >> 8;
                this.y = this.fpy >> 8;
                if (!this.on_building) {
                    this.stop_fall();
                }
            }
        }
    }

    public void start_jump(boolean jump_dir) {
        this.fpvx = jump_dir ? (this.dir ? -SPEED_FPVX : SPEED_FPVX) : (this.dir ? SPEED_FPVX : -SPEED_FPVX);
        this.fpvy = -MAX_FPVY;
        this.fpx += this.fpvx;
        this.fpy += this.fpvy;
        this.x = this.fpx >> 8;
        this.y = this.fpy >> 8;
        this.fpvy += 256;
        this.set_anim(1);
        this.falling = true;
    }

    public void fall() {
        int map_x = 0;
        int map_y = 0;
        if (this.fpvx < 0) {
            map_x = (this.x - (this.worm_anim.lx >> 1)) / this.ingame.game.bkgnd_clx;
            map_y = this.y / this.ingame.game.bkgnd_cly;
        } else {
            map_x = (this.x + (this.worm_anim.lx >> 1)) / this.ingame.game.bkgnd_clx;
            map_y = this.y / this.ingame.game.bkgnd_cly;
        }
        if (map_x < 0 || map_x >= this.ingame.game.bkgnd_mlx || map_y < 0 || map_y >= this.ingame.game.bkgnd_mly) {
            this.stop_fall();
        } else {
            byte tile = this.ingame.game.getMapTile(map_x, map_y);
            if (this.ingame.blocking_tile(tile)) {
                this.fpvx *= -1;
            }
            this.fpx += this.fpvx;
            this.fpy += this.fpvy;
            this.x = this.fpx >> 8;
            this.y = this.fpy >> 8;
            this.fpvy += 256;
            if (this.frame < '\u0004') {
                this.frame = (char)(this.frame + '\u0001');
            }
            this.apply_gravity(true);
            this.ingame.check_crate_collision();
        }
    }

    private void stop_fall() {
        this.fpvx = 0;
        this.fpvy = 0;
        this.x = this.fpx >> 8;
        this.y = this.fpy >> 8;
        this.falling = false;
        this.on_building = false;
        this.set_anim(0);
        if (this.x > 0 || this.x < this.ingame.game.bkgnd_slx || this.y + (this.worm_anim.ly >> 1) < this.ingame.game.bkgnd_sly) {
            byte tile1 = this.ingame.game.getMapTile((this.x + (this.worm_anim.lx >> 1)) / this.ingame.game.bkgnd_clx, this.y / this.ingame.game.bkgnd_cly);
            byte tile2 = this.ingame.game.getMapTile((this.x - (this.worm_anim.lx >> 1)) / this.ingame.game.bkgnd_clx, this.y / this.ingame.game.bkgnd_cly);
            if (tile1 == this.ingame.TILE_WATER_1 || tile2 == this.ingame.TILE_WATER_1) {
                this.health = 0;
                if (!this.ingame.fling_worms) {
                    this.ingame.change_state('\u0001');
                }
            }
        }
    }

    public void check_roof_collision() {
        Building building = null;
        for (int b = 0; b < this.ingame.ai_building_list.length && (building = this.ingame.players_turn ? this.ingame.player_building_list[b].check_roof_collision(this.x, this.y + (this.worm_anim.ly >> 1)) : this.ingame.ai_building_list[b].check_roof_collision(this.x, this.y + (this.worm_anim.ly >> 1))) == null; ++b) {
        }
        if (building != null) {
            this.stop_fall();
            this.set_anim(0);
            this.on_building = true;
            this.building_roof_start_x = building.roof_start_x;
            this.building_roof_end_x = building.roof_end_x;
            this.building_type = (char)building.building_type;
            this.y = building.y - (this.worm_anim.ly >> 1) + Ingame.BUILDING_ROOF_Y_OFFSET[Ingame.scheme][this.building_type];
            this.fpy = this.y << 8;
        }
    }

    public void climb_building() {
        Building building = null;
        for (int b = 0; b < this.ingame.ai_building_list.length && (building = this.ingame.players_turn ? this.ingame.player_building_list[b].get_collided_building(this.x, false) : this.ingame.ai_building_list[b].get_collided_building(this.x, false)) == null; ++b) {
        }
        if (building != null) {
            this.stop_fall();
            this.set_anim(0);
            this.on_building = true;
            this.x = building.x + (building.building_anim.lx >> 1);
            this.building_roof_start_x = building.roof_start_x;
            this.building_roof_end_x = building.roof_end_x;
            this.building_type = (char)building.building_type;
            this.y = building.y - (this.worm_anim.ly >> 1) + Ingame.BUILDING_ROOF_Y_OFFSET[Ingame.scheme][this.building_type];
            this.fpx = this.x << 8;
            this.fpy = this.y << 8;
        } else {
            this.on_building = false;
        }
        building = null;
    }

    public void hit(int check_x, int check_y, int radius, int strength, boolean player_worm, Worm current_worm) {
        if (this.health > 0) {
            long new_x = 0L;
            long new_y = 0L;
            new_x = check_x >> 8 > this.x + (this.worm_anim.lx >> 1) ? (long)(this.x + (this.worm_anim.lx >> 1)) : (check_x >> 8 < this.x - (this.worm_anim.lx >> 1) ? (long)(this.x - (this.worm_anim.lx >> 1)) : (long)(check_x >> 8));
            new_y = check_y >> 8 > this.y + (this.worm_anim.ly >> 1) ? (long)(this.y + (this.worm_anim.ly >> 1)) : (check_y >> 8 < this.y - (this.worm_anim.ly >> 1) ? (long)(this.y - (this.worm_anim.ly >> 1)) : (long)(check_y >> 8));
            long result = ((new_x = (new_x << 8) - (long)check_x) * new_x >> 8) + ((new_y = (new_y << 8) - (long)check_y) * new_y >> 8);
            if (result <= (long)(radius = radius * radius << 8)) {
                if ((result = ((long)radius - result << 8) / (long)radius) >= 243L) {
                    result = 256L;
                } else if (result < 38L) {
                    result = 38L;
                }
                this.health = (int)((long)this.health - (result * (long)(strength << 8) >> 16));
                if (this.health < 0) {
                    this.health = 0;
                }
                this.fpvx = check_x > this.fpx ? (int)((long)(-SPEED_FPVX) * result) >> 8 : (int)((long)SPEED_FPVX * result) >> 8;
                this.fpvy = (int)((long)(-MAX_FPVY) * result) >> 8;
                this.falling = true;
                this.on_building = false;
                this.set_anim(1);
                if (this == current_worm) {
                    this.ingame.worm_stop_movement = true;
                }
            }
        }
        if (this.health <= 0) {
            this.respawn = false;
            for (int b = 0; b < this.ingame.player_building_list.length; ++b) {
                if (player_worm) {
                    if (this.ingame.player_building_list[b].building_type != 5) continue;
                    this.respawn = true;
                    break;
                }
                if (this.ingame.ai_building_list[b].building_type != 5) continue;
                this.respawn = true;
                break;
            }
        }
    }
}

