/*
 * Decompiled with CFR 0.152.
 */
public final class Ingame {
    public static final char SINGLEPLAYER = '\u0000';
    public static final char MULTIPLAYER = '\u0001';
    public static final char MAX_WORMS_PER_TEAM = '\u0004';
    public static final char MAX_CRATES = '\u0005';
    public static final char MAX_BUILDINGS = '\u0005';
    public static final int MESSAGE_BACK_COLOUR = 0;
    public static final int MESSAGE_BORDER_COLOUR = 0xDD0000;
    public static final int WORM_SELECTED_BORDER = 9242507;
    public static final int WORM_FOCUS_BORDER = 0xFD4DFF;
    public static final int WORM_PLAYER_BORDER = 56576;
    public static final int WORM_AI_BORDER = 0xDD0000;
    public static final char ROUND_TIME = '\u001e';
    public static char WONDER_TURNS = (char)3;
    public static final char STATE_INIT = '\u0000';
    public static final char STATE_CHECK_FOR_END_GAME = '\u0001';
    public static final char STATE_PLAYER_WON = '\u0002';
    public static final char STATE_AI_WON = '\u0003';
    public static final char STATE_END_GAME_AI_WON = '\u0004';
    public static final char STATE_END_GAME_PLAYER_WON = '\u0005';
    public static final char STATE_CHECK_SPECIAL = '\u0006';
    public static final char STATE_MESSAGE_WONDER = '\u0007';
    public static final char STATE_MESSAGE_CRATE = '\b';
    public static final char STATE_MESSAGE_PLAYERS_TURN = '\t';
    public static final char STATE_PLAYER_SELECT_WORM = '\n';
    public static final char STATE_PLAYER_MOVE_WORM = '\u000b';
    public static final char STATE_PLAYER_CHOOSE_BUILDING = '\f';
    public static final char STATE_PLAYER_PLACE_BUILDING = '\r';
    public static final char STATE_PLAYER_CHOOSE_WEAPON = '\u000e';
    public static final char STATE_PLAYER_CHOOSE_ANGLE = '\u000f';
    public static final char STATE_PLAYER_CHOOSE_POWER = '\u0010';
    public static final char STATE_PLAYER_WEAPON_FIRED = '\u0011';
    public static final char STATE_AI_SELECT_WORM = '\u0012';
    public static final char STATE_AI_MOVE_WORM = '\u0013';
    public static final char STATE_AI_CHOOSE_BUILDING = '\u0014';
    public static final char STATE_AI_PLACE_BUILDING = '\u0015';
    public static final char STATE_AI_CHOOSE_WEAPON = '\u0016';
    public static final char STATE_AI_CHOOSE_ANGLE = '\u0017';
    public static final char STATE_AI_CHOOSE_POWER = '\u0018';
    public static final char STATE_AI_WEAPON_FIRED = '\u0019';
    public static final char STATE_PLAYER_PICK_TARGET = '\u001b';
    public static final char STATE_AI_PICK_TARGET = '\u001c';
    public static final char STATE_CRATE_FALLING = '\u00fd';
    public static final char STATE_GAME_PAUSED = '\u00fe';
    public static final char STATE_NO_CHANGE = '\u00ff';
    public static final char SCHEME_ORIENTAL = '\u0000';
    public static final char SCHEME_EGYPTIAN = '\u0001';
    public static final char SCHEME_GRECOROMAN = '\u0002';
    public static final char SCHEME_MEDIEVAL = '\u0003';
    public static final char NUM_SCHEMES = '\u0004';
    public static final char NUM_LEVELS_PER_SCHEME = '\u0005';
    public static final char TILE_GROUND_1 = '\u0000';
    public byte TILE_GROUND_2 = 1;
    public byte TILE_SLOPE_FILLER_L = 1;
    public static final char TILE_SLOPE_UP = '\u0002';
    public static final char TILE_SLOPE_DOWN = '\u0003';
    public static final char TILE_SLOPE_FILLER_R = '\u0004';
    public static final char TILE_PEAK = '\u0005';
    public static final char TILE_FILLER = '\u0006';
    public byte TILE_EMPTY_1 = (byte)7;
    public byte TILE_WATER_1 = (byte)7;
    public static final char TILE_WALL_1 = '\b';
    public static final char TILE_WALL_2 = '\t';
    public static final char TILE_FOUNDATION_TOP = '\n';
    public static final char TILE_FOUNDATION_BOTTOM = '\u000b';
    public static final char CAMERA_TARGET_FREE = '\u0000';
    public static final char CAMERA_TARGET_WORM = '\u0001';
    public static final char CAMERA_TARGET_WEAPON = '\u0002';
    public static final char CAMERA_TARGET_BUILDING = '\u0003';
    public static final char CAMERA_TARGET_CRATE = '\u0004';
    public static final char WIND_SPEED = '\u0100';
    public static final char GRAVITY = '\u0100';
    public static final char MAX_VELOCITY_X = '\u2800';
    public static final char MAX_VELOCITY_Y = '\u0a00';
    public static final char CROSSHAIR_RADIUS = '\u2300';
    public static final char NUM_WEAPONS = '\u0018';
    public static final char ITEM_WEAPON_ROCKET_LAUNCHER = '\u0000';
    public static final char ITEM_WEAPON_MORTAR = '\u0001';
    public static final char ITEM_WEAPON_HOMING_PIGEON = '\u0002';
    public static final char ITEM_WEAPON_CLUSTER_LAUNCHER = '\u0003';
    public static final char ITEM_WEAPON_SMALL_CLUSTER = '\u0018';
    public static final char ITEM_WEAPON_GRENADE = '\u0004';
    public static final char ITEM_WEAPON_FRIDGE_LAUNCHER = '\u0005';
    public static final char ITEM_WEAPON_CHILLI_PEPPER = '\u0007';
    public static final char ITEM_WEAPON_BANANA_BOMB = '\b';
    public static final char ITEM_WEAPON_BANANA_BOMB_SMALL = '\u001e';
    public static final char ITEM_WEAPON_HOLY_HAND_GRENADE = '\t';
    public static final char ITEM_WEAPON_EARTHQUAKE = '\u000f';
    public static final char ITEM_WEAPON_FLOOD = '\u0010';
    public static final char ITEM_WEAPON_ARMAGEDDON = '\u0012';
    public static final char ITEM_WEAPON_MINIGUN = '\u0014';
    public static final char ITEM_WEAPON_GIANT_CROSSBOW = '\u0015';
    public static final char ITEM_WEAPON_TREBUCHET = '\u0016';
    public static final char ITEM_WEAPON_GIANT_LASER = '\u0017';
    public static final char WEAPON_STRENGTH = '\u0000';
    public static final char WEAPON_BOUNCE = '\u0001';
    public static final char WEAPON_WIND = '\u0002';
    public static final char WEAPON_GRAVITY = '\u0003';
    public static final char WEAPON_FUSE = '\u0004';
    public static final char WEAPON_MAX_POWER = '\u0005';
    public static final char WEAPON_WEAPON_ANIM = '\u0006';
    public static final char WEAPON_ANIM_ROCKET = '\u0000';
    public static final char WEAPON_ANIM_CLUSTER = '\u0001';
    public static final char WEAPON_ANIM_SMALL_CLUSTER = '\u0002';
    public static final char WEAPON_ANIM_GRENADE = '\u0003';
    public static final char WEAPON_ANIM_FRIDGE = '\u0004';
    public static final char WEAPON_ANIM_MORTAR = '\u0005';
    public static final char WEAPON_ANIM_CHILLI = '\u0006';
    public static final char WEAPON_ANIM_BANANA_BOMB = '\u0007';
    public static final char WEAPON_ANIM_BANANA_BOMB_SMALL = '\b';
    public static final char WEAPON_ANIM_BULLET = '\t';
    public static final char WEAPON_ANIM_ARMAGEDDON = '\n';
    public static final char WEAPON_ANIM_TREBUCHET = '\u000b';
    public static final char WEAPON_ANIM_CROSSBOW = '\f';
    public static final char WEAPON_ANIM_HOLY_HAND_GRENADE = '\r';
    public static final char WEAPON_ANIM_PIGEON = '\u000e';
    public static final char WEAPON_ANIM_NONE = 'b';
    public static final char WEAPON_WORM_ANIM = '\u0007';
    public static final char WORM_ANIM_WALK = '\u0000';
    public static final char WORM_ANIM_JUMP = '\u0001';
    public static final char WORM_ANIM_ROCKET_LAUNCHER = '\u0002';
    public static final char WORM_ANIM_LAUNCHER = '\u0003';
    public static final char WORM_ANIM_LASER = '\u0004';
    public static final char WEAPON_WEAPON_MULTIPLE_FRAMES = '\b';
    public static final char WEAPON_WORM_MULTIPLE_FRAMES = '\t';
    public static final char WEAPON_TYPE = '\n';
    public static final char WEAPON_TYPE_SPAWN = '\u0000';
    public static final char WEAPON_SPAWN_TYPE = '\f';
    public static final char WEAPON_SPAWN_NUMBER = '\r';
    public static final char WEAPON_TYPE_EXPLOSION = '\u0001';
    public static final char WEAPON_EXPLOSION_DIAMETER = '\u000b';
    public static final char WEAPON_TYPE_EFFECT = '\u0002';
    public static final char WEAPON_EFFECT_TYPE = '\u000b';
    public static final char EFFECT_ARMAGEDDON = '\u0000';
    public static final char EFFECT_EARTHQUAKE = '\u0001';
    public static final char EFFECT_FLOOD = '\u0002';
    public static final char WEAPON_TYPE_HOMING = '\u0003';
    public static final char WEAPON_TYPE_BULLET = '\u0004';
    public static final char WEAPON_TYPE_LASER = '\u0005';
    public static final char WEAPON_TYPE_PROJECTILE = '\u0006';
    public static final char[] WEAPON_CHANCE = new char[]{'\u0000', '\n', '\u0014', '\u0019', '\u001e', '(', '-', '<', 'K', 'P', 'U', 'W', 'Z', '_', '\u0000', 'd'};
    public static final char[][] WEAPON_PROFILES = new char[][]{{'2', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0002', '\u0001', '\u0001', '\u0001', '2'}, {'2', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001', '\u0005', '\u0002', '\u0001', '\u0001', '\u0001', '2'}, {'2', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u000e', '\u0002', '\u0001', '\u0001', '\u0003', '2'}, {'\u0014', '\u0001', '\u0000', '\u0001', '\u0005', '\u0000', '\u0001', '\u0003', '\u0001', '\u0000', '\u0000', '\u0014', '\u0018', '\u0003'}, {'2', '\u0001', '\u0000', '\u0001', '\u0005', '\u0000', '\u0003', '\u0003', '\u0001', '\u0000', '\u0001', '('}, {'2', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0004', '\u0003', '\u0001', '\u0000', '\u0001', '2'}, {'2', '\u0001', '\u0000', '\u0001', '\u0005', '\u0000', '\u0006', '\u0003', '\u0001', '\u0000', '\u0001', '<'}, {'\u001e', '\u0001', '\u0000', '\u0001', '\u0005', '\u0000', '\u0007', '\u0003', '\u0001', '\u0000', '\u0000', '\u001e', '\u001e', '\u0005'}, {'F', '\u0001', '\u0000', '\u0001', '\u0005', '\u0000', '\r', '\u0003', '\u0001', '\u0000', '\u0001', 'Z'}, {'2', '\u0000', '\u0000', '\u0000', '\u0005', '\u0001', 'b', '\u0000', '\u0000', '\u0000', '\u0002', '\u0001'}, {'2', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', 'b', '\u0000', '\u0000', '\u0000', '\u0002', '\u0002'}, {'c', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', '\n', '\u0000', '\u0000', '\u0000', '\u0002', '\u0000'}, {'\u0005', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\t', '\u0002', '\u0000', '\u0001', '\u0004', '\u0005'}, {'(', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\f', '\u0003', '\u0001', '\u0000', '\u0006', '\u0010'}, {'\u0019', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u000b', '\u0003', '\u0001', '\u0000', '\u0006', '\u0010'}, {'\u0005', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', 'b', '\u0004', '\u0000', '\u0000', '\u0005', '\u0005'}, {'\u001e', '\u0001', '\u0000', '\u0001', '\u0003', '\u0000', '\u0002', '\u0000', '\u0001', '\u0000', '\u0001', '\u0019'}, {'(', '\u0001', '\u0000', '\u0001', '\u0005', '\u0000', '\b', '\u0000', '\u0001', '\u0000', '\u0001', '('}};
    public static final char NUM_BUILDINGS = '\n';
    public static final char ITEM_BUILDING_TOWER = '\u0000';
    public static final char ITEM_BUILDING_KEEP = '\u0001';
    public static final char ITEM_BUILDING_CASTLE = '\u0002';
    public static final char ITEM_BUILDING_CITADEL = '\u0003';
    public static final char ITEM_BUILDING_STRONGHOLD = '\u0004';
    public static final char ITEM_BUILDING_HOSPITAL = '\u0005';
    public static final char ITEM_BUILDING_WEAPONS = '\u0006';
    public static final char ITEM_BUILDING_SCIENCE = '\u0007';
    public static final char ITEM_BUILDING_WONDER = '\b';
    public static final char ITEM_BUILDING_FOUNDATION = '\t';
    public static final char FOUNDATION_2x2 = '\u0000';
    public static final char FOUNDATION_3x2 = '\u0001';
    public static final char FOUNDATION_4x3 = '\u0002';
    public static final char[][][] BUILDING_ROOF_X_OFFSET = new char[][][]{new char[][]{{'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\f', '\f'}, {'\u0014', '\u0014'}}, new char[][]{{'\u0003', '\u0003'}, {'\u0000', '\u0000'}, {'\u0013', '\u0013'}, {'\u0004', '\u0004'}}, new char[][]{{'\u0000', '\u0000'}, {'\u0007', '\u0007'}, {'\u000f', '\u0010'}, {'\u0017', '\u0017'}}, new char[][]{{'\u0000', '\u0000'}, {'\u0000', '\u0002'}, {'\u0001', '\u0012'}, {'\b', '\u001a'}}};
    public static final char[][] BUILDING_ROOF_Y_OFFSET = new char[][]{{'\u0001', '\u0002', '\f', '\u0001'}, {'\u0001', '\u0000', '\u0005', '\t'}, {'\b', '\u0000', '\u0010', '\u0000'}, {'\u0000', '\u0002', '\n', '\u0000'}};
    public static final char EXTRA_TILESET = '\u0000';
    public static final char EXTRA_MAP_WIDTH = '\u0001';
    public static final char EXTRA_MAP_HEIGHT = '\u0002';
    public static final char EXTRA_RED_STEP = '\u0003';
    public static final char EXTRA_GREEN_STEP = '\u0004';
    public static final char EXTRA_BLUE_STEP = '\u0005';
    public static final char EXTRA_TILE_WATER = '\u0006';
    public static final char EXTRA_TILE_EMPTY = '\u0007';
    public static final char EXTRA_TILE_GROUND_2 = '\b';
    public static final char EXTRA_TILE_SLOPE_FILLER_L = '\t';
    public static final char EXTRA_BUILDING_START = '\n';
    public static final char EXTRA_WEAPON_START = '\u0014';
    public static final char EXTRA_MAP_DATA_START = ',';
    public static final int TIMER_X_PADDING = 4;
    public Game game;
    private char game_type;
    public char game_state = '\u0000';
    public boolean players_turn;
    private boolean banner_on;
    public char state_tick;
    private String player_name;
    private String ai_name;
    private String message;
    private StringBuffer message_buffer;
    private int player_wonder_turns;
    private int ai_wonder_turns;
    private boolean second_turn;
    private char map_height;
    private char map_width;
    private char red_step;
    private char green_step;
    private char blue_step;
    public static char scheme;
    public int ingame_font;
    private char turn_timer_tick;
    private char turn_timer;
    String sk_select;
    String sk_back;
    String sk_resume;
    String sk_quit;
    String sk_ok;
    String sk_pause;
    String message_crate;
    String message_wonder;
    String[] message_player_turn;
    String message_game_paused;
    String message_quit_question;
    String message_game_won;
    String message_game_over;
    String message_win_wonder;
    String message_win_no_buildings;
    String message_win_no_worms;
    String message_select_worm;
    int[] building_names;
    int[] weapon_names;
    private Anim crate;
    private int[] player_crate_fpx = new int[5];
    private int[] player_crate_fpy = new int[5];
    private boolean[] player_crate_active = new boolean[5];
    private int[] ai_crate_fpx = new int[5];
    private int[] ai_crate_fpy = new int[5];
    private boolean[] ai_crate_active = new boolean[5];
    private int crate_fpvy;
    private int crate_falling;
    private Anim wind_hud;
    private int wind_value;
    private boolean calculate_wind;
    private Anim crosshair;
    private int crosshair_y;
    private int ai_crosshair_y;
    private int crosshair_x;
    private int weapon_power;
    private int[] weapon_fpx;
    private int[] weapon_fpy;
    private int[] weapon_fpvx;
    private int[] weapon_fpvy;
    private boolean[] weapon_stopped;
    private boolean weapon_stop_fuse;
    private Anim[] weapon_anim;
    private char[][] current_weapon;
    private int[][] explosion_radius;
    private int[] explosion_x_offset;
    private int[] explosion_y_offset;
    private int[] smoke_x_offset;
    private int[] smoke_y_offset;
    private int[][] explosion_increment;
    private boolean fire_pressed;
    private char[] weapon_frame;
    private char weapon_fuse;
    public boolean fling_worms;
    private boolean explosion_sound_played;
    private int homing_map_x;
    private int homing_map_y;
    long ai_distance;
    int ai_weapon_power;
    private int num_bullets;
    public Building[] player_building_list;
    public Building[] ai_building_list;
    private Anim building;
    private char building_type;
    private int building_map_x;
    private int building_map_y;
    private boolean building_ok;
    private boolean ai_building_ok;
    private int ai_building_move;
    private char ai_move_count;
    public boolean player_stronghold_placed;
    public boolean ai_stronghold_placed;
    public char foundation_state;
    public int foundation_y_offset;
    public Anim building_tower;
    public Anim building_keep;
    public Anim building_citadel;
    public Anim building_special;
    public Anim building_special_flags;
    public Anim tick_cross;
    public Anim building_anim_zoomed;
    private int camera_x;
    private int camera_y;
    private int camera_fpx;
    private int camera_fpy;
    private int camera_fpvx;
    private int camera_fpvy;
    private char camera_target_type;
    public char target_worm;
    public Worm[] player_worm = new Worm[4];
    public Worm[] ai_worm = new Worm[4];
    public Worm current_worm;
    public Anim[] worm_anim;
    public boolean worm_stop_movement;
    public boolean player_worms_plagued;
    public boolean ai_worms_plagued;
    public boolean ai_worm_building;
    private IngameMenu player_building_menu;
    private IngameMenu player_weapon_menu;
    private IngameMenu ai_building_menu;
    private IngameMenu ai_weapon_menu;
    private int menu_selection;
    private char old_building = '\u0000';
    public int intersect_x = 0;
    public int intersect_y = 0;
    char prev_state;

    public Ingame(char type, char _scheme, Game _game, int level, boolean first_player) {
        this.game = _game;
        this.game_type = type;
        scheme = _scheme;
        this.ingame_font = -1;
        this.banner_on = true;
        this.init_game(level, first_player);
        this.sk_select = this.game.res_get_string(159807);
        this.sk_back = this.game.res_get_string(151615);
        this.sk_resume = this.game.res_get_string(733247);
        this.sk_quit = this.game.res_get_string(53311);
        this.sk_ok = this.game.res_get_string(741439);
        this.sk_pause = this.game.res_get_string(716863);
        this.message_wonder = this.game.res_get_string(536639);
        this.message_wonder = this.message_wonder.replace('%', ("" + WONDER_TURNS).charAt(0));
        this.message_crate = this.game.res_get_string(700479);
        this.message_player_turn = new String[4];
        this.message_player_turn[0] = this.game.res_get_string(569407);
        this.message_player_turn[1] = this.game.res_get_string(577599);
        this.message_player_turn[2] = this.game.res_get_string(585791);
        this.message_player_turn[3] = this.game.res_get_string(593983);
        this.message_game_paused = this.game.res_get_string(725055);
        this.message_quit_question = this.game.res_get_string(217151);
        this.message_game_won = this.game.res_get_string(553023);
        this.message_game_over = this.game.res_get_string(561215);
        this.message_win_wonder = this.game.res_get_string(544831);
        this.message_win_no_buildings = this.game.res_get_string(528447);
        this.message_win_no_worms = this.game.res_get_string(520255);
        this.message_select_worm = this.game.res_get_string(913471);
        this.game.reset_keys();
    }

    public void init_game(int level, boolean first_player) {
        this.init_level(scheme, level, first_player);
        this.second_turn = true;
        this.change_state('\u0001');
        this.turn_timer = (char)30;
    }

    public void close() {
        int a;
        if (this.camera_target_type == '\u0000') {
            this.switch_view();
        }
        if (this.player_weapon_menu != null) {
            this.player_weapon_menu.close();
            this.player_weapon_menu = null;
        }
        if (this.player_building_menu != null) {
            this.player_building_menu.close();
            this.player_building_menu = null;
        }
        if (this.ai_building_menu != null) {
            this.ai_weapon_menu.close();
            this.ai_weapon_menu = null;
        }
        if (this.ai_weapon_menu != null) {
            this.ai_building_menu.close();
            this.ai_building_menu = null;
        }
        this.player_building_list = null;
        this.ai_building_list = null;
        this.player_crate_fpx = null;
        this.player_crate_fpy = null;
        this.player_crate_active = null;
        this.ai_crate_fpx = null;
        this.ai_crate_fpy = null;
        this.ai_crate_active = null;
        for (a = 0; a < this.worm_anim.length; ++a) {
            this.worm_anim[a] = this.game.res_free_anim(this.worm_anim[a]);
        }
        this.worm_anim = null;
        this.player_worm = null;
        this.ai_worm = null;
        for (a = 0; a < this.weapon_anim.length; ++a) {
            this.weapon_anim[a] = this.game.res_free_anim(this.weapon_anim[a]);
        }
        this.weapon_anim = null;
        this.weapon_fpx = null;
        this.weapon_fpy = null;
        this.weapon_fpvx = null;
        this.weapon_fpvy = null;
        this.weapon_stopped = null;
        this.current_weapon = null;
        this.explosion_radius = null;
        this.explosion_x_offset = null;
        this.explosion_y_offset = null;
        this.smoke_x_offset = null;
        this.smoke_y_offset = null;
        this.explosion_increment = null;
        this.weapon_frame = null;
        this.game.bkgnd_close();
        this.game.res_free_all_anims();
        for (int i = 0; i < 5; ++i) {
            this.game.sound_stop(88 + i);
        }
        System.gc();
    }

    public void init_level(int scheme, int level, boolean first_player) {
        this.player_name = this.game.res_get_string(495679);
        this.ai_name = this.game_type == '\u0000' ? this.game.res_get_string(512063) : this.game.res_get_string(503871);
        byte[] menu_data = this.game.bkgnd_init(68 + scheme * 5 + level, 59 + scheme);
        this.message = null;
        this.message_buffer = null;
        this.map_height = (char)menu_data[2];
        this.map_width = (char)menu_data[1];
        this.red_step = (char)((menu_data[3] & 0xFF) / this.map_height);
        this.green_step = (char)((menu_data[4] & 0xFF) / this.map_height);
        this.blue_step = (char)((menu_data[5] & 0xFF) / this.map_height);
        this.TILE_WATER_1 = menu_data[6];
        this.TILE_EMPTY_1 = menu_data[7];
        this.game.WATER_TILE = this.TILE_WATER_1;
        this.game.EMPTY_TILE = this.TILE_EMPTY_1;
        this.TILE_GROUND_2 = menu_data[8];
        this.TILE_SLOPE_FILLER_L = menu_data[9];
        this.state_tick = '\u0000';
        this.game.reset_keys();
        this.init_weapon();
        this.init_camera();
        this.init_worms(first_player);
        this.init_wind();
        this.init_buildings(scheme);
        this.init_menus(scheme, level, menu_data);
        this.init_crates();
    }

    private void init_weapon() {
        this.crosshair = this.game.res_get_anim(5);
        this.crosshair_y = 0;
        this.crosshair_x = 35;
        this.current_weapon = new char[1][WEAPON_PROFILES[0].length];
        this.current_weapon[0] = WEAPON_PROFILES[0];
        this.fire_pressed = false;
        this.weapon_fpx = new int[1];
        this.weapon_fpy = new int[1];
        this.weapon_fpvx = new int[1];
        this.weapon_fpvy = new int[1];
        this.explosion_radius = new int[1][1];
        this.explosion_increment = new int[1][1];
        this.explosion_x_offset = new int[1];
        this.explosion_y_offset = new int[1];
        this.smoke_x_offset = new int[1];
        this.smoke_y_offset = new int[1];
        this.weapon_frame = new char[1];
        this.weapon_stopped = new boolean[1];
        this.weapon_stop_fuse = false;
        this.weapon_fuse = '\u0000';
        this.fling_worms = false;
        this.explosion_sound_played = false;
        this.num_bullets = 0;
        this.weapon_anim = new Anim[17];
        this.weapon_anim[0] = this.game.res_get_anim(12);
        this.weapon_anim[1] = this.game.res_get_anim(13);
        this.weapon_anim[2] = this.game.res_get_anim(14);
        this.weapon_anim[3] = this.game.res_get_anim(15);
        this.weapon_anim[4] = this.game.res_get_anim(16);
        this.weapon_anim[5] = this.game.res_get_anim(17);
        this.weapon_anim[6] = this.game.res_get_anim(18);
        this.weapon_anim[7] = this.game.res_get_anim(19);
        this.weapon_anim[13] = this.game.res_get_anim(21);
        this.weapon_anim[14] = this.game.res_get_anim(22);
        this.weapon_anim[9] = this.game.res_get_anim(14);
        this.weapon_anim[10] = this.weapon_anim[9];
        this.weapon_anim[11] = this.game.res_get_anim(23);
        this.weapon_anim[12] = this.game.res_get_anim(24);
        this.weapon_anim[8] = this.game.res_get_anim(20);
        this.weapon_names = new int[16];
        this.weapon_names[this.game.convertWeaponItem((int)0)] = 389183;
        this.weapon_names[this.game.convertWeaponItem((int)1)] = 282687;
        this.weapon_names[this.game.convertWeaponItem((int)2)] = 356415;
        this.weapon_names[this.game.convertWeaponItem((int)3)] = 290879;
        this.weapon_names[this.game.convertWeaponItem((int)4)] = 315455;
        this.weapon_names[this.game.convertWeaponItem((int)5)] = 364607;
        this.weapon_names[this.game.convertWeaponItem((int)7)] = 323647;
        this.weapon_names[this.game.convertWeaponItem((int)8)] = 299071;
        this.weapon_names[this.game.convertWeaponItem((int)9)] = 331839;
        this.weapon_names[this.game.convertWeaponItem((int)15)] = 307263;
        this.weapon_names[this.game.convertWeaponItem((int)16)] = 340031;
        this.weapon_names[this.game.convertWeaponItem((int)18)] = 405567;
        this.weapon_names[this.game.convertWeaponItem((int)20)] = 348223;
        this.weapon_names[this.game.convertWeaponItem((int)21)] = 380991;
        this.weapon_names[this.game.convertWeaponItem((int)22)] = 397375;
        this.weapon_names[this.game.convertWeaponItem((int)23)] = 413759;
    }

    private void init_buildings(int scheme) {
        this.building = null;
        this.building_map_x = 0;
        this.building_map_y = 0;
        this.building_ok = false;
        this.ai_building_ok = false;
        this.ai_building_move = 0;
        this.ai_move_count = '\u0000';
        this.building_type = '\u0000';
        this.player_building_list = new Building[5];
        this.ai_building_list = new Building[5];
        for (int b = 0; b < this.player_building_list.length; ++b) {
            this.player_building_list[b] = new Building();
            this.ai_building_list[b] = new Building();
        }
        this.player_stronghold_placed = false;
        this.ai_stronghold_placed = false;
        this.player_wonder_turns = -1;
        this.player_wonder_turns = -1;
        this.building_names = new int[10];
        this.building_names[0] = 421951;
        this.building_names[1] = 430143;
        this.building_names[2] = 438335;
        this.building_names[3] = 446527;
        this.building_names[4] = 454719;
        this.building_names[6] = 462911;
        this.building_names[7] = 471103;
        this.building_names[5] = 479295;
        this.building_names[8] = 487487;
        this.building_names[9] = 897087;
        this.building_special = this.game.res_get_anim(53 + scheme);
        this.building_tower = this.game.res_get_anim(41 + scheme);
        this.building_keep = this.game.res_get_anim(45 + scheme);
        this.building_citadel = this.game.res_get_anim(49 + scheme);
        this.tick_cross = this.game.res_get_anim(58);
        this.building_special_flags = this.game.res_get_anim(57);
    }

    private void init_wind() {
        this.wind_value = 0;
        if (this.game.wind_on) {
            this.wind_hud = this.game.res_get_anim(4);
            this.calculate_wind = true;
        }
    }

    private void init_menus(int scheme, int level, byte[] menu_data) {
        int d;
        this.player_weapon_menu = new IngameMenu(this, true);
        this.player_building_menu = new IngameMenu(this, false);
        this.ai_weapon_menu = new IngameMenu(this, true);
        this.ai_building_menu = new IngameMenu(this, false);
        for (d = 20; d < 44; ++d) {
            this.player_weapon_menu.add_item(d - 20, menu_data[d]);
            this.ai_weapon_menu.add_item(d - 20, menu_data[d]);
        }
        for (d = 10; d < 20; ++d) {
            this.player_building_menu.add_item(d - 10, menu_data[d]);
            this.ai_building_menu.add_item(d - 10, menu_data[d]);
            if (menu_data[d] != 0) continue;
            this.player_building_menu.remove_weapons(d - 10);
            this.ai_building_menu.remove_weapons(d - 10);
        }
        this.menu_selection = -1;
    }

    private void init_crates() {
        this.crate = this.game.res_get_anim(6);
        this.crate_falling = -1;
        this.crate_fpvy = 0;
        for (int x = 0; x < this.player_crate_active.length; ++x) {
            this.player_crate_fpx[x] = 0;
            this.player_crate_fpy[x] = 0;
            this.player_crate_active[x] = false;
            this.ai_crate_fpx[x] = 0;
            this.ai_crate_fpy[x] = 0;
            this.ai_crate_active[x] = false;
        }
    }

    public void init_camera() {
        this.camera_x = this.game.bkgnd_slx / 2;
        this.camera_y = this.game.bkgnd_sly / 2;
        this.camera_fpx = this.camera_x << 8;
        this.camera_fpy = this.camera_y << 8;
        this.camera_fpvx = 0;
        this.camera_fpvy = 0;
        this.camera_target_type = '\u0001';
    }

    public void init_worms(boolean first_player) {
        int offset;
        int w;
        this.worm_stop_movement = false;
        this.player_worms_plagued = false;
        this.ai_worms_plagued = false;
        this.worm_anim = new Anim[5];
        this.worm_anim[0] = this.game.res_get_anim(7);
        this.worm_anim[1] = this.game.res_get_anim(8);
        this.worm_anim[2] = this.game.res_get_anim(10);
        this.worm_anim[3] = this.game.res_get_anim(11);
        this.worm_anim[4] = this.game.res_get_anim(9);
        this.target_worm = '\u0000';
        this.players_turn = !first_player;
        int x = 0;
        int y = 0;
        for (w = 0; w < 4; ++w) {
            while (!this.empty_tile(this.game.getMapTile(x, y))) {
                if (++y < this.game.bkgnd_mly) continue;
                y = 0;
                ++x;
            }
            while (!this.worm_tile(this.game.getMapTile(x, y))) {
                if (++y < this.game.bkgnd_mly) continue;
                y = 0;
                ++x;
            }
            offset = 0;
            if (this.game.getMapTile(x, y) == 2 || this.game.getMapTile(x, y) == 3 || this.game.getMapTile(x, y) == 5) {
                offset = this.game.bkgnd_cly >> 1;
            }
            this.player_worm[w] = new Worm(x * this.game.bkgnd_clx + (this.game.bkgnd_clx >> 1), y * this.game.bkgnd_cly - (this.worm_anim[0].ly >> 1) + offset, this.worm_anim[0], false, this);
        }
        x = this.game.bkgnd_mlx - 1;
        y = this.game.bkgnd_mly - 1;
        for (w = 0; w < 4; ++w) {
            while (!this.empty_tile(this.game.getMapTile(x, y))) {
                if (--y >= 0) continue;
                y = this.game.bkgnd_mly - 1;
                --x;
            }
            while (!this.worm_tile(this.game.getMapTile(x, y))) {
                if (++y < this.game.bkgnd_mly) continue;
                y = 0;
                ++x;
            }
            offset = 0;
            if (this.game.getMapTile(x, y) == 2 || this.game.getMapTile(x, y) == 3 || this.game.getMapTile(x, y) == 5) {
                offset = this.game.bkgnd_cly >> 1;
            }
            this.ai_worm[w] = new Worm(x * this.game.bkgnd_clx + (this.game.bkgnd_clx >> 1), y * this.game.bkgnd_cly - (this.worm_anim[0].ly >> 1) + offset, this.worm_anim[0], true, this);
            --x;
            y = this.game.bkgnd_mly - 1;
        }
    }

    private void setup_weapon(int weapon, int number, boolean spawn) {
        weapon = this.game.convertWeaponItem(weapon);
        char[] old_weapon = null;
        int old_fpx = 0;
        int old_fpy = 0;
        if (spawn) {
            if (this.current_weapon != null) {
                old_weapon = this.current_weapon[0];
                old_fpx = this.weapon_fpx[0];
                old_fpy = this.weapon_fpy[0];
            }
            ++number;
        }
        if (number < 0) {
            number = 1;
        }
        if (weapon < 0 || weapon >= WEAPON_PROFILES.length) {
            weapon = 0;
        }
        this.current_weapon = new char[number][];
        this.weapon_fpx = new int[number];
        this.weapon_fpy = new int[number];
        this.weapon_fpvx = new int[number];
        this.weapon_fpvy = new int[number];
        this.weapon_frame = new char[number];
        this.weapon_stopped = new boolean[number];
        int num_extra_explosions = 6 / number;
        if (num_extra_explosions < 1) {
            num_extra_explosions = 1;
        }
        this.explosion_radius = new int[number][num_extra_explosions];
        this.explosion_x_offset = new int[num_extra_explosions];
        this.explosion_y_offset = new int[num_extra_explosions];
        this.explosion_increment = new int[number][num_extra_explosions];
        this.smoke_x_offset = new int[num_extra_explosions];
        this.smoke_y_offset = new int[num_extra_explosions];
        boolean new_weapon = false;
        for (int w = 0; w < this.current_weapon.length; ++w) {
            if (!spawn || spawn && w != this.current_weapon.length - 1) {
                this.current_weapon[w] = WEAPON_PROFILES[weapon];
                this.setup_fancy_explosion(w, 0, 0);
            } else {
                this.current_weapon[w] = old_weapon;
                this.setup_fancy_explosion(w, 5, 2);
            }
            for (int e = 0; e < this.explosion_increment[w].length; ++e) {
                if (e == 0) {
                    this.explosion_increment[w][e] = this.current_weapon[w][11] / 10;
                    if (this.explosion_increment[w][e] >= 5) continue;
                    this.explosion_increment[w][e] = 5;
                    continue;
                }
                this.explosion_increment[w][e] = this.current_weapon[w][11] / 10 >> 1;
                if (this.explosion_increment[w][e] >= 2) continue;
                this.explosion_increment[w][e] = 2;
            }
            this.weapon_frame[w] = '\u0000';
            this.weapon_stopped[w] = false;
            if (spawn) {
                this.weapon_fpx[w] = old_fpx;
                this.weapon_fpy[w] = old_fpy;
                if (w != this.current_weapon.length - 1) {
                    if (this.current_weapon[w][6] == '\b') {
                        this.weapon_fpvx[w] = this.game.random.nextInt() % 2560;
                        this.weapon_fpvy[w] = this.game.random.nextInt() % 3920;
                    } else {
                        this.weapon_fpvx[w] = this.game.random.nextInt() % 1280;
                        this.weapon_fpvy[w] = this.game.random.nextInt() % 1960;
                    }
                    if (this.weapon_fpvy[w] <= 0) continue;
                    int n = w;
                    this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                    continue;
                }
                this.weapon_fpvx[w] = 0;
                this.weapon_fpvy[w] = 0;
                continue;
            }
            this.weapon_fpx[w] = 0;
            this.weapon_fpy[w] = 0;
            this.weapon_fpvx[w] = 0;
            this.weapon_fpvy[w] = 0;
        }
        this.weapon_stop_fuse = false;
        this.fling_worms = false;
        this.state_tick = '\u0000';
        this.weapon_fuse = '\u0000';
        this.current_worm.set_anim(this.current_weapon[0][7]);
    }

    private void setup_fancy_explosion(int w, int r1, int r2) {
        for (int e = 0; e < this.explosion_radius[w].length; ++e) {
            this.explosion_radius[w][e] = e == 0 ? r1 : r2;
        }
        int random_value = 0;
        for (int a = 1; a < this.explosion_x_offset.length; ++a) {
            if (this.current_weapon[w][10] != '\u0002') {
                this.explosion_x_offset[a] = random_value = this.game.random.nextInt() % (this.current_weapon[w][11] >> 2);
                this.explosion_y_offset[a] = random_value = this.game.random.nextInt() % (this.current_weapon[w][11] >> 2);
                this.smoke_x_offset[a] = random_value = this.game.random.nextInt() % (this.current_weapon[w][11] >> 2);
                this.smoke_y_offset[a] = random_value = this.game.random.nextInt() % (this.current_weapon[w][11] >> 2);
                continue;
            }
            this.explosion_x_offset[a] = 0;
            this.explosion_y_offset[a] = 0;
            this.smoke_x_offset[a] = 0;
            this.smoke_y_offset[a] = 0;
        }
        this.explosion_x_offset[0] = 0;
        this.explosion_y_offset[0] = 0;
        this.explosion_x_offset[this.explosion_y_offset.length - 1] = 0;
        this.explosion_y_offset[this.explosion_y_offset.length - 1] = 0;
    }

    private void spawn_weapon() {
        this.state_tick = '\u0000';
        if (this.current_weapon != null) {
            int num_iterations = 0;
            byte tile = 0;
            for (int w = 0; w < this.current_weapon.length; ++w) {
                if (this.current_weapon[0][10] == '\u0002') {
                    this.weapon_fpx[w] = this.current_worm.fpx;
                    this.weapon_fpy[w] = this.current_worm.fpy;
                } else if (this.current_weapon[w][10] != '\u0005') {
                    this.weapon_fpx[w] = this.current_worm.fpx;
                    this.weapon_fpy[w] = this.current_worm.fpy;
                    tile = this.game.getMapTile((this.weapon_fpx[w] >> 8) / this.game.bkgnd_clx, (this.weapon_fpy[w] >> 8) / this.game.bkgnd_cly);
                    for (num_iterations = this.current_worm.dir ? this.num_iterations(-(this.crosshair_x << 8), -this.crosshair_y, 4) : this.num_iterations(this.crosshair_x << 8, -this.crosshair_y, 4); this.empty_tile(tile) && num_iterations > 0; num_iterations -= 256) {
                        this.weapon_fpx[w] = this.current_worm.dir ? this.current_worm.fpx - (this.crosshair_x << 16) / num_iterations : this.current_worm.fpx + (this.crosshair_x << 16) / num_iterations;
                        this.weapon_fpy[w] = this.current_worm.fpy - (this.crosshair_y << 8) / num_iterations;
                        tile = this.game.getMapTile((this.weapon_fpx[w] >> 8) / this.game.bkgnd_clx, (this.weapon_fpy[w] >> 8) / this.game.bkgnd_cly);
                    }
                    if (this.current_worm.dir) {
                        int n = w;
                        this.weapon_fpx[n] = this.weapon_fpx[n] + (this.weapon_anim[this.current_weapon[w][6]].lx >> 1 << 8);
                    } else {
                        int n = w;
                        this.weapon_fpx[n] = this.weapon_fpx[n] - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1 << 8);
                    }
                } else {
                    this.weapon_fpx[w] = this.current_worm.dir ? this.current_worm.fpx - (this.crosshair_x << 8) : this.current_worm.fpx + (this.crosshair_x << 8);
                    this.weapon_fpy[w] = this.current_worm.fpy - this.crosshair_y;
                }
                if (this.current_weapon[0][10] == '\u0002') {
                    this.weapon_fpvx[w] = 0;
                    this.weapon_fpvy[w] = 0;
                } else {
                    int strength = (this.weapon_power << 16) / 25600;
                    strength = 8960 * strength >> 8;
                    this.weapon_fpvy[w] = -(this.crosshair_y * ((strength << 8) / 8960) >> 8);
                    this.weapon_fpvx[w] = this.current_worm.dir ? -((int)this.square_root((strength * strength >> 8) - (this.weapon_fpvy[w] * this.weapon_fpvy[w] >> 8))) : (int)this.square_root((strength * strength >> 8) - (this.weapon_fpvy[w] * this.weapon_fpvy[w] >> 8));
                }
                if (this.current_weapon[w][10] == '\u0004') {
                    int n = w;
                    this.weapon_fpvy[n] = this.weapon_fpvy[n] + this.game.random.nextInt() % 256;
                    this.find_bullet_intersect(w);
                    continue;
                }
                if (this.current_weapon[w][10] != '\u0005') continue;
                this.find_bullet_intersect(w);
            }
        }
        this.camera_target_type = (char)2;
    }

    private int num_iterations(int x_dist, int y_dist, int it_step) {
        int iterations = 1;
        iterations = x_dist >= 0 ? (y_dist >= 0 ? (x_dist > y_dist ? (x_dist << 8) / (it_step << 8) : (y_dist << 8) / (it_step << 8)) : (x_dist > -y_dist ? (x_dist << 8) / (it_step << 8) : (y_dist << 8) / (it_step << 8))) : (y_dist >= 0 ? (-x_dist > y_dist ? (x_dist << 8) / (it_step << 8) : (y_dist << 8) / (it_step << 8)) : (-x_dist > -y_dist ? (x_dist << 8) / (it_step << 8) : (y_dist << 8) / (it_step << 8)));
        if (iterations < 0) {
            iterations *= -1;
        }
        if (iterations < 1) {
            iterations = 1;
        }
        return iterations;
    }

    private void set_homing_speed(int w) {
        int xDist = (this.homing_map_x * this.game.bkgnd_clx << 8) - this.weapon_fpx[w];
        int yDist = (this.homing_map_y * this.game.bkgnd_cly << 8) - this.weapon_fpy[w];
        int iterations = this.num_iterations(xDist, yDist, 19200);
        this.weapon_fpvx[w] = xDist / iterations;
        this.weapon_fpvy[w] = yDist / iterations;
    }

    private void find_bullet_intersect(int w) {
        int iterations = this.num_iterations(this.weapon_fpvx[w], this.weapon_fpvy[w], this.game.bkgnd_clx >> 2);
        if (iterations > 0) {
            int x_step_fp = (this.weapon_fpvx[w] << 8) / iterations;
            int y_step_fp = (this.weapon_fpvy[w] << 8) / iterations;
            int new_fpx = 0;
            int new_fpy = 0;
            new_fpx = this.weapon_fpx[w] + x_step_fp;
            new_fpy = this.weapon_fpy[w] + y_step_fp;
            int result = this.collides_with_ground(new_fpx >> 8, new_fpy >> 8, 0);
            block0: while (result == 1 && new_fpx > 0 && new_fpx < this.game.bkgnd_slx << 8 && new_fpy > 0 && new_fpy < this.game.bkgnd_sly << 8) {
                int b;
                result = this.collides_with_ground((new_fpx += x_step_fp) >> 8, (new_fpy += y_step_fp) >> 8, 0);
                if (result == 1 && this.weapon_collides_with_worm(new_fpx >> 8, new_fpy >> 8) != null) {
                    result = 0;
                }
                if (result == 1) {
                    for (b = 0; b < this.player_building_list.length; ++b) {
                        if (!this.player_building_list[b].check_collision(new_fpx >> 8, new_fpx >> 8, true, true, new_fpy >> 8, new_fpy >> 8)) continue;
                        result = 0;
                        break;
                    }
                }
                if (result != 1) continue;
                for (b = 0; b < this.ai_building_list.length; ++b) {
                    if (!this.ai_building_list[b].check_collision(new_fpx >> 8, new_fpx >> 8, true, true, new_fpy >> 8, new_fpy >> 8)) continue;
                    result = 0;
                    continue block0;
                }
            }
            this.weapon_fpx[w] = new_fpx / this.game.bkgnd_clx * this.game.bkgnd_clx;
            this.weapon_fpy[w] = new_fpy;
            this.weapon_fpvx[w] = 0;
            this.weapon_fpvy[w] = 0;
            this.weapon_stopped[w] = true;
        }
    }

    private void update_weapon() {
        if (this.current_weapon != null) {
            boolean ok = false;
            for (int w = 0; w < this.current_weapon.length; ++w) {
                if (this.weapon_fpx[w] <= 0) continue;
                ok = true;
                break;
            }
            if (this.fling_worms) {
                this.fling_worms = !this.update_worms();
                ok = true;
            }
            if (!ok) {
                if (this.turn_timer <= '\u0000' || this.camera_target_type == '\u0002') {
                    this.change_state('\u0001');
                }
                return;
            }
            if (this.check_fuse()) {
                int start_value;
                for (int w = start_value = 0; w < this.current_weapon.length; ++w) {
                    if (this.weapon_fpx[w] <= 0 || !this.end_weapon(w)) continue;
                    return;
                }
            }
            int iterations = 0;
            int new_x = 0;
            int new_y = 0;
            boolean tile = false;
            boolean map_x = false;
            boolean map_y = false;
            char result = '\u0000';
            boolean monkey_speed_set = false;
            for (int w = 0; w < this.current_weapon.length; ++w) {
                int y;
                int x;
                if (this.current_weapon[w][10] == '\u0003' && !this.weapon_stopped[w]) {
                    if (this.weapon_fpvy[w] < 0) {
                        int n = w;
                        this.weapon_fpvy[n] = this.weapon_fpvy[n] + 512;
                    } else {
                        this.weapon_fpvy[w] = 0;
                        this.weapon_stopped[w] = true;
                        this.set_homing_speed(w);
                    }
                }
                if (this.explosion_radius[w][0] > 0 || this.explosion_increment[w][0] < 0) {
                    this.update_explosion(w);
                    if (this.current_weapon[w][10] != '\u0006') continue;
                    x = (this.weapon_fpx[w] >> 8) - this.camera_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1);
                    y = (this.weapon_fpy[w] >> 8) - this.camera_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1);
                    this.weapon_anim[this.current_weapon[w][6]].disp(x, y, this.weapon_frame[w], this.weapon_fpvx[w] < 0 ? 1 : 0);
                    continue;
                }
                if (this.weapon_fpx[w] <= 0) continue;
                x = this.weapon_fpx[w] >> 8;
                y = this.weapon_fpy[w] >> 8;
                this.paint_weapons(w);
                if (this.weapon_fpx[w] > 0) {
                    iterations = 0;
                    new_x = 0;
                    new_y = 0;
                    tile = false;
                    map_x = false;
                    map_y = false;
                    result = '\u0000';
                    if (this.current_weapon[w][10] == '\u0002' && this.current_weapon[w][11] == '\u0001') {
                        for (int a = 0; a < this.player_worm.length; ++a) {
                            this.fling_worms = true;
                            if (this.player_worm[a].health > 0 && !this.player_worm[a].falling) {
                                this.player_worm[a].fpvx = this.game.random.nextInt() % 1024;
                                this.player_worm[a].fpvy = this.game.random.nextInt() % 1024;
                                if (this.player_worm[a].fpvy > 0) {
                                    this.player_worm[a].fpvy *= -1;
                                }
                                this.player_worm[a].falling = true;
                                if (this.player_worm[a] == this.current_worm) {
                                    this.worm_stop_movement = true;
                                }
                            }
                            if (this.ai_worm[a].health <= 0 || this.ai_worm[a].falling) continue;
                            this.ai_worm[a].fpvx = this.game.random.nextInt() % 1024;
                            this.ai_worm[a].fpvy = this.game.random.nextInt() % 1024;
                            if (this.ai_worm[a].fpvy < 0) {
                                this.ai_worm[a].fpvy *= -1;
                            }
                            this.ai_worm[a].falling = true;
                            if (this.ai_worm[a] != this.current_worm) continue;
                            this.worm_stop_movement = true;
                        }
                    } else {
                        if (this.current_weapon[w][10] == '\u0004') {
                            this.end_weapon(w);
                            continue;
                        }
                        if (this.current_weapon[w][10] == '\u0005') {
                            this.game.update_clip();
                            int laser_step = this.num_bullets % 5;
                            for (int l = -1; l < 1; ++l) {
                                this.game.graphics.setColor(255, 51 * (laser_step == 0 ? laser_step : laser_step + l), 0);
                                this.game.graphics.drawLine(this.current_worm.x - this.camera_x, this.current_worm.y - this.camera_y + l, (this.weapon_fpx[w] >> 8) - this.camera_x, (this.weapon_fpy[w] >> 8) - this.camera_y + l);
                            }
                            this.end_weapon(w);
                            continue;
                        }
                        if (this.current_weapon[w][10] != '\u0002') {
                            for (x = iterations = this.num_iterations(this.weapon_fpvx[w], this.weapon_fpvy[w], 2); x > 0; x -= 256) {
                                if (x < 256) {
                                    x = 256;
                                }
                                new_x = this.weapon_fpx[w] + (this.weapon_fpvx[w] << 8) / x >> 8;
                                new_y = this.weapon_fpy[w] + (this.weapon_fpvy[w] << 8) / x >> 8;
                                if (new_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1) <= 0 || new_x + (this.weapon_anim[this.current_weapon[w][6]].lx >> 1) >= this.game.bkgnd_slx - 1 || new_y + (this.weapon_anim[this.current_weapon[w][6]].ly >> 1) >= this.game.bkgnd_sly - 1) {
                                    this.weapon_fpx[w] = -100;
                                    this.weapon_fpy[w] = -100;
                                    this.weapon_fpvx[w] = 0;
                                    this.weapon_fpvy[w] = 0;
                                    continue;
                                }
                                if (this.game.getMapTile(new_x / this.game.bkgnd_clx, new_y / this.game.bkgnd_cly) == this.TILE_WATER_1) {
                                    this.weapon_fpx[w] = new_x << 8;
                                    this.weapon_fpy[w] = new_y << 8;
                                    if (this.game.getMapTile(new_x / this.game.bkgnd_clx, (new_y + (this.weapon_anim[this.current_weapon[w][6]].ly >> 1)) / this.game.bkgnd_cly) != this.TILE_WATER_1) {
                                        this.weapon_fpvx[w] = 0;
                                        this.weapon_fpvy[w] = 0;
                                        this.weapon_stopped[w] = true;
                                        continue;
                                    }
                                    this.weapon_fpvx[w] = 0;
                                    this.weapon_fpvy[w] = this.weapon_fpvy[w] >> 1;
                                    if (this.current_weapon[w][4] > '\u0000') {
                                        this.weapon_stopped[w] = false;
                                        continue;
                                    }
                                    int n = w;
                                    this.weapon_fpy[n] = this.weapon_fpy[n] + this.weapon_fpvy[w];
                                    this.end_weapon(w);
                                    continue;
                                }
                                result = this.check_terrain_collision(w, new_x, new_y);
                                if (result == '\u0001') {
                                    return;
                                }
                                if (result == '\u0002') break;
                                for (int b = 0; b < this.player_building_list.length; ++b) {
                                    result = this.check_building_collision(b, w, new_x, new_y);
                                    if (result == '\u0001') {
                                        return;
                                    }
                                    if (result == '\u0002') break;
                                }
                                if ((result = this.check_worm_collision(w, new_x, new_y)) == '\u0001') {
                                    return;
                                }
                                if (result != '\u0002') {
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }
                int n = w;
                this.weapon_fpx[n] = this.weapon_fpx[n] + this.weapon_fpvx[w];
                if (!this.weapon_stopped[w] || this.current_weapon[w][10] == '\u0003' && this.explosion_radius[w][0] == 0) {
                    int n2 = w;
                    this.weapon_fpy[n2] = this.weapon_fpy[n2] + this.weapon_fpvy[w];
                }
                if (this.current_weapon[w][8] > '\u0000') {
                    if (this.current_weapon[w][10] == '\u0002') {
                        int n3 = w;
                        this.weapon_frame[n3] = (char)(this.weapon_frame[n3] + '\u0001');
                        if (this.weapon_frame[w] > '\u0003') {
                            this.weapon_frame[w] = '\u0000';
                        }
                    } else if (this.current_weapon[w][6] == '\u000b') {
                        if (!this.weapon_stopped[w]) {
                            int n4 = w;
                            this.weapon_frame[n4] = (char)(this.weapon_frame[n4] + '\u0001');
                            if (this.weapon_frame[w] > '\u0003') {
                                this.weapon_frame[w] = '\u0000';
                            }
                        }
                    } else {
                        this.weapon_frame[w] = this.weapon_fpvx[w] <= 256 && this.weapon_fpvx[w] >= -256 ? 3 : (this.weapon_fpvy[w] <= 256 && this.weapon_fpvy[w] >= -256 ? 0 : (this.weapon_fpvy[w] >= 0 ? 1 : 2));
                        if (this.weapon_fpvx[w] == 0 && this.current_weapon[0][6] != '\f') {
                            this.weapon_frame[w] = '\u0001';
                        }
                    }
                }
                if (this.weapon_stopped[w]) continue;
                if (this.game.wind_on && this.current_weapon[w][2] > '\u0000' && (this.game.wind_on && this.wind_value > 0 && this.weapon_fpvx[w] < 10240 || this.wind_value < 0 && this.weapon_fpvx[w] > -10240)) {
                    int n5 = w;
                    this.weapon_fpvx[n5] = this.weapon_fpvx[n5] + (256 * this.wind_value >> 8);
                }
                if (this.current_weapon[w][3] <= '\u0000' || this.weapon_fpvy[w] >= 2560 || this.weapon_stopped[w]) continue;
                int n6 = w;
                this.weapon_fpvy[n6] = this.weapon_fpvy[n6] + 256;
            }
        }
    }

    private char check_worm_collision(int w, int new_x, int new_y) {
        Worm worm = this.weapon_collides_with_worm(new_x, new_y);
        if (worm != null) {
            this.weapon_fpx[w] = new_x << 8;
            this.weapon_fpy[w] = new_y << 8;
            if (this.current_weapon[w][1] > '\u0000') {
                this.bounce_weapon_below(w, new_x, new_y);
                return '\u0002';
            }
            this.end_weapon(w);
            return '\u0001';
        }
        return '\u0000';
    }

    private char check_building_collision(int b, int w, int new_x, int new_y) {
        Building build = null;
        if (this.player_building_list[b].check_collision(new_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1), new_x + (this.weapon_anim[this.current_weapon[w][6]].lx >> 1), true, true, new_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1), new_y + (this.weapon_anim[this.current_weapon[w][6]].ly >> 1))) {
            build = this.player_building_list[b];
        } else if (this.ai_building_list[b].check_collision(new_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1), new_x + (this.weapon_anim[this.current_weapon[w][6]].lx >> 1), true, true, new_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1), new_y + (this.weapon_anim[this.current_weapon[w][6]].ly >> 1))) {
            build = this.ai_building_list[b];
        }
        if (build != null) {
            this.intersect_x = new_x > build.x + build.building_anim.lx ? build.x + build.building_anim.lx : (new_x < build.x ? build.x : new_x);
            this.intersect_y = new_y > build.y + build.building_anim.ly ? build.y + build.building_anim.ly : (new_y < build.y ? build.y : new_y);
            this.weapon_fpx[w] = this.intersect_x << 8;
            this.weapon_fpy[w] = this.intersect_y << 8;
            if (this.current_weapon[w][1] > '\u0000') {
                this.bounce_weapon_below(w, new_x, new_y);
                return '\u0002';
            }
            this.end_weapon(w);
            return '\u0001';
        }
        return '\u0000';
    }

    private char check_terrain_collision(int w, int new_x, int new_y) {
        int result = 1;
        result = this.collides_with_ground(new_x, new_y + (this.weapon_anim[this.current_weapon[w][6]].ly >> 1), 0);
        if (result != 1) {
            this.weapon_intersect_below_terrain(w, new_x, new_y);
            if (this.current_weapon[w][1] > '\u0000') {
                this.bounce_weapon_below(w, new_x, new_y);
                return '\u0002';
            }
            this.end_weapon(w);
            return '\u0001';
        }
        if (this.weapon_fpvx[w] > 0) {
            result = this.collides_with_ground(new_x + (this.weapon_anim[this.current_weapon[w][6]].lx >> 1), new_y, 0);
        } else if (this.weapon_fpvx[w] < 0) {
            result = this.collides_with_ground(new_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1), new_y, 0);
        }
        if (result != 1) {
            this.weapon_fpx[w] = new_x << 8;
            this.weapon_fpy[w] = new_y << 8;
            if (this.current_weapon[w][1] > '\u0000') {
                this.decrease_weapon_speed(w);
                int n = w;
                this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                return '\u0002';
            }
            this.end_weapon(w);
            return '\u0001';
        }
        return '\u0000';
    }

    private void weapon_intersect_right_terrain(int w, int new_x, int new_y) {
        int map_x = (new_x + (this.weapon_anim[this.current_weapon[w][6]].lx >> 1)) / this.game.bkgnd_clx;
        int map_y = new_y / this.game.bkgnd_cly;
        int old_x = map_x;
        byte tile = this.game.getMapTile(map_x, map_y);
        if (this.empty_tile(tile)) {
            ++map_x;
        }
        tile = this.game.getMapTile(map_x, map_y);
        map_x *= this.game.bkgnd_clx;
        map_y *= this.game.bkgnd_cly;
        switch (tile) {
            case 2: {
                this.find_intersect_point(new_x << 8, new_y << 8, new_x + this.game.bkgnd_clx << 8, new_y << 8, map_x + this.game.bkgnd_clx << 8, map_y << 8, map_x << 8, map_y + this.game.bkgnd_cly << 8);
                break;
            }
            case 3: {
                this.find_intersect_point(new_x << 8, new_y << 8, new_x + this.game.bkgnd_clx << 8, new_y << 8, map_x << 8, map_y << 8, map_x + this.game.bkgnd_clx << 8, map_y + this.game.bkgnd_cly << 8);
            }
            default: {
                this.find_intersect_point(new_x << 8, new_y << 8, new_x + this.game.bkgnd_clx << 8, new_y << 8, map_x << 8, map_y << 8, map_x << 8, map_y + this.game.bkgnd_cly << 8);
            }
        }
        this.weapon_fpx[w] = this.intersect_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1 << 8);
        this.weapon_fpy[w] = this.intersect_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1 << 8);
    }

    private void weapon_intersect_left_terrain(int w, int new_x, int new_y) {
        int map_x = (new_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1)) / this.game.bkgnd_clx;
        int map_y = new_y / this.game.bkgnd_cly;
        int old_x = map_x;
        byte tile = this.game.getMapTile(map_x, map_y);
        if (this.empty_tile(tile)) {
            --map_x;
        }
        tile = this.game.getMapTile(map_x, map_y);
        map_x *= this.game.bkgnd_clx;
        map_y *= this.game.bkgnd_cly;
        switch (tile) {
            case 2: {
                this.find_intersect_point(new_x << 8, new_y << 8, new_x - this.game.bkgnd_clx << 8, new_y << 8, map_x + this.game.bkgnd_clx << 8, map_y << 8, map_x << 8, map_y + this.game.bkgnd_cly << 8);
                break;
            }
            case 3: {
                this.find_intersect_point(new_x << 8, new_y << 8, new_x - this.game.bkgnd_clx << 8, new_y << 8, map_x << 8, map_y << 8, map_x + this.game.bkgnd_clx << 8, map_y + this.game.bkgnd_cly << 8);
            }
            default: {
                this.find_intersect_point(new_x << 8, new_y << 8, new_x - this.game.bkgnd_clx << 8, new_y << 8, map_x + this.game.bkgnd_clx << 8, map_y << 8, map_x + this.game.bkgnd_clx << 8, map_y + this.game.bkgnd_cly << 8);
            }
        }
        this.weapon_fpx[w] = this.intersect_x + (this.weapon_anim[this.current_weapon[w][6]].lx >> 1 << 8);
        this.weapon_fpy[w] = this.intersect_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1 << 8);
    }

    private void weapon_intersect_below_terrain(int w, int new_x, int new_y) {
        int map_y;
        int map_x = new_x / this.game.bkgnd_clx;
        int old_y = map_y = (new_y + (this.weapon_anim[this.current_weapon[w][6]].ly >> 1)) / this.game.bkgnd_cly;
        byte tile = this.game.getMapTile(map_x, map_y);
        this.find_intersect_point(new_x << 8, new_y << 8, new_x << 8, new_y + this.game.bkgnd_cly << 8, map_x *= this.game.bkgnd_clx, map_y *= this.game.bkgnd_cly);
        this.weapon_fpx[w] = this.intersect_x;
        this.weapon_fpy[w] = this.intersect_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1 << 8);
    }

    private boolean check_fuse() {
        if (!this.weapon_stop_fuse && this.current_weapon[0][4] > '\u0000') {
            this.state_tick = (char)(this.state_tick + '\u0001');
            if (this.state_tick % 8 == 0) {
                this.weapon_fuse = (char)(this.weapon_fuse + '\u0001');
                if (this.weapon_fuse <= this.current_weapon[0][4] && this.current_weapon[0][10] == '\u0002' && this.current_weapon[0][11] == '\u0002') {
                    this.game.flood_level(this.TILE_WATER_1);
                    for (int x = 0; x < this.player_worm.length; ++x) {
                        this.player_worm[x].apply_gravity(false);
                        this.ai_worm[x].apply_gravity(false);
                        if (!this.player_worm[x].falling && !this.ai_worm[x].falling) continue;
                        this.fling_worms = true;
                    }
                    for (int b = 0; b < this.player_building_list.length; ++b) {
                        this.player_building_list[b].check_flood(this);
                        this.ai_building_list[b].check_flood(this);
                    }
                    this.clean_building_list();
                }
            }
            if (this.weapon_fuse >= this.current_weapon[0][4]) {
                this.weapon_stop_fuse = true;
                return true;
            }
        }
        return false;
    }

    private void decrease_weapon_speed(int w) {
        this.weapon_fpvx[w] = this.current_weapon[w][6] == '\u0007' || this.current_weapon[w][6] == '\b' || this.current_weapon[w][6] == '\r' ? (this.weapon_fpvx[w] >> 2) * 3 : this.weapon_fpvx[w] >> 1;
        if (this.weapon_fpvx[w] > 0 && this.weapon_fpvx[w] < 128 || this.weapon_fpvx[w] < 0 && this.weapon_fpvx[w] > -128) {
            this.weapon_fpvx[w] = 0;
        }
        this.weapon_fpvy[w] = this.weapon_fpvy[w] >> 1;
    }

    private void bounce_weapon_below(int w, int new_x, int new_y) {
        int map_x = new_x / this.game.bkgnd_clx;
        int map_y = new_y / this.game.bkgnd_cly;
        byte tile = this.game.getMapTile(map_x, map_y);
        if (this.empty_tile(tile)) {
            ++map_y;
        }
        this.decrease_weapon_speed(w);
        switch (this.game.getMapTile(map_x, map_y)) {
            case 3: {
                if (this.weapon_fpvx[w] < 0) {
                    int n = w;
                    this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                }
                int n = w;
                this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                break;
            }
            case 2: {
                if (this.weapon_fpvx[w] > 0) {
                    int n = w;
                    this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                }
                int n = w;
                this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                break;
            }
            case 5: {
                int wx = this.current_worm.x - map_x * this.game.bkgnd_clx;
                int wy = this.current_worm.y - map_y * this.game.bkgnd_cly;
                if (wx < this.game.bkgnd_clx >> 1) {
                    if (this.weapon_fpvx[w] > 0) {
                        int n = w;
                        this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                    }
                    int n = w;
                    this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                    break;
                }
                if (this.weapon_fpvx[w] < 0) {
                    int n = w;
                    this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                }
                int n = w;
                this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                break;
            }
            default: {
                if (this.game.getMapTile(map_x, map_y) == this.TILE_WATER_1) {
                    if (scheme == '\u0001') {
                        this.weapon_fpvx[w] = 0;
                        break;
                    }
                    int n = w;
                    this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                    break;
                }
                if (this.game.getMapTile(map_x, map_y) == 4 || this.game.getMapTile(map_x, map_y) == this.TILE_SLOPE_FILLER_L) {
                    if (this.game.getMapTile(map_x, map_y - 1) == 2) {
                        if (this.weapon_fpvx[w] > 0) {
                            int n = w;
                            this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                        }
                    } else if (this.game.getMapTile(map_x, map_y - 1) == 3) {
                        if (this.weapon_fpvx[w] < 0) {
                            int n = w;
                            this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                        }
                    } else if (this.game.getMapTile(map_x, map_y - 1) == 5) {
                        int wx = this.current_worm.x - map_x * this.game.bkgnd_clx;
                        int wy = this.current_worm.y - map_y * this.game.bkgnd_cly;
                        if (wx < this.game.bkgnd_clx >> 1) {
                            if (this.weapon_fpvx[w] > 0) {
                                int n = w;
                                this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                            }
                            int n = w;
                            this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                        } else {
                            if (this.weapon_fpvx[w] < 0) {
                                int n = w;
                                this.weapon_fpvx[n] = this.weapon_fpvx[n] * -1;
                            }
                            int n = w;
                            this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                        }
                    }
                    int n = w;
                    this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
                    break;
                }
                int n = w;
                this.weapon_fpvy[n] = this.weapon_fpvy[n] * -1;
            }
        }
    }

    private boolean end_weapon(int w) {
        block0 : switch (this.current_weapon[w][10]) {
            case '\u0001': 
            case '\u0003': 
            case '\u0006': {
                this.weapon_fpvx[w] = 0;
                this.weapon_fpvy[w] = 0;
                for (int e = 0; e < this.explosion_radius[w].length; ++e) {
                    this.explosion_radius[w][e] = this.explosion_increment[w][e];
                }
                this.weapon_stop_fuse = true;
                if (this.current_weapon[w][6] != '\f') break;
                this.weapon_frame[w] = 3;
                break;
            }
            case '\u0004': {
                if (this.weapon_fpx[w] < 0) break;
                this.weapon_fpvx[w] = 0;
                this.weapon_fpvy[w] = 0;
                for (int e = 0; e < this.explosion_radius[w].length; ++e) {
                    this.explosion_radius[w][e] = this.explosion_increment[w][e];
                }
                if (this.num_bullets >= 9) break;
                this.setup_weapon(20, 1, true);
                this.spawn_weapon();
                ++this.num_bullets;
                return true;
            }
            case '\u0005': {
                if (this.weapon_fpx[w] < 0) break;
                this.weapon_fpvx[w] = 0;
                this.weapon_fpvy[w] = 0;
                for (int e = 0; e < this.explosion_radius[w].length; ++e) {
                    this.explosion_radius[w][e] = this.explosion_increment[w][e];
                }
                if (this.num_bullets >= 29) break;
                this.setup_weapon(23, 1, true);
                this.spawn_weapon();
                ++this.num_bullets;
                return true;
            }
            case '\u0002': {
                switch (this.current_weapon[w][11]) {
                    case '\u0000': {
                        this.weapon_fpx[w] = -100;
                        this.weapon_fpy[w] = -100;
                        for (int x = 0; x < this.player_worm.length; ++x) {
                            if (this.player_worm[x].health > 1) {
                                this.player_worm[x].health = 1;
                            }
                            if (this.ai_worm[x].health <= 1) continue;
                            this.ai_worm[x].health = 1;
                        }
                        break block0;
                    }
                    case '\u0001': {
                        this.weapon_fpx[w] = -100;
                        this.weapon_fpy[w] = -100;
                        break;
                    }
                    case '\u0002': {
                        this.weapon_fpx[w] = -100;
                        this.weapon_fpy[w] = -100;
                    }
                }
                break;
            }
            case '\u0000': {
                this.setup_weapon(this.current_weapon[w][12], this.current_weapon[w][13], true);
                return true;
            }
        }
        return false;
    }

    private void update_explosion(int w) {
        this.game.set_clip(0, 0, this.game.slx, this.game.sly);
        int current_radius = 0;
        for (int e = 0; e < this.explosion_radius[w].length; ++e) {
            if (this.explosion_radius[w][e] > 0) {
                if (!this.explosion_sound_played) {
                    this.game.hdl_sound(91);
                    this.explosion_sound_played = true;
                }
                int x = this.weapon_fpx[w] >> 8;
                int y = this.weapon_fpy[w] >> 8;
                for (int r = 3; r > 0; --r) {
                    if (r == 3) {
                        this.game.graphics.setColor(0xFCFCAC);
                    } else if (r == 2) {
                        this.game.graphics.setColor(16768000);
                    } else if (r == 1) {
                        this.game.graphics.setColor(16750080);
                    }
                    current_radius = this.explosion_radius[w][e] / 3 * r;
                    x = (this.weapon_fpx[w] >> 8) - this.camera_x - (current_radius >> 1);
                    y = (this.weapon_fpy[w] >> 8) - this.camera_y - (current_radius >> 1);
                    if (x <= 0 || x >= this.game.slx || y <= 0 || y >= this.game.sly) continue;
                    if (this.current_weapon[w][10] != '\u0006') {
                        this.game.graphics.fillArc(x + this.explosion_x_offset[e], y + this.explosion_y_offset[e], current_radius, current_radius, 0, 359);
                    }
                    if (e == 0) continue;
                    this.game.graphics.setColor(0x4F4F4F);
                    if (this.current_weapon[w][10] != '\u0006') {
                        this.game.graphics.fillArc(x + this.smoke_x_offset[e], y + this.smoke_y_offset[e], current_radius, current_radius, 0, 359);
                    }
                    this.game.graphics.setColor(0x8A8A8A);
                    if (this.current_weapon[w][10] == '\u0006') continue;
                    this.game.graphics.fillArc(x + this.smoke_x_offset[e], y + this.smoke_y_offset[e], current_radius, current_radius, 0, 160);
                }
                int[] nArray = this.explosion_radius[w];
                int n = e;
                nArray[n] = nArray[n] + this.explosion_increment[w][e];
                if (this.explosion_radius[w][e] >= this.current_weapon[w][11]) {
                    this.explosion_radius[w][e] = this.current_weapon[w][11];
                    int a = 0;
                    while (a < this.explosion_increment[w].length) {
                        int[] nArray2 = this.explosion_increment[w];
                        int n2 = a++;
                        nArray2[n2] = nArray2[n2] * -1;
                    }
                }
            }
            if (this.explosion_radius[w][e] == this.current_weapon[w][11]) {
                this.apply_damage(w);
            }
            if (this.explosion_radius[w][0] > 0 || this.explosion_increment[w][0] >= 0) continue;
            for (int a = 0; a < this.explosion_radius[w].length; ++a) {
                this.explosion_radius[w][a] = 0;
                this.explosion_increment[w][a] = e == 0 ? 5 : 2;
            }
            this.weapon_fpx[w] = -100;
            this.weapon_fpy[w] = -100;
            this.weapon_fpvx[w] = 0;
            this.weapon_fpvy[w] = 0;
            this.explosion_sound_played = false;
            if (this.current_weapon[w][10] != '\u0004') break;
            this.end_weapon(w);
            break;
        }
    }

    private void apply_damage(int w) {
        int b;
        int weapon_damage = this.current_weapon[w][0];
        int weapon_radius = this.current_weapon[w][11] >> 1;
        for (b = 0; b < this.player_building_list.length; ++b) {
            if (this.players_turn) {
                if (this.player_building_list[b].building_type != 7) continue;
                weapon_damage *= 2;
                continue;
            }
            if (this.ai_building_list[b].building_type != 7) continue;
            weapon_damage *= 2;
        }
        for (int x = 0; x < 4; ++x) {
            this.player_worm[x].hit(this.weapon_fpx[w], this.weapon_fpy[w], weapon_radius, weapon_damage, true, this.current_worm);
            this.ai_worm[x].hit(this.weapon_fpx[w], this.weapon_fpy[w], weapon_radius, weapon_damage, false, this.current_worm);
        }
        for (b = 0; b < this.player_building_list.length; ++b) {
            this.player_building_list[b].hit(this.weapon_fpx[w], this.weapon_fpy[w], weapon_radius, weapon_damage, this);
            this.ai_building_list[b].hit(this.weapon_fpx[w], this.weapon_fpy[w], weapon_radius, weapon_damage, this);
        }
        this.clean_building_list();
        this.fling_worms = true;
    }

    private Worm weapon_collides_with_worm(int weapon_x, int weapon_y) {
        for (int x = 0; x < 4; ++x) {
            if (this.player_worm[x].health > 0 && this.player_worm[x].x - (this.player_worm[x].worm_anim.lx >> 1) <= weapon_x && this.player_worm[x].x + (this.player_worm[x].worm_anim.lx >> 1) >= weapon_x && this.player_worm[x].y - (this.player_worm[x].worm_anim.ly >> 1) <= weapon_y && this.player_worm[x].y + (this.player_worm[x].worm_anim.ly >> 1) >= weapon_y) {
                return this.player_worm[x];
            }
            if (this.ai_worm[x].health <= 0 || this.ai_worm[x].x - (this.player_worm[x].worm_anim.lx >> 1) > weapon_x || this.ai_worm[x].x + (this.player_worm[x].worm_anim.lx >> 1) < weapon_x || this.ai_worm[x].y - (this.player_worm[x].worm_anim.ly >> 1) > weapon_y || this.ai_worm[x].y + (this.player_worm[x].worm_anim.ly >> 1) < weapon_y) continue;
            return this.ai_worm[x];
        }
        return null;
    }

    public long square_root(long x) {
        long step = 2560L;
        long curValue = 0L;
        long prevValue = 0L;
        if (x > 0L) {
            curValue = 128L * (step + (x << 8) / step) >> 8;
            while (curValue != prevValue) {
                prevValue = curValue;
                curValue = 128L * (curValue + (x << 8) / curValue) >> 8;
            }
        } else if (x < 0L) {
            curValue = this.square_root(x * -1L);
        }
        return curValue;
    }

    private int get_wind_value() {
        return (this.game.random.nextInt() % 101 << 16) / 25600;
    }

    public void update_camera() {
        switch (this.camera_target_type) {
            case '\u0000': {
                if ((this.game.get_kb_state() & 4) != 0) {
                    this.camera_fpx -= 2048;
                    break;
                }
                if ((this.game.get_kb_state() & 8) != 0) {
                    this.camera_fpx += 2048;
                    break;
                }
                if ((this.game.get_kb_state() & 1) != 0) {
                    this.camera_fpy -= 2048;
                    break;
                }
                if ((this.game.get_kb_state() & 2) == 0) break;
                this.camera_fpy += 2048;
                break;
            }
            case '\u0002': {
                if (this.current_weapon == null) break;
                if (this.weapon_fpx[0] > 0) {
                    this.camera_fpx = this.weapon_fpx[0] - (this.game.slx >> 1 << 8);
                    this.camera_fpy = this.weapon_fpy[0] - (this.game.sly >> 1 << 8);
                } else {
                    for (int w = 1; w < this.weapon_fpx.length; ++w) {
                        if (this.weapon_fpx[w] <= 0) continue;
                        this.camera_fpx = this.weapon_fpx[w] - (this.game.slx >> 1 << 8);
                        this.camera_fpy = this.weapon_fpy[w] - (this.game.sly >> 1 << 8);
                    }
                }
                if (this.current_weapon[0][10] != '\u0002' || this.current_weapon[0][11] != '\u0001') break;
                this.camera_fpx += this.game.random.nextInt() % 10 << 8;
                this.camera_fpy += this.game.random.nextInt() % 10 << 8;
                break;
            }
            case '\u0003': {
                if (this.building != null) {
                    this.camera_fpx = (this.building_map_x * this.game.bkgnd_clx + (this.building.lx >> 1) << 8) - (this.game.slx >> 1 << 8);
                    this.camera_fpy = (this.building_map_y * this.game.bkgnd_cly + (this.building.ly >> 1) << 8) - (this.game.sly >> 1 << 8);
                    break;
                }
                int num_tiles_height = 0;
                int num_tiles_width = 0;
                int building_height = 0;
                int building_width = 0;
                switch (this.foundation_state) {
                    case '\u0000': {
                        num_tiles_height = 2;
                        num_tiles_width = 2;
                        break;
                    }
                    case '\u0001': {
                        num_tiles_height = 2;
                        num_tiles_width = 3;
                        break;
                    }
                    case '\u0002': {
                        num_tiles_height = 3;
                        num_tiles_width = 4;
                    }
                }
                building_height = this.game.bkgnd_cly * num_tiles_height;
                building_width = this.game.bkgnd_clx * num_tiles_width;
                this.camera_fpx = (this.building_map_x * this.game.bkgnd_clx + (building_width >> 1) << 8) - (this.game.slx >> 1 << 8);
                this.camera_fpy = ((this.building_map_y + this.foundation_y_offset) * this.game.bkgnd_cly + (building_height >> 1) << 8) - (this.game.sly >> 1 << 8);
                break;
            }
            case '\u0004': {
                if (this.crate_falling < 0 || this.crate_falling >= this.player_crate_active.length) break;
                if (this.players_turn) {
                    this.camera_fpx = this.player_crate_fpx[this.crate_falling] - (this.game.slx >> 1 << 8);
                    this.camera_fpy = this.player_crate_fpy[this.crate_falling] - (this.game.sly >> 1 << 8);
                    break;
                }
                this.camera_fpx = this.ai_crate_fpx[this.crate_falling] - (this.game.slx >> 1 << 8);
                this.camera_fpy = this.ai_crate_fpy[this.crate_falling] - (this.game.sly >> 1 << 8);
                break;
            }
            case '\u0001': {
                if (this.current_worm == null) break;
                if (this.game_state == '\u001b' || this.game_state == '\u001c') {
                    this.camera_fpx = this.homing_map_x * this.game.bkgnd_clx - (this.game.slx >> 1) << 8;
                    this.camera_fpy = this.homing_map_y * this.game.bkgnd_cly - (this.game.sly >> 1) << 8;
                    break;
                }
                this.camera_fpx = (this.current_worm.x << 8) - (this.game.slx >> 1 << 8);
                this.camera_fpy = (this.current_worm.y << 8) - (this.game.sly >> 1 << 8);
            }
        }
        this.camera_x = this.camera_fpx >> 8;
        this.camera_y = this.camera_fpy >> 8;
        this.restrain_camera();
    }

    public void restrain_camera() {
        if (this.camera_x < 0) {
            this.camera_x = 0;
            this.camera_fpx = 0;
        } else if (this.camera_x > this.game.bkgnd_slx - this.game.slx) {
            this.camera_x = this.game.bkgnd_slx - this.game.slx;
            this.camera_fpx = this.camera_x << 8;
        }
        if (this.camera_y < 0) {
            this.camera_y = 0;
            this.camera_fpy = 0;
        } else if (this.camera_y > this.game.bkgnd_sly - this.game.sly) {
            this.camera_y = this.game.bkgnd_sly - this.game.sly;
            this.camera_fpy = this.camera_y << 8;
        }
    }

    public int paint() {
        int x;
        int x2;
        int y;
        int map_y;
        if (this.game_state == '\u0001' && this.game_state != '\u00fe') {
            if (this.update_worms()) {
                this.check_for_end_game();
            }
        } else {
            if (this.game_state == '\u0004') {
                this.game.hdl_sound(89);
                return 12;
            }
            if (this.game_state == '\u0005') {
                this.game.hdl_sound(89);
                return 13;
            }
            if (this.game_state == '\u0006') {
                this.check_special();
            } else if (this.game_state == '\b' || this.game_state == '\u00fd') {
                this.move_crate();
            }
        }
        this.controls();
        if (this.game_state != '\u00fe') {
            this.update_camera();
        }
        if (this.banner_on) {
            switch (this.game_state) {
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u001b': {
                    this.game.banner_set(this.sk_select, this.sk_back, true, 0xFFFFFF, false);
                    break;
                }
                case '\u000f': {
                    this.game.banner_set(this.sk_pause, this.sk_back, true, 0xFFFFFF, false);
                    break;
                }
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u001c': {
                    if (this.game_type == '\u0001') {
                        this.game.banner_set(this.sk_select, this.sk_back, true, 0xFFFFFF, false);
                        break;
                    }
                    this.game.banner_set(this.sk_pause, this.sk_quit, true, 0xFFFFFF, false);
                    break;
                }
                case '\u0017': {
                    if (this.game_type == '\u0001') {
                        this.game.banner_set(this.sk_pause, this.sk_back, true, 0xFFFFFF, false);
                        break;
                    }
                    this.game.banner_set(this.sk_pause, this.sk_quit, true, 0xFFFFFF, false);
                    break;
                }
                case '\u00fe': {
                    if (this.message == null || !this.message.equals(this.message_quit_question)) {
                        this.game.banner_set(this.sk_resume, this.sk_quit, true, 0xFFFFFF, false);
                        break;
                    }
                    this.game.banner_set(this.game.res_get_string(61503), this.game.res_get_string(69695), true, 0xFFFFFF, false);
                    break;
                }
                case '\u0002': 
                case '\u0003': 
                case '\u0007': 
                case '\b': 
                case '\t': {
                    if (this.state_tick < '\u0004') break;
                    this.game.banner_set(this.sk_ok, null, true, 0xFFFFFF, false);
                    break;
                }
                case '\u0001': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': {
                    break;
                }
                default: {
                    this.game.banner_set(this.sk_pause, this.sk_quit, true, 0xFFFFFF, false);
                }
            }
        }
        if ((map_y = this.camera_y / this.game.bkgnd_cly) >= 0) {
            this.game.update_clip();
            for (y = map_y; y <= map_y + this.game.sly / this.game.bkgnd_cly + 1; ++y) {
                this.game.graphics.setColor(y * this.red_step, y * this.green_step, y * this.blue_step);
                this.game.graphics.fillRect(0, (y - map_y) * this.game.bkgnd_cly - this.camera_y % this.game.bkgnd_cly, this.game.slx, this.game.bkgnd_cly);
            }
        }
        this.game.bkgnd_disp(this.camera_x, this.camera_y, (byte)11);
        this.paint_buildings();
        this.paint_crates();
        this.paint_worms();
        if (this.game_state != '\b' && this.game_state != '\u00fd' && this.game_state != '\u0007') {
            if (this.turn_timer >= '\n') {
                this.game.draw_bordered_text("" + this.turn_timer, this.game.font_get_width(this.ingame_font, "" + this.turn_timer) - 4, this.game.slyc - this.game.font_get_height(this.ingame_font), this.ingame_font, 0, 0xDD0000, false);
            } else {
                this.game.draw_bordered_text("0" + this.turn_timer, this.game.font_get_width(this.ingame_font, "0" + this.turn_timer) - 4, this.game.slyc - this.game.font_get_height(this.ingame_font), this.ingame_font, 0, 0xDD0000, false);
            }
        }
        switch (this.game_state) {
            case '\u0010': 
            case '\u0018': {
                if (this.weapon_power < 100) {
                    y = 0;
                    x2 = 0;
                    int radius = 0;
                    int strength = (this.weapon_power << 16) / 25600;
                    strength = 8960 * strength >> 8;
                    for (int circle = 6; circle < strength >> 8; circle += 2) {
                        y = this.crosshair_y * ((circle << 16) / 8960) >> 8;
                        x2 = (int)this.square_root((circle * circle << 8) - (y * y >> 8)) >> 8;
                        radius = (circle << 16) / 512 >> 8;
                        if (this.current_worm.dir) {
                            x2 *= -1;
                        }
                        y = -(y >> 8);
                        this.game.update_clip();
                        this.game.graphics.setColor(255, circle * 6, 0);
                        this.game.graphics.fillArc(x2 + this.current_worm.x - this.camera_x - (radius >> 1), y + this.current_worm.y - this.camera_y - (radius >> 1), radius, radius, 0, 360);
                    }
                }
            }
            case '\u000f': 
            case '\u0017': {
                if (this.current_weapon[0][10] == '\u0002' || this.camera_target_type == '\u0000') break;
                y = -(this.crosshair_y >> 8);
                x2 = this.crosshair_x;
                if (this.current_worm.dir) {
                    x2 *= -1;
                }
                this.crosshair.disp(x2 + this.current_worm.x - this.camera_x - (this.crosshair.lx >> 1), y + this.current_worm.y - this.camera_y - (this.crosshair.ly >> 1), 0, 0);
                break;
            }
            case '\u0011': 
            case '\u0019': {
                this.update_weapon();
                break;
            }
            case '\u001b': 
            case '\u001c': {
                x = this.homing_map_x * this.game.bkgnd_clx;
                int y2 = this.homing_map_y * this.game.bkgnd_cly;
                this.crosshair.disp(x - this.camera_x, y2 - this.camera_y, 0, 0);
            }
        }
        if (this.game_state == '\u00fe') {
            if (this.prev_state == '\u000f' || this.prev_state == '\u000f') {
                y = -(this.crosshair_y >> 8);
                x2 = this.crosshair_x;
                if (this.current_worm.dir) {
                    x2 *= -1;
                }
                this.crosshair.disp(x2 + this.current_worm.x - this.camera_x - (this.crosshair.lx >> 1), y + this.current_worm.y - this.camera_y - (this.crosshair.ly >> 1), 0, 0);
            } else if ((this.prev_state == '\u0011' || this.prev_state == '\u0019') && this.current_weapon != null) {
                for (int w = 0; w < this.current_weapon.length; ++w) {
                    if (this.explosion_radius[w][0] > 5) continue;
                    this.paint_weapons(w);
                }
            }
        }
        switch (this.game_state) {
            case '\f': {
                this.player_building_menu.disp();
                break;
            }
            case '\u000e': {
                this.player_weapon_menu.disp();
                break;
            }
            case '\u0014': {
                if (this.game_type != '\u0001') break;
                this.ai_building_menu.disp();
                break;
            }
            case '\u0016': {
                if (this.game_type != '\u0001') break;
                this.ai_weapon_menu.disp();
                break;
            }
            default: {
                if (!this.game.wind_on) break;
                this.wind_hud.disp(this.game.slx - this.wind_hud.lx - 5, this.game.slyc - this.wind_hud.ly - 5, 0, 0);
                if (this.wind_value > 0) {
                    this.wind_hud.disp_part(this.game.slx - this.wind_hud.lx - 5, this.game.slyc - this.wind_hud.ly - 5, 1, 0, this.wind_hud.lx >> 1, 0, (this.wind_hud.lx >> 1 << 8) * this.wind_value >> 16, this.wind_hud.ly);
                    break;
                }
                if (this.wind_value >= 0) break;
                x = (this.wind_hud.lx >> 1 << 8) * (256 + this.wind_value) >> 16;
                this.wind_hud.disp_part(this.game.slx - this.wind_hud.lx - 5, this.game.slyc - this.wind_hud.ly - 5, 1, 0, x, 0, (this.wind_hud.lx >> 1) - x, this.wind_hud.ly);
            }
        }
        switch (this.game_state) {
            case '\u00fe': {
                if (this.message == null || !this.message.equals(this.message_quit_question)) {
                    this.game.draw_bordered_text(this.message_game_paused, this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                    break;
                }
                this.game.draw_bordered_text(this.message, this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                break;
            }
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': {
                this.game.draw_bordered_text(this.message, this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                break;
            }
            case '\u0007': {
                if ((this.player_wonder_turns != 0 || !this.players_turn) && (this.ai_wonder_turns != 0 || this.players_turn)) break;
                this.game.draw_bordered_text(this.message_wonder, this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                break;
            }
            case '\b': {
                if (this.state_tick >= ' ') break;
                this.game.draw_bordered_text(this.message_crate, this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                break;
            }
            case '\t': {
                this.game.draw_bordered_text(this.message, this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                break;
            }
            case '\n': {
                this.game.draw_bordered_text(this.message_select_worm, this.game.slx >> 1, this.game.slyc - this.game.font_get_height(this.ingame_font), this.ingame_font, 0, 0xDD0000, true);
                break;
            }
            case '\u0012': {
                if (this.game_type != '\u0001') break;
                this.game.draw_bordered_text(this.message_select_worm, this.game.slx >> 1, this.game.slyc - this.game.font_get_height(this.ingame_font), this.ingame_font, 0, 0xDD0000, true);
                break;
            }
            case '\u000b': 
            case '\u0013': {
                if (this.message == null) break;
                this.game.draw_bordered_text(this.message, this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                break;
            }
            default: {
                if (this.current_weapon != null && this.current_weapon[0][10] == '\u0002' && this.weapon_power >= 100) {
                    switch (this.current_weapon[0][11]) {
                        case '\u0000': {
                            this.game.draw_bordered_text(this.game.res_get_string(this.weapon_names[this.game.convertWeaponItem(18)]), this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
                        }
                    }
                }
                if (this.message == null) break;
                this.game.draw_bordered_text(this.message, this.game.slx >> 1, this.game.slyc - this.game.font_get_height(this.ingame_font), this.ingame_font, 0, 0xDD0000, true);
            }
        }
        if (this.game_state != '\u0011' && this.game_state != '\u0019') {
            this.state_tick = (char)(this.state_tick + '\u0001');
        }
        if (this.game_state != '\b' && this.game_state != '\u00fd' && this.state_tick >= ' ' || this.state_tick >= '\u0010' && this.game_state == '\u000b' || this.state_tick >= '\u0010' && this.game_state == '\u0013') {
            this.controls_message_dismiss();
        }
        if (this.game_state != '\u0011' && this.game_state != '\u0019' && this.game_state != '\u0001' && this.game_state != '\u0002' && this.game_state != '\u0003' && this.game_state != '\u0006' && this.game_state != '\u0007' && this.game_state != '\u00fe' && this.camera_target_type != '\u0000' && this.game_state != '\u00fd' && this.game_state != '\b' && this.game_state != '\t' && this.game_state != '\u0004' && this.game_state != '\u0005') {
            this.turn_timer_tick = (char)(this.turn_timer_tick + '\u0001');
            if (this.turn_timer_tick % 8 == 0 && this.turn_timer > '\u0000') {
                this.turn_timer = (char)(this.turn_timer - '\u0001');
            }
            if (this.turn_timer == '\u0000') {
                this.change_state('\u0001');
            }
        } else if ((this.game_state == '\u0011' || this.game_state == '\u0019') && this.camera_target_type == '\u0001') {
            this.turn_timer_tick = (char)(this.turn_timer_tick + '\u0001');
            if (this.turn_timer_tick % 8 == 0 && this.turn_timer > '\u0000') {
                this.turn_timer = (char)(this.turn_timer - '\u0001');
            }
            if (this.turn_timer == '\u0000') {
                this.worm_stop_movement = true;
            }
        }
        return this.controls_softkeys();
    }

    private void paint_buildings() {
        for (int b = 0; b < this.player_building_list.length; ++b) {
            this.player_building_list[b].disp(this.camera_x, this.camera_y, this.game.slx, this.game.sly, this.building_special_flags);
            this.player_building_list[b].disp_health(this.game, this.camera_x, this.camera_y);
            this.ai_building_list[b].disp(this.camera_x, this.camera_y, this.game.slx, this.game.sly, this.building_special_flags);
            this.ai_building_list[b].disp_health(this.game, this.camera_x, this.camera_y);
        }
        if (this.game_state == '\r' || this.game_state == '\u0015' || this.game_state == '\u00fe' && this.prev_state == '\u0015') {
            if (this.building != null && this.building_type != '\t') {
                this.building.disp(this.building_map_x * this.game.bkgnd_clx - this.camera_x, this.building_map_y * this.game.bkgnd_cly - this.camera_y, 0, 0);
                this.tick_cross.disp(this.building_map_x * this.game.bkgnd_clx - this.camera_x + (this.building.lx >> 1) - (this.tick_cross.lx >> 1), this.building_map_y * this.game.bkgnd_cly - this.camera_y + (this.building.ly >> 1) - (this.tick_cross.ly >> 1), this.building_ok ? 1 : 0, 0);
                if (this.building == this.building_special) {
                    int xOffset = 18;
                    int yOffset = 0;
                    switch (scheme) {
                        case '\u0001': {
                            xOffset = 22;
                            yOffset = -5;
                            break;
                        }
                        case '\u0002': {
                            xOffset = 26;
                            yOffset = -10;
                            break;
                        }
                        case '\u0003': {
                            xOffset = -6;
                            yOffset = 0;
                        }
                    }
                    switch (this.menu_selection) {
                        case 6: {
                            this.building_special_flags.disp(this.building_map_x * this.game.bkgnd_clx - this.camera_x + xOffset, this.building_map_y * this.game.bkgnd_cly - this.camera_y + yOffset, 2, 0);
                            break;
                        }
                        case 5: {
                            this.building_special_flags.disp(this.building_map_x * this.game.bkgnd_clx - this.camera_x + xOffset, this.building_map_y * this.game.bkgnd_cly - this.camera_y + yOffset, 1, 0);
                            break;
                        }
                        case 7: {
                            this.building_special_flags.disp(this.building_map_x * this.game.bkgnd_clx - this.camera_x + xOffset, this.building_map_y * this.game.bkgnd_cly - this.camera_y + yOffset, 3, 0);
                            break;
                        }
                        case 8: {
                            this.building_special_flags.disp(this.building_map_x * this.game.bkgnd_clx - this.camera_x + xOffset, this.building_map_y * this.game.bkgnd_cly - this.camera_y + yOffset, 4, 0);
                            break;
                        }
                        case 4: {
                            this.building_special_flags.disp(this.building_map_x * this.game.bkgnd_clx - this.camera_x + xOffset, this.building_map_y * this.game.bkgnd_cly - this.camera_y + yOffset, 0, 0);
                        }
                    }
                }
            } else if (this.building_type == '\t') {
                int rows = 0;
                int cols = 0;
                switch (this.foundation_state) {
                    case '\u0000': {
                        rows = 2;
                        cols = 2;
                        break;
                    }
                    case '\u0001': {
                        rows = 2;
                        cols = 3;
                        break;
                    }
                    case '\u0002': {
                        rows = 3;
                        cols = 4;
                    }
                }
                for (int r = 0; r < rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        if (r != 0) {
                            this.game.disp_tile((this.building_map_x + c) * this.game.bkgnd_clx - this.camera_x, (this.building_map_y + r + this.foundation_y_offset) * this.game.bkgnd_cly - this.camera_y, 11);
                            continue;
                        }
                        this.game.disp_tile((this.building_map_x + c) * this.game.bkgnd_clx - this.camera_x, (this.building_map_y + r + this.foundation_y_offset) * this.game.bkgnd_cly - this.camera_y, 10);
                    }
                }
            }
        }
    }

    private void paint_worms() {
        int w;
        for (w = 0; w < this.player_worm.length; ++w) {
            if (this.player_worm[w] == this.current_worm && this.players_turn) continue;
            this.player_worm[w].disp(this.camera_x, this.camera_y);
            this.player_worm[w].disp_health(this.camera_x, this.camera_y, 0, 56576);
        }
        for (w = 0; w < this.ai_worm.length; ++w) {
            if (this.ai_worm[w] == this.current_worm && !this.players_turn) continue;
            this.ai_worm[w].disp(this.camera_x, this.camera_y);
            this.ai_worm[w].disp_health(this.camera_x, this.camera_y, 0, 0xDD0000);
        }
        if (this.current_worm != null) {
            if (this.game_state == '\u0010' || this.game_state == '\u000f' || this.game_state == '\u0018' || this.game_state == '\u0017') {
                if (this.current_weapon != null) {
                    int weap_frame = 0;
                    if (this.current_weapon[0][6] == '\f') {
                        weap_frame = 2;
                    }
                    if (this.current_worm.worm_anim.res_index == this.worm_anim[3].res_index) {
                        this.weapon_anim[this.current_weapon[0][6]].disp(this.current_worm.x - this.camera_x - (this.weapon_anim[this.current_weapon[0][6]].lx >> 1) - 3, this.current_worm.y - this.camera_y - (this.weapon_anim[this.current_weapon[0][6]].ly >> 1) - 1, weap_frame, 0);
                        this.current_worm.disp(this.camera_x, this.camera_y);
                    } else {
                        this.current_worm.disp(this.camera_x, this.camera_y);
                    }
                }
            } else {
                this.current_worm.disp(this.camera_x, this.camera_y);
            }
            if (this.game_state == '\n' || this.game_state == '\u0012' || this.game_state == '\t' || this.game_state == '\u00fe' && this.prev_state == '\n' || this.game_state == '\u00fe' && this.prev_state == '\u0012') {
                this.current_worm.disp_health(this.camera_x, this.camera_y, 0, 0xFD4DFF);
            } else {
                this.current_worm.disp_health(this.camera_x, this.camera_y, 0, 9242507);
            }
        }
    }

    private void paint_crates() {
        for (int c = 0; c < this.player_crate_active.length; ++c) {
            if (this.player_crate_active[c]) {
                this.crate.disp((this.player_crate_fpx[c] >> 8) - this.camera_x, (this.player_crate_fpy[c] >> 8) - this.camera_y, 0, 1);
                if (this.crate_fpvy == 512 && this.crate_falling == c) {
                    this.crate.disp((this.player_crate_fpx[c] >> 8) - this.camera_x, (this.player_crate_fpy[c] >> 8) - this.camera_y - this.crate.ly, 0, 0);
                }
            }
            if (!this.ai_crate_active[c]) continue;
            this.crate.disp((this.ai_crate_fpx[c] >> 8) - this.camera_x, (this.ai_crate_fpy[c] >> 8) - this.camera_y, 0, 1);
            if (this.crate_fpvy != 512 || this.crate_falling != c) continue;
            this.crate.disp((this.ai_crate_fpx[c] >> 8) - this.camera_x, (this.ai_crate_fpy[c] >> 8) - this.camera_y - this.crate.ly, 0, 0);
        }
    }

    private void paint_weapons(int w) {
        int x = this.weapon_fpx[w] >> 8;
        int y = this.weapon_fpy[w] >> 8;
        if (this.current_weapon[w][4] > '\u0000') {
            if (this.current_weapon[w][10] == '\u0002' && (this.current_weapon[w][11] == '\u0001' || this.current_weapon[w][11] == '\u0002')) {
                this.game.draw_bordered_text("" + (this.current_weapon[w][4] - this.weapon_fuse), this.game.slx >> 1, this.game.sly >> 1, this.ingame_font, 0, 0xDD0000, false);
            } else if ((this.current_weapon[w][10] != '\u0002' || this.current_weapon[w][11] == '\u0002') && this.current_weapon[w][6] != '\u0002' && this.current_weapon[w][6] != '\b') {
                if (this.game_state != '\u00fe') {
                    this.game.draw_bordered_text("" + (this.current_weapon[w][4] - this.weapon_fuse), x - this.camera_x, y - this.camera_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1) - this.game.font_get_height(this.ingame_font), this.ingame_font, 0, 0xDD0000, false);
                } else {
                    this.game.draw_bordered_text("" + (this.current_weapon[w][4] - this.weapon_fuse), x - this.camera_x - (this.weapon_fpvx[w] >> 8), y - this.camera_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1) - this.game.font_get_height(this.ingame_font) - (this.weapon_fpvy[w] >> 8), this.ingame_font, 0, 0xDD0000, false);
                }
            }
        }
        if (this.game_state != '\u00fe') {
            if (this.current_weapon[w][6] != 'b') {
                this.weapon_anim[this.current_weapon[w][6]].disp(x - this.camera_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1), y - this.camera_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1), this.weapon_frame[w], this.weapon_fpvx[w] < 0 ? 1 : 0);
            }
        } else if (this.current_weapon[w][6] != 'b') {
            this.weapon_anim[this.current_weapon[w][6]].disp(x - this.camera_x - (this.weapon_anim[this.current_weapon[w][6]].lx >> 1) - (this.weapon_fpvx[w] >> 8), y - this.camera_y - (this.weapon_anim[this.current_weapon[w][6]].ly >> 1) - (this.weapon_fpvy[w] >> 8), this.weapon_frame[w], this.weapon_fpvx[w] < 0 ? 1 : 0);
        }
    }

    private int controls_softkeys() {
        int return_state = 0;
        if (this.game_state != '\u0000') {
            if (this.game.g_press == 11) {
                if (this.game_type == '\u0001') {
                    switch (this.game_state) {
                        case '\u0014': 
                        case '\u0016': {
                            this.change_state('\u0013');
                            return return_state;
                        }
                        case '\u0015': {
                            if (this.camera_target_type == '\u0000') {
                                this.switch_view();
                            }
                            this.change_state('\u0014');
                            return return_state;
                        }
                        case '\u0017': 
                        case '\u001c': {
                            if (this.camera_target_type == '\u0000') {
                                this.switch_view();
                            }
                            this.change_state('\u0016');
                            return return_state;
                        }
                    }
                }
                switch (this.game_state) {
                    case '\f': 
                    case '\u000e': {
                        this.change_state('\u000b');
                        break;
                    }
                    case '\r': {
                        if (this.camera_target_type == '\u0000') {
                            this.switch_view();
                        }
                        this.change_state('\f');
                        break;
                    }
                    case '\u000f': 
                    case '\u001b': {
                        if (this.camera_target_type == '\u0000') {
                            this.switch_view();
                        }
                        this.change_state('\u000e');
                        break;
                    }
                    case '\u00fe': {
                        if (this.message == null) {
                            this.message = this.message_quit_question;
                            break;
                        }
                        this.resume_game();
                        break;
                    }
                    default: {
                        this.pause_game();
                        this.message = this.message_quit_question;
                        break;
                    }
                }
            } else if (this.game.g_press == 10) {
                if (this.game_type == '\u0001') {
                    switch (this.game_state) {
                        case '\u0014': {
                            if (this.ai_building_menu.item_selectable((char)this.ai_building_menu.get_menu_choice(), false)) {
                                this.change_state('\u0015');
                            }
                            return return_state;
                        }
                        case '\u0016': {
                            if (this.ai_weapon_menu.item_selectable((char)this.ai_weapon_menu.get_menu_choice(), false)) {
                                this.change_state('\u0017');
                            }
                            return return_state;
                        }
                        case '\u0015': {
                            this.change_state(this.place_building());
                            return return_state;
                        }
                        case '\u0017': {
                            this.pause_game();
                            return return_state;
                        }
                        case '\u001b': {
                            this.change_state('\u0017');
                        }
                    }
                }
                switch (this.game_state) {
                    case '\f': {
                        if (!this.player_building_menu.item_selectable((char)this.player_building_menu.get_menu_choice(), false)) break;
                        this.change_state('\r');
                        break;
                    }
                    case '\u000e': {
                        if (!this.player_weapon_menu.item_selectable((char)this.player_weapon_menu.get_menu_choice(), false)) break;
                        this.change_state('\u000f');
                        break;
                    }
                    case '\r': {
                        this.change_state(this.place_building());
                        break;
                    }
                    case '\u00fe': {
                        if (this.message == null || !this.message.equals(this.message_quit_question)) {
                            this.resume_game();
                            break;
                        }
                        return_state = 2;
                        break;
                    }
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0007': 
                    case '\b': 
                    case '\t': {
                        this.controls_message_dismiss();
                        break;
                    }
                    case '\u001b': {
                        this.change_state('\u000f');
                        break;
                    }
                    default: {
                        this.pause_game();
                    }
                }
            }
        }
        return return_state;
    }

    private void switch_view() {
        if (this.camera_target_type == '\u0001') {
            this.camera_target_type = '\u0000';
        } else if (this.camera_target_type == '\u0000') {
            this.camera_target_type = '\u0001';
        }
        this.game.reset_keys();
    }

    /*
     * Unable to fully structure code
     */
    private void controls() {
        block72: {
            block71: {
                if (this.game_state == '\u0001') {
                    return;
                }
                if ((this.game.get_kb_state() & 256) != 0 && (this.game_state == '\u000b' || this.game_state == '\n' || this.game_state == '\u000f' || (this.game_state == '\u0013' || this.game_state == '\u0012' || this.game_state == '\u0017') && this.game_type == '\u0001')) {
                    this.switch_view();
                }
                if (this.camera_target_type != '\u0001') break block71;
                block0 : switch (this.game_state) {
                    case '\n': {
                        this.controls_player_select_worm();
                        break;
                    }
                    case '\u000b': {
                        this.controls_player_move_worm();
                        break;
                    }
                    case '\u0011': {
                        if (this.worm_stop_movement) break;
                        this.controls_player_move_worm();
                        break;
                    }
                    case '\f': {
                        this.controls_player_choose_building();
                        break;
                    }
                    case '\u000e': {
                        this.controls_player_choose_weapon();
                        break;
                    }
                    case '\u000f': {
                        this.controls_player_choose_angle();
                        break;
                    }
                    case '\u0010': {
                        this.controls_player_choose_power();
                        break;
                    }
                    case '\u0012': {
                        switch (this.game_type) {
                            case '\u0000': {
                                this.controls_ai_select_worm();
                                break block0;
                            }
                            case '\u0001': {
                                this.controls_player_select_worm();
                            }
                        }
                        break;
                    }
                    case '\u0013': {
                        switch (this.game_type) {
                            case '\u0000': {
                                this.controls_ai_move_worm();
                                break block0;
                            }
                            case '\u0001': {
                                if (this.worm_stop_movement) break;
                                this.controls_player_move_worm();
                            }
                        }
                        break;
                    }
                    case '\u0014': {
                        switch (this.game_type) {
                            case '\u0000': {
                                this.controls_ai_choose_building();
                                break block0;
                            }
                            case '\u0001': {
                                this.controls_player_choose_building();
                            }
                        }
                        break;
                    }
                    case '\u0016': {
                        switch (this.game_type) {
                            case '\u0000': {
                                this.controls_ai_choose_weapon();
                                break block0;
                            }
                            case '\u0001': {
                                this.controls_player_choose_weapon();
                            }
                        }
                        break;
                    }
                    case '\u0017': {
                        switch (this.game_type) {
                            case '\u0000': {
                                this.controls_ai_fire_weapon();
                                break block0;
                            }
                            case '\u0001': {
                                this.controls_player_choose_angle();
                            }
                        }
                        break;
                    }
                    case '\u0018': {
                        switch (this.game_type) {
                            case '\u0000': {
                                this.controls_ai_choose_power();
                                break block0;
                            }
                            case '\u0001': {
                                this.controls_player_choose_power();
                            }
                        }
                        break;
                    }
                    case '\u0019': {
                        if (this.game_type != '\u0001' || this.worm_stop_movement) break;
                        this.controls_player_move_worm();
                        break;
                    }
                    case '\t': {
                        if ((this.game.get_kb_state() & 1) != 0) ** GOTO lbl91
                        if ((this.game.get_kb_state() & 2) != 0) ** GOTO lbl91
                        if ((this.game.get_kb_state() & 4) != 0) ** GOTO lbl91
                        if ((this.game.get_kb_state() & 8) == 0) ** GOTO lbl93
lbl91:
                        // 4 sources

                        this.controls_message_dismiss();
                        this.game.reset_keys();
                    }
lbl93:
                    // 3 sources

                    case '\u0002': 
                    case '\u0003': 
                    case '\u0007': 
                    case '\b': {
                        if ((this.game.get_kb_state() & 16) == 0) break;
                        this.controls_message_dismiss();
                        this.game.reset_keys();
                        break;
                    }
                    case '\u001b': {
                        this.controls_player_pick_target();
                        break;
                    }
                    case '\u001c': {
                        switch (this.game_type) {
                            case '\u0001': {
                                this.controls_player_pick_target();
                            }
                        }
                    }
                }
                break block72;
            }
            switch (this.game_state) {
                case '\r': {
                    this.controls_player_place_building();
                    break;
                }
                case '\u0015': {
                    switch (this.game_type) {
                        case '\u0000': {
                            this.controls_ai_place_building();
                            break;
                        }
                        case '\u0001': {
                            this.controls_player_place_building();
                        }
                    }
                    break;
                }
                case '\u0011': {
                    this.controls_player_afterfire();
                    break;
                }
                case '\u0019': {
                    switch (this.game_type) {
                        case '\u0000': {
                            this.controls_ai_afterfire();
                            break;
                        }
                        case '\u0001': {
                            this.controls_player_afterfire();
                        }
                    }
                    break;
                }
                case '\t': {
                    if ((this.game.get_kb_state() & 1) != 0) ** GOTO lbl142
                    if ((this.game.get_kb_state() & 2) != 0) ** GOTO lbl142
                    if ((this.game.get_kb_state() & 4) != 0) ** GOTO lbl142
                    if ((this.game.get_kb_state() & 8) == 0) ** GOTO lbl144
lbl142:
                    // 4 sources

                    this.controls_message_dismiss();
                    this.game.reset_keys();
                }
lbl144:
                // 3 sources

                case '\u0002': 
                case '\u0003': 
                case '\u0007': 
                case '\b': {
                    if ((this.game.get_kb_state() & 16) == 0) break;
                    this.controls_message_dismiss();
                    this.game.reset_keys();
                }
            }
        }
    }

    private void controls_message_dismiss() {
        if (this.state_tick >= '\u0004') {
            switch (this.game_state) {
                case '\u0002': {
                    if (this.message.indexOf(10) != -1) {
                        if (this.message.substring(0, this.message.indexOf(10) - 1).equals(this.message_game_won.substring(0, this.message.indexOf(10) - 1))) {
                            this.change_state('\u0005');
                        } else {
                            this.message = this.message_game_won;
                            this.add_name_to_message(this.player_name);
                        }
                    } else {
                        this.message = this.message_game_won;
                        this.add_name_to_message(this.player_name);
                    }
                    this.state_tick = '\u0000';
                    break;
                }
                case '\u0003': {
                    if (this.game_type == '\u0000') {
                        if (this.message.equals(this.message_game_over)) {
                            this.change_state('\u0004');
                        } else {
                            this.message = this.message_game_over;
                        }
                    } else if (this.message.substring(0, this.message.indexOf(10)).equals(this.message_game_won.substring(0, this.message.indexOf(10)))) {
                        this.change_state('\u0004');
                    } else {
                        this.message = this.message_game_won;
                        this.add_name_to_message(this.ai_name);
                    }
                    this.state_tick = '\u0000';
                    break;
                }
                case '\u0007': {
                    this.change_state('\u0001');
                    break;
                }
                case '\b': {
                    if (this.crate_falling != -1) {
                        this.change_state('\u00fd');
                        break;
                    }
                    this.change_state('\t');
                    break;
                }
                case '\u00fd': {
                    this.change_state('\t');
                    break;
                }
                case '\t': {
                    if (this.players_turn) {
                        this.change_state('\n');
                    } else {
                        this.change_state('\u0012');
                    }
                    this.message = null;
                    break;
                }
                case '\u000b': 
                case '\u0013': {
                    this.message = null;
                }
            }
        }
    }

    private void controls_player_select_worm() {
        if (this.game.frame % 8 == 0 || this.game.key_released) {
            if ((this.game.get_kb_state() & 4) != 0) {
                int new_target;
                char old_target = this.target_worm;
                this.target_worm = this.target_worm > '\u0000' ? (char)(this.target_worm - '\u0001') : (char)(this.player_worm.length - 1);
                if (this.players_turn) {
                    for (new_target = this.target_worm; new_target >= 0 && this.player_worm[new_target].health <= 0; --new_target) {
                    }
                } else {
                    while (new_target >= 0 && this.ai_worm[new_target].health <= 0) {
                        --new_target;
                    }
                }
                this.target_worm = new_target < 0 ? (char)old_target : (char)new_target;
                this.current_worm = this.players_turn ? this.player_worm[this.target_worm] : this.ai_worm[this.target_worm];
            } else if ((this.game.get_kb_state() & 8) != 0) {
                char old_target = this.target_worm;
                this.target_worm = this.target_worm < '\u0003' ? (char)(this.target_worm + '\u0001') : (char)'\u0000';
                if (this.players_turn) {
                    while (this.target_worm <= '\u0003' && this.player_worm[this.target_worm].health <= 0) {
                        this.target_worm = (char)(this.target_worm + '\u0001');
                    }
                } else {
                    while (this.target_worm <= '\u0003' && this.ai_worm[this.target_worm].health <= 0) {
                        this.target_worm = (char)(this.target_worm + '\u0001');
                    }
                }
                if (this.target_worm > '\u0003') {
                    this.target_worm = old_target;
                }
                this.current_worm = this.players_turn ? this.player_worm[this.target_worm] : this.ai_worm[this.target_worm];
            }
        }
        if ((this.game.get_kb_state() & 0x10) != 0) {
            if (this.players_turn) {
                this.change_state('\u000b');
            } else {
                this.change_state('\u0013');
            }
            this.game.reset_keys();
        }
    }

    private void controls_player_move_worm() {
        if (this.game.key_released && !this.current_worm.falling) {
            this.current_worm.frame = '\u0000';
        }
        if (!this.fling_worms && this.current_worm.falling || this.current_worm.worm_anim.res_index == this.worm_anim[1].res_index) {
            this.current_worm.fall();
        } else if ((this.game.get_kb_state() & 4) != 0) {
            this.current_worm.dir = true;
            this.current_worm.move(-Worm.SPEED_FP, 0);
        } else if ((this.game.get_kb_state() & 8) != 0) {
            this.current_worm.dir = false;
            this.current_worm.move(Worm.SPEED_FP, 0);
        } else if ((this.game.get_kb_state() & 1) != 0) {
            boolean collided = false;
            if (!this.current_worm.on_building) {
                if (this.players_turn) {
                    for (int b = 0; b < this.player_building_list.length; ++b) {
                        if (!this.player_building_list[b].check_collision(this.current_worm.x, this.current_worm.x, false, false, 0, 0)) continue;
                        collided = true;
                        break;
                    }
                } else {
                    for (int b = 0; b < this.ai_building_list.length; ++b) {
                        if (!this.ai_building_list[b].check_collision(this.current_worm.x, this.current_worm.x, false, false, 0, 0)) continue;
                        collided = true;
                        break;
                    }
                }
                if (collided) {
                    this.current_worm.climb_building();
                } else {
                    this.current_worm.start_jump(true);
                    this.current_worm.on_building = false;
                    this.game.hdl_sound(90);
                }
            } else {
                this.current_worm.start_jump(true);
                this.current_worm.on_building = false;
                this.game.hdl_sound(90);
            }
            this.game.reset_keys();
        } else if (this.game_state == '\u000b' || this.game_state == '\u0013') {
            if ((this.game.get_kb_state() & 2) != 0) {
                this.current_worm.start_jump(false);
                this.game.reset_keys();
                this.game.hdl_sound(90);
            } else if ((this.game.get_kb_state() & 0x10) != 0) {
                if (this.current_worm.on_building) {
                    if (this.players_turn) {
                        this.change_state('\u000e');
                    } else {
                        this.change_state('\u0016');
                    }
                } else if (this.players_turn) {
                    this.change_state('\f');
                } else {
                    this.change_state('\u0014');
                }
                this.game.reset_keys();
            }
        }
    }

    private void controls_player_choose_building() {
        if (this.game.frame % 8 == 0 || this.game.key_released) {
            if ((this.game.get_kb_state() & 4) != 0) {
                if (this.players_turn) {
                    this.player_building_menu.move(-1, 0);
                } else {
                    this.ai_building_menu.move(-1, 0);
                }
            } else if ((this.game.get_kb_state() & 8) != 0) {
                if (this.players_turn) {
                    this.player_building_menu.move(1, 0);
                } else {
                    this.ai_building_menu.move(1, 0);
                }
            } else if ((this.game.get_kb_state() & 1) != 0) {
                if (this.players_turn) {
                    this.player_building_menu.move(0, -1);
                } else {
                    this.ai_building_menu.move(0, -1);
                }
            } else if ((this.game.get_kb_state() & 2) != 0) {
                if (this.players_turn) {
                    this.player_building_menu.move(0, 1);
                } else {
                    this.ai_building_menu.move(0, 1);
                }
            } else if ((this.game.get_kb_state() & 0x10) != 0) {
                if (this.players_turn) {
                    if (this.player_building_menu.item_selectable((char)this.player_building_menu.get_menu_choice(), false)) {
                        this.change_state('\r');
                    }
                } else if (this.ai_building_menu.item_selectable((char)this.ai_building_menu.get_menu_choice(), false)) {
                    this.change_state('\u0015');
                }
                this.game.reset_keys();
            } else if ((this.game.get_kb_state() & 0x40) != 0) {
                if (this.players_turn) {
                    this.change_state('\u000b');
                } else {
                    this.change_state('\u0013');
                }
                this.game.reset_keys();
            }
        }
    }

    private void controls_player_choose_weapon() {
        if (this.game.frame % 8 == 0 || this.game.key_released) {
            if ((this.game.get_kb_state() & 4) != 0) {
                if (this.players_turn) {
                    this.player_weapon_menu.move(-1, 0);
                } else {
                    this.ai_weapon_menu.move(-1, 0);
                }
            } else if ((this.game.get_kb_state() & 8) != 0) {
                if (this.players_turn) {
                    this.player_weapon_menu.move(1, 0);
                } else {
                    this.ai_weapon_menu.move(1, 0);
                }
            } else if ((this.game.get_kb_state() & 1) != 0) {
                if (this.players_turn) {
                    this.player_weapon_menu.move(0, -1);
                } else {
                    this.ai_weapon_menu.move(0, -1);
                }
            } else if ((this.game.get_kb_state() & 2) != 0) {
                if (this.players_turn) {
                    this.player_weapon_menu.move(0, 1);
                } else {
                    this.ai_weapon_menu.move(0, 1);
                }
            } else if ((this.game.get_kb_state() & 0x10) != 0) {
                if (this.players_turn) {
                    if (this.player_weapon_menu.item_selectable((char)this.player_weapon_menu.get_menu_choice(), false)) {
                        this.change_state('\u000f');
                    }
                } else if (this.ai_weapon_menu.item_selectable((char)this.ai_weapon_menu.get_menu_choice(), false)) {
                    this.change_state('\u0017');
                }
                this.game.reset_keys();
            } else if ((this.game.get_kb_state() & 0x40) != 0) {
                if (this.players_turn) {
                    this.change_state('\u000b');
                } else {
                    this.change_state('\u0013');
                }
                this.game.reset_keys();
            }
        }
    }

    private void controls_player_choose_angle() {
        if ((this.game.get_kb_state() & 4) != 0) {
            this.current_worm.dir = true;
        } else if ((this.game.get_kb_state() & 8) != 0) {
            this.current_worm.dir = false;
        } else if ((this.game.get_kb_state() & 1) != 0) {
            if (this.crosshair_y < 8960) {
                this.crosshair_y += 256;
                int a = 313600;
                this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
            }
        } else if ((this.game.get_kb_state() & 2) != 0) {
            if (this.crosshair_y > 0) {
                this.crosshair_y -= 256;
                int a = 313600;
                this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
            }
        } else if ((this.game.get_kb_state() & 0x10) != 0) {
            if (this.players_turn) {
                this.change_state('\u0010');
            } else {
                this.change_state('\u0018');
            }
        } else if ((this.game.get_kb_state() & 0x40) != 0) {
            if (this.players_turn) {
                this.change_state('\u000e');
            } else {
                this.change_state('\u0016');
            }
            this.current_worm.set_anim(0);
            this.game.reset_keys();
        }
        this.current_worm.frame = this.current_weapon[0][9] > '\u0000' ? (this.crosshair_y <= 2560 ? (char)'\u0000' : (this.crosshair_y >= 8320 ? (char)2 : (char)'\u0001')) : (char)'\u0000';
    }

    private void controls_player_choose_power() {
        if ((this.game.get_kb_state() & 0x10) != 0) {
            this.weapon_power += 5;
            this.fire_pressed = true;
            if (this.current_weapon[0][5] > '\u0000') {
                this.weapon_power = 100;
            }
        }
        if (this.weapon_power >= 100 || this.fire_pressed && this.game.key_released) {
            if (this.players_turn) {
                this.change_state('\u0011');
            } else {
                this.change_state('\u0019');
            }
            this.game.hdl_sound(92);
            this.game.reset_keys();
        }
    }

    private void controls_player_place_building() {
        if (this.game.frame % 8 == 0 || this.game.key_released) {
            if ((this.game.get_kb_state() & 4) != 0) {
                this.move_building(true);
            } else if ((this.game.get_kb_state() & 8) != 0) {
                this.move_building(false);
            } else if ((this.game.get_kb_state() & 0x10) != 0 && this.game.key_released) {
                this.change_state(this.place_building());
            } else if ((this.game.get_kb_state() & 0x40) != 0) {
                if (this.players_turn) {
                    this.change_state('\f');
                } else {
                    this.change_state('\u0014');
                }
            } else if ((this.game.get_kb_state() & 1) != 0) {
                switch (this.foundation_state) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': {
                        if (this.foundation_y_offset <= 0) break;
                        --this.foundation_y_offset;
                    }
                }
                this.check_building();
            } else if ((this.game.get_kb_state() & 2) != 0) {
                switch (this.foundation_state) {
                    case '\u0000': 
                    case '\u0001': {
                        if (this.foundation_y_offset >= 2) break;
                        ++this.foundation_y_offset;
                        break;
                    }
                    case '\u0002': {
                        if (this.foundation_y_offset >= 3) break;
                        ++this.foundation_y_offset;
                    }
                }
                this.check_building();
            }
        } else if ((this.game.get_kb_state() & 0x80) != 0 && this.building_type == '\t') {
            this.foundation_state = (char)(this.foundation_state + '\u0001');
            if (this.foundation_state > '\u0002') {
                this.foundation_state = '\u0000';
            }
            this.move_building(true);
            this.move_building(false);
            this.game.reset_keys();
        }
    }

    private void controls_player_afterfire() {
        block11: {
            block10: {
                if ((this.game.get_kb_state() & 1) != 0) break block10;
                if ((this.game.get_kb_state() & 2) != 0) break block10;
                if ((this.game.get_kb_state() & 4) != 0) break block10;
                if ((this.game.get_kb_state() & 8) == 0) break block11;
            }
            if (this.current_weapon[0][10] == '\u0004' || this.current_weapon[0][10] == '\u0005') {
                if ((this.game.get_kb_state() & 1) != 0) {
                    if (this.crosshair_y < 8960) {
                        this.crosshair_y += 256;
                        int a = 313600;
                        this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
                    }
                } else if ((this.game.get_kb_state() & 2) != 0 && this.crosshair_y > 0) {
                    this.crosshair_y -= 256;
                    int a = 313600;
                    this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
                }
            } else if (!this.worm_stop_movement) {
                this.camera_target_type = '\u0001';
                this.current_worm.set_anim(0);
                this.turn_timer_tick = '\u0000';
                this.turn_timer = (char)5;
            }
        }
    }

    private void controls_player_pick_target() {
        if ((this.game.get_kb_state() & 8) != 0) {
            this.move_target(false);
        } else if ((this.game.get_kb_state() & 4) != 0) {
            this.move_target(true);
        } else if ((this.game.get_kb_state() & 0x10) != 0) {
            this.game.reset_keys();
            if (this.players_turn) {
                this.change_state('\u000f');
            } else {
                this.change_state('\u0017');
            }
        }
    }

    private boolean ai_build_or_attack() {
        int b;
        boolean continue_checking = false;
        this.ai_building_menu.open(-1);
        if (!this.ai_stronghold_placed) {
            return true;
        }
        for (b = 0; b < this.ai_building_list.length; ++b) {
            if (this.ai_building_list[b].building_type != 4) continue;
            continue_checking = true;
            break;
        }
        if (continue_checking) {
            continue_checking = false;
            for (b = 0; b < 9; b = (char)(b + '\u0001')) {
                if (!this.ai_building_menu.item_selectable((char)b, false)) continue;
                continue_checking = true;
                break;
            }
            if (continue_checking) {
                continue_checking = false;
                for (b = 0; b < this.ai_building_list.length; ++b) {
                    if (this.ai_building_list[b].building_anim != null) continue;
                    continue_checking = true;
                    break;
                }
                if (continue_checking) {
                    continue_checking = false;
                    for (b = 0; b < this.ai_building_list.length; ++b) {
                        if (this.ai_building_list[b].building_anim == null || this.ai_building_list[b].building_type == 4) continue;
                        continue_checking = true;
                        break;
                    }
                    if (!continue_checking) {
                        return true;
                    }
                    int build = this.game.random.nextInt() % 100;
                    if (build < 0) {
                        build *= -1;
                    }
                    if (this.wind_value >= 160 || build <= 20) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void controls_ai_select_worm() {
        int c;
        int temp = 0;
        this.ai_worm_building = this.ai_build_or_attack();
        if (this.ai_worm_building) {
            this.ai_building_ok = false;
            temp = this.game.random.nextInt() % this.ai_worm.length;
            if (temp < 0) {
                temp *= -1;
            }
            this.target_worm = (char)99;
            for (int c2 = 0; c2 < this.ai_worm.length; ++c2) {
                if (this.ai_worm[temp].health > 0 && !this.ai_worm[temp].on_building) {
                    this.target_worm = (char)temp;
                    break;
                }
                temp = this.game.random.nextInt() % this.ai_worm.length;
                if (temp >= 0) continue;
                temp *= -1;
            }
            if (this.target_worm == 'c') {
                this.target_worm = this.get_first_worm();
            }
            if (this.target_worm == 'c') {
                this.change_state('\u0001');
                return;
            }
            this.change_state('\u0013');
            return;
        }
        this.ai_building_move = 99;
        this.menu_selection = -1;
        temp = this.game.random.nextInt();
        if (temp < 0) {
            temp *= -1;
            for (c = 0; c < this.ai_crate_active.length; ++c) {
                if (!this.ai_crate_active[c]) continue;
                temp *= -1;
                break;
            }
            if (temp < 0) {
                temp = this.game.random.nextInt() % this.ai_crate_active.length;
                if (temp > 0) {
                    temp *= -1;
                }
                for (c = 0; c < this.ai_crate_active.length; ++c) {
                    if (this.ai_crate_active[-temp]) {
                        this.ai_building_move = c;
                        break;
                    }
                    temp = this.game.random.nextInt() % this.ai_crate_active.length;
                    if (temp <= 0) continue;
                    temp *= -1;
                }
                if (this.ai_building_move == 99) {
                    temp = 0;
                }
            }
        }
        if (temp >= 0) {
            this.ai_building_move = this.get_ai_building();
            if (this.ai_building_move == 99) {
                return;
            }
        }
        this.target_worm = (char)99;
        if (this.ai_building_move >= 0) {
            for (int w = 0; w < this.ai_worm.length; ++w) {
                if (!this.ai_worm[w].on_building || !this.ai_building_list[this.ai_building_move].check_collision(this.ai_worm[w].x, this.ai_worm[w].x, false, false, 0, 0) || this.ai_worm[w].health <= 0) continue;
                this.target_worm = (char)w;
                break;
            }
        }
        if (this.target_worm == 'c') {
            temp = this.game.random.nextInt() % this.ai_worm.length;
            if (temp < 0) {
                temp *= -1;
            }
            for (c = 0; c < this.ai_worm.length; ++c) {
                if (this.ai_worm[temp].health > 0 && !this.ai_worm[temp].on_building) {
                    this.target_worm = (char)temp;
                    break;
                }
                temp = this.game.random.nextInt() % this.ai_worm.length;
                if (temp >= 0) continue;
                temp *= -1;
            }
        }
        if (this.target_worm == 'c') {
            this.target_worm = this.get_first_worm();
        }
        if (this.target_worm == 'c') {
            this.change_state('\u0001');
            return;
        }
        this.change_state('\u0013');
    }

    private int get_ai_building() {
        int ai_building_move = 99;
        int temp = this.game.random.nextInt() % this.ai_building_list.length;
        if (temp < 0) {
            temp *= -1;
        }
        for (int c = 0; c < 10; ++c) {
            if (this.ai_building_list[temp].building_type >= 0 && this.ai_building_list[temp].building_type <= 3) {
                ai_building_move = temp;
                break;
            }
            temp = this.game.random.nextInt() % this.ai_building_list.length;
            if (temp >= 0) continue;
            temp *= -1;
        }
        if (ai_building_move == 99) {
            for (int b = 1; b < this.ai_building_list.length; ++b) {
                if (this.ai_building_list[b].building_type < 0 || this.ai_building_list[b].building_type > 3) continue;
                ai_building_move = b;
                break;
            }
        }
        if (ai_building_move == 99) {
            this.change_state('\u0001');
        }
        return ai_building_move;
    }

    private void controls_ai_move_worm() {
        if (this.current_worm.falling) {
            this.current_worm.fall();
        } else if (this.current_worm.on_building && !this.ai_worm_building) {
            this.change_state('\u0016');
        } else if (!this.current_worm.on_building && this.ai_worm_building) {
            this.change_state('\u0014');
        } else if (!this.ai_worm_building) {
            if (this.ai_building_move <= 0) {
                if (this.ai_crate_active[-this.ai_building_move]) {
                    if (this.ai_crate_fpx[-this.ai_building_move] >> 8 > this.current_worm.x) {
                        int map_x = (this.current_worm.x + this.game.bkgnd_clx) / this.game.bkgnd_clx;
                        int map_y = this.current_worm.y / this.game.bkgnd_cly;
                        this.current_worm.move(Worm.SPEED_FP, 0);
                        this.current_worm.dir = false;
                        if (this.blocking_tile(this.game.getMapTile(map_x, map_y))) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        } else if (this.game.getMapTile(map_x, map_y + 1) == this.TILE_WATER_1) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        }
                    } else {
                        int map_x = (this.current_worm.x - this.game.bkgnd_clx) / this.game.bkgnd_clx;
                        int map_y = this.current_worm.y / this.game.bkgnd_cly;
                        this.current_worm.move(-Worm.SPEED_FP, 0);
                        this.current_worm.dir = true;
                        if (this.blocking_tile(this.game.getMapTile(map_x, map_y))) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        } else if (this.game.getMapTile(map_x, map_y + 1) == this.TILE_WATER_1) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        }
                    }
                } else {
                    this.ai_building_move = this.get_ai_building();
                    if (this.ai_building_move == 99) {
                        return;
                    }
                }
            } else if (!this.ai_building_list[this.ai_building_move].check_collision(this.current_worm.x, this.current_worm.x, false, false, 0, 0)) {
                if (this.ai_building_list[this.ai_building_move].building_anim != null) {
                    if (this.ai_building_list[this.ai_building_move].x > this.current_worm.x) {
                        int map_x = (this.current_worm.x + this.game.bkgnd_clx) / this.game.bkgnd_clx;
                        int map_y = this.current_worm.y / this.game.bkgnd_cly;
                        this.current_worm.move(Worm.SPEED_FP, 0);
                        this.current_worm.dir = false;
                        if (this.blocking_tile(this.game.getMapTile(map_x, map_y))) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        } else if (this.game.getMapTile(map_x, map_y + 1) == this.TILE_WATER_1) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        }
                    } else {
                        int map_x = (this.current_worm.x - this.game.bkgnd_clx) / this.game.bkgnd_clx;
                        int map_y = this.current_worm.y / this.game.bkgnd_cly;
                        this.current_worm.move(-Worm.SPEED_FP, 0);
                        this.current_worm.dir = true;
                        if (this.blocking_tile(this.game.getMapTile(map_x, map_y))) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        } else if (this.game.getMapTile(map_x, map_y + 1) == this.TILE_WATER_1) {
                            this.current_worm.start_jump(true);
                            this.game.hdl_sound(90);
                        }
                    }
                }
            } else {
                this.current_worm.climb_building();
                this.current_worm.dir = true;
            }
        } else {
            this.current_worm.move(Worm.SPEED_FP, 0);
            this.current_worm.dir = false;
        }
    }

    private boolean buildable(int item) {
        if (item == 9) {
            return false;
        }
        if (this.ai_stronghold_placed && this.ai_building_menu.item_selectable((char)item, false)) {
            if (item == 0 || item == 5 || item == 6 || item == 7 || item == 8) {
                return true;
            }
            for (int b = 0; b < this.ai_building_list.length; ++b) {
                if (this.ai_building_list[b].building_anim == null || this.ai_building_list[b].building_type != item - 1) continue;
                return true;
            }
        } else if (!this.ai_stronghold_placed && item == 4) {
            return true;
        }
        return false;
    }

    private void controls_ai_choose_building() {
        int b;
        this.building_ok = false;
        this.ai_building_ok = false;
        this.ai_building_move = 0;
        this.ai_move_count = '\u0000';
        for (b = 0; b < this.ai_building_list.length; ++b) {
            if (this.ai_building_list[b].building_anim != null) continue;
            this.ai_building_move = (char)b;
            break;
        }
        if (!this.ai_stronghold_placed || this.ai_building_move == 0) {
            this.menu_selection = 4;
        } else {
            switch (this.ai_building_move) {
                case 1: {
                    this.menu_selection = 0;
                    break;
                }
                case 2: {
                    this.menu_selection = 1;
                    break;
                }
                case 3: {
                    this.menu_selection = 2;
                    break;
                }
                case 4: {
                    this.menu_selection = this.game.random.nextInt() % 6;
                    if (this.menu_selection < 0) {
                        this.menu_selection *= -1;
                    }
                    this.menu_selection += 3;
                }
            }
            while (!this.buildable(this.menu_selection) && this.menu_selection > 0) {
                --this.menu_selection;
            }
        }
        this.ai_building_move = 99;
        for (b = 1; b < this.ai_building_list.length; ++b) {
            if (this.ai_building_list[b].building_anim != null) continue;
            this.ai_building_move = (char)(b - 1);
            break;
        }
        this.init_building();
        this.change_state('\u0015');
    }

    private void controls_ai_place_building() {
        if (this.game.frame % 2 == 0) {
            if (this.building_type == '\u0004') {
                if (this.building_ok) {
                    this.change_state(this.place_building());
                } else {
                    this.move_building(true);
                }
            } else if (this.ai_building_move < this.ai_building_list.length) {
                this.old_building = (char)this.ai_building_move;
                if (this.building_map_x < this.ai_building_list[this.ai_building_move].x / this.game.bkgnd_clx) {
                    this.move_building(false);
                } else if (this.building_map_x > this.ai_building_list[this.ai_building_move].x / this.game.bkgnd_clx) {
                    this.move_building(true);
                } else {
                    this.ai_building_move = 255;
                }
            } else {
                if (this.menu_selection == 9) {
                    if (this.ai_move_count > '\u0005' && this.building_ok) {
                        this.change_state(this.place_building());
                    } else if (this.ai_move_count > '\u001e') {
                        this.change_state('\u0001');
                    } else {
                        this.move_building(true);
                        this.ai_move_count = (char)(this.ai_move_count + '\u0001');
                        this.foundation_y_offset = this.foundation_state == '\u0002' ? 2 : 1;
                    }
                } else if (!this.building_ok && !this.ai_building_ok) {
                    this.move_building(true);
                    this.ai_move_count = (char)(this.ai_move_count + '\u0001');
                } else if (this.building_ok && !this.ai_building_ok) {
                    this.move_building(true);
                    this.ai_move_count = (char)(this.ai_move_count + '\u0001');
                    if (!this.building_ok) {
                        this.ai_building_ok = true;
                    }
                } else if (!this.building_ok && this.ai_building_ok) {
                    this.move_building(false);
                    this.ai_move_count = (char)(this.ai_move_count + '\u0001');
                } else if (this.building_ok && this.ai_building_ok) {
                    this.change_state(this.place_building());
                }
                if (this.ai_building_ok && this.ai_move_count >= '\u0014') {
                    char prev_type = this.building_type;
                    this.building_ok = false;
                    this.ai_building_ok = false;
                    this.ai_building_move = this.old_building;
                    this.ai_move_count = '\u0000';
                    if (this.menu_selection != 9) {
                        this.menu_selection = 9;
                        this.init_building();
                        this.foundation_state = prev_type == '\u0000' ? (char)'\u0000' : (prev_type == '\u0001' ? (char)'\u0001' : (char)2);
                        this.move_building(true);
                        this.move_building(false);
                    } else {
                        this.change_state('\u0001');
                        return;
                    }
                }
                if (!this.ai_building_ok && this.ai_move_count == '\n') {
                    this.ai_building_ok = true;
                    this.ai_move_count = '\u0000';
                }
            }
        }
    }

    private void controls_ai_choose_weapon() {
        int temp = 0;
        this.menu_selection = 99;
        this.ai_crosshair_y = -1;
        temp = this.game.random.nextInt() % 24;
        if (temp < 0) {
            temp *= -1;
        }
        for (int tries = 0; tries < 100; ++tries) {
            if (this.ai_weapon_menu.item_selectable((char)temp, false)) {
                this.menu_selection = (char)temp;
                break;
            }
            temp = this.game.random.nextInt() % 24;
            if (temp >= 0) continue;
            temp *= -1;
        }
        if (this.menu_selection == 99) {
            this.menu_selection = 0;
            switch (this.current_worm.building_type) {
                case '\u0001': {
                    this.menu_selection = 4;
                    break;
                }
                case '\u0002': {
                    this.menu_selection = 1;
                    break;
                }
                case '\u0003': {
                    this.menu_selection = 5;
                }
            }
        }
        if (this.menu_selection == 99) {
            this.change_state('\u0001');
        } else {
            this.change_state('\u0017');
        }
    }

    private void controls_ai_fire_weapon() {
        if (this.ai_crosshair_y < 0) {
            int c;
            this.current_worm.dir = true;
            int random_target_type = this.game.random.nextInt();
            int random_target = -1;
            int temp = 0;
            boolean continue_selection = false;
            if (random_target_type < 0) {
                int b;
                for (b = 0; b < this.player_building_list.length; ++b) {
                    if (this.player_building_list[b].building_anim == null) continue;
                    continue_selection = true;
                    break;
                }
                if (continue_selection) {
                    for (b = 0; b < this.player_building_list.length; ++b) {
                        if (this.player_building_list[b].building_type < 5 || this.player_building_list[b].building_type < 5) continue;
                        random_target = (char)b;
                        break;
                    }
                    if (random_target < 0) {
                        temp = this.game.random.nextInt() % this.player_building_list.length;
                        if (temp < 0) {
                            temp *= -1;
                        }
                        for (c = 0; c < 10; ++c) {
                            if (this.player_building_list[temp].building_anim == null) {
                                random_target = (char)temp;
                                break;
                            }
                            temp = this.game.random.nextInt() % this.player_building_list.length;
                            if (temp >= 0) continue;
                            temp *= -1;
                        }
                    }
                    if (random_target < 0) {
                        random_target_type = 0;
                    }
                } else {
                    random_target_type = 0;
                }
            }
            if (random_target_type >= 0) {
                int w;
                continue_selection = false;
                for (w = 0; w < this.player_worm.length; ++w) {
                    if (this.player_worm[w].health <= 0) continue;
                    continue_selection = true;
                    break;
                }
                if (continue_selection) {
                    temp = this.game.random.nextInt() % this.player_worm.length;
                    if (temp < 0) {
                        temp *= -1;
                    }
                    for (c = 0; c < 10; ++c) {
                        if (this.player_worm[temp].health < 0) {
                            random_target = (char)temp;
                            break;
                        }
                        temp = this.game.random.nextInt() % this.player_worm.length;
                        if (temp >= 0) continue;
                        temp *= -1;
                    }
                    if (random_target < 0) {
                        random_target = 99;
                        for (w = 0; w < this.player_worm.length; ++w) {
                            if (this.player_worm[w].health <= 0) continue;
                            random_target = (char)w;
                            break;
                        }
                        if (random_target == 99) {
                            this.change_state('\u0001');
                            return;
                        }
                    }
                } else {
                    this.change_state('\u0001');
                    return;
                }
            }
            this.ai_distance = 0L;
            int xd = 0;
            int yd = 0;
            if (random_target_type < 0) {
                switch (this.current_weapon[0][10]) {
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': {
                        this.homing_map_x = this.player_building_list[random_target].x / this.game.bkgnd_clx + this.game.random.nextInt() % 3;
                        this.homing_map_y = this.player_building_list[random_target].y / this.game.bkgnd_cly;
                    }
                }
                xd = this.current_worm.fpx - (this.player_building_list[random_target].x << 8);
                yd = this.current_worm.fpy - (this.player_building_list[random_target].y << 8);
                this.ai_distance = this.square_root(xd * xd + yd * yd);
            } else {
                switch (this.current_weapon[0][10]) {
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': {
                        this.homing_map_x = this.player_worm[random_target].x / this.game.bkgnd_clx + this.game.random.nextInt() % 3;
                        this.homing_map_y = this.player_worm[random_target].y / this.game.bkgnd_cly;
                    }
                }
                xd = this.current_worm.fpx - this.player_worm[random_target].fpx;
                yd = this.current_worm.fpy - this.player_worm[random_target].fpy;
                this.ai_distance = this.square_root(xd * xd + yd * yd);
            }
            if (this.homing_map_x < 0) {
                this.homing_map_x = 1;
            }
            switch (this.current_weapon[0][10]) {
                case '\u0002': 
                case '\u0004': 
                case '\u0005': {
                    this.crosshair_y = 0;
                    this.ai_crosshair_y = 0;
                    break;
                }
                case '\u0003': {
                    random_target = this.game.random.nextInt();
                    int random_offset = this.game.random.nextInt() % 10;
                    this.ai_crosshair_y = 6720 + random_offset;
                    break;
                }
                default: {
                    random_target = this.game.random.nextInt();
                    int random_offset = this.game.random.nextInt() % 10;
                    this.ai_crosshair_y = this.ai_distance < 102400L ? (random_target < 0 ? 1120 + random_offset : 7840 + random_offset) : (this.ai_distance < 256000L ? (random_target < 0 ? 2240 + random_offset : 6720 + random_offset) : 4480 + random_offset);
                    if (this.ai_crosshair_y <= 0) {
                        this.ai_crosshair_y = 0;
                        break;
                    }
                    if (this.ai_crosshair_y <= 8960) break;
                    this.ai_crosshair_y = 8960;
                }
            }
            int a = 313600;
            this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
        } else if (this.ai_crosshair_y != this.crosshair_y) {
            if (this.crosshair_y < this.ai_crosshair_y) {
                this.crosshair_y = this.ai_crosshair_y - this.crosshair_y < 256 ? this.ai_crosshair_y : (this.crosshair_y += 256);
            } else if (this.crosshair_y > this.ai_crosshair_y) {
                this.crosshair_y = this.crosshair_y - this.ai_crosshair_y < 256 ? this.ai_crosshair_y : (this.crosshair_y -= 256);
            }
            this.update_ai_crosshair();
        } else {
            this.ai_weapon_power = -1;
            this.weapon_power = 0;
            this.change_state('\u0018');
        }
    }

    private void update_ai_crosshair() {
        int a = 313600;
        this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
        this.current_worm.frame = this.current_weapon[0][9] > '\u0000' ? (this.crosshair_y <= 2560 ? (char)'\u0000' : (this.crosshair_y >= 8320 ? (char)2 : (char)'\u0001')) : (char)'\u0000';
    }

    private void controls_ai_choose_power() {
        if (this.ai_weapon_power < 0) {
            if (this.current_weapon[0][5] > '\u0000') {
                this.ai_weapon_power = 100;
                this.weapon_power = 100;
            } else {
                int random_target = this.game.random.nextInt() % 15;
                this.ai_weapon_power = this.ai_distance < 102400L ? 25 + random_target : (this.ai_distance < 256000L ? 50 + random_target : 85 + random_target);
                if (this.ai_weapon_power <= 0) {
                    this.ai_weapon_power = 10;
                } else if (this.ai_weapon_power > 100) {
                    this.ai_weapon_power = 100;
                }
                if (this.ai_weapon_power % 5 != 0) {
                    this.ai_weapon_power += 5 - this.ai_weapon_power % 5;
                }
            }
        } else if (this.ai_weapon_power != this.weapon_power) {
            if (this.weapon_power < this.ai_weapon_power) {
                this.weapon_power = this.ai_weapon_power - this.weapon_power < 5 ? this.ai_weapon_power : (this.weapon_power += 5);
            } else if (this.weapon_power > this.ai_weapon_power) {
                this.weapon_power = this.ai_weapon_power;
            }
        } else {
            this.game.hdl_sound(92);
            this.change_state('\u0019');
        }
    }

    private void controls_ai_afterfire() {
        if (this.current_weapon != null && (this.current_weapon[0][10] == '\u0005' || this.current_weapon[0][10] == '\u0004')) {
            for (int w = 0; w < this.weapon_fpy.length; ++w) {
                int a;
                if (this.weapon_fpy[w] >> 8 < this.homing_map_y * this.game.bkgnd_cly) {
                    if (this.crosshair_y <= 0) continue;
                    this.crosshair_y -= 256;
                    a = 313600;
                    this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
                    continue;
                }
                if (this.weapon_fpy[w] >> 8 <= this.homing_map_y * this.game.bkgnd_cly || this.crosshair_y >= 8960) continue;
                this.crosshair_y += 256;
                a = 313600;
                this.crosshair_x = (int)this.square_root(a -= this.crosshair_y * this.crosshair_y >> 8) >> 8;
            }
        }
    }

    private void init_building() {
        this.building_type = (char)this.menu_selection;
        switch (this.building_type) {
            case '\u0004': {
                this.building = this.building_special;
                break;
            }
            case '\u0000': {
                this.building = this.building_tower;
                break;
            }
            case '\u0001': {
                this.building = this.building_keep;
                break;
            }
            case '\u0002': {
                this.building = this.building_special;
                break;
            }
            case '\u0003': {
                this.building = this.building_citadel;
                break;
            }
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': {
                this.building = this.building_special;
                break;
            }
            case '\t': {
                this.building = null;
                this.foundation_state = '\u0000';
                this.foundation_y_offset = 0;
            }
        }
        this.building_map_x = this.current_worm.x / this.game.bkgnd_clx;
        this.building_map_y = this.current_worm.y / this.game.bkgnd_cly;
        this.move_building(true);
        this.move_building(false);
        this.camera_target_type = (char)3;
    }

    private char place_building() {
        if (this.building_ok) {
            this.game.hdl_sound(92);
            if (this.building_type == '\t') {
                int rows = 0;
                int cols = 0;
                switch (this.foundation_state) {
                    case '\u0000': {
                        rows = 2;
                        cols = 2;
                        break;
                    }
                    case '\u0001': {
                        rows = 2;
                        cols = 3;
                        break;
                    }
                    case '\u0002': {
                        rows = 3;
                        cols = 4;
                    }
                }
                for (int r = 0; r <= rows; ++r) {
                    for (int c = 0; c < cols; ++c) {
                        if (r == 0) {
                            this.game.setMapTile(this.building_map_x + c, this.building_map_y + r + this.foundation_y_offset, (byte)10);
                            continue;
                        }
                        this.game.setMapTile(this.building_map_x + c, this.building_map_y + r + this.foundation_y_offset, (byte)11);
                    }
                }
                this.check_worms_in_foundation();
            } else {
                for (int b = 0; b < this.player_building_list.length; ++b) {
                    if (this.players_turn) {
                        if (this.player_building_list[b].building_anim != null) continue;
                        this.player_building_list[b].add_building(this.building_map_x * this.game.bkgnd_clx, this.building_map_y * this.game.bkgnd_cly, this.building, this.menu_selection);
                        break;
                    }
                    if (this.ai_building_list[b].building_anim != null) continue;
                    this.ai_building_list[b].add_building(this.building_map_x * this.game.bkgnd_clx, this.building_map_y * this.game.bkgnd_cly, this.building, this.menu_selection);
                    break;
                }
            }
            this.camera_target_type = '\u0001';
            if (this.building_type == '\u0004') {
                if (this.players_turn) {
                    this.player_stronghold_placed = true;
                    this.player_building_menu.remove_item(this.building_type);
                } else {
                    this.ai_stronghold_placed = true;
                    this.ai_building_menu.remove_item(this.building_type);
                }
            } else if (this.players_turn) {
                this.player_building_menu.remove_item(this.building_type);
                if (this.building_type == '\b') {
                    this.player_wonder_turns = 0;
                    return '\u0007';
                }
            } else {
                this.ai_building_menu.remove_item(this.building_type);
                if (this.building_type == '\b') {
                    this.ai_wonder_turns = 0;
                    return '\u0007';
                }
            }
            return '\u0001';
        }
        return '\u00ff';
    }

    private void check_worms_in_foundation() {
        int map_x = 0;
        int map_y = 0;
        int new_map_y = 0;
        for (int w = 0; w < this.player_worm.length; ++w) {
            if (this.player_worm[w].health >= 0) {
                map_x = (this.player_worm[w].fpx >> 8) / this.game.bkgnd_clx;
                new_map_y = map_y = (this.player_worm[w].fpy >> 8) / this.game.bkgnd_cly;
                while (!this.empty_tile(this.game.getMapTile(map_x, new_map_y))) {
                    --new_map_y;
                }
                if (new_map_y < map_y) {
                    map_y = new_map_y - map_y;
                    this.player_worm[w].fpy += map_y * this.game.bkgnd_cly << 8;
                }
            }
            if (this.ai_worm[w].health < 0) continue;
            map_x = (this.ai_worm[w].fpx >> 8) / this.game.bkgnd_clx;
            new_map_y = map_y = (this.ai_worm[w].fpy >> 8) / this.game.bkgnd_cly;
            while (!this.empty_tile(this.game.getMapTile(map_x, new_map_y))) {
                --new_map_y;
            }
            if (new_map_y >= map_y) continue;
            map_y = new_map_y - map_y;
            this.ai_worm[w].fpy += map_y * this.game.bkgnd_cly << 8;
        }
    }

    private void move_building(boolean dir) {
        int num_tiles_height = 0;
        int num_tiles_width = 0;
        if (this.building != null) {
            num_tiles_width = this.building.lx / this.game.bkgnd_clx;
            num_tiles_height = this.building.ly / this.game.bkgnd_cly;
        } else {
            this.foundation_y_offset = 0;
            switch (this.foundation_state) {
                case '\u0000': {
                    num_tiles_height = 2 + this.foundation_y_offset;
                    num_tiles_width = 2;
                    break;
                }
                case '\u0001': {
                    num_tiles_height = 2 + this.foundation_y_offset;
                    num_tiles_width = 3;
                    break;
                }
                case '\u0002': {
                    num_tiles_height = 3 + this.foundation_y_offset;
                    num_tiles_width = 4;
                }
            }
        }
        int old_x = this.building_map_x--;
        int old_y = this.building_map_y;
        if (!dir) {
            ++this.building_map_x;
        }
        byte tile = this.game.getMapTile(this.building_map_x, this.building_map_y + num_tiles_height - 1);
        while (!this.empty_tile(tile)) {
            --this.building_map_y;
            if (this.building_map_y >= 0) {
                tile = this.game.getMapTile(this.building_map_x, this.building_map_y + num_tiles_height - 1);
                continue;
            }
            this.building_map_x = old_x;
            this.building_map_y = old_y;
            break;
        }
        tile = this.game.getMapTile(this.building_map_x, this.building_map_y + num_tiles_height);
        while (this.empty_tile(tile)) {
            ++this.building_map_y;
            if (this.building_map_y + num_tiles_height - 1 < this.game.bkgnd_mly) {
                tile = this.game.getMapTile(this.building_map_x, this.building_map_y + num_tiles_height);
                continue;
            }
            this.building_map_x = old_x;
            this.building_map_y = old_y;
            break;
        }
        if ((tile = this.game.getMapTile(this.building_map_x, this.building_map_y + num_tiles_height)) == 2 || tile == 3 || tile == 5) {
            ++this.building_map_y;
        }
        this.check_building();
    }

    private void check_building() {
        int b;
        int num_tiles_height = 0;
        int num_tiles_width = 0;
        int building_width = 0;
        int building_height = 0;
        if (this.building != null) {
            num_tiles_width = this.building.lx / this.game.bkgnd_clx;
            building_width = this.building.lx;
            num_tiles_height = this.building.ly / this.game.bkgnd_cly;
            building_height = this.building.ly;
        } else {
            switch (this.foundation_state) {
                case '\u0001': {
                    num_tiles_height = 2 + this.foundation_y_offset;
                    num_tiles_width = 3;
                    break;
                }
                case '\u0002': {
                    num_tiles_height = 3 + this.foundation_y_offset;
                    num_tiles_width = 4;
                    break;
                }
                case '\u0000': {
                    num_tiles_height = 2 + this.foundation_y_offset;
                    num_tiles_width = 2;
                }
            }
            building_height = this.game.bkgnd_cly * num_tiles_height;
            building_width = this.game.bkgnd_clx * num_tiles_width;
        }
        this.building_ok = false;
        for (b = 0; b < this.player_building_list.length; ++b) {
            if (this.players_turn) {
                if (this.player_building_list[b].building_anim == null) {
                    this.building_ok = true;
                }
            } else if (this.ai_building_list[b].building_anim == null) {
                this.building_ok = true;
            }
            if (this.building_ok) break;
        }
        if (this.building_type == '\u0004' || this.building_type == '\t') {
            this.building_ok = true;
        } else if (this.building_ok) {
            this.building_ok = false;
            for (b = 0; b < this.player_building_list.length; ++b) {
                if (this.players_turn) {
                    if (this.player_building_list[b].building_type == 4) {
                        this.building_ok = true;
                    }
                } else if (this.ai_building_list[b].building_type == 4) {
                    this.building_ok = true;
                }
                if (this.building_ok) break;
            }
        }
        if (this.building_ok) {
            if (this.players_turn) {
                if (this.building_map_x > this.game.bkgnd_mlx >> 1) {
                    this.building_ok = false;
                }
            } else if (this.building_map_x < this.game.bkgnd_mlx >> 1) {
                this.building_ok = false;
            }
        }
        if (this.building_ok && this.building != null && (this.building.res_index != this.building_special.res_index || this.building_type == '\u0002') && this.building_type != '\u0000' && this.building_type != '\u0004') {
            this.building_ok = false;
            for (b = 0; b < this.player_building_list.length; ++b) {
                if (this.players_turn) {
                    if (this.player_building_list[b].building_type == this.menu_selection - 1) {
                        this.building_ok = true;
                    }
                } else if (this.ai_building_list[b].building_type == this.menu_selection - 1) {
                    this.building_ok = true;
                }
                if (this.building_ok) break;
            }
        }
        if (this.building_ok) {
            for (b = 0; b < this.player_building_list.length; ++b) {
                boolean bl = this.building_ok = !this.player_building_list[b].check_collision(this.building_map_x * this.game.bkgnd_clx, this.building_map_x * this.game.bkgnd_clx + building_width, true, false, 0, 0);
                if (this.building_ok) {
                    boolean bl2 = this.building_ok = !this.ai_building_list[b].check_collision(this.building_map_x * this.game.bkgnd_clx, this.building_map_x * this.game.bkgnd_clx + building_width, true, false, 0, 0);
                }
                if (!this.building_ok) break;
            }
        }
        if (this.building_ok) {
            byte tile = 0;
            for (int x = 0; x < num_tiles_width; ++x) {
                tile = this.building_type == '\t' ? this.game.getMapTile(this.building_map_x + x, this.building_map_y + num_tiles_height + this.foundation_y_offset) : this.game.getMapTile(this.building_map_x + x, this.building_map_y + num_tiles_height - 1);
                if (this.building_type == '\t') {
                    if (tile != this.TILE_WATER_1 && tile != 8 && tile != 9 && tile != 10 && tile != 11 && !this.empty_tile(tile)) continue;
                    this.building_ok = false;
                    break;
                }
                if (!this.empty_tile(tile)) {
                    this.building_ok = false;
                    break;
                }
                tile = this.game.getMapTile(this.building_map_x + x, this.building_map_y + num_tiles_height);
                if (tile != this.TILE_WATER_1 && tile != 8 && tile != 2 && tile != 3 && tile != 9 && !this.empty_tile(tile)) continue;
                this.building_ok = false;
                break;
            }
        }
        if (this.building_ok && this.building_type != '\u0004' && this.building_type != '\t') {
            for (b = 0; b < this.player_building_list.length; ++b) {
                this.building_ok = this.players_turn ? this.player_building_list[b].check_distance(this.building_map_x, this.game.bkgnd_clx, num_tiles_width) : this.ai_building_list[b].check_distance(this.building_map_x, this.game.bkgnd_clx, num_tiles_width);
                if (this.building_ok) break;
            }
        }
    }

    private void clean_building_list() {
        for (int b = 0; b < this.player_building_list.length; ++b) {
            if (this.player_building_list[b].health <= 0) {
                this.player_building_list[b] = new Building();
            }
            if (this.ai_building_list[b].health > 0) continue;
            this.ai_building_list[b] = new Building();
        }
    }

    public void find_intersect_point(int x11, int y11, int x12, int y12, int x21, int y21, int x22, int y22) {
        long m1 = -1L;
        long m2 = -1L;
        long c1 = 0L;
        long c2 = 0L;
        if (x12 - x11 >> 8 == 0) {
            x12 += 256;
        }
        if (x22 - x21 >> 8 == 0) {
            x22 += 256;
        }
        m1 = y12 - y11 >> 8 == 0 ? 0L : (long)((y12 - y11 << 8) / (x12 - x11));
        m2 = y22 - y21 >> 8 == 0 ? 0L : (long)((y22 - y21 << 8) / (x22 - x21));
        c1 = (long)y11 - (m1 * (long)x11 >> 8);
        c2 = (long)y21 - (m2 * (long)x21 >> 8);
        this.intersect_x = m1 - m2 >> 8 == 0L ? x11 : (int)((c2 - c1 << 8) / (m1 - m2));
        this.intersect_y = (int)(c2 + (m2 * (long)this.intersect_x >> 8));
    }

    public void find_intersect_point(int x11, int y11, int x12, int y12, int map_x, int map_y) {
        int tile_x1 = map_x / this.game.bkgnd_clx;
        int tile_y1 = map_y / this.game.bkgnd_cly;
        byte tile = this.game.getMapTile(tile_x1, tile_y1);
        int tile_x2 = 0;
        int tile_y2 = 0;
        switch (tile) {
            case 2: {
                tile_x1 = map_x << 8;
                tile_y1 = map_y + this.game.bkgnd_cly << 8;
                tile_x2 = map_x + this.game.bkgnd_clx << 8;
                tile_y2 = map_y << 8;
                break;
            }
            case 3: {
                tile_x1 = map_x << 8;
                tile_y1 = map_y << 8;
                tile_x2 = map_x + this.game.bkgnd_clx << 8;
                tile_y2 = map_y + this.game.bkgnd_cly << 8;
                break;
            }
            case 5: {
                int wx = (x11 >> 8) - tile_x1 * this.game.bkgnd_clx;
                if (wx < this.game.bkgnd_clx >> 1) {
                    tile_x1 = map_x << 8;
                    tile_y1 = map_y + this.game.bkgnd_cly << 8;
                    tile_x2 = map_x + this.game.bkgnd_clx << 8;
                    tile_y2 = map_y << 8;
                    break;
                }
                tile_x1 = map_x << 8;
                tile_y1 = map_y << 8;
                tile_x2 = map_x + this.game.bkgnd_clx << 8;
                tile_y2 = map_y + this.game.bkgnd_cly << 8;
                break;
            }
            default: {
                tile_x1 = map_x << 8;
                tile_y1 = map_y << 8;
                tile_x2 = map_x + this.game.bkgnd_clx << 8;
                tile_y2 = map_y << 8;
            }
        }
        this.find_intersect_point(x11, y11, x12, y12, tile_x1, tile_y1, tile_x2, tile_y2);
    }

    public int collides_with_ground(int _wx, int _wy, int y_offset) {
        if (_wx < 0 || _wy < 0) {
            return 1;
        }
        if (_wx > this.game.bkgnd_slx || _wy > this.game.bkgnd_sly) {
            return -1;
        }
        int result = 0;
        int wx = _wx;
        int wy = _wy + y_offset;
        int mx = wx / this.game.bkgnd_clx;
        int my = wy / this.game.bkgnd_cly;
        byte tile = this.game.getMapTile(mx, my);
        switch (tile) {
            case 0: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (wy == my) {
                    result = 0;
                    break;
                }
                if (wy < my) {
                    result = 1;
                    break;
                }
                result = -1;
                break;
            }
            case 3: {
                wy = this.game.bkgnd_cly - (wy - my * this.game.bkgnd_cly);
                if ((wx -= mx * this.game.bkgnd_clx) + wy == this.game.bkgnd_clx) {
                    result = 0;
                    break;
                }
                if (wx + wy > this.game.bkgnd_clx) {
                    result = 1;
                    break;
                }
                result = -1;
                break;
            }
            case 2: {
                if ((wx -= mx * this.game.bkgnd_clx) == (wy -= my * this.game.bkgnd_cly)) {
                    result = 0;
                    break;
                }
                if (wx + wy < this.game.bkgnd_clx) {
                    result = 1;
                    break;
                }
                result = -1;
                break;
            }
            case 5: {
                wy -= my * this.game.bkgnd_cly;
                if ((wx -= mx * this.game.bkgnd_clx) < this.game.bkgnd_clx >> 1) {
                    if (wx == wy) {
                        result = 0;
                        break;
                    }
                    if (wx + wy < this.game.bkgnd_clx) {
                        result = 1;
                        break;
                    }
                    result = -1;
                    break;
                }
                if (wx + (wy = this.game.bkgnd_cly - wy) == this.game.bkgnd_clx) {
                    result = 0;
                    break;
                }
                if (wx + wy > this.game.bkgnd_clx) {
                    result = 1;
                    break;
                }
                result = -1;
                break;
            }
            default: {
                if (tile == this.TILE_WATER_1 || this.empty_tile(tile)) {
                    result = 1;
                    break;
                }
                if (tile == this.TILE_SLOPE_FILLER_L || tile == this.TILE_GROUND_2) {
                    if (wy == my) {
                        result = 0;
                        break;
                    }
                    if (wy < my) {
                        result = 1;
                        break;
                    }
                    result = -1;
                    break;
                }
                result = -1;
            }
        }
        return result;
    }

    private boolean update_worms() {
        boolean continue_game = true;
        for (int w = 0; w < this.player_worm.length; ++w) {
            int b;
            Building building;
            if (this.player_worm[w].on_building && !this.player_worm[w].falling) {
                building = null;
                for (b = 0; b < this.player_building_list.length && (building = this.player_building_list[b].check_roof_collision(this.player_worm[w].x, this.player_worm[w].y + (this.player_worm[w].worm_anim.ly >> 1))) == null; ++b) {
                }
                if (building == null) {
                    this.player_worm[w].fpvy = Worm.MAX_FPVY;
                    this.player_worm[w].falling = true;
                }
            }
            if (this.player_worm[w].falling) {
                this.player_worm[w].fall();
                continue_game = false;
            }
            if (this.ai_worm[w].on_building && !this.ai_worm[w].falling) {
                building = null;
                for (b = 0; b < this.ai_building_list.length && (building = this.ai_building_list[b].check_roof_collision(this.ai_worm[w].x, this.ai_worm[w].y + (this.ai_worm[w].worm_anim.ly >> 1))) == null; ++b) {
                }
                if (building == null) {
                    this.ai_worm[w].fpvy = Worm.MAX_FPVY;
                    this.ai_worm[w].falling = true;
                }
            }
            if (!this.ai_worm[w].falling) continue;
            this.ai_worm[w].fall();
            continue_game = false;
        }
        return continue_game;
    }

    private boolean check_ai_status() {
        boolean end_game = true;
        if (this.ai_stronghold_placed) {
            for (int b = 0; b < this.player_building_list.length; ++b) {
                if (this.ai_building_list[b].building_anim == null || this.ai_building_list[b].building_type >= 5) continue;
                end_game = false;
                break;
            }
            if (end_game) {
                this.message = this.message_win_no_buildings;
                this.add_name_to_message(this.ai_name);
                this.change_state('\u0002');
                return true;
            }
        }
        this.target_worm = (char)99;
        for (int w = 0; w < this.ai_worm.length; w = (int)((char)(w + 1))) {
            if (this.ai_worm[w].health <= 0) continue;
            this.target_worm = (char)w;
            break;
        }
        if (this.target_worm == 'c') {
            this.target_worm = '\u0000';
            this.message = this.message_win_no_worms;
            this.add_name_to_message(this.ai_name);
            this.change_state('\u0002');
            return true;
        }
        return false;
    }

    private boolean check_player_status() {
        boolean end_game = true;
        if (this.player_stronghold_placed) {
            end_game = true;
            for (int b = 0; b < this.player_building_list.length; ++b) {
                if (this.player_building_list[b].building_anim == null || this.player_building_list[b].building_type >= 5) continue;
                end_game = false;
                break;
            }
            if (end_game) {
                this.message = this.message_win_no_buildings;
                this.add_name_to_message(this.player_name);
                this.change_state('\u0003');
                return true;
            }
        }
        this.target_worm = (char)99;
        for (int w = 0; w < this.player_worm.length; w = (int)((char)(w + 1))) {
            if (this.player_worm[w].health <= 0) continue;
            this.target_worm = (char)w;
            break;
        }
        if (this.target_worm == 'c') {
            this.target_worm = '\u0000';
            this.message = this.message_win_no_worms;
            this.add_name_to_message(this.player_name);
            this.change_state('\u0003');
            return true;
        }
        return false;
    }

    private void check_for_end_game() {
        this.clean_building_list();
        if (!this.update_worms()) {
            return;
        }
        boolean end_game = true;
        if (this.players_turn && this.second_turn && this.player_wonder_turns >= WONDER_TURNS) {
            this.message = this.message_win_wonder;
            this.change_state('\u0002');
            this.state_tick = '\u0000';
            return;
        }
        if (!this.players_turn && this.second_turn && this.ai_wonder_turns >= WONDER_TURNS) {
            this.message = this.message_win_wonder;
            this.change_state('\u0003');
            this.state_tick = '\u0000';
            return;
        }
        if (this.players_turn) {
            if (this.check_ai_status()) {
                return;
            }
            if (this.check_player_status()) {
                return;
            }
        } else {
            if (this.check_player_status()) {
                return;
            }
            if (this.check_ai_status()) {
                return;
            }
        }
        if (this.players_turn && !this.second_turn || !this.players_turn && !this.second_turn) {
            this.second_turn = true;
            this.num_bullets = 0;
            this.crosshair_y = 0;
            this.crosshair_x = 35;
            this.weapon_power = 0;
            this.state_tick = '\u0000';
            this.worm_stop_movement = false;
            if (!this.players_turn) {
                this.ai_worm_building = false;
                this.ai_distance = 0L;
                this.ai_crosshair_y = 0;
                this.ai_weapon_power = 0;
                this.change_state('\u0012');
            } else {
                this.change_state('\n');
            }
            this.camera_target_type = '\u0001';
        } else {
            this.target_worm = '\u0000';
            this.change_state('\u0006');
        }
    }

    public void check_special() {
        int b;
        if (this.prev_state == '\u0001') {
            for (int b2 = 0; b2 < this.player_building_list.length; ++b2) {
                int offset;
                int w;
                int y;
                int x;
                if (this.players_turn && this.player_building_list[b2].building_type == 5) {
                    x = 0;
                    y = 0;
                    for (w = 0; w < 4; ++w) {
                        if (this.player_worm[w].health > 0 || !this.player_worm[w].respawn) continue;
                        while (!this.empty_tile(this.game.getMapTile(x, y))) {
                            if (++y < this.game.bkgnd_mly) continue;
                            y = 0;
                            ++x;
                        }
                        while (!this.worm_tile(this.game.getMapTile(x, y))) {
                            if (++y < this.game.bkgnd_mly) continue;
                            y = 0;
                            ++x;
                        }
                        offset = 0;
                        if (this.game.getMapTile(x, y) == 2 || this.game.getMapTile(x, y) == 3 || this.game.getMapTile(x, y) == 5) {
                            offset = this.game.bkgnd_cly >> 1;
                        }
                        this.player_worm[w] = new Worm(x * this.game.bkgnd_clx + (this.game.bkgnd_clx >> 1), y * this.game.bkgnd_cly - (this.worm_anim[0].ly >> 1) + offset, this.worm_anim[0], false, this);
                    }
                    continue;
                }
                if (this.players_turn || this.ai_building_list[b2].building_type != 5) continue;
                x = this.game.bkgnd_mlx - 1;
                y = this.game.bkgnd_mly - 1;
                for (w = 0; w < 4; ++w) {
                    if (this.ai_worm[w].health > 0 || !this.ai_worm[w].respawn) continue;
                    while (!this.empty_tile(this.game.getMapTile(x, y))) {
                        if (--y >= 0) continue;
                        y = this.game.bkgnd_mly - 1;
                        --x;
                    }
                    while (!this.worm_tile(this.game.getMapTile(x, y))) {
                        if (++y < this.game.bkgnd_mly) continue;
                        y = 0;
                        ++x;
                    }
                    offset = 0;
                    if (this.game.getMapTile(x, y) == 2 || this.game.getMapTile(x, y) == 3 || this.game.getMapTile(x, y) == 5) {
                        offset = this.game.bkgnd_cly >> 1;
                    }
                    this.ai_worm[w] = new Worm(x * this.game.bkgnd_clx + (this.game.bkgnd_clx >> 1), y * this.game.bkgnd_cly - (this.worm_anim[0].ly >> 1) + offset, this.worm_anim[0], true, this);
                }
            }
        }
        boolean wonder_still_standing = false;
        if (this.players_turn && this.prev_state == '\u0001') {
            if (this.player_wonder_turns >= 0) {
                for (b = 0; b < this.player_building_list.length; ++b) {
                    if (this.player_building_list[b].building_type != 8) continue;
                    wonder_still_standing = true;
                    break;
                }
            }
            this.player_wonder_turns = wonder_still_standing ? ++this.player_wonder_turns : -1;
        } else if (!this.players_turn && this.prev_state == '\u0001') {
            if (this.ai_wonder_turns >= 0) {
                for (b = 0; b < this.player_building_list.length; ++b) {
                    if (this.ai_building_list[b].building_type != 8) continue;
                    wonder_still_standing = true;
                    break;
                }
            }
            this.ai_wonder_turns = wonder_still_standing ? ++this.ai_wonder_turns : -1;
        }
        if (this.players_turn) {
            for (b = 0; b < this.player_building_list.length; ++b) {
                if (this.player_building_list[b].building_type != 6 || !this.spawn_crate(true)) continue;
                this.change_state('\b');
                return;
            }
        } else {
            for (b = 0; b < this.player_building_list.length; ++b) {
                if (this.ai_building_list[b].building_type != 6 || !this.spawn_crate(false)) continue;
                this.change_state('\b');
                return;
            }
        }
        this.change_state('\t');
    }

    public boolean spawn_crate(boolean player_crate) {
        int new_crate = -1;
        if (this.players_turn) {
            for (int c = 0; c < this.player_crate_active.length; ++c) {
                if (this.player_crate_active[c]) continue;
                new_crate = c;
                break;
            }
            if (new_crate == -1) {
                return false;
            }
            Building weapons = null;
            for (int b = 0; b < this.player_building_list.length; ++b) {
                if (this.player_building_list[b].building_type != 6) continue;
                weapons = this.player_building_list[b];
            }
            if (weapons == null) {
                return false;
            }
            int x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
            while (x < 0 && x >= this.game.bkgnd_slx) {
                x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
            }
            while (!this.empty_tile(this.game.getMapTile(x, 0))) {
                x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
                while (x < 0 && x >= this.game.bkgnd_slx) {
                    x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
                }
            }
            this.player_crate_active[new_crate] = true;
            this.player_crate_fpx[new_crate] = x * this.game.bkgnd_clx + this.game.bkgnd_clx >> 1 << 8;
            this.player_crate_fpy[new_crate] = 0;
            this.crate_fpvy = 512;
            this.crate_falling = new_crate;
            return true;
        }
        for (int c = 0; c < this.ai_crate_active.length; ++c) {
            if (this.ai_crate_active[c]) continue;
            new_crate = c;
            break;
        }
        if (new_crate == -1) {
            return false;
        }
        Building weapons = null;
        for (int b = 0; b < this.ai_building_list.length; ++b) {
            if (this.ai_building_list[b].building_type != 6) continue;
            weapons = this.ai_building_list[b];
        }
        if (weapons == null) {
            return false;
        }
        int x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
        while (x < 0 && x >= this.game.bkgnd_slx) {
            x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
        }
        while (!this.empty_tile(this.game.getMapTile(x, 0))) {
            x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
            while (x < 0 && x >= this.game.bkgnd_slx) {
                x = this.game.random.nextInt() % 5 + weapons.x / this.game.bkgnd_clx + 1;
            }
        }
        this.ai_crate_active[new_crate] = true;
        this.ai_crate_fpx[new_crate] = x * this.game.bkgnd_clx + (this.game.bkgnd_clx >> 1) << 8;
        this.ai_crate_fpy[new_crate] = 0;
        this.crate_fpvy = 512;
        this.crate_falling = new_crate;
        return true;
    }

    public void change_state(char state) {
        if (state != '\u00ff') {
            this.prev_state = this.game_state;
            switch (this.game_state) {
                case '\u0001': {
                    if (this.current_worm == null || this.current_worm.health <= 0) break;
                    this.current_worm.set_anim(0);
                    break;
                }
                case '\f': {
                    this.menu_selection = this.player_building_menu.get_menu_choice();
                    this.player_building_menu.close();
                    break;
                }
                case '\r': {
                    this.camera_target_type = '\u0001';
                    break;
                }
                case '\u000e': {
                    this.menu_selection = this.player_weapon_menu.get_menu_choice();
                    this.player_weapon_menu.close();
                    break;
                }
                case '\u0010': {
                    this.fire_pressed = false;
                    break;
                }
                case '\u0011': {
                    this.current_worm.set_anim(0);
                    this.player_weapon_menu.remove_item(this.menu_selection);
                    break;
                }
                case '\u0012': {
                    if (this.target_worm < this.ai_worm.length) {
                        this.current_worm = this.ai_worm[this.target_worm];
                        break;
                    }
                    this.current_worm = this.ai_worm[0];
                    break;
                }
                case '\u0014': {
                    if (this.game_type == '\u0001') {
                        this.menu_selection = this.ai_building_menu.get_menu_choice();
                    }
                    this.ai_building_menu.close();
                    break;
                }
                case '\u0015': {
                    this.camera_target_type = '\u0001';
                    break;
                }
                case '\u0016': {
                    if (this.game_type == '\u0001') {
                        this.menu_selection = this.ai_weapon_menu.get_menu_choice();
                    }
                    this.ai_weapon_menu.close();
                    break;
                }
                case '\u0019': {
                    this.current_worm.set_anim(0);
                    this.ai_weapon_menu.remove_item(this.menu_selection);
                    break;
                }
            }
            switch (state) {
                case '\u0001': {
                    this.message = null;
                    break;
                }
                case '\u0002': 
                case '\u0003': {
                    this.state_tick = '\u0000';
                    break;
                }
                case '\u0006': {
                    this.game.reset_keys();
                    this.players_turn = !this.players_turn;
                    break;
                }
                case '\u0007': {
                    this.state_tick = '\u0000';
                    break;
                }
                case '\b': {
                    this.state_tick = '\u0000';
                    this.camera_target_type = (char)4;
                    break;
                }
                case '\t': {
                    this.fling_worms = false;
                    this.num_bullets = 0;
                    this.crosshair_y = 0;
                    this.crosshair_x = 35;
                    this.weapon_power = 0;
                    this.state_tick = '\u0000';
                    this.turn_timer_tick = '\u0000';
                    this.turn_timer = (char)30;
                    this.camera_target_type = '\u0001';
                    this.worm_stop_movement = false;
                    this.ai_worm_building = false;
                    this.second_turn = false;
                    this.target_worm = this.get_first_worm();
                    if (this.target_worm == 'c') {
                        this.message = this.message_win_no_worms;
                        if (this.players_turn) {
                            state = (char)2;
                            this.add_name_to_message(this.ai_name);
                        } else {
                            state = (char)3;
                            this.add_name_to_message(this.player_name);
                        }
                    } else {
                        this.current_worm = this.players_turn ? this.player_worm[this.target_worm] : this.ai_worm[this.target_worm];
                    }
                    this.wind_value = this.get_wind_value();
                    int msg = this.game.random.nextInt() % this.message_player_turn.length;
                    if (msg < 0) {
                        msg *= -1;
                    }
                    this.message = this.message_player_turn[msg];
                    if (this.players_turn) {
                        this.add_name_to_message(this.player_name);
                        break;
                    }
                    this.add_name_to_message(this.ai_name);
                    break;
                }
                case '\n': {
                    this.fling_worms = false;
                    this.message = null;
                    this.state_tick = '\u0000';
                    this.turn_timer_tick = '\u0000';
                    this.turn_timer = (char)30;
                    if (this.camera_target_type == '\u0000') {
                        this.switch_view();
                    }
                    this.target_worm = this.get_first_worm();
                    if (this.target_worm == 'c') {
                        state = (char)3;
                        this.message = this.message_win_no_worms;
                        this.add_name_to_message(this.player_name);
                        break;
                    }
                    this.current_worm = this.player_worm[this.target_worm];
                    break;
                }
                case '\u000b': {
                    this.current_worm.set_anim(0);
                    this.camera_target_type = '\u0001';
                    break;
                }
                case '\f': {
                    this.message = null;
                    this.player_building_menu.open(-1);
                    break;
                }
                case '\r': {
                    if (this.menu_selection >= 0) {
                        this.init_building();
                        break;
                    }
                    state = (char)11;
                    break;
                }
                case '\u000e': {
                    this.message = null;
                    this.player_weapon_menu.open(this.current_worm.building_type);
                    break;
                }
                case '\u000f': {
                    if (this.menu_selection >= 0) {
                        this.setup_weapon(this.menu_selection, 1, false);
                        if (this.current_weapon[0][10] != '\u0003' || this.prev_state == '\u001b') break;
                        state = (char)27;
                        this.homing_map_x = this.current_worm.x / this.game.bkgnd_clx;
                        this.homing_map_y = this.current_worm.y / this.game.bkgnd_cly;
                        while (this.empty_tile(this.game.getMapTile(this.homing_map_x, this.homing_map_y + 1))) {
                            ++this.homing_map_y;
                        }
                        break;
                    }
                    if (this.players_turn) {
                        state = (char)11;
                        break;
                    }
                    state = (char)19;
                    break;
                }
                case '\u0010': {
                    this.fire_pressed = false;
                    break;
                }
                case '\u0011': {
                    this.spawn_weapon();
                    break;
                }
                case '\u0012': {
                    this.fling_worms = false;
                    this.message = null;
                    this.state_tick = '\u0000';
                    this.turn_timer_tick = '\u0000';
                    this.turn_timer = (char)30;
                    if (this.camera_target_type == '\u0000') {
                        this.switch_view();
                    }
                    this.target_worm = this.get_first_worm();
                    if (this.target_worm == 'c') {
                        state = (char)2;
                        this.message = this.message_win_no_worms;
                        this.add_name_to_message(this.ai_name);
                        break;
                    }
                    this.current_worm = this.ai_worm[this.target_worm];
                    break;
                }
                case '\u0013': {
                    this.current_worm.set_anim(0);
                    this.camera_target_type = '\u0001';
                    break;
                }
                case '\u0014': {
                    this.message = null;
                    this.ai_building_menu.open(-1);
                    break;
                }
                case '\u0015': {
                    this.message = null;
                    if (this.menu_selection >= 0) {
                        this.init_building();
                        break;
                    }
                    state = (char)19;
                    break;
                }
                case '\u0016': {
                    this.ai_weapon_menu.open(this.current_worm.building_type);
                    break;
                }
                case '\u0017': {
                    if (this.menu_selection >= 0) {
                        this.setup_weapon(this.menu_selection, 1, false);
                        if (this.game_type != '\u0001' || this.current_weapon[0][10] != '\u0003' || this.prev_state == '\u001c') break;
                        state = (char)28;
                        this.homing_map_x = this.current_worm.x / this.game.bkgnd_clx;
                        this.homing_map_y = this.current_worm.y / this.game.bkgnd_cly;
                        while (this.empty_tile(this.game.getMapTile(this.homing_map_x, this.homing_map_y + 1))) {
                            ++this.homing_map_y;
                        }
                        break;
                    }
                    state = (char)19;
                    break;
                }
                case '\u0019': {
                    this.spawn_weapon();
                    break;
                }
                case '\u00fd': {
                    if (this.crate_falling < 0 || this.crate_falling >= this.player_crate_active.length) break;
                    this.crate_fpvy = 2048;
                    break;
                }
            }
            this.game_state = state;
        }
    }

    private char get_first_worm() {
        int result = 99;
        if (this.players_turn) {
            for (int w = 0; w < this.player_worm.length; w = (int)((char)(w + 1))) {
                if (this.player_worm[w].health <= 0) continue;
                result = w;
                break;
            }
        } else {
            for (int w = 0; w < this.ai_worm.length; w = (int)((char)(w + 1))) {
                if (this.ai_worm[w].health <= 0) continue;
                result = w;
                break;
            }
        }
        return (char)result;
    }

    public void pause_game() {
        if (this.game_state != '\u00fe' && this.game_state != '\t' && this.game_state != '\u0000' && this.game_state != '\u0003' && this.game_state != '\u0002') {
            this.prev_state = this.game_state;
            this.game_state = (char)254;
            this.game.reset_keys();
        }
    }

    private void resume_game() {
        this.game_state = this.prev_state;
        this.prev_state = '\u0000';
        this.message = null;
        this.game.reset_keys();
    }

    public boolean blocking_tile(int tile) {
        return tile == 0 || tile == this.TILE_GROUND_2 || tile == 8 || tile == 9 || tile == this.TILE_SLOPE_FILLER_L || tile == 4 || tile == 6 || tile == 10 || tile == 11;
    }

    public boolean empty_tile(int tile) {
        return tile == this.TILE_EMPTY_1;
    }

    public boolean worm_tile(int tile) {
        return tile == 0 || tile == this.TILE_GROUND_2 || tile == 8 || tile == 9 || tile == 5 || tile == 2 || tile == 3;
    }

    private void move_crate() {
        if (this.players_turn) {
            if (this.crate_falling >= 0 && this.crate_falling < this.player_crate_active.length && this.player_crate_active[this.crate_falling]) {
                int map_x1 = (this.player_crate_fpx[this.crate_falling] >> 8) / this.game.bkgnd_clx;
                int map_x2 = ((this.player_crate_fpx[this.crate_falling] >> 8) + this.crate.lx) / this.game.bkgnd_clx;
                int map_y = ((this.player_crate_fpy[this.crate_falling] + this.crate_fpvy >> 8) + this.crate.ly) / this.game.bkgnd_cly;
                byte tile_1 = this.game.getMapTile(map_x1, map_y);
                byte tile_2 = this.game.getMapTile(map_x2, map_y);
                if (tile_1 == this.TILE_WATER_1 || tile_2 == this.TILE_WATER_1) {
                    this.controls_message_dismiss();
                    this.crate_fpvy = 0;
                    this.player_crate_active[this.crate_falling] = false;
                    this.crate_falling = -1;
                    return;
                }
                if (!this.empty_tile(tile_1) || !this.empty_tile(tile_2)) {
                    this.find_intersect_point(this.player_crate_fpx[this.crate_falling], this.player_crate_fpy[this.crate_falling] + this.crate_fpvy, this.player_crate_fpx[this.crate_falling], this.player_crate_fpy[this.crate_falling] + this.crate_fpvy + (this.crate.ly << 8), (this.player_crate_fpx[this.crate_falling] >> 8) / this.game.bkgnd_clx * this.game.bkgnd_clx, ((this.player_crate_fpy[this.crate_falling] + this.crate_fpvy >> 8) + this.crate.ly) / this.game.bkgnd_cly * this.game.bkgnd_cly);
                    this.player_crate_fpx[this.crate_falling] = this.intersect_x;
                    this.player_crate_fpy[this.crate_falling] = this.intersect_y - (this.crate.ly << 8);
                    this.crate_fpvy = 0;
                    this.crate_falling = -1;
                    this.controls_message_dismiss();
                    return;
                }
                if (this.crate_fpvy == 2048) {
                    if ((this.player_crate_fpy[this.crate_falling] >> 8) % 8 != 0) {
                        int n = this.crate_falling;
                        this.player_crate_fpy[n] = this.player_crate_fpy[n] + (2048 - ((this.player_crate_fpy[this.crate_falling] >> 8) % 8 << 8));
                    } else {
                        int n = this.crate_falling;
                        this.player_crate_fpy[n] = this.player_crate_fpy[n] + this.crate_fpvy;
                    }
                } else {
                    int n = this.crate_falling;
                    this.player_crate_fpy[n] = this.player_crate_fpy[n] + this.crate_fpvy;
                }
            }
        } else if (this.crate_falling >= 0 && this.crate_falling < this.ai_crate_active.length && this.ai_crate_active[this.crate_falling]) {
            int map_x1 = (this.ai_crate_fpx[this.crate_falling] >> 8) / this.game.bkgnd_clx;
            int map_x2 = ((this.ai_crate_fpx[this.crate_falling] >> 8) + this.crate.lx) / this.game.bkgnd_clx;
            int map_y = ((this.ai_crate_fpy[this.crate_falling] + this.crate_fpvy >> 8) + this.crate.ly) / this.game.bkgnd_cly;
            byte tile_1 = this.game.getMapTile(map_x1, map_y);
            byte tile_2 = this.game.getMapTile(map_x2, map_y);
            if (tile_1 == this.TILE_WATER_1 || tile_2 == this.TILE_WATER_1) {
                this.controls_message_dismiss();
                this.crate_fpvy = 0;
                this.ai_crate_active[this.crate_falling] = false;
                this.crate_falling = -1;
                return;
            }
            if (!this.empty_tile(tile_1) || !this.empty_tile(tile_2)) {
                this.find_intersect_point(this.ai_crate_fpx[this.crate_falling], this.ai_crate_fpy[this.crate_falling] + this.crate_fpvy, this.ai_crate_fpx[this.crate_falling], this.ai_crate_fpy[this.crate_falling] + this.crate_fpvy + (this.crate.ly << 8), (this.ai_crate_fpx[this.crate_falling] >> 8) / this.game.bkgnd_clx * this.game.bkgnd_clx, ((this.ai_crate_fpy[this.crate_falling] + this.crate_fpvy >> 8) + this.crate.ly) / this.game.bkgnd_cly * this.game.bkgnd_cly);
                this.ai_crate_fpx[this.crate_falling] = this.intersect_x;
                this.ai_crate_fpy[this.crate_falling] = this.intersect_y - (this.crate.ly << 8);
                this.crate_fpvy = 0;
                this.crate_falling = -1;
                this.controls_message_dismiss();
                return;
            }
            if (this.crate_fpvy == 2048) {
                if ((this.ai_crate_fpy[this.crate_falling] >> 8) % 8 != 0) {
                    int n = this.crate_falling;
                    this.ai_crate_fpy[n] = this.ai_crate_fpy[n] + (2048 - ((this.ai_crate_fpy[this.crate_falling] >> 8) % 8 << 8));
                } else {
                    int n = this.crate_falling;
                    this.ai_crate_fpy[n] = this.ai_crate_fpy[n] + this.crate_fpvy;
                }
            } else {
                int n = this.crate_falling;
                this.ai_crate_fpy[n] = this.ai_crate_fpy[n] + this.crate_fpvy;
            }
            if ((this.ai_crate_fpy[this.crate_falling] >> 8) + this.crate.ly >= this.game.bkgnd_sly) {
                this.crate_fpvy = 0;
                this.ai_crate_active[this.crate_falling] = false;
                this.crate_falling = -1;
                this.controls_message_dismiss();
                return;
            }
        }
    }

    public void check_crate_collision() {
        if (this.current_worm != null) {
            for (int c = 0; c < this.player_crate_active.length; ++c) {
                if (this.player_crate_active[c] && this.current_worm.fpx >= this.player_crate_fpx[c] && this.current_worm.fpx <= this.player_crate_fpx[c] + (this.crate.lx << 8) && this.current_worm.fpy >= this.player_crate_fpy[c] && this.current_worm.fpy <= this.player_crate_fpy[c] + (this.crate.ly << 8)) {
                    this.get_random_weapon();
                    this.player_crate_active[c] = false;
                }
                if (!this.ai_crate_active[c] || this.current_worm.fpx < this.ai_crate_fpx[c] || this.current_worm.fpx > this.ai_crate_fpx[c] + (this.crate.lx << 8) || this.current_worm.fpy < this.ai_crate_fpy[c] || this.current_worm.fpy > this.ai_crate_fpy[c] + (this.crate.ly << 8)) continue;
                this.get_random_weapon();
                this.ai_crate_active[c] = false;
            }
        }
    }

    private void get_random_weapon() {
        int weapon = this.game.random.nextInt() % 100;
        if (weapon < 0) {
            weapon *= -1;
        }
        for (int x = 0; x < 24; ++x) {
            if (weapon > WEAPON_CHANCE[this.game.convertWeaponItem(x)]) continue;
            if (this.game.everything_unlocked) {
                weapon = x;
                break;
            }
            if (this.players_turn) {
                if (this.player_weapon_menu.item_available((char)x)) {
                    weapon = x;
                    break;
                }
                x = 0;
                weapon = this.game.random.nextInt() % 100;
                continue;
            }
            if (this.ai_weapon_menu.item_available((char)x)) {
                weapon = x;
                break;
            }
            x = 0;
            weapon = this.game.random.nextInt() % 100;
        }
        this.message = this.game.res_get_string(this.weapon_names[this.game.convertWeaponItem(weapon)]);
        this.state_tick = '\u0000';
        if (this.players_turn) {
            this.player_weapon_menu.add_item(weapon, 1);
        } else {
            this.ai_weapon_menu.add_item(weapon, 1);
        }
    }

    public void add_name_to_message(String name) {
        int msg = this.message.indexOf("%");
        if (msg == 0) {
            this.message_buffer = new StringBuffer(name);
            this.message_buffer.append(this.message.substring(1));
        } else if (msg == this.message.length() - 1) {
            this.message_buffer = new StringBuffer(this.message.substring(0, msg));
            this.message_buffer.append(name);
        } else if (msg != -1) {
            this.message_buffer = new StringBuffer(this.message.substring(0, msg));
            this.message_buffer.append(name);
            this.message_buffer.append(this.message.substring(msg + 1));
        }
        this.message = new String(this.message_buffer.toString());
    }

    private void move_target(boolean dir) {
        int old_x = this.homing_map_x--;
        int old_y = this.homing_map_y;
        if (!dir) {
            ++this.homing_map_x;
        }
        byte tile = this.game.getMapTile(this.homing_map_x, this.homing_map_y);
        block0 : switch (tile) {
            case 0: {
                --this.homing_map_y;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                while (!this.empty_tile(tile)) {
                    --this.homing_map_y;
                    if (this.homing_map_y >= 0) {
                        tile = this.game.getMapTile(this.homing_map_x, this.homing_map_y);
                        continue;
                    }
                    this.homing_map_x = old_x;
                    this.homing_map_y = old_y;
                    break block0;
                }
                break;
            }
            default: {
                if (this.empty_tile(tile)) {
                    ++this.homing_map_y;
                    tile = this.game.getMapTile(this.homing_map_x, this.homing_map_y);
                    if (tile != 0 && tile != this.TILE_GROUND_2) {
                        while (this.empty_tile(tile)) {
                            ++this.homing_map_y;
                            tile = this.game.getMapTile(this.homing_map_x, this.homing_map_y);
                        }
                        if (tile == 2 || tile == 3 || tile == 5) break;
                        --this.homing_map_y;
                        break;
                    }
                    --this.homing_map_y;
                    break;
                }
                if (tile == this.TILE_SLOPE_FILLER_L || tile == 4) {
                    --this.homing_map_y;
                    tile = this.game.getMapTile(this.homing_map_x, this.homing_map_y);
                    while (tile == 6 || tile == this.TILE_SLOPE_FILLER_L || tile == 4) {
                        --this.homing_map_y;
                        tile = this.game.getMapTile(this.homing_map_x, this.homing_map_y);
                    }
                    break;
                }
                if (tile != this.TILE_GROUND_2) break;
                --this.homing_map_y;
            }
        }
    }
}

