/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Player {
    public int xPosFP;
    public int yPosFP;
    public int dxFP;
    public int dyFP;
    public int move;
    public int track;
    public int group;
    public int number;
    public int team;
    private int oldMove;
    private int frame;
    private int frameCounter;
    private int animationCounter;
    private int jColour;
    private int sColour;
    private int widthFP;
    private int heightFP;
    private int halfWidthFP;
    private int halfHeightFP;
    private boolean stopped;
    private boolean animation;
    public String name;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int PASS_LEFT = 4;
    public static final int PASS_RIGHT = 5;
    public static final int TACKLE = 6;
    public static final int KICK = 7;
    private static final int UP_PASS_LEFT = 4;
    private static final int UP_PASS_RIGHT = 5;
    private static final int DOWN_PASS_LEFT = 6;
    private static final int DOWN_PASS_RIGHT = 7;
    private static final int LEFT_PASS_LEFT = 8;
    private static final int LEFT_PASS_RIGHT = 5;
    private static final int RIGHT_PASS_LEFT = 6;
    private static final int RIGHT_PASS_RIGHT = 9;
    private static final int TACKLE_UP = 10;
    private static final int TACKLE_DOWN = 11;
    private static final int KICK_UP = 12;
    private static final int KICK_DOWN = 13;
    public final int MAX_SPEED_FP;
    private PlayerGraphics[] plrGrphcs;
    private RugbyPitch pitch;

    public Player(int n, int n2, String string, int n3, int n4, RugbyPitch rugbyPitch) {
        this.MAX_SPEED_FP = 327680;
        this.team = n;
        this.number = n2;
        this.name = string;
        this.jColour = n3;
        this.sColour = n4;
        this.pitch = rugbyPitch;
    }

    public void setPlayerGraphics(PlayerGraphics[] playerGraphicsArray) {
        this.plrGrphcs = playerGraphicsArray;
        this.widthFP = this.plrGrphcs[this.plrGrphcs.length - 1].width << 16;
        this.heightFP = this.plrGrphcs[this.plrGrphcs.length - 1].width << 16;
        this.halfWidthFP = this.widthFP / 2;
        this.halfHeightFP = this.heightFP / 2;
        this.setStopped(true);
    }

    public void setDXFP(int n) {
        this.dxFP = n;
        this.setStopped(false);
        int n2 = this.getMaxSpeedFP();
        if (this.dxFP > n2) {
            this.dxFP = n2;
        } else if (this.dxFP < -n2) {
            this.dxFP = -n2;
        }
        if (n > 0) {
            this.setMove(3, false);
        } else if (n < 0) {
            this.setMove(2, false);
        } else if (this.dyFP == 0) {
            this.setStopped(true);
        }
    }

    public void setDYFP(int n) {
        this.dyFP = n;
        this.setStopped(false);
        int n2 = this.getMaxSpeedFP();
        if (this.dyFP > n2) {
            this.dyFP = n2;
        } else if (this.dyFP < -n2) {
            this.dyFP = -n2;
        }
        if (n > 0) {
            this.setMove(1, false);
        } else if (n < 0) {
            this.setMove(0, false);
        } else if (this.dxFP == 0) {
            this.setStopped(true);
        }
    }

    public void setMove(int n, boolean bl) {
        if (!this.animation || bl) {
            this.oldMove = this.move;
            this.move = n;
            this.animationCounter = 0;
            this.animation = false;
            if (this.move >= 4) {
                this.animationCounter = 0;
                this.animation = true;
                if (this.move == 4) {
                    switch (this.oldMove) {
                        case 0: {
                            this.move = 4;
                            break;
                        }
                        case 1: {
                            this.move = 6;
                            break;
                        }
                        case 2: {
                            this.move = 8;
                            break;
                        }
                        case 3: {
                            this.move = 6;
                        }
                    }
                } else if (this.move == 5) {
                    switch (this.oldMove) {
                        case 0: {
                            this.move = 5;
                            break;
                        }
                        case 1: {
                            this.move = 7;
                            break;
                        }
                        case 2: {
                            this.move = 5;
                            break;
                        }
                        case 3: {
                            this.move = 9;
                        }
                    }
                } else if (this.move == 6) {
                    this.move = this.pitch.getOppositionTeam((int)this.team).tacklingPlayer.yPosFP < this.yPosFP ? 10 : 11;
                } else if (this.move == 7) {
                    switch (this.oldMove) {
                        case 0: {
                            this.move = 12;
                            break;
                        }
                        case 1: {
                            this.move = 13;
                        }
                    }
                }
            }
        }
    }

    public void setStopped(boolean bl) {
        this.stopped = bl;
        if (this.stopped) {
            this.frame = this.plrGrphcs[this.plrGrphcs.length - 1].mvsNfrms[this.move];
        }
    }

    public int getMaxSpeedFP() {
        return this.pitch.getAnyPlayerAssociatedWithBall().team == this.team ? 327680 / 15 : 458752 / 15;
    }

    public int getScaledXPosFP(int n) {
        return RugbyPitch.mul(this.xPosFP, n);
    }

    public int getScaledYPosFP(int n) {
        return RugbyPitch.mul(this.yPosFP, n);
    }

    public void move() {
        this.xPosFP += this.dxFP;
        this.yPosFP += this.dyFP;
        if (this.dxFP != 0) {
            this.pitch.getClass();
            if (this.track != this.xPosFP / 425984) {
                this.pitch.teams[this.team].removePlayerFromTrack(this);
                Team team = this.pitch.teams[this.team];
                this.pitch.getClass();
                team.addPlayerToTrack(this, this.xPosFP / 425984);
            }
        }
        int n = this.pitch.teams[this.team].teamHalf;
        this.pitch.getClass();
        if (n == 1) {
            this.pitch.getClass();
            if (this.yPosFP > 0x6E0000) {
                this.pitch.getClass();
                this.yPosFP = 0x6E0000;
            }
        }
        int n2 = this.pitch.teams[this.team].teamHalf;
        this.pitch.getClass();
        if (n2 == 0) {
            this.pitch.getClass();
            if (this.yPosFP < 0x160000) {
                this.pitch.getClass();
                this.yPosFP = 0x160000;
            }
        }
        if (this.animation) {
            ++this.animationCounter;
            if (this.animationCounter >= 15) {
                this.animation = false;
                this.animationCounter = 0;
                this.move = this.oldMove;
            }
        }
        if (!this.stopped) {
            ++this.frameCounter;
            if (this.frameCounter == 2) {
                this.frameCounter = 0;
                ++this.frame;
                if (this.frame >= this.plrGrphcs[this.plrGrphcs.length - 1].mvsNfrms[this.move]) {
                    this.frame = 0;
                }
            }
        }
    }

    public boolean canCatchBall() {
        return this.pitch.ballZFP < 78643 && this.pitch.ballXFP > this.xPosFP - this.halfWidthFP && this.pitch.ballXFP < this.xPosFP + this.halfWidthFP && this.pitch.ballYFP > this.yPosFP - this.halfHeightFP && this.pitch.ballYFP < this.yPosFP + this.halfHeightFP;
    }

    public boolean collide(Player player, int n) {
        return player.track == this.track && player.getScaledXPosFP(n) >= this.getScaledXPosFP(n) - this.widthFP && player.getScaledXPosFP(n) <= this.getScaledXPosFP(n) + this.widthFP && player.getScaledYPosFP(n) >= this.getScaledYPosFP(n) - this.heightFP && player.getScaledYPosFP(n) <= this.getScaledYPosFP(n) + this.heightFP;
    }

    public boolean inOwnHalf() {
        int n = this.pitch.teams[this.team].teamHalf;
        this.pitch.getClass();
        if (n == 1) {
            this.pitch.getClass();
            if (this.yPosFP > 0x420000) {
                return true;
            }
        }
        int n2 = this.pitch.teams[this.team].teamHalf;
        this.pitch.getClass();
        if (n2 == 0) {
            this.pitch.getClass();
            if (this.yPosFP < 0x420000) {
                return true;
            }
        }
        return false;
    }

    public int[] getBallOffsets(int n) {
        int n2 = this.plrGrphcs.length - 1;
        while (n2 >= 0) {
            if (this.plrGrphcs[n2].minSclFP <= n) {
                return this.plrGrphcs[n2].getBallOffsets(this.move, this.frame);
            }
            --n2;
        }
        return null;
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.plrGrphcs.length - 1;
        while (n4 >= 0) {
            if (this.plrGrphcs[n4].minSclFP <= n3) {
                this.plrGrphcs[n4].drawFrame(graphics, n + (RugbyPitch.mul(this.xPosFP, n3) >> 16), n2 + (RugbyPitch.mul(this.yPosFP, n3) >> 16), this.move, this.frame, this.number, this.jColour, this.sColour);
                n4 = 0;
            }
            --n4;
        }
    }
}

