/*
 * Decompiled with CFR 0.152.
 */
public class MathFP {
    public static long[] sin = new long[360];
    public static long[] asin = new long[201];
    private static final int _fbits = 24;
    private static final int _digits = 8;
    private static final long _one = 0x1000000L;
    private static final long _fmask = 0xFFFFFFL;
    private static final long _dmul = 100000000L;
    private static final long _flt = 0L;
    private static final long _pi = 52707178L;
    private static final long _sqrt = MathFP.calcSqrt(0x1000000L);
    public static final long PI = 52707178L;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final long MIN_VALUE = -9223372036854775807L;

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static long mul(long l, long l2) {
        boolean bl = false;
        int n = 24;
        long l3 = 0xFFFFFFL;
        if ((l & l3) == 0L) {
            return (l >> n) * l2;
        }
        if ((l2 & l3) == 0L) {
            return l * (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (MathFP.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            l3 >>= 1;
            --n;
        }
        long l4 = (l >> n) * (l2 >> n) << n;
        long l5 = (l & l3) * (l2 & l3) >> n;
        if ((l4 = l4 + (l5 += (l & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) * (l2 & l3) >> n) + ((l & l3) * (l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) >> n) << 24 - n) < 0L) {
            l4 = 0x7FFFFFFFFDFFFFFFL;
        }
        return bl ? -l4 : l4;
    }

    public static long div(long l, long l2) {
        boolean bl = false;
        int n = 24;
        if (l2 == 0x1000000L) {
            return l;
        }
        if ((l2 & 0xFFFFFFL) == 0L) {
            return l / (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (MathFP.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            --n;
        }
        long l3 = (l << n) / l2 << 24 - n;
        return bl ? -l3 : l3;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static long sqrt(long l) {
        return MathFP.calcSqrt(l) * _sqrt;
    }

    private static long calcSqrt(long l) {
        long l2 = 0L;
        long l3 = 0x40000000L;
        do {
            if ((l2 ^= l3) * l2 <= l) continue;
            l2 ^= l3;
        } while ((l3 >>= 1) != 0L);
        return l2;
    }

    public static long trueSin(long l) {
        long l2 = l;
        if ((l2 %= 6039797760L) < 0L) {
            l2 = 6039797760L + l2;
        }
        long l3 = l2;
        if (l2 >= 0x5A000000L && l2 < 0x10E000000L) {
            l3 = 0xB4000000L - l2;
        } else if (l2 >= 0x10E000000L && l2 < 6039797760L) {
            l3 = -(6039797760L - l2);
        }
        long l4 = l3 / 90L;
        long l5 = MathFP.mul(l4, l4);
        long l6 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(-73190L, l5) + 1333581L, l5) - 10836755L, l5) + 26353564L, l4);
        return l6;
    }

    public static long sin(long l) {
        int n = (int)l;
        if ((n %= 360) < 0) {
            n = 360 + n;
        }
        return sin[n];
    }

    public static long trueAsin(long l) {
        if (MathFP.abs(l) > 0x1000000L) {
            throw new ArithmeticException("Bad Input");
        }
        boolean bl = l < 0L;
        l = MathFP.abs(l);
        long l2 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(145103L, l) - 599880L, l) + 1420468L, l) - 3592413L, l) + 26353447L;
        long l3 = 26353589L - MathFP.mul(MathFP.sqrt(0x1000000L - l), l2);
        return bl ? -l3 : l3;
    }

    public static long asin(long l) {
        return asin[(int)((l * 100L >> 24) + 100L)];
    }

    public static long cos(long l) {
        return MathFP.sin(90L - l);
    }

    public static long atan(long l) {
        try {
            return MathFP.asin(MathFP.div(l, MathFP.sqrt(0x1000000L + MathFP.mul(l, l))));
        }
        catch (Exception exception) {
            return MathFP.asin(0L);
        }
    }
}

