/*
 * Decompiled with CFR 0.152.
 */
public class MovementVector
implements GameConstants {
    public int x;
    public int y;

    public MovementVector() {
        this.x = 0;
        this.y = 0;
    }

    public MovementVector(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public MovementVector(MovementVector movementVector) {
        this.x = movementVector.x;
        this.y = movementVector.y;
    }

    public void setVector(MovementVector movementVector) {
        this.x = movementVector.x;
        this.y = movementVector.y;
    }

    public void setVector(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public MovementVector minus(MovementVector movementVector) {
        return new MovementVector(this.x - movementVector.x, this.y - movementVector.y);
    }

    public MovementVector plus(MovementVector movementVector) {
        return new MovementVector(this.x + movementVector.x, this.y + movementVector.y);
    }

    public void scaleThis(int n) {
        this.x = Engine.mulAcc(this.x, n);
        this.y = Engine.mulAcc(this.y, n);
    }

    public MovementVector copy() {
        MovementVector movementVector = new MovementVector();
        movementVector.x = this.x;
        movementVector.y = this.y;
        return movementVector;
    }

    public boolean isPreciseZero() {
        return this.x == 0 && this.y == 0;
    }

    public boolean isZero() {
        return Math.abs(this.x) < 256 && Math.abs(this.y) < 256;
    }

    public int getLength() {
        return (int)Engine.sqrt(Engine.getDistance2(0, 0, this.x, this.y));
    }

    public int getAngle() {
        return Engine.getAngle(0, 0, this.x, this.y);
    }

    public boolean isSameAs(MovementVector movementVector) {
        return this.x == movementVector.x && this.y == movementVector.y;
    }

    public boolean isSameAsNoPrecision(MovementVector movementVector) {
        return Engine.p2i(this.x) == Engine.p2i(movementVector.x) && Engine.p2i(this.y) == Engine.p2i(movementVector.y);
    }
}

