/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameWorld
implements GameConstants,
Constants {
    public static boolean GAME_DEBUG = false;
    public boolean slowMotion;
    public int tmpLevelType;
    public static final int N_TICKS = 4;
    public static final int MAX_START_OFFSET = Engine.scale(3);
    public static final int START_INCR = Engine.scale(3);
    public int state;
    public static final int STATE_GAME = 0;
    public static final int STATE_LEVEL_NAME = 1;
    public static final int STATE_CAMERA_PAN = 2;
    public static final int STATE_START = 3;
    public static final int STATE_PAUSE = 4;
    public static final int STATE_FALL_OUT = 5;
    public static final int STATE_TIME_OVER = 6;
    public static final int STATE_END_OF_LEVEL = 7;
    public static final int STATE_GAME_OVER = 8;
    public int subState;
    public static final int STATE_NONE = 0;
    public static final int STATE_CAMERA_PAN_LEVEL = 1;
    public static final int STATE_CAMERA_PAN_PAUSE = 2;
    public static final int STATE_CAMERA_PAN_TO_START = 3;
    public static final int STATE_START_START = 1;
    public static final int STATE_START_READY = 2;
    public static final int STATE_START_GO = 3;
    public static final int STATE_PAUSE_VIEWING = 1;
    public static final int STATE_PAUSE_FOCUSING = 2;
    public static final int STATE_END_OF_LEVEL_INITIAL_PAUSE = 1;
    public static final int STATE_END_OF_LEVEL_VICTORY_DANCE = 2;
    public static final int STATE_END_OF_LEVEL_FLY_UP = 3;
    public static final int STATE_END_OF_LEVEL_MIDDLE_PAUSE = 4;
    public static final int STATE_END_OF_LEVEL_SCORE = 5;
    public static final int STATE_END_OF_LEVEL_STATISTICS = 6;
    public static final int STATE_END_OF_LEVEL_UNLOCKED = 7;
    public static final int STATE_GAME_OVER_TEXT = 1;
    public static final int STATE_GAME_OVER_HIGHSCORE = 2;
    public static final int STATE_GAME_OVER_COMPLETE = 3;
    public int lastStateChangeTime;
    public static boolean settingPlayerCollision;
    public static boolean settingPlayerGravity;
    public static boolean settingMovePlayer;
    public static boolean settingGameOver;
    public static GameWorld instance;
    public static short[] DIRECTIONS;
    public int level;
    public int levelIndex;
    public int levelHighscoreIndex;
    public int levelType;
    public int prevLevelType = -1;
    public boolean isBonus;
    public int mapWidth;
    public int mapHeight;
    public int mapWidthPrecise;
    public int mapHeightPrecise;
    public int mapWidthScaled;
    public int mapHeightScaled;
    public static final boolean LOAD_LEVELS_FROM_JAR = false;
    public static byte[][] LEVELS_MENU;
    public static byte[][] LEVELS_INGAME;
    public int tick;
    public int gameTime;
    public static int playMode;
    public String levelName;
    public int difficulty = 1;
    public static int highscoreIndex;
    public int nBananasThisLevel;
    public int nBananasTotal;
    public int time;
    public int maxTime;
    public int nPlatformsVisited;
    public int distanceTravelled;
    public long endTick;
    public static int currentHighscore;
    public static int[] score;
    public static int[] name;
    public boolean isLevelHighscore;
    public boolean isTotalHighscore;
    public boolean isLevelUnlocked;
    public int[] nBananas;
    public int[] character;
    public int[] nContinues;
    public int[] nLives;
    public int[] playerLevelIndexes;
    public int[] playerLevelTries;
    public int nTicksInAir;
    public int speed;
    public int[] speedValues = new int[5];
    public int avgSpeed;
    public int playerStartPreciseX;
    public int playerStartPreciseY;
    public GameObject goal;
    public int goalLargestNTiles;
    public int timeScore;
    public int timeScoreMultiplier;
    public int levelScore;
    public int levelScoreExceptBananas;
    public int levelDistance;
    public int levelPercentInAir;
    public int lifeScore;
    public static int platformAngle;
    public int viewWidth;
    public int viewHeight;
    public int mapViewX;
    public int mapViewY;
    public int viewMaxSpeed;
    public int viewOffsetY;
    public int hudHeight;
    public MovementVector viewPos = new MovementVector();
    public MovementVector viewVel = new MovementVector();
    public MovementVector viewAcc = new MovementVector();
    public int cameraMode;
    public int cameraPathStep;
    public int[] cameraPath;
    public GameObject firstObject;
    public GameObject lastObject;
    public Vector objectsToAdd = new Vector();
    public Vector objectsToRemove = new Vector();
    public GameObject focusedObject;
    public GameObject player;
    public GameObject[] platformsAndGoals;
    public GameObject[] hazards;
    public GameObject[] pathsChainsAndWalls;
    public GameObject[] pickups;
    public GameObject[] particles;
    public static DeviceImage[] platformTileImages;
    public static DeviceImage[] platformTileBgImages;
    public static DeviceImage hudSpeedImage;
    public static DeviceImage hudTimerImage;
    public static DeviceImage[] hudLivesIconImages;
    public static DeviceImage trackEndImage;
    public static DeviceImage[] goalTileImages;
    public static DeviceImage[] goalTileTransitionImages;
    public static DeviceImage[] goalTileEndImages;
    public static DeviceImage[] hudArrowImages;
    public static DeviceImage[] hudBarImages;
    public static DeviceImage[] platformPivotImages;
    public static DeviceImage[] platformPivotBgImages;
    public static DeviceImage[] goalArrowImages;
    public static DeviceImage[] goalArrowWhiteImages;
    public Image[] cachedHudImages;
    public Image[] cachedPlatformImages;
    public int hudTimerX;
    public int hudTimerY;
    public int hudSecondsX;
    public int hudSecondsY;
    public int hudHundredsX;
    public int hudHundredsY;
    public int hudSecondsSmallOffsetY;
    public int hudLivesIconX;
    public int hudLivesIconY;
    public int hudLivesBarX;
    public int hudLivesBarY;
    public int hudLivesX;
    public int hudLivesY;
    public int hudBananasBarX;
    public int hudBananasBarY;
    public int hudBananasX;
    public int hudBananasY;
    public int hudScoreBarX;
    public int hudScoreBarY;
    public int hudScoreX;
    public int hudScoreY;
    public int hudSpeedBarX;
    public int hudSpeedBarY;
    public int hudSpeedX;
    public int hudSpeedY;
    public int hudPlayerNumberX;
    public int hudPlayerNumberY;
    public int textX;
    public int textY;
    public int textSpeedX;
    public int textSpeedY;
    public int textAccX;
    public int textAccY;
    public boolean extraLife;
    public boolean hurryUp;
    public int endOfLevelStartY;
    public String[] endOfLevelStrings;
    public int[] endOfLevelSpacings;
    public int[] endOfLevelFonts;
    public boolean goalArrowWhite;
    public int goalArrowTickCountdown;
    public static boolean gameWorldInitialized;
    public int startOffsetY;
    public int startIncr;
    public boolean goalHit;
    public int manualArrowsOffset;
    public int manualArrowIncr;
    public boolean resetReference;
    public int nextParticleSpawnTick;
    public byte[] playerBallSprites;
    public int[] timeAttackBestScores;
    public static int bananaAnimationHandle;
    public static int bananaBunchAnimationHandle;
    public static final byte[] PLAYER_SPRITES;
    public static final byte[] PLAYER_BALL_SPRITES;
    public static final int[][] SPRITE_RESOURCES;
    public static final int[] VIEW_OFFSET_DIVIDERS;
    public static final int HUD_BAR_WIDTH;
    public static final int HUD_BAR_HEIGHT;
    public static byte[] SPRITE_PAINT_OFFSETS;
    public static byte[] GOAL_TYPE_MAPPING;
    public static byte[] PAINT_OFFSETS;
    public static byte[] REDUCED_PAINT_OFFSETS;
    public static final int[] LEVEL_RESOURCES;
    public static final byte[] LEVEL_OBJECTS;
    public static final byte[] CHARACTER_SPRITE_MAPPING;
    public static boolean alsoCreatingGameWorld;
    private Vector ingameFeatures;
    public GameObject activePlatform;
    public int pressDirection;
    public static final int PRESSING_NONE = 0;
    public static final int PRESSING_LEFT = 2;
    public static final int PRESSING_RIGHT = 4;
    public static final int PRESSING_BOTH = 8;
    public int forceResumeTicks;
    public int N_ONSCREEN_ROWS = 6;
    public int N_ONSCREEN_SECTIONS = this.N_ONSCREEN_ROWS * this.N_ONSCREEN_ROWS;
    public int mapWidthDiv4;
    public int mapHeightDiv4;
    public GameObject[][] onScreenGrid;
    public int curViewOffsetX;
    public int curViewOffsetY;
    public boolean canScrollUp;
    public boolean canScrollDown;
    public boolean canScrollLeft;
    public boolean canScrollRight;
    public boolean gotoMenu;
    public int paintCountdown;
    public String[] levelNameStrings;
    private Vector strings;
    private Vector fonts;
    private Vector spacings;
    private int height;
    public DeviceImage[] bgImages;
    public static int[][] bgImageResources;
    public int[] cloudGridMapping;
    public int[] cloudGridMappingReversed;
    public int[] cloudGridWidth;
    public int[][] cloudGrid;
    public static final int BG_TYPE_NORMAL = 0;
    public static final int BG_TYPE_CLOUDS = 1;
    public static int[][] bgLayerTypes;
    public static int[][] bgLayerSpeedsX;
    public static int[][] bgLayerSpeedsY;
    public static final int BG_SCROLL_OUTSIDE_TO_BOTTOM = 0;
    public static final int BG_SCROLL_TOP_TO_BOTTOM = 1;
    public static final int BG_SCROLL_TOP_TO_CLOUDS_1 = 2;
    public static final int BG_SCROLL_TOP_TO_CLOUDS_2 = 3;
    public static final int BG_SCROLL_TOP_TO_CLOUDS_3 = 4;
    public static final int BG_SCROLL_TILE = 7;
    public static int[][] bgLayerScrollYTypes;
    public static int[] bgLayerEdgeY;
    public int[] bgLayerY;
    public int[] bgLayerOffsetX;
    Vector[][] vBgData;
    public static final int BG_DATA_RESOURCE = 0;
    public static final int BG_DATA_TYPE = 1;
    public static final int BG_DATA_SPEED_X = 2;
    public static final int BG_DATA_SPEED_Y = 3;
    public static final int BG_DATA_SCROLL_TYPE = 4;
    private final int[] BONUS_BACKGROUND_SIZES = new int[]{Engine.scale(128), Engine.scale(192), Engine.scale(256)};
    private final int[] BONUS_BACKGROUND_SQUARE_SIZES = new int[]{Engine.scale(32), Engine.scale(48), Engine.scale(64)};
    private final int[] BONUS_BACKGROUND_COLORS = new int[]{11468605, 7657794, 3912518, 167498};
    public boolean drawHud;
    public static final byte[] LEVEL_MUSIC_MAPPING;
    public boolean difficultyCompleted;
    public static final short[] GOAL_BONUS_POINTS;
    public int goalScore;
    public boolean saveRms;
    public int viewEdgeLeft;
    public int viewEdgeRight;
    public int viewEdgeUp;
    public int viewEdgeDown;

    public GameWorld(int n, int[] nArray, int n2, int n3) {
        try {
            int n4;
            GameObject.gameWorld = this;
            this.viewWidth = 132;
            this.viewHeight = 176;
            this.viewOffsetY = -(this.viewHeight / VIEW_OFFSET_DIVIDERS[0]);
            if (!gameWorldInitialized) {
                this.loadGfx();
            }
            this.initUIValues();
            if (!gameWorldInitialized) {
                Engine.AnimatedBitmap_initialize(20);
                for (n4 = 0; n4 < 20; ++n4) {
                    if (Engine.getIndexInArray(n4, PLAYER_BALL_SPRITES) != -1 || Engine.getIndexInArray(n4, PLAYER_SPRITES) != -1) continue;
                    this.loadSprite(n4);
                }
                gameWorldInitialized = true;
            }
            Engine.setLoadingPercentage(60);
            this.initBackgrounds();
            Engine.setLoadingPercentage(65);
            playMode = n;
            this.difficulty = n2;
            this.character = nArray;
            score = new int[Engine.nPlayers];
            this.nBananas = new int[Engine.nPlayers];
            this.nContinues = new int[Engine.nPlayers];
            this.nLives = new int[Engine.nPlayers];
            if (n == 0 && Engine.save != null) {
                this.nContinues[Engine.currentPlayer] = Engine.save[0];
                this.nLives[Engine.currentPlayer] = Engine.save[1];
                GameWorld.score[Engine.currentPlayer] = Engine.save[5];
                this.nBananas[Engine.currentPlayer] = Engine.save[6];
            } else {
                for (n4 = 0; n4 < Engine.nPlayers; ++n4) {
                    this.nContinues[n4] = 5;
                    this.nLives[n4] = 2;
                }
            }
            this.playerLevelIndexes = new int[Engine.nPlayers];
            for (n4 = 0; n4 < Engine.nPlayers; ++n4) {
                this.playerLevelIndexes[n4] = n3;
            }
            this.playerLevelTries = new int[Engine.nPlayers];
            if (n == 3 && Engine.nPlayers > 1) {
                this.timeAttackBestScores = new int[Engine.nPlayers];
            }
            Engine.currentPlayer = 0;
            this.playerBallSprites = new byte[Engine.nPlayers];
            for (n4 = 0; n4 < Engine.nPlayers; ++n4) {
                this.playerBallSprites[n4] = Engine.multiplayerPlayMode ? PLAYER_BALL_SPRITES[n4] : PLAYER_BALL_SPRITES[nArray[n4]];
            }
            if (!Engine.Demo_isEnabled() && n == 0 && Engine.save == null) {
                Engine.save = new int[7];
                Engine.save[2] = this.character[Engine.currentPlayer];
                Engine.save[3] = n2;
            }
            this.loadLevel(LEVELS_INGAME[n2][n3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getPlatformColors(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            if (bl) {
                n2 = 3986132;
                n3 = 1019302;
            } else {
                n2 = 2008245;
                n3 = 0;
            }
        } else if (n == 3) {
            n2 = 15118320;
            n3 = 0;
        } else if (n == 1) {
            if (bl) {
                n2 = 15531916;
                n3 = 35328;
            } else {
                n2 = 11599675;
                n3 = 0;
            }
        } else if (n == 2) {
            if (bl) {
                n2 = 15577683;
                n3 = 0x940000;
            } else {
                n2 = 15495936;
                n3 = 0;
            }
        }
        return new int[]{n2, n3};
    }

    public void loadSprite(int n) {
        for (int i = 0; i < SPRITE_RESOURCES[n].length && !Engine.AnimatedBitmap_loadSprite(n, SPRITE_RESOURCES[n][i]); ++i) {
        }
    }

    public void clear() {
        this.goal = null;
        this.clearObjects();
        this.focusedObject = null;
        this.player = null;
        this.platformsAndGoals = null;
        this.hazards = null;
        this.pathsChainsAndWalls = null;
        this.pickups = null;
        this.particles = null;
        this.endOfLevelStrings = null;
        this.ingameFeatures = null;
        this.onScreenGrid = null;
        this.levelNameStrings = null;
        this.bgImages = null;
        this.bgLayerY = null;
        this.bgLayerOffsetX = null;
        System.gc();
    }

    public void initUIValues() {
        short s = GameWorld.hudBarImages[0].width;
        short s2 = GameWorld.hudBarImages[0].height;
        this.hudTimerX = 66;
        this.hudTimerY = Engine.scale(3);
        this.hudSecondsX = this.hudTimerX;
        this.hudSecondsY = this.hudTimerY + (GameWorld.hudTimerImage.height >> 1) + GameWorld.hudTimerImage.height / 5;
        this.hudSecondsY = Device.USE_BITMAP_FONTS ? (this.hudSecondsY += 0) : (this.hudSecondsY += 0);
        this.hudHundredsX = this.hudSecondsX;
        this.hudHundredsY = this.hudSecondsY;
        this.hudSecondsSmallOffsetY = -(Engine.FontManager_lineHeight[1] - Engine.FontManager_lineHeight[0] >> 1);
        if (!Device.USE_BITMAP_FONTS) {
            this.hudSecondsSmallOffsetY += 0;
        }
        int n = 132 - GameWorld.hudTimerImage.width >> 1;
        this.hudLivesBarX = n - s >> 1;
        this.hudLivesBarY = this.hudTimerY + GameWorld.hudTimerImage.height / 10;
        this.hudBananasBarX = 132 - (n - s >> 1);
        this.hudBananasBarY = this.hudLivesBarY;
        this.hudScoreBarX = n - s >> 1;
        this.hudScoreBarY = this.hudTimerY + GameWorld.hudTimerImage.height - s2;
        this.hudSpeedBarX = 132 - (n - s >> 1);
        this.hudSpeedBarY = this.hudScoreBarY;
        this.hudLivesX = this.hudLivesBarX + s - (s - this.numbersWidth(false, Engine.fillZeros("", 4)) >> 1) + 0;
        this.hudLivesY = this.hudLivesBarY + (s2 >> 1) + 0;
        this.hudLivesIconX = this.hudLivesX - this.numbersWidth(false, Engine.fillZeros("", 2)) - GameWorld.hudLivesIconImages[0].width - Engine.scale(3);
        this.hudLivesIconY = this.hudLivesBarY + (s2 >> 1) - (GameWorld.hudLivesIconImages[0].height >> 1);
        this.hudBananasX = this.hudBananasBarX - (s - this.numbersWidth(false, Engine.fillZeros("", 4)) >> 1);
        this.hudBananasY = this.hudLivesY;
        this.hudScoreX = this.hudScoreBarX + s - (s - this.numbersWidth(false, Engine.fillZeros("", 6)) >> 1);
        this.hudScoreY = this.hudSpeedBarY + (s2 >> 1) + 0;
        this.hudSpeedX = this.hudSpeedBarX - (s >> 1) + 0;
        this.hudSpeedY = this.hudScoreY;
        this.hudHeight = this.hudScoreY + Engine.FontManager_lineHeight[0];
        this.hudPlayerNumberX = 3;
        this.hudPlayerNumberY = this.hudHeight;
    }

    public int numbersWidth(boolean bl, String string) {
        if (!Device.USE_BITMAP_FONTS) {
            // empty if block
        }
        return Engine.FontManager_stringWidth(bl ? 1 : 0, string);
    }

    public static void initArrays() {
        try {
            int n;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(Engine.ResourceManager_getResource(65633)));
            GameObject.N_TYPE_INTS = GameWorld.initByteArray(dataInputStream);
            GameObject.N_TYPE_INTS2 = GameWorld.initByteArray(dataInputStream);
            GameObject.N_TYPE_BOOLEANS = GameWorld.initByteArray(dataInputStream);
            GameObject.N_TYPE_OBJECTS = GameWorld.initByteArray(dataInputStream);
            GameObject.N_TYPE_IMAGES = GameWorld.initByteArray(dataInputStream);
            GOAL_TYPE_MAPPING = GameWorld.initByteArray(dataInputStream);
            SPRITE_PAINT_OFFSETS = GameWorld.initByteArray(dataInputStream);
            PAINT_OFFSETS = GameWorld.initByteArray(dataInputStream);
            LEVELS_MENU = new byte[3][];
            for (n = 0; n < 3; ++n) {
                GameWorld.LEVELS_MENU[n] = GameWorld.initByteArray(dataInputStream);
            }
            LEVELS_INGAME = new byte[3][];
            for (n = 0; n < 3; ++n) {
                GameWorld.LEVELS_INGAME[n] = GameWorld.initByteArray(dataInputStream);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] initByteArray(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readByte();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = dataInputStream.readByte();
        }
        return byArray;
    }

    public void loadLevel(int n) {
        this.clear();
        byte[] byArray = Engine.ResourceManager_getResource(LEVEL_RESOURCES[n]);
        this.loadLevel(n, byArray);
    }

    public void loadLevel(int n, byte[] byArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        Engine.startLoading();
        Engine.setLoadingPercentage(alsoCreatingGameWorld ? 70 : 20);
        this.level = n;
        this.levelIndex = Engine.getIndexInArray(this.level, LEVELS_INGAME[this.difficulty]);
        this.levelHighscoreIndex = Engine.getIndexInArray((int)LEVELS_INGAME[this.difficulty][this.levelIndex], LEVELS_MENU[this.difficulty]);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean[] blArray = new boolean[5];
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.levelType = dataInputStream.readByte();
            this.maxTime = dataInputStream.readByte() * 1000;
            this.isBonus = dataInputStream.readBoolean();
            this.mapWidth = dataInputStream.readShort();
            this.mapHeight = dataInputStream.readShort();
            this.mapWidthScaled = Engine.scale(this.mapWidth);
            this.mapHeightScaled = Engine.scale(this.mapHeight);
            this.mapWidthPrecise = Engine.i2p(this.mapWidth);
            this.mapHeightPrecise = Engine.i2p(this.mapHeight);
            this.initBackground();
            this.prevLevelType = this.levelType;
            n5 = 0;
            this.nBananasTotal = 0;
            this.goalLargestNTiles = 0;
            Vector<GameObject> vector = new Vector<GameObject>();
            Vector<GameObject> vector2 = new Vector<GameObject>();
            n4 = dataInputStream.readShort();
            for (n3 = 0; n3 < n4; ++n3) {
                GameObject gameObject;
                int n10;
                byte by = dataInputStream.readByte();
                if (Engine.getIndexInArray((int)by, LEVEL_OBJECTS) != -1) {
                    n2 = dataInputStream.readShort();
                    int n11 = dataInputStream.readShort();
                    if (by == 4) {
                        if (playMode == 3) continue;
                        this.addObject(GameObject.createPickup(0, n2 += SPRITE_PAINT_OFFSETS[4], n11 += SPRITE_PAINT_OFFSETS[5]));
                        ++this.nBananasTotal;
                        ++n9;
                        continue;
                    }
                    if (by == 5) {
                        if (playMode == 3) continue;
                        this.addObject(GameObject.createPickup(1, n2 += SPRITE_PAINT_OFFSETS[6], n11 += SPRITE_PAINT_OFFSETS[7]));
                        this.nBananasTotal += 10;
                        ++n9;
                        continue;
                    }
                    if (by == 6) {
                        this.addObject(GameObject.createBumper(n2 += SPRITE_PAINT_OFFSETS[10], n11 += SPRITE_PAINT_OFFSETS[11]));
                        blArray[4] = true;
                        ++n7;
                        continue;
                    }
                    if (by == 9) {
                        this.addObject(GameObject.createFan(n2 += SPRITE_PAINT_OFFSETS[14], n11 += SPRITE_PAINT_OFFSETS[15], 4));
                        blArray[3] = true;
                        n7 += 2;
                        continue;
                    }
                    if (by == 8) {
                        this.addObject(GameObject.createFan(n2 += SPRITE_PAINT_OFFSETS[14], n11 += SPRITE_PAINT_OFFSETS[15], 8));
                        blArray[3] = true;
                        n7 += 2;
                        continue;
                    }
                    if (by == 11) {
                        this.playerStartPreciseX = Engine.i2p(n2 + 18);
                        this.playerStartPreciseY = Engine.i2p(n11 + 24);
                        continue;
                    }
                    if (by != 7) continue;
                    GameObject gameObject2 = GameObject.createGoal(n2, n11, dataInputStream);
                    this.addObject(gameObject2);
                    ++n6;
                    continue;
                }
                if (by == 12) {
                    n2 = dataInputStream.readByte();
                    int[] nArray = new int[n2 << 1];
                    for (int i = 0; i < nArray.length; i += 2) {
                        short s = dataInputStream.readShort();
                        short s2 = dataInputStream.readShort();
                        nArray[i] = s;
                        nArray[i + 1] = s2;
                    }
                    this.cameraPath = nArray;
                    continue;
                }
                if (by == 3) {
                    int n12;
                    n2 = dataInputStream.readBoolean() ? 1 : 0;
                    int n13 = dataInputStream.readInt();
                    byte by2 = dataInputStream.readByte();
                    Vector<GameObject> vector3 = new Vector<GameObject>();
                    int n14 = -1;
                    n10 = -1;
                    int[] nArray = new int[by2 << 1];
                    int[] nArray2 = new int[by2];
                    for (int i = 0; i < nArray.length; i += 2) {
                        GameObject gameObject3;
                        n12 = dataInputStream.readShort();
                        short s = dataInputStream.readShort();
                        nArray2[i >> 1] = dataInputStream.readBoolean() ? 1 : 0;
                        boolean bl = dataInputStream.readBoolean();
                        nArray[i] = n12;
                        nArray[i + 1] = s;
                        if (!bl) continue;
                        byte by3 = dataInputStream.readByte();
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                        int n15 = (i >> 1) + 1;
                        if (n15 > by2 - 1) {
                            n15 = n2 != 0 ? 0 : by2 - 2;
                        }
                        if (by3 == 7) {
                            gameObject3 = GameObject.createGoal(n12, s, dataInputStream);
                            gameObject3.ints[16] = n15;
                            gameObject3.ints[17] = 1;
                            vector3.addElement(gameObject3);
                            ++n6;
                            continue;
                        }
                        gameObject3 = GameObject.createPlatform(1, n12, s, dataInputStream);
                        gameObject3.ints[31] = n15;
                        vector3.addElement(gameObject3);
                        blArray[0] = true;
                        ++n6;
                    }
                    gameObject = GameObject.createPath(nArray, nArray2, n13);
                    gameObject.booleans[0] = n2;
                    vector2.addElement(gameObject);
                    this.addObject(gameObject);
                    for (n12 = 0; n12 < vector3.size(); ++n12) {
                        GameObject gameObject4 = (GameObject)vector3.elementAt(n12);
                        gameObject4.objects[0] = gameObject4.type == 7 ? gameObject : gameObject;
                        this.calcAndSetMovingPlatformSpeed(gameObject4);
                        this.addObject(gameObject4);
                    }
                    ++n8;
                    continue;
                }
                if (by == 13) {
                    n2 = dataInputStream.readByte();
                    int n16 = n5++;
                    GameObject gameObject5 = null;
                    GameObject gameObject6 = null;
                    int[] nArray = new int[n2 << 1];
                    for (n10 = 0; n10 < nArray.length; n10 += 2) {
                        short s = dataInputStream.readShort();
                        short s3 = dataInputStream.readShort();
                        nArray[n10] = s;
                        nArray[n10 + 1] = s3;
                        dataInputStream.readByte();
                        dataInputStream.readShort();
                        dataInputStream.readShort();
                        gameObject = GameObject.createPlatform(2, s, s3, dataInputStream);
                        gameObject.ints[34] = n16;
                        this.addObject(gameObject);
                        blArray[1] = true;
                        ++n6;
                        if (gameObject6 != null) {
                            gameObject6.objects[2] = gameObject;
                            gameObject6.ints[30] = Engine.getAngle(gameObject6.pos.x, gameObject6.pos.y, gameObject.pos.x, gameObject.pos.y);
                        }
                        if (gameObject5 == null) {
                            gameObject5 = gameObject;
                        }
                        gameObject.objects[1] = gameObject5;
                        gameObject6 = gameObject;
                    }
                    this.addObject(GameObject.createChain(nArray));
                    ++n8;
                    continue;
                }
                if (by == 10) {
                    n2 = dataInputStream.readByte();
                    int[] nArray = new int[n2 << 1];
                    for (int i = 0; i < n2 << 1; i += 2) {
                        short s = dataInputStream.readShort();
                        short s4 = dataInputStream.readShort();
                        nArray[i] = Engine.i2p(s);
                        nArray[i + 1] = Engine.i2p(s4);
                    }
                    this.addObject(GameObject.createWall(nArray));
                    ++n8;
                    continue;
                }
                if (by == 15) {
                    n2 = dataInputStream.readByte();
                    int n17 = -1;
                    int n18 = -1;
                    for (int i = 0; i < n2 << 1; i += 2) {
                        short s = dataInputStream.readShort();
                        n10 = dataInputStream.readShort();
                        if (n17 != -1) {
                            this.addObject(GameObject.createFalloutLine(new int[]{n17 << 8, n18 << 8, s << 8, n10 << 8}));
                        }
                        n17 = s;
                        n18 = n10;
                    }
                    continue;
                }
                n2 = dataInputStream.readShort();
                short s = dataInputStream.readShort();
                int n19 = -1;
                if (by == 0) {
                    n19 = 0;
                } else if (by == 1) {
                    n19 = 1;
                    blArray[0] = true;
                } else if (by == 2) {
                    n19 = 3;
                    blArray[2] = true;
                }
                GameObject gameObject7 = GameObject.createPlatform(n19, n2, s, dataInputStream);
                if (n19 == 1) continue;
                this.addObject(gameObject7);
                ++n6;
                vector.addElement(gameObject7);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Engine.setLoadingPercentage(alsoCreatingGameWorld ? 80 : 50);
        this.cameraPath[this.cameraPath.length - 2] = Engine.p2i(this.playerStartPreciseX);
        this.cameraPath[this.cameraPath.length - 1] = Engine.p2i(this.playerStartPreciseY);
        this.cameraPathStep = 0;
        this.focusedObject = new GameObject(0, Engine.i2p(this.cameraPath[0]), Engine.i2p(this.cameraPath[1]));
        this.viewMaxSpeed = 2048;
        byte by = PLAYER_SPRITES[Engine.startCharacters[Engine.currentPlayer]];
        if (!Engine.AnimatedBitmap_exists(by)) {
            for (n5 = 0; n5 < 4; ++n5) {
                Engine.AnimatedBitmap_eraseSprite(PLAYER_SPRITES[n5]);
            }
            this.loadSprite(by);
        }
        if (!Engine.AnimatedBitmap_exists(n5 = this.playerBallSprites[Engine.currentPlayer])) {
            for (int i = 0; i < this.playerBallSprites.length; ++i) {
                Engine.AnimatedBitmap_eraseSprite(this.playerBallSprites[i]);
            }
            this.loadSprite(n5);
        }
        Engine.setLoadingPercentage(alsoCreatingGameWorld ? 90 : 80);
        this.player = GameObject.createPlayer(Engine.startCharacters[Engine.currentPlayer], -1000, -1000);
        if (!this.isBonus && this.goal.pos.x < this.playerStartPreciseX - 2560) {
            this.player.startAnimation(3);
        }
        this.addObject(this.player);
        this.addObjects();
        this.particles = new GameObject[20];
        this.platformsAndGoals = new GameObject[n6];
        this.hazards = new GameObject[n7];
        this.pathsChainsAndWalls = new GameObject[n8];
        this.pickups = new GameObject[n9];
        int n20 = 0;
        int n21 = 0;
        n4 = 0;
        n3 = 0;
        GameObject gameObject = this.firstObject;
        while (gameObject != null) {
            n2 = -1;
            GameObject[] gameObjectArray = null;
            if (gameObject.type == 2 || gameObject.type == 7) {
                gameObjectArray = this.platformsAndGoals;
                n2 = n20++;
            } else if (gameObject.type == 6 || gameObject.type == 4 || gameObject.type == 5) {
                gameObjectArray = this.hazards;
                n2 = n21++;
            } else if (gameObject.type == 8 || gameObject.type == 11 || gameObject.type == 10) {
                gameObjectArray = this.pathsChainsAndWalls;
                n2 = n4++;
            } else if (gameObject.type == 3) {
                gameObjectArray = this.pickups;
                n2 = n3++;
            }
            if (gameObjectArray != null) {
                gameObject.array = gameObjectArray;
                gameObject.arrayIndex = n2;
                gameObjectArray[n2] = gameObject;
            }
            gameObject = gameObject.nextObject;
        }
        this.setupOnScreenGrid();
        this.setPointTwins();
        if (playMode == 1) {
            GameWorld.score[Engine.currentPlayer] = 0;
            this.nBananas[Engine.currentPlayer] = 0;
        }
        this.isLevelHighscore = false;
        this.isTotalHighscore = false;
        this.isLevelUnlocked = false;
        this.nBananasThisLevel = 0;
        this.time = playMode == 3 ? 0 : this.maxTime;
        this.distanceTravelled = 0;
        this.nPlatformsVisited = 0;
        this.nTicksInAir = 0;
        this.goalHit = false;
        this.startOffsetY = 0;
        this.startIncr = -START_INCR;
        this.goalArrowWhite = false;
        this.goalArrowTickCountdown = -1;
        this.resetReference = true;
        this.difficultyCompleted = false;
        if (this.levelType == 1) {
            this.nextParticleSpawnTick = 25;
        } else if (this.levelType == 2) {
            this.nextParticleSpawnTick = this.getLavaGlowSpawnInterval();
        }
        this.hurryUp = false;
        this.extraLife = false;
        this.paintCountdown = 0;
        bananaAnimationHandle = Engine.AnimatedBitmap_startAnimation(0);
        bananaBunchAnimationHandle = Engine.AnimatedBitmap_startAnimation(0);
        settingPlayerCollision = false;
        settingPlayerGravity = false;
        settingMovePlayer = true;
        settingGameOver = false;
        if (this.playerLevelTries[Engine.currentPlayer] == 0) {
            this.setLevelName();
        } else {
            this.focusedObject.setPosition(Engine.i2p(this.cameraPath[this.cameraPath.length - 2]), Engine.i2p(this.cameraPath[this.cameraPath.length - 1]));
            this.setStart();
        }
        this.scrollView(true);
        this.checkOnScreen();
        this.tickObjects();
        this.putBackgroundLayersInPlace();
        Engine.fadeIn(false, -1);
        Engine.setLoadingPercentage(100);
        n2 = 0;
        if (!Engine.Demo_isEnabled() && playMode == 0) {
            Engine.save[4] = this.levelIndex;
            Engine.save[0] = this.nContinues[Engine.currentPlayer];
            Engine.save[1] = this.nLives[Engine.currentPlayer];
            Engine.save[5] = score[Engine.currentPlayer];
            Engine.save[6] = this.nBananas[Engine.currentPlayer];
            n2 = 1;
        }
        for (int i = 0; i < 5; ++i) {
            if (!blArray[i] || Engine.seenFeatures[i]) continue;
            Engine.seenFeatures[i] = true;
            n2 = 1;
            if (this.ingameFeatures == null) {
                this.ingameFeatures = new Vector();
            }
            this.ingameFeatures.addElement(new Integer(i));
        }
        this.setNextFeature();
        if (n2 != 0) {
            Engine.saveRMS(0);
        }
        this.playMusic();
        Engine.loadingPercentage = -1;
        Engine.stopLoading();
    }

    public void setPointTwins() {
        for (int i = 0; i < this.platformsAndGoals.length; ++i) {
            GameObject gameObject = this.platformsAndGoals[i];
            Vector<GameObject> vector = new Vector<GameObject>();
            for (int j = 0; j < this.platformsAndGoals.length; ++j) {
                boolean bl;
                if (i == j) continue;
                GameObject gameObject2 = this.platformsAndGoals[j];
                if (gameObject.type != 2 || gameObject.ints[16] != 2 || gameObject2.type != 2 || gameObject2.ints[16] != 2 || gameObject.ints[34] != gameObject2.ints[34]) continue;
                boolean bl2 = bl = gameObject.ints2[0].length == gameObject2.ints2[0].length;
                if (bl) {
                    for (int k = 0; k < gameObject.ints2[0].length; ++k) {
                        if (gameObject.ints2[0][k] == gameObject2.ints2[0][k]) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                vector.addElement(gameObject2);
            }
            if (vector.size() <= 0) continue;
            gameObject.pointTwins = new GameObject[vector.size()];
            vector.copyInto(gameObject.pointTwins);
        }
    }

    public int getLavaGlowSpawnInterval() {
        int n = 100 * Engine.p2i(this.viewPos.y) / this.mapHeight;
        return Math.max(3, 100 - n >> 4);
    }

    public void setNextFeature() {
        if (this.ingameFeatures != null && this.ingameFeatures.size() > 0) {
            int n = (Integer)this.ingameFeatures.elementAt(0);
            this.ingameFeatures.removeElementAt(0);
            if (this.ingameFeatures.size() == 0) {
                this.ingameFeatures = null;
            }
            Engine.currentForm = 9;
            Engine.MenuManager_dontUnloadResources = true;
            Engine.MenuManager_setForm(null, Engine.getText(36 + n + 1), 10, -1, -1);
            Engine.MenuManager_dontUnloadResources = false;
            Engine.MenuManager_menuAction[14] = true;
        } else {
            this.ingameFeatures = null;
            Engine.MenuManager_toGame();
            this.drawHud = true;
            Engine.state = 100;
        }
    }

    private void clearObjects() {
        GameObject gameObject = this.firstObject;
        while (gameObject != null) {
            GameObject gameObject2 = gameObject.nextObject;
            gameObject.prevObject = null;
            gameObject.nextObject = null;
            gameObject.array = null;
            gameObject.arrayIndexOnScreenArray = null;
            gameObject = gameObject2;
        }
        this.firstObject = null;
        this.lastObject = null;
    }

    private void loadGfx() {
        Engine.setLoadingPercentage(15);
        hudLivesIconImages = new DeviceImage(65550).divide(4);
        goalArrowImages = new DeviceImage(65539).divide(8);
        goalArrowWhiteImages = new DeviceImage(Engine.insertPLTE(Engine.ResourceManager_getResource(65539), Engine.ResourceManager_getResource(65540))).divide(8);
        Engine.setLoadingPercentage(20);
        hudArrowImages = new DeviceImage(65541).divide(4);
        hudBarImages = new DeviceImage(65542).divide(4);
        Engine.setLoadingPercentage(25);
        platformPivotImages = new DeviceImage(65638).divide(3);
        platformTileImages = new DeviceImage(65639).divide(7);
        Engine.setLoadingPercentage(30);
        goalTileImages = new DeviceImage(65560).divide(4);
        goalTileTransitionImages = new DeviceImage(65561).divide(10);
        goalTileEndImages = new DeviceImage(65559).divide(8);
        hudTimerImage = new DeviceImage(65562);
        trackEndImage = new DeviceImage(65564);
        Engine.setLoadingPercentage(40);
    }

    public static DeviceImage[] divideImageByName(int n, int n2) {
        DeviceImage[] deviceImageArray = new DeviceImage[n2];
        for (int i = 0; i < n2; ++i) {
            deviceImageArray[i] = new DeviceImage(n + i);
        }
        return deviceImageArray;
    }

    public static DeviceImage getGoalTileImage(int n) {
        if (n < 10) {
            return goalTileImages[n];
        }
        if (n < 20) {
            return goalTileTransitionImages[n - 10];
        }
        return goalTileEndImages[n - 20];
    }

    public void setState(int n) {
        this.setState(n, 0);
    }

    public void setState(int n, int n2) {
        this.state = n;
        this.subState = n2;
        this.lastStateChangeTime = this.gameTime;
    }

    public boolean isState(int n) {
        return this.state == n;
    }

    public boolean isState(int n, int n2) {
        return this.state == n && this.subState == n2;
    }

    public boolean isAtLeastState(int n, int n2) {
        return this.state == n && this.subState >= n2;
    }

    public boolean playersLeft() {
        for (int i = 0; i < Engine.nPlayers; ++i) {
            if (this.nLives[i] < 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasMorePlayersThisRound() {
        for (int i = Engine.currentPlayer + 1; i < Engine.nPlayers; ++i) {
            if (this.nLives[i] < 0 || this.playerLevelIndexes[Engine.currentPlayer] > LEVELS_INGAME[this.difficulty].length - 1) continue;
            return true;
        }
        return false;
    }

    public boolean nextPlayer() {
        int n = Engine.currentPlayer;
        int n2 = 0;
        do {
            Engine.currentPlayer = (Engine.currentPlayer + 1) % Engine.nPlayers;
            if (n2 > Engine.nPlayers) {
                return false;
            }
            ++n2;
        } while (this.nLives[Engine.currentPlayer] == -1 || this.playerLevelIndexes[Engine.currentPlayer] > LEVELS_INGAME[this.difficulty].length - 1);
        return true;
    }

    public void tick() {
        int n;
        if (Engine.cheatOn) {
            if (Engine.key(16384)) {
                if (Engine.multiplayerPlayMode) {
                    int n2 = Engine.currentPlayer;
                    this.playerLevelIndexes[n2] = this.playerLevelIndexes[n2] + 1;
                } else {
                    if (this.getNextLevel(this.levelIndex) != -1) {
                        Engine.fadeOut(false, 10);
                        return;
                    }
                    if (!this.isState(7)) {
                        this.player.stop();
                        settingPlayerGravity = false;
                        this.setLevelComplete(0);
                    }
                }
            }
            if (Engine.key(4096)) {
                Engine.fadeOut(false, 11);
                return;
            }
            if (Engine.key(512) && !this.isState(7)) {
                this.player.stop();
                settingPlayerGravity = false;
                this.setLevelComplete(0);
            }
        }
        this.pressDirection = 0;
        if (this.activePlatform != null && this.activePlatform.ints[16] != 3) {
            if (Engine.isPressed(4)) {
                this.pressDirection |= 2;
            } else if (Engine.isPressed(8)) {
                this.pressDirection |= 4;
            }
        }
        if (this.isState(0) || this.isState(4)) {
            if (Engine.key(128)) {
                this.togglePause();
            }
            if (this.isState(4, 2)) {
                int n3 = n = !this.canScrollLeft || !this.canScrollRight || !this.canScrollDown ? 1 : 0;
                if (n != 0) {
                    ++this.forceResumeTicks;
                }
                if (this.forceResumeTicks > 3 || Math.abs(this.viewPos.x - this.player.pos.x) < Engine.i2p(5) && Math.abs(this.viewPos.y - this.player.pos.y + Engine.i2p(this.viewOffsetY)) < Engine.i2p(5)) {
                    this.viewMaxSpeed = 2816;
                    this.setState(0);
                }
            }
        }
        this.player.booleans[0] = false;
        if (this.isState(0) && this.gameTime >= this.player.ints[0] + 500) {
            if ((this.pressDirection & 2) != 0) {
                this.player.acc.x -= 32;
                this.player.booleans[0] = true;
            } else if ((this.pressDirection & 4) != 0) {
                this.player.acc.x += 32;
                this.player.booleans[0] = true;
            }
        }
        if (this.extraLife && this.textSpeedY >= 0) {
            this.extraLife = false;
        }
        if (this.hurryUp && this.textX >= this.viewWidth + Engine.scale(50)) {
            this.hurryUp = false;
        }
        if (!this.isBonus && (this.isState(3) || this.isState(0) || this.isState(4))) {
            if (this.goalArrowWhite) {
                this.goalArrowWhite = false;
            } else if (this.goalArrowTickCountdown > 0) {
                --this.goalArrowTickCountdown;
                if (this.goalArrowTickCountdown == 0) {
                    this.goalArrowTickCountdown = -1;
                    this.goalArrowWhite = true;
                }
            } else {
                n = Engine.getDistance(this.viewPos.x, this.viewPos.y, this.goal.pos.x, this.goal.pos.y);
                this.goalArrowTickCountdown = Math.max(1, n / 20000);
                if (this.goalArrowTickCountdown > 20) {
                    this.goalArrowTickCountdown = -1;
                }
            }
        }
        if (this.textAccX != 0) {
            this.textSpeedX += this.textAccX;
        }
        if (this.textAccY != 0) {
            this.textSpeedY += this.textAccY;
        }
        if (this.textSpeedX != 0) {
            this.textX += this.textSpeedX;
        }
        if (this.textSpeedY != 0) {
            this.textY += this.textSpeedY;
        }
        if (this.textY < this.hudHeight + Engine.FontManager_lineHeight[1]) {
            this.textY = this.hudHeight + Engine.FontManager_lineHeight[1];
        }
        for (n = 0; n < this.platformsAndGoals.length; ++n) {
            GameObject gameObject = this.platformsAndGoals[n];
            if (gameObject.pointTwins == null) continue;
            gameObject.booleans[6] = false;
            gameObject.booleans[7] = false;
        }
        if (this.isState(0)) {
            this.tickActivePlatform();
        }
        if (!this.isState(4)) {
            int n4;
            this.tickPlatforms();
            this.computeForces();
            this.moveObjects();
            if (this.resetReference) {
                this.player.ints[5] = this.player.vel.x;
            } else {
                this.resetReference = true;
            }
            n = 64;
            for (n4 = 0; n4 < 4; ++n4) {
                if (this.isState(0)) {
                    this.moveAndRotatePlatforms(n);
                }
                if (settingMovePlayer) {
                    this.moveObject(this.player, n);
                }
                if (!settingPlayerCollision) continue;
                this.checkCollision(this.player, n);
            }
            if (!(this.state != 0 || this.player.collided || this.player.collisionY <= this.mapHeightPrecise && this.player.collisionX >= -46080 && this.player.collisionX + this.player.collisionWidth <= this.mapWidthPrecise + 46080)) {
                this.setFallout();
            }
            this.updatePlatformDrawPoints();
            this.scrollView(false);
            this.tickObjects();
            this.removeObjects();
            this.addObjects();
            this.checkOnScreen();
            if (this.isState(0)) {
                this.findActivePlatform();
            }
            if (this.levelType == 1) {
                if (this.tick >= this.nextParticleSpawnTick) {
                    this.nextParticleSpawnTick = this.tick + 25;
                    if (Engine.rndPositive(100) < 70) {
                        n4 = this.viewPos.x;
                        n4 = this.player.vel.x > 0 ? (n4 += Engine.i2p(Engine.unScale(this.viewWidth >> 2))) : (n4 -= Engine.i2p(Engine.unScale(this.viewWidth >> 2)));
                        GameObject gameObject = GameObject.createParticle(1, 10, n4 + Engine.rnd(Engine.i2p(this.viewWidth << 1)), this.viewPos.y + Engine.i2p((this.viewHeight >> 1) - this.viewOffsetY));
                        gameObject.removeAfterAnimationWrapped = false;
                        gameObject.vel.y = -(256 + Engine.rndPositive(256));
                        this.addObject(gameObject);
                    } else {
                        GameObject gameObject = GameObject.createParticle(4, Engine.rndPositive(100) < 50 ? 17 : 18, 0, this.viewPos.y + Engine.i2p(this.viewHeight / 3) + Engine.rnd(Engine.i2p(2 * this.viewHeight / 3)) - Engine.i2p(this.viewOffsetY));
                        gameObject.removeAfterAnimationWrapped = false;
                        if (this.player.vel.x < -1280 || Engine.rndPositive(100) < 50) {
                            gameObject.setX(this.viewPos.x - Engine.i2p(Engine.unScale(this.viewWidth >> 1) + Engine.AnimatedBitmap_getWidth(17)));
                            gameObject.vel.x = 256 + Engine.rndPositive(512);
                            gameObject.startAnimation(1);
                        } else {
                            gameObject.setX(this.viewPos.x + Engine.i2p(Engine.unScale(this.viewWidth >> 1) + Engine.AnimatedBitmap_getWidth(17)));
                            gameObject.vel.x = -(256 + Engine.rndPositive(512));
                            gameObject.startAnimation(0);
                        }
                        this.addObject(gameObject);
                    }
                }
            } else if (this.levelType == 2 && this.tick >= this.nextParticleSpawnTick) {
                this.nextParticleSpawnTick = this.tick + this.getLavaGlowSpawnInterval();
                n4 = this.viewPos.x;
                n4 = this.player.vel.x > 0 ? (n4 += Engine.i2p(Engine.unScale(this.viewWidth >> 2))) : (n4 -= Engine.i2p(Engine.unScale(this.viewWidth >> 2)));
                GameObject gameObject = GameObject.createParticle(3, -1, n4 + Engine.rnd(Engine.i2p(this.viewWidth << 1)), this.viewPos.y + Engine.i2p((this.viewHeight >> 1) - this.viewOffsetY));
                gameObject.removeAfterAnimationWrapped = false;
                gameObject.booleans[0] = true;
                gameObject.ints[1] = gameObject.pos.x;
                gameObject.keepAcceleration = true;
                gameObject.vel.x = -(256 + Engine.rndPositive(5) * 256);
                gameObject.acc.x = -(gameObject.vel.x >> 2);
                gameObject.vel.y = -256 - Engine.rndPositive(768);
                gameObject.ints[2] = 1 + Engine.rndPositive(3);
                int n5 = 1500 + Engine.rndPositive(3000);
                gameObject.removeTime = this.gameTime + n5;
                int n6 = n5 / 50;
                gameObject.ints[3] = 16762880;
                gameObject.ints[4] = -(135 / n6 << 16);
                gameObject.ints[5] = -(174 / n6 << 8);
                this.addObject(gameObject);
            }
        } else {
            this.scrollView(false);
            GameObject gameObject = this.firstObject;
            while (gameObject != null) {
                if (!(gameObject.type != 2 && gameObject.type != 8 && gameObject.type != 10 && gameObject.type != 11 && gameObject.type != 7 || gameObject.type == 7 && gameObject.objects[0] == null || gameObject.type == 2 && gameObject.ints[16] != 1)) {
                    gameObject.onScreen = gameObject.isOnScreen();
                }
                gameObject = gameObject.nextObject;
            }
            this.checkOnScreen();
        }
        ++this.tick;
        this.gameTime += 50;
        if (this.gameTime > 2147483547) {
            this.tick = 0;
            this.gameTime = 0;
        }
        if (this.state == 0) {
            int n7 = this.time;
            if (playMode == 3) {
                this.time += 50;
                if (this.time > 599990) {
                    this.time = 599990;
                    this.setTimeOver();
                }
            } else {
                this.time -= 50;
                if (n7 >= 10000 && this.time < 10000) {
                    this.hurryUp = true;
                    this.textX = -Engine.scale(50);
                    this.textAccX = 0;
                    this.textSpeedX = Engine.scale(13);
                    Device.soundFunction(3, 7);
                }
                if (this.time < 0) {
                    this.time = 0;
                    this.setTimeOver();
                }
            }
        }
        this.calculateSpeed();
        if ((this.isState(2, 1) || this.isState(1)) && (Engine.keyFire() || Engine.key(64))) {
            this.focusedObject.setPosition(Engine.i2p(this.cameraPath[this.cameraPath.length - 2]), Engine.i2p(this.cameraPath[this.cameraPath.length - 1]));
            this.viewMaxSpeed = 15360;
            this.cameraMode = 0;
            this.setState(2, 3);
        }
        if (this.isState(3)) {
            if (this.isAtLeastState(3, 2) && (Engine.keyFire() || Engine.key(64))) {
                this.startDone();
            }
            if (!this.isState(3, 3) && this.tick % 2 == 0) {
                GameObject gameObject = GameObject.createParticle(0, Engine.rndPositive(2) == 0 ? 4 : 11, this.playerStartPreciseX, this.playerStartPreciseY + 2048 + Engine.rnd(10240));
                gameObject.booleans[0] = true;
                gameObject.booleans[1] = Engine.rndPositive(2) == 0;
                gameObject.ints[1] = this.playerStartPreciseX;
                gameObject.animate = false;
                gameObject.keepAcceleration = true;
                gameObject.vel.x = -(5120 + Engine.rndPositive(5) * 256);
                gameObject.acc.x = -(gameObject.vel.x >> 2);
                gameObject.vel.y = -Engine.rndPositive(768);
                this.addObject(gameObject);
            }
            switch (this.subState) {
                case 1: {
                    if (this.gameTime <= this.lastStateChangeTime + 300) break;
                    this.player.spriteNAnimTelapsPerTick = 8;
                    this.player.ints[2] = 6;
                    this.player.startAnimation(6);
                    this.player.setPosition(this.playerStartPreciseX, this.playerStartPreciseY);
                    this.focusedObject = this.player;
                    this.textX = 0;
                    this.textSpeedX = Engine.scale(26);
                    this.textAccX = -2;
                    this.textY = this.viewHeight >> 1;
                    this.textSpeedY = 0;
                    this.textAccY = 0;
                    Engine.releaseKey(16);
                    Engine.releaseKey(65536);
                    Engine.releaseKey(64);
                    this.setState(3, 2);
                    break;
                }
                case 2: {
                    this.textSpeedX = Math.max(4, Math.abs((this.viewWidth >> 1) - this.textX) >> 1);
                    this.player.acc.y = -8;
                    if (this.gameTime <= this.lastStateChangeTime + 1000) break;
                    this.textX = this.viewWidth >> 1;
                    this.textSpeedX = 0;
                    this.textAccX = -8;
                    this.textY = 0;
                    this.textSpeedY = 0;
                    this.textAccY = 0;
                    this.setState(3, 3);
                    break;
                }
                case 3: {
                    if (this.textX < 0) {
                        this.textX = 0;
                        this.textSpeedX = 0;
                    }
                    if (this.gameTime <= this.lastStateChangeTime + 600) break;
                    this.startDone();
                }
            }
            this.startOffsetY += this.startIncr;
            if (this.startOffsetY < -MAX_START_OFFSET) {
                this.startOffsetY = -MAX_START_OFFSET;
                this.startIncr = START_INCR;
            } else if (this.startOffsetY > MAX_START_OFFSET) {
                this.startOffsetY = MAX_START_OFFSET;
                this.startIncr = -START_INCR;
            }
        } else if (this.isState(7)) {
            switch (this.subState) {
                case 1: {
                    if (this.gameTime <= this.lastStateChangeTime + 800) break;
                    this.player.startAnimation(5);
                    Engine.releaseAllKeys();
                    this.setState(7, 2);
                    break;
                }
                case 2: {
                    if (!Engine.keyFire() && !Engine.key(64) && this.gameTime <= this.lastStateChangeTime + 1500) break;
                    this.player.vel.y = -6144;
                    this.viewMaxSpeed = 12288;
                    this.player.startAnimation(6);
                    settingPlayerGravity = false;
                    settingPlayerCollision = false;
                    this.setState(7, 3);
                    break;
                }
                case 3: {
                    if (Engine.keyFire() || Engine.key(64)) {
                        Engine.releaseAllKeys();
                        this.addScore(this.levelScoreExceptBananas);
                        this.setEndOfLevelStrings(7, 5);
                        this.setState(7, 5);
                        break;
                    }
                    if (this.player.spriteY - this.player.spritePaintOffsetY >= -this.viewHeight) break;
                    this.addScore(this.levelScoreExceptBananas);
                    this.setEndOfLevelStrings(7, 5);
                    this.setState(7, 5);
                    break;
                }
                case 5: {
                    if (!Engine.keyFire() && !Engine.key(64)) break;
                    this.setEndOfLevelStrings(7, 6);
                    this.setState(7, 6);
                    break;
                }
                case 6: {
                    if (!Engine.keyFire() && !Engine.key(64)) break;
                    if (playMode == 1 || playMode == 3) {
                        if (Engine.multiplayerPlayMode) {
                            Engine.fadeOut(false, 10);
                            break;
                        }
                        Engine.fadeOut(false, 11);
                        break;
                    }
                    int n8 = this.getNextLevel(this.levelIndex);
                    if (n8 == -1) {
                        this.checkTotalScore();
                    }
                    if (this.isLevelUnlocked) {
                        this.setEndOfLevelStrings(7, 7);
                        this.setState(7, 7);
                        break;
                    }
                    if (n8 == -1) {
                        this.setGameOver(true);
                        break;
                    }
                    Engine.fadeOut(false, 10);
                    break;
                }
                case 7: {
                    if (!Engine.keyFire() && !Engine.key(64)) break;
                    if (this.getNextLevel(this.levelIndex) == -1) {
                        this.setGameOver(true);
                        break;
                    }
                    Engine.fadeOut(false, 10);
                }
            }
        } else if (this.isState(2)) {
            if (this.isState(2, 1)) {
                int n9;
                boolean bl = this.cameraPathStep > (this.cameraPath.length >> 1) - 2;
                int n10 = n9 = bl ? 5120 : 12800;
                if (Math.abs(this.viewPos.x - this.focusedObject.pos.x) < n9 && Math.abs(this.viewPos.y - this.focusedObject.pos.y) < n9) {
                    ++this.cameraPathStep;
                    if (this.cameraPathStep > (this.cameraPath.length >> 1) - 1) {
                        this.cameraMode = 0;
                        this.setState(2, 2);
                    } else {
                        this.focusedObject.setPosition(Engine.i2p(this.cameraPath[this.cameraPathStep << 1]), Engine.i2p(this.cameraPath[(this.cameraPathStep << 1) + 1]));
                    }
                }
            } else if (this.isState(2, 2)) {
                if (this.gameTime > this.lastStateChangeTime + 400) {
                    this.setStart();
                }
            } else if (this.isState(2, 3) && Math.abs(this.viewPos.x + this.curViewOffsetX - this.focusedObject.pos.x) <= 2560 && Math.abs(this.viewPos.y + this.curViewOffsetY - this.focusedObject.pos.y) <= 2560) {
                this.setState(2, 2);
            }
        } else if (this.isState(1)) {
            if (this.gameTime > this.lastStateChangeTime + 500) {
                this.setCameraPan();
            }
        } else if (this.isState(5)) {
            if (this.textY > this.viewHeight >> 1) {
                this.textY = this.viewHeight >> 1;
                if (this.textSpeedY > Engine.scale(8)) {
                    this.textSpeedY = -Engine.scale(5);
                } else {
                    this.textAccY = 0;
                    this.textSpeedY = 0;
                }
            }
            if (!Engine.fading() && (Engine.keyFire() || Engine.key(64) || this.gameTime > this.lastStateChangeTime + 2000)) {
                this.checkGameOver();
            }
        } else if (this.isState(6)) {
            if (!Engine.fading() && (Engine.keyFire() || Engine.key(64) || this.gameTime > this.lastStateChangeTime + 2000)) {
                this.checkGameOver();
            }
        } else if (this.isState(8)) {
            if (this.isState(8, 1)) {
                if (Engine.keyFire() || Engine.key(64)) {
                    if (this.isTotalHighscore) {
                        this.setEndOfLevelStrings(8, 2);
                        this.setState(8, 2);
                    } else {
                        Engine.fadeOut(false, 13);
                    }
                }
            } else if (this.isState(8, 3)) {
                if (Engine.keyFire() || Engine.key(64)) {
                    this.setEndOfLevelStrings(8, 2);
                    this.setState(8, 2);
                }
            } else if (this.isState(8, 2) && (Engine.keyFire() || Engine.key(64))) {
                Engine.fadeOut(false, 13);
            }
        }
        if (this.cameraMode == 2) {
            this.manualArrowsOffset += this.manualArrowIncr;
            if (this.manualArrowsOffset >= 3) {
                this.manualArrowIncr = -1;
            } else if (this.manualArrowsOffset <= 0) {
                this.manualArrowIncr = 1;
            }
        }
        if (Engine.key(64)) {
            if (playMode == 1 || playMode == 3) {
                Engine.MenuManager_setMenu(5, 0);
            } else if (playMode == 0 || playMode == 2) {
                Engine.MenuManager_setMenu(4, 0);
            }
            return;
        }
    }

    public void setupOnScreenGrid() {
        int n;
        int n2;
        int n3;
        GameObject[] gameObjectArray = new GameObject[this.platformsAndGoals.length + this.hazards.length + this.pickups.length];
        int n4 = 0;
        for (n3 = 0; n3 < this.platformsAndGoals.length; ++n3) {
            GameObject gameObject = this.platformsAndGoals[n3];
            if ((gameObject.type != 2 || gameObject.ints[16] == 1) && (gameObject.type != 7 || gameObject.objects[0] != null)) continue;
            gameObjectArray[n4++] = this.platformsAndGoals[n3];
        }
        for (n3 = 0; n3 < this.hazards.length; ++n3) {
            gameObjectArray[n4++] = this.hazards[n3];
        }
        for (n3 = 0; n3 < this.pickups.length; ++n3) {
            gameObjectArray[n4++] = this.pickups[n3];
        }
        this.mapWidthDiv4 = this.mapWidthPrecise / this.N_ONSCREEN_ROWS;
        this.mapHeightDiv4 = this.mapHeightPrecise / this.N_ONSCREEN_ROWS;
        this.onScreenGrid = new GameObject[this.N_ONSCREEN_SECTIONS][];
        Vector[] vectorArray = new Vector[this.N_ONSCREEN_SECTIONS];
        for (n2 = 0; n2 < gameObjectArray.length && gameObjectArray[n2] != null; ++n2) {
            int n5 = gameObjectArray[n2].pos.y / this.mapHeightDiv4;
            n = gameObjectArray[n2].pos.x / this.mapWidthDiv4;
            n4 = n5 * this.N_ONSCREEN_ROWS + n;
            if (vectorArray[n4] == null) {
                vectorArray[n4] = new Vector();
            }
            vectorArray[n4].addElement(gameObjectArray[n2]);
        }
        for (n2 = 0; n2 < this.N_ONSCREEN_SECTIONS; ++n2) {
            if (vectorArray[n2] == null) continue;
            this.onScreenGrid[n2] = new GameObject[vectorArray[n2].size()];
            vectorArray[n2].copyInto(this.onScreenGrid[n2]);
            for (n = 0; n < this.onScreenGrid[n2].length; ++n) {
                this.onScreenGrid[n2][n].arrayIndexOnScreenIndex = n;
                this.onScreenGrid[n2][n].arrayIndexOnScreenArray = this.onScreenGrid[n2];
            }
        }
    }

    public void checkOnScreen() {
        this.viewEdgeLeft = this.mapViewX;
        this.viewEdgeRight = this.mapViewX + this.viewWidth;
        this.viewEdgeUp = this.mapViewY;
        this.viewEdgeDown = this.mapViewY + this.viewHeight;
        boolean bl = Math.abs(this.viewVel.x) >= 6400 || Math.abs(this.viewVel.y) >= 6400;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!bl) {
            n = Engine.unScale(this.viewWidth << 1 << 8);
            n2 = Engine.unScale(this.viewEdgeDown - this.viewEdgeUp << 1 << 8);
            n3 = this.viewPos.x - (n >> 1);
            n4 = this.viewPos.y - (n2 >> 1);
        }
        for (int i = 0; i < this.N_ONSCREEN_SECTIONS; ++i) {
            if (this.onScreenGrid[i] == null) continue;
            int n5 = i % this.N_ONSCREEN_ROWS * this.mapWidthDiv4;
            int n6 = i / this.N_ONSCREEN_ROWS * this.mapHeightDiv4;
            if (!bl && !Engine.intersectsRectRect(n3, n4, n, n2, n5, n6, this.mapWidthDiv4, this.mapHeightDiv4)) continue;
            for (int j = 0; j < this.onScreenGrid[i].length; ++j) {
                if (this.onScreenGrid[i][j] == null) continue;
                this.onScreenGrid[i][j].onScreen = this.onScreenGrid[i][j].isOnScreen();
            }
        }
    }

    public void tickObjects() {
        bananaAnimationHandle = Engine.AnimatedBitmap_tickAnimation(2, bananaAnimationHandle, 1);
        bananaBunchAnimationHandle = Engine.AnimatedBitmap_tickAnimation(3, bananaBunchAnimationHandle, 1);
        GameObject gameObject = this.firstObject;
        while (gameObject != null) {
            if (!gameObject.keepAcceleration) {
                gameObject.acc.setVector(0, 0);
            }
            if (gameObject.type != 3) {
                gameObject.tick();
            }
            gameObject = gameObject.nextObject;
        }
    }

    public void startDone() {
        if (!this.isBonus && this.goal.pos.x < this.playerStartPreciseX - 2560) {
            this.player.startAnimation(3);
        } else {
            this.player.startAnimation(2);
        }
        settingPlayerGravity = true;
        settingPlayerCollision = true;
        this.setState(0);
    }

    public void checkGameOver() {
        int n = Engine.currentPlayer;
        this.playerLevelTries[n] = this.playerLevelTries[n] + 1;
        if (playMode == 1 || playMode == 3) {
            Engine.fadeOut(false, 11);
        } else if (!this.isBonus && this.nLives[Engine.currentPlayer] == 0) {
            int n2 = Engine.currentPlayer;
            this.nLives[n2] = this.nLives[n2] - 1;
            if (!Engine.Demo_isEnabled() && this.nContinues[Engine.currentPlayer] > 0) {
                this.playerLevelTries[Engine.currentPlayer] = 0;
                Engine.fadeOut(false, 4);
            } else {
                this.setGameOver(false);
            }
        } else if (this.isBonus) {
            int n3 = Engine.currentPlayer;
            this.playerLevelIndexes[n3] = this.playerLevelIndexes[n3] + 1;
            Engine.fadeOut(false, 10);
        } else {
            Engine.fadeOut(false, 12);
        }
    }

    public void tickPlatforms() {
        for (int i = 0; i < this.platformsAndGoals.length; ++i) {
            GameObject gameObject = this.platformsAndGoals[i];
            if (gameObject.type != 2) continue;
            if (gameObject.ints[16] == 2) {
                if (gameObject == this.activePlatform && this.pressDirection != 0) continue;
                gameObject.ints[18] = gameObject.ints[18] + -gameObject.ints[17];
                if (Math.abs(gameObject.ints[17]) >= 10) continue;
                gameObject.ints[17] = 0;
                gameObject.ints[18] = 0;
                continue;
            }
            if (gameObject.ints[16] == 3) {
                gameObject.ints[18] = gameObject.ints[18] + -(gameObject.ints[17] >> 1);
                continue;
            }
            if (gameObject.booleans[0] && this.pressDirection != 0) continue;
            if (Math.abs(gameObject.ints[21]) > 0) {
                if (Math.abs(gameObject.ints[21]) <= 256) {
                    gameObject.ints[17] = gameObject.ints[21];
                    continue;
                }
                gameObject.ints[17] = gameObject.ints[21] >> 2;
                if (gameObject.ints[29] == 2) {
                    gameObject.ints[17] = gameObject.ints[21] < 0 ? gameObject.ints[17] - gameObject.ints[26] : gameObject.ints[17] + gameObject.ints[26];
                }
                gameObject.ints[17] = Engine.cap(gameObject.ints[17], Math.abs(gameObject.ints[21]));
                continue;
            }
            gameObject.ints[17] = 0;
        }
    }

    public void tickActivePlatform() {
        if (this.activePlatform != null) {
            if (this.activePlatform.ints[16] != 3) {
                GameObject gameObject;
                if ((this.pressDirection & 2) != 0) {
                    if (this.activePlatform.ints[16] == 2) {
                        gameObject = this.activePlatform.objects[1];
                        while (gameObject != null) {
                            if (gameObject.ints[17] <= 0) {
                                gameObject.ints[17] = gameObject.ints[22];
                            }
                            gameObject.ints[18] = gameObject.ints[18] + gameObject.ints[24];
                            gameObject = gameObject.objects[2];
                        }
                    } else {
                        if (this.activePlatform.ints[17] <= 0) {
                            this.activePlatform.ints[17] = this.activePlatform.ints[22];
                        }
                        this.activePlatform.ints[18] = this.activePlatform.ints[18] + this.activePlatform.ints[24];
                        if (this.activePlatform.ints[29] == 2 || this.activePlatform.ints[27] == 8) {
                            this.activePlatform.ints[29] = 0;
                            this.activePlatform.ints[26] = 0;
                        }
                    }
                } else if ((this.pressDirection & 4) != 0) {
                    if (this.activePlatform.ints[16] == 2) {
                        gameObject = this.activePlatform.objects[1];
                        while (gameObject != null) {
                            if (gameObject.ints[17] >= 0) {
                                gameObject.ints[17] = -gameObject.ints[22];
                            }
                            gameObject.ints[18] = gameObject.ints[18] + -gameObject.ints[24];
                            gameObject = gameObject.objects[2];
                        }
                    } else {
                        if (this.activePlatform.ints[17] >= 0) {
                            this.activePlatform.ints[17] = -this.activePlatform.ints[22];
                        }
                        this.activePlatform.ints[18] = this.activePlatform.ints[18] + -this.activePlatform.ints[24];
                        if (this.activePlatform.ints[29] == 2 || this.activePlatform.ints[27] == 4) {
                            this.activePlatform.ints[29] = 0;
                            this.activePlatform.ints[26] = 0;
                        }
                    }
                } else if (this.activePlatform.ints[29] == 1) {
                    this.activePlatform.ints[29] = 2;
                }
            }
            if (this.activePlatform.ints[16] == 0 || this.activePlatform.ints[16] == 1) {
                if (this.pressDirection == 2) {
                    if (this.activePlatform.ints[19] < 23040 && this.activePlatform.ints[19] >= 8960) {
                        if (this.activePlatform.booleans[4]) {
                            this.activePlatform.ints[29] = 1;
                            this.activePlatform.ints[26] = this.activePlatform.ints[26] + 64;
                            this.activePlatform.ints[27] = 4;
                        }
                        this.activePlatform.ints[19] = 8960;
                        this.activePlatform.ints[21] = -8960;
                        this.activePlatform.ints[17] = 0;
                        this.activePlatform.ints[18] = 0;
                    }
                } else if (this.pressDirection == 4) {
                    int n = 83200;
                    if (this.activePlatform.ints[19] > 69120 && this.activePlatform.ints[19] <= n) {
                        if (this.activePlatform.booleans[4]) {
                            this.activePlatform.ints[29] = 1;
                            this.activePlatform.ints[26] = this.activePlatform.ints[26] + 64;
                            this.activePlatform.ints[27] = 8;
                        }
                        this.activePlatform.ints[19] = n;
                        this.activePlatform.ints[21] = 8960;
                        this.activePlatform.ints[17] = 0;
                        this.activePlatform.ints[18] = 0;
                    }
                }
            }
        }
    }

    public void calculateSpeed() {
        if (!this.isState(0)) {
            this.speed = 0;
        } else {
            int n;
            int n2 = this.player.pos.isSameAsNoPrecision(this.player.oldPos) ? 0 : this.player.vel.getLength() / 5;
            for (n = 0; n < this.speedValues.length - 2; ++n) {
                this.speedValues[n] = this.speedValues[n + 1];
            }
            this.speedValues[4] = n2;
            n = 0;
            for (int i = 0; i < 5; ++i) {
                n += this.speedValues[i];
            }
            this.speed = n / 5;
            if (this.speed == 0 && this.player.spriteNAnimTelapsPerTick > 0) {
                this.speed = 1;
            }
            this.distanceTravelled += n2;
        }
    }

    public void moveAndRotatePlatforms(int n) {
        for (int i = 0; i < this.platformsAndGoals.length; ++i) {
            GameObject gameObject = this.platformsAndGoals[i];
            boolean bl = false;
            if (gameObject.type == 2) {
                if (gameObject.ints[16] == 1) {
                    bl = this.movePlatform(gameObject, n);
                }
                if (gameObject.ints[17] != 0 || gameObject.ints[18] != 0) {
                    if (gameObject.ints[16] == 2 && gameObject.booleans[5]) {
                        gameObject.ints[17] = gameObject.objects[1].ints[17];
                        gameObject.ints[19] = gameObject.objects[1].ints[19];
                        gameObject.ints[21] = gameObject.objects[1].ints[21];
                    } else {
                        gameObject.ints[17] = gameObject.ints[17] + Engine.mulAcc(gameObject.ints[18], n);
                        gameObject.ints[17] = gameObject.ints[29] == 2 ? Engine.cap(gameObject.ints[17], 4 * gameObject.ints[23]) : Engine.cap(gameObject.ints[17], gameObject.ints[23]);
                        int n2 = Engine.mulAcc(gameObject.ints[17], n);
                        gameObject.ints[19] = gameObject.ints[19] + n2;
                        while (gameObject.ints[19] < 0) {
                            gameObject.ints[19] = gameObject.ints[19] + 92160;
                        }
                        gameObject.ints[19] = gameObject.ints[19] % 92160;
                        gameObject.ints[21] = gameObject.ints[21] - n2;
                    }
                    gameObject.ints[18] = 0;
                    if ((gameObject.ints[16] == 0 || gameObject.ints[16] == 1) && gameObject.ints[19] == 0) {
                        gameObject.ints[29] = 0;
                        gameObject.ints[26] = 0;
                    }
                }
                if (gameObject.ints[20] != gameObject.ints[19]) {
                    gameObject.updatePoints(false);
                    bl = true;
                }
                gameObject.ints[20] = gameObject.ints[19];
            } else if (gameObject.type == 7 && this.isState(0) && gameObject.objects[0] != null && (bl = this.movePlatform(gameObject, n))) {
                gameObject.updatePoints(false);
            }
            if (!bl) continue;
            gameObject.updateControlEdges();
        }
    }

    public void updatePlatformDrawPoints() {
        for (int i = 0; i < this.platformsAndGoals.length; ++i) {
            GameObject gameObject = this.platformsAndGoals[i];
            if (gameObject.type != 2 || !gameObject.booleans[3]) continue;
            gameObject.updateDrawPoints();
            gameObject.booleans[3] = false;
        }
    }

    public boolean movePlatform(GameObject gameObject, int n) {
        int n2;
        int n3;
        GameObject gameObject2;
        if (gameObject.type == 7) {
            gameObject2 = gameObject.objects[0];
            n3 = gameObject.ints[16];
            n2 = gameObject.ints[17];
        } else {
            gameObject2 = gameObject.objects[0];
            n3 = gameObject.ints[31];
            n2 = gameObject.ints[28];
        }
        int n4 = gameObject2.ints2[0][n3 << 1];
        int n5 = gameObject2.ints2[0][(n3 << 1) + 1];
        boolean bl = true;
        if (gameObject.vel.x > 0 && gameObject.pos.x < n4) {
            bl = false;
        } else if (gameObject.vel.x < 0 && gameObject.pos.x > n4) {
            bl = false;
        } else if (gameObject.vel.y > 0 && gameObject.pos.y < n5) {
            bl = false;
        } else if (gameObject.vel.y < 0 && gameObject.pos.y > n5) {
            bl = false;
        }
        if (bl) {
            gameObject.setPosition(n4, n5);
            n3 += n2;
            if (n2 > 0) {
                if (n3 > gameObject2.ints2[0].length / 2 - 1) {
                    if (gameObject2.booleans[0]) {
                        n3 = 0;
                    } else {
                        n3 = gameObject2.ints2[0].length / 2 - 2;
                        n2 = -1;
                    }
                }
            } else if (n3 < 0) {
                if (gameObject2.booleans[0]) {
                    n3 = gameObject2.ints2[0].length / 2 - 1;
                } else {
                    n3 = 0;
                    n2 = 1;
                }
            }
            if (gameObject.type == 7) {
                gameObject.ints[16] = n3;
                gameObject.ints[17] = n2;
            } else {
                gameObject.ints[31] = n3;
                gameObject.ints[28] = n2;
            }
        } else {
            this.moveObject(gameObject, n);
            return true;
        }
        this.calcAndSetMovingPlatformSpeed(gameObject);
        return false;
    }

    public void calcAndSetMovingPlatformSpeed(GameObject gameObject) {
        int n;
        GameObject gameObject2;
        if (gameObject.type == 7) {
            gameObject2 = gameObject.objects[0];
            n = gameObject.ints[16];
        } else {
            gameObject2 = gameObject.objects[0];
            n = gameObject.ints[31];
        }
        int n2 = gameObject2.ints2[0][n << 1];
        int n3 = gameObject2.ints2[0][(n << 1) + 1];
        int n4 = 0;
        int n5 = 0;
        if (n2 > gameObject.pos.x) {
            n4 = gameObject2.ints[16];
        } else if (n2 < gameObject.pos.x) {
            n4 = -gameObject2.ints[16];
        }
        if (n3 > gameObject.pos.y) {
            n5 = gameObject2.ints[16];
        } else if (n3 < gameObject.pos.y) {
            n5 = -gameObject2.ints[16];
        }
        if (n4 != 0 && n5 != 0) {
            boolean bl = n4 < 0;
            boolean bl2 = n5 < 0;
            int n6 = Engine.sqrt(Math.abs(n4));
            n4 = bl ? -n6 : n6;
            n5 = bl2 ? -n6 : n6;
        }
        gameObject.vel.setVector(n4, n5);
    }

    public void deactivateAllPlatforms() {
        GameObject gameObject = this.firstObject;
        while (gameObject != null) {
            if (gameObject.type == 2 && gameObject.booleans[0]) {
                gameObject.ints[29] = 0;
                gameObject.booleans[0] = false;
                gameObject.ints[32] = 0;
            }
            gameObject = gameObject.nextObject;
        }
    }

    public void findActivePlatform() {
        GameObject gameObject = this.activePlatform;
        GameObject gameObject2 = null;
        int n = 0;
        for (int i = 0; i < this.platformsAndGoals.length; ++i) {
            GameObject gameObject3 = this.platformsAndGoals[i];
            if (gameObject3.type != 2 || gameObject3.ints[16] == 3 || this.player.pos.y - this.player.collisionHeight >= gameObject3.ints[2] || this.player.pos.x + this.player.collisionWidth < gameObject3.ints[0] || this.player.pos.x - this.player.collisionWidth > gameObject3.ints[1]) continue;
            int n2 = 0;
            n2 = this.player.pos.x < gameObject3.pos.x ? (n2 += this.player.pos.x + (this.player.collisionWidth >> 1) - gameObject3.ints[0]) : (n2 += gameObject3.ints[1] - (this.player.pos.x - (this.player.collisionWidth >> 1)));
            n2 = this.player.pos.y < gameObject3.pos.y ? (n2 += this.player.pos.y + (this.player.collisionHeight >> 1) - gameObject3.ints[3]) : (n2 += gameObject3.ints[2] - (this.player.pos.y - (this.player.collisionHeight >> 1)));
            if (n2 <= n) continue;
            gameObject2 = gameObject3;
            n = n2;
        }
        if (gameObject2 != null) {
            if (gameObject != null && gameObject2 != gameObject) {
                if (gameObject.ints[16] == 2) {
                    GameObject gameObject4 = gameObject.objects[1];
                    while (gameObject4 != null) {
                        gameObject4.booleans[0] = false;
                        gameObject4.ints[32] = 0;
                        gameObject4 = gameObject4.objects[2];
                    }
                } else {
                    gameObject.booleans[0] = false;
                    gameObject.ints[26] = 0;
                    gameObject.ints[29] = 0;
                    gameObject.ints[32] = 0;
                }
            }
            if (gameObject2.ints[16] == 2) {
                GameObject gameObject5 = gameObject2.objects[1];
                while (gameObject5 != null) {
                    gameObject5.booleans[0] = true;
                    gameObject5.ints[32] = 1;
                    gameObject5 = gameObject5.objects[2];
                }
            } else {
                gameObject2.booleans[0] = true;
            }
            if (gameObject != gameObject2) {
                gameObject2.ints[32] = 1;
            }
            this.activePlatform = gameObject2;
        }
    }

    public void scrollView(boolean bl) {
        if (!bl && settingGameOver) {
            return;
        }
        if (this.cameraMode == 2) {
            this.viewVel.x = Engine.isPressed(4) ? -this.viewMaxSpeed : (Engine.isPressed(8) ? this.viewMaxSpeed : 0);
            this.viewVel.y = Engine.isPressed(1) ? -this.viewMaxSpeed : (Engine.isPressed(2) ? this.viewMaxSpeed : 0);
        } else if (this.focusedObject != null) {
            this.curViewOffsetX = 0;
            this.curViewOffsetY = 0;
            if (this.focusedObject.type == 1 && !this.isState(7) && !this.isState(3) || this.isState(3) && !this.isState(3, 1)) {
                this.curViewOffsetY = this.viewOffsetY;
            }
            if (this.isState(0)) {
                this.curViewOffsetX -= Engine.p2i(this.player.vel.x) << 2;
            }
            if (bl) {
                this.viewPos.x = this.focusedObject.pos.x - Engine.i2p(this.curViewOffsetX);
                this.viewPos.y = this.focusedObject.pos.y - Engine.i2p(this.curViewOffsetY);
                this.viewVel.setVector(0, 0);
                this.viewAcc.setVector(0, 0);
            } else if (this.cameraMode == 0) {
                int n = this.focusedObject.pos.x - (this.viewPos.x + Engine.i2p(this.curViewOffsetX));
                int n2 = this.focusedObject.pos.y - (this.viewPos.y + Engine.i2p(this.curViewOffsetY));
                if (this.isState(7) && !this.isState(7, 1)) {
                    this.viewVel.x = Engine.cap(n >> 1, this.viewMaxSpeed);
                    this.viewVel.y = Engine.cap(n2 >> 1, this.viewMaxSpeed);
                } else {
                    this.viewVel.x = Math.max(Math.min(512, n), Engine.cap(n >> 2, this.viewMaxSpeed));
                    this.viewVel.y = Math.max(Math.min(512, n2), Engine.cap(n2 >> 2, this.viewMaxSpeed));
                }
            } else {
                int n;
                if (Engine.fadeState != 0) {
                    return;
                }
                int n3 = this.viewVel.x;
                int n4 = this.viewVel.y;
                int n5 = 0;
                int n6 = 0;
                int n7 = this.focusedObject.pos.x - this.viewPos.x;
                int n8 = this.focusedObject.pos.y - this.viewPos.y;
                int n9 = Engine.mul(Engine.div(n7, Math.abs(n7) + Math.abs(n8)), 2048);
                int n10 = Engine.mul(Engine.div(n8, Math.abs(n7) + Math.abs(n8)), 2048);
                boolean bl2 = this.cameraPathStep > (this.cameraPath.length >> 1) - 2;
                int n11 = n = bl2 ? 5120 : 12800;
                if (Math.abs(n7) < n) {
                    n5 = -(n3 >> 5);
                } else if (n3 != n9) {
                    n5 = (n9 - n3) / 8;
                }
                if (Math.abs(n8) < n) {
                    n6 = -(n4 >> 5);
                } else if (n4 != n10) {
                    n6 = (n10 - n4) / 8;
                }
                this.viewAcc.setVector(n5, n6);
            }
        }
        this.viewVel = this.viewVel.plus(this.viewAcc);
        this.viewAcc.setVector(0, 0);
        if (Math.abs(this.viewVel.x) > this.viewMaxSpeed) {
            this.viewVel.x = Engine.cap(this.viewVel.x, this.viewMaxSpeed);
        }
        if (Math.abs(this.viewVel.y) > this.viewMaxSpeed) {
            this.viewVel.y = Engine.cap(this.viewVel.y, this.viewMaxSpeed);
        }
        this.viewPos = this.viewPos.plus(this.viewVel);
        this.canScrollUp = true;
        this.canScrollDown = true;
        this.canScrollLeft = true;
        this.canScrollRight = true;
        if (this.viewPos.x - Engine.i2p(this.viewWidth >> 1) <= -51200) {
            this.viewPos.x = Engine.i2p(this.viewWidth >> 1) - 51200;
            this.canScrollLeft = false;
        } else if (this.viewPos.x + Engine.i2p(this.viewWidth >> 1) >= this.mapWidthPrecise + 51200) {
            this.viewPos.x = this.mapWidthPrecise + 51200 - Engine.i2p(this.viewWidth >> 1);
            this.canScrollRight = false;
        }
        if (this.viewPos.y - Engine.i2p(this.viewHeight >> 1) <= -51200) {
            this.viewPos.y = Engine.i2p(this.viewHeight >> 1) - 51200;
            this.canScrollUp = false;
        } else if (this.viewPos.y + Engine.i2p(this.viewHeight >> 1) >= this.mapHeightPrecise + 51200) {
            this.viewPos.y = this.mapHeightPrecise + 51200 - Engine.i2p(this.viewHeight >> 1);
            this.canScrollDown = false;
        }
        this.mapViewX = Engine.p2i(Engine.scale(this.viewPos.x)) - (this.viewWidth >> 1);
        this.mapViewY = Engine.p2i(Engine.scale(this.viewPos.y)) - (this.viewHeight >> 1);
    }

    public void addObject(GameObject gameObject) {
        if (gameObject == null) {
            return;
        }
        if (gameObject.type == 9) {
            int n = -1;
            int n2 = -1;
            boolean bl = false;
            for (int i = 0; i < 20; ++i) {
                GameObject gameObject2 = this.particles[i];
                if (gameObject2 == null) {
                    gameObject.array = this.particles;
                    gameObject.arrayIndex = i;
                    this.particles[i] = gameObject;
                    bl = true;
                    break;
                }
                if (gameObject2.birthTime <= n) continue;
                n = gameObject2.birthTime;
                n2 = i;
            }
            if (!bl) {
                this.particles[n2].removeObject();
                gameObject.array = this.particles;
                gameObject.arrayIndex = n2;
                this.particles[n2] = gameObject;
            }
        }
        if (gameObject.nextObject != null || gameObject.prevObject != null) {
            return;
        }
        this.objectsToAdd.addElement(gameObject);
    }

    public void addObject(GameObject[] gameObjectArray) {
        for (int i = 0; i < gameObjectArray.length; ++i) {
            this.addObject(gameObjectArray[i]);
        }
    }

    public void addObjects() {
        Enumeration enumeration = this.objectsToAdd.elements();
        while (enumeration.hasMoreElements()) {
            GameObject gameObject = (GameObject)enumeration.nextElement();
            if (this.firstObject == null) {
                this.firstObject = gameObject;
                this.lastObject = gameObject;
            } else {
                this.lastObject.nextObject = gameObject;
                gameObject.prevObject = this.lastObject;
                this.lastObject = gameObject;
            }
            gameObject.setX(gameObject.pos.x);
            gameObject.setY(gameObject.pos.y);
        }
        this.objectsToAdd.removeAllElements();
    }

    public void removeObject(GameObject gameObject) {
        this.objectsToRemove.addElement(gameObject);
    }

    public int countObjects(int n) {
        int n2 = 0;
        GameObject gameObject = this.firstObject;
        while (gameObject != null) {
            if (gameObject.type == n) {
                ++n2;
            }
            gameObject = gameObject.nextObject;
        }
        return n2;
    }

    public void removeObjects() {
        Enumeration enumeration = this.objectsToRemove.elements();
        while (enumeration.hasMoreElements()) {
            GameObject gameObject = (GameObject)enumeration.nextElement();
            if (gameObject.prevObject != null) {
                gameObject.prevObject.nextObject = gameObject.nextObject;
            }
            if (gameObject.nextObject != null) {
                gameObject.nextObject.prevObject = gameObject.prevObject;
            }
            if (gameObject == this.firstObject) {
                this.firstObject = gameObject.nextObject;
            }
            if (gameObject == this.lastObject) {
                this.lastObject = gameObject.prevObject;
            }
            gameObject.prevObject = null;
            gameObject.nextObject = null;
        }
        this.objectsToRemove.removeAllElements();
    }

    public void paint(Graphics graphics) {
        if (--this.paintCountdown > 0) {
            Engine.skipNextPaint = true;
        } else {
            this.paintCountdown = 2;
        }
        switch (this.state) {
            default: 
        }
        this.drawWorld(graphics);
        if (!Engine.fading() && this.gotoMenu) {
            Engine.paintTooltips(graphics, 4);
        }
    }

    public void drawWorld(Graphics graphics) {
        this.gotoMenu = true;
        int n = -this.mapViewX;
        int n2 = -this.mapViewY;
        this.drawBackground(graphics);
        if (!settingGameOver) {
            this.drawObjects(this.particles, 1, graphics, n, n2);
            this.drawObjects(this.pathsChainsAndWalls, 0, graphics, n, n2);
            this.drawObjects(this.platformsAndGoals, 0, graphics, n, n2);
            this.drawObjects(this.hazards, 0, graphics, n, n2);
            this.drawObjects(this.pickups, 0, graphics, n, n2);
            this.player.paint(graphics, n, n2);
            this.drawObjects(this.particles, 2, graphics, n, n2);
        }
        if (Engine.state == 100) {
            int n3;
            int n4;
            if (this.isState(3)) {
                if (this.isState(3, 1)) {
                    n4 = Engine.scale(Engine.p2i(this.playerStartPreciseX)) + n;
                    n3 = Engine.scale(Engine.p2i(this.playerStartPreciseY)) - (this.player.spriteHeight >> 1) + this.startOffsetY + n2;
                    hudArrowImages[2].drawImage(graphics, n4, n3, 33);
                    Engine.FontManager_drawString(0, graphics, Engine.getText(93), n4, n3 - GameWorld.hudArrowImages[0].height + 3, 65);
                } else if (this.isState(3, 2)) {
                    Engine.FontManager_drawString(1, graphics, Engine.getText(94), this.textX, this.textY, Engine.multiplayerPlayMode ? 65 : 3);
                    if (Engine.multiplayerPlayMode) {
                        Engine.FontManager_drawString(0, graphics, Engine.playerNames[Engine.currentPlayer], this.textX, this.textY, 17);
                    }
                } else if (this.isState(3, 3)) {
                    String string = Engine.getText(95);
                    Engine.FontManager_drawString(1, graphics, string.substring(0, string.length() >> 1), (this.viewWidth >> 1) - this.textX, this.viewHeight >> 1, 10);
                    Engine.FontManager_drawString(1, graphics, string.substring(string.length() >> 1, string.length()), (this.viewWidth >> 1) + this.textX, this.viewHeight >> 1, 6);
                }
                if (this.isAtLeastState(3, 2)) {
                    Engine.paintTooltips(graphics, 2);
                    this.gotoMenu = false;
                }
            }
            if (this.extraLife) {
                Engine.FontManager_drawString(1, graphics, "1UP", this.viewWidth >> 1, this.textY, 3);
            }
            if (this.hurryUp) {
                Engine.FontManager_drawString(1, graphics, Engine.getText(91), this.textX, this.viewHeight >> 1, 3);
            }
            if (this.isState(5)) {
                Engine.FontManager_drawString(1, graphics, Engine.getText(90), this.viewWidth >> 1, this.textY, 3);
            } else if (this.isState(6)) {
                Engine.FontManager_drawString(1, graphics, Engine.getText(92), this.viewWidth >> 1, this.viewHeight >> 1, 3);
            }
            if (this.isState(8)) {
                this.drawEndOfLevelStrings(graphics);
            }
            if (this.isState(1) || this.isState(2)) {
                n4 = this.levelNameStrings.length * Engine.FontManager_lineHeight[1];
                n3 = this.viewHeight - n4 >> 1;
                for (int i = 0; i < this.levelNameStrings.length; ++i) {
                    Engine.FontManager_drawString(1, graphics, this.levelNameStrings[i], this.viewWidth >> 1, n3, 17);
                    n3 += Engine.FontManager_lineHeight[1];
                }
            }
            if (this.isState(7)) {
                if (this.isState(7, 1)) {
                    Engine.FontManager_drawString(1, graphics, this.isBonus ? Engine.getText(97) : Engine.getText(96), this.viewWidth >> 1, this.textY, 65);
                    if (this.goalScore > 0) {
                        Engine.FontManager_drawString(1, graphics, "" + this.goalScore, this.viewWidth >> 1, this.textY + 1, 17);
                    }
                } else if (this.isAtLeastState(7, 5)) {
                    this.drawEndOfLevelStrings(graphics);
                }
                if (!Engine.fading()) {
                    if (this.isState(7, 2) || this.isState(7, 3)) {
                        Engine.paintTooltips(graphics, 2);
                        this.gotoMenu = false;
                    } else if (this.isState(7, 5) || this.isState(7, 6) || this.isState(7, 7)) {
                        Engine.paintTooltips(graphics, 2);
                        this.gotoMenu = false;
                    }
                }
            }
            if (!Engine.fading()) {
                if (this.isState(1) || this.isState(2, 1) || this.isState(1)) {
                    Engine.paintTooltips(graphics, 2);
                    this.gotoMenu = false;
                } else if (this.isState(8) || this.isState(5) || this.isState(6)) {
                    Engine.paintTooltips(graphics, 2);
                    this.gotoMenu = false;
                }
            }
        }
        Engine.minClipY = 0;
        this.drawHud(graphics);
    }

    public void drawObjects(GameObject[] gameObjectArray, int n, Graphics graphics, int n2, int n3) {
        for (int i = 0; i < gameObjectArray.length; ++i) {
            GameObject gameObject = gameObjectArray[i];
            if (gameObject == null || !gameObject.onScreen || n != 0 && (n != 1 || gameObject.type != 9 || gameObject.booleans[1]) && (n != 2 || gameObject.type != 9 || !gameObject.booleans[1])) continue;
            gameObject.paint(graphics, n2, n3);
        }
    }

    public void setEndOfLevelStrings(int n, int n2) {
        this.strings = new Vector();
        this.fonts = new Vector();
        this.spacings = new Vector();
        this.height = 0;
        if (n == 7 && n2 == 5) {
            this.addEndOfLevelRows(Engine.getText(100), 1, 2);
            this.addEndOfLevelRow(null, -1, 8);
            if (playMode == 3) {
                this.addEndOfLevelRows(Engine.getText(106), 0, 3);
                this.addEndOfLevelRows(Engine.toTimeString(this.levelScore, true), 1, 3);
            } else {
                this.addEndOfLevelRows(Engine.getText(107) + " " + this.timeScore / 100 + "." + Engine.fillZeros("" + this.timeScore % 100, 2) + " " + "", 0, 3);
                this.addEndOfLevelRows(Engine.getText(109) + " " + this.timeScore, 0, 3);
                if (this.timeScoreMultiplier > 1) {
                    String string = Device.USE_BITMAP_FONTS ? "*" : "x";
                    this.addEndOfLevelRows("2 " + string + " " + Engine.getText(109) + " " + this.timeScoreMultiplier * this.timeScore, 0, 3);
                }
                if (this.isBonus) {
                    this.addEndOfLevelRows(Engine.getText(105) + " " + this.goalScore, 0, 3);
                }
                this.addEndOfLevelRow(null, -1, 9);
                this.addEndOfLevelRows(Engine.getText(104), 0, 3);
                this.addEndOfLevelRows("" + this.levelScore, 1, 3);
            }
            if (this.isLevelHighscore) {
                this.addEndOfLevelRow(null, -1, 4);
                this.addEndOfLevelRows(Engine.getText(55), 0, 0);
            }
        } else if (n == 7 && n2 == 6) {
            if (playMode != 3) {
                this.addEndOfLevelRow(Engine.getText(110) + " " + this.nBananasThisLevel + "/" + this.nBananasTotal, 0, 3);
            }
            this.addEndOfLevelRows(Engine.getText(111) + " " + this.nPlatformsVisited, 0, 3);
            this.addEndOfLevelRows(Engine.getText(112) + " " + Engine.getText(113, new String[]{"" + this.levelDistance}), 0, 3);
            this.addEndOfLevelRows(Engine.getText(114) + " " + Engine.getText(115, new String[]{"" + this.avgSpeed}), 0, 3);
            this.addEndOfLevelRows(Engine.getText(116) + " " + this.levelPercentInAir + "%", 0, 0);
        } else if (n == 7 && n2 == 7) {
            this.addEndOfLevelRows(Engine.getText(85), 0, 3);
        } else if (n == 8 && n2 == 1) {
            this.addEndOfLevelRows(Engine.getText(98), 1, 0);
        } else if (n == 8 && n2 == 3) {
            this.addEndOfLevelRows(Engine.getText(23 + this.difficulty + 1), 1, 0);
            this.addEndOfLevelRows(Engine.getText(99), 1, 0);
        } else if (n == 8 && n2 == 2) {
            if (this.lifeScore >= 0) {
                this.addEndOfLevelRows(Engine.getText(102), 0, 4);
                this.addEndOfLevelRows("" + this.lifeScore, 1, 10);
            }
            this.addEndOfLevelRows(Engine.getText(55), 1, 10);
            this.addEndOfLevelRows(Engine.getText(101), 0, 4);
            this.addEndOfLevelRows("" + (Engine.getHighScorePosition(Engine.difficultyToHighscoreIndex(this.difficulty), score[Engine.currentPlayer]) + 1), 1, 10);
            this.addEndOfLevelRows(Engine.getText(103), 0, 4);
            this.addEndOfLevelRows("" + score[Engine.currentPlayer], 1, 0);
        }
        this.endOfLevelStrings = new String[this.strings.size()];
        this.strings.copyInto(this.endOfLevelStrings);
        this.endOfLevelFonts = Engine.fromVectorToIntArray(this.fonts);
        this.endOfLevelSpacings = Engine.fromVectorToIntArray(this.spacings);
        int n3 = this.hudHeight;
        this.endOfLevelStartY = n3 + (176 - n3 - Engine.hudBottomPadding >> 1) - (this.height >> 1) + 0;
        this.strings = null;
        this.fonts = null;
        this.spacings = null;
    }

    public void addEndOfLevelRows(String string, int n, int n2) {
        this.addEndOfLevelRows(Engine.getStrings(string, 124, n), n, n2);
    }

    public void addEndOfLevelRows(String[] stringArray, int n, int n2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addEndOfLevelRow(stringArray[i], n, 1);
        }
        this.addEndOfLevelRow(null, -1, n2 - 1);
    }

    public void addEndOfLevelRow(String string, int n, int n2) {
        this.strings.addElement(string);
        this.fonts.addElement(new Integer(n));
        this.spacings.addElement(new Integer(n2));
        if (string != null) {
            this.height += Engine.FontManager_lineHeight[n];
        }
        this.height += n2;
    }

    public void drawEndOfLevelStrings(Graphics graphics) {
        int n = this.endOfLevelStartY;
        for (int i = 0; i < this.endOfLevelStrings.length; ++i) {
            if (this.endOfLevelStrings[i] != null) {
                Engine.FontManager_drawString(this.endOfLevelFonts[i], graphics, this.endOfLevelStrings[i], 66, n, 17);
                n += Engine.FontManager_lineHeight[this.endOfLevelFonts[i]];
            }
            n += this.endOfLevelSpacings[i];
        }
    }

    public void initBackgrounds() {
        int n;
        if (this.vBgData == null) {
            this.vBgData = new Vector[4][5];
        }
        for (n = 0; n < 4; ++n) {
            for (int i = 0; i < 5; ++i) {
                this.vBgData[n][i] = new Vector();
            }
        }
        this.addBackgroundLayer(0, 65543, 0, 85, -1, 1);
        this.addBackgroundLayer(1, 65556, 0, 85, -1, 1);
        this.addBackgroundLayer(2, 65548, 0, 85, -1, 1);
        this.addBackgroundLayer(0, 65545, 1, 105, -1, 2);
        this.addBackgroundLayer(0, 65546, 1, 125, -1, 3);
        this.addBackgroundLayer(0, 65547, 1, 145, -1, 4);
        this.addBackgroundLayer(0, 65544, 0, 256, -1, 0);
        this.addBackgroundLayer(1, 65557, 0, 170, -1, 0);
        this.addBackgroundLayer(2, 65549, 0, 170, -1, 0);
        this.addBackgroundLayer(3, 65536, 0, 85, 85, 7);
        this.addBackgroundLayer(3, 65537, 0, 170, 170, 7);
        this.addBackgroundLayer(3, 65538, 0, 256, 256, 7);
        for (n = 0; n < 4; ++n) {
            GameWorld.bgImageResources[n] = Engine.fromVectorToIntArray(this.vBgData[n][0]);
            GameWorld.bgLayerTypes[n] = Engine.fromVectorToIntArray(this.vBgData[n][1]);
            GameWorld.bgLayerSpeedsX[n] = Engine.fromVectorToIntArray(this.vBgData[n][2]);
            GameWorld.bgLayerSpeedsY[n] = Engine.fromVectorToIntArray(this.vBgData[n][3]);
            GameWorld.bgLayerScrollYTypes[n] = Engine.fromVectorToIntArray(this.vBgData[n][4]);
        }
        this.vBgData = null;
    }

    private void addBackgroundLayer(int n, int n2, int n3, int n4, int n5, int n6) {
        this.vBgData[n][0].addElement(new Integer(n2));
        this.vBgData[n][1].addElement(new Integer(n3));
        this.vBgData[n][2].addElement(new Integer(n4));
        this.vBgData[n][3].addElement(new Integer(n5));
        this.vBgData[n][4].addElement(new Integer(n6));
    }

    public void initBackground() {
        int n;
        int n2;
        int n3 = bgImageResources[this.levelType].length;
        this.bgImages = new DeviceImage[bgImageResources[this.levelType].length];
        for (n2 = 0; n2 < n3; ++n2) {
            if (bgImageResources[this.levelType][n2] == -1) continue;
            this.bgImages[n2] = new DeviceImage(bgImageResources[this.levelType][n2]);
        }
        this.bgLayerOffsetX = new int[this.bgImages.length];
        if (this.levelType == 3) {
            this.bgLayerY = null;
            bgLayerEdgeY = null;
        } else {
            this.bgLayerY = new int[this.bgImages.length];
            bgLayerEdgeY = new int[n3 << 1];
            for (n2 = 0; n2 < bgLayerEdgeY.length; n2 += 2) {
                n = n2 >> 1;
                if (bgLayerScrollYTypes[this.levelType][n] == 1) {
                    GameWorld.bgLayerEdgeY[n2 + 1] = 176 - this.bgImages[n].height;
                    continue;
                }
                if (bgLayerScrollYTypes[this.levelType][n] == 0) {
                    GameWorld.bgLayerEdgeY[n2] = 176 + Engine.scale(100);
                    GameWorld.bgLayerEdgeY[n2 + 1] = 176 - this.bgImages[n].height;
                    continue;
                }
                if (bgLayerScrollYTypes[this.levelType][n] == 2) {
                    GameWorld.bgLayerEdgeY[n2 + 1] = -(this.bgImages[0].height >> 1);
                    continue;
                }
                if (bgLayerScrollYTypes[this.levelType][n] == 3) {
                    GameWorld.bgLayerEdgeY[n2 + 1] = -(69 * this.bgImages[0].height / 100);
                    continue;
                }
                if (bgLayerScrollYTypes[this.levelType][n] != 4) continue;
                GameWorld.bgLayerEdgeY[n2 + 1] = -(88 * this.bgImages[0].height / 100);
            }
        }
        if (this.levelType == 0) {
            this.cloudGridMapping = new int[]{1, 2, 3};
            n2 = this.cloudGridMapping.length;
            this.cloudGridMappingReversed = new int[]{-1, 0, 1, 2, -1};
            this.cloudGridWidth = new int[n2];
            this.cloudGrid = new int[n2][];
            for (n = 0; n < n2; ++n) {
                int n4 = this.viewWidth << 1;
                int n5 = 2 * this.bgImages[0].height / 3;
                int n6 = Math.min(this.viewWidth, (4 + n) * this.bgImages[this.cloudGridMapping[n]].width);
                int n7 = Math.min(2 * this.viewHeight / 3, (4 + n) * this.bgImages[this.cloudGridMapping[n]].height);
                int n8 = n4 / n6;
                int n9 = n5 / n7;
                this.cloudGridWidth[n] = n4;
                this.cloudGrid[n] = new int[2 * n9 * n8];
                for (int i = 0; i < this.cloudGrid[n].length; i += 2) {
                    int n10 = (i >> 1) % n8;
                    int n11 = (i >> 1) / n8;
                    int n12 = n10 * n6 + (n6 >> 1);
                    int n13 = n11 * n7 + (n7 >> 1);
                    this.cloudGrid[n][i] = n12 + Engine.rnd(n6 / 3);
                    this.cloudGrid[n][i + 1] = n13 + Engine.rnd(n7 / 3);
                }
            }
        }
    }

    public void putBackgroundLayersInPlace() {
        if (this.levelType == 3) {
            return;
        }
        int n = 100 * Engine.p2i(this.viewPos.y) / Engine.p2i(this.mapHeightPrecise);
        for (int i = 0; i < this.bgLayerY.length; ++i) {
            int n2;
            int n3 = bgLayerEdgeY[(i << 1) + 1] - bgLayerEdgeY[i << 1];
            this.bgLayerY[i] = n2 = Engine.i2p(bgLayerEdgeY[i << 1] + n * n3 / 100);
        }
    }

    public void drawBackground(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < this.bgImages.length; ++n6) {
            int n7;
            n5 = -1;
            if (bgLayerScrollYTypes[this.levelType][n6] == 1) {
                n5 = 0;
            }
            n4 = -1;
            if (bgLayerScrollYTypes[this.levelType][n6] == 1) {
                n4 = this.viewHeight - this.bgImages[n6].height;
            } else if (bgLayerScrollYTypes[this.levelType][n6] == 0) {
                n4 = this.viewHeight - this.bgImages[n6].height;
            }
            n3 = bgLayerTypes[this.levelType][n6] == 1 ? this.cloudGridWidth[this.cloudGridMappingReversed[n6]] : this.bgImages[n6].width;
            n2 = n3 - Engine.mod(Engine.p2i(Engine.mul(Engine.i2p(this.mapViewX), bgLayerSpeedsX[this.levelType][n6]) + this.bgLayerOffsetX[n6]), n3) - n3;
            if (bgLayerScrollYTypes[this.levelType][n6] == 7) {
                n = this.bgImages[n6].height;
                for (int i = n7 = n - Engine.mod(Engine.p2i(Engine.mul(Engine.i2p(this.mapViewY), bgLayerSpeedsY[this.levelType][n6])), n) - n; i < this.viewHeight; i += n) {
                    for (int j = n2; j < this.viewWidth; j += n3) {
                        this.bgImages[n6].drawImage(graphics, j, i);
                    }
                }
                continue;
            }
            n = Engine.p2i(this.bgLayerY[n6]);
            if (n5 != -1) {
                n = Math.min(n5, n);
            }
            if (n4 != -1) {
                n = Math.max(n4, n);
            }
            if (bgLayerTypes[this.levelType][n6] == 1) {
                for (n7 = n2; n7 < this.viewWidth; n7 += n3) {
                    this.drawClouds(graphics, this.cloudGridMappingReversed[n6], n7, n);
                }
                continue;
            }
            for (n7 = n2; n7 < this.viewWidth; n7 += n3) {
                this.bgImages[n6].drawImage(graphics, n7, n);
            }
        }
        if (this.levelType != 3) {
            n6 = 100 * Engine.p2i(this.viewPos.y) / Engine.p2i(this.mapHeightPrecise);
            for (n5 = 0; n5 < this.bgLayerY.length; ++n5) {
                if (bgLayerTypes[this.levelType][n5] == 1 && !this.isState(4)) {
                    int n8 = n5;
                    this.bgLayerOffsetX[n8] = this.bgLayerOffsetX[n8] + n5 * 64;
                }
                n4 = this.bgLayerY[n5];
                n3 = bgLayerEdgeY[(n5 << 1) + 1] - bgLayerEdgeY[n5 << 1];
                n2 = Engine.i2p(bgLayerEdgeY[n5 << 1] + n6 * n3 / 100);
                n = n2 - n4 >> 1;
                if (Math.abs(n) < 4) {
                    n <<= 1;
                }
                this.bgLayerY[n5] = n4 += n;
            }
        }
    }

    public void drawClouds(Graphics graphics, int n, int n2, int n3) {
        for (int i = 0; i < this.cloudGrid[n].length; i += 2) {
            this.bgImages[this.cloudGridMapping[n]].drawImage(graphics, n2 + this.cloudGrid[n][i], n3 + this.cloudGrid[n][i + 1], 3);
        }
    }

    public void drawHud(Graphics graphics) {
        hudTimerImage.drawImage(graphics, this.hudTimerX, this.hudTimerY, 17);
        hudBarImages[0].drawImage(graphics, this.hudLivesBarX, this.hudLivesBarY);
        hudLivesIconImages[this.character[Engine.currentPlayer]].drawImage(graphics, this.hudLivesIconX, this.hudLivesIconY);
        hudBarImages[1].drawImage(graphics, this.hudScoreBarX, this.hudScoreBarY);
        hudBarImages[2].drawImage(graphics, this.hudBananasBarX, this.hudBananasBarY, 24);
        hudBarImages[3].drawImage(graphics, this.hudSpeedBarX, this.hudSpeedBarY, 24);
        if (playMode == 3) {
            Engine.FontManager_drawString(0, graphics, Engine.toTimeString(this.time, false), this.hudSecondsX, this.hudSecondsY + this.hudSecondsSmallOffsetY, 65);
        } else {
            String string = Engine.fillZeros("" + this.time / 1000, 2);
            Engine.FontManager_drawString(1, graphics, "" + string.charAt(0), this.hudSecondsX, this.hudSecondsY, 72);
            Engine.FontManager_drawString(1, graphics, "" + string.charAt(1), this.hudSecondsX, this.hudSecondsY, 68);
        }
        Engine.FontManager_drawString(0, graphics, Engine.fillZeros("" + this.time % 1000 / 10, 2), this.hudHundredsX, this.hudHundredsY + (playMode == 3 ? this.hudSecondsSmallOffsetY : 0), 17);
        if (playMode != 1 && playMode != 3) {
            Engine.FontManager_drawString(0, graphics, "" + Math.max(0, this.nLives[Engine.currentPlayer]), this.hudLivesX, this.hudLivesY, 10, false);
        }
        if (playMode != 3) {
            Engine.FontManager_drawString(0, graphics, "" + score[Engine.currentPlayer], this.hudScoreX, this.hudScoreY, 10);
        }
        if (playMode != 3) {
            Engine.FontManager_drawString(0, graphics, "" + this.nBananas[Engine.currentPlayer], this.hudBananasX, this.hudBananasY, 10, false);
        }
        Engine.FontManager_drawString(0, graphics, "" + this.speed, this.hudSpeedX, this.hudSpeedY, 10);
        if (Engine.multiplayerPlayMode) {
            Engine.FontManager_drawString(0, graphics, Engine.currentPlayer + 1 + "P", this.hudPlayerNumberX, this.hudPlayerNumberY, 20);
        }
        if (!this.isBonus && (this.isState(3) || this.isState(0) || this.isState(4))) {
            short s = GameWorld.goalArrowImages[0].width;
            short s2 = GameWorld.goalArrowImages[0].height;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = (this.viewWidth >> 1) + Engine.p2i(Engine.scale(this.goal.pos.x - this.viewPos.x));
            int n2 = (this.viewHeight >> 1) + Engine.p2i(Engine.scale(this.goal.pos.y - this.viewPos.y));
            if (n < 0) {
                bl3 = true;
                n = 0;
            } else if (n > this.viewWidth - s) {
                bl4 = true;
                n = this.viewWidth - s;
            }
            if (n2 < this.hudHeight + 3) {
                bl = true;
                n2 = this.hudHeight + 3;
            } else if (n2 > this.viewHeight - Engine.hudBottomPadding - s2) {
                bl2 = true;
                n2 = this.viewHeight - Engine.hudBottomPadding - s2;
            }
            int n3 = bl ? (bl3 ? 7 : (bl4 ? 5 : 6)) : (bl2 ? (bl3 ? 1 : (bl4 ? 3 : 2)) : (bl3 ? 0 : (bl4 ? 4 : -1)));
            if (n3 >= 0) {
                if (this.goalArrowWhite) {
                    goalArrowWhiteImages[n3].drawImage(graphics, n, n2);
                } else {
                    goalArrowImages[n3].drawImage(graphics, n, n2);
                }
            }
        }
        if (this.isState(0) || this.isState(4, 1)) {
            if (this.cameraMode == 2) {
                if (this.canScrollUp) {
                    hudArrowImages[0].drawImage(graphics, this.viewWidth >> 1, this.hudHeight + Engine.scale(1) + this.manualArrowsOffset, 17);
                }
                if (this.canScrollRight) {
                    hudArrowImages[1].drawImage(graphics, this.viewWidth - 2 - this.manualArrowsOffset, this.hudHeight + (this.viewHeight - this.hudHeight >> 1), 10);
                }
                if (this.canScrollDown) {
                    hudArrowImages[2].drawImage(graphics, this.viewWidth >> 1, this.viewHeight - 2 - this.manualArrowsOffset, 33);
                }
                if (this.canScrollLeft) {
                    hudArrowImages[3].drawImage(graphics, 2 + this.manualArrowsOffset, this.hudHeight + (this.viewHeight - this.hudHeight >> 1), 6);
                }
                Engine.paintTooltips(graphics, 64);
            } else {
                Engine.paintTooltips(graphics, 32);
            }
        }
    }

    public void playMusic() {
        if (playMode != 3 && this.time < 10000) {
            Device.soundFunction(3, 7);
        } else {
            Device.soundFunction(3, Engine.getMapping(LEVEL_MUSIC_MAPPING, this.levelType));
        }
    }

    public void computeForces() {
        if (this.pressDirection == 0) {
            int n = -this.player.vel.x / 30;
            if (Math.abs(this.player.vel.x) > 5 && Math.abs(n) < 5) {
                if (this.player.vel.x > 0) {
                    n = -5;
                } else if (this.player.vel.x < 0) {
                    n = 5;
                }
            }
            this.player.acc.x += n;
        }
        if (settingPlayerGravity) {
            this.player.acc.y += 384;
        }
    }

    public void moveObjects() {
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.particles[i] == null) continue;
            this.moveObject(this.particles[i], 256);
        }
    }

    public void moveObject(GameObject gameObject, int n) {
        if (gameObject.vel.isPreciseZero() && gameObject.acc.isPreciseZero()) {
            return;
        }
        gameObject.oldPos.setVector(gameObject.pos);
        if (gameObject.type == 2 || gameObject.type == 7) {
            gameObject.vel.x += Engine.mul(gameObject.acc.x, n);
            gameObject.vel.y += Engine.mul(gameObject.acc.y, n);
        } else {
            gameObject.vel.x += Engine.mulAcc(gameObject.acc.x, n);
            gameObject.vel.y += Engine.mulAcc(gameObject.acc.y, n);
        }
        if (gameObject.type == 9) {
            if (Math.abs(gameObject.vel.x) > 3840) {
                gameObject.vel.x = Engine.cap(gameObject.vel.x, 3840);
            }
        } else if (gameObject.type != 2 && gameObject.type != 7 && gameObject.hasProperty(1) && !this.isState(7)) {
            if (Math.abs(gameObject.vel.x) > 3072) {
                gameObject.vel.x = Engine.cap(gameObject.vel.x, 3072);
            }
            if (Math.abs(gameObject.vel.y) > 3072) {
                gameObject.vel.y = Engine.cap(gameObject.vel.y, 3072);
            }
        }
        if (gameObject.hasProperty(16) && (gameObject.type != 1 || this.pressDirection == 0) && Math.abs(gameObject.vel.x) < 25) {
            gameObject.vel.x = 0;
        }
        gameObject.collided = false;
        if (gameObject.type == 2 || gameObject.type == 7) {
            gameObject.moveX(Engine.mul(gameObject.vel.x, n));
            gameObject.moveY(Engine.mul(gameObject.vel.y, n));
        } else {
            gameObject.moveX(Engine.mulAcc(gameObject.vel.x, n));
            gameObject.moveY(Engine.mulAcc(gameObject.vel.y, n));
        }
    }

    public void spawnParticles(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n5;
        for (int i = 0; i < n2; ++i) {
            GameObject gameObject = GameObject.createParticle(0, n, n3, n4);
            int n9 = Engine.mul(n7, Engine.cos(n8));
            int n10 = Engine.mul(n7, -Engine.sin(n8));
            n8 += n6;
            gameObject.vel.setVector(n9, n10);
            this.addObject(gameObject);
        }
    }

    public void checkCollision(GameObject gameObject, int n) {
        GameObject gameObject2 = this.firstObject;
        while (gameObject2 != null) {
            if (gameObject != gameObject2 && gameObject2.onScreen && gameObject2.hasProperty(1)) {
                int n2;
                int n3;
                int n4;
                int n5;
                if (gameObject.collisionType == 1 && gameObject2.collisionType == 1) {
                    n5 = gameObject2.collisionX - (gameObject.collisionWidth >> 1);
                    n4 = gameObject2.collisionY - (gameObject.collisionWidth >> 1);
                    n3 = gameObject2.collisionWidth + gameObject.collisionWidth;
                    if (Engine.isPointInRect(gameObject.pos.x, gameObject.pos.y, n5, n4, n3, n3)) {
                        this.checkCollisionCircle(gameObject, gameObject2);
                    }
                } else if (gameObject.collisionType == 1 && gameObject2.collisionType == 2 && Engine.isPointInRect(gameObject.pos.x, gameObject.pos.y, n5 = gameObject2.ints[0] - (gameObject.collisionWidth >> 1), n4 = gameObject2.ints[3] - (gameObject.collisionWidth >> 1), n3 = gameObject2.ints[1] - gameObject2.ints[0] + gameObject.collisionWidth, n2 = gameObject2.ints[2] - gameObject2.ints[3] + gameObject.collisionWidth)) {
                    this.checkCollisionLine(gameObject, gameObject2, n);
                }
            }
            gameObject2 = gameObject2.nextObject;
        }
    }

    public void checkCollisionCircle(GameObject gameObject, GameObject gameObject2) {
        int n;
        int n2 = gameObject.collisionWidth >> 1;
        int n3 = gameObject2.collisionWidth >> 1;
        MovementVector movementVector = new MovementVector(gameObject.pos.x - gameObject2.pos.x, gameObject.pos.y - gameObject2.pos.y);
        long l = Engine.vectorSquaredLengthLong(movementVector);
        if (l <= (long)(n = Engine.mulAcc(n2 + n3, n2 + n3))) {
            if (gameObject2.hasProperty(4)) {
                MovementVector movementVector2;
                MovementVector movementVector3;
                gameObject.collided = true;
                MovementVector movementVector4 = Engine.normalizeVector(movementVector);
                if (gameObject2.type == 6) {
                    movementVector3 = movementVector4.copy();
                    if (this.isState(0)) {
                        movementVector3.scaleThis(4096);
                    } else {
                        movementVector3.scaleThis(128);
                    }
                    gameObject.vel = movementVector3;
                } else {
                    int n4 = Engine.dotProduct(movementVector4, gameObject.vel);
                    MovementVector movementVector5 = Engine.scaleVector(movementVector4, n4);
                    movementVector2 = Engine.vectorDifference(gameObject.vel, movementVector5);
                    gameObject.vel = Engine.vectorDifference(movementVector2, Engine.scaleVector(movementVector5, gameObject2.kR));
                }
                movementVector3 = Engine.vectorSum(gameObject2.pos, Engine.scaleVector(movementVector4, n3));
                if (this.isState(0) && gameObject2.type == 6) {
                    this.spawnParticles(4, 3, movementVector3.x, movementVector3.y, 0, 120, 1280);
                    this.spawnParticles(11, 3, movementVector3.x, movementVector3.y, 60, 120, 1280);
                }
                int n5 = (int)Engine.sqrt(l);
                movementVector2 = Engine.vectorSum(gameObject.pos, Engine.scaleVector(movementVector4, n2 + n3 - n5));
                gameObject.pos.setVector(movementVector2);
                gameObject.setPosition(gameObject.pos.x, gameObject.pos.y);
            }
            gameObject.collided(gameObject2);
        }
    }

    public void checkCollisionLine(GameObject gameObject, GameObject gameObject2, int n) {
        int n2 = gameObject.pos.x;
        int n3 = gameObject.pos.y;
        int n4 = gameObject.collisionWidth >> 1;
        int[] nArray = gameObject2.ints2[0];
        int n5 = gameObject2.pos.x + nArray[0];
        int n6 = gameObject2.pos.y + nArray[1];
        for (int i = 2; i < nArray.length; i += 2) {
            int n7 = gameObject2.pos.x + nArray[i];
            int n8 = gameObject2.pos.y + nArray[i + 1];
            if (gameObject2.type == 2 && gameObject2.booleans[2] && i < nArray.length - 1 && n7 == gameObject2.pos.x && n8 == gameObject2.pos.y) {
                n7 = gameObject2.pos.x + nArray[i += 2];
                n8 = gameObject2.pos.y + nArray[i + 1];
            }
            if (Engine.intersectsLineCircle(n5, n6, n7, n8, n2, n3, n4)) {
                if (gameObject2.hasProperty(4)) {
                    this.resolveCircleLineCollision(gameObject, gameObject2, n);
                }
                gameObject.collided(gameObject2);
            }
            n5 = n7;
            n6 = n8;
        }
    }

    public void resolveCircleLineCollision(GameObject gameObject, GameObject gameObject2, int n) {
        int n2;
        int n3;
        MovementVector movementVector;
        int n4 = gameObject.pos.x;
        int n5 = gameObject.pos.y;
        int n6 = gameObject.collisionWidth >> 1;
        if (this.goalHit) {
            movementVector = new MovementVector(0, -256);
        } else {
            movementVector = new MovementVector(n4 - Engine.lastCollisionX, n5 - Engine.lastCollisionY);
            Engine.normalizeVector(movementVector);
        }
        int n7 = Engine.sqrt(Engine.lastDistance2);
        MovementVector movementVector2 = Engine.scaleVector(movementVector, n6 - n7 + 64);
        MovementVector movementVector3 = Engine.vectorSum(gameObject.pos, movementVector2);
        gameObject.pos.setVector(movementVector3);
        gameObject.setPosition(gameObject.pos.x, gameObject.pos.y);
        gameObject.collided = true;
        int n8 = Engine.dotProduct(movementVector, gameObject.vel);
        MovementVector movementVector4 = Engine.scaleVector(movementVector, n8);
        MovementVector movementVector5 = Engine.vectorDifference(gameObject.vel, movementVector4);
        MovementVector movementVector6 = null;
        if (gameObject2.type != 2 || gameObject2.ints[16] == 3 || Engine.p2i(gameObject2.ints[17]) == 0) {
            movementVector6 = new MovementVector(0, 0);
        } else {
            MovementVector movementVector7;
            n3 = Engine.getDistance(gameObject2.pos.x, gameObject2.pos.y, Engine.lastCollisionX, Engine.lastCollisionY);
            n2 = Engine.p2i(gameObject2.ints[17]);
            int n9 = (int)Engine.divAcc(n3, Engine.cos(n2));
            int n10 = Engine.mulAcc(n9, Engine.sin(n2));
            int n11 = Engine.lastCollisionX - gameObject2.pos.x;
            int n12 = Engine.lastCollisionY - gameObject2.pos.y;
            MovementVector movementVector8 = new MovementVector(-n12, n11);
            Engine.normalizeVector(movementVector8);
            movementVector8.scaleThis(-n10);
            int n13 = Engine.dotProduct(movementVector, movementVector8);
            movementVector6 = movementVector7 = Engine.scaleVector(movementVector, n13);
        }
        int n14 = 256;
        if (Engine.dotProduct(movementVector, movementVector4) < 0) {
            movementVector4 = Engine.scaleVector(movementVector4, -256);
            n14 = gameObject2.kR;
        }
        gameObject.vel = Engine.vectorSum(movementVector5, Engine.scaleVector(movementVector4, n14));
        if (gameObject2.type == 2 && gameObject2.ints[16] != 3) {
            movementVector6 = Engine.scaleVector(movementVector6, 85);
            gameObject.vel = Engine.vectorSum(gameObject.vel, movementVector6);
        }
        if (gameObject2.type == 2 && gameObject2.ints[16] == 1 && gameObject2.ints[19] == 0 && Math.abs(gameObject.vel.x) < Math.abs(gameObject2.vel.x)) {
            gameObject.vel.x += Engine.mulAcc(gameObject2.vel.x - gameObject.vel.x >> 2, n);
        }
        platformAngle = gameObject2.type == 2 ? Engine.p2i(gameObject2.ints[19]) : 0;
        n3 = Math.abs(n8 - movementVector4.getLength());
        if (n3 >= 5120) {
            n2 = movementVector.getAngle();
            this.spawnParticles(4, 1, Engine.lastCollisionX, Engine.lastCollisionY, Engine.absAngle(n2 + 65), 0, 1280);
            this.spawnParticles(4, 1, Engine.lastCollisionX, Engine.lastCollisionY, Engine.absAngle(n2 - 65), 0, 1280);
            Device.vibrate(100);
        }
    }

    public void addScore(int n) {
        int n2 = Engine.currentPlayer;
        score[n2] = score[n2] + n;
    }

    public void cacheHudBar(int n) {
        Graphics graphics;
        if (n == -1 || n == 0) {
            graphics = this.cachedHudImages[0].getGraphics();
            Engine.cls(graphics, 27030);
            Engine.FontManager_drawString(0, graphics, "" + this.nLives[Engine.currentPlayer], this.cachedHudImages[0].getWidth(), 0, 24);
        }
        if (n == -1 || n == 1) {
            graphics = this.cachedHudImages[1].getGraphics();
            Engine.cls(graphics, 27030);
            Engine.FontManager_drawString(0, graphics, "" + this.nBananas[Engine.currentPlayer], this.cachedHudImages[1].getWidth(), 0, 24);
        }
        if (n == -1 || n == 2) {
            graphics = this.cachedHudImages[2].getGraphics();
            Engine.cls(graphics, 27030);
            Engine.FontManager_drawString(0, graphics, "" + score[Engine.currentPlayer], this.cachedHudImages[2].getWidth(), 0, 24);
        }
        if (n == -1 || n == 3) {
            graphics = this.cachedHudImages[3].getGraphics();
            Engine.cls(graphics, 27030);
            Engine.FontManager_drawString(0, graphics, "" + this.speed, this.cachedHudImages[3].getWidth(), 0, 24);
        }
    }

    public void setLevelName() {
        this.cameraMode = 1;
        this.levelName = this.isBonus ? Engine.getText(89) : Engine.getLevelName(this.difficulty, Engine.getIndexInArray((int)LEVELS_INGAME[this.difficulty][this.levelIndex], LEVELS_MENU[this.difficulty]));
        this.levelNameStrings = Engine.getStrings(this.levelName, 112, 1);
        this.setState(1);
    }

    public void setCameraPan() {
        this.setState(2, 1);
    }

    public void setStart() {
        this.viewMaxSpeed = 2816;
        this.setState(3, 1);
        this.cameraMode = 0;
        this.scrollView(true);
        this.putBackgroundLayersInPlace();
        Engine.releaseKey(128);
    }

    public void togglePause() {
        if (this.isState(4)) {
            this.cameraMode = 0;
            this.viewMaxSpeed = 6400;
            this.forceResumeTicks = 0;
            this.setState(4, 2);
        } else {
            this.viewVel.setVector(0, 0);
            this.cameraMode = 2;
            this.viewMaxSpeed = 2560;
            this.manualArrowsOffset = 0;
            this.manualArrowIncr = 1;
            this.setState(4, 1);
        }
    }

    public void setTimeOver() {
        Engine.releaseAllKeys();
        this.deactivateAllPlatforms();
        this.setState(6);
        Device.soundFunction(1, 0);
    }

    public void setFallout() {
        Engine.releaseAllKeys();
        this.deactivateAllPlatforms();
        settingPlayerCollision = false;
        this.player.startAnimation(4);
        this.viewMaxSpeed = 1536;
        this.setState(5);
        this.textY = 0;
        this.textAccY = Engine.scale(3);
        this.textSpeedY = Engine.scale(8);
        Device.soundFunction(3, 6);
    }

    public void setGameOver(boolean bl) {
        this.difficultyCompleted = bl;
        Engine.releaseAllKeys();
        if (bl) {
            this.lifeScore = this.nLives[Engine.currentPlayer] * 100 * 100;
            this.addScore(this.lifeScore);
            this.checkTotalScore();
            this.setEndOfLevelStrings(8, 3);
            this.setState(8, 3);
        } else {
            this.lifeScore = -1;
            this.checkTotalScore();
            this.setEndOfLevelStrings(8, 1);
            this.setState(8, 1);
        }
        if (!bl) {
            this.hurryUp = false;
            this.extraLife = false;
            settingGameOver = true;
        }
    }

    public void setLevelComplete(int n) {
        this.hurryUp = false;
        this.extraLife = false;
        if (playMode != 1) {
            this.playerLevelTries[Engine.currentPlayer] = 0;
        }
        if (Engine.multiplayerPlayMode && playMode != 3 && playMode != 1) {
            int n2 = Engine.currentPlayer;
            this.playerLevelIndexes[n2] = this.playerLevelIndexes[n2] + 1;
        }
        this.goalScore = 0;
        this.timeScoreMultiplier = 1;
        if (this.isBonus) {
            this.goalScore = GOAL_BONUS_POINTS[2];
        } else if (playMode != 3) {
            if (n == 3 || n == 24 || n == 25) {
                this.goalScore = GOAL_BONUS_POINTS[2];
            } else if (n == 2 || n == 12 || n == 13 || n == 22 || n == 23) {
                this.goalScore = GOAL_BONUS_POINTS[1];
            } else if (n == 1 || n == 10 || n == 11 || n == 20 || n == 21) {
                this.goalScore = GOAL_BONUS_POINTS[0];
            }
        }
        if (playMode == 3) {
            this.levelScore = this.time;
        } else {
            if (this.time >= this.maxTime >> 1) {
                this.timeScoreMultiplier = 2;
            }
            this.timeScore = this.time / 10;
            this.levelScoreExceptBananas = this.goalScore + this.timeScoreMultiplier * this.timeScore;
            this.levelScore = this.levelScoreExceptBananas + this.nBananasThisLevel * 100;
        }
        this.checkLevelScore();
        this.levelDistance = this.distanceTravelled / 3600;
        this.avgSpeed = this.distanceTravelled / this.tick;
        this.levelPercentInAir = 100 * this.nTicksInAir / this.tick;
        this.checkLevelUnlocking();
        this.textY = (this.viewHeight >> 1) - Engine.scale(30);
        this.textAccY = 0;
        this.textSpeedY = -1;
        this.deactivateAllPlatforms();
        Engine.releaseAllKeys();
        Device.soundFunction(3, 5);
        this.setState(7, 1);
    }

    public void checkLevelUnlocking() {
        if (Engine.Demo_isEnabled()) {
            return;
        }
        if (this.isBonus) {
            return;
        }
        int n = this.getNextLevel(this.levelIndex);
        if (n != -1) {
            int n2;
            int n3 = 0;
            while ((n2 = Engine.getIndexInArray((int)LEVELS_INGAME[this.difficulty][this.levelIndex + ++n3], LEVELS_MENU[this.difficulty])) == -1) {
            }
            if (Engine.levelUnlocked[this.difficulty] < n2) {
                Engine.levelUnlocked[this.difficulty] = n2;
                this.isLevelUnlocked = true;
            }
        }
        if (this.isLevelUnlocked) {
            this.saveRms = true;
        }
    }

    public boolean isRectOnScreen(int n, int n2, int n3, int n4) {
        return n2 <= this.viewEdgeDown && n2 + n4 >= this.viewEdgeUp && n <= this.viewEdgeRight && n + n3 >= this.viewEdgeLeft;
    }

    public void checkLevelScore() {
        if (Engine.Demo_isEnabled()) {
            return;
        }
        if (this.isBonus) {
            return;
        }
        if (playMode == 3 && Engine.nPlayers > 1 && (this.timeAttackBestScores[Engine.currentPlayer] == 0 || this.levelScore < this.timeAttackBestScores[Engine.currentPlayer])) {
            this.timeAttackBestScores[Engine.currentPlayer] = this.levelScore;
        }
        int n = playMode == 3 ? 2 : 1;
        this.isLevelHighscore = Engine.isHigherThan(Engine.difficultyToHighscoreIndex(this.difficulty) + n, this.levelHighscoreIndex, this.levelScore);
    }

    public void saveLevelScore() {
        if (this.isLevelHighscore) {
            Engine.replaceHighScore(Engine.difficultyToHighscoreIndex(this.difficulty) + (playMode == 3 ? 2 : 1), this.levelHighscoreIndex, Engine.playerNames[Engine.currentPlayer], this.levelScore);
            Engine.saveRMS(0);
        }
    }

    public void checkTotalScore() {
        if (Engine.Demo_isEnabled()) {
            return;
        }
        if (playMode == 3) {
            return;
        }
        this.isTotalHighscore = Engine.isHighScore(Engine.difficultyToHighscoreIndex(this.difficulty), score[Engine.currentPlayer]);
    }

    public int getNextLevel(int n) {
        int n2 = n + 1;
        if (n2 > LEVELS_INGAME[this.difficulty].length - 1) {
            return -1;
        }
        return LEVELS_INGAME[this.difficulty][n2];
    }

    public void handleFadeEvent(int n, int n2) {
        if (this.saveRms) {
            this.saveRms = false;
            Engine.saveRMS(0);
        }
        if (n2 == 10) {
            if (Engine.Demo_isEnabled() && this.levelIndex == 1) {
                if (Engine.goingFromGameToMenu()) {
                    Engine.MenuManager_setMenu(0, true);
                }
            } else {
                if (this.isBonus && playMode != 1) {
                    this.playerLevelTries[Engine.currentPlayer] = 0;
                }
                this.saveLevelScore();
                if (Engine.multiplayerPlayMode) {
                    if (this.nextPlayer()) {
                        this.level = LEVELS_INGAME[this.difficulty][this.playerLevelIndexes[Engine.currentPlayer]];
                        this.loadLevel(this.level);
                    }
                } else {
                    this.loadLevel(this.getNextLevel(this.levelIndex));
                }
            }
        } else if (n2 == 11 || n2 == 12) {
            if (Engine.state == 10) {
                Engine.MenuManager_toGame();
            }
            if (n2 == 12) {
                int n3 = Engine.currentPlayer;
                this.nLives[n3] = this.nLives[n3] - 1;
            }
            if (playMode == 1) {
                this.saveLevelScore();
            }
            if (Engine.multiplayerPlayMode && this.nextPlayer()) {
                this.level = LEVELS_INGAME[this.difficulty][this.playerLevelIndexes[Engine.currentPlayer]];
            }
            this.loadLevel(this.level);
        } else if (n2 == 13) {
            if (playMode == 0) {
                Engine.save = null;
                Engine.saveRMS(0);
            }
            if (this.difficultyCompleted) {
                this.saveLevelScore();
            }
            highscoreIndex = Engine.difficultyToHighscoreIndex(this.difficulty);
            if (this.isTotalHighscore) {
                Engine.insertHighScore(highscoreIndex, score[Engine.currentPlayer], Engine.playerNames[Engine.currentPlayer]);
                if (playMode == 0 && Engine.goingFromGameToMenu()) {
                    Engine.setHighscorePage(highscoreIndex, -1, 0);
                }
            } else if (playMode == 0 && Engine.goingFromGameToMenu()) {
                Engine.MenuManager_setMenu(0, true);
            }
            if (Engine.multiplayerPlayMode) {
                if (this.nextPlayer()) {
                    this.level = LEVELS_INGAME[this.difficulty][this.playerLevelIndexes[Engine.currentPlayer]];
                    this.loadLevel(this.level);
                } else if (Engine.goingFromGameToMenu()) {
                    Engine.setHighscorePage(highscoreIndex, -1, 0);
                }
            }
        }
    }

    static {
        DIRECTIONS = new short[]{4, 8, 1, 2};
        platformAngle = 0;
        PLAYER_SPRITES = new byte[]{1, 6, 12, 13};
        PLAYER_BALL_SPRITES = new byte[]{0, 15, 14, 16};
        SPRITE_RESOURCES = new int[][]{{-1, -1, 65567, -1}, {-1, -1, 65565, -1}, {-1, 65572, -1}, {-1, 65571, -1}, {-1, 65583, -1}, {-1, 65575, -1}, {-1, 65582, -1, -1}, {-1, 65576, -1}, {-1, 65578, -1}, {-1, 65577, -1}, {-1, 65573}, {-1, 65584, -1}, {-1, 65581, -1, -1}, {-1, -1, 65566, -1}, {-1, -1, 65569, -1}, {-1, -1, 65570, -1}, {-1, -1, 65568, -1}, {-1, 65579}, {-1, 65580}, {-1, 65574}};
        VIEW_OFFSET_DIVIDERS = new int[]{4, 6, 8};
        HUD_BAR_WIDTH = Engine.scale(83);
        HUD_BAR_HEIGHT = Engine.scale(23);
        LEVEL_RESOURCES = new int[]{65585, 65586, 65587, 65588, 65589, 65590, 65591, 65592, 65593, 65594, 65595, 65596, 65597, 65598, 65599, 65600, 65601, 65602, 65603, 65604, 65605, 65606, 65607, 65608, 65609, 65610, 65611, 65612, 65613, 65614, 65615, 65616, 65617, 65618, 65619, 65620, 65621, 65622, 65623, 65624, 65625, 65626, 65627, 65628, 65629, 65630, 65631, 65632};
        LEVEL_OBJECTS = new byte[]{4, 5, 6, 9, 8, 11, 7};
        CHARACTER_SPRITE_MAPPING = new byte[]{0, 1, 1, 6, 2, 12, 3, 13};
        bgImageResources = new int[4][];
        bgLayerTypes = new int[4][];
        bgLayerSpeedsX = new int[4][];
        bgLayerSpeedsY = new int[4][];
        bgLayerScrollYTypes = new int[4][];
        LEVEL_MUSIC_MAPPING = new byte[]{0, 1, 1, 2, 2, 3, 3, 4};
        GOAL_BONUS_POINTS = new short[]{1000, 3000, 5000};
    }
}

