/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameObject
implements GameConstants,
Constants {
    public int type;
    public MovementVector pos;
    public MovementVector oldPos;
    public MovementVector vel;
    public MovementVector acc;
    public boolean collided;
    public int collisionType;
    public int collisionX;
    public int collisionY;
    public int collisionOffsetX;
    public int collisionOffsetY;
    public int collisionWidth;
    public int collisionHeight;
    public int kR = 256;
    public GameObject prevObject;
    public GameObject nextObject;
    public static GameWorld gameWorld;
    public int properties;
    public boolean animate = true;
    public boolean removeAfterAnimationWrapped;
    protected int tick;
    public int birthTime;
    public int removeTime = -1;
    public boolean onScreen;
    public boolean keepAcceleration;
    public int arrayIndex;
    public GameObject[] array;
    public int arrayIndexOnScreenIndex = -1;
    public GameObject[] arrayIndexOnScreenArray;
    public static byte[] N_TYPE_INTS;
    public static byte[] N_TYPE_INTS2;
    public static byte[] N_TYPE_BOOLEANS;
    public static byte[] N_TYPE_OBJECTS;
    public static byte[] N_TYPE_IMAGES;
    public int[] ints;
    public int[][] ints2;
    public boolean[] booleans;
    public GameObject[] objects;
    public Image[] images;
    public GameObject[] pointTwins;
    public static final byte[] PLATFORMS_START_VEL;
    public static final byte[] PLATFORMS_MAX_VEL;
    public static final int[] PLATFORMS_ACC;
    public static byte[] LEFT_END_MAPPING;
    public static byte[] RIGHT_END_MAPPING;
    public static final byte[] FAT_LINE_OFFSETS;
    public int spriteX;
    public int spriteY;
    public int spriteWidth;
    public int spriteHeight;
    public int spritePaintOffsetX;
    public int spritePaintOffsetY;
    public int spriteNAnimTelapsPerTick = 1;
    public int spriteHandle = -1;
    public int spriteAnimationSequence = -1;
    public int spriteAnimationHandle = -1;
    public static final int ANIMATION_HANDLE_0;

    public GameObject() {
        this.birthTime = GameObject.gameWorld.gameTime;
    }

    public GameObject(int n) {
        this();
        this.type = n;
        this.initArrays();
    }

    public GameObject(int n, int n2, int n3) {
        this(n);
        this.pos = new MovementVector();
        this.vel = new MovementVector();
        this.acc = new MovementVector();
        this.setPosition(n2, n3);
        this.oldPos = new MovementVector();
    }

    public void setX(int n) {
        this.pos.x = n;
        this.spriteX = Engine.p2i(Engine.scale(this.pos.x));
        this.collisionX = this.pos.x - (this.collisionWidth >> 1);
    }

    public void setY(int n) {
        this.pos.y = n;
        this.spriteY = Engine.p2i(Engine.scale(this.pos.y));
        this.collisionY = this.pos.y - (this.collisionHeight >> 1);
    }

    public void setPosition(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public void moveX(int n) {
        this.setX(this.pos.x + n);
    }

    public void moveY(int n) {
        this.setY(this.pos.y + n);
    }

    public void initArrays() {
        if (N_TYPE_INTS[this.type] > 0) {
            this.ints = new int[N_TYPE_INTS[this.type]];
        }
        if (N_TYPE_INTS2[this.type] > 0) {
            this.ints2 = new int[N_TYPE_INTS2[this.type]][];
        }
        if (N_TYPE_BOOLEANS[this.type] > 0) {
            this.booleans = new boolean[N_TYPE_BOOLEANS[this.type]];
        }
        if (N_TYPE_OBJECTS[this.type] > 0) {
            this.objects = new GameObject[N_TYPE_OBJECTS[this.type]];
        }
        if (N_TYPE_IMAGES[this.type] > 0) {
            this.images = new Image[N_TYPE_IMAGES[this.type]];
        }
    }

    public static GameObject createPlayer(int n, int n2, int n3) {
        GameObject gameObject = new GameObject(1, n2 << 8, n3 << 8);
        gameObject.ints[7] = n;
        gameObject.setSprite(GameWorld.PLAYER_SPRITES[n]);
        gameObject.setProperty(8);
        gameObject.setProperty(16);
        gameObject.setProperty(1);
        gameObject.collisionType = 1;
        gameObject.collisionWidth = gameObject.collisionHeight = Engine.i2p(34);
        GameObject gameObject2 = GameObject.createSprite(GameObject.gameWorld.playerBallSprites[Engine.currentPlayer]);
        gameObject2.spriteNAnimTelapsPerTick = 0;
        gameObject.objects[0] = gameObject2;
        gameObject2.onScreen = true;
        return gameObject;
    }

    public static GameObject createPlatform(int n, int n2, int n3, DataInputStream dataInputStream) {
        try {
            int n4;
            GameObject gameObject = new GameObject(2, Engine.i2p(n2), Engine.i2p(n3));
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            int[] nArray = new int[by << 1];
            int[] nArray2 = new int[by2 << 1];
            for (n4 = 0; n4 < nArray.length; n4 += 2) {
                nArray[n4] = dataInputStream.readShort();
                nArray[n4 + 1] = Engine.i2p(dataInputStream.readShort());
            }
            gameObject.ints2[1] = nArray;
            for (n4 = 0; n4 < nArray2.length; n4 += 2) {
                nArray2[n4] = dataInputStream.readShort();
                nArray2[n4 + 1] = Engine.i2p(dataInputStream.readShort());
            }
            gameObject.ints2[2] = nArray2;
            gameObject.booleans[2] = nArray[0] == Engine.absAngle(nArray2[0] + 180);
            gameObject.ints[16] = n;
            gameObject.setProperty(1);
            gameObject.setProperty(4);
            gameObject.collisionType = 2;
            gameObject.animate = false;
            gameObject.updatePoints(true);
            gameObject.calculateNTiles();
            gameObject.updateDrawPoints();
            n4 = Engine.p2i(Math.max(gameObject.ints[1] - gameObject.ints[0], gameObject.ints[2] - gameObject.ints[3]));
            int n5 = n4 <= 70 ? 0 : (n4 < 100 ? 1 : (n4 < 140 ? 2 : 3));
            int n6 = Engine.i2p(PLATFORMS_START_VEL[n5]);
            int n7 = Engine.i2p(PLATFORMS_MAX_VEL[n5]);
            int n8 = Engine.i2p(PLATFORMS_ACC[n5]);
            if (n4 < 170) {
                gameObject.booleans[4] = true;
            }
            gameObject.kR = 90;
            gameObject.ints[22] = n6;
            gameObject.ints[23] = n7;
            gameObject.ints[24] = n8;
            if (n == 1) {
                gameObject.ints[28] = 1;
            }
            return gameObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static GameObject createPath(int[] nArray, int[] nArray2, int n) {
        GameObject gameObject = new GameObject(8, 0, 0);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Engine.i2p(nArray[i]);
        }
        gameObject.ints2[0] = nArray;
        gameObject.ints2[1] = nArray2;
        gameObject.ints[16] = n;
        gameObject.animate = false;
        gameObject.updatePoints(true);
        return gameObject;
    }

    public static GameObject createChain(int[] nArray) {
        GameObject gameObject = new GameObject(11, 0, 0);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Engine.i2p(nArray[i]);
        }
        gameObject.ints2[0] = nArray;
        int[] nArray2 = new int[nArray.length << 1];
        int n = 0;
        int n2 = nArray[0];
        int n3 = nArray[1];
        for (int i = 2; i < nArray.length; i += 2) {
            int n4 = nArray[i];
            int n5 = nArray[i + 1];
            int n6 = Engine.getAngle(n2, n3, n4, n5);
            int n7 = Engine.absAngle(n6 + 90);
            int n8 = Engine.mul(Engine.i2p(3), Engine.cos(n7));
            int n9 = Engine.mul(Engine.i2p(3), -Engine.sin(n7));
            int n10 = Engine.absAngle(n6 - 90);
            int n11 = Engine.mul(Engine.i2p(3), Engine.cos(n10));
            int n12 = Engine.mul(Engine.i2p(3), -Engine.sin(n10));
            nArray2[n++] = n8;
            nArray2[n++] = n9;
            nArray2[n++] = n11;
            nArray2[n++] = n12;
            n2 = n4;
            n3 = n5;
        }
        gameObject.ints2[1] = nArray2;
        gameObject.animate = false;
        gameObject.updatePoints(true);
        return gameObject;
    }

    public static GameObject createWall(int[] nArray) {
        GameObject gameObject = new GameObject(10, 0, 0);
        gameObject.ints2[0] = nArray;
        gameObject.setProperty(1);
        gameObject.setProperty(4);
        gameObject.collisionType = 2;
        gameObject.animate = false;
        gameObject.kR = 128;
        gameObject.updatePoints(true);
        return gameObject;
    }

    public static GameObject createFalloutLine(int[] nArray) {
        GameObject gameObject = new GameObject(12, 0, 0);
        gameObject.ints2[0] = nArray;
        gameObject.setProperty(1);
        gameObject.collisionType = 2;
        gameObject.animate = false;
        gameObject.updatePoints(true);
        return gameObject;
    }

    public static GameObject createParticle(int n, int n2, int n3, int n4) {
        GameObject gameObject = new GameObject(9, n3, n4);
        if (n2 >= 0) {
            gameObject.setSprite(n2);
        } else {
            gameObject.animate = false;
        }
        gameObject.removeAfterAnimationWrapped = true;
        gameObject.ints[0] = n;
        gameObject.onScreen = true;
        return gameObject;
    }

    public void updatePoints(boolean bl) {
        boolean bl2 = false;
        if (this.pointTwins != null) {
            for (int i = 0; i < this.pointTwins.length; ++i) {
                if (!this.pointTwins[i].booleans[6]) continue;
                this.ints2[0] = this.pointTwins[i].ints2[0];
                bl2 = true;
                break;
            }
        }
        if (!bl2 && this.type == 2) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = Engine.p2i(this.ints[19]);
            int[] nArray = this.ints2[1];
            int[] nArray2 = this.ints2[2];
            int[] nArray3 = new int[nArray.length + 2 + nArray2.length];
            int n7 = nArray.length - 1;
            int n8 = this.pos.x;
            int n9 = this.pos.y;
            for (n5 = 0; n5 < nArray.length; n5 += 2) {
                n4 = Engine.absAngle(nArray[n5] + n6);
                n3 = nArray[n5 + 1];
                n2 = n8 + Engine.mulAcc(n3, Engine.cos(n4));
                n = n9 + Engine.mulAcc(n3, -Engine.sin(n4));
                nArray3[n7--] = n - this.pos.y;
                nArray3[n7--] = n2 - this.pos.x;
                n8 = n2;
                n9 = n;
            }
            n7 = nArray.length + 2;
            n8 = this.pos.x;
            n9 = this.pos.y;
            for (n5 = 0; n5 < nArray2.length; n5 += 2) {
                n4 = Engine.absAngle(nArray2[n5] + n6);
                n3 = nArray2[n5 + 1];
                n2 = n8 + Engine.mulAcc(n3, Engine.cos(n4));
                n = n9 + Engine.mulAcc(n3, -Engine.sin(n4));
                nArray3[n7++] = n2 - this.pos.x;
                nArray3[n7++] = n - this.pos.y;
                n8 = n2;
                n9 = n;
            }
            this.ints2[0] = nArray3;
        }
        if (bl) {
            this.updateControlEdges();
        }
        if (this.type == 2) {
            this.booleans[3] = true;
        }
        if (this.pointTwins != null) {
            this.booleans[6] = true;
        }
    }

    public void updateDrawPoints() {
        boolean bl = false;
        if (this.pointTwins != null) {
            for (int i = 0; i < this.pointTwins.length; ++i) {
                if (!this.pointTwins[i].booleans[7]) continue;
                this.ints2[3] = this.pointTwins[i].ints2[3];
                bl = true;
                break;
            }
        }
        if (!bl) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int[] nArray = this.ints2[0];
            int[] nArray2 = new int[400];
            int n8 = 0;
            boolean bl2 = false;
            if (nArray.length == 4) {
                bl2 = true;
                nArray = new int[]{nArray[0], nArray[1], 0, 0, nArray[2], nArray[3], 0, 0};
            }
            int n9 = 0;
            int n10 = nArray[0];
            int n11 = nArray[1];
            for (n7 = 2; n7 < nArray.length; n7 += 2) {
                n6 = nArray[n7];
                n5 = nArray[n7 + 1];
                if (!bl2 || n7 != 4) {
                    n4 = n6 - n10;
                    n3 = n5 - n11;
                    if ((n2 = this.ints2[4][n9++]) > 0) {
                        n = n4 / n2;
                        int n12 = n3 / n2;
                        int n13 = n10;
                        int n14 = n11;
                        for (int i = 0; i < n2; ++i) {
                            n13 += n;
                            n14 += n12;
                            if (i == n2 - 1 && n6 == 0 && n5 == 0) continue;
                            nArray2[n8++] = Engine.scale(n13);
                            nArray2[n8++] = Engine.scale(n14);
                        }
                    }
                }
                if (n10 != 0 || n11 != 0) {
                    nArray2[n8++] = Engine.scale(n10);
                    nArray2[n8++] = Engine.scale(n11);
                }
                n10 = n6;
                n11 = n5;
            }
            n7 = n8 += 2;
            for (n6 = 0; n6 < n7 - 2; n6 += 2) {
                for (n5 = 0; n5 < n7 - 2 - n6; n5 += 2) {
                    n4 = nArray2[n5 + 3];
                    n3 = nArray2[n5 + 1];
                    if (n4 <= n3) continue;
                    n2 = nArray2[n5];
                    n = nArray2[n5 + 1];
                    nArray2[n5] = nArray2[n5 + 2];
                    nArray2[n5 + 1] = nArray2[n5 + 3];
                    nArray2[n5 + 2] = n2;
                    nArray2[n5 + 3] = n;
                }
            }
            int[] nArray3 = new int[n8];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray3.length);
            this.ints2[3] = nArray3;
        }
        if (this.pointTwins != null) {
            this.booleans[7] = true;
        }
    }

    public void calculateNTiles() {
        int[] nArray = this.ints2[0];
        boolean bl = false;
        if (nArray.length == 4) {
            bl = true;
            nArray = new int[]{nArray[0], nArray[1], 0, 0, nArray[2], nArray[3], 0, 0};
        }
        int[] nArray2 = new int[(nArray.length >> 1) - 1];
        int n = 0;
        int n2 = nArray[0];
        int n3 = nArray[1];
        for (int i = 2; i < nArray.length; i += 2) {
            int n4 = nArray[i];
            int n5 = nArray[i + 1];
            if (!bl || i != 4) {
                int n6 = Engine.getDistance(n2, n3, n4, n5);
                nArray2[n++] = Engine.p2i(n6 / 7);
            }
            n2 = n4;
            n3 = n5;
        }
        this.ints2[4] = nArray2;
    }

    public int snap(int n) {
        return 0;
    }

    public void updateControlEdges() {
        int n;
        int[] nArray = this.ints2[0];
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (n = 0; n < nArray.length; n += 2) {
            int n6 = this.pos.x + nArray[n];
            int n7 = this.pos.y + nArray[n + 1];
            if (n3 == -1 || n6 < n3) {
                n3 = n6;
            }
            if (n2 == -1 || n6 > n2) {
                n2 = n6;
            }
            if (n5 == -1 || n7 < n5) {
                n5 = n7;
            }
            if (n4 != -1 && n7 <= n4) continue;
            n4 = n7;
        }
        this.ints[0] = n3;
        this.ints[1] = n2;
        this.ints[2] = n4;
        this.ints[3] = n5;
        n = GameWorld.platformPivotImages[0].height >> 1;
        this.ints[4] = (Engine.scale(n3) >> 8) - n;
        this.ints[5] = (Engine.scale(n2 - n3) >> 8) + (n << 1);
        this.ints[6] = (Engine.scale(n5) >> 8) - n;
        this.ints[7] = (Engine.scale(n4 - n5) >> 8) + (n << 1);
    }

    public static GameObject createPickup(int n, int n2, int n3) {
        GameObject gameObject = new GameObject(3, n2 << 8, n3 << 8);
        gameObject.ints[0] = n;
        switch (n) {
            case 0: {
                gameObject.setSprite(2);
                break;
            }
            case 1: {
                gameObject.setSprite(3);
            }
        }
        gameObject.setProperty(1);
        gameObject.setProperty(2);
        gameObject.collisionType = 1;
        return gameObject;
    }

    public static GameObject createBumper(int n, int n2) {
        GameObject gameObject = new GameObject(6, n << 8, n2 << 8);
        gameObject.setSprite(5);
        gameObject.setProperty(1);
        gameObject.setProperty(4);
        gameObject.collisionType = 1;
        gameObject.ints[4] = -300;
        return gameObject;
    }

    public static GameObject createGoal(int n, int n2, DataInputStream dataInputStream) throws Exception {
        int n3;
        int n4;
        int n5;
        GameObject gameObject = new GameObject(7, n << 8, n2 << 8);
        gameObject.setProperty(1);
        gameObject.setProperty(4);
        gameObject.collisionType = 1;
        gameObject.animate = false;
        gameObject.kR = 64;
        int n6 = dataInputStream.readByte();
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            n5 = dataInputStream.readByte();
            nArray[i] = Engine.getMapping(GameWorld.GOAL_TYPE_MAPPING, n5);
        }
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(GameObject.tileBetween(-1, nArray[0])));
        vector.addElement(new Integer(nArray[0]));
        for (n5 = 0; n5 < nArray.length - 1; ++n5) {
            n4 = GameObject.tileBetween(nArray[n5], nArray[n5 + 1]);
            if (n4 != -1) {
                vector.addElement(new Integer(n4));
            }
            vector.addElement(new Integer(nArray[n5 + 1]));
        }
        vector.addElement(new Integer(GameObject.tileBetween(nArray[nArray.length - 1], -1)));
        n5 = vector.size();
        gameObject.ints2[1] = new int[n5];
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            gameObject.ints2[1][n3] = (Integer)vector.elementAt(n3);
            n4 += GameWorld.getGoalTileImage((int)gameObject.ints2[1][n3]).width;
        }
        gameObject.spriteWidth = n4;
        gameObject.collisionWidth = Engine.unScale(Engine.i2p(gameObject.spriteWidth));
        gameObject.collisionOffsetX = -(gameObject.collisionWidth >> 1);
        gameObject.collisionType = 2;
        n3 = GameWorld.goalTileEndImages[0].width;
        Image image = Image.createImage((int)(gameObject.spriteWidth - (n3 << 1)), (int)GameWorld.goalTileImages[0].height);
        Graphics graphics = image.getGraphics();
        int n7 = 0;
        for (int i = 1; i < n5 - 1; ++i) {
            DeviceImage deviceImage = GameWorld.getGoalTileImage(gameObject.ints2[1][i]);
            deviceImage.drawImage(graphics, n7, 0);
            n7 += deviceImage.width;
        }
        gameObject.images[0] = image;
        int[] nArray2 = new int[4];
        nArray2[0] = -(gameObject.collisionWidth >> 1);
        nArray2[2] = gameObject.collisionWidth >> 1;
        gameObject.ints2[0] = nArray2;
        gameObject.updateControlEdges();
        if (n5 > GameObject.gameWorld.goalLargestNTiles) {
            GameObject.gameWorld.goalLargestNTiles = n5;
            GameObject.gameWorld.goal = gameObject;
        }
        return gameObject;
    }

    public static int tileBetween(int n, int n2) {
        if (n == n2) {
            return -1;
        }
        if (n == -1) {
            return Engine.getMapping(LEFT_END_MAPPING, n2);
        }
        if (n2 == -1) {
            return Engine.getMapping(RIGHT_END_MAPPING, n);
        }
        if (n == 0) {
            if (n2 == 1) {
                return 14;
            }
            if (n2 == 2) {
                return 16;
            }
            if (n2 == 3) {
                return 18;
            }
        } else if (n == 1) {
            if (n2 == 2) {
                return 10;
            }
            if (n2 == 0) {
                return 15;
            }
        } else {
            if (n == 2) {
                if (n2 == 0) {
                    return 17;
                }
                if (n2 == 1) {
                    return 11;
                }
                return 12;
            }
            if (n == 3) {
                if (n2 == 0) {
                    return 19;
                }
                return 13;
            }
        }
        return -1;
    }

    public static GameObject[] createFan(int n, int n2, int n3) {
        GameObject gameObject = new GameObject(4, Engine.i2p(n), Engine.i2p(n2));
        gameObject.setSprite(7);
        gameObject.ints[11] = n3;
        if (n3 == 8) {
            gameObject.startAnimation(0);
            gameObject.ints[8] = Engine.AnimatedBitmap_startAnimation(0);
            gameObject.ints[9] = GameWorld.SPRITE_PAINT_OFFSETS[16] - Engine.AnimatedBitmap_getWidth(8);
        } else {
            gameObject.startAnimation(1);
            gameObject.ints[8] = Engine.AnimatedBitmap_startAnimation(1);
            gameObject.ints[9] = gameObject.spriteWidth - GameWorld.SPRITE_PAINT_OFFSETS[16];
        }
        gameObject.ints[10] = -GameWorld.SPRITE_PAINT_OFFSETS[17];
        gameObject.setProperty(1);
        gameObject.setProperty(4);
        gameObject.collisionType = 1;
        gameObject.ints[5] = gameObject.spriteWidth + (Engine.AnimatedBitmap_getWidth(8) << 1);
        gameObject.ints[7] = gameObject.spriteHeight;
        gameObject.ints[4] = gameObject.spriteX - (gameObject.ints[5] >> 1);
        gameObject.ints[6] = gameObject.spriteY - (gameObject.ints[7] >> 1);
        GameObject gameObject2 = new GameObject(5, Engine.i2p(n), Engine.i2p(n2));
        gameObject2.setProperty(1);
        gameObject2.collisionType = 1;
        gameObject2.collisionWidth = 15360;
        gameObject2.collisionHeight = 15360;
        if (n3 == 4) {
            gameObject2.moveX(-gameObject2.collisionWidth >> 1);
            gameObject2.ints[0] = -256;
        } else if (n3 == 8) {
            gameObject2.moveX(gameObject2.collisionWidth >> 1);
            gameObject2.ints[0] = 256;
        }
        gameObject2.animate = false;
        return new GameObject[]{gameObject, gameObject2};
    }

    public void setProperty(int n) {
        this.properties |= n;
    }

    public void removeProperty(int n) {
        this.properties &= ~n;
    }

    public boolean hasProperty(int n) {
        return (this.properties & n) != 0;
    }

    public void setSprite(int n) {
        this.spriteHandle = n;
        this.spriteWidth = Engine.AnimatedBitmap_getWidth(this.spriteHandle);
        this.spriteHeight = Engine.AnimatedBitmap_getHeight(this.spriteHandle);
        this.setPaintOffsets();
        this.startAnimation(0);
        this.collisionWidth = Engine.unScale(Engine.i2p(this.spriteWidth));
        this.collisionHeight = Engine.unScale(Engine.i2p(this.spriteHeight));
    }

    public void setPaintOffsets() {
        this.spritePaintOffsetX = -GameWorld.SPRITE_PAINT_OFFSETS[this.spriteHandle << 1];
        this.spritePaintOffsetY = -GameWorld.SPRITE_PAINT_OFFSETS[(this.spriteHandle << 1) + 1];
    }

    public void collided(GameObject gameObject) {
        switch (this.type) {
            case 1: {
                this.ints[0] = GameObject.gameWorld.gameTime;
                if (gameObject.hasProperty(4)) {
                    this.booleans[1] = true;
                    if (gameObject.type == 2 && gameObject.ints[16] == 1) {
                        this.ints[5] = this.vel.x - gameObject.vel.x;
                        GameObject.gameWorld.resetReference = false;
                    }
                    this.ints[6] = 2;
                }
                if (!gameWorld.isState(6) && gameObject.isPickable()) {
                    if (gameObject.ints[0] == 0) {
                        int n = Engine.currentPlayer;
                        GameObject.gameWorld.nBananas[n] = GameObject.gameWorld.nBananas[n] + 1;
                        ++GameObject.gameWorld.nBananasThisLevel;
                        gameWorld.addScore(100);
                    } else if (gameObject.ints[0] == 1) {
                        int n = Engine.currentPlayer;
                        GameObject.gameWorld.nBananas[n] = GameObject.gameWorld.nBananas[n] + 10;
                        GameObject.gameWorld.nBananasThisLevel += 10;
                        gameWorld.addScore(1000);
                    }
                    gameObject.booleans[0] = true;
                    gameObject.removeObject();
                    gameWorld.spawnParticles(4, 3, gameObject.pos.x, gameObject.pos.y, 90, 120, 1280);
                    if (GameObject.gameWorld.nBananas[Engine.currentPlayer] >= 100) {
                        int n = Engine.currentPlayer;
                        GameObject.gameWorld.nBananas[n] = GameObject.gameWorld.nBananas[n] - 100;
                        int n2 = Engine.currentPlayer;
                        GameObject.gameWorld.nLives[n2] = GameObject.gameWorld.nLives[n2] + 1;
                        GameObject.gameWorld.extraLife = true;
                        GameObject.gameWorld.textY = (GameObject.gameWorld.viewHeight >> 1) + Engine.scale(10);
                        GameObject.gameWorld.textSpeedY = -Engine.scale(9);
                        GameObject.gameWorld.textAccY = 1;
                    }
                    if (!GameObject.gameWorld.isBonus || GameObject.gameWorld.nBananasThisLevel != GameObject.gameWorld.nBananasTotal) break;
                    this.stop();
                    GameWorld.settingPlayerGravity = false;
                    gameWorld.setLevelComplete(0);
                    break;
                }
                if (gameObject.type == 2) {
                    if (gameObject.ints[16] == 3) {
                        gameObject.ints[17] = this.spriteX < gameObject.spriteX ? 640 : -640;
                    }
                    if (gameObject.booleans[1]) break;
                    gameObject.booleans[1] = true;
                    ++GameObject.gameWorld.nPlatformsVisited;
                    break;
                }
                if (gameObject.type == 6) {
                    if (!gameWorld.isState(0)) break;
                    gameObject.startAnimation(1);
                    gameObject.ints[4] = GameObject.gameWorld.gameTime;
                    int n = this.spriteX < gameObject.spriteX + gameObject.spritePaintOffsetX ? 1 : (this.spriteX > gameObject.spriteX - gameObject.spritePaintOffsetX ? -1 : 0);
                    int n3 = this.spriteY < gameObject.spriteY + gameObject.spritePaintOffsetY ? 1 : (this.spriteY > gameObject.spriteY - gameObject.spritePaintOffsetY ? -1 : 0);
                    gameObject.ints[2] = n;
                    gameObject.ints[3] = n3;
                    Device.vibrate(150);
                    break;
                }
                if (gameObject.type == 7) {
                    if (GameObject.gameWorld.state != 0 || this.vel.y > 0) break;
                    GameObject.gameWorld.goalHit = true;
                    this.vel.x = 0;
                    this.vel.y = -2048;
                    int n = -1;
                    int n4 = this.spriteX - (gameObject.spriteX - (gameObject.spriteWidth >> 1));
                    int n5 = 0;
                    for (int i = 0; i < gameObject.ints2[1].length; ++i) {
                        if (n4 >= (n5 += GameWorld.getGoalTileImage((int)gameObject.ints2[1][i]).width)) continue;
                        n = gameObject.ints2[1][i];
                        break;
                    }
                    gameWorld.setLevelComplete(n);
                    break;
                }
                if (gameObject.type == 5) {
                    this.acc.x += gameObject.ints[0];
                    break;
                }
                if (gameObject.type != 12) break;
                gameWorld.setFallout();
            }
        }
    }

    public boolean isPickable() {
        return this.hasProperty(2) && !this.booleans[0];
    }

    public void tick() {
        if (this.spriteHandle >= 0 && this.animate) {
            this.tickSprite();
            if (this.removeAfterAnimationWrapped && Engine.AnimatedBitmap_getAnimationPlaybackMode(this.spriteHandle, this.spriteAnimationSequence) == 2 && Engine.AnimatedBitmap_hasAnimationWrapped(this.spriteAnimationHandle)) {
                this.removeObject();
            }
        }
        if (this.removeTime > 0 && GameObject.gameWorld.gameTime >= this.removeTime) {
            this.removeObject();
        }
        switch (this.type) {
            case 1: {
                boolean bl;
                if (this.ints[6] > 0) {
                    this.ints[6] = this.ints[6] - 1;
                } else {
                    ++GameObject.gameWorld.nTicksInAir;
                }
                if (gameWorld.isState(3) && this.tick > this.ints[3]) {
                    if (this.spriteNAnimTelapsPerTick > 1) {
                        --this.spriteNAnimTelapsPerTick;
                    }
                    this.ints[2] = this.ints[2] - 1;
                    this.ints[3] = this.tick + this.ints[2];
                }
                if (this.vel.y > 1536) {
                    if (this.spriteAnimationSequence == 0) {
                        this.startAnimation(2);
                    } else if (this.spriteAnimationSequence == 1) {
                        this.startAnimation(3);
                    }
                } else if (this.spriteAnimationSequence == 2) {
                    this.startAnimation(0);
                } else if (this.spriteAnimationSequence == 3) {
                    this.startAnimation(1);
                }
                boolean bl2 = GameObject.gameWorld.gameTime >= this.ints[1] + 500;
                boolean bl3 = this.booleans[0] && GameObject.gameWorld.pressDirection == 2;
                boolean bl4 = bl = this.booleans[0] && GameObject.gameWorld.pressDirection == 4;
                if (!bl3 && !bl) {
                    bl3 = this.ints[5] < -64;
                    boolean bl5 = bl = this.ints[5] > 64;
                }
                if (bl2 && bl3) {
                    if (this.spriteAnimationSequence == 0) {
                        this.startAnimation(1);
                        this.ints[1] = GameObject.gameWorld.gameTime;
                    } else if (this.spriteAnimationSequence == 2) {
                        this.startAnimation(3);
                        this.ints[1] = GameObject.gameWorld.gameTime;
                    }
                } else if (bl2 && bl) {
                    if (this.spriteAnimationSequence == 1) {
                        this.startAnimation(0);
                        this.ints[1] = GameObject.gameWorld.gameTime;
                    } else if (this.spriteAnimationSequence == 3) {
                        this.startAnimation(2);
                        this.ints[1] = GameObject.gameWorld.gameTime;
                    }
                }
                if (this.spriteAnimationSequence > 1) {
                    if (!gameWorld.isState(3)) {
                        this.spriteNAnimTelapsPerTick = 1;
                    }
                } else {
                    this.spriteNAnimTelapsPerTick = Math.min(40, Math.abs(Engine.p2i(this.ints[5])) * 6);
                    if (this.spriteNAnimTelapsPerTick < 6 && Math.abs(this.ints[5]) > 0) {
                        this.spriteNAnimTelapsPerTick = 6;
                    } else if (Math.abs(this.ints[5]) == 0 && Engine.AnimatedBitmap_getAnimationFrame(this.spriteAnimationHandle) != 1) {
                        this.setFrame(1);
                    }
                }
                GameObject gameObject = this.objects[0];
                if (this.booleans[1]) {
                    if (this.ints[5] < 0 && Engine.AnimatedBitmap_getAnimationDirection(gameObject.spriteAnimationHandle) == 0) {
                        gameObject.spriteAnimationHandle = Engine.AnimatedBitmap_setAnimationDirection(gameObject.spriteAnimationHandle, 1);
                    } else if (this.ints[5] > 0 && Engine.AnimatedBitmap_getAnimationDirection(gameObject.spriteAnimationHandle) == 1) {
                        gameObject.spriteAnimationHandle = Engine.AnimatedBitmap_setAnimationDirection(gameObject.spriteAnimationHandle, 0);
                    }
                    gameObject.spriteNAnimTelapsPerTick = this.spriteAnimationSequence == 1 || this.spriteAnimationSequence == 0 ? this.spriteNAnimTelapsPerTick << 1 : 0;
                    this.booleans[1] = false;
                }
                if (!gameWorld.isState(7)) {
                    gameObject.tick();
                }
                if (this.spriteAnimationSequence != 6 || !gameWorld.isAtLeastState(7, 3) && !gameWorld.isState(8)) break;
                gameWorld.addObject(GameObject.createParticle(0, Engine.rndPositive(2) == 0 ? 4 : 11, this.pos.x + Engine.i2p(Engine.rnd(this.spriteWidth >> 1)), this.pos.y - Engine.i2p(this.spritePaintOffsetY) + Engine.scale(3840 + Engine.rndPositive(12800))));
                break;
            }
            case 2: {
                if (this.ints[29] != 1 && this.ints[32] == 2) {
                    this.ints[32] = this.booleans[0] ? 1 : 0;
                }
                if (this.ints[29] == 1 && this.tick >= this.ints[33]) {
                    this.ints[32] = this.ints[32] + 1;
                    if (this.ints[32] > 2) {
                        this.ints[32] = 1;
                    }
                    int n = this.ints[26] >= 512 ? 1 : (this.ints[26] >= 256 ? 2 : (this.ints[26] >= 128 ? 3 : 4));
                    this.ints[33] = this.tick + n;
                }
                if (this.ints[16] != 1) break;
                this.onScreen = this.isOnScreen();
                break;
            }
            case 4: {
                if (!this.onScreen || GameObject.gameWorld.tick < this.ints[12]) break;
                int n = this.pos.y + Engine.rnd(7680);
                int n2 = this.ints[11] == 4 ? this.pos.x - Engine.i2p(Engine.scale(15)) : this.pos.x + Engine.i2p(Engine.scale(15));
                GameObject gameObject = GameObject.createParticle(2, 9, n2, n);
                if (this.ints[11] == 4) {
                    gameObject.startAnimation(1);
                    gameObject.vel.x = -1280;
                } else {
                    gameObject.startAnimation(0);
                    gameObject.vel.x = 1280;
                }
                gameWorld.addObject(gameObject);
                this.ints[12] = GameObject.gameWorld.tick + 3 + Engine.rndPositive(3);
                break;
            }
            case 6: {
                if (this.ints[0] < this.ints[2]) {
                    this.ints[0] = this.ints[0] + Math.min(this.ints[2] - this.ints[0], 3);
                } else if (this.ints[0] > this.ints[2]) {
                    this.ints[0] = this.ints[0] - Math.min(this.ints[0] - this.ints[2], 3);
                } else if (GameObject.gameWorld.gameTime < this.ints[4] + 300) {
                    this.ints[2] = Engine.rnd(3);
                } else if (this.ints[2] != 0) {
                    this.ints[2] = 0;
                }
                if (this.ints[1] < this.ints[3]) {
                    this.ints[1] = this.ints[1] + Math.min(this.ints[3] - this.ints[1], 3);
                    break;
                }
                if (this.ints[1] > this.ints[3]) {
                    this.ints[1] = this.ints[1] - Math.min(this.ints[1] - this.ints[3], 3);
                    break;
                }
                if (GameObject.gameWorld.gameTime < this.ints[4] + 300) {
                    this.ints[3] = Engine.rnd(3);
                    break;
                }
                if (this.ints[3] == 0) break;
                this.ints[3] = 0;
                break;
            }
            case 9: {
                int n = this.ints[0];
                if (!(n != 1 && n != 4 && n != 3 || this.pos.y >= GameObject.gameWorld.viewPos.y - Engine.i2p(Engine.unScale((GameObject.gameWorld.viewHeight >> 1) - GameObject.gameWorld.viewOffsetY)) && this.pos.x >= GameObject.gameWorld.viewPos.x - Engine.i2p(3 * GameObject.gameWorld.viewWidth / 2) && this.pos.x <= GameObject.gameWorld.viewPos.x + Engine.i2p(3 * GameObject.gameWorld.viewWidth / 2))) {
                    this.removeObject();
                    return;
                }
                if (this.booleans[0]) {
                    if (this.acc.x < 0) {
                        if (this.pos.x < this.ints[1]) {
                            this.acc.x = -this.acc.x;
                            this.booleans[1] = !this.booleans[1];
                        }
                    } else if (this.acc.x > 0 && this.pos.x > this.ints[1]) {
                        this.acc.x = -this.acc.x;
                        boolean bl = this.booleans[1] = !this.booleans[1];
                    }
                    if (n == 0 && !this.animate && GameObject.gameWorld.gameTime - this.birthTime > 500) {
                        this.animate = true;
                    }
                }
                if (n == 4 && Engine.rndPositive(100) < 4) {
                    GameObject gameObject = GameObject.createParticle(1, 19, this.pos.x, this.pos.y);
                    gameObject.vel.y = -(256 + Engine.rndPositive(256));
                    gameWorld.addObject(gameObject);
                }
                if (n != 3) break;
                this.ints[3] = this.ints[3] + this.ints[4];
                this.ints[3] = this.ints[3] + this.ints[5];
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                if (this.type == 7 && this.objects[0] == null) break;
                this.onScreen = this.isOnScreen();
            }
        }
        ++this.tick;
    }

    public void stop() {
        this.vel.setVector(0, 0);
        this.acc.setVector(0, 0);
    }

    public boolean isOnScreen() {
        if (this.type == 1) {
            return true;
        }
        if (this.type == 8 || this.type == 2 || this.type == 7 || this.type == 10 || this.type == 11 || this.type == 12 || this.type == 4) {
            return gameWorld.isRectOnScreen(this.ints[4], this.ints[6], this.ints[5], this.ints[7]);
        }
        return gameWorld.isRectOnScreen(this.spriteX + this.spritePaintOffsetX, this.spriteY + this.spritePaintOffsetY, this.spriteWidth, this.spriteHeight);
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3 = n + this.spritePaintOffsetX;
        int n4 = n2 + this.spritePaintOffsetY;
        int n5 = 0;
        switch (this.type) {
            case 1: {
                n3 += Engine.DeviceConstants_MONKEY_OFFSETS[0];
                n4 += Engine.DeviceConstants_MONKEY_OFFSETS[1];
                if (GameWorld.PLAYER_SPRITES[this.ints[7]] != 6 && GameWorld.PLAYER_SPRITES[this.ints[7]] != 12) break;
                n3 -= 2;
                break;
            }
            case 4: {
                GameObject.paintSprite(graphics, 8, this.ints[8], this.spriteX + this.ints[9] + n3, this.spriteY + this.ints[10] + n4);
                break;
            }
            case 6: {
                n3 += this.ints[0];
                n4 += this.ints[1];
                break;
            }
            case 3: {
                if (this.spriteHandle == 2) {
                    this.spriteAnimationHandle = GameWorld.bananaAnimationHandle;
                    break;
                }
                if (this.spriteHandle != 3) break;
                this.spriteAnimationHandle = GameWorld.bananaBunchAnimationHandle;
            }
        }
        if (this.spriteHandle >= 0) {
            this.paintSprite(graphics, n3, n4);
        }
        switch (this.type) {
            case 1: {
                this.objects[0].paint(graphics, this.spriteX + n + Engine.DeviceConstants_MONKEY_OFFSETS[2], this.spriteY + n2 + Engine.DeviceConstants_MONKEY_OFFSETS[3] + n5);
                break;
            }
            case 2: {
                int n6 = this.ints[16];
                int n7 = 0;
                if (this.booleans[0]) {
                    n6 += 4;
                    if (this.ints[16] == 0) {
                        n7 = 1;
                    } else if (this.ints[16] == 1) {
                        n7 = 2;
                    } else if (this.ints[16] == 2) {
                        n7 = 3;
                    }
                }
                for (int i = 0; i < this.ints2[3].length; i += 2) {
                    int n8 = Engine.p2i(this.ints2[3][i]);
                    int n9 = Engine.p2i(this.ints2[3][i + 1]);
                    int n10 = this.spriteX + n8 + n;
                    int n11 = this.spriteY + n9 + n2;
                    if (n8 == 0 && n9 == 0) {
                        GameWorld.platformPivotImages[this.ints[32]].drawImage(graphics, this.spriteX + n, this.spriteY + 0 + GameWorld.PAINT_OFFSETS[0] + n2, 3);
                        continue;
                    }
                    GameWorld.platformTileImages[n6].drawImage(graphics, n10, n11 + GameWorld.PAINT_OFFSETS[0], 3);
                }
                break;
            }
            case 8: {
                int n12;
                int n13;
                int n14;
                int n15;
                boolean bl = this.booleans[0];
                for (n15 = 0; n15 < this.ints2[0].length - 2; n15 += 2) {
                    int n16;
                    n14 = Engine.p2i(Engine.scale(this.ints2[0][n15]));
                    n13 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 1]));
                    if (this.ints2[1][(n15 >> 1) + 1] == 0) {
                        n12 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 2]));
                        n16 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 3]));
                    } else if ((n15 += 2) >= this.ints2[0].length - 2) {
                        n12 = Engine.p2i(Engine.scale(this.ints2[0][0]));
                        n16 = Engine.p2i(Engine.scale(this.ints2[0][1]));
                        bl = false;
                    } else {
                        n12 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 2]));
                        n16 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 3]));
                    }
                    GameObject.drawFatLine(graphics, n14 + n, n13 + n2, n12 + n, n16 + n2, 9474213, 0x474764);
                }
                if (bl) {
                    n15 = Engine.p2i(Engine.scale(this.ints2[0][0]));
                    n14 = Engine.p2i(Engine.scale(this.ints2[0][1]));
                    n13 = Engine.p2i(Engine.scale(this.ints2[0][this.ints2[0].length - 2]));
                    n12 = Engine.p2i(Engine.scale(this.ints2[0][this.ints2[0].length - 1]));
                    GameObject.drawFatLine(graphics, n15 + n, n14 + n2, n13 + n, n12 + n2, 9474213, 0x474764);
                }
                for (n15 = 0; n15 < this.ints2[0].length - 1; n15 += 2) {
                    n14 = Engine.p2i(Engine.scale(this.ints2[0][n15]));
                    n13 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 1]));
                    if (this.ints2[1][n15 >> 1] == 0) {
                        GameWorld.trackEndImage.drawImage(graphics, n14 + n, n13 + n2, 3);
                    }
                    if (n15 != this.ints2[0].length - 4 || this.ints2[0][0] == this.ints2[0][n15 + 2] || this.ints2[0][1] == this.ints2[0][n15 + 3]) continue;
                    n14 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 2]));
                    n13 = Engine.p2i(Engine.scale(this.ints2[0][n15 + 3]));
                    GameWorld.trackEndImage.drawImage(graphics, n14 + n, n13 + n2, 3);
                }
                break;
            }
            case 10: {
                int[] nArray = this.ints2[0];
                int n17 = nArray[0];
                int n18 = nArray[1];
                for (int i = 2; i < nArray.length; i += 2) {
                    int n19 = nArray[i];
                    int n20 = nArray[i + 1];
                    int n21 = Engine.p2i(Engine.scale(n17));
                    int n22 = Engine.p2i(Engine.scale(n18));
                    int n23 = Engine.p2i(Engine.scale(n19));
                    int n24 = Engine.p2i(Engine.scale(n20));
                    GameObject.drawFatLine(graphics, n21 + n, n22 + n2, n23 + n, n24 + n2, 0x6E8888, 5268580);
                    n17 = n19;
                    n18 = n20;
                }
                break;
            }
            case 7: {
                int[] nArray = this.ints2[1];
                int n25 = -(GameWorld.goalTileImages[0].height >> 1) + GameWorld.PAINT_OFFSETS[0];
                int n26 = this.spriteX - (this.spriteWidth >> 1);
                GameWorld.getGoalTileImage(nArray[0]).drawImage(graphics, n26 + n, this.spriteY + n25 + n2);
                graphics.drawImage(this.images[0], (n26 += GameWorld.goalTileEndImages[0].width) + n, this.spriteY + n25 + n2, 20);
                n26 = this.spriteX + (this.spriteWidth >> 1);
                GameWorld.getGoalTileImage(nArray[nArray.length - 1]).drawImage(graphics, n26 + n, this.spriteY + n25 + n2, 24);
                break;
            }
            case 11: {
                graphics.setColor(0);
                int[] nArray = this.ints2[0];
                int[] nArray2 = this.ints2[1];
                int n27 = 0;
                int n28 = nArray[0];
                int n29 = nArray[1];
                for (int i = 2; i < nArray.length; i += 2) {
                    int n30 = nArray[i];
                    int n31 = nArray[i + 1];
                    int n32 = nArray2[n27++];
                    int n33 = nArray2[n27++];
                    int n34 = nArray2[n27++];
                    int n35 = nArray2[n27++];
                    int n36 = Engine.p2i(Engine.scale(n28 + n32));
                    int n37 = Engine.p2i(Engine.scale(n29 + n33));
                    int n38 = Engine.p2i(Engine.scale(n30 + n32));
                    int n39 = Engine.p2i(Engine.scale(n31 + n33));
                    graphics.drawLine(n36 + n, n37 + n2, n38 + n, n39 + n2);
                    n36 = Engine.p2i(Engine.scale(n28 + n34));
                    n37 = Engine.p2i(Engine.scale(n29 + n35));
                    n38 = Engine.p2i(Engine.scale(n30 + n34));
                    n39 = Engine.p2i(Engine.scale(n31 + n35));
                    graphics.drawLine(n36 + n, n37 + n2, n38 + n, n39 + n2);
                    n28 = n30;
                    n29 = n31;
                }
                break;
            }
            case 9: {
                if (this.ints[0] != 3) break;
                int n40 = this.ints[2];
                graphics.setColor(this.ints[3]);
                graphics.fillRect(this.spriteX - (n40 >> 1) + n, this.spriteY - (n40 >> 1) + n2, n40, n40);
            }
        }
    }

    public static void drawFatLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < FAT_LINE_OFFSETS.length; i += 2) {
            if (i == FAT_LINE_OFFSETS.length - 2) {
                graphics.setColor(n5);
            } else {
                graphics.setColor(n6);
            }
            int n7 = 0;
            graphics.drawLine(n + FAT_LINE_OFFSETS[i] - n7, n2 + FAT_LINE_OFFSETS[i + 1], n3 + FAT_LINE_OFFSETS[i] + n7, n4 + FAT_LINE_OFFSETS[i + 1]);
        }
    }

    public void removeObject() {
        if (this.array != null) {
            this.array[this.arrayIndex] = null;
        }
        if (this.arrayIndexOnScreenIndex != -1) {
            this.arrayIndexOnScreenArray[this.arrayIndexOnScreenIndex] = null;
        }
        gameWorld.removeObject(this);
    }

    public static GameObject createSprite(int n) {
        GameObject gameObject = new GameObject();
        gameObject.setSprite(n);
        return gameObject;
    }

    public void startAnimation(int n) {
        this.spriteAnimationSequence = n;
        this.spriteAnimationHandle = Engine.AnimatedBitmap_startAnimation(n);
    }

    public int getNumFrames() {
        return Engine.AnimatedBitmap_getNumCells(this.spriteHandle);
    }

    public void setFrame(int n) {
        this.spriteAnimationHandle = Engine.AnimatedBitmap_setAnimationFrame(this.spriteHandle, this.spriteAnimationHandle, n);
    }

    public void tickSprite() {
        if (this.spriteHandle >= 0) {
            this.spriteAnimationHandle = Engine.AnimatedBitmap_tickAnimation(this.spriteHandle, this.spriteAnimationHandle, this.spriteNAnimTelapsPerTick);
        }
    }

    public void paintSprite(Graphics graphics, int n, int n2) {
        if (this.spriteHandle >= 0) {
            Engine.AnimatedBitmap_drawImage(graphics, this.spriteHandle, this.spriteAnimationHandle, this.spriteX + n, this.spriteY + n2);
        }
    }

    public static void paintSprite(Graphics graphics, int n, int n2, int n3, int n4) {
        GameObject.paintSprite(graphics, n, n2, n3, n4, 20);
    }

    public static void paintSprite(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Engine.AnimatedBitmap_drawImage(graphics, n, n2, n3, n4, n5);
    }

    static {
        PLATFORMS_START_VEL = new byte[]{5, 3, 2, 1};
        PLATFORMS_MAX_VEL = new byte[]{7, 6, 5, 4};
        PLATFORMS_ACC = new int[]{256, 192, 128, 64};
        LEFT_END_MAPPING = new byte[]{0, 20, 1, 22, 2, 24, 3, 26};
        RIGHT_END_MAPPING = new byte[]{0, 21, 1, 23, 2, 25, 3, 27};
        FAT_LINE_OFFSETS = new byte[]{0, 1, 0, -1, -1, 0, 1, 0, 0, 0};
        ANIMATION_HANDLE_0 = Engine.AnimatedBitmap_startAnimation(0);
    }
}

