/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage
implements Constants {
    public static final boolean USE_CLIPPING = false;
    private Image image;
    private int manipulation = 0;
    private int clip_x;
    private int clip_y;
    public short width;
    public short height;

    public DeviceImage(byte[] byArray) {
        this.createImage(byArray);
    }

    public DeviceImage(int n) {
        this.createImage(Engine.ResourceManager_getResource(n));
    }

    private void createImage(byte[] byArray) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.width = (short)n3;
        this.height = (short)n4;
        this.image = deviceImage.image;
        this.clip_x = n;
        this.clip_y = n2;
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        short s = this.height;
        return this.divide(n2, s);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2);
            }
        }
        return deviceImageArray;
    }

    public void drawImageAs(Graphics graphics, int n, int n2, int n3) {
        this.drawImageAs(graphics, n, n2, n3, 20);
    }

    public void drawImageAs(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n4 != 20) {
            if ((n4 & 8) != 0) {
                n -= this.width;
            }
            if ((n4 & 1) != 0) {
                n -= this.width >> 1;
            }
            if ((n4 & 0x20) != 0) {
                n2 -= this.height;
            }
            if ((n4 & 2) != 0) {
                n2 -= this.height >> 1;
            }
        }
        graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, n3, n, n2, 20);
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        this.drawImageAs(graphics, n, n2, this.manipulation, 20);
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3) {
        this.drawImageAs(graphics, n, n2, this.manipulation, n3);
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n, n2, 20);
    }
}

