/*
 * Decompiled with CFR 0.152.
 */
package rats;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import rats.CBalloon;
import rats.CBoardMouse;
import rats.CBoards;
import rats.CBouquet;
import rats.CImages;
import rats.CJavelin;
import rats.CMenu;
import rats.CMouse;
import rats.Rats;

public class CMainScreen
extends GameCanvas
implements CommandListener {
    public int MATCHES_X = 300;
    private int MATCHES_STOP_X = 40;
    private int M_STOP_RUN = 10;
    private int STEP_RUN = 10;
    private int SPEED_SCALE_UP = 4;
    private int SPEED_SCALE_DOWN = 9;
    private int STANDARD_G = this.div(this.itofx(1), this.itofx(40));
    private int MAX_SCROLL_SPEED = 20;
    private int MAX_SPEED_DOWN = 2;
    private int DEX_COEF = 1;
    private int MAX_ANGLE_DOWN = 2;
    private int[][] POINTS_SPD = new int[][]{{100, 50}, {30, 15}, {40, 20}};
    private int[][] POINTS_STR = new int[][]{{200, 100}, {300, 150}, {100, 50}};
    private int[][] POINTS_DEX = new int[][]{{3, 2}, {4, 2}, {8, 4}};
    private int[] BEGIN_SPD = new int[]{70, 60, 50};
    private int[] BEGIN_STR = new int[]{5000, 6000, 7000};
    private int[] BEGIN_DEX = new int[]{3, 3, 5};
    private int EXP_DISTANCE = 6;
    public int m_gameskill = -1;
    private int m_game_state = 0;
    private CMenu m_menu;
    private CImages m_images;
    private CBoards m_boards;
    private CJavelin m_javelin;
    private CMouse m_mouse;
    private CBoardMouse[] m_boardmouses;
    private CBalloon[] m_balloons;
    private CBalloon m_final_balloon;
    private CBouquet m_bouquet;
    Random m_random = new Random();
    private boolean m_animate = true;
    private static int MILLIS_PER_TICK = 10;
    private int WIDTH = 128;
    private int HEIGHT = 128;
    private int m_SPD = this.itofx(60);
    private int m_STR = this.itofx(6000);
    private int m_DEX = this.itofx(3);
    private int G = 0;
    private int m_vx = 0;
    private int m_vy = 0;
    private int m_Angle = 0;
    private int m_Step = 0;
    private int m_Run = this.MATCHES_X;
    private int m_TotalRun = 0;
    private int m_CurrentRun = 0;
    private int m_Result = 0;
    private int m_BestResult = 0;
    boolean m_params_visible = false;
    boolean m_reporter_visible = false;
    boolean m_demo_mode = false;
    boolean m_sound_on = true;
    private int[] m_Freq = new int[10];
    private int[] m_Dur = new int[10];
    private int m_SoundsNumber = 0;
    private int m_SoundsCurrent = 0;
    String m_String = "";
    int S_STANDING = 0;
    int S_RUN = 1;
    int S_PREPARE = 2;
    int S_FLY = 3;
    int S_TIRED = 4;
    int S_DOWN = 5;
    int m_State = this.S_STANDING;
    boolean m_ShowHint = false;
    Timer m_tm = null;
    TimerTask taskPerformer = new TimerTask(){

        public void run() {
            CMainScreen.this.onTimer();
        }
    };
    long m_SoundTimer = 0L;
    int[] m_Top = new int[]{0, 0, 0};
    int[] sin_table = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 128, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 127, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, -4, -8, -13, -17, -22, -26, -31, -35, -40, -44, -48, -53, -57, -61, -66, -70, -74, -79, -83, -87, -91, -95, -100, -104, -108, -112, -116, -120, -124, -128, -131, -135, -139, -143, -146, -150, -154, -157, -161, -164, -167, -171, -174, -177, -181, -184, -187, -190, -193, -196, -198, -201, -204, -207, -209, -212, -214, -217, -219, -221, -223, -226, -228, -230, -232, -233, -235, -237, -238, -240, -242, -243, -244, -246, -247, -248, -249, -250, -251, -252, -252, -253, -254, -254, -255, -255, -255, -255, -255, -256, -255, -255, -255, -255, -255, -254, -254, -253, -252, -252, -251, -250, -249, -248, -247, -246, -244, -243, -242, -240, -238, -237, -235, -233, -232, -230, -228, -226, -223, -221, -219, -217, -214, -212, -209, -207, -204, -201, -198, -196, -193, -190, -187, -184, -181, -177, -174, -171, -167, -164, -161, -157, -154, -150, -146, -143, -139, -135, -131, -127, -124, -120, -116, -112, -108, -104, -100, -95, -91, -87, -83, -79, -74, -70, -66, -61, -57, -53, -48, -44, -40, -35, -31, -26, -22, -17, -13, -8, -4};

    public CMainScreen(String str, CMenu menu) {
        super(false);
        this.m_menu = menu;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_images = new CImages(11);
        this.m_boards = new CBoards(this.m_images.Get(0), this.m_images.Get(1), this.m_images.Get(7), this.m_images.Get(9));
        this.m_mouse = new CMouse(this.m_images);
        this.m_javelin = new CJavelin();
        this.m_boardmouses = new CBoardMouse[2];
        this.m_boardmouses[0] = new CBoardMouse(this.m_images);
        this.m_boardmouses[1] = new CBoardMouse(this.m_images);
        this.m_bouquet = new CBouquet(this.m_images.Get(8));
        this.m_balloons = new CBalloon[10];
        int i = 0;
        while (i < 10) {
            this.m_balloons[i] = null;
            ++i;
        }
        if (this.m_menu.m_nead_load) {
            this.LoadFromData(this.m_menu.m_store.GetData());
        }
        if (this.m_menu.m_store.GetData() != null && this.m_menu.m_store.GetData().length > 28) {
            int i2 = 0;
            while (i2 < 4) {
                this.m_Top[i2] = this.m_menu.m_store.GetData()[21 + i2 * 2] * 256 + this.m_menu.m_store.GetData()[22 + i2 * 2];
                ++i2;
            }
        }
        this.m_mouse.SetPos(3, 113);
        this.m_javelin.SetPos(52, 132);
        this.m_Angle = this.itofx(90);
        this.m_tm = new Timer();
        this.m_tm.schedule(this.taskPerformer, MILLIS_PER_TICK, (long)MILLIS_PER_TICK);
        this.setFullScreenMode(true);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            Rats.quitApp();
        }
    }

    public void SetState(int newState) {
        this.m_State = newState;
        if (this.m_State == this.S_STANDING) {
            this.m_String = "";
            this.m_final_balloon = null;
            this.m_reporter_visible = false;
            this.m_Angle = this.itofx(90);
            this.m_Step = 0;
            this.m_vx = 0;
            this.m_vy = 0;
            this.m_boards.SetVX(0);
            this.m_boards.SetVY(0);
            this.m_boards.SetPos(this.m_boards.GetX(), this.m_boards.BEGIN_Y);
            this.m_boards.ReinitTablet();
            this.m_mouse.SetPos(3, 113);
            this.m_mouse.SetVel(0, 0);
            this.m_mouse.SetState(this.m_mouse.S_STANDING);
            this.m_javelin.SetPos(52, 122);
            this.m_Run = this.MATCHES_X;
            this.m_boardmouses[0].SetPos(this.m_Run + 64, this.m_boards.BEGIN_Y - 27);
            this.m_boardmouses[1].SetPos(this.m_Run + 160, this.m_boards.BEGIN_Y - 27);
            this.m_boardmouses[0].SetBalloonVisible(true);
            this.m_boardmouses[1].SetBalloonVisible(true);
            this.m_boardmouses[0].SetNumber(20);
            this.m_boardmouses[1].SetNumber(30);
            this.m_boardmouses[0].SetVel(0, 0);
            this.m_boardmouses[1].SetVel(0, 0);
            this.m_bouquet.SetVisible(false);
            int i = 0;
            while (i < 10) {
                this.m_balloons[i] = null;
                ++i;
            }
        } else if (this.m_State == this.S_RUN) {
            this.PlaySound(0);
            this.m_mouse.SetState(this.m_mouse.S_RUN);
            this.m_mouse.SetPos(2, 138);
            this.m_javelin.SetPos(57, 133);
            this.m_boards.SetVX(-3);
            this.m_boards.SetVY(0);
            this.m_Angle = 0;
            this.m_Run = this.MATCHES_X;
            this.m_boardmouses[0].SetVel(-3, 0);
            this.m_boardmouses[1].SetVel(-3, 0);
        } else if (this.m_State == this.S_PREPARE) {
            this.PlaySound(1);
            this.m_mouse.SetState(this.m_mouse.S_PREPARE);
            this.m_Angle = this.itofx(5);
            this.m_javelin.SetPos(40, 124);
        } else if (this.m_State == this.S_FLY) {
            this.PlaySound(2);
            this.CalculateV();
            this.m_Step = this.div(this.mul(this.m_Angle, this.G), this.m_vy);
            this.m_boards.SetVX(this.fxtoi(this.m_vx));
            this.m_boards.SetVY(this.fxtoi(this.m_vy));
            this.m_mouse.SetVel(-this.fxtoi(this.m_vx), this.fxtoi(this.m_vy));
            this.m_mouse.SetState(this.m_mouse.S_AFTER);
            this.m_boardmouses[0].SetVel(this.fxtoi(this.m_vx), this.fxtoi(this.m_vy));
            this.m_boardmouses[1].SetVel(this.fxtoi(this.m_vx), this.fxtoi(this.m_vy));
        } else if (this.m_State == this.S_TIRED) {
            this.PlaySound(3);
            this.m_boards.SetVX(0);
            this.m_boards.SetVY(0);
            this.m_mouse.SetState(this.m_mouse.S_TIRED);
            this.m_javelin.SetPos(66, 111);
            this.m_Angle = this.itofx(90);
            this.m_boardmouses[0].SetVel(0, 0);
            this.m_boardmouses[1].SetVel(0, 0);
            this.DoLevelUp(false);
            this.m_bouquet.Init(false);
        } else if (this.m_State == this.S_DOWN) {
            this.m_vx = 0;
            this.m_mouse.SetVel(0, 0);
            this.m_boards.SetVX(0);
            this.m_boards.SetVY(0);
            this.m_boards.SetPos(this.m_boards.GetX(), this.m_boards.BEGIN_Y);
            this.m_javelin.SetPos(40, 137);
            this.m_boardmouses[0].SetVel(0, 0);
            this.m_boardmouses[1].SetVel(0, 0);
            this.m_boardmouses[0].SetPos(this.m_boardmouses[0].GetX(), this.m_boards.BEGIN_Y - 27);
            this.m_boardmouses[1].SetPos(this.m_boardmouses[1].GetX(), this.m_boards.BEGIN_Y - 27);
            this.m_final_balloon = new CBalloon(this.m_images);
            this.m_final_balloon.SetPos(this.m_javelin.GetRight(this.fxtoi(this.m_Angle)), -50);
            this.m_final_balloon.SetVel(0, 3);
            int result = Math.min(this.m_boardmouses[0].GetNumber(), this.m_boardmouses[1].GetNumber());
            int min = Math.min(this.m_boardmouses[0].GetX() + 19, this.m_boardmouses[1].GetX() + 19);
            int max = Math.max(this.m_boardmouses[0].GetX() + 19, this.m_boardmouses[1].GetX() + 19);
            if (result == 10 && this.m_javelin.GetRight(this.fxtoi(this.m_Angle)) < min) {
                result = 20 * (this.m_javelin.GetRight(this.fxtoi(this.m_Angle)) - this.m_Run) / (min - this.m_Run);
            } else {
                int addition = 10 * (this.m_javelin.GetRight(this.fxtoi(this.m_Angle)) - min) / (max - min);
                result += addition;
            }
            if (this.m_javelin.GetRight(this.fxtoi(this.m_Angle)) <= this.m_Run) {
                result = 0;
            }
            if (result > this.m_BestResult) {
                this.PlaySound(4);
                this.m_BestResult = result;
                this.m_reporter_visible = true;
                if (this.m_BestResult > this.m_Top[this.m_gameskill]) {
                    this.m_Top[this.m_gameskill] = this.m_BestResult;
                }
            }
            this.m_final_balloon.SetNumber(result);
            if (result >= this.m_Result * (100 - this.EXP_DISTANCE) / 100) {
                if (this.DoLevelUp(true, result)) {
                    this.m_bouquet.Init(true);
                }
                if (!this.m_reporter_visible) {
                    this.PlaySound(5);
                }
            } else if (result <= this.m_Result / 2) {
                this.PlaySound(3);
                this.m_bouquet.Init(false);
            } else {
                this.PlaySound(5);
                this.m_bouquet.SetVisible(false);
            }
        }
    }

    public void NewGame() {
        if (this.m_gameskill < 0 || this.m_gameskill > 2) {
            this.m_gameskill = 0;
        }
        this.m_SPD = this.itofx(this.BEGIN_SPD[this.m_gameskill]);
        this.m_STR = this.itofx(this.BEGIN_STR[this.m_gameskill]);
        this.m_DEX = this.itofx(this.BEGIN_DEX[this.m_gameskill]);
        this.m_Result = 0;
        this.m_BestResult = 0;
        if (!this.m_demo_mode) {
            this.m_ShowHint = true;
        }
        this.SetState(this.S_STANDING);
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, 132, 176);
        this.m_boards.DrawSky(g);
        if (this.m_State == this.S_DOWN || this.m_State == this.S_TIRED) {
            this.m_bouquet.Draw(g, true);
        }
        this.m_boards.Draw(g);
        int i = 0;
        while (i < 10) {
            if (this.m_balloons[i] != null) {
                this.m_balloons[i].Draw(g);
            }
            ++i;
        }
        this.m_boardmouses[0].Draw(g);
        this.m_boardmouses[1].Draw(g);
        g.setClip(this.m_Run - 297, this.m_boards.GetY() + 5, 69, 37);
        g.drawImage(this.m_images.Get(9), this.m_Run - 297, this.m_boards.GetY() + 5 - 37, 0);
        g.setClip(0, 0, 132, 176);
        g.drawString("Max: " + this.m_BestResult, this.m_Run - 288, this.m_boards.GetY() + 15, 0);
        g.drawString("Best: " + Math.max(Math.max(this.m_Top[0], this.m_Top[1]), this.m_Top[2]), this.m_Run - 288, this.m_boards.GetY() + 25, 0);
        if (this.m_State == this.S_DOWN || this.m_State == this.S_TIRED) {
            this.m_bouquet.Draw(g, false);
        }
        if (this.m_Run > 0 && this.m_Run < 132) {
            g.drawImage(this.m_images.Get(4), this.m_Run, this.m_boards.GetY() + 77, 0);
        }
        this.m_mouse.Draw(g);
        this.m_javelin.Draw(g, this.fxtoi(this.m_Angle));
        if (this.m_final_balloon != null) {
            this.m_final_balloon.Draw(g);
        }
        g.setColor(0, 0, 0);
        if (this.m_demo_mode) {
            g.drawString("DEMO", 64, 9, 0x20 | 1);
        }
        if (this.m_reporter_visible) {
            g.drawImage(this.m_images.Get(10), 34, 117, 0);
        }
        if (this.m_params_visible) {
            this.DrawParams(g, 0, 0, 0);
        }
        if (this.m_ShowHint) {
            this.DrawHint(g);
        }
    }

    private void onTimer() {
        if (this.m_menu.m_display.getCurrent() != this) {
            return;
        }
        if (this.m_demo_mode) {
            this.OnTimerDemo();
        }
        if (this.m_State == this.S_PREPARE) {
            this.OnTimerPrepare();
        } else if (this.m_State == this.S_FLY) {
            this.OnTimerFly();
        } else if (this.m_State == this.S_RUN) {
            this.m_Run -= 3;
            if (this.m_Run < this.M_STOP_RUN) {
                this.SetState(this.S_TIRED);
            }
        } else if (this.m_State == this.S_DOWN || this.m_State == this.S_TIRED) {
            this.m_bouquet.OnTimer();
        }
        this.m_boards.OnTimer();
        this.m_mouse.OnTimer();
        this.m_boardmouses[0].OnTimer();
        this.m_boardmouses[1].OnTimer();
        int i = 0;
        while (i < 10) {
            if (this.m_balloons[i] != null) {
                this.m_balloons[i].SetVel(this.fxtoi(this.m_vx), this.fxtoi(this.m_vy) - 2);
                this.m_balloons[i].OnTimer();
                if (this.m_balloons[i].GetX() < -60) {
                    this.m_balloons[i] = null;
                }
            }
            ++i;
        }
        if (this.m_final_balloon != null) {
            this.m_final_balloon.OnTimer();
            this.m_final_balloon.SetPos(this.m_final_balloon.GetX(), this.m_final_balloon.GetY() + (Math.abs(this.m_random.nextInt()) % 4 - 1));
            if (this.m_final_balloon.GetY() > 70) {
                this.m_final_balloon.SetPos(this.m_final_balloon.GetX(), 70);
                this.m_final_balloon.SetVel(0, 0);
            }
        }
        this.repaint();
    }

    protected void OnTimerDemo() {
        if (this.m_State == this.S_STANDING) {
            this.SetState(this.S_RUN);
        } else if (this.m_State == this.S_RUN) {
            if (this.m_Run < this.MATCHES_X / 2 && Math.abs(this.m_random.nextInt()) % 2 == 0) {
                this.SetState(this.S_PREPARE);
            }
        } else if (this.m_State == this.S_PREPARE) {
            if (this.m_Run < this.MATCHES_STOP_X + 10) {
                this.SetState(this.S_FLY);
            }
        } else if ((this.m_State == this.S_DOWN || this.m_State == this.S_TIRED) && Math.abs(this.m_random.nextInt()) % 30 == 0) {
            this.SetState(this.S_STANDING);
        }
    }

    protected void OnTimerPrepare() {
        this.m_Run -= 3;
        if (this.m_Run < this.M_STOP_RUN) {
            this.SetState(this.S_TIRED);
        }
        this.m_Angle += this.itofx(1);
        if (this.m_Angle > this.itofx(80)) {
            this.m_Angle = this.itofx(80);
        }
    }

    protected void OnTimerFly() {
        this.m_Run += this.fxtoi(this.m_vx);
        if (this.m_vx != 0) {
            this.m_vy -= this.G;
            this.m_boards.SetVY(this.fxtoi(this.m_vy));
            this.m_mouse.SetVel(this.fxtoi(this.m_vx), this.fxtoi(this.m_vy));
            this.m_boardmouses[0].SetVel(this.fxtoi(this.m_vx), this.fxtoi(this.m_vy));
            this.m_boardmouses[1].SetVel(this.fxtoi(this.m_vx), this.fxtoi(this.m_vy));
            this.m_Angle -= this.m_Step;
            int i = 0;
            while (i < 2) {
                if (this.m_boardmouses[i].GetX() < 43) {
                    this.AddBalloon(this.m_boardmouses[i]);
                    this.m_boardmouses[i].SetBalloonVisible(false);
                }
                ++i;
            }
        }
        if (this.m_boards.GetY() < this.m_boards.BEGIN_Y) {
            this.SetState(this.S_DOWN);
        }
    }

    protected void CalculateV() {
        this.m_TotalRun = this.MATCHES_X - this.MATCHES_STOP_X;
        this.m_CurrentRun = this.MATCHES_X - this.m_Run;
        int StepRun = (100 - this.STEP_RUN) * this.m_TotalRun / 100;
        int FullVh = this.fxtoi(this.m_SPD);
        int Vh = this.m_CurrentRun < StepRun ? this.m_CurrentRun * FullVh / 3 / StepRun : FullVh / 3 + (this.m_CurrentRun - StepRun) * 2 * FullVh / 3 / (this.m_TotalRun - StepRun);
        int F = this.fxtoi(this.m_STR);
        int V = this.IntSqrt((F + Vh * Vh) * this.SPEED_SCALE_UP / this.SPEED_SCALE_DOWN);
        if (V >= this.IntSqrt((F + FullVh * FullVh) * this.SPEED_SCALE_UP / this.SPEED_SCALE_DOWN)) {
            V -= V * (this.m_random.nextInt() % (this.MAX_SPEED_DOWN + 1)) / 100;
        }
        int Vbase = V;
        V += this.m_random.nextInt() % this.fxtoi(this.m_DEX) * this.DEX_COEF;
        int A = this.fxtoi(this.m_Angle);
        if (A <= 0) {
            A = 3;
        }
        if (A <= 43 || A < 47) {
            // empty if block
        }
        this.m_vx = -this.mul(this.itofx(V), this.cos(A));
        this.m_vy = this.mul(this.itofx(V), this.sin(A));
        int FlyTime = this.fxtoi(this.mul(2, this.div(this.m_vy, this.STANDARD_G)));
        this.m_Result = this.fxtoi(-this.m_vx) * FlyTime;
        if (V > this.MAX_SCROLL_SPEED) {
            this.m_vx = -this.mul(this.itofx(this.MAX_SCROLL_SPEED), this.cos(A));
            this.m_vy = this.mul(this.itofx(this.MAX_SCROLL_SPEED), this.sin(A));
            this.G = this.m_Result != 0 ? this.div(this.mul(this.itofx(this.MAX_SCROLL_SPEED * this.MAX_SCROLL_SPEED), this.sin(2 * A)), this.itofx(this.m_Result)) : this.STANDARD_G;
        } else {
            this.G = this.STANDARD_G;
        }
        int MaxV = (F + FullVh * FullVh) * this.SPEED_SCALE_UP * this.SPEED_SCALE_UP / this.SPEED_SCALE_DOWN / this.SPEED_SCALE_DOWN;
        this.m_Result = MaxV / this.STANDARD_G / 6;
    }

    private boolean DoLevelUp(boolean aUp, int aResult) {
        int PointsDex;
        int PointsSpd;
        int PointsStr;
        int DStr = 0;
        int DDex = 0;
        int DSpd = 0;
        if (aUp) {
            if (aResult >= this.m_Result) {
                PointsStr = this.POINTS_STR[this.m_gameskill][0];
                PointsSpd = this.POINTS_SPD[this.m_gameskill][0];
                PointsDex = this.POINTS_DEX[this.m_gameskill][0];
            } else {
                PointsStr = this.POINTS_STR[this.m_gameskill][0] * (aResult - this.m_Result * (100 - this.EXP_DISTANCE) / 100) / (this.m_Result - this.m_Result * (100 - this.EXP_DISTANCE) / 100);
                PointsSpd = this.POINTS_SPD[this.m_gameskill][0] * (aResult - this.m_Result * (100 - this.EXP_DISTANCE) / 100) / (this.m_Result - this.m_Result * (100 - this.EXP_DISTANCE) / 100);
                PointsDex = this.POINTS_DEX[this.m_gameskill][0] * (aResult - this.m_Result * (100 - this.EXP_DISTANCE) / 100) / (this.m_Result - this.m_Result * (100 - this.EXP_DISTANCE) / 100);
                if (PointsStr > this.POINTS_STR[this.m_gameskill][0]) {
                    PointsStr = this.POINTS_STR[this.m_gameskill][0];
                }
                if (PointsSpd > this.POINTS_SPD[this.m_gameskill][0]) {
                    PointsSpd = this.POINTS_SPD[this.m_gameskill][0];
                }
                if (PointsDex > this.POINTS_DEX[this.m_gameskill][0]) {
                    PointsDex = this.POINTS_DEX[this.m_gameskill][0];
                }
            }
        } else {
            PointsStr = -this.POINTS_STR[this.m_gameskill][1];
            PointsSpd = -this.POINTS_SPD[this.m_gameskill][1];
            PointsDex = -this.POINTS_DEX[this.m_gameskill][1];
        }
        DSpd = this.div(this.itofx(PointsSpd), this.itofx(100));
        DStr = this.itofx(PointsStr);
        DDex = this.div(this.itofx(PointsDex), this.itofx(100));
        if (this.m_SPD < this.itofx(1000)) {
            this.m_SPD += DSpd;
        }
        if (this.m_STR < this.itofx(200000)) {
            this.m_STR += DStr;
        }
        if (this.m_DEX < this.itofx(1000)) {
            this.m_DEX += DDex;
        }
        if (this.m_STR < this.itofx(this.BEGIN_STR[this.m_gameskill])) {
            this.m_STR = this.itofx(this.BEGIN_STR[this.m_gameskill]);
        }
        if (this.m_DEX < this.itofx(this.BEGIN_DEX[this.m_gameskill])) {
            this.m_DEX = this.itofx(this.BEGIN_DEX[this.m_gameskill]);
        }
        if (this.m_SPD < this.itofx(this.BEGIN_SPD[this.m_gameskill])) {
            this.m_SPD = this.itofx(this.BEGIN_SPD[this.m_gameskill]);
        }
        return DSpd != 0 || DStr != 0 || DDex != 0;
    }

    private boolean DoLevelUp(boolean aUp) {
        return this.DoLevelUp(aUp, 0);
    }

    protected void keyPressed(int keyCode) {
        if (this.m_demo_mode) {
            this.m_menu.ShowMenu();
        }
        if (this.m_ShowHint) {
            this.m_ShowHint = false;
            return;
        }
        if (keyCode == 42) {
            this.SaveToData();
            this.m_menu.ShowMenu();
        } else if (keyCode == 35) {
            this.m_params_visible = !this.m_params_visible;
        } else {
            if (this.m_params_visible) {
                this.m_params_visible = false;
                return;
            }
            if (this.m_State == this.S_STANDING) {
                this.SetState(this.S_RUN);
            } else if (this.m_State == this.S_RUN) {
                this.SetState(this.S_PREPARE);
            } else if (this.m_State == this.S_PREPARE && this.m_Run > this.MATCHES_STOP_X) {
                this.SetState(this.S_FLY);
            } else if (this.m_State == this.S_TIRED || this.m_State == this.S_DOWN) {
                this.SetState(this.S_STANDING);
            }
        }
        this.repaint();
    }

    protected void keyReleased(int keyCode) {
    }

    void AddBalloon(CBoardMouse board_mouse) {
        if (!board_mouse.GetBalloonVisible()) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < 10) {
            if (this.m_balloons[i] == null) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return;
        }
        this.m_balloons[index] = new CBalloon(this.m_images);
        if (board_mouse.GetY() > 156) {
            this.m_balloons[index].SetPos(board_mouse.GetX() + 19 + 40, 128);
        } else {
            this.m_balloons[index].SetPos(board_mouse.GetX() + 19, board_mouse.GetY() - 28);
        }
        this.m_balloons[index].SetNumber(board_mouse.GetNumber());
    }

    void SaveToData() {
        byte[] data = new byte[]{(byte)(this.m_STR >> 24 & 0xFF), (byte)(this.m_STR >> 16 & 0xFF), (byte)(this.m_STR >> 8 & 0xFF), (byte)(this.m_STR & 0xFF), (byte)(this.m_SPD >> 24), (byte)(this.m_SPD >> 16 & 0xFF), (byte)(this.m_SPD >> 8 & 0xFF), (byte)(this.m_SPD & 0xFF), (byte)(this.m_DEX >> 24), (byte)(this.m_DEX >> 16 & 0xFF), (byte)(this.m_DEX >> 8 & 0xFF), (byte)(this.m_DEX & 0xFF), (byte)(this.m_BestResult >> 24), (byte)(this.m_BestResult >> 16 & 0xFF), (byte)(this.m_BestResult >> 8 & 0xFF), (byte)(this.m_BestResult & 0xFF), (byte)(this.m_Top[0] >> 8 & 0xFF), (byte)(this.m_Top[0] & 0xFF), (byte)(this.m_Top[1] >> 8 & 0xFF), (byte)(this.m_Top[1] & 0xFF), (byte)(this.m_Top[2] >> 8 & 0xFF), (byte)(this.m_Top[2] & 0xFF), (byte)this.m_gameskill, (byte)(this.m_menu.m_sound ? 1 : 0), (byte)(this.m_menu.m_vibro ? 1 : 0)};
        this.m_menu.m_store.SetData(data);
    }

    void LoadFromData(byte[] data) {
        if (data == null || data.length < 25 || data[22] < 0) {
            if (data != null && data.length == 25) {
                this.m_menu.m_sound = data[23] == 1;
                this.m_menu.m_vibro = data[24] == 1;
            }
            this.m_gameskill = 0;
            this.NewGame();
            return;
        }
        this.m_STR = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.m_SPD = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        this.m_DEX = (data[8] & 0xFF) << 24 | (data[9] & 0xFF) << 16 | (data[10] & 0xFF) << 8 | data[11] & 0xFF;
        this.m_BestResult = (data[12] << 24) + (data[13] << 16) + (data[14] << 8) + data[15];
        this.m_Top[0] = (data[16] & 0xFF) << 8 | data[17] & 0xFF;
        this.m_Top[1] = (data[18] & 0xFF) << 8 | data[19] & 0xFF;
        this.m_Top[2] = (data[20] & 0xFF) << 8 | data[21] & 0xFF;
        this.m_gameskill = data[22];
        this.m_menu.m_sound = data[23] == 1;
        this.m_menu.m_vibro = data[24] == 1;
        this.SetState(this.S_STANDING);
    }

    public void DrawParams(Graphics g, int STR, int DEX, int SPD) {
        g.setColor(255, 202, 78);
        g.fillRect(14, 14, 100, 100);
        g.setColor(153, 0, 0);
        g.drawRect(14, 14, 100, 100);
        g.drawRect(15, 15, 98, 98);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        if (this.m_gameskill == 0) {
            g.drawString("\u0411\u044b\u0441\u0442\u0440\u044b\u0439", 64, 27, 0x20 | 1);
        } else if (this.m_gameskill == 1) {
            g.drawString("\u041b\u043e\u0432\u043a\u0438\u0439", 64, 27, 0x20 | 1);
        } else if (this.m_gameskill == 2) {
            g.drawString("\u0421\u0438\u043b\u044c\u043d\u044b\u0439", 64, 27, 0x20 | 1);
        }
        g.drawString("STR : " + this.fxtoi(this.m_STR) / 100 + "," + this.fxtoi(this.m_STR) % 100, 64, 47, 0x20 | 1);
        g.drawString("DEX : " + this.fxtoi(this.mul(this.m_DEX, this.itofx(20))) + "," + this.mul(this.m_DEX, this.itofx(20)) % 256 * 100 / 256, 64, 57, 0x20 | 1);
        g.drawString("SPD : " + this.fxtoi(this.m_SPD) + "," + this.m_SPD % 256 * 100 / 256, 64, 67, 0x20 | 1);
        g.drawString("\u041b\u0443\u0447\u0448\u0438\u0439", 64, 87, 0x20 | 1);
        g.drawString("\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 :", 64, 97, 0x20 | 1);
        g.drawString("" + this.m_BestResult, 64, 107, 0x20 | 1);
    }

    public void DrawHint(Graphics g) {
        g.setColor(255, 202, 78);
        g.fillRect(14, 14, 100, 100);
        g.setColor(153, 0, 0);
        g.drawRect(14, 14, 100, 100);
        g.drawRect(15, 15, 98, 98);
        g.drawString("# - \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", 64, 27, 0x20 | 1);
        g.drawString("* - \u041c\u0435\u043d\u044e", 64, 37, 0x20 | 1);
        g.drawString("\u041b\u044e\u0431\u0430\u044f \u0434\u0440\u0443\u0433\u0430\u044f:", 64, 62, 0x20 | 1);
        g.drawString("\u0420\u0430\u0437\u0431\u0435\u0433", 64, 72, 0x20 | 1);
        g.drawString("\u0417\u0430\u043c\u0430\u0445", 64, 82, 0x20 | 1);
        g.drawString("\u0411\u0440\u043e\u0441\u043e\u043a", 64, 92, 0x20 | 1);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
    }

    private void PlaySound(int Number) {
        if (!this.m_menu.m_sound) {
            return;
        }
        if (Number == 0) {
            this.m_Freq[0] = 440;
            this.m_Dur[0] = 500;
            this.m_SoundsNumber = 1;
            this.m_SoundsCurrent = 0;
        } else if (Number == 1) {
            this.m_Freq[0] = 494;
            this.m_Dur[0] = 500;
            this.m_SoundsNumber = 1;
            this.m_SoundsCurrent = 0;
        } else if (Number == 2) {
            this.m_Freq[0] = 554;
            this.m_Dur[0] = 500;
            this.m_SoundsNumber = 1;
            this.m_SoundsCurrent = 0;
        } else if (Number == 3) {
            this.m_Freq[0] = 2093;
            this.m_Dur[0] = 300;
            this.m_Freq[1] = 1047;
            this.m_Dur[1] = 500;
            this.m_SoundsNumber = 2;
            this.m_SoundsCurrent = 0;
        } else if (Number == 4) {
            this.m_Freq[0] = 2093;
            this.m_Dur[0] = 150;
            this.m_Freq[1] = 2093;
            this.m_Dur[1] = 150;
            this.m_Freq[2] = 2637;
            this.m_Dur[2] = 150;
            this.m_Freq[3] = 3136;
            this.m_Dur[3] = 300;
            this.m_SoundsNumber = 4;
            this.m_SoundsCurrent = 0;
        } else if (Number == 5) {
            this.m_Freq[0] = 4186;
            this.m_Dur[0] = 150;
            this.m_Freq[1] = 1976;
            this.m_Dur[1] = 150;
            this.m_Freq[2] = 1760;
            this.m_Dur[2] = 150;
            this.m_Freq[3] = 3136;
            this.m_Dur[3] = 150;
            this.m_SoundsNumber = 4;
            this.m_SoundsCurrent = 0;
        }
    }

    void OnTimerSound() {
        if (this.m_SoundsCurrent >= 0 && System.currentTimeMillis() - this.m_SoundTimer > (long)this.m_Dur[this.m_SoundsCurrent]) {
            ++this.m_SoundsCurrent;
            if (this.m_SoundsCurrent >= this.m_SoundsNumber) {
                this.m_SoundsCurrent = -1;
            }
        }
    }

    private int itofx(int arg) {
        return arg * 256;
    }

    private int fxtoi(int arg) {
        return arg / 256;
    }

    private int mul(int arg1, int arg2) {
        return arg1 * arg2 / 256;
    }

    private int div(int arg1, int arg2) {
        return arg1 * 256 / arg2;
    }

    private int IntSqrt(int a) {
        if (a <= 0) {
            a = 0;
        } else {
            int p = 1;
            if (a < 32768) {
                a <<= 16;
                p = (byte)(p + 8);
            }
            if (a < 0x800000) {
                a <<= 8;
                p = (byte)(p + 4);
            }
            if (a < 0x8000000) {
                a <<= 4;
                p = (byte)(p + 2);
            }
            if (a < 0x20000000) {
                a <<= 2;
                p = (byte)(p + 1);
            }
            int x = a >> 15;
            x = x + a / x >> 1;
            x = x + a / x >> 1;
            a = x + a / x >> p;
        }
        return a;
    }

    private int cos(int aDeg) {
        return this.sin_table[Math.abs((aDeg + 90) % 360)];
    }

    private int sin(int aDeg) {
        return this.sin_table[Math.abs(aDeg % 360)];
    }
}

