/*
 * Decompiled with CFR 0.152.
 */
package rats;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import rats.Rats;

public class CIntro
extends Canvas
implements Runnable {
    private static int MILLIS_PER_TICK = 200;
    static Image m_IntroImg;
    private final Rats parent;
    private volatile Thread animationThread = null;
    private boolean animate = true;
    private long ScrTime;
    private long startScrTime;

    public CIntro(Rats parent) {
        this.parent = parent;
        m_IntroImg = this.createImage("/img/intro.png");
        this.ScrTime = 2000L;
        this.startScrTime = System.currentTimeMillis();
        this.setFullScreenMode(true);
    }

    synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    synchronized void stop() {
        m_IntroImg = null;
        this.animationThread = null;
        this.parent.AfterIntro();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTaken;
                if (currentThread != this.animationThread) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (startTime >= this.startScrTime + this.ScrTime) {
                    this.stop();
                }
                if (this.animate) {
                    this.tick();
                    this.repaint(0, 0, this.getWidth(), this.getHeight());
                    this.serviceRepaints();
                }
                if ((timeTaken = System.currentTimeMillis() - startTime) >= (long)MILLIS_PER_TICK) continue;
                CIntro cIntro = this;
                synchronized (cIntro) {
                    this.wait((long)MILLIS_PER_TICK - timeTaken);
                }
            }
        }
        catch (InterruptedException interruptedexception) {
            return;
        }
    }

    private synchronized void tick() {
        System.out.println("tick");
    }

    public void paint(Graphics g) {
        if (m_IntroImg != null) {
            g.drawImage(m_IntroImg, 0, 0, 0);
        }
    }

    private Image createImage(String filename) {
        Image image = null;
        try {
            image = Image.createImage((String)filename);
        }
        catch (IOException ioexception) {}
        return image;
    }

    protected void keyPressed(int keyCode) {
        this.stop();
    }
}

