/*
 * Decompiled with CFR 0.152.
 */
package rats;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CBoards {
    public int BOARD_WIDTH = 16;
    public int BOARDS_NUM = 9;
    public int BEGIN_Y = 60;
    public int CLOUDS_NUM = 4;
    public int GARBAGE_BEGIN_Y = 77;
    public int GARBAGE_END_Y = 60;
    public int GARBAGE_MIN_STEP = 50;
    public int GARBAGE_MAX_STEP = 80;
    public int GARBAGE_NUM = 4;
    public int GARBAGE_KINDS = 5;
    public int[] GARBAGE_X = new int[]{0, 28, 60, 77, 91};
    public int[] GARBAGE_WIDTH = new int[]{28, 32, 17, 14, 22};
    public int[] GARBAGE_HEIGHT = new int[]{14, 20, 20, 15, 15};
    int m_x = 0;
    int m_y = 0;
    int m_v_x = 0;
    int m_vx = 0;
    int m_vy = 0;
    int[] m_board = new int[this.BOARDS_NUM];
    int[] m_clouds_x = new int[4];
    int[] m_clouds_y = new int[4];
    int[] m_garbage = new int[this.GARBAGE_NUM];
    int[] m_garbage_x = new int[this.GARBAGE_NUM];
    int[] m_garbage_y = new int[this.GARBAGE_NUM];
    int m_tablet_x = 131;
    int m_tablet_y = 8;
    Image m_board_image = null;
    Image m_cloud_image = null;
    Image m_garbage_image = null;
    Image m_tablet_image = null;
    Random m_random = new Random();

    public CBoards(Image board, Image cloud, Image garbage, Image tablet) {
        this.m_board_image = board;
        this.m_cloud_image = cloud;
        this.m_garbage_image = garbage;
        this.m_tablet_image = tablet;
        int i = 0;
        while (i < this.BOARDS_NUM) {
            this.GenerateBoard(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.CLOUDS_NUM) {
            this.GenerateCloud(i2);
            int n = i2;
            this.m_clouds_x[n] = this.m_clouds_x[n] + (70 * i2 - 100);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.GARBAGE_NUM) {
            this.GenerateGarbage(i3);
            this.m_garbage_x[i3] = this.GARBAGE_MIN_STEP * i3;
            ++i3;
        }
        this.SetPos(0, this.BEGIN_Y);
    }

    public void GenerateBoard(int Number) {
        this.m_board[Number] = Math.abs(this.m_random.nextInt()) % 4;
    }

    public void GenerateCloud(int Number) {
        this.m_clouds_x[Number] = 128 + Math.abs(this.m_random.nextInt()) % 50;
        this.m_clouds_y[Number] = this.m_y - 30 - Math.abs(this.m_random.nextInt()) % 100;
    }

    public void GenerateGarbage(int Number) {
        int max = 0;
        int i = 0;
        while (i < this.CLOUDS_NUM) {
            if (max < this.m_garbage_x[i]) {
                max = this.m_garbage_x[i];
            }
            ++i;
        }
        this.m_garbage[Number] = Math.abs(this.m_random.nextInt()) % this.GARBAGE_KINDS;
        this.m_garbage_x[Number] = max + this.GARBAGE_MIN_STEP + Math.abs(this.m_random.nextInt()) % (this.GARBAGE_MAX_STEP - this.GARBAGE_MIN_STEP);
        this.m_garbage_y[Number] = this.GARBAGE_BEGIN_Y + Math.abs(this.m_random.nextInt()) % (this.GARBAGE_END_Y - this.GARBAGE_BEGIN_Y);
    }

    public void DrawSky(Graphics g) {
        g.setColor(204, 255, 255);
        g.fillRect(0, 0, 132, this.m_y + 5);
    }

    public void Draw(Graphics g) {
        int i = 0;
        while (i < this.BOARDS_NUM) {
            g.drawImage(this.m_board_image, this.m_v_x + this.BOARD_WIDTH * i, this.m_y + this.m_board[i], 0);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.CLOUDS_NUM) {
            g.drawImage(this.m_cloud_image, this.m_clouds_x[i2], this.m_clouds_y[i2], 0);
            ++i2;
        }
        g.setColor(171, 120, 27);
        g.fillRect(0, this.m_y + 77, 132, 53);
        int i3 = 0;
        while (i3 < this.GARBAGE_NUM) {
            g.setClip(this.m_garbage_x[i3], this.m_y + this.m_garbage_y[i3], this.GARBAGE_WIDTH[this.m_garbage[i3]], this.GARBAGE_HEIGHT[this.m_garbage[i3]]);
            g.drawImage(this.m_garbage_image, this.m_garbage_x[i3] - this.GARBAGE_X[this.m_garbage[i3]], this.m_y + this.m_garbage_y[i3], 0);
            ++i3;
        }
        g.setClip(0, 0, 132, 176);
        g.setClip(this.m_tablet_x, this.m_y + this.m_tablet_y, 69, 37);
        g.drawImage(this.m_tablet_image, this.m_tablet_x, this.m_y + this.m_tablet_y, 0);
        g.setClip(0, 0, 132, 176);
    }

    public void SetPos(int x, int y) {
        this.m_v_x += x - this.m_x;
        while (this.m_v_x < -this.BOARD_WIDTH) {
            int i = 1;
            while (i < this.BOARDS_NUM) {
                this.m_board[i - 1] = this.m_board[i];
                ++i;
            }
            this.GenerateBoard(this.BOARDS_NUM - 1);
            this.m_v_x += this.BOARD_WIDTH;
        }
        this.m_x = x;
        this.m_y = y;
    }

    public int GetX() {
        return this.m_x;
    }

    public int GetY() {
        return this.m_y;
    }

    public void OnTimer() {
        this.SetPos(this.m_x + this.m_vx, this.m_y + this.m_vy);
        int i = 0;
        while (i < this.CLOUDS_NUM) {
            int n = i;
            this.m_clouds_x[n] = this.m_clouds_x[n] + this.m_vx;
            int n2 = i;
            this.m_clouds_y[n2] = this.m_clouds_y[n2] + this.m_vy;
            if (this.m_clouds_x[i] < -50) {
                this.GenerateCloud(i);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.GARBAGE_NUM) {
            int n = i2;
            this.m_garbage_x[n] = this.m_garbage_x[n] + this.m_vx;
            if (this.m_garbage_x[i2] < -50) {
                this.GenerateGarbage(i2);
            }
            ++i2;
        }
        this.m_tablet_x += this.m_vx;
        if (this.m_tablet_x < -100) {
            this.m_tablet_x = 132 + Math.abs(this.m_random.nextInt()) % 50;
        }
    }

    public void SetVX(int vx) {
        this.m_vx = vx;
    }

    public void SetVY(int vy) {
        this.m_vy = vy;
    }

    public void ReinitTablet() {
        this.m_tablet_x = 133;
    }
}

