/*
 * Decompiled with CFR 0.152.
 */
package pagenetsoft.game;

import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;

class PNSound {
    public static PNSound SOUND;
    public static boolean isSound;
    private volatile boolean isPaused = true;
    private volatile int currentPriority = 0;
    private Sound sound = null;
    private static final byte[] SOUND_EXPLODE;
    private static final byte[] SOUND_OVER;
    private static final byte[] SOUND_SPLASH;
    private static final byte[] SOUND_RING;

    private PNSound() {
    }

    public static PNSound createSound() {
        SOUND = new PNSound();
        return SOUND;
    }

    boolean hasSoundCapability() {
        return true;
    }

    boolean hasVibrationCapability() {
        return true;
    }

    private synchronized void setIsPaused(boolean bl) {
        this.isPaused = bl;
    }

    void pause() {
        this.setIsPaused(true);
        if (this.sound != null) {
            this.sound.stop();
        }
        DeviceControl.stopVibra();
    }

    void resume() {
        if (!isSound) {
            return;
        }
        this.setIsPaused(false);
    }

    private void playSound(int n, byte[] byArray) {
        if (!isSound) {
            return;
        }
        if (!this.isPaused && this.hasSoundCapability()) {
            try {
                if (this.sound == null || this.sound.getState() != 0) {
                    this.sound = new Sound(byArray, 1);
                    this.sound.play(2);
                    this.currentPriority = n;
                } else if (n > this.currentPriority) {
                    this.sound.stop();
                    this.sound.init(byArray, 1);
                    this.sound.play(2);
                    this.currentPriority = n;
                }
            }
            catch (Exception exception) {
                this.currentPriority = 0;
            }
        }
    }

    public void playSplash() {
        this.playSound(1, SOUND_SPLASH);
    }

    public void playRing() {
        this.playSound(1, SOUND_RING);
    }

    public void playOver() {
        this.playSound(1, SOUND_OVER);
    }

    public void backlight() {
        DeviceControl.setLights((int)0, (int)100);
    }

    public void playExplode() {
        this.playSound(2, SOUND_EXPLODE);
        this.vibrate();
    }

    public void vibrate() {
        try {
            DeviceControl.startVibra((int)100, (long)500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        isSound = true;
        SOUND_EXPLODE = new byte[]{2, 74, 58, -128, 64, 1, 82, 72, 45, 2, 113, 73, 24, 32, -44, 18, 114, 0, 0};
        SOUND_OVER = new byte[]{2, 74, 58, 64, 4, 0, 37, 28, 102, 38, 88, 98, 4, 32, 97, -123, -104, 65, 4, 24, 98, 38, 88, 65, -124, -48, -125, 20, 45, 66, -108, 39, 0, 0};
        SOUND_SPLASH = new byte[]{2, 74, 58, 64, 4, 0, 31, 26, -126, -44, 33, 2, 20, 45, 66, -12, 47, 67, 20, 51, 67, 84, 73, 58, 40, -92, 0, 0};
        SOUND_RING = new byte[]{2, 74, 58, 64, 4, 0, 11, 30, -126, -112, 33, 2, -112, 0};
    }
}

