/*
 * Decompiled with CFR 0.152.
 */
package pagenetsoft.game;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import pagenetsoft.game.PNCanvas;
import pagenetsoft.game.PNMenu;
import pagenetsoft.game.PNStage;

public abstract class PNMidlet {
    private MIDlet midlet = null;
    public static PNMidlet MIDLET = null;
    public static final byte MS_EMPTY = 0;
    public static final byte MS_SPLASH_SCREEN = 1;
    public static final byte MS_MENU = 2;
    public static final byte MS_SHORT_MENU = 12;
    public static final byte MS_GAME_NEW = 3;
    public static final byte MS_GAME = 4;
    public static final byte MS_INSTRUCTIONS_TEXT = 5;
    public static final byte MS_OPTIONS = 6;
    public static final byte MS_HIGH_SCORES = 7;
    public static final byte MS_GAME_SCORES = 11;
    public static final byte MS_ABOUT = 8;
    public static final byte MS_QUIT = 9;
    public static final byte MS_GAMEOVER_SCREEN = 10;
    private PNMenu menu = null;
    private PNStage splash = null;
    private PNStage about = null;
    private PNStage help = null;
    private PNStage options = null;
    private PNStage highscore = null;
    private PNStage game = null;
    private Display display = null;
    private int state = 0;
    public static PNCanvas canvas;
    private Thread threadCanvas;

    public PNMidlet(MIDlet mIDlet) {
        MIDLET = this;
        this.midlet = mIDlet;
    }

    public final void notifyDestroyed() {
        this.midlet.notifyDestroyed();
    }

    public void startApp() {
        if (this.display == null) {
            this.display = Display.getDisplay((MIDlet)this.midlet);
            this.loadParams();
            canvas = new PNCanvas();
            this.setDisplayable((Displayable)canvas);
            this.threadCanvas = new Thread(canvas);
            this.threadCanvas.start();
        }
        if (this.state == 0) {
            this.setNewState(1);
        }
    }

    protected void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.menu = null;
        this.game = null;
        this.highscore = null;
        this.options = null;
        this.help = null;
        this.about = null;
        this.splash = null;
        this.display = null;
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)null);
    }

    public void setDisplayable(Displayable displayable) {
        this.display.setCurrent(displayable);
    }

    public void setNewState(int n) {
        switch (n) {
            case 1: {
                this.splash = this.createSplash();
                canvas.setStage(this.splash);
                break;
            }
            case 9: {
                this.saveParams();
                canvas.setStage(null);
                this.threadCanvas = null;
                this.notifyDestroyed();
                break;
            }
            case 10: {
                this.menu.setShort();
                this.splash = this.createGameOver();
                break;
            }
            case 12: {
                if (this.menu != null) {
                    this.menu.setShort();
                }
            }
            case 2: {
                if (this.menu == null) {
                    this.menu = this.createMenu();
                    canvas.setStage(this.menu);
                } else {
                    this.menu.resume();
                    canvas.setStage(this.menu);
                }
                this.highscore = null;
                this.options = null;
                this.help = null;
                this.about = null;
                this.splash = null;
                break;
            }
            case 4: {
                if (this.game == null) break;
                canvas.setStage(this.game);
                break;
            }
            case 3: {
                this.menu.setFull();
                if (this.game == null) {
                    this.game = this.createGame();
                    canvas.setStage(this.game);
                    break;
                }
                this.game.reload();
                canvas.setStage(this.game);
                break;
            }
            case 8: {
                this.about = this.createAbout();
                canvas.setStage(this.about);
                break;
            }
            case 6: {
                this.options = this.createOptions();
                canvas.setStage(this.options);
                break;
            }
            case 7: {
                this.highscore = this.createHighScores();
                canvas.setStage(this.highscore);
                break;
            }
            case 11: {
                this.highscore = this.createHighScores();
                canvas.setStage(this.highscore);
                break;
            }
            case 5: {
                this.help = this.createHelp();
                canvas.setStage(this.help);
                break;
            }
        }
    }

    public abstract PNMenu createMenu();

    public abstract PNStage createSplash();

    public abstract PNStage createGameOver();

    public abstract PNStage createHelp();

    public abstract PNStage createAbout();

    public abstract PNStage createOptions();

    public abstract PNStage createHighScores();

    public abstract PNStage createGameScores();

    public abstract PNStage createGame();

    public abstract void saveParams();

    public abstract void loadParams();
}

