/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.nokia.mid.ui.FullCanvas;
import game.BoardGame;
import game.CheckersGame;
import game.JumpersGame;
import game.QueensMain;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import lcg.C_sprite_engine;

public class QueensCanvas
extends FullCanvas
implements Runnable {
    private Display display;
    private QueensMain midlet;
    final int SCREEN_SX;
    final int SCREEN_SY;
    private static final byte MODE_WAIT_FROM = 0;
    private static final byte MODE_WAIT_TO = 1;
    private static final byte MODE_THINKING = 2;
    private static final byte MODE_ERROR = 3;
    private static final byte MODE_LOGO = 4;
    private static final byte MODE_FLASH_AI_FROM = 5;
    private static final byte MODE_FLASH_AI_TO = 6;
    private static final byte MODE_WIN = 7;
    private static final byte MODE_LOST = 8;
    private static final byte MODE_WAIT_TO_MULTI_JUMP = 9;
    private static final byte MODE_ERROR_MULTI_JUMP = 10;
    public static final byte GAME_TYPE_CHECKERS = 0;
    public static final byte GAME_TYPE_JUMPERS = 1;
    private byte[] field;
    private Image board;
    private Image img_logo;
    private int cursor_x;
    private int cursor_y;
    private int from_x;
    private int from_y;
    private int think_dest_x;
    private int think_dest_y;
    private boolean cursor_blink = false;
    private byte game_type;
    private byte mode;
    private String curr_err;
    C_sprite_engine spr_eng;
    BoardGame board_game;

    public QueensCanvas(Display display, QueensMain queensMain) {
        this.SCREEN_SX = 176;
        this.SCREEN_SY = 208;
        this.midlet = queensMain;
        this.display = display;
        try {
            this.spr_eng = new C_sprite_engine("/resources/spr.png", "/resources/spr.txt");
            this.board = Image.createImage((String)"/resources/playfield.png");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.field = new byte[64];
        this.SetGameType((byte)0);
        this.NewGame();
    }

    public void SetGameType(byte by) {
        this.game_type = by;
        switch (this.game_type) {
            case 0: {
                this.board_game = new CheckersGame(this.field);
                break;
            }
            case 1: {
                this.board_game = new JumpersGame(this.field);
                break;
            }
            default: {
                System.err.println("Invalid game type: " + by);
            }
        }
    }

    public byte GetGameType() {
        return this.game_type;
    }

    public void NewGame() {
        this.ResetField();
        this.mode = 0;
        try {
            this.img_logo = Image.createImage((String)"/resources/logo.png");
            this.mode = (byte)4;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void Debug(String string) {
        System.out.println("* " + string);
    }

    private static void Debug(int n) {
        QueensCanvas.Debug("" + n);
    }

    private void ResetField() {
        this.board_game.ResetField();
        this.cursor_x = this.board_game.GetInitCursorX();
        this.cursor_y = this.board_game.GetInitCursorY();
        this.from_x = 0;
        this.from_y = 0;
        this.think_dest_x = 0;
        this.think_dest_y = 0;
    }

    private int GetFieldScreenX(int n, int n2) {
        int n3;
        switch (n2) {
            case 0: {
                n3 = 17;
                break;
            }
            case 1: {
                n3 = 24;
                break;
            }
            case 2: {
                n3 = 29;
                break;
            }
            case 3: {
                n3 = 35;
                break;
            }
            case 4: {
                n3 = 39;
                break;
            }
            case 5: {
                n3 = 43;
                break;
            }
            case 6: {
                n3 = 46;
                break;
            }
            case 7: {
                n3 = 48;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        int n4 = 176 - n3;
        return n3 + (n4 - n3) * n / 7;
    }

    int GetFieldScreenY(int n) {
        switch (n) {
            case 0: {
                n = 76;
                break;
            }
            case 1: {
                n = 61;
                break;
            }
            case 2: {
                n = 46;
                break;
            }
            case 3: {
                n = 35;
                break;
            }
            case 4: {
                n = 24;
                break;
            }
            case 5: {
                n = 17;
                break;
            }
            case 6: {
                n = 9;
                break;
            }
            case 7: {
                n = 2;
            }
        }
        return n += 96;
    }

    private void DrawCursor(Graphics graphics, int n, int n2) {
        int n3 = this.GetFieldScreenX(this.cursor_x, this.cursor_y);
        int n4 = this.GetFieldScreenY(this.cursor_y);
        this.spr_eng.Paint(graphics, this.cursor_y * 8 + 0, n + n3, n2 + n4);
    }

    private void DrawFigure(Graphics graphics, byte n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = this.GetFieldScreenX(n2, n3);
        int n9 = this.GetFieldScreenY(n3);
        int n10 = n;
        this.spr_eng.Paint(graphics, n10 += n3 * 8, n6 + n8, n7 + (n9 += BoardGame.IsWhite((byte)n) ? n4 : n5));
    }

    private void DrawAllFigures(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 7;
        while (n5 >= 0) {
            int n6 = 1 - (n5 & 1);
            while (n6 < 8) {
                byte by = this.field[n5 * 8 + n6];
                if (by != 0) {
                    this.DrawFigure(graphics, by, n6, n5, n, n2, n3, n4);
                }
                n6 += 2;
            }
            --n5;
        }
    }

    private static String GetPositionText(int n, int n2) {
        return "" + (char)(65 + n) + (char)(49 + n2);
    }

    private void PaintGameText(Graphics graphics, int n, int n2, String string, boolean bl) {
        int n3 = n + (bl ? 88 : 2);
        int n4 = bl ? 17 : 0;
        graphics.setColor(0);
        graphics.drawString(string, n3 + 1, n2 + 3, n4);
        graphics.setColor(-1);
        graphics.drawString(string, n3, n2 + 2, n4);
    }

    protected void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (n - 176) / 2;
        int n4 = (n2 - 208) / 2;
        if (n3 != 0 || n4 != 0) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, n, n2);
        }
        if (this.mode == 4) {
            graphics.drawImage(this.img_logo, n3, n4, 0);
            if (this.cursor_blink) {
                this.spr_eng.BeginPaint(graphics);
                this.spr_eng.Paint(graphics, 64, n3 + 88, n4 + 124);
                this.spr_eng.EndPaint(graphics);
            }
            return;
        }
        graphics.drawImage(this.board, n3, n4, 0);
        Font font = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(font);
        boolean bl = false;
        boolean bl2 = false;
        int n5 = -1;
        boolean bl3 = false;
        int n6 = 0;
        int n7 = 0;
        switch (this.mode) {
            case 0: {
                String string = "Your move from: ";
                if (this.cursor_blink) {
                    string = string + QueensCanvas.GetPositionText(this.cursor_x, this.cursor_y);
                }
                bl = true;
                this.PaintGameText(graphics, n3, n4, string, false);
                BoardGame.MoveResult moveResult = this.board_game.IsValidSource(this.cursor_x, this.cursor_y, true);
                bl3 = moveResult.valid;
                break;
            }
            case 1: 
            case 9: {
                String string = "From: " + (char)(65 + this.from_x) + (char)(49 + this.from_y) + " to: ";
                if (this.cursor_blink) {
                    n5 = this.from_y * 8 + this.from_x;
                    string = string + QueensCanvas.GetPositionText(this.cursor_x, this.cursor_y);
                }
                bl = true;
                this.PaintGameText(graphics, n3, n4, string, false);
                BoardGame.MoveResult moveResult = this.board_game.TestMove(this.from_x, this.from_y, this.cursor_x, this.cursor_y, true);
                bl3 = moveResult.valid || this.from_x == this.cursor_x && this.from_y == this.cursor_y;
                break;
            }
            case 3: 
            case 10: {
                if (!this.cursor_blink) break;
                this.PaintGameText(graphics, n3, n4, this.curr_err, false);
                break;
            }
            case 2: {
                this.PaintGameText(graphics, n3, n4, "Considering...", false);
                break;
            }
            case 5: {
                String string = "Moving from ";
                if (this.cursor_blink) {
                    string = string + QueensCanvas.GetPositionText(this.from_x, this.from_y);
                } else {
                    n5 = this.from_y * 8 + this.from_x;
                }
                this.PaintGameText(graphics, n3, n4, string, false);
                break;
            }
            case 6: {
                String string = "Moving from " + QueensCanvas.GetPositionText(this.from_x, this.from_y) + " to ";
                if (this.cursor_blink) {
                    string = string + QueensCanvas.GetPositionText(this.think_dest_x, this.think_dest_y);
                } else {
                    n5 = this.think_dest_y * 8 + this.think_dest_x;
                }
                this.PaintGameText(graphics, n3, n4, string, false);
                break;
            }
            case 7: {
                if (this.cursor_blink) {
                    n6 += 2;
                    n7 -= 2;
                }
            }
            case 8: {
                bl2 = this.cursor_blink;
                this.PaintGameText(graphics, n3, n4, this.mode == 7 ? "You have won the game!" : "You lost!", true);
                if (!this.cursor_blink) break;
                n7 += 2;
            }
        }
        this.spr_eng.BeginPaint(graphics);
        if (bl) {
            this.DrawCursor(graphics, n3, n4);
        }
        byte by = 0;
        if (n5 != -1) {
            by = this.field[n5];
            this.field[n5] = 0;
        }
        this.DrawAllFigures(graphics, n6, n7, n3, n4);
        if (n5 != -1) {
            this.field[n5] = by;
        }
        if (bl3) {
            int n8 = this.GetFieldScreenX(this.cursor_x, this.cursor_y) + 4;
            int n9 = this.GetFieldScreenY(this.cursor_y) - this.spr_eng.GetSpriteHeight(this.cursor_y * 8 + 0) - 2;
            if (this.cursor_blink) {
                --n8;
                ++n9;
            }
            this.spr_eng.Paint(graphics, 65, n3 + n8, n4 + n9);
        }
        if (bl2) {
            this.spr_eng.Paint(graphics, 64, n3 + 88, n4 + 34);
        }
        this.spr_eng.EndPaint(graphics);
    }

    private void SetWinMode(boolean bl) {
        this.mode = (byte)(bl ? 7 : 8);
    }

    private void SetErrMode(String string) {
        this.curr_err = string;
        this.mode = (byte)(this.mode == 9 ? 10 : 3);
    }

    private void MakeAction() {
        switch (this.mode) {
            case 4: {
                this.mode = 0;
                this.img_logo = null;
                break;
            }
            case 0: {
                BoardGame.MoveResult moveResult = this.board_game.IsValidSource(this.cursor_x, this.cursor_y, true);
                if (moveResult.valid) {
                    this.from_x = this.cursor_x;
                    this.from_y = this.cursor_y;
                    this.mode = 1;
                    break;
                }
                this.SetErrMode(moveResult.err);
                break;
            }
            case 1: 
            case 9: {
                BoardGame.MoveResult moveResult = this.board_game.MakeMove(this.from_x, this.from_y, this.cursor_x, this.cursor_y, true);
                if (moveResult.valid) {
                    int n = this.board_game.GetGameStatus(false);
                    if (n != -1) {
                        this.SetWinMode(n == 0);
                        break;
                    }
                    if (!moveResult.continuous) {
                        this.mode = (byte)2;
                        break;
                    }
                    this.from_x = this.cursor_x;
                    this.from_y = this.cursor_y;
                    this.mode = (byte)9;
                    break;
                }
                if (this.from_x == this.cursor_x && this.from_y == this.cursor_y && this.mode == 1) {
                    this.mode = 0;
                    break;
                }
                this.SetErrMode(moveResult.err);
                break;
            }
            case 3: {
                this.mode = 0;
                break;
            }
            case 10: {
                this.mode = (byte)9;
                break;
            }
            case 7: 
            case 8: {
                this.NewGame();
            }
        }
    }

    private void MoveLeft() {
        if (this.cursor_x-- == 0) {
            this.cursor_x = 7;
        }
    }

    private void MoveRight() {
        if (++this.cursor_x == 8) {
            this.cursor_x = 0;
        }
    }

    private void MoveDown() {
        if (this.cursor_y-- == 0) {
            this.cursor_y = 7;
        }
    }

    private void MoveUp() {
        if (++this.cursor_y == 8) {
            this.cursor_y = 0;
        }
    }

    public void keyPressed(int n) {
        switch (n) {
            case -6: {
                this.midlet.ShowMenu();
                return;
            }
            case -7: {
                try {
                    this.midlet.destroyApp(false);
                    this.midlet.notifyDestroyed();
                }
                catch (MIDletStateChangeException mIDletStateChangeException) {
                    // empty catch block
                }
                return;
            }
        }
        block5 : switch (this.mode) {
            case 3: 
            case 10: {
                this.MakeAction();
                break;
            }
            case 0: 
            case 1: 
            case 9: {
                switch (this.getGameAction(n)) {
                    case 5: {
                        this.MoveRight();
                        break block5;
                    }
                    case 2: {
                        this.MoveLeft();
                        break block5;
                    }
                    case 1: {
                        this.MoveUp();
                        break block5;
                    }
                    case 6: {
                        this.MoveDown();
                        break block5;
                    }
                    case 8: {
                        this.MakeAction();
                        break block5;
                    }
                }
                switch (n) {
                    case 49: {
                        this.MoveLeft();
                        this.MoveUp();
                        break;
                    }
                    case 51: {
                        this.MoveRight();
                        this.MoveUp();
                        break;
                    }
                    case 55: {
                        this.MoveLeft();
                        this.MoveDown();
                        break;
                    }
                    case 57: {
                        this.MoveRight();
                        this.MoveDown();
                        break;
                    }
                    case 52: {
                        this.MoveLeft();
                        break;
                    }
                    case 54: {
                        this.MoveRight();
                        break;
                    }
                    case 56: {
                        this.MoveDown();
                        break;
                    }
                    case 50: {
                        this.MoveUp();
                        break;
                    }
                    case 53: {
                        this.MakeAction();
                    }
                }
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                switch (this.getGameAction(n)) {
                    case 8: {
                        this.MakeAction();
                    }
                }
            }
        }
        this.cursor_blink = false;
        this.repaint();
    }

    public void SaveGame() {
        this.ClearSaveGame();
        if (this.mode != 4) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"game", (boolean)true);
                recordStore.addRecord(this.field, 0, 64);
                byte[] byArray = new byte[6];
                int n = 0;
                byArray[n++] = this.game_type;
                byArray[n++] = (byte)this.cursor_x;
                byArray[n++] = (byte)this.cursor_y;
                byArray[n++] = (byte)this.from_x;
                byArray[n++] = (byte)this.from_y;
                int n2 = this.mode;
                switch (this.mode) {
                    case 2: 
                    case 5: 
                    case 10: {
                        n2 = 2;
                        break;
                    }
                    case 0: 
                    case 3: 
                    case 6: {
                        n2 = 0;
                        break;
                    }
                }
                byArray[n++] = n2;
                recordStore.addRecord(byArray, 0, n);
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void LoadGame() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"game", (boolean)false);
            recordStore.getRecord(1, this.field, 0);
            byte[] byArray = recordStore.getRecord(2);
            int n = 0;
            byte by = byArray[n++];
            if (this.game_type != by) {
                this.SetGameType(by);
            }
            this.cursor_x = byArray[n++];
            this.cursor_y = byArray[n++];
            this.from_x = byArray[n++];
            this.from_y = byArray[n++];
            this.mode = byArray[n++];
            recordStore.closeRecordStore();
            this.ClearSaveGame();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void ClearSaveGame() {
        try {
            RecordStore.deleteRecordStore((String)"game");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        this.display.setCurrent((Displayable)this);
        Thread thread = new Thread(this);
        thread.start();
    }

    private static void Sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            QueensCanvas.Debug("sleep failed");
        }
    }

    public void run() {
        while (true) {
            QueensCanvas.Sleep(200);
            this.cursor_blink = !this.cursor_blink;
            this.repaint();
            if (this.mode != 2) continue;
            this.MakeAIMove();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void MakeAIMove() {
        var1_1 = this.board_game.MakeAIMove();
        if (var1_1.IsValid()) ** GOTO lbl31
        this.SetWinMode(true);
        return;
lbl-1000:
        // 1 sources

        {
            this.from_x = var1_1.sx;
            this.from_y = var1_1.sy;
            this.think_dest_x = var1_1.dx;
            this.think_dest_y = var1_1.dy;
            this.cursor_blink = true;
            this.mode = (byte)5;
            var2_2 = 0;
            while (var2_2 < 6) {
                QueensCanvas.Sleep(200);
                this.cursor_blink = this.cursor_blink == false;
                this.repaint();
                ++var2_2;
            }
            var3_3 = this.board_game.MakeMove(var1_1.sx, var1_1.sy, var1_1.dx, var1_1.dy, false);
            if (!var3_3.valid) {
                return;
            }
            var1_1 = var1_1.cont_step;
            if (var1_1 != null) continue;
            this.mode = (byte)6;
            var4_4 = 0;
            while (var4_4 < 2) {
                QueensCanvas.Sleep(200);
                this.cursor_blink = this.cursor_blink == false;
                this.repaint();
                ++var4_4;
            }
lbl31:
            // 3 sources

            ** while (var1_1 != null)
        }
lbl32:
        // 1 sources

        var2_2 = this.board_game.GetGameStatus(true);
        if (var2_2 != -1) {
            this.SetWinMode(var2_2 == 0);
        } else {
            this.mode = 0;
        }
    }
}

