/*
 * Decompiled with CFR 0.152.
 */
package com.movaya.license.gamecontrol;

import com.hellomoto.fullscreen.FullCn;
import com.movaya.M123456;
import com.movaya.license.gamecontrol.MResource;
import com.movaya.license.gamecontrol.MUnlockUI;
import com.movaya.license.rms.RmsBiz;
import com.movaya.license.utils.Utils;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MTnbUI
extends FullCn
implements CommandListener {
    private M123456 mmidlet = null;
    private static final int ROWSPACING = 5;
    private int focusInd = -1;
    private int firstInd = 0;
    private int lastInd = 0;
    private Font titleFont;
    private Font defFont;
    private Font focusFont;
    private int bgColor;
    private int titleColor;
    private int defColor;
    private int focusColor;
    private int titleBgColor;
    private int focusBgColor;
    private Vector m_cmdList = null;
    private Vector m_strList = null;
    private Command m_exit = null;
    private Command m_tnbok = null;
    private RmsBiz rmsBiz = null;
    private String m_defFID = null;
    private long timeLimit = -1L;

    public MTnbUI(M123456 m2) {
        this.mmidlet = m2;
        this.rmsBiz = this.mmidlet.rmsBiz;
        this.m_defFID = this.rmsBiz.getDatLicense().getDefFeature().getFeatureId();
        this.timeLimit = this.rmsBiz.getTrialTimeLimit();
        this.m_cmdList = new Vector();
        this.m_strList = new Vector();
        this.titleFont = Font.getFont((int)Font.getDefaultFont().getFace(), (int)1, (int)Font.getDefaultFont().getSize());
        this.defFont = Font.getFont((int)Font.getDefaultFont().getFace(), (int)1, (int)Font.getDefaultFont().getSize());
        this.focusFont = Font.getFont((int)Font.getDefaultFont().getFace(), (int)1, (int)Font.getDefaultFont().getSize());
        this.titleColor = 0;
        this.defColor = 0;
        this.focusColor = 0x9B0000;
        this.titleBgColor = 0xAAAAAA;
        this.focusBgColor = 0xDEDEDE;
        this.bgColor = 0xFFFFFF;
        this.m_exit = Utils.getCmdExit();
        this.m_tnbok = Utils.getCmdOk();
        this.addCommand(this.m_exit);
        this.setCommandListener(this);
    }

    private MResource getRes() {
        return MResource.getResource(this.rmsBiz.getDatLicense());
    }

    public void process() {
        try {
            if (!this.rmsBiz.isPlayable(this.m_defFID)) {
                this.mmidlet.start();
            } else {
                if (this.rmsBiz.isTriable(this.m_defFID)) {
                    this.addList(this.getRes().tnb_tryLable);
                }
                if (this.rmsBiz.isBuyable(this.m_defFID)) {
                    this.addList(this.getRes().tnb_buyLable);
                } else if (this.rmsBiz.isOrderProcess(this.m_defFID)) {
                    this.addStr(this.getRes().tnb_orderProcessLable);
                }
                if (this.rmsBiz.isUnlockable(this.m_defFID)) {
                    this.addList(this.getRes().tnb_unlockLable);
                }
                if (this.m_cmdList.size() > 0) {
                    this.addCommand(this.m_tnbok);
                }
                this.mmidlet.display.setCurrent((Displayable)this);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void commandAction(Command cmd, Displayable dp) {
        if (cmd == this.m_exit) {
            this.mmidlet.notifyDestroyed();
        } else if (cmd == this.m_tnbok) {
            this.proCmd();
        }
    }

    protected void proCmd() {
        String focus = this.m_cmdList.elementAt(this.focusInd).toString();
        try {
            if (focus.equals(this.getRes().tnb_tryLable)) {
                this.rmsBiz.updateTry(this.m_defFID);
                this.mmidlet.start();
                new Controller(this.mmidlet, this.timeLimit).start();
            } else if (focus.equals(this.getRes().tnb_buyLable)) {
                this.mmidlet.purchase_123456(false);
            } else if (focus.equals(this.getRes().tnb_unlockLable)) {
                new MUnlockUI(this.mmidlet).unlock();
            } else if (focus.equals(this.getRes().tnb_orderProcessLable)) {
                this.mmidlet.notifyDestroyed();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void addList(Object item) {
        this.m_cmdList.addElement(item);
    }

    protected void addStr(Object str) {
        this.m_strList.addElement(str);
    }

    protected void paint(Graphics g2) {
        int y = 0;
        int x = 0;
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.titleBgColor);
        g2.fillRect(0, y, this.getWidth(), this.titleFont.getHeight());
        g2.setFont(this.titleFont);
        g2.setColor(this.titleColor);
        x = (this.getWidth() - this.titleFont.stringWidth(this.getRes().tnb_displayName)) / 2;
        g2.drawString(this.getRes().tnb_displayName, x, 0, 0);
        y += this.titleFont.getHeight();
        Object obj = null;
        String str = null;
        Image image = null;
        Vector v = null;
        int i2 = 0;
        while (i2 < this.m_cmdList.size()) {
            obj = this.m_cmdList.elementAt(i2);
            y += 5;
            if (obj instanceof Image) {
                image = obj;
                x = (this.getWidth() - image.getWidth()) / 2;
                g2.drawImage(image, x, y, 0);
                y += image.getHeight();
            } else if (obj instanceof String) {
                str = obj;
                v = Utils.split(str, this.focusFont, this.getWidth());
                if (-1 == this.focusInd) {
                    this.firstInd = i2;
                    this.focusInd = i2;
                }
                this.lastInd = i2;
                if (i2 == this.focusInd) {
                    g2.setColor(this.focusBgColor);
                    g2.fillRect(0, y, this.getWidth(), this.focusFont.getHeight() * v.size());
                    g2.setColor(this.focusColor);
                    g2.setFont(this.focusFont);
                    int j2 = 0;
                    while (j2 < v.size()) {
                        x = 1 == v.size() ? (this.getWidth() - this.focusFont.stringWidth(v.elementAt(j2).toString())) / 2 : 2;
                        g2.drawString(v.elementAt(j2).toString(), x, y, 0);
                        y += this.focusFont.getHeight();
                        ++j2;
                    }
                } else {
                    g2.setColor(this.defColor);
                    g2.setFont(this.defFont);
                    x = (this.getWidth() - this.defFont.stringWidth(str)) / 2;
                    int h2 = 0;
                    while (h2 < v.size()) {
                        x = 1 == v.size() ? (this.getWidth() - this.focusFont.stringWidth(v.elementAt(h2).toString())) / 2 : 2;
                        g2.drawString(v.elementAt(h2).toString(), x, y, 0);
                        y += this.defFont.getHeight();
                        ++h2;
                    }
                }
            }
            ++i2;
        }
        int h3 = 0;
        while (h3 < this.m_strList.size()) {
            y += 5;
            str = (String)this.m_strList.elementAt(h3);
            v = Utils.split(str, this.focusFont, this.getWidth());
            g2.setColor(this.defColor);
            g2.setFont(this.defFont);
            int m2 = 0;
            while (m2 < v.size()) {
                x = 1 == v.size() ? (this.getWidth() - this.focusFont.stringWidth(v.elementAt(m2).toString())) / 2 : 2;
                g2.drawString(v.elementAt(m2).toString(), x, y, 0);
                y += this.defFont.getHeight();
                ++m2;
            }
            ++h3;
        }
    }

    protected void KEYPRESSED(int keyCode) {
        int key = this.getGameAction(keyCode);
        if (key == 1 || keyCode == 50) {
            this.focusInd = this.focusInd == this.firstInd ? this.lastInd : --this.focusInd;
            this.repaint();
        } else if (key == 6 || keyCode == 56) {
            this.focusInd = this.focusInd == this.lastInd ? this.firstInd : ++this.focusInd;
            this.repaint();
        } else if (key == 8 || keyCode == 53) {
            this.proCmd();
        }
    }

    class Controller
    extends Thread {
        private long timeLimit = -1L;
        M123456 m_midlet = null;

        public Controller(M123456 mm, long timeLimit) {
            this.timeLimit = timeLimit;
            this.m_midlet = mm;
        }

        public synchronized void run() {
            try {
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
        }
    }
}

