/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class SSResourceManager {
    private static final String PACKAGE_NAME = "res";
    private int numFiles;
    private String[] resNames;
    private byte[] resIndex;
    private short[] resLength;
    private int[] resOffset;
    private int lastIndex = -1;
    private InputStream is;

    public SSResourceManager() {
        this.initResourceManager();
    }

    private void initResourceManager() {
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/res0"));
            byte[] buffer = new byte[256];
            short headerLength = dis.readShort();
            this.numFiles = dis.readUnsignedByte();
            this.resNames = new String[this.numFiles];
            this.resIndex = new byte[this.numFiles];
            this.resLength = new short[this.numFiles];
            this.resOffset = new int[this.numFiles];
            for (int i = 0; i < this.numFiles; ++i) {
                int nameLength = dis.readUnsignedByte();
                dis.read(buffer, 0, nameLength);
                this.resNames[i] = new String(buffer, 0, nameLength);
                this.resIndex[i] = (byte)dis.readUnsignedByte();
                this.resLength[i] = dis.readShort();
                this.resOffset[i] = dis.readInt();
            }
            dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getIndexResource(String name) {
        for (int i = 0; i < this.numFiles; ++i) {
            if (!this.resNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public byte[] getResource(String name) {
        try {
            int index = this.getIndexResource(name);
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/res" + this.resIndex[index]));
            dis.skip(this.resOffset[index]);
            byte[] file = new byte[this.resLength[index]];
            dis.read(file);
            dis.close();
            System.gc();
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataInputStream getResourceAsStream(String name) {
        try {
            int index = this.getIndexResource(name);
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/res" + this.resIndex[index]));
            dis.skip(this.resOffset[index]);
            return dis;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Image getImage(String name) {
        byte[] res = this.getResource(name);
        return Image.createImage((byte[])res, (int)0, (int)res.length);
    }
}

