/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class LayerManager {
    private Vector layers;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;

    public LayerManager() {
        this.setViewWindow(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.layers = new Vector();
    }

    public void append(Layer l2) {
        this.layers.addElement(l2);
    }

    public void insert(Layer l2, int index) {
        this.layers.insertElementAt(l2, index);
    }

    public Layer getLayerAt(int index) {
        return (Layer)this.layers.elementAt(index);
    }

    public int getSize() {
        return this.layers.size();
    }

    public void remove(Layer l2) {
        this.layers.removeElement(l2);
    }

    public void paint(Graphics g2, int x, int y) {
        int clipX = g2.getClipX();
        int clipY = g2.getClipY();
        int clipW = g2.getClipWidth();
        int clipH = g2.getClipHeight();
        g2.translate(x - this.viewX, y - this.viewY);
        g2.setClip(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        int i2 = this.layers.size();
        while (--i2 >= 0) {
            Layer comp = (Layer)this.layers.elementAt(i2);
            if (!comp.visible || comp.x + comp.width < this.viewX || comp.x > this.viewX + clipW || comp.y + comp.height < this.viewY || comp.y > this.viewY + clipH) continue;
            comp.paint(g2);
        }
        g2.translate(-x + this.viewX, -y + this.viewY);
        g2.setClip(clipX, clipY, clipW, clipH);
    }

    public void setViewWindow(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.viewX = x;
        this.viewY = y;
        this.viewWidth = width;
        this.viewHeight = height;
    }
}

