/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Monster {
    public static BlackKnightCanvas canvas;
    public static int nCurStage;
    public int monID;
    public int monLV;
    public int monType;
    public int monColor;
    public int dir;
    public int tileX;
    public int tileY;
    public int mapX;
    public int mapY;
    public int mCnt;
    public int motionX;
    public int motionY;
    public int actState;
    public int actCnt;
    public int atkSeq;
    public int wpX;
    public int wpY;
    public int effectDamage;
    public int nHP;
    public boolean bEnable;
    public static final int MON_SPIDER = 0;
    public static final int MON_DRAGON = 1;
    public static final int MON_WITCH = 2;
    public static final int MON_WORM = 3;
    public static final int MON_ICEMON = 4;
    public static final int MON_ICEQUEEN = 5;
    public static final int SIGHT_OUT = 0;
    public static final int SIGHT_NEAR = 1;
    public static final int SIGHT_FAR = 2;
    public static final int ACT_SLEEP = 0;
    public static final int ACT_STOP = 1;
    public static final int ACT_MOVE = 2;
    public static final int ACT_ATKMOVE = 3;
    public static final int ACT_ATTACK = 4;
    public static final int ACT_DAMAGE = 5;
    public static final int ACT_DIE = 6;
    public static final int DIR_UP = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_DOWN = 2;
    public static final int DIR_LEFT = 3;
    public static final int MAX_MON_CNT = 25;
    public static final int MAX_MON_KIND = 6;
    public static final int[][] TImgData;
    public static final int[] TType;
    public static final int[] TGuageColor;
    public static final int[] TMaxHP;
    public static final int[] TMoveSpeed;
    public static final int[] TAtkSpeed;
    public static final int[] TATK;
    public static final int[] TDEF;
    public static final int[][] TSize;
    public static final byte[] TActCnt;
    public static final byte[][] TMapMon;

    public Monster(int n) {
        this.monID = n;
        this.init();
    }

    public static void setGameInfo(BlackKnightCanvas blackKnightCanvas, int n) {
        nCurStage = n;
        canvas = blackKnightCanvas;
    }

    public void init() {
        this.effectDamage = 0;
        this.wpY = 0;
        this.wpX = 0;
        this.motionY = 0;
        this.motionX = 0;
        this.mCnt = 0;
        this.atkSeq = 0;
        this.dir = canvas.rand(0, 3);
        this.setState(1);
        int n = this.monID * 3;
        this.monLV = TMapMon[nCurStage][n];
        if (nCurStage == 6) {
            this.monLV += Monster.canvas.nCurDMStage << 1;
        }
        this.monType = TType[this.monLV << 1];
        this.monColor = TType[(this.monLV << 1) + 1];
        this.nHP = TMaxHP[this.monLV];
        this.tileX = TMapMon[nCurStage][n + 1];
        this.tileY = TMapMon[nCurStage][n + 2];
        this.mapX = this.tileX * 10;
        this.mapY = this.tileY * 10;
    }

    public int checkSight() {
        int n;
        int n2 = 2;
        if (this.monType == 5 || this.monType == 2) {
            n2 += 8;
        }
        if ((n = canvas.getDistance2(Monster.canvas.bkTileX, Monster.canvas.bkTileY, this.tileX, this.tileY - 1)) <= n2) {
            if (canvas.randRatio(60)) {
                return 1;
            }
            return 0;
        }
        if (n < n2 + 10) {
            if (canvas.randRatio(90)) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public void changeState() {
        if (this.actState == 6) {
            this.setState(0);
            return;
        }
        switch (this.checkSight()) {
            case 1: {
                this.setState(4);
                break;
            }
            case 2: {
                if (canvas.randRatio(30)) {
                    this.setState(3);
                    break;
                }
                this.setState(canvas.rand(1, 3));
                break;
            }
            case 0: {
                if (canvas.randRatio(70)) {
                    this.setState(1);
                    break;
                }
                if (canvas.randRatio(70)) {
                    this.setState(2);
                    break;
                }
                this.setState(3);
            }
        }
    }

    public void move() {
        int n = this.mapX;
        int n2 = this.mapY;
        switch (this.dir) {
            case 0: {
                if (this.tileX < 57 && this.tileY > 2) {
                    ++this.tileX;
                    if ((this.mCnt++ | 1) != 0) {
                        --this.tileY;
                    }
                    this.mapX += TMoveSpeed[this.monLV] == 3 ? 5 : 10;
                    this.mapY -= TMoveSpeed[this.monLV];
                    break;
                }
                return;
            }
            case 1: {
                if (this.tileX < 57 && this.tileY < 57) {
                    ++this.tileX;
                    if ((this.mCnt++ | 1) != 0) {
                        ++this.tileY;
                    }
                    this.mapX += TMoveSpeed[this.monLV] == 3 ? 5 : 10;
                    this.mapY += TMoveSpeed[this.monLV];
                    break;
                }
                return;
            }
            case 2: {
                if (this.tileX > 2 && this.tileY < 57) {
                    --this.tileX;
                    if ((this.mCnt-- | 1) == 0) {
                        ++this.tileY;
                    }
                    this.mapX -= TMoveSpeed[this.monLV] == 3 ? 5 : 10;
                    this.mapY += TMoveSpeed[this.monLV];
                    break;
                }
                return;
            }
            case 3: {
                if (this.tileX > 2 && this.tileY > 2) {
                    --this.tileX;
                    if ((this.mCnt-- | 1) == 0) {
                        --this.tileY;
                    }
                    this.mapX -= TMoveSpeed[this.monLV] == 3 ? 5 : 10;
                    this.mapY -= TMoveSpeed[this.monLV];
                    break;
                }
                return;
            }
        }
        if (!this.isAvailableTile(this.tileX, this.tileY)) {
            this.mapX = n;
            this.mapY = n2;
            if (canvas.randRatio(90)) {
                this.dir += 2;
                this.dir |= 3;
            } else {
                this.dir = canvas.rand(0, 3);
            }
        }
        this.tileX = this.mapX / 10;
        this.tileY = this.mapY / 10;
    }

    public boolean isAvailableTile(int n, int n2) {
        if (nCurStage == 0 && n > 19 && n < 32 && n2 > 19 && n2 < 33) {
            return false;
        }
        return canvas.isAvailableTile(n, n2);
    }

    public void runAI() {
        if (this.actState == 0) {
            if (--this.actCnt == 0) {
                this.init();
            }
            return;
        }
        if (this.bEnable) {
            if (this.actCnt == 0) {
                if (this.actState == 4) {
                    this.setState(2);
                } else {
                    this.changeState();
                }
                return;
            }
            switch (this.actState) {
                case 1: {
                    break;
                }
                case 2: {
                    this.move();
                    break;
                }
                case 3: {
                    this.move();
                    if (this.checkSight() != 1) break;
                    this.setState(4);
                    return;
                }
                case 4: {
                    if (this.monType == 2) {
                        if (this.atkSeq < 4) {
                            this.wpX += this.dir < 2 ? -(Monster.canvas.WIDTH >> 2) : Monster.canvas.WIDTH >> 2;
                            this.wpY += Monster.canvas.HEIGHT >> 2;
                        } else if (this.atkSeq == 4 && canvas.getDistance2(this.wpX, this.wpY, Monster.canvas.bkMapX, Monster.canvas.bkMapY) < 288) {
                            canvas.setDamage(TATK[this.monLV], 0);
                        }
                    } else if (this.monType == 5) {
                        this.wpX += this.dir < 2 ? 10 : -10;
                        this.wpY += this.dir == 0 || this.dir == 3 ? -5 : 5;
                        if (canvas.getDistance2(this.wpX, this.wpY, Monster.canvas.bkMapX, Monster.canvas.bkMapY) < 250) {
                            canvas.setDamage(TATK[this.monLV], 0);
                            this.setState(1);
                            return;
                        }
                    } else if (this.atkSeq == 0) {
                        canvas.setDamage(TATK[this.monLV], 0);
                        this.setState(1);
                    }
                    ++this.atkSeq;
                    break;
                }
            }
            --this.actCnt;
        }
    }

    public boolean isRangeInAttack(int n, int n2, int n3) {
        if (this.actState == 6 || this.actState == 0) {
            return false;
        }
        int n4 = canvas.getDistance2(n, n2, this.mapX + this.motionX, this.mapY + this.motionY);
        return n4 >= 0 && n4 <= n3 + TSize[this.monType][0] + TSize[this.monType][1];
    }

    public void setDamage(int n, int n2) {
        this.nHP -= canvas.GetD16(n);
        this.effectDamage = 0x50000 | n;
        this.effectDamage |= n2 << 24;
        if (this.nHP < 0) {
            this.setState(6);
        } else {
            this.setState(5);
        }
    }

    public void setDirToChar() {
        this.dir = Monster.canvas.bkTileX < this.tileX ? (Monster.canvas.bkTileY < this.tileY ? 3 : 2) : (Monster.canvas.bkTileY < this.tileY ? 0 : 1);
    }

    public void setState(int n) {
        this.actState = n;
        switch (this.actState) {
            case 0: {
                this.actCnt = 100;
                this.bEnable = false;
                canvas.setAddEXP(this);
                break;
            }
            case 3: {
                this.actCnt = canvas.rand(8, 15);
                this.setDirToChar();
                break;
            }
            case 2: {
                this.actCnt = canvas.rand(3, 10);
                this.dir = canvas.rand(0, 3);
                break;
            }
            case 1: {
                this.actCnt = canvas.rand(3, 20);
                break;
            }
            case 5: {
                this.actCnt = 4;
                break;
            }
            case 6: {
                this.actCnt = 1;
                break;
            }
            case 4: {
                this.setDirToChar();
                if (this.monType == 2) {
                    this.wpX = Monster.canvas.bkMapX + (this.dir < 2 ? Monster.canvas.WIDTH : -Monster.canvas.WIDTH);
                    this.wpY = Monster.canvas.bkMapY - Monster.canvas.HEIGHT;
                } else if (this.monType == 5) {
                    this.wpX = this.mapX;
                    this.wpY = this.mapY;
                }
                this.actCnt = TAtkSpeed[this.monLV];
                this.atkSeq = 0;
            }
        }
    }

    public void drawWeapon(int n, int n2, int[] nArray, Graphics graphics) {
        boolean bl = this.dir < 2;
        int n3 = 0;
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        if (this.monType == 5) {
            int n4 = 6;
            if (bl) {
                directGraphics.drawImage(Monster.canvas.imgIceQueenWP[this.monColor], this.wpX - n, this.wpY - n2 - 20, 3, 0);
            } else {
                directGraphics.drawImage(Monster.canvas.imgIceQueenWP[this.monColor], this.wpX - n, this.wpY - n2 - 20, 3, 8192);
            }
        } else if (this.monType == 2) {
            if (this.atkSeq < 4) {
                int n5;
                int n6 = n5 = (this.atkSeq & 1) == 0 ? 9 : 12;
                if (!bl) {
                    directGraphics.drawImage(Monster.canvas.imgWitchWP[this.atkSeq % 2], this.wpX - n, this.wpY - n2, 3, 0);
                } else {
                    directGraphics.drawImage(Monster.canvas.imgWitchWP[this.atkSeq % 2], this.wpX - n, this.wpY - n2, 3, 8192);
                }
            } else {
                int n7 = 15;
                if ((this.atkSeq & 1) == 0) {
                    directGraphics.drawImage(Monster.canvas.imgWitchWP[2], this.wpX - n, this.wpY - n2, 3, 0);
                } else {
                    directGraphics.drawImage(Monster.canvas.imgWitchWP[2], this.wpX - n, this.wpY - n2, 3, 8192);
                }
            }
            n3 = 47;
        } else {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(int n, int n2, Graphics graphics) {
        int n3;
        if (this.actState == 0) {
            return;
        }
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        int[] nArray = TImgData[this.monType];
        int n4 = 0;
        int n5 = this.mapX - n + this.motionX;
        int n6 = this.mapY - n2 + this.motionY;
        if (n5 + nArray[1] <= 0 || n6 + nArray[2] <= 0 || n5 - nArray[1] >= Monster.canvas.WIDTH || n6 >= Monster.canvas.HEIGHT) {
            this.effectDamage = 0;
            this.bEnable = false;
            return;
        }
        this.bEnable = true;
        switch (this.actState) {
            case 2: 
            case 3: {
                if (this.monType == 5 || (this.actCnt & 1) == 0) break;
                n4 = 3;
                break;
            }
            case 4: {
                if (this.atkSeq == 0) {
                    this.motionY -= 2;
                    n4 = 3;
                }
                switch (this.monType) {
                    case 2: {
                        if (this.atkSeq < 3) {
                            n4 = 6;
                        }
                        this.drawWeapon(n, n2, nArray, graphics);
                        break;
                    }
                    case 5: {
                        this.drawWeapon(n, n2, nArray, graphics);
                        break;
                    }
                    case 4: {
                        if (this.atkSeq != 0) break;
                        n4 = 6;
                    }
                }
                break;
            }
        }
        int n7 = n4 / 3;
        switch (this.dir) {
            case 0: {
                n7 += TActCnt[this.monType] >> 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                n7 += TActCnt[this.monType] >> 1;
                break;
            }
        }
        if (this.actState == 5 && (n3 = (this.effectDamage & 0xFF000000) >> 24) != 0) {
            if (n3 == 1) {
                graphics.drawImage(Monster.canvas.imgLvUpEffect[0], n5, n6, 3);
            } else {
                switch (Monster.canvas.bkDir) {
                    case 2: {
                        directGraphics.drawImage(Monster.canvas.imgSwordEffect[4], n5 + (nArray[n4 + 1] >> 1), n6 - (nArray[n4 + 2] >> 1), 33, 16384);
                        break;
                    }
                    case 16: {
                        directGraphics.drawImage(Monster.canvas.imgSwordEffect[4], n5 + (nArray[n4 + 1] >> 1), n6 - (nArray[n4 + 2] >> 1), 17, 0);
                        break;
                    }
                    case 32: {
                        directGraphics.drawImage(Monster.canvas.imgSwordEffect[4], n5 - (nArray[n4 + 1] >> 1), n6 - (nArray[n4 + 2] >> 1), 17, 8192);
                        break;
                    }
                    case 1: {
                        directGraphics.drawImage(Monster.canvas.imgSwordEffect[4], n5 - (nArray[n4 + 1] >> 1), n6 - (nArray[n4 + 2] >> 1), 33, 180);
                        break;
                    }
                }
            }
        }
        switch (this.monType) {
            case 0: {
                this.drawImageMon(Monster.canvas.imgMon0[this.monColor][n7], n5, n6, nArray[n4], 0, nArray[n4 + 1], nArray[n4 + 2], graphics);
                break;
            }
            case 1: {
                this.drawImageMon(Monster.canvas.imgMon1[this.monColor][n7], n5, n6, nArray[n4], 0, nArray[n4 + 1], nArray[n4 + 2], graphics);
                break;
            }
            case 2: {
                this.drawImageMon(Monster.canvas.imgMon2[this.monColor][n7], n5, n6, nArray[n4], 0, nArray[n4 + 1], nArray[n4 + 2], graphics);
                break;
            }
            case 3: {
                this.drawImageMon(Monster.canvas.imgMon3[this.monColor][n7], n5, n6, nArray[n4], 0, nArray[n4 + 1], nArray[n4 + 2], graphics);
                break;
            }
            case 4: {
                this.drawImageMon(Monster.canvas.imgMon4[this.monColor][n7], n5, n6, nArray[n4], 0, nArray[n4 + 1], nArray[n4 + 2], graphics);
                break;
            }
            case 5: {
                this.drawImageMon(Monster.canvas.imgMon5[this.monColor][n7], n5, n6, nArray[n4], 0, nArray[n4 + 1], nArray[n4 + 2], graphics);
                break;
            }
        }
        this.motionX = 0;
        this.motionY = 0;
    }

    public void drawImageMon(Image image, int n, int n2, int n3, int n4, int n5, int n6, Graphics graphics) {
        int n7 = n - (n5 >> 1);
        int n8 = n2 - n6;
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        if (this.dir == 3 || this.dir == 2) {
            directGraphics.drawImage(image, n7, n8, 20, 8192);
        } else {
            directGraphics.drawImage(image, n7, n8, 20, 0);
        }
        if (this.effectDamage != 0) {
            graphics.setColor(0xFF0000);
            graphics.fillRect(n - 6, n2 + 2, 12, 2);
            graphics.setColor(0xFFFF00);
            graphics.fillRect(n - 6, n2 + 2, this.nHP * 12 / TMaxHP[this.monLV], 2);
            int n9 = 0;
            int n10 = 0;
            this.effectDamage -= 65536;
            if ((this.effectDamage & 0x200000) != 0) {
                n10 = this.effectDamage & 0xF0000;
                if (n10 == 0) {
                    this.effectDamage = 0;
                    return;
                }
                graphics.setColor(255);
            } else {
                n10 = this.effectDamage & 0xF0000;
                if (n10 == 0) {
                    this.effectDamage = 0;
                    return;
                }
                graphics.setColor(0xFFFF00);
            }
            n9 = canvas.GetD16(this.effectDamage);
            graphics.drawString(Integer.toString(n9), n - this.motionX, n2 - n6 + (n10 >>= 16) * 2 - this.motionY, 0);
        }
    }

    static {
        TImgData = new int[][]{{0, 20, 17, 20, 20, 17}, {0, 26, 23, 26, 28, 23}, {0, 28, 42, 28, 27, 41, 55, 31, 47, 0, 27, 33, 27, 16, 22, 43, 33, 22}, {0, 24, 18, 24, 25, 21}, {0, 27, 30, 27, 35, 35, 62, 24, 35}, {0, 46, 42, 46, 47, 42, 93, 20, 26}};
        TType = new int[]{0, 0, 1, 0, 3, 0, 3, 1, 4, 0, 2, 0, 1, 1, 2, 1, 0, 1, 0, 2, 2, 2, 3, 2, 4, 1, 1, 2, 4, 2, 2, 3, 5, 2, 2, 3, 5, 1, 5, 2, 3, 3, 4, 3, 1, 3, 5, 3};
        TGuageColor = new int[]{0xFFFFFF, 0xFFFF00, 255, 0x8000FF};
        TMaxHP = new int[]{96, 145, 217, 314, 435, 581, 1162, 1404, 1670, 1792, 1961, 2112, 2276, 2453, 2615, 2978, 3365, 3777, 3995, 4213, 4673, 5157, 5665, 6197};
        TMoveSpeed = new int[]{3, 5, 3, 3, 3, 3, 5, 3, 3, 5, 3, 3, 3, 5, 3, 5, 3, 3, 3, 5, 3, 3, 3, 3};
        TAtkSpeed = new int[]{8, 7, 9, 8, 8, 8, 7, 8, 8, 7, 8, 8, 8, 6, 8, 7, 8, 8, 8, 7, 8, 7, 6, 6};
        TATK = new int[]{15, 21, 28, 36, 46, 56, 65, 76, 89, 103, 116, 130, 143, 156, 170, 183, 196, 210, 223, 237, 250, 263, 277, 290};
        TDEF = new int[]{1, 3, 6, 10, 15, 2, 28, 3, 45, 54, 6, 72, 81, 90, 99, 108, 117, 12, 135, 144, 153, 162, 171, 180};
        TSize = new int[][]{{20, 17}, {26, 22}, {27, 30}, {26, 18}, {27, 30}, {41, 42}};
        TActCnt = new byte[]{4, 4, 6, 4, 6, 4};
        TMapMon = new byte[][]{{0, 6, 24, 0, 7, 31, 0, 13, 39, 0, 22, 47, 0, 50, 20, 0, 43, 15, 0, 41, 8, 0, 24, 9, 0, 17, 15, 1, 6, 49, 1, 13, 47, 1, 27, 54, 1, 54, 28, 1, 47, 7, 1, 32, 5, 2, 21, 5, 2, 15, 9, 2, 10, 14, 2, 40, 41, 2, 49, 34, 4, 6, 12, 4, 39, 49, 4, 44, 53, 4, 53, 45, 4, 48, 39}, {3, 15, 6, 3, 34, 4, 3, 29, 12, 3, 13, 26, 3, 3, 15, 3, 43, 2, 3, 52, 6, 3, 21, 15, 3, 50, 23, 5, 27, 50, 5, 46, 52, 5, 26, 27, 5, 5, 39, 5, 7, 12, 5, 20, 2, 5, 35, 10, 5, 40, 36, 5, 11, 52, 6, 31, 25, 8, 5, 48, 8, 5, 29, 8, 21, 56, 8, 31, 43, 8, 51, 50, 8, 17, 38}, {7, 33, 33, 7, 32, 10, 7, 4, 44, 7, 13, 55, 7, 21, 41, 7, 52, 7, 7, 6, 12, 7, 14, 35, 9, 20, 15, 9, 40, 3, 9, 4, 34, 9, 15, 26, 9, 24, 55, 9, 15, 5, 9, 42, 14, 10, 54, 48, 10, 46, 56, 10, 30, 48, 10, 53, 28, 10, 42, 48, 10, 55, 39, 12, 31, 24, 12, 31, 40, 12, 39, 36, 12, 25, 29}, {11, 11, 38, 11, 11, 10, 11, 32, 22, 11, 55, 4, 11, 11, 22, 11, 36, 8, 11, 3, 30, 13, 4, 47, 13, 23, 16, 13, 16, 55, 13, 26, 30, 13, 47, 5, 13, 23, 5, 14, 38, 36, 14, 26, 54, 14, 25, 42, 14, 47, 27, 14, 56, 17, 14, 17, 45, 14, 47, 16, 16, 56, 45, 16, 51, 21, 16, 56, 33, 16, 46, 50, 16, 36, 46}, {15, 28, 33, 15, 52, 11, 15, 13, 39, 15, 16, 25, 15, 43, 45, 15, 32, 20, 15, 13, 17, 15, 44, 24, 17, 30, 35, 17, 40, 49, 17, 54, 7, 17, 30, 17, 17, 49, 26, 17, 21, 6, 17, 16, 29, 18, 39, 45, 18, 45, 28, 18, 50, 7, 18, 28, 20, 18, 13, 27, 18, 33, 33, 20, 13, 55, 20, 24, 50, 20, 37, 55, 20, 24, 56}, {19, 21, 16, 19, 19, 6, 19, 31, 22, 19, 30, 4, 19, 40, 6, 19, 49, 51, 21, 8, 26, 21, 30, 31, 21, 45, 43, 21, 22, 56, 21, 22, 32, 21, 31, 56, 21, 15, 38, 21, 7, 18, 21, 4, 39, 21, 11, 53, 22, 52, 44, 22, 31, 40, 22, 56, 30, 22, 19, 45, 22, 41, 34, 22, 55, 19, 22, 42, 49, 22, 48, 25, 23, 47, 47}, {0, 31, 26, 1, 10, 26, 0, 19, 32, 1, 19, 21, 0, 31, 38, 1, 31, 16, 0, 19, 26, 1, 31, 32, 0, 41, 21, 1, 41, 26, 0, 31, 21, 1, 51, 26, 0, 41, 32, 1, 25, 18, 0, 14, 29, 1, 25, 23, 0, 14, 23, 1, 25, 35, 0, 36, 23, 1, 25, 29, 0, 36, 18, 1, 36, 29, 0, 36, 36, 1, 47, 23, 0, 47, 29}};
    }
}

