/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashMidlet;
import com.lavastorm.astrosmash.Collidable;
import java.io.IOException;
import java.util.Stack;
import javax.microedition.lcdui.Image;

public class MunitionsFactory {
    public static final int INITIAL_BULLETS = 3;
    public static final int INITIAL_Y_VELOCITY = -5;
    public static final int INITIAL_VELOCITY_TIME = 500;
    public static final String BULLET_IMAGE = "/bullet.png";
    private Stack m_stackBullets = new Stack();
    private Image m_bulletImage;
    private int m_nNumBullets;
    private int m_nInitialYVelocity = -5;
    private long m_nInitialVelocityTime = 500L;

    public MunitionsFactory(int n, int n2, long l) {
        this.m_nNumBullets = n;
        this.m_nInitialYVelocity = n2;
        this.m_nInitialVelocityTime = l;
    }

    public boolean setup(AstrosmashMidlet astrosmashMidlet) {
        try {
            this.m_bulletImage = Image.createImage((String)BULLET_IMAGE);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
        if (!astrosmashMidlet.updateGauge(1)) {
            return false;
        }
        int n = 0;
        while (n < this.m_nNumBullets) {
            Collidable collidable = new Collidable();
            collidable.setImage(this.m_bulletImage);
            collidable.setVelocity(0, this.m_nInitialYVelocity, this.m_nInitialVelocityTime);
            this.m_stackBullets.push(collidable);
            ++n;
        }
        return true;
    }

    public MunitionsFactory(int n, long l) {
        this(3, n, l);
    }

    public Collidable getBullet() {
        Collidable collidable = null;
        if (!this.m_stackBullets.isEmpty()) {
            collidable = (Collidable)this.m_stackBullets.pop();
            collidable.setCollided(false);
        } else {
            collidable = new Collidable();
            collidable.setImage(this.m_bulletImage);
            collidable.setVelocity(0, this.m_nInitialYVelocity, this.m_nInitialVelocityTime);
        }
        return collidable;
    }

    public void putBullet(Collidable collidable) {
        this.m_stackBullets.push(collidable);
    }
}

