/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashMidlet;
import com.lavastorm.astrosmash.HiscoreFile;
import com.lavastorm.astrosmash.Language;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class HiScoreDisplay
extends Canvas
implements CommandListener {
    public static final String HISCORE_TITLE = Language.getString("HighScores");
    public static final String HISCORE_ENTRY_TITLE = Language.getString("ScoreEntryTitle");
    public static final String HISCORE_ENTRY_TEXT1_SUFFIX = Language.getString("ScoreSuffix");
    public static final String HISCORE_ENTRY_NAME_FIELD = Language.getString("ScoreEntry");
    public static final String HISCORE_ENTRY_TEXT2 = Language.getString("ScoreInstructions");
    public static final int HIGH_SCORE_MAX_NAME_LENGTH = 8;
    public static final String DONE_LABEL = Language.getString("Done");
    public static final String HIGH_SCORE_FILENAME = "highscores";
    public static final int NUM_HIGH_SCORES = 10;
    public static final String[] DEFAULT_HIGH_SCORE_NAMES = new String[]{"Stuart", "Doug", "Tim", "Kelley", "Terrie", "John", "Adam", "Ole", "Josh", "Lindsay"};
    public static final int[] DEFAULT_HIGH_SCORE_SCORES = new int[]{1550, 1500, 1400, 1200, 1000, 750, 500, 300, 100, 50};
    private Form m_highScoreEntryForm;
    private Form m_highScoreDisplayForm = new Form(HISCORE_TITLE);
    private StringItem m_text1;
    private StringItem m_text2;
    private TextField m_nameEntry;
    private Command m_cmdEnterScore;
    private Display m_display;
    private AstrosmashMidlet m_midlet;
    private HiscoreFile m_hiscoreFile = null;
    public int m_peakScore = 0;
    private Command m_command1 = null;
    private Command m_command2 = null;

    public HiscoreFile getHiscores() {
        return this.m_hiscoreFile;
    }

    public HiScoreDisplay(Display display, AstrosmashMidlet astrosmashMidlet) {
        this.m_display = display;
        this.m_midlet = astrosmashMidlet;
        if (this.m_text1 == null) {
            this.m_text1 = new StringItem("", "");
        }
        if (this.m_text2 == null) {
            this.m_text2 = new StringItem("", "");
        }
        if (this.m_nameEntry == null) {
            this.m_nameEntry = new TextField(HISCORE_ENTRY_NAME_FIELD, "", 8, 0);
        }
        if (this.m_cmdEnterScore == null) {
            this.m_cmdEnterScore = new Command(DONE_LABEL, 1, 10);
        }
        if (this.m_highScoreEntryForm == null) {
            this.m_highScoreEntryForm = new Form(HISCORE_ENTRY_TITLE);
        }
        this.m_highScoreEntryForm.append((Item)this.m_text1);
        this.m_highScoreEntryForm.append((Item)this.m_nameEntry);
        this.m_highScoreEntryForm.append((Item)this.m_text2);
        this.m_highScoreEntryForm.addCommand(this.m_cmdEnterScore);
    }

    public void readHighScores() {
        if (this.m_hiscoreFile == null) {
            this.m_hiscoreFile = new HiscoreFile(HIGH_SCORE_FILENAME, 10);
            this.m_hiscoreFile.readFile(DEFAULT_HIGH_SCORE_NAMES, DEFAULT_HIGH_SCORE_SCORES);
        }
    }

    public boolean enterHighScore(boolean bl) {
        if (this.m_hiscoreFile == null) {
            this.m_hiscoreFile = new HiscoreFile(HIGH_SCORE_FILENAME, 10);
            this.m_hiscoreFile.readFile(DEFAULT_HIGH_SCORE_NAMES, DEFAULT_HIGH_SCORE_SCORES);
        }
        if (this.m_hiscoreFile.getScorePosition(this.m_peakScore) != -1) {
            this.m_display.setCurrent((Displayable)this.m_highScoreEntryForm);
            this.m_highScoreEntryForm.setCommandListener((CommandListener)this);
            this.m_text1.setLabel(this.m_peakScore + HISCORE_ENTRY_TEXT1_SUFFIX);
            this.m_text2.setLabel(HISCORE_ENTRY_TEXT2);
            this.repaint();
            this.serviceRepaints();
            return true;
        }
        if (!bl) {
            this.displayHighScores(-1);
            return true;
        }
        return false;
    }

    public void displayHighScores(int n) {
        while (this.m_highScoreDisplayForm.size() > 0) {
            try {
                this.m_highScoreDisplayForm.delete(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n2 = 0;
        while (n2 < 10) {
            String string = this.m_hiscoreFile.getName(n2);
            while (string.length() < 9) {
                string = string + " ";
            }
            string = string + this.m_hiscoreFile.getScore(n2) + "\n";
            if (n == n2) {
                string = "=> " + string;
            }
            this.m_highScoreDisplayForm.append(string);
            ++n2;
        }
        this.m_display.setCurrent((Displayable)this.m_highScoreDisplayForm);
        this.m_highScoreDisplayForm.setCommandListener((CommandListener)this);
        this.repaint();
        this.serviceRepaints();
    }

    public void setCommands(Command command, Command command2) {
        if (this.m_command1 != null) {
            this.m_highScoreDisplayForm.removeCommand(this.m_command1);
        }
        if (this.m_command2 != null) {
            this.m_highScoreDisplayForm.removeCommand(this.m_command2);
        }
        this.m_command1 = command;
        if (this.m_command1 != null) {
            this.m_highScoreDisplayForm.addCommand(this.m_command1);
        }
        this.m_command2 = command2;
        if (this.m_command2 != null) {
            this.m_highScoreDisplayForm.addCommand(this.m_command2);
        }
    }

    public void setPeakScore(int n) {
        this.m_peakScore = n;
    }

    public void showHighScores() {
        if (this.m_hiscoreFile == null) {
            this.m_hiscoreFile = new HiscoreFile(HIGH_SCORE_FILENAME, 10);
            this.m_hiscoreFile.readFile(DEFAULT_HIGH_SCORE_NAMES, DEFAULT_HIGH_SCORE_SCORES);
        }
        this.displayHighScores(-1);
    }

    public void setHighScoreEntry(String string) {
        if (this.m_hiscoreFile == null) {
            this.m_hiscoreFile = new HiscoreFile(HIGH_SCORE_FILENAME, 10);
            this.m_hiscoreFile.readFile(DEFAULT_HIGH_SCORE_NAMES, DEFAULT_HIGH_SCORE_SCORES);
        }
        int n = this.m_hiscoreFile.addScore(string, this.m_peakScore);
        this.m_hiscoreFile.writeFile();
        this.displayHighScores(n);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_cmdEnterScore) {
            this.setHighScoreEntry(this.m_nameEntry.getString());
        } else {
            this.m_midlet.commandAction(command, displayable);
        }
    }

    protected void paint(Graphics graphics) {
    }
}

