/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashMidlet;
import com.lavastorm.astrosmash.StarManager;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BackgroundManager {
    public static final int BLACKCOLOR = 0;
    public static final int WHITECOLOR = 0xFFFFFF;
    public static final int GREENCOLOR = 65280;
    public static final String MOUNTAINIMAGE = "/mountains.png";
    private static final int MAXLIFEDISPLAY = 4;
    private static final String[] NUMBERFONT_FILENAMES = new String[]{"/no0.png", "/no1.png", "/no2.png", "/no3.png", "/no4.png", "/no5.png", "/no6.png", "/no7.png", "/no8.png", "/no9.png"};
    private static final String X_FILENAME = "/noX.png";
    private static final String GREENSHIP_FILNAME = "/ship_green.png";
    private static final String MINUS_FILENAME = "/minus.png";
    private boolean m_bRegenerateBackground = true;
    private int m_screenWidth = 0;
    private int m_screenHeight = 0;
    private StarManager m_starManager;
    private Image m_image;
    private Image m_mountain;
    private int m_nLevel = 1;
    private int m_nScore = 0;
    private int m_nLives = 0;
    private Image[] m_numberFonts;
    private Image m_xImage;
    private Image m_greenShip;
    private Image m_minusImage;
    private boolean m_bGameOverMode = false;
    private int m_nPeakScore;

    public BackgroundManager(int n, int n2, int n3, int n4, int n5) {
        this.m_screenWidth = n;
        this.m_screenHeight = n2;
        this.m_nLevel = n3;
        this.m_nScore = n4;
        this.m_nPeakScore = n4;
        this.m_nLives = n5;
    }

    public boolean setup(AstrosmashMidlet astrosmashMidlet) {
        try {
            this.m_image = Image.createImage((int)this.m_screenWidth, (int)this.m_screenHeight);
            this.m_mountain = Image.createImage((String)MOUNTAINIMAGE);
            int n = this.getGroundLevel() - this.m_mountain.getHeight() - 9;
            this.m_starManager = new StarManager(this.m_screenWidth, n, 0);
            if (!this.m_starManager.setup(astrosmashMidlet)) {
                return false;
            }
            this.m_numberFonts = new Image[NUMBERFONT_FILENAMES.length];
            int n2 = 0;
            while (n2 < this.m_numberFonts.length) {
                this.m_numberFonts[n2] = Image.createImage((String)NUMBERFONT_FILENAMES[n2]);
                ++n2;
            }
            if (!astrosmashMidlet.updateGauge(1)) {
                return false;
            }
            this.m_xImage = Image.createImage((String)X_FILENAME);
            this.m_greenShip = Image.createImage((String)GREENSHIP_FILNAME);
            this.m_minusImage = Image.createImage((String)MINUS_FILENAME);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.m_bRegenerateBackground) {
            this.regenerateBackground();
            this.m_bRegenerateBackground = false;
        }
        graphics.drawImage(this.m_image, 0, 0, 20);
    }

    public void setScore(int n) {
        this.m_bRegenerateBackground = true;
        this.m_nScore = n;
    }

    public void setLives(int n) {
        this.m_bRegenerateBackground = true;
        this.m_nLives = n;
    }

    public void setGameLevel(int n) {
        this.m_bRegenerateBackground = true;
        this.m_nLevel = n;
    }

    public int getGroundLevel() {
        int n = this.m_screenHeight - 13;
        return n;
    }

    public void setGameOverMode(boolean bl) {
        this.m_bRegenerateBackground = true;
        this.m_bGameOverMode = bl;
    }

    public void setPeakScore(int n) {
        this.m_bRegenerateBackground = true;
        this.m_nPeakScore = n;
    }

    protected void regenerateBackground() {
        Graphics graphics = this.m_image.getGraphics();
        int n = this.getGroundLevel();
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.m_screenWidth, this.m_screenHeight);
        graphics.drawImage(this.m_starManager.getStarImage(), 0, 0, 20);
        graphics.drawImage(this.m_mountain, 0, n - 9, 36);
        graphics.setColor(65280);
        graphics.fillRect(0, n, this.m_screenWidth, 3);
        graphics.drawImage(this.m_xImage, this.m_screenWidth - 3, this.m_screenHeight, 40);
        this.paintNumber(graphics, this.m_nLevel, this.m_screenWidth - 3 - this.m_xImage.getWidth(), this.m_screenHeight);
        this.drawLives(graphics, this.m_screenWidth / 2, this.m_screenHeight);
        this.paintNumber(graphics, this.m_nScore, this.m_screenWidth / 2 - 3, this.m_screenHeight);
        if (this.m_bGameOverMode) {
            Font font = graphics.getFont();
            int n2 = font.getHeight();
            graphics.setColor(0xFFFFFF);
            graphics.drawString("GAME OVER", this.m_screenWidth / 2, this.m_screenHeight / 2, 33);
            StringBuffer stringBuffer = new StringBuffer("Peak Score: ");
            graphics.drawString(stringBuffer.toString(), this.m_screenWidth / 2, this.m_screenHeight / 2 + n2, 33);
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(this.m_nPeakScore);
            graphics.drawString(stringBuffer.toString(), this.m_screenWidth / 2, this.m_screenHeight / 2 + n2 * 2, 33);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int paintNumber(Graphics var1_1, int var2_2, int var3_3, int var4_4) {
        block2: {
            var6_5 = 0;
            var7_6 = false;
            var7_6 = var2_2 < 0;
            if (0 != (var2_2 = Math.abs(var2_2))) ** GOTO lbl12
            var1_1.drawImage(this.m_numberFonts[0], var3_3, var4_4, 40);
            var6_5 = this.m_numberFonts[0].getWidth();
            break block2;
lbl-1000:
            // 1 sources

            {
                var5_7 = var2_2 % 10;
                var1_1.drawImage(this.m_numberFonts[var5_7], var3_3 - var6_5, var4_4, 40);
                var6_5 += this.m_numberFonts[var5_7].getWidth();
                var2_2 /= 10;
lbl12:
                // 2 sources

                ** while (var2_2 > 0)
            }
        }
        if (var7_6) {
            var1_1.drawImage(this.m_minusImage, var3_3 - var6_5, var4_4, 40);
            var6_5 += this.m_minusImage.getWidth();
        }
        return var6_5;
    }

    protected void drawLives(Graphics graphics, int n, int n2) {
        if (this.m_nLives > 4) {
            int n3 = n + 4 * this.m_greenShip.getWidth();
            int n4 = this.paintNumber(graphics, this.m_nLives, n3, n2);
            graphics.drawImage(this.m_greenShip, n3 - n4 - this.m_greenShip.getWidth(), n2, 36);
        } else {
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.m_nLives) {
                graphics.drawImage(this.m_greenShip, n + n5, n2, 36);
                n5 += this.m_greenShip.getWidth();
                ++n6;
            }
        }
    }
}

