/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsChipBW {
    private final int MS_PER_FRAME;
    private final int TILE_FLIPX;
    private final int TILE_FLIPY;
    private final int TILE_OBJ1;
    private final int TILE_OBJ2;
    private byte[] videoRam;
    private byte[][] videoRamBanks;
    private final int[] colors = new int[]{-1, -5592406, -11184811, -16777216};
    private int[] gbPalette = new int[12];
    boolean bgEnabled = true;
    boolean winEnabled = true;
    boolean winEnabledThisFrame = true;
    boolean spritesEnabled = true;
    boolean spritesEnabledThisFrame = true;
    boolean lcdEnabled = true;
    boolean spritePriorityEnabled = true;
    private Graphics g;
    public int timer;
    private boolean skipping = true;
    private int skipCount;
    int lastSkipCount;
    boolean frameDone = false;
    boolean bgWindowDataSelect = true;
    boolean doubledSprites = false;
    boolean hiBgTileMapAddress = false;
    boolean hiWinTileMapAddress = false;
    private int tileOffset;
    private int tileCount;
    private int colorCount;
    private DmgcpuBW cpu;
    boolean savedWindowDataSelect = false;
    private boolean windowStopped;
    private boolean winEnabledThisLine = false;
    private int windowStopLine = 144;
    private int windowStopX;
    private int windowStopY;
    private Image transparentImage;
    private Image[] tileImage;
    private boolean[] tileReadState;
    private int[] tempPix;
    public int left;
    public int top;
    private boolean screenFilled;
    private boolean scale;
    int tileWidth = 8;
    int tileHeight = 8;
    private static int[] weaveLookup = new int[256];

    public GraphicsChipBW(DmgcpuBW dmgcpuBW) {
        this.MS_PER_FRAME = 17;
        this.TILE_FLIPX = 1;
        this.TILE_FLIPY = 2;
        this.TILE_OBJ1 = 4;
        this.TILE_OBJ2 = 8;
        this.cpu = dmgcpuBW;
        this.videoRamBanks = new byte[1][8192];
        this.tileCount = 384;
        this.colorCount = 12;
        this.videoRam = this.videoRamBanks[0];
        this.tileImage = new Image[this.tileCount * this.colorCount];
        this.tileReadState = new boolean[this.tileCount];
        this.cpu.memory[4] = this.videoRam;
        this.tempPix = new int[this.tileWidth * this.tileHeight];
        this.transparentImage = Image.createRGBImage((int[])this.tempPix, (int)this.tileWidth, (int)this.tileHeight, (boolean)true);
    }

    public int unflatten(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < this.videoRamBanks.length; ++n2) {
            System.arraycopy(byArray, n, this.videoRamBanks[n2], 0, 8192);
            n += 8192;
        }
        for (n2 = 0; n2 < 12; ++n2) {
            this.gbPalette[n2] = (n2 & 3) == 0 ? 0xFFFFFF & GBCanvas.getInt(byArray, n) : 0xFF000000 | GBCanvas.getInt(byArray, n);
            n += 4;
        }
        this.bgEnabled = byArray[n++] != 0;
        this.winEnabled = byArray[n++] != 0;
        this.spritesEnabled = byArray[n++] != 0;
        this.bgWindowDataSelect = byArray[n++] != 0;
        this.doubledSprites = byArray[n++] != 0;
        this.hiBgTileMapAddress = byArray[n++] != 0;
        this.hiWinTileMapAddress = (this.cpu.registers[64] & 0x40) != 0;
        this.lcdEnabled = (this.cpu.registers[64] & 0x80) != 0;
        this.invalidateAll(0);
        this.invalidateAll(1);
        this.invalidateAll(2);
        return n;
    }

    public int flatten(byte[] byArray, int n) {
        int n2;
        for (n2 = 0; n2 < this.videoRamBanks.length; ++n2) {
            System.arraycopy(this.videoRamBanks[n2], 0, byArray, n, 8192);
            n += 8192;
        }
        for (n2 = 0; n2 < 12; ++n2) {
            GBCanvas.setInt(byArray, n, this.gbPalette[n2]);
            n += 4;
        }
        byArray[n++] = (byte)(this.bgEnabled ? 1 : 0);
        byArray[n++] = (byte)(this.winEnabled ? 1 : 0);
        byArray[n++] = (byte)(this.spritesEnabled ? 1 : 0);
        byArray[n++] = (byte)(this.bgWindowDataSelect ? 1 : 0);
        byArray[n++] = (byte)(this.doubledSprites ? 1 : 0);
        byArray[n++] = (byte)(this.hiBgTileMapAddress ? 1 : 0);
        return n;
    }

    public final void addressWrite(int n, byte by) {
        int n2;
        if (n < 6144 && this.tileReadState[n2 = (n >> 4) + this.tileOffset]) {
            int n3 = this.tileImage.length - this.tileCount + n2;
            do {
                this.tileImage[n3] = null;
            } while ((n3 -= this.tileCount) >= 0);
            this.tileReadState[n2] = false;
        }
        this.videoRam[n] = by;
    }

    public final void invalidateAll(int n) {
        int n2 = n * this.tileCount * 4;
        int n3 = (n + 1) * this.tileCount * 4;
        for (int i = n2; i < n3; ++i) {
            this.tileImage[i] = null;
        }
    }

    private final void drawSprites(int n) {
        if (!this.spritesEnabledThisFrame) {
            return;
        }
        for (int i = 0; i < 40; ++i) {
            int n2 = 0xFF & this.cpu.oam[i * 4 + 3];
            if ((n2 & 0x80) != n) continue;
            int n3 = (0xFF & this.cpu.oam[i * 4 + 1]) - 8;
            int n4 = (0xFF & this.cpu.oam[i * 4]) - 16;
            int n5 = 0xFF & this.cpu.oam[i * 4 + 2];
            if (n3 >= 160 || n4 >= 144 || n4 == -16) continue;
            if (this.doubledSprites) {
                n5 &= 0xFE;
            }
            int n6 = 0;
            n6 = (n2 & 0x10) != 0 ? (n6 |= 8) : (n6 |= 4);
            if ((n2 & 0x20) != 0) {
                n6 |= 1;
            }
            if ((n2 & 0x40) != 0) {
                n6 |= 2;
            }
            if (this.doubledSprites) {
                if ((n6 & 2) != 0) {
                    this.draw(n5 + 1, n3, n4, n6);
                    this.draw(n5, n3, n4 + 8, n6);
                    continue;
                }
                this.draw(n5, n3, n4, n6);
                this.draw(n5 + 1, n3, n4 + 8, n6);
                continue;
            }
            this.draw(n5, n3, n4, n6);
        }
    }

    public final void notifyScanline(int n) {
        if (this.skipping) {
            return;
        }
        if (n == 0) {
            this.g.setClip(this.left, this.top, 20 * this.tileWidth, 18 * this.tileHeight);
            this.g.setColor(this.gbPalette[0]);
            this.g.fillRect(this.left, this.top, 20 * this.tileWidth, 18 * this.tileHeight);
            if (this.spritePriorityEnabled) {
                this.drawSprites(128);
            }
            this.windowStopLine = 144;
            this.winEnabledThisFrame = this.winEnabled;
            this.winEnabledThisLine = this.winEnabled;
            this.screenFilled = false;
            this.windowStopped = false;
        }
        if (this.winEnabledThisLine && !this.winEnabled) {
            this.windowStopLine = n & 0xFF;
            this.winEnabledThisLine = false;
        }
        if (n == (this.cpu.registers[74] & 0xFF) + 1) {
            this.savedWindowDataSelect = this.bgWindowDataSelect;
        }
        if (!this.bgEnabled) {
            return;
        }
        if (this.winEnabledThisLine && !this.windowStopped && (this.cpu.registers[75] & 0xFF) - 7 == 0 && (this.cpu.registers[74] & 0xFF) <= n - 7) {
            int n2 = this.cpu.registers[66] & 7;
            int n3 = (n & 0xF8) - n2;
            if (n3 >= 136) {
                this.screenFilled = true;
            }
        } else if ((this.cpu.registers[66] + n & 7) == 7 || n == 144) {
            int n4 = this.cpu.registers[67] & 7;
            int n5 = this.cpu.registers[66] & 7;
            int n6 = (this.cpu.registers[67] & 0xFF) >> 3;
            int n7 = (this.cpu.registers[66] & 0xFF) >> 3;
            int n8 = this.hiBgTileMapAddress ? 7168 : 6144;
            int n9 = (n & 0xF8) - n5;
            int n10 = 160;
            int n11 = (n >> 3) + n7;
            int n12 = n6;
            int n13 = n8 + ((n11 & 0x1F) << 5);
            for (int i = -n4; i < n10; i += 8) {
                int n14 = this.bgWindowDataSelect ? this.videoRamBanks[0][n13 + (n12 & 0x1F)] & 0xFF : 256 + this.videoRamBanks[0][n13 + (n12 & 0x1F)];
                int n15 = 0;
                ++n12;
                this.draw(n14, i, n9, n15);
            }
            if (n9 >= 136) {
                this.screenFilled = true;
            }
        }
        if (n == 143 && !this.screenFilled) {
            this.notifyScanline(144);
        }
    }

    public final void vBlank() {
        this.timer += 17;
        if (this.skipping && this.g != null) {
            ++this.skipCount;
            if (this.skipCount >= MeBoy.maxFrameSkip) {
                this.skipping = false;
                int n = (int)System.currentTimeMillis() - this.timer;
                if (n > 17) {
                    this.timer += n - 17;
                }
            } else {
                this.skipping = this.timer - (int)System.currentTimeMillis() < 0;
            }
            return;
        }
        if (!this.lcdEnabled && this.g != null) {
            this.g.setClip(this.left, this.top, 20 * this.tileWidth, 18 * this.tileHeight);
            this.g.setColor(this.gbPalette[0]);
            this.g.fillRect(this.left, this.top, 20 * this.tileWidth, 18 * this.tileHeight);
        }
        this.lastSkipCount = this.skipCount;
        this.frameDone = false;
        this.cpu.screen.repaint();
        while (!this.frameDone && !this.cpu.terminate) {
            Thread.yield();
        }
        int n = (int)System.currentTimeMillis();
        this.skipping = MeBoy.maxFrameSkip == 0 ? false : this.timer - n < 0;
        try {
            while (this.timer > n + 17) {
                Thread.sleep(1L);
                n = (int)System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.skipCount = 0;
    }

    public final void draw(Graphics graphics) {
        if (this.lcdEnabled) {
            this.g = graphics;
            if (this.winEnabledThisFrame) {
                int n;
                int n2;
                int n3;
                int n4 = n3 = this.hiWinTileMapAddress ? 7168 : 6144;
                if (this.windowStopped) {
                    n2 = this.windowStopX;
                    n = this.windowStopY;
                } else {
                    n2 = (this.cpu.registers[75] & 0xFF) - 7;
                    n = this.cpu.registers[74] & 0xFF;
                }
                graphics.setColor(this.gbPalette[0]);
                int n5 = this.windowStopLine - n;
                int n6 = 160 - n2;
                graphics.fillRect((n2 * this.tileWidth >> 3) + this.left, (n * this.tileHeight >> 3) + this.top, n6 * this.tileWidth >> 3, n5 * this.tileHeight >> 3);
                int n7 = n;
                int n8 = 19 - (n >> 3);
                for (int i = 0; i < n8 && n + i * 8 < this.windowStopLine; ++i) {
                    int n9 = n2;
                    int n10 = 21 - (n2 >> 3);
                    for (int j = 0; j < n10; ++j) {
                        int n11 = n3 + i * 32 + j;
                        int n12 = this.savedWindowDataSelect ? this.videoRamBanks[0][n11] & 0xFF : 256 + this.videoRamBanks[0][n11];
                        int n13 = 0;
                        this.draw(n12, n9, n7, n13);
                        n9 += 8;
                    }
                    n7 += 8;
                }
            }
            if (!this.spritePriorityEnabled) {
                this.drawSprites(128);
            }
            this.drawSprites(0);
        }
        this.frameDone = true;
        this.spritesEnabledThisFrame = this.spritesEnabled;
    }

    private final Image updateImage(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n + this.tileCount * n2;
        boolean bl = n >= 384;
        int n8 = bl ? n - 384 << 4 : n << 4;
        int n9 = n2 & 0xFC;
        byte[] byArray = bl ? this.videoRamBanks[1] : this.videoRamBanks[0];
        int[] nArray = this.gbPalette;
        boolean bl2 = nArray[n9] >= 0;
        int n10 = 0;
        int n11 = 1;
        int n12 = 0;
        if ((n2 & 2) != 0) {
            n12 = -2 * this.tileWidth;
            n10 = this.tileWidth * (this.tileHeight - 1);
        }
        if ((n2 & 1) == 0) {
            n11 = -1;
            n10 += this.tileWidth - 1;
            n12 += this.tileWidth * 2;
        }
        if (this.tileWidth > 8) {
            n6 = this.tileWidth - 5;
            n5 = 8;
        } else {
            n6 = this.tileWidth - 1;
            n5 = 9;
        }
        if (this.tileHeight > 8) {
            n4 = this.tileHeight - 5;
            n3 = 8;
        } else {
            n4 = this.tileHeight - 1;
            n3 = 9;
        }
        int n13 = n4;
        int n14 = 0;
        for (int i = 0; i < this.tileHeight; ++i) {
            int n15 = weaveLookup[byArray[n8] & 0xFF] + (weaveLookup[byArray[n8 + 1] & 0xFF] << 1);
            if (n15 != 0) {
                bl2 = false;
            }
            int n16 = n6;
            int n17 = 0;
            int n18 = this.tileWidth;
            while (--n18 >= 0) {
                this.tempPix[n10] = nArray[n9 + (n15 & 3)];
                n10 += n11;
                n17 += n5;
                while (n17 > n16) {
                    n16 += this.tileWidth;
                    n15 >>= 2;
                }
            }
            n10 += n12;
            n14 += n3;
            while (n14 > n13) {
                n13 += this.tileHeight;
                n8 += 2;
            }
        }
        this.tileImage[n7] = bl2 ? this.transparentImage : Image.createRGBImage((int[])this.tempPix, (int)this.tileWidth, (int)this.tileHeight, (boolean)true);
        this.tileReadState[n] = true;
        return this.tileImage[n7];
    }

    private final void draw(int n, int n2, int n3, int n4) {
        int n5 = n + this.tileCount * n4;
        Image image = this.tileImage[n5];
        if (image == null) {
            image = this.updateImage(n, n4);
        }
        if (image == this.transparentImage) {
            return;
        }
        if (this.scale) {
            n3 = n3 * this.tileHeight >> 3;
            n2 = n2 * this.tileWidth >> 3;
        }
        this.g.drawImage(image, this.left + n2, this.top + n3, 20);
    }

    public void decodePalette(int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            this.gbPalette[n + i] = this.colors[n2 >> 2 * i & 3];
        }
        int n3 = n;
        this.gbPalette[n3] = this.gbPalette[n3] & 0xFFFFFF;
    }

    public final void stopWindowFromLine() {
        this.windowStopped = true;
        this.windowStopLine = this.cpu.registers[68] & 0xFF;
        this.windowStopX = (this.cpu.registers[75] & 0xFF) - 7;
        this.windowStopY = this.cpu.registers[74] & 0xFF;
    }

    public void setScale(int n, int n2) {
        int n3 = this.tileWidth;
        int n4 = this.tileHeight;
        this.tileWidth = n / 20;
        this.tileHeight = n2 / 18;
        if (MeBoy.keepProportions) {
            if (this.tileWidth < this.tileHeight) {
                this.tileHeight = this.tileWidth;
            } else {
                this.tileWidth = this.tileHeight;
            }
        }
        boolean bl = this.scale = this.tileWidth != 8 || this.tileHeight != 8;
        if (this.tileWidth != n3 || this.tileHeight != n4) {
            int n5;
            for (n5 = 0; n5 < this.tileImage.length; ++n5) {
                this.tileImage[n5] = null;
            }
            for (n5 = 0; n5 < this.tileReadState.length; ++n5) {
                this.tileReadState[n5] = false;
            }
        }
        this.tempPix = new int[this.tileWidth * this.tileHeight];
    }

    static {
        for (int i = 1; i < 256; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                weaveLookup[n] = weaveLookup[n] + ((i >> j & 1) << j * 2);
            }
        }
    }
}

