/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GBCanvas
extends Canvas
implements CommandListener {
    public MeBoy parent;
    private ICpu cpu;
    private int w;
    private int h;
    private int l;
    private int t;
    private int sw;
    private int sh;
    private int trans;
    private int ssw;
    private int ssh;
    private boolean clear = true;
    boolean showFps = false;
    private int[] previousTime = new int[8];
    private int previousTimeIx;
    private boolean fullScreen;
    private Command pause = new Command(MeBoy.literal[34], 1, 0);
    private Command resume = new Command(MeBoy.literal[35], 1, 0);
    private static int[] key = new int[]{54, 52, 50, 56, 55, 57, 35, 42};
    private String[] keyName = new String[]{MeBoy.literal[36], MeBoy.literal[37], MeBoy.literal[38], MeBoy.literal[39], MeBoy.literal[40], MeBoy.literal[41], MeBoy.literal[42], MeBoy.literal[43]};
    private int keySetCounter;
    private boolean settingKeys;
    private String cartName;
    private String suspendName;
    private Image buf;
    private Graphics bufg;
    private Thread cpuThread;

    private GBCanvas() {
        this.addCommand(this.pause);
        this.addCommand(new Command(MeBoy.literal[9], 7, 1));
        if (this.showFps) {
            this.addCommand(new Command(MeBoy.literal[44], 1, 10));
        } else {
            this.addCommand(new Command(MeBoy.literal[45], 1, 10));
        }
        this.addCommand(new Command(MeBoy.literal[46], 1, 11));
        this.addCommand(new Command(MeBoy.literal[47], 1, 16));
        this.addCommand(new Command(MeBoy.literal[48], 1, 17));
        this.addCommand(new Command(MeBoy.literal[49], 1, 2));
        this.setCommandListener(this);
        if (MeBoy.rotations != 0) {
            this.buf = Image.createImage((int)160, (int)144);
            this.bufg = this.buf.getGraphics();
        }
        this.fullScreen = MeBoy.fullScreen;
        this.setFullScreenMode(this.fullScreen);
    }

    public GBCanvas(MeBoy meBoy, String string) throws RecordStoreException {
        this();
        this.parent = meBoy;
        this.suspendName = string;
        RecordStore recordStore = RecordStore.openRecordStore((String)("s" + string), (boolean)false);
        byte[] byArray = recordStore.getRecord(1);
        recordStore.closeRecordStore();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (byArray[n] != 0) {
            stringBuffer.append((char)byArray[n]);
            ++n;
        }
        this.cartName = stringBuffer.toString();
        this.cpu = this.isColor(this.cartName) && !MeBoy.disableColor ? new DmgcpuColor(this.cartName, this, byArray, n + 1) : new DmgcpuBW(this.cartName, this, byArray, n + 1);
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    public GBCanvas(MeBoy meBoy, String string, boolean bl) {
        this();
        this.parent = meBoy;
        this.cartName = string;
        this.cpu = this.isColor(string) && !MeBoy.disableColor ? new DmgcpuColor(string, this) : new DmgcpuBW(string, this);
        if (this.cpu.hasBattery()) {
            this.loadCartRam();
        }
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isColor(String string) {
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string + 0);
            if (inputStream.skip(323L) != 323L) {
                throw new RuntimeException("failed skipping to 0x143");
            }
            int n = inputStream.read();
            if (n >= 0 && (n & 0x80) == 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public void setDimensions() {
        boolean bl;
        this.w = this.getWidth();
        this.h = this.getHeight();
        int[] nArray = new int[]{0, 5, 3, 6};
        this.trans = nArray[MeBoy.rotations];
        boolean bl2 = bl = (MeBoy.rotations & 1) != 0;
        if (MeBoy.enableScaling) {
            int n = this.showFps ? -16 : 0;
            this.cpu.setScale(bl ? this.h + n : this.w, bl ? this.w : this.h + n);
        }
        this.ssw = this.sw = 20 * this.cpu.getTileWidth();
        this.ssh = this.sh = 18 * this.cpu.getTileHeight();
        if (MeBoy.rotations != 0) {
            this.buf = Image.createImage((int)this.ssw, (int)this.ssh);
            this.bufg = this.buf.getGraphics();
        }
        if (bl) {
            this.sw = this.ssh;
            this.sh = this.ssw;
        }
        this.l = (this.w - this.sw) / 2;
        this.t = (this.h - this.sh) / 2;
        if (this.showFps) {
            this.t -= 8;
        }
        if (this.l < 0) {
            this.l = 0;
        }
        if (this.t < 0) {
            this.t = 0;
        }
        this.cpu.setTranslation(this.trans == 0 ? this.l : 0, this.trans == 0 ? this.t : 0);
    }

    public void keyReleased(int n) {
        for (int i = 0; i < 8; ++i) {
            if (n != key[i]) continue;
            this.cpu.buttonUp(i);
        }
    }

    public void keyPressed(int n) {
        if (this.settingKeys) {
            GBCanvas.key[this.keySetCounter++] = n;
            if (this.keySetCounter == 8) {
                GBCanvas.writeSettings();
                this.settingKeys = false;
            }
            this.clear = true;
            this.repaint();
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (n != key[i]) continue;
            this.cpu.buttonDown(i);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            String string = command.getLabel();
            if (string == MeBoy.literal[9]) {
                if (this.cpu.hasBattery()) {
                    this.saveCartRam();
                }
                this.parent.destroyApp(true);
                this.parent.notifyDestroyed();
            } else if (string == MeBoy.literal[49]) {
                if (this.cpu.hasBattery()) {
                    this.saveCartRam();
                }
                this.parent.unloadCart();
                Runtime.getRuntime().gc();
            } else if (string == MeBoy.literal[34]) {
                this.removeCommand(this.pause);
                this.addCommand(this.resume);
                this.cpu.terminate();
            } else if (string == MeBoy.literal[35] && !this.settingKeys) {
                this.removeCommand(this.resume);
                this.addCommand(this.pause);
                this.cpuThread = new Thread(this.cpu);
                this.cpuThread.start();
            } else if (string == MeBoy.literal[45]) {
                this.removeCommand(command);
                this.addCommand(new Command(MeBoy.literal[44], 1, 10));
                this.showFps = true;
                this.setDimensions();
            } else if (string == MeBoy.literal[44]) {
                this.removeCommand(command);
                this.addCommand(new Command(MeBoy.literal[45], 1, 10));
                this.showFps = false;
                this.setDimensions();
            } else if (string == MeBoy.literal[46] && !this.settingKeys) {
                this.settingKeys = true;
                this.keySetCounter = 0;
            } else if (string == MeBoy.literal[47] && !this.settingKeys) {
                if (!this.cpu.isTerminated()) {
                    this.cpu.terminate();
                    while (this.cpuThread.isAlive()) {
                        Thread.yield();
                    }
                    this.suspend();
                    this.cpuThread = new Thread(this.cpu);
                    this.cpuThread.start();
                } else {
                    this.suspend();
                }
            } else if (string == MeBoy.literal[48] && !this.settingKeys) {
                this.fullScreen = !this.fullScreen;
                this.setFullScreenMode(this.fullScreen);
                this.setDimensions();
            }
        }
        catch (Throwable throwable) {
            MeBoy.log(throwable.toString());
            MeBoy.showLog();
        }
        this.clear = true;
        this.repaint();
    }

    public final void redrawSmall() {
        if (this.showFps) {
            this.repaint(this.l, this.t, this.sw, this.sh + 16);
        } else {
            this.repaint(this.l, this.t, this.sw, this.sh);
        }
    }

    public final void showNotify() {
        this.clear = true;
        this.repaint();
    }

    public final void paintFps(Graphics graphics) {
        graphics.setClip(this.l, this.t + this.sh, 80, 16);
        graphics.setColor(-1);
        graphics.fillRect(this.l, this.t + this.sh, 80, 16);
        graphics.setColor(0);
        int n = (int)System.currentTimeMillis();
        int n2 = (16320 + n - this.previousTime[this.previousTimeIx]) / (n - this.previousTime[this.previousTimeIx]) >> 1;
        this.previousTime[this.previousTimeIx] = n;
        this.previousTimeIx = this.previousTimeIx + 1 & 7;
        graphics.drawString(n2 + " fps * " + (this.cpu.getLastSkipCount() + 1), this.l + 1, this.t + this.sh, 20);
    }

    public final void paint(Graphics graphics) {
        if (this.cpu == null) {
            return;
        }
        if (!this.clear) {
            if (this.showFps) {
                this.paintFps(graphics);
            }
            graphics.setClip(this.l, this.t, this.sw, this.sh);
            if (this.trans == 0) {
                this.cpu.draw(graphics);
            } else {
                this.cpu.draw(this.bufg);
                graphics.drawRegion(this.buf, 0, 0, this.ssw, this.ssh, this.trans, this.l, this.t, 20);
            }
        } else if (this.settingKeys) {
            graphics.setColor(0x446688);
            graphics.fillRect(0, 0, this.w, this.h);
            graphics.setColor(-1);
            graphics.drawString(MeBoy.literal[52], this.w / 2, this.h / 2 - 18, 65);
            graphics.drawString(MeBoy.literal[53], this.w / 2, this.h / 2, 65);
            graphics.drawString(this.keyName[this.keySetCounter], this.w / 2, this.h / 2 + 18, 65);
        } else {
            if (graphics.getClipHeight() == this.h) {
                this.clear = false;
            }
            graphics.setColor(0x666666);
            graphics.fillRect(0, 0, this.w, this.h);
            graphics.setColor(-1);
            graphics.fillRect(this.l, this.t, this.sw, this.sh);
            if (this.showFps) {
                this.paintFps(graphics);
            }
            graphics.setClip(this.l, this.t, this.sw, this.sh);
            if (this.trans == 0) {
                this.cpu.draw(graphics);
            } else {
                this.cpu.draw(this.bufg);
                graphics.drawRegion(this.buf, 0, 0, this.ssw, this.ssh, this.trans, this.l, this.t, 20);
            }
        }
    }

    public static final void setInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)n2;
    }

    public static final int getInt(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        n2 = (n2 << 8) + (byArray[n++] & 0xFF);
        n2 = (n2 << 8) + (byArray[n++] & 0xFF);
        return (n2 << 8) + (byArray[n++] & 0xFF);
    }

    public static final void writeSettings() {
        try {
            int n;
            RecordStore recordStore = RecordStore.openRecordStore((String)"set", (boolean)true);
            int n2 = 53;
            for (int i = 0; i < MeBoy.suspendIndex.length; ++i) {
                n2 += 1 + MeBoy.suspendIndex[i].length();
            }
            byte[] byArray = new byte[++n2];
            for (n = 0; n < 8; ++n) {
                GBCanvas.setInt(byArray, n * 4, key[n]);
            }
            GBCanvas.setInt(byArray, 32, MeBoy.maxFrameSkip);
            GBCanvas.setInt(byArray, 36, MeBoy.rotations);
            GBCanvas.setInt(byArray, 40, MeBoy.lazyLoadingThreshold);
            GBCanvas.setInt(byArray, 44, MeBoy.suspendCounter);
            GBCanvas.setInt(byArray, 48, MeBoy.suspendIndex.length);
            n = 52;
            for (int i = 0; i < MeBoy.suspendIndex.length; ++i) {
                String string = MeBoy.suspendIndex[i];
                byArray[n++] = (byte)string.length();
                for (int j = 0; j < string.length(); ++j) {
                    byArray[n++] = (byte)string.charAt(j);
                }
            }
            byArray[n++] = (byte)((MeBoy.enableScaling ? 1 : 0) + (MeBoy.keepProportions ? 2 : 0) + (MeBoy.fullScreen ? 4 : 0) + (MeBoy.disableColor ? 8 : 0));
            byArray[n++] = (byte)MeBoy.language;
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, n2);
            } else {
                recordStore.setRecord(1, byArray, 0, n2);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    public static final void readSettings() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"set", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                int n;
                byte[] byArray = recordStore.getRecord(1);
                for (n = 0; n < 8; ++n) {
                    GBCanvas.key[n] = GBCanvas.getInt(byArray, n * 4);
                }
                if (byArray.length >= 36) {
                    MeBoy.maxFrameSkip = GBCanvas.getInt(byArray, 32);
                }
                if (byArray.length >= 40) {
                    MeBoy.rotations = GBCanvas.getInt(byArray, 36);
                }
                if (byArray.length >= 44) {
                    MeBoy.lazyLoadingThreshold = GBCanvas.getInt(byArray, 40);
                }
                if (byArray.length >= 48) {
                    MeBoy.suspendCounter = GBCanvas.getInt(byArray, 44);
                    MeBoy.suspendIndex = new String[GBCanvas.getInt(byArray, 48)];
                    n = 52;
                    for (int i = 0; i < MeBoy.suspendIndex.length; ++i) {
                        int n2 = byArray[n++] & 0xFF;
                        MeBoy.suspendIndex[i] = new String(byArray, n, n2);
                        n += n2;
                    }
                    if (byArray.length > n) {
                        MeBoy.enableScaling = (byArray[n] & 1) != 0;
                        MeBoy.keepProportions = (byArray[n] & 2) != 0;
                        MeBoy.fullScreen = (byArray[n] & 4) != 0;
                        MeBoy.disableColor = (byArray[n] & 8) != 0;
                        MeBoy.language = (byArray[n] & 0x10) != 0 ? 1 : 0;
                        ++n;
                    }
                    if (byArray.length > n) {
                        MeBoy.language = byArray[n++];
                    }
                } else {
                    MeBoy.suspendIndex = new String[0];
                }
            } else {
                GBCanvas.writeSettings();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    private final void saveCartRam() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)this.cartName, (boolean)true);
            byte[][] byArray = this.cpu.getCartRam();
            int n = byArray.length;
            int n2 = byArray[0].length;
            int n3 = n * n2 + 13;
            byte[] byArray2 = new byte[n3];
            for (int i = 0; i < n; ++i) {
                System.arraycopy(byArray[i], 0, byArray2, i * n2, n2);
            }
            System.arraycopy(this.cpu.getRtcReg(), 0, byArray2, n * n2, 5);
            long l = System.currentTimeMillis();
            GBCanvas.setInt(byArray2, n * n2 + 5, (int)(l >> 32));
            GBCanvas.setInt(byArray2, n * n2 + 9, (int)l);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray2, 0, n3);
            } else {
                recordStore.setRecord(1, byArray2, 0, n3);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadCartRam() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)this.cartName, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[][] byArray = this.cpu.getCartRam();
                int n = byArray.length;
                int n2 = byArray[0].length;
                byte[] byArray2 = recordStore.getRecord(1);
                for (int i = 0; i < n; ++i) {
                    System.arraycopy(byArray2, i * n2, byArray[i], 0, n2);
                }
                if (byArray2.length == n * n2 + 13) {
                    System.arraycopy(byArray2, n * n2, this.cpu.getRtcReg(), 0, 5);
                    long l = GBCanvas.getInt(byArray2, n * n2 + 5);
                    l = (l << 32) + ((long)GBCanvas.getInt(byArray2, n * n2 + 9) & 0xFFFFFFFFL);
                    l = System.currentTimeMillis() - l;
                    this.cpu.rtcSkip((int)(l / 1000L));
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            MeBoy.log(exception.toString());
        }
    }

    private final void suspend() {
        try {
            boolean bl = false;
            if (this.suspendName == null) {
                this.suspendName = MeBoy.suspendCounter++ + ": " + this.cartName;
                bl = true;
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)("s" + this.suspendName), (boolean)true);
            byte[] byArray = this.cpu.flatten();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
            if (bl) {
                MeBoy.addSuspendedGame(this.suspendName);
            }
            MeBoy.log(MeBoy.literal[50] + this.suspendName);
        }
        catch (Exception exception) {
            MeBoy.log(MeBoy.literal[51] + exception);
            MeBoy.showLog();
        }
    }

    public void releaseReferences() {
        this.cpu.terminate();
        while (this.cpuThread.isAlive()) {
            Thread.yield();
        }
        this.cpu.releaseReferences();
        this.cpu = null;
        this.buf = null;
        this.bufg = null;
        this.cartName = null;
        this.pause = null;
        this.resume = null;
        this.previousTime = null;
        this.parent = null;
        System.gc();
    }
}

