/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.sa.nokiacolour;

import com.bsg.sa.nokiacolour.SharkAttackCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Shark {
    int xPos;
    int origXPos;
    int dx;
    int maxDx;
    int yPos;
    int origYPos;
    int dy;
    int maxDy;
    int move;
    int moveCounter;
    int currentMove;
    int currentFrame;
    int frameCounter;
    int width;
    int height;
    int halfWidth;
    int halfHeight;
    private Image sharkImages;
    boolean dead;

    public Shark(int n, int n2, int n3, int n4, int n5, int n6, int n7, Image image) {
        this.xPos = n;
        this.origXPos = n;
        this.yPos = n3;
        this.origYPos = n3;
        this.move = n5 * 24 >> 4;
        this.sharkImages = image;
        this.width = n6;
        this.height = n7;
        this.halfWidth = this.width / 2;
        this.halfHeight = this.height / 2;
        this.moveCounter = 0;
        this.dx = n2;
        this.maxDx = n2;
        this.dy = n4;
        this.maxDy = n4;
        if (this.dx < 0) {
            this.currentMove = 2;
        } else if (this.dx > 0) {
            this.currentMove = 3;
        }
        this.currentFrame = 0;
        this.frameCounter = 0;
        this.dead = false;
    }

    public void reset() {
        this.xPos = this.origXPos;
        this.yPos = this.origYPos;
        this.dx = this.maxDx;
        this.dy = this.maxDy;
    }

    public void move() {
        if (this.dead) {
            this.yPos -= 4;
        } else {
            ++this.moveCounter;
            if (this.moveCounter == this.move) {
                this.moveCounter = 0;
                if (this.xPos > this.origXPos) {
                    --this.dx;
                } else if (this.xPos < this.origXPos) {
                    ++this.dx;
                }
                if (this.yPos > this.origYPos) {
                    --this.dy;
                } else if (this.yPos < this.origYPos) {
                    ++this.dy;
                }
            }
            if (this.dx < 0) {
                this.currentMove = 2;
            } else if (this.dx > 0) {
                this.currentMove = 3;
            }
            this.xPos += this.dx;
            this.yPos += this.dy;
        }
        ++this.frameCounter;
        if (this.frameCounter == 3) {
            this.frameCounter = 0;
            ++this.currentFrame;
            if (this.currentFrame == SharkAttackCanvas.F_FRAMES[this.currentMove]) {
                this.currentFrame = 0;
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        graphics.setClip(n + this.xPos - this.halfWidth, n2 + this.yPos - this.halfHeight, this.width, this.height);
        graphics.drawImage(this.sharkImages, n + this.xPos - this.width * this.currentFrame - this.halfWidth, n2 + this.yPos - this.height * this.currentMove - this.halfHeight, 20);
    }
}

