/*
 * Decompiled with CFR 0.152.
 */
package pagenetsoft.game;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.IOException;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import pagenetsoft.game.Block;
import pagenetsoft.game.PNCanvas;
import pagenetsoft.game.PNMidlet;
import pagenetsoft.game.PNSound;
import pagenetsoft.game.PNStage;
import pagenetsoft.game.ShameMain;
import pagenetsoft.game.VectorBlock;

class GameShame
extends PNStage {
    private final String girl;
    private final String[] sLevel = new String[]{"/alyson/alyson_1.png", "/alyson/alyson_2.png", "/alyson/alyson_3.png", "/alyson/alyson_4.png", "/alyson/alyson_5.png"};
    private final int LEVEL_COUNT;
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;
    private boolean jump;
    private boolean isGameOver = false;
    private boolean isLevelComplite = false;
    private int scores;
    private int restLines;
    private VectorBlock listFall = new VectorBlock();
    private Stack stackFall = new Stack();
    private boolean isFall = false;
    private Vector listDown = new Vector();
    private int maskDown = 0;
    private boolean isDown = false;
    private VectorBlock listFlip = new VectorBlock();
    private boolean isFlip = false;
    private Block[][] area;
    private byte[] colorNext;
    private byte countNext = 0;
    private long timeNext = 0L;
    private int areaRows;
    private int areaCols;
    private Image[] img = null;
    private Random rand;
    private int cursorCol;
    private int cursorRow;
    private boolean cursorVisible;
    private boolean cursorSelect;
    private int BLOCK_SIZE = 11;
    private final int BLOCK_SIZE_SMALL;
    private final int BLOCK_SIZE_BIG;
    private final int BLOCK_TYPES;
    private final int IMG_BG;
    private final int IMG_BG_DARK;
    private final int IMG_BLOCKS;
    private final int IMG_CURSOR;
    private final int IMG_CURSOR_SEL;
    private int TIME_NEXT_BLOCK = 1000;
    private final int PANE_HEIGHT_BIG;
    private final int PANE_HEIGHT_SMALL;
    private int PANE_HEIGHT = 48;
    private byte mode = 0;
    private byte level = 0;
    private long stateTime;
    private byte state = 0;
    private final byte G_PREPARE;
    private final byte G_PLAY;
    private final byte G_WAITREADY = (byte)2;
    private final byte G_OVER = (byte)3;
    private final byte G_COMPLITE = (byte)4;
    private final int txtColor;
    private int backlightTime;
    PNSound sound;

    public GameShame(PNCanvas pNCanvas, byte by, byte by2) {
        super(pNCanvas);
        this.girl = "alyson";
        this.LEVEL_COUNT = 5;
        this.BLOCK_SIZE_SMALL = 11;
        this.BLOCK_SIZE_BIG = 16;
        this.BLOCK_TYPES = 4;
        this.IMG_BG = 0;
        this.IMG_BG_DARK = 1;
        this.IMG_BLOCKS = 2;
        this.IMG_CURSOR = 6;
        this.IMG_CURSOR_SEL = 7;
        this.PANE_HEIGHT_BIG = 48;
        this.PANE_HEIGHT_SMALL = 54;
        this.G_PREPARE = 0;
        this.G_PLAY = 1;
        this.txtColor = 16631041;
        this.level = by;
        this.mode = by2;
        this.setStartTime();
        this.rand = new Random();
        this.jump = false;
        this.down = false;
        this.up = false;
        this.right = false;
        this.left = false;
        this.state = 0;
        this.stateTime = 0L;
        this.scores = 0;
        this.isGameOver = false;
        this.isLevelComplite = false;
        this.sound = PNSound.SOUND;
    }

    private void setStartTime() {
        this.TIME_NEXT_BLOCK = 500 - this.level * 32;
    }

    public void reload() {
        this.state = 0;
        this.stateTime = 0L;
        this.level = ShameMain.level;
        this.mode = ShameMain.mode;
        this.setStartTime();
        this.scores = 0;
        this.isGameOver = false;
        this.isLevelComplite = false;
    }

    protected void paint(Graphics graphics) {
        switch (this.state) {
            case 0: {
                this.paintPrepare(graphics);
                break;
            }
            case 1: {
                this.paintGame(graphics);
                break;
            }
            case 2: {
                this.paintWaitReady(graphics);
                break;
            }
            case 4: {
                this.paintComplete(graphics);
                break;
            }
            case 3: {
                this.paintGameOver(graphics);
            }
        }
    }

    private void paintPrepare(Graphics graphics) {
        graphics.drawImage(ShameMain.imgBG, 0, 0, 0x10 | 4);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        this.drawShString(graphics, "Loading...", this.centerX + 1, this.centerY + 1, 17, 16631041);
    }

    private void paintGameOver(Graphics graphics) {
        this.paintGame(graphics);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        this.drawShString(graphics, "Game Over", this.centerX, this.centerY + 1, 17, 16631041);
    }

    private void paintComplete(Graphics graphics) {
        this.paintGame(graphics);
        if (this.stateTime < 2000L) {
            graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
            this.drawShString(graphics, "Complete", this.centerX + 1, this.centerY + 1, 17, 16631041);
        }
    }

    private void paintWaitReady(Graphics graphics) {
        this.paintGame(graphics);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
        this.drawShString(graphics, "Wait Ready", this.centerX, this.centerX, 17, 16631041);
    }

    private void paintGame(Graphics graphics) {
        graphics.setClip(0, 0, this.sizeX, this.sizeY - this.PANE_HEIGHT);
        this.paintBG(graphics);
        this.paintArea(graphics);
        if (this.isFall) {
            this.paintFall(graphics);
        }
        graphics.setClip(0, 0, this.sizeX, this.sizeY);
        this.paintPane(graphics);
        this.paintNext(graphics);
        this.paintCursor(graphics);
    }

    private void drawShString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        graphics.setColor(0);
        graphics.drawString(string, n + 1, n2 + 1, n3);
        graphics.setColor(n4);
        graphics.drawString(string, n, n2, n3);
    }

    private void paintBG(Graphics graphics) {
        if (this.state != 4) {
            if (this.img != null && this.img[1] != null) {
                graphics.drawImage(this.img[1], 0, 0, 0x10 | 4);
            }
            String string = "Level:" + (1 + this.level);
            graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
            this.drawShString(graphics, string, this.sizeX - 1, 1, 24, 16631041);
        } else if (this.img != null && this.img[0] != null) {
            graphics.drawImage(this.img[0], 0, 0, 0x10 | 4);
        }
    }

    private void paintPane(Graphics graphics) {
        graphics.setColor(255);
        graphics.fillRect(0, this.sizeY - this.PANE_HEIGHT, this.sizeX, this.PANE_HEIGHT);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)0));
        int n = this.sizeY - (this.PANE_HEIGHT - this.BLOCK_SIZE - 8 >> 1) - (graphics.getFont().getHeight() >> 1);
        this.drawShString(graphics, "SCORES:", 5, n, 20, 16631041);
        this.drawShString(graphics, "LINES:", this.centerX + (this.centerX >> 2), n, 20, 16631041);
        graphics.setFont(Font.getFont((int)64, (int)1, (int)0));
        String string = String.valueOf(this.scores);
        this.drawShString(graphics, string, this.centerX + 5, n, 24, 16631041);
        string = String.valueOf(this.restLines);
        this.drawShString(graphics, string, this.sizeX - 5, n, 24, 16631041);
    }

    private void paintNext(Graphics graphics) {
        graphics.setColor(0);
        int n = this.sizeY - this.PANE_HEIGHT;
        graphics.drawLine(0, n, this.sizeX, n);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(0, ++n, this.sizeX, n);
        byte by = 0;
        while (by < this.countNext) {
            graphics.drawImage(this.img[2 + this.colorNext[by]], by * this.BLOCK_SIZE, this.sizeY - this.PANE_HEIGHT + 2, 0x10 | 4);
            by = (byte)(by + 1);
        }
        graphics.drawLine(0, n += this.BLOCK_SIZE + 2, this.sizeX, n);
        graphics.setColor(0);
        graphics.drawLine(0, ++n, this.sizeX, n);
    }

    private void paintArea(Graphics graphics) {
        int n = 0;
        while (n < this.areaCols) {
            int n2 = 0;
            while (n2 < this.areaRows) {
                Block block = this.area[n2][n];
                if (block != null) {
                    graphics.drawImage(this.img[2 + block.color], block.x, block.y, 0x20 | 4);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void paintCursor(Graphics graphics) {
        if (this.cursorVisible && this.state == 1) {
            Image image = this.cursorSelect ? this.img[7] : this.img[6];
            graphics.drawImage(image, this.cursorCol * this.BLOCK_SIZE, this.sizeY - this.PANE_HEIGHT - this.cursorRow * this.BLOCK_SIZE, 0x20 | 4);
        }
    }

    protected void update(long l) {
        this.stateTime += l;
        switch (this.state) {
            case 0: {
                this.stopSound();
                this.prepareLevel();
                this.state = (byte)2;
                this.stateTime = 0L;
                break;
            }
            case 1: {
                if (this.isGameOver) {
                    this.state = (byte)3;
                    this.stateTime = 0L;
                    this.startSoundOver();
                    break;
                }
                if (this.isLevelComplite) {
                    this.isLevelComplite = false;
                    this.state = (byte)4;
                    this.stateTime = 0L;
                    this.backlightTime = 0;
                    this.explodeAll();
                    break;
                }
                this.updateGame(l);
                break;
            }
            case 2: {
                if (this.stateTime <= 1000L) break;
                this.state = 1;
                this.stateTime = 0L;
                break;
            }
            case 4: {
                this.backlightTime += (int)l;
                if (this.backlightTime > 1000) {
                    this.backlightTime = 0;
                    this.backlight();
                }
                if (this.isFall) {
                    this.updateFall((int)l);
                }
                if (this.stateTime <= 5000L) break;
                if (!this.jump) {
                    return;
                }
                this.level = (byte)(this.level + 1);
                if (this.level >= 5) {
                    this.level = (byte)(this.level - 1);
                    this.stopSound();
                    PNMidlet.MIDLET.setNewState(2);
                    break;
                }
                if (ShameMain.levelMAX < this.level) {
                    ShameMain.levelMAX = this.level;
                }
                ShameMain.level = this.level;
                this.state = 0;
                this.stateTime = 0L;
                break;
            }
            case 3: {
                if (this.stateTime <= 4000L) break;
                this.stateTime = 0L;
                this.stopSound();
                PNMidlet.MIDLET.setNewState(2);
            }
        }
    }

    protected void updateGame(long l) {
        if (this.left) {
            --this.cursorCol;
            if (this.cursorCol < 0) {
                this.cursorCol = this.areaCols - 1;
            }
            this.left = false;
        }
        if (this.right) {
            ++this.cursorCol;
            if (this.cursorCol >= this.areaCols) {
                this.cursorCol = 0;
            }
            this.right = false;
        }
        if (this.down) {
            --this.cursorRow;
            if (this.cursorRow < 0) {
                this.cursorRow = this.areaRows - 1;
            }
            this.down = false;
        }
        if (this.up) {
            ++this.cursorRow;
            if (this.cursorRow >= this.areaRows) {
                this.cursorRow = 0;
            }
            this.up = false;
        }
        if (this.cursorSelect && !this.isFall && !this.isDown && !this.isFlip) {
            this.cursorSelect = false;
        }
        if (this.jump && !this.cursorSelect) {
            this.cursorSelect = true;
            this.jump = false;
            this.explode();
        }
        if (this.cursorSelect) {
            if (this.isFall) {
                this.updateFall((int)l);
            }
            if (this.isDown) {
                this.updateDown((int)l);
            }
            if (this.isFlip) {
                this.updateFlip((int)l);
            }
        } else {
            this.updateNext((int)l);
        }
    }

    private void addLine() {
        int n = 0;
        while (n < this.areaCols) {
            if (this.area[this.areaRows - 2][n] != null) {
                this.startSoundRing();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.areaCols) {
            if (this.area[this.areaRows - 1][n2] != null) {
                this.isGameOver = true;
                return;
            }
            ++n2;
        }
        --this.restLines;
        if (this.restLines <= 0) {
            this.isLevelComplite = true;
            return;
        }
        this.TIME_NEXT_BLOCK -= 4;
        byte by = 0;
        while (by < this.areaCols) {
            byte by2 = (byte)(this.areaRows - 2);
            while (by2 >= 0) {
                this.area[by2 + 1][by] = this.area[by2][by];
                Block block = this.area[by2 + 1][by];
                if (block != null) {
                    block.row = (byte)(block.row + 1);
                    block.y -= this.BLOCK_SIZE;
                }
                by2 = (byte)(by2 - 1);
            }
            this.area[0][by] = Block.newBlock((byte)0, by, this.colorNext[by]);
            by = (byte)(by + 1);
        }
    }

    private void updateNext(int n) {
        this.timeNext += (long)n;
        if (this.timeNext > (long)this.TIME_NEXT_BLOCK) {
            this.countNext = (byte)((long)this.countNext + this.timeNext / (long)this.TIME_NEXT_BLOCK);
            this.timeNext %= (long)this.TIME_NEXT_BLOCK;
            if (this.countNext > this.areaCols) {
                this.addLine();
                this.countNext = 0;
                int n2 = 0;
                while (n2 < this.areaCols) {
                    this.colorNext[n2] = (byte)(this.rand.nextInt() % 4);
                    if (this.colorNext[n2] < 0) {
                        this.colorNext[n2] = -this.colorNext[n2];
                    }
                    ++n2;
                }
            }
        }
    }

    private void updateDown(int n) {
        boolean bl = true;
        int n2 = this.listDown.size();
        int n3 = 0;
        while (n3 < n2) {
            Block block = (Block)this.listDown.elementAt(n3);
            block.update(n);
            if (bl && block.movement) {
                bl = false;
            }
            ++n3;
        }
        if (bl) {
            this.listDown.removeAllElements();
            this.isDown = false;
            this.startFlip();
        }
    }

    private void updateFlip(int n) {
        boolean bl = true;
        int n2 = this.listFlip.size();
        int n3 = 0;
        while (n3 < n2) {
            Block block = (Block)this.listFlip.elementAt(n3);
            block.update(n);
            if (bl && block.movement) {
                bl = false;
            }
            ++n3;
        }
        if (bl) {
            this.isFlip = false;
            this.listFlip.removeAllElements();
        }
    }

    private void updateFall(int n) {
        boolean bl = true;
        int n2 = this.listFall.size();
        int n3 = 0;
        while (n3 < n2) {
            Block block = (Block)this.listFall.elementAt(n3);
            block.update(n);
            if (bl && block.movement) {
                bl = false;
            }
            ++n3;
        }
        if (bl) {
            this.isFall = false;
            this.listFall.deleteAll();
            this.stopSound();
        }
    }

    private void paintFall(Graphics graphics) {
        int n = 0;
        while (n < this.listFall.size()) {
            Block block = (Block)this.listFall.elementAt(n);
            graphics.drawImage(this.img[2 + block.color], block.x, block.y, 0x20 | 4);
            ++n;
        }
    }

    private void startSoundOver() {
        this.sound.pause();
        this.sound.resume();
        this.sound.playOver();
    }

    private void startSound() {
        this.sound.resume();
        this.sound.playExplode();
    }

    private void startSoundRing() {
        this.sound.resume();
        this.sound.playRing();
    }

    private void stopSound() {
        this.sound.pause();
    }

    private void backlight() {
        this.sound.backlight();
    }

    private void startFall() {
        this.startSound();
        int n = this.listFall.size();
        this.scores += n < 11 ? 1 << n : (1 << n) + 8 * n;
        int n2 = 0;
        while (n2 < n) {
            Block block = (Block)this.listFall.elementAt(n2);
            block.startFall(n2);
            ++n2;
        }
    }

    private void startDown() {
        this.listDown.removeAllElements();
        int n = 0;
        while (n < this.areaCols) {
            if ((this.maskDown & 1 << n) != 0) {
                byte by = 0;
                int n2 = 0;
                while (n2 < this.areaRows) {
                    Block block = this.area[n2][n];
                    if (block == null) {
                        by = (byte)(by - 1);
                    } else if (by < 0) {
                        this.area[n2][n] = null;
                        this.area[n2 + by][n] = block;
                        block.startDown(by);
                        this.listDown.addElement(block);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (this.listDown.size() > 0) {
            this.isDown = true;
        } else {
            this.startFlip();
        }
    }

    private void startFlip() {
        Block block;
        int n;
        this.listFlip.removeAllElements();
        int n2 = 1 + this.areaCols >> 1;
        byte by = 0;
        int n3 = n2;
        while (n3 < this.areaCols) {
            if (this.area[0][n3] == null) {
                by = (byte)(by - 1);
            } else if (by != 0) {
                n = 0;
                while (n < this.areaRows) {
                    if (this.area[n][n3] == null) break;
                    Block block2 = this.area[n][n3];
                    this.area[n][n3 + by] = block2;
                    block = block2;
                    this.area[n][n3] = null;
                    block.startFlip(by);
                    this.listFlip.addElement(block);
                    ++n;
                }
            }
            ++n3;
        }
        by = 0;
        n3 = n2 - 1;
        while (n3 >= 0) {
            block = this.area[0][n3];
            if (block == null) {
                by = (byte)(by + 1);
            } else if (by != 0) {
                n = 0;
                while (n < this.areaRows) {
                    if (this.area[n][n3] == null) break;
                    Block block3 = this.area[n][n3];
                    this.area[n][n3 + by] = block3;
                    block = block3;
                    this.area[n][n3] = null;
                    block.startFlip(by);
                    this.listFlip.addElement(block);
                    ++n;
                }
            }
            --n3;
        }
        if (this.listFlip.size() > 0) {
            this.isFlip = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void keyPressed(int n) {
        block30: {
            block29: {
                if (n == -6) break block29;
                if (n != -7) break block30;
            }
            PNMidlet.MIDLET.setNewState(2);
            return;
        }
        if (n == -3) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.left = true;
                return;
            }
        }
        if (n == -4) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.right = true;
                return;
            }
        }
        if (n == -1) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.up = true;
                return;
            }
        }
        if (n == -2) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.down = true;
                return;
            }
        }
        if (n == 42) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.jump = true;
                return;
            }
        }
        if (n == 35) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.jump = true;
                return;
            }
        }
        if (n != -5) return;
        GameShame gameShame = this;
        synchronized (gameShame) {
            this.jump = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyRepeated(int n) {
        if (n == -3) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.left = true;
            }
        }
        if (n == -4) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.right = true;
            }
        }
        if (n == -1) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.up = true;
            }
        }
        if (n == -2) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.down = true;
            }
        }
        if (n == 42) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.jump = true;
            }
        }
        if (n == 35) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.jump = true;
            }
        }
        if (n == -5) {
            GameShame gameShame = this;
            synchronized (gameShame) {
                this.jump = true;
            }
        }
    }

    private void freeAllMemory() {
        if (this.img != null) {
            int n = 0;
            while (n < this.img.length) {
                this.img[n] = null;
                ++n;
            }
        }
        if (this.area != null) {
            int n = 0;
            while (n < this.area.length) {
                int n2 = 0;
                while (n2 < this.area[n].length) {
                    if (this.area[n][n2] != null) {
                        this.area[n][n2].delBlock();
                    }
                    this.area[n][n2] = null;
                    ++n2;
                }
                this.area[n] = null;
                ++n;
            }
        }
        this.area = null;
        this.colorNext = null;
        this.stackFall.removeAllElements();
        this.listDown.removeAllElements();
        this.listFlip.deleteAll();
        this.listFall.deleteAll();
        System.gc();
    }

    private void prepareLevel() {
        Object[] objectArray;
        this.freeAllMemory();
        if (this.mode == 0) {
            objectArray = new String[]{this.sLevel[this.level], this.sLevel[this.level], "/bl01.png", "/bl02.png", "/bl03.png", "/bl04.png", "/cursor0.png", "/cursor_sel0.png"};
            this.BLOCK_SIZE = 16;
            this.PANE_HEIGHT = 48;
            this.img = GameShame.loadImageList(objectArray);
        } else {
            objectArray = new String[]{this.sLevel[this.level], this.sLevel[this.level], "/bl1.png", "/bl2.png", "/bl3.png", "/bl4.png", "/cursor.png", "/cursor_sel.png"};
            this.BLOCK_SIZE = 11;
            this.PANE_HEIGHT = 54;
            this.img = GameShame.loadImageList(objectArray);
        }
        objectArray = new int[]{0, this.sizeX, this.sizeX, 0};
        int[] nArray = new int[]{0, 0, this.sizeY - this.PANE_HEIGHT, this.sizeY - this.PANE_HEIGHT};
        Image image = Image.createImage((int)this.sizeX, (int)this.sizeY);
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)image.getGraphics());
        directGraphics.drawImage(this.img[0], 0, 0, 20, 0);
        directGraphics.fillPolygon((int[])objectArray, 0, nArray, 0, 4, -1895825408);
        this.img[1] = Image.createImage((Image)image);
        image = null;
        this.areaCols = this.sizeX / this.BLOCK_SIZE;
        this.areaRows = (this.sizeY - this.PANE_HEIGHT) / this.BLOCK_SIZE;
        Block.BLOCK_SIZE = this.BLOCK_SIZE;
        Block.BOTTOM_Y = this.sizeY - this.PANE_HEIGHT;
        this.area = new Block[this.areaRows][this.areaCols];
        this.colorNext = new byte[this.areaCols];
        int n = (this.areaRows >> 1) + this.level + 1;
        this.restLines = 10 + this.level * 2 + this.level / 2;
        if (this.mode == 0) {
            n -= 2;
        }
        byte by = 0;
        while (by < this.areaCols) {
            byte by2 = 0;
            byte by3 = 0;
            while (by3 < this.areaRows) {
                if (by3 < n) {
                    by2 = (byte)(this.rand.nextInt() % 4);
                    if (by2 < 0) {
                        by2 = -by2;
                    }
                    this.area[by3][by] = Block.newBlock(by3, by, by2);
                } else {
                    this.area[by3][by] = null;
                }
                by3 = (byte)(by3 + 1);
            }
            this.colorNext[by] = by2;
            by = (byte)(by + 1);
        }
        this.cursorCol = this.areaCols >> 1;
        this.cursorRow = this.areaRows >> 1;
        this.cursorVisible = true;
        this.cursorSelect = false;
    }

    public static Image[] loadImageList(String[] stringArray) {
        Image[] imageArray = new Image[stringArray.length];
        try {
            imageArray[0] = Image.createImage((String)stringArray[0]);
            int n = 1;
            while (n < imageArray.length) {
                imageArray[n] = stringArray[n].equals(stringArray[n - 1]) ? imageArray[n - 1] : Image.createImage((String)stringArray[n]);
                ++n;
            }
            return imageArray;
        }
        catch (IOException iOException) {
            return imageArray;
        }
    }

    private void explodeAll() {
        this.startSound();
        this.listFall.deleteAll();
        int n = 0;
        while (n < this.areaRows) {
            int n2 = 0;
            while (n2 < this.areaCols) {
                Block block = this.area[n][n2];
                if (block != null) {
                    this.listFall.addElement(block);
                    this.area[n][n2] = null;
                    block.startFall(n2 + n);
                }
                ++n2;
            }
            ++n;
        }
        this.isFall = true;
    }

    private void explode() {
        Block block = this.area[this.cursorRow][this.cursorCol];
        if (block != null) {
            byte by = block.color;
            this.listFall.deleteAll();
            this.stackFall.push(block);
            while (!this.stackFall.empty()) {
                block = (Block)this.stackFall.pop();
                if (this.listFall.contain(block.row, block.col)) continue;
                this.listFall.addElement(block);
                if (block.row > 0 && this.area[block.row - 1][block.col] != null && this.area[block.row - 1][block.col].color == by && !this.listFall.contain(block.row - 1, block.col)) {
                    this.stackFall.push(this.area[block.row - 1][block.col]);
                }
                if (block.col > 0 && this.area[block.row][block.col - 1] != null && this.area[block.row][block.col - 1].color == by && !this.listFall.contain(block.row, block.col - 1)) {
                    this.stackFall.push(this.area[block.row][block.col - 1]);
                }
                if (block.row < this.areaRows - 1 && this.area[block.row + 1][block.col] != null && this.area[block.row + 1][block.col].color == by && !this.listFall.contain(block.row + 1, block.col)) {
                    this.stackFall.push(this.area[block.row + 1][block.col]);
                }
                if (block.col >= this.areaCols - 1 || this.area[block.row][block.col + 1] == null || this.area[block.row][block.col + 1].color != by || this.listFall.contain(block.row, block.col + 1)) continue;
                this.stackFall.push(this.area[block.row][block.col + 1]);
            }
            if (this.listFall.size() >= 3) {
                this.maskDown = 0;
                int n = 0;
                while (n < this.listFall.size()) {
                    block = (Block)this.listFall.elementAt(n);
                    this.area[block.row][block.col] = null;
                    this.maskDown |= 1 << block.col;
                    ++n;
                }
                this.isFall = true;
                this.startFall();
                this.startDown();
                return;
            }
        }
        this.cursorSelect = false;
        this.listFall.removeAllElements();
    }
}

