/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.BoardGame;
import game.CheckersGame;

public class JumpersGame
extends CheckersGame {
    private final int SCORE_MOVE_PAWN;
    private final int SCORE_WIN;

    JumpersGame(byte[] byArray) {
        super(byArray);
        this.SCORE_MOVE_PAWN = 100;
        this.SCORE_WIN = 1000;
    }

    public void ResetField() {
        this.ClearField();
        int n = 0;
        while (n < 4) {
            this.field[0 + n * 2 + 1] = 1;
            this.field[8 + n * 2 + 0] = 1;
            this.field[48 + n * 2 + 1] = 2;
            this.field[56 + n * 2 + 0] = 2;
            ++n;
        }
    }

    public int GetInitCursorX() {
        return 1;
    }

    public int GetInitCursorY() {
        return 0;
    }

    protected boolean CanJump(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        byte by = byArray[n2 * 8 + n];
        if (by != 0 && BoardGame.IsWhite(by) == bl) {
            int n3 = -2;
            while (n3 <= 2) {
                int n4;
                boolean bl3;
                boolean bl4 = bl3 = n3 > 0;
                if (bl3 == bl && (n4 = n2 + n3) >= 0 && n4 <= 7) {
                    int n5 = 0;
                    while (n5 < 2) {
                        byte by2;
                        byte by3;
                        int n6 = n5 == 0 ? -2 : 2;
                        int n7 = n + n6;
                        if (n7 >= 0 && n7 <= 7 && (by3 = byArray[n4 * 8 + n7]) == 0 && (by2 = byArray[(n2 + n3 / 2) * 8 + (n + n6 / 2)]) != 0) {
                            if (bl2) {
                                if (BoardGame.IsWhite(by2) != bl) {
                                    return true;
                                }
                            } else {
                                return true;
                            }
                        }
                        ++n5;
                    }
                }
                n3 += 4;
            }
        }
        return false;
    }

    protected BoardGame.MoveResult MakeOrTestMove(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        BoardGame.MoveResult moveResult = new BoardGame.MoveResult();
        moveResult.valid = false;
        moveResult.continuous = false;
        if (((n3 ^ n4) & 1) != 1) {
            moveResult.err = "Play on white cells!";
            return moveResult;
        }
        if (this.field[n4 * 8 + n3] != 0) {
            moveResult.err = "Dest must be free!";
            return moveResult;
        }
        byte by = this.field[n2 * 8 + n];
        if (BoardGame.IsWhite(by) != bl) {
            moveResult.err = "Move with white!";
            return moveResult;
        }
        boolean bl3 = this.CanAnyJump(this.field, bl, true);
        boolean bl4 = false;
        int n5 = n3 - n;
        int n6 = n4 - n2;
        switch (n6) {
            case -1: {
                if (bl) {
                    moveResult.err = "Pawns move forward!";
                    return moveResult;
                }
                if (n5 != 1 && n5 != -1) {
                    moveResult.err = "Move diagonally!";
                    return moveResult;
                }
                if (!bl3) break;
                moveResult.err = "You must jump!";
                return moveResult;
            }
            case 1: {
                if (!bl) {
                    moveResult.err = "Pawns move forward!";
                    return moveResult;
                }
                if (n5 != 1 && n5 != -1) {
                    moveResult.err = "Move diagonally!";
                    return moveResult;
                }
                if (!bl3) break;
                moveResult.err = "You must jump!";
                return moveResult;
            }
            case -2: 
            case 2: {
                boolean bl5;
                boolean bl6 = bl5 = n6 > 0;
                if (bl5 != bl) {
                    moveResult.err = "Pawns move forward!";
                    return moveResult;
                }
                if (n5 != 2 && n5 != -2) {
                    moveResult.err = "Move diagonally!";
                    return moveResult;
                }
                int n7 = n2 + n6 / 2;
                int n8 = n + n5 / 2;
                byte by2 = this.field[n7 * 8 + n8];
                if (by2 == 0) {
                    moveResult.err = "Move to adjacent cell!";
                    return moveResult;
                }
                bl4 = true;
                break;
            }
            default: {
                moveResult.err = "Move to adjacent cell!";
                return moveResult;
            }
        }
        if (!bl2) {
            this.field[n4 * 8 + n3] = by;
            this.field[n2 * 8 + n] = 0;
            if (bl3 || bl4) {
                moveResult.continuous = this.CanJump(this.field, n3, n4, bl, false);
            }
        }
        moveResult.valid = true;
        return moveResult;
    }

    public BoardGame.MoveResult IsValidSource(int n, int n2, boolean bl) {
        BoardGame.MoveResult moveResult = new BoardGame.MoveResult();
        moveResult.valid = false;
        byte by = this.field[n2 * 8 + n];
        if (by == 0) {
            moveResult.err = "This field is empty!";
        } else if (BoardGame.IsWhite(by) != bl) {
            moveResult.err = "Move with " + (bl ? "white" : "black") + "!";
        } else if (this.CanAnyJump(this.field, bl, true)) {
            if (!this.CanJump(this.field, n, n2, bl, true)) {
                moveResult.err = "You must jump!";
            } else {
                moveResult.valid = true;
            }
        } else {
            int n3 = -2;
            while (n3 <= 2) {
                if (n3 != 0) {
                    int n4;
                    boolean bl2;
                    boolean bl3 = bl2 = n3 > 0;
                    if (bl2 == bl && (n4 = n2 + n3) >= 0 && n4 <= 7) {
                        int n5 = Math.abs(n3);
                        int n6 = 0;
                        while (n6 < 2) {
                            byte by2;
                            byte by3;
                            int n7 = n6 == 0 ? -n5 : n5;
                            int n8 = n + n7;
                            if (n8 >= 0 && n8 <= 7 && (by3 = this.field[n4 * 8 + n8]) == 0 && (n5 != 2 || (by2 = this.field[(n2 + n3 / 2) * 8 + n + n7 / 2]) != 0)) {
                                moveResult.valid = true;
                            }
                            ++n6;
                        }
                        if (moveResult.valid) break;
                    }
                }
                ++n3;
            }
            if (!moveResult.valid) {
                moveResult.err = "No valid move!";
            }
        }
        return moveResult;
    }

    private void GetFigureScore(byte[] byArray, boolean bl, int n, int n2, int n3) {
        BoardGame.C_best_step c_best_step = this.step_data[n3];
        boolean bl2 = this.CanAnyJump(byArray, bl, false);
        int n4 = bl ? 2 : -2;
        int n5 = -n4;
        if (!bl2) {
            n5 /= 2;
        }
        while (n4 != 0) {
            int n6 = n2 + n4;
            if (n6 >= 0 && n6 <= 7) {
                int n7 = Math.abs(n4);
                int n8 = 0;
                while (n8 < 2) {
                    byte by;
                    int n9 = n8 == 0 ? -n7 : n7;
                    int n10 = n + n9;
                    if (n10 >= 0 && n10 <= 7 && (by = byArray[n6 * 8 + n10]) == 0) {
                        byte by2 = 0;
                        if (n7 != 2 || (by2 = byArray[(n2 + n4 / 2) * 8 + (n + n9 / 2)]) != 0) {
                            int n11;
                            BoardGame.C_best_step c_best_step2 = null;
                            int n12 = n11 = 100 * n7;
                            boolean bl3 = false;
                            if (bl ? n6 >= 5 : n6 <= 2) {
                                byArray[n6 * 8 + n10] = byArray[n2 * 8 + n];
                                bl3 = JumpersGame.IsWinner(byArray, bl);
                                byArray[n6 * 8 + n10] = 0;
                            }
                            if (bl3) {
                                n12 += 1000;
                            } else if (n3 != 0) {
                                BoardGame.C_best_step c_best_step3;
                                byArray[n6 * 8 + n10] = byArray[n2 * 8 + n];
                                byArray[n2 * 8 + n] = 0;
                                this.step_data[n3 - 1].Reset();
                                if (n7 == 2 && this.CanJump(byArray, n10, n6, bl, false)) {
                                    this.GetFigureScore(byArray, bl, n10, n6, n3 - 1);
                                    c_best_step3 = this.step_data[n3 - 1];
                                    if (!c_best_step3.IsValid()) {
                                        n12 -= 300;
                                    } else {
                                        n12 += c_best_step3.score;
                                        c_best_step2 = new BoardGame.C_best_step(c_best_step3);
                                    }
                                } else {
                                    c_best_step3 = this.GetBestStep(byArray, !bl, n3 - 1, false, false);
                                    n12 = c_best_step3.score == -10000 ? (n12 += 300) : (n12 -= c_best_step3.score);
                                }
                                byArray[n2 * 8 + n] = byArray[n6 * 8 + n10];
                                byArray[n6 * 8 + n10] = 0;
                            }
                            if (n12 == n11) {
                                n12 += this.rnd.nextInt() & 7;
                            }
                            if (c_best_step.score < n12) {
                                c_best_step.score = n12;
                                c_best_step.sx = n;
                                c_best_step.sy = n2;
                                c_best_step.dx = n10;
                                c_best_step.dy = n6;
                                c_best_step.cont_step = c_best_step2;
                            }
                        }
                    }
                    ++n8;
                }
            }
            n4 += n5;
        }
    }

    protected BoardGame.C_best_step GetBestStep(byte[] byArray, boolean bl, int n, boolean bl2, boolean bl3) {
        BoardGame.C_best_step c_best_step = this.step_data[n];
        c_best_step.Reset();
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 1 - (n2 & 1);
            while (n3 < 8) {
                byte by = byArray[n2 * 8 + n3];
                if (by != 0 && BoardGame.IsWhite(by) == bl) {
                    this.GetFigureScore(byArray, bl, n3, n2, n);
                }
                n3 += 2;
            }
            ++n2;
        }
        return c_best_step;
    }

    private static boolean IsWinner(byte[] byArray, boolean bl) {
        if (bl) {
            return byArray[56] == 1 && byArray[58] == 1 && byArray[60] == 1 && byArray[62] == 1 && byArray[49] == 1 && byArray[51] == 1 && byArray[53] == 1 && byArray[55] == 1;
        }
        return byArray[1] == 2 && byArray[3] == 2 && byArray[5] == 2 && byArray[7] == 2 && byArray[8] == 2 && byArray[10] == 2 && byArray[12] == 2 && byArray[14] == 2;
    }

    public int GetGameStatus(boolean bl) {
        if (JumpersGame.IsWinner(this.field, true)) {
            return 0;
        }
        if (JumpersGame.IsWinner(this.field, false)) {
            return 1;
        }
        this.GetBestStep(this.field, bl, 0, false, true);
        if (!this.step_data[0].IsValid()) {
            return bl ? 1 : 0;
        }
        return -1;
    }
}

