/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.BoardGame;
import java.util.Random;

public class CheckersGame
extends BoardGame {
    protected static final int SCORE_MOVE_PAWN = 40;
    protected static final int SCORE_MOVE_QUEEN = 10;
    protected static final int SCORE_RANDOM_MASK = 7;
    protected static final int SCORE_LEAVE_FRONT_ROW = -20;
    protected static final int SCORE_KEEP_X_BORDER = 10;
    protected static final int SCORE_JUMP_PAWN = 100;
    protected static final int SCORE_JUMP_QUEEN = 200;
    protected static final int SCORE_QUEEN_PROMOTE = 60;
    protected static final int SCORE_OPPONENT_DEAD = 300;
    protected Random rnd = new Random();
    protected BoardGame.C_best_step[] step_data = new BoardGame.C_best_step[10];
    protected static final String err_play_on_white = "Play on white cells!";
    protected static final String err_dst_must_be_free = "Dest must be free!";
    protected static final String err_forward = "Pawns move forward!";
    protected static final String err_diagonal = "Move diagonally!";
    protected static final String err_jump = "You must jump!";
    protected static final String err_white = "Move with white!";
    protected static final String err_adjacent = "Move to adjacent cell!";

    protected static void Debug(String string) {
        System.out.println("* " + string);
    }

    public CheckersGame(byte[] byArray) {
        super(byArray);
        int n = 0;
        while (n < 10) {
            this.step_data[n] = new BoardGame.C_best_step();
            ++n;
        }
        this.rnd.setSeed(System.currentTimeMillis());
    }

    public void ResetField() {
        this.ClearField();
        int n = 0;
        while (n < 4) {
            this.field[0 + n * 2 + 1] = 1;
            this.field[8 + n * 2 + 0] = 1;
            this.field[48 + n * 2 + 1] = 2;
            this.field[56 + n * 2 + 0] = 2;
            this.field[16 + n * 2 + 1] = 1;
            this.field[40 + n * 2 + 0] = 2;
            ++n;
        }
    }

    public int GetInitCursorX() {
        return 1;
    }

    public int GetInitCursorY() {
        return 2;
    }

    protected boolean CanJump(byte[] byArray, int n, int n2, boolean n3, boolean bl) {
        block7: {
            byte by = byArray[n2 * 8 + n];
            if (by == 0 || BoardGame.IsWhite(by) != n3) break block7;
            boolean bl2 = BoardGame.IsQueen(by);
            int n4 = -2;
            while (n4 <= 2) {
                block9: {
                    int n5;
                    block8: {
                        if (bl2) break block8;
                        int n6 = n5 = n4 > 0 ? 1 : 0;
                        if (n5 != n3) break block9;
                    }
                    if ((n5 = n2 + n4) >= 0 && n5 <= 7) {
                        int n7 = 0;
                        while (n7 < 2) {
                            byte by2;
                            byte by3;
                            int n8 = n7 == 0 ? -2 : 2;
                            int n9 = n + n8;
                            if (n9 >= 0 && n9 <= 7 && (by3 = byArray[n5 * 8 + n9]) == 0 && (by2 = byArray[(n2 + n4 / 2) * 8 + (n + n8 / 2)]) != 0 && BoardGame.IsWhite(by2) != n3) {
                                return true;
                            }
                            ++n7;
                        }
                    }
                }
                n4 += 4;
            }
        }
        return false;
    }

    protected boolean CanAnyJump(byte[] byArray, boolean bl, boolean bl2) {
        int n = 0;
        while (n < 8) {
            int n2 = 1 - (n & 1);
            while (n2 < 8) {
                if (this.CanJump(byArray, n2, n, bl, bl2)) {
                    return true;
                }
                n2 += 2;
            }
            ++n;
        }
        return false;
    }

    protected BoardGame.MoveResult MakeOrTestMove(int n, int n2, int n3, int n4, boolean n5, boolean bl) {
        BoardGame.MoveResult moveResult = new BoardGame.MoveResult();
        moveResult.valid = false;
        moveResult.continuous = false;
        if (((n3 ^ n4) & 1) != 1) {
            moveResult.err = err_play_on_white;
            return moveResult;
        }
        if (this.field[n4 * 8 + n3] != 0) {
            moveResult.err = err_dst_must_be_free;
            return moveResult;
        }
        int n6 = this.field[n2 * 8 + n];
        if (BoardGame.IsWhite((byte)n6) != n5) {
            moveResult.err = err_white;
            return moveResult;
        }
        boolean bl2 = this.CanAnyJump(this.field, n5 != 0, true);
        int n7 = n3 - n;
        int n8 = n4 - n2;
        switch (n8) {
            case -1: {
                if (!BoardGame.IsQueen((byte)n6) && n5 != 0) {
                    moveResult.err = err_forward;
                    return moveResult;
                }
                if (n7 != 1 && n7 != -1) {
                    moveResult.err = err_diagonal;
                    return moveResult;
                }
                if (!bl2) break;
                moveResult.err = err_jump;
                return moveResult;
            }
            case 1: {
                if (!BoardGame.IsQueen((byte)n6) && n5 == 0) {
                    moveResult.err = err_forward;
                    return moveResult;
                }
                if (n7 != 1 && n7 != -1) {
                    moveResult.err = err_diagonal;
                    return moveResult;
                }
                if (!bl2) break;
                moveResult.err = err_jump;
                return moveResult;
            }
            case -2: 
            case 2: {
                int n9;
                if (!BoardGame.IsQueen((byte)n6)) {
                    int n10 = n9 = n8 > 0 ? 1 : 0;
                    if (n9 != n5) {
                        moveResult.err = err_forward;
                        return moveResult;
                    }
                }
                if (n7 != 2 && n7 != -2) {
                    moveResult.err = err_diagonal;
                    return moveResult;
                }
                int n11 = n2 + n8 / 2;
                n9 = n + n7 / 2;
                byte by = this.field[n11 * 8 + n9];
                if (by == 0 || BoardGame.IsWhite(by) == n5) {
                    moveResult.err = err_adjacent;
                    return moveResult;
                }
                if (bl) break;
                this.field[n11 * 8 + n9] = 0;
                break;
            }
            default: {
                moveResult.err = err_adjacent;
                return moveResult;
            }
        }
        if (!bl) {
            if (!(BoardGame.IsQueen((byte)n6) || n4 != 0 && n4 != 7)) {
                n6 = BoardGame.IsWhite((byte)n6) ? 3 : 4;
            }
            this.field[n4 * 8 + n3] = n6;
            this.field[n2 * 8 + n] = 0;
            if (bl2) {
                moveResult.continuous = this.CanJump(this.field, n3, n4, n5 != 0, false);
            }
        }
        moveResult.valid = true;
        return moveResult;
    }

    public BoardGame.MoveResult MakeMove(int n, int n2, int n3, int n4, boolean bl) {
        return this.MakeOrTestMove(n, n2, n3, n4, bl, false);
    }

    public BoardGame.MoveResult TestMove(int n, int n2, int n3, int n4, boolean bl) {
        return this.MakeOrTestMove(n, n2, n3, n4, bl, true);
    }

    public int GetGameStatus(boolean bl) {
        this.GetBestStep(this.field, false, 0, false, true);
        if (!this.step_data[0].IsValid()) {
            return 0;
        }
        this.GetBestStep(this.field, true, 0, false, true);
        if (!this.step_data[0].IsValid()) {
            return 1;
        }
        return -1;
    }

    protected BoardGame.C_best_step GetBestStep(byte[] byArray, boolean n, int n2, boolean bl, boolean bl2) {
        BoardGame.C_best_step c_best_step = this.step_data[n2];
        c_best_step.Reset();
        boolean bl3 = this.CanAnyJump(byArray, n != 0, false);
        int n3 = 0;
        while (n3 < 8) {
            int n4 = 1 - (n3 & 1);
            while (n4 < 8) {
                block28: {
                    int n5 = byArray[n3 * 8 + n4];
                    if (n5 == 0 || BoardGame.IsWhite((byte)n5) != n) break block28;
                    boolean bl4 = BoardGame.IsQueen((byte)n5);
                    int n6 = bl3 ? 4 : 1;
                    int n7 = -2;
                    while (n7 <= 2) {
                        block29: {
                            int n8;
                            block30: {
                                if (n7 == 0) break block29;
                                if (bl4) break block30;
                                int n9 = n8 = n7 > 0 ? 1 : 0;
                                if (n8 != n) break block29;
                            }
                            if ((n8 = n3 + n7) >= 0 && n8 <= 7) {
                                int n10 = Math.abs(n7);
                                int n11 = 0;
                                while (n11 < 2) {
                                    byte by;
                                    int n12 = n11 == 0 ? -n10 : n10;
                                    int n13 = n4 + n12;
                                    if (n13 >= 0 && n13 <= 7 && (by = byArray[n8 * 8 + n13]) == 0) {
                                        byte by2 = 0;
                                        if (n10 != 2 || (by2 = byArray[(n3 + n7 / 2) * 8 + (n4 + n12 / 2)]) != 0 && BoardGame.IsWhite(by2) != n) {
                                            int n14;
                                            BoardGame.C_best_step c_best_step2 = null;
                                            int n15 = n14 = bl4 ? 10 : 40;
                                            if (!bl4) {
                                                if (n8 == 0 || n8 == 7) {
                                                    n15 += 60;
                                                }
                                                if (n3 == 0 || n3 == 7) {
                                                    n15 -= 20;
                                                }
                                                if (n13 == 0 || n13 == 7) {
                                                    n15 += 10;
                                                }
                                            }
                                            if (by2 != 0) {
                                                n15 += BoardGame.IsQueen(by2) ? 200 : 100;
                                            }
                                            if (n2 != 0 || bl) {
                                                int n16 = n5;
                                                if (!(bl4 || n8 != 0 && n8 != 7)) {
                                                    n16 = n != 0 ? 3 : 4;
                                                }
                                                byArray[n8 * 8 + n13] = n16;
                                                byArray[n3 * 8 + n4] = 0;
                                                if (by2 != 0) {
                                                    byArray[(n3 + n7 / 2) * 8 + (n4 + n12 / 2)] = 0;
                                                }
                                                if (n2 != 0) {
                                                    if (by2 != 0 && this.CanJump(byArray, n13, n8, n != 0, false)) {
                                                        BoardGame.C_best_step c_best_step3 = this.GetBestStep(byArray, n != 0, n2 - 1, bl, false);
                                                        if (!c_best_step3.IsValid()) {
                                                            n15 -= 300;
                                                        } else {
                                                            n15 += c_best_step3.score;
                                                            c_best_step2 = new BoardGame.C_best_step(c_best_step3);
                                                        }
                                                    } else {
                                                        BoardGame.C_best_step c_best_step4 = this.GetBestStep(byArray, n == 0, n2 - 1, bl, false);
                                                        n15 = c_best_step4.score == -10000 ? (n15 += 300) : (n15 -= c_best_step4.score);
                                                    }
                                                }
                                                byArray[n8 * 8 + n13] = 0;
                                                byArray[n3 * 8 + n4] = n5;
                                                if (by2 != 0) {
                                                    byArray[(n3 + n7 / 2) * 8 + (n4 + n12 / 2)] = by2;
                                                }
                                            }
                                            if (n15 == n14) {
                                                n15 += this.rnd.nextInt() & 7;
                                            }
                                            if (bl) {
                                                String string = "";
                                                int n17 = n2;
                                                while (n17 < 9) {
                                                    string = string + "  ";
                                                    ++n17;
                                                }
                                                BoardGame.DebugMove(string, byArray, n4, n3, n13, n8, "" + n15);
                                            }
                                            if (c_best_step.score < n15) {
                                                c_best_step.score = n15;
                                                c_best_step.sx = n4;
                                                c_best_step.sy = n3;
                                                c_best_step.dx = n13;
                                                c_best_step.dy = n8;
                                                c_best_step.cont_step = c_best_step2;
                                            }
                                        }
                                    }
                                    ++n11;
                                }
                            }
                        }
                        n7 += n6;
                    }
                }
                n4 += 2;
            }
            ++n3;
        }
        return c_best_step;
    }

    public BoardGame.C_best_step MakeAIMove() {
        int n;
        boolean bl = false;
        byte[] byArray = new byte[64];
        System.arraycopy(this.field, 0, byArray, 0, 64);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 8) {
            n = 1 - (n5 & 1);
            while (n < 8) {
                byte by = this.field[n5 * 8 + n];
                switch (by) {
                    case 1: {
                        n3 += 2;
                        break;
                    }
                    case 3: {
                        n3 += 4;
                        break;
                    }
                    case 2: {
                        n4 += 2;
                        break;
                    }
                    case 4: {
                        n4 += 4;
                    }
                }
                n += 2;
            }
            ++n5;
        }
        n = n4;
        while (n < 50000 && n2 < 9) {
            n *= (++n2 & 1) == 1 ? n3 : n4;
        }
        if (bl) {
            System.out.println("nest count: " + n2);
        }
        this.GetBestStep(byArray, false, n2, bl, true);
        BoardGame.C_best_step c_best_step = this.step_data[n2];
        if (bl && c_best_step.IsValid()) {
            BoardGame.DebugMove("--- Moving: ", this.field, c_best_step.sx, c_best_step.sy, c_best_step.dx, c_best_step.dy, "(score: " + c_best_step.score + ") ---");
        }
        return c_best_step;
    }

    public BoardGame.MoveResult IsValidSource(int n, int n2, boolean n3) {
        BoardGame.MoveResult moveResult;
        block11: {
            byte by;
            block13: {
                block12: {
                    block10: {
                        moveResult = new BoardGame.MoveResult();
                        moveResult.valid = false;
                        by = this.field[n2 * 8 + n];
                        if (by != 0) break block10;
                        moveResult.err = "This field is empty!";
                        break block11;
                    }
                    if (BoardGame.IsWhite(by) == n3) break block12;
                    moveResult.err = "Move with " + (n3 != 0 ? "white" : "black") + "!";
                    break block11;
                }
                if (!this.CanAnyJump(this.field, n3 != 0, true)) break block13;
                if (!this.CanJump(this.field, n, n2, n3 != 0, false)) {
                    moveResult.err = err_jump;
                } else {
                    moveResult.valid = true;
                }
                break block11;
            }
            boolean bl = BoardGame.IsQueen(by);
            int n4 = -1;
            while (n4 <= 1) {
                block14: {
                    int n5;
                    block15: {
                        if (n4 == 0) break block14;
                        if (bl) break block15;
                        int n6 = n5 = n4 > 0 ? 1 : 0;
                        if (n5 != n3) break block14;
                    }
                    if ((n5 = n2 + n4) >= 0 && n5 <= 7) {
                        int n7 = Math.abs(n4);
                        int n8 = 0;
                        while (n8 < 2) {
                            byte by2;
                            int n9 = n8 == 0 ? -n7 : n7;
                            int n10 = n + n9;
                            if (n10 >= 0 && n10 <= 7 && (by2 = this.field[n5 * 8 + n10]) == 0) {
                                moveResult.valid = true;
                            }
                            ++n8;
                        }
                        if (moveResult.valid) break;
                    }
                }
                ++n4;
            }
            if (!moveResult.valid) {
                moveResult.err = "No valid move!";
            }
        }
        return moveResult;
    }
}

