/*
 * Decompiled with CFR 0.152.
 */
package game;

public abstract class BoardGame {
    protected byte[] field;
    protected static final int AI_MAX_NUM_ITERS = 50000;
    protected static final int AI_MAX_NUM_NESTING = 9;
    protected static final int INVALID_SCORE = -10000;
    public static final byte EMPTY = 0;
    public static final byte WHITE_PAWN = 1;
    public static final byte BLACK_PAWN = 2;
    public static final byte WHITE_QUEEN = 3;
    public static final byte BLACK_QUEEN = 4;

    protected static void DebugMove(String string, byte[] byArray, int n, int n2, int n3, int n4, String string2) {
        byte by = byArray[8 * n2 + n];
        System.out.println("* " + string + (BoardGame.IsWhite(by) ? "W" : "B") + (BoardGame.IsQueen(by) ? "Q" : "p") + ": " + (char)(97 + n) + (n2 + 1) + "-" + (char)(97 + n3) + (n4 + 1) + ": " + string2);
    }

    protected static boolean IsQueen(byte by) {
        return by == 3 || by == 4;
    }

    protected static boolean IsWhite(byte by) {
        return by == 3 || by == 1;
    }

    protected int NumFigures(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 1 - (n2 & 1);
            while (n3 < 8) {
                switch (this.field[n2 * 8 + n3]) {
                    case 1: 
                    case 3: {
                        if (!bl) break;
                        ++n;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (bl) break;
                        ++n;
                    }
                }
                n3 += 2;
            }
            ++n2;
        }
        return n;
    }

    protected BoardGame(byte[] byArray) {
        this.field = byArray;
    }

    protected void ClearField() {
        int n = 0;
        while (n < 64) {
            this.field[n] = 0;
            ++n;
        }
    }

    public abstract void ResetField();

    public int GetInitCursorX() {
        return 0;
    }

    public int GetInitCursorY() {
        return 0;
    }

    public abstract MoveResult MakeMove(int var1, int var2, int var3, int var4, boolean var5);

    public abstract MoveResult TestMove(int var1, int var2, int var3, int var4, boolean var5);

    public abstract int GetGameStatus(boolean var1);

    protected abstract C_best_step GetBestStep(byte[] var1, boolean var2, int var3, boolean var4, boolean var5);

    public C_best_step MakeAIMove() {
        int n;
        byte[] byArray = new byte[64];
        System.arraycopy(this.field, 0, byArray, 0, 64);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 8) {
            n = 1 - (n5 & 1);
            while (n < 8) {
                byte by = this.field[n5 * 8 + n];
                switch (by) {
                    case 1: {
                        n3 += 2;
                        break;
                    }
                    case 3: {
                        n3 += 4;
                        break;
                    }
                    case 2: {
                        n4 += 2;
                        break;
                    }
                    case 4: {
                        n4 += 4;
                    }
                }
                n += 2;
            }
            ++n5;
        }
        n = n4;
        while (n < 50000 && n2 < 9) {
            n *= (++n2 & 1) == 1 ? n3 : n4;
        }
        return this.GetBestStep(byArray, false, n2, false, true);
    }

    public abstract MoveResult IsValidSource(int var1, int var2, boolean var3);

    class MoveResult {
        boolean valid;
        boolean continuous;
        String err;

        MoveResult() {
        }
    }

    public class C_best_step {
        int sx;
        int sy;
        int dx;
        int dy;
        int score;
        C_best_step cont_step;

        C_best_step() {
        }

        C_best_step(C_best_step c_best_step) {
            this.sx = c_best_step.sx;
            this.sy = c_best_step.sy;
            this.dx = c_best_step.dx;
            this.dy = c_best_step.dy;
            this.score = c_best_step.score;
            this.cont_step = c_best_step.cont_step;
        }

        public void Reset() {
            this.cont_step = null;
            this.score = -10000;
        }

        public boolean IsValid() {
            return this.score != -10000;
        }
    }
}

