/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class SeaDrive
extends MIDlet {
    private Display disp;
    private Intro intro;
    private GameOver gameOver;
    private GameCanvas game;
    public int gameScore;
    public int gameTime;
    public int lifes;
    public int currentLevel;
    public int gameState;
    public Timer timer;
    public Animator animator;
    byte[] abyte0 = new byte[1000];
    public boolean snd;
    static final String DBNAME = "SeaDrive7650";
    static final String DBNAME1 = "SeaDriveTime";
    static final int SCORE_DIV = 15;
    Sound sound1 = SeaDrive.a(this, "/intro.ott", this.abyte0);
    Sound sound2 = SeaDrive.a(this, "/over.ott", this.abyte0);
    Sound sound3 = SeaDrive.a(this, "/score.ott", this.abyte0);
    Sound sound4 = SeaDrive.a(this, "/sink.ott", this.abyte0);
    Image bottle;
    Image boat1;
    Image flag1;
    Image flag2;
    Image imgintro;
    Image imggameover;
    Image log;
    Image ramp;
    Image croc1;
    Image croc2;
    Image tube;
    Image usr1;
    Image usr2;
    Image u2tube;
    Image usr3;
    Image u3tube;
    Image w1;
    Image w2;
    Image w3;
    Image unit1;
    Image unit2;
    Image menuimg;
    Image uwon;
    Image tubeblack;
    Image joystick;
    Image loading;
    Image bg;
    Image m2w;

    public void startApp() {
        try {
            this.bg = Image.createImage((String)"/bg.gif");
            this.bottle = Image.createImage((String)"/batli.gif");
            this.boat1 = Image.createImage((String)"/boat1.gif");
            this.flag1 = Image.createImage((String)"/flag1.gif");
            this.flag2 = Image.createImage((String)"/flag2.gif");
            this.imggameover = Image.createImage((String)"/gameover.gif");
            this.log = Image.createImage((String)"/log.gif");
            this.ramp = Image.createImage((String)"/log2.gif");
            this.croc1 = Image.createImage((String)"/muger1.png");
            this.croc2 = Image.createImage((String)"/muger2.png");
            this.tube = Image.createImage((String)"/tube.gif");
            this.usr1 = Image.createImage((String)"/u1.gif");
            this.usr2 = Image.createImage((String)"/u2.gif");
            this.u2tube = Image.createImage((String)"/u2tube.gif");
            this.usr3 = Image.createImage((String)"/u3.gif");
            this.u3tube = Image.createImage((String)"/u3tube.gif");
            this.w1 = Image.createImage((String)"/w1.gif");
            this.w2 = Image.createImage((String)"/w2.gif");
            this.w3 = Image.createImage((String)"/w3.gif");
            this.unit1 = Image.createImage((String)"/unit1.gif");
            this.unit2 = Image.createImage((String)"/unit2.gif");
            this.uwon = Image.createImage((String)"/uwon.gif");
            this.tubeblack = Image.createImage((String)"/tubeblack.gif");
            this.loading = Image.createImage((String)"/loading.gif");
            this.m2w = Image.createImage((String)"/mobile2win.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.sound1.setGain(100);
        this.sound2.setGain(100);
        this.sound3.setGain(100);
        this.sound4.setGain(100);
        this.timer.schedule((TimerTask)this.animator, 0L, 50L);
        this.disp.setCurrent((Displayable)this.intro);
        this.gameScore = 0;
        this.lifes = 3;
        this.currentLevel = 1;
        this.gameState = 1;
        this.intro.introScreen();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public SeaDrive() {
        try {
            this.imgintro = Image.createImage((String)"/intro.gif");
            this.menuimg = Image.createImage((String)"/menuname.gif");
            this.joystick = Image.createImage((String)"/joystick.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.timer = new Timer();
        this.animator = new Animator();
        this.intro = new Intro();
        this.game = new GameCanvas();
        this.gameOver = new GameOver();
        this.disp = Display.getDisplay((MIDlet)this);
        this.snd = true;
        this.game.startGame();
        this.game.init();
    }

    public void HighScore(int n) {
        RecordStore recordStore = null;
        byte[] byArray = new byte[2];
        try {
            recordStore = RecordStore.openRecordStore((String)DBNAME, (boolean)true);
            try {
                byArray = recordStore.getRecord(1);
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                byArray[0] = 0;
                byArray[1] = 0;
            }
            int n2 = byArray[0] * 15 + byArray[1];
            int n3 = n / 15;
            int n4 = n % 15;
            recordStore.closeRecordStore();
            recordStore = null;
            RecordStore.deleteRecordStore((String)DBNAME);
            recordStore = RecordStore.openRecordStore((String)DBNAME, (boolean)true);
            byte[] byArray2 = new byte[]{(byte)n3, (byte)n4};
            recordStore.addRecord(byArray2, 0, byArray2.length);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public int HighScoreDisplayDB() {
        RecordStore recordStore = null;
        byte[] byArray = new byte[2];
        try {
            recordStore = RecordStore.openRecordStore((String)DBNAME, (boolean)true);
            try {
                byArray = recordStore.getRecord(1);
                recordStore.closeRecordStore();
                recordStore = null;
                return byArray[0] * 15 + byArray[1];
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                byArray[0] = 0;
                recordStore.closeRecordStore();
                recordStore = null;
                return 0;
            }
        }
        catch (RecordStoreException recordStoreException) {
            return 0;
        }
    }

    public static Sound a(MIDlet mIDlet, String string, byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
            int n = dataInputStream.read(byArray);
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            Sound sound = new Sound(byArray2, 1);
            dataInputStream.close();
            return sound;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    class Animator
    extends TimerTask {
        Animator() {
        }

        public void run() {
            if (SeaDrive.this.gameState == 1) {
                SeaDrive.this.intro.animate();
            } else if (SeaDrive.this.gameState == 2) {
                SeaDrive.this.game.animate();
            } else if (SeaDrive.this.gameState == 3) {
                // empty if block
            }
        }
    }

    class GameCanvas
    extends FullCanvas {
        private Vector elements;
        private int WD = this.getWidth();
        private int HT = this.getHeight();
        private Random r = new Random();
        private int ctr;
        private boolean gOver;
        private boolean gameBG = false;
        private boolean flagState;
        private int noElm;
        private int boatState;
        private int usrState;
        private int usrX;
        private int usrY;
        private int boatX;
        private int boatY;
        private int usrPos;
        private int usrLeft;
        private int usrRight;
        private int objSpacing;
        private int dispX;
        private int waveState;
        private boolean initAnimation;
        private boolean finalAnimation;
        private int leftFence;
        private int rightFence;
        private int startFenceY;
        private int levelX;
        private int levelY;
        private boolean levelAnimation;
        private int obsTemp;
        private int noOfRamp;
        private int tempX;
        private int tempY;
        private String levelText;
        private int[][] elemMass;
        private int usrSpeed;
        private final int obsInterval;

        GameCanvas() {
            this.obsInterval = 40;
        }

        public void startGame() {
            this.ctr = 0;
            SeaDrive.this.gameTime = 180;
            this.usrSpeed = 8;
            this.boatY = this.HT + 60;
            this.levelY = -20;
            this.levelAnimation = true;
            this.initAnimation = true;
            this.finalAnimation = false;
            this.levelText = "Easy Rider";
        }

        public void init() {
            this.usrState = 0;
            this.objSpacing = 50;
            this.elemMass = new int[6][2];
            this.elements = new Vector();
            this.elemMass[0][0] = 29;
            this.elemMass[1][0] = 10;
            this.elemMass[2][0] = 15;
            this.elemMass[3][0] = 23;
            this.elemMass[4][0] = 17;
            this.elemMass[5][0] = 49;
            this.elemMass[0][1] = 23;
            this.elemMass[1][1] = 20;
            this.elemMass[2][1] = 45;
            this.elemMass[3][1] = 14;
            this.elemMass[4][1] = 26;
            this.elemMass[5][1] = 32;
            this.usrPos = 0;
            this.usrLeft = 0;
            this.usrRight = 0;
            this.dispX = 0;
            this.startFenceY = -48;
            this.boatX = this.WD / 2;
            this.usrX = this.WD / 2;
            this.usrY = this.boatY + 125;
            this.leftFence = -70;
            this.rightFence = 245;
            this.obsTemp = 0;
            this.noOfRamp = 0;
            this.flagState = true;
            this.waveState = 0;
            this.gOver = false;
        }

        public void pauseGame() {
            SeaDrive.this.intro.setContinue2play();
            ((SeaDrive)SeaDrive.this).intro.mnu = true;
            ((SeaDrive)SeaDrive.this).intro.option = -1;
            ((SeaDrive)SeaDrive.this).intro.mnuIndex = ((SeaDrive)SeaDrive.this).intro.menu.length;
            SeaDrive.this.intro.startAnimator();
            SeaDrive.this.disp.setCurrent((Displayable)SeaDrive.this.intro);
            SeaDrive.this.gameState = 1;
            this.ctr = 0;
        }

        public void resumeGame() {
            this.ctr = 0;
        }

        private void gameOver(boolean bl) {
            this.gOver = true;
            ((SeaDrive)SeaDrive.this).gameOver.win = bl;
            SeaDrive.this.disp.setCurrent((Displayable)SeaDrive.this.gameOver);
            SeaDrive.this.gameState = 3;
        }

        public void paint(Graphics graphics) {
            DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.WD, this.HT);
            graphics.drawImage(SeaDrive.this.bg, 0, 0, 20);
            if (this.waveState == 0) {
                graphics.drawImage(SeaDrive.this.w1, this.boatX - 75, this.boatY + 48, 20);
                directGraphics.drawImage(SeaDrive.this.w1, this.boatX + 1, this.boatY + 48, 20, 8192);
            } else if (this.waveState == 1) {
                graphics.drawImage(SeaDrive.this.w2, this.boatX - 75, this.boatY + 48, 20);
                directGraphics.drawImage(SeaDrive.this.w2, this.boatX + 1, this.boatY + 48, 20, 8192);
            } else if (this.waveState == 2) {
                graphics.drawImage(SeaDrive.this.w3, this.boatX - 75, this.boatY + 48, 20);
                directGraphics.drawImage(SeaDrive.this.w3, this.boatX + 1, this.boatY + 48, 20, 8192);
            }
            if (!this.initAnimation) {
                this.drawObstacles(graphics);
            }
            if (this.boatX + 20 > 0 && this.boatX - 20 < this.WD) {
                graphics.drawImage(SeaDrive.this.boat1, this.boatX, this.boatY, 17);
            }
            graphics.setColor(0, 0, 0);
            if (this.initAnimation || this.finalAnimation) {
                graphics.drawLine(this.boatX, this.boatY + 35, this.usrX, this.usrY + 8);
                if (this.usrState == 0) {
                    graphics.drawImage(SeaDrive.this.usr1, this.usrX, this.usrY, 17);
                } else if (this.usrState == 1) {
                    graphics.drawImage(SeaDrive.this.usr1, this.usrX + 2, this.usrY, 17);
                }
            } else {
                graphics.drawLine(this.boatX, this.boatY + 35, this.usrX, this.usrY + 8);
                if (this.usrState == 0) {
                    if (this.usrLeft > 0) {
                        directGraphics.drawImage(SeaDrive.this.usr1, this.usrX, this.usrY, 17, 8192);
                    } else {
                        graphics.drawImage(SeaDrive.this.usr1, this.usrX, this.usrY, 17);
                    }
                } else if (this.usrState == 1) {
                    if (this.usrLeft > 0) {
                        directGraphics.drawImage(SeaDrive.this.usr1, this.usrX + 2, this.usrY, 17, 8192);
                    } else {
                        graphics.drawImage(SeaDrive.this.usr1, this.usrX + 2, this.usrY, 17);
                    }
                } else if (this.usrState == 3) {
                    graphics.drawImage(SeaDrive.this.u2tube, this.usrX, this.usrY, 17);
                    graphics.drawImage(SeaDrive.this.usr2, this.usrX, this.usrY, 17);
                } else if (this.usrState == 4) {
                    graphics.drawImage(SeaDrive.this.u2tube, this.usrX, this.usrY, 17);
                    graphics.drawImage(SeaDrive.this.usr2, this.usrX, this.usrY, 17);
                } else if (this.usrState == 5) {
                    graphics.drawImage(SeaDrive.this.u2tube, this.usrX, this.usrY, 17);
                    graphics.drawImage(SeaDrive.this.usr2, this.usrX, this.usrY + 5, 17);
                } else if (this.usrState == 6) {
                    graphics.drawImage(SeaDrive.this.u2tube, this.usrX, this.usrY, 17);
                    graphics.drawImage(SeaDrive.this.usr2, this.usrX, this.usrY + 10, 17);
                } else if (this.usrState > 6 && this.usrState < 12) {
                    graphics.drawImage(SeaDrive.this.u3tube, this.usrX, this.usrY, 17);
                    graphics.drawImage(SeaDrive.this.usr3, this.usrX, this.usrY + 15, 17);
                } else if (this.usrState >= 12) {
                    graphics.drawImage(SeaDrive.this.u2tube, this.usrX, this.usrY, 17);
                    graphics.drawImage(SeaDrive.this.usr2, this.usrX, this.usrY, 17);
                }
            }
            this.drawConstant(graphics, directGraphics);
        }

        public void drawConstant(Graphics graphics, DirectGraphics directGraphics) {
            int n;
            if (this.leftFence >= 0) {
                n = this.startFenceY;
                while (n < this.HT + 20) {
                    graphics.drawImage(SeaDrive.this.tubeblack, this.leftFence - 27, n, 20);
                    n += 30;
                }
            }
            if (this.rightFence <= this.WD) {
                n = this.startFenceY;
                while (n < this.HT + 20) {
                    graphics.drawImage(SeaDrive.this.tubeblack, this.rightFence, n, 20);
                    n += 30;
                }
            }
            if (this.levelY < this.HT) {
                graphics.setColor(0, 0, 0);
                graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
                graphics.drawString(this.levelText, this.WD / 2, this.levelY, 17);
            }
            graphics.drawImage(SeaDrive.this.unit1, 0, 0, 20);
            directGraphics.drawImage(SeaDrive.this.unit1, this.WD / 2, 0, 20, 8192);
            graphics.drawImage(SeaDrive.this.unit2, 0, this.HT - 22, 20);
            n = 0;
            while (n < SeaDrive.this.lifes) {
                graphics.drawImage(SeaDrive.this.tube, n * 22, this.HT - 18, 20);
                ++n;
            }
            graphics.setColor(255, 255, 255);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString("Pts " + SeaDrive.this.gameScore, 5, 5, 20);
            graphics.drawString("Time", 80, 5, 20);
            graphics.setColor(255, 0, 0);
            graphics.fillRect(this.WD - 64, 10, (180 - SeaDrive.this.gameTime) / 3, 5);
            graphics.setColor(0, 0, 0);
            graphics.drawRect(this.WD - 65, 9, 61, 6);
        }

        private void drawObstacles(Graphics graphics) {
            try {
                int n = 0;
                while (n < this.elements.size()) {
                    GameElement gameElement = (GameElement)this.elements.elementAt(n);
                    switch (gameElement.getId()) {
                        case 0: {
                            graphics.drawImage(SeaDrive.this.log, gameElement.getX(), gameElement.getY(), 20);
                            break;
                        }
                        case 1: {
                            graphics.drawImage(SeaDrive.this.bottle, gameElement.getX(), gameElement.getY(), 20);
                            break;
                        }
                        case 2: {
                            graphics.drawImage(SeaDrive.this.croc1, gameElement.getX(), gameElement.getY(), 20);
                            graphics.drawImage(SeaDrive.this.croc2, gameElement.getX(), gameElement.getY() - 30, 20);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            if (this.flagState) {
                                graphics.drawImage(SeaDrive.this.flag1, gameElement.getX(), gameElement.getY(), 20);
                                break;
                            }
                            graphics.drawImage(SeaDrive.this.flag2, gameElement.getX(), gameElement.getY(), 20);
                            break;
                        }
                        case 5: {
                            graphics.drawImage(SeaDrive.this.ramp, gameElement.getX(), gameElement.getY(), 20);
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void addObstacle() {
            this.tempX = this.r.nextInt() % 105;
            this.tempX = this.tempX < 0 ? this.tempX * -1 : this.tempX;
            int n = 0;
            while (n < 3) {
                int n2 = this.r.nextInt() % 6;
                int n3 = n2 = n2 < 0 ? n2 * -1 : n2;
                if (n2 == 3) {
                    n2 = 1;
                }
                if (SeaDrive.this.gameTime > 120 && n2 == 2) {
                    n2 = 0;
                }
                this.tempY = this.r.nextInt() % 20;
                this.tempY = this.tempY > 0 ? this.tempY * -1 : this.tempY;
                this.tempY -= this.elemMass[n2][1];
                if (n2 > 3) {
                    if (n == 0) {
                        this.elements.addElement(new GameElement(this.leftFence + this.tempX, this.tempY, this.elemMass[n2][0], this.elemMass[n2][1], n2, true));
                    } else if (n == 1) {
                        this.elements.addElement(new GameElement(this.leftFence + this.tempX + 105, this.tempY, this.elemMass[n2][0], this.elemMass[n2][1], n2, true));
                    } else if (n == 2 && this.leftFence + this.tempX + 210 < this.rightFence) {
                        this.elements.addElement(new GameElement(this.leftFence + this.tempX + 210, this.tempY, this.elemMass[n2][0], this.elemMass[n2][1], n2, true));
                    }
                } else if (n == 0) {
                    this.elements.addElement(new GameElement(this.leftFence + this.tempX, this.tempY, this.elemMass[n2][0], this.elemMass[n2][1], n2, false));
                } else if (n == 1) {
                    this.elements.addElement(new GameElement(this.leftFence + this.tempX + 105, this.tempY, this.elemMass[n2][0], this.elemMass[n2][1], n2, false));
                } else if (n == 2 && this.leftFence + this.tempX + 210 < this.rightFence) {
                    this.elements.addElement(new GameElement(this.leftFence + this.tempX + 210, this.tempY, this.elemMass[n2][0], this.elemMass[n2][1], n2, false));
                }
                ++n;
            }
            ++this.noElm;
            if (this.noElm > 100) {
                this.noElm = 0;
            }
        }

        private void checkCollision() {
            if (this.usrState < 2) {
                int n = 0;
                while (n < this.elements.size()) {
                    block24: {
                        try {
                            GameElement gameElement = (GameElement)this.elements.elementAt(n);
                            if (gameElement.getId() < 3) {
                                if (this.usrX - 23 - gameElement.getX() <= -38 || this.usrX - 23 - gameElement.getX() >= gameElement.getWD() || gameElement.getY() + gameElement.getHT() - (this.usrY + 10) <= 0 || gameElement.getY() - this.usrY >= 35) break block24;
                                this.usrState = 3;
                                try {
                                    if (SeaDrive.this.snd) {
                                        SeaDrive.this.sound4.stop();
                                        SeaDrive.this.sound1.stop();
                                        SeaDrive.this.sound2.stop();
                                        SeaDrive.this.sound3.stop();
                                        SeaDrive.this.sound4.play(1);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return;
                            }
                            if (gameElement.getId() != 4 && gameElement.getId() != 5 || this.usrX - 23 - gameElement.getX() <= -40 || this.usrX - 23 - gameElement.getX() >= gameElement.getWD() || gameElement.getY() + gameElement.getHT() - (this.usrY + 10) <= 0 || gameElement.getY() - this.usrY >= 40) break block24;
                            this.usrState = 12;
                            if (!gameElement.scr) break block24;
                            if (gameElement.getId() == 4) {
                                SeaDrive.this.gameScore += 5;
                            } else if (gameElement.getId() == 5) {
                                if (SeaDrive.this.lifes < 3) {
                                    ++this.noOfRamp;
                                    if (this.noOfRamp == 5) {
                                        ++SeaDrive.this.lifes;
                                        this.noOfRamp = 0;
                                    }
                                }
                                SeaDrive.this.gameScore += 10;
                            }
                            try {
                                if (SeaDrive.this.snd) {
                                    SeaDrive.this.sound4.stop();
                                    SeaDrive.this.sound1.stop();
                                    SeaDrive.this.sound2.stop();
                                    SeaDrive.this.sound3.stop();
                                    SeaDrive.this.sound3.play(1);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            gameElement.scr = false;
                            return;
                        }
                        catch (Exception exception) {
                            System.out.println("Array Exception");
                            exception.printStackTrace();
                        }
                    }
                    ++n;
                }
                if (this.leftFence - this.usrX >= -16 && this.usrState < 2) {
                    this.usrState = 3;
                    try {
                        if (SeaDrive.this.snd) {
                            SeaDrive.this.sound4.stop();
                            SeaDrive.this.sound1.stop();
                            SeaDrive.this.sound2.stop();
                            SeaDrive.this.sound3.stop();
                            SeaDrive.this.sound4.play(1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.rightFence - this.usrX < 16 && this.usrState < 2) {
                    this.usrState = 3;
                    try {
                        if (SeaDrive.this.snd) {
                            SeaDrive.this.sound4.stop();
                            SeaDrive.this.sound1.stop();
                            SeaDrive.this.sound2.stop();
                            SeaDrive.this.sound3.stop();
                            SeaDrive.this.sound4.play(1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void keyPressed(int n) {
            if (!this.initAnimation) {
                switch (this.getGameAction(n)) {
                    case 2: 
                    case 52: {
                        if (this.usrState >= 2 && this.usrState <= 11) break;
                        if (this.usrRight > 0) {
                            this.usrRight = 0;
                            this.usrLeft = 0;
                            this.dispX = 0;
                        }
                        this.usrPos = 1;
                        break;
                    }
                    case 5: 
                    case 54: {
                        if (this.usrState >= 2 && this.usrState <= 11) break;
                        if (this.usrLeft > 0) {
                            this.usrRight = 0;
                            this.usrLeft = 0;
                            this.dispX = 0;
                        }
                        this.usrPos = 2;
                        break;
                    }
                    default: {
                        if (n != -6) break;
                        this.pauseGame();
                    }
                }
            }
        }

        public void keyReleased(int n) {
            if (!this.initAnimation) {
                switch (this.getGameAction(n)) {
                    case 2: 
                    case 5: 
                    case 52: 
                    case 54: {
                        this.usrPos = 0;
                    }
                }
            }
        }

        public void animate() {
            try {
                if (!this.gOver) {
                    if (this.initAnimation) {
                        if (this.ctr % 2 == 0) {
                            this.boatY -= 10;
                            this.usrY -= 10;
                            if (this.usrY <= this.HT - 65) {
                                this.usrY = this.HT - 65;
                                this.initAnimation = false;
                            }
                            ++this.waveState;
                            if (this.waveState > 2) {
                                this.waveState = 0;
                            }
                        }
                    } else if (this.finalAnimation) {
                        this.usrState = 0;
                        this.boatY -= 10;
                        this.usrY -= 10;
                        if (this.usrY <= -40) {
                            this.finalAnimation = false;
                            this.gameOver(true);
                        }
                        ++this.waveState;
                        if (this.waveState > 2) {
                            this.waveState = 0;
                        }
                    } else {
                        ++this.obsTemp;
                        if (SeaDrive.this.gameTime > 4 && this.obsTemp >= 40) {
                            this.obsTemp = 0;
                            this.addObstacle();
                        }
                        if (this.ctr % 2 == 0) {
                            if (this.levelY <= this.HT) {
                                this.levelY += this.usrSpeed;
                            }
                            this.startFenceY += this.usrSpeed;
                            if (this.startFenceY > 0) {
                                this.startFenceY = -50;
                            }
                            if (this.usrState < 2 || this.usrState > 11) {
                                if (this.usrPos == 1) {
                                    this.usrLeft = this.usrLeft + 1 > 4 ? 4 : this.usrLeft + 1;
                                } else if (this.usrPos == 2) {
                                    int n = this.usrRight = this.usrRight + 1 > 4 ? 4 : this.usrRight + 1;
                                }
                                if (this.usrLeft > 0) {
                                    if (this.usrLeft == 1) {
                                        this.dispX = 2;
                                    } else if (this.usrLeft == 2) {
                                        this.dispX = 5;
                                    } else if (this.usrLeft == 3) {
                                        this.dispX = 8;
                                    } else if (this.usrLeft == 4) {
                                        this.dispX = 12;
                                    }
                                } else if (this.usrRight > 0) {
                                    if (this.usrRight == 1) {
                                        this.dispX = -2;
                                    } else if (this.usrRight == 2) {
                                        this.dispX = -5;
                                    } else if (this.usrRight == 3) {
                                        this.dispX = -8;
                                    } else if (this.usrRight == 4) {
                                        this.dispX = -12;
                                    }
                                }
                            }
                            if (this.dispX != 0 && (this.usrState < 2 || this.usrState > 11)) {
                                if (this.leftFence < 27 && this.rightFence > 149) {
                                    this.boatX += this.dispX;
                                    this.leftFence += this.dispX;
                                    this.rightFence += this.dispX;
                                } else {
                                    this.usrX -= this.dispX;
                                    if (this.leftFence >= 27 && this.usrX > this.WD / 2) {
                                        this.usrX = this.WD / 2;
                                        this.boatX += this.dispX;
                                        this.leftFence += this.dispX;
                                        this.rightFence += this.dispX;
                                    } else if (this.rightFence <= 149 && this.usrX < this.WD / 2) {
                                        this.usrX = this.WD / 2;
                                        this.boatX += this.dispX;
                                        this.leftFence += this.dispX;
                                        this.rightFence += this.dispX;
                                    }
                                }
                            }
                            if (this.usrState < 2 || this.usrState > 11) {
                                int n = 0;
                                while (n < this.elements.size()) {
                                    GameElement gameElement = (GameElement)this.elements.elementAt(n);
                                    gameElement.setY(gameElement.getY() + this.usrSpeed);
                                    if (this.dispX != 0 && this.leftFence < 27 && this.rightFence > 149) {
                                        gameElement.setX(gameElement.getX() + this.dispX);
                                    }
                                    if (gameElement.getY() > this.HT + 50) {
                                        this.elements.removeElementAt(n);
                                    }
                                    ++n;
                                }
                            }
                            if (this.usrState == 12) {
                                ++this.usrState;
                            } else if (this.usrState == 13) {
                                this.usrState = 0;
                            }
                            this.checkCollision();
                            if (this.usrState >= 3 && this.usrState <= 8) {
                                ++this.usrState;
                            }
                            if (this.usrState > 8 && this.usrState < 12) {
                                --SeaDrive.this.lifes;
                                if (SeaDrive.this.lifes > 0) {
                                    this.init();
                                } else {
                                    this.gameOver(false);
                                }
                            }
                            ++this.waveState;
                            if (this.waveState > 2) {
                                this.waveState = 0;
                            }
                        }
                        if (this.ctr % 4 == 0) {
                            boolean bl = this.flagState = !this.flagState;
                        }
                        if (this.ctr % 8 == 0 && this.usrState < 3) {
                            ++this.usrState;
                            if (this.usrState > 1) {
                                this.usrState = 0;
                            }
                        }
                        if (this.ctr % 20 == 0) {
                            --SeaDrive.this.gameTime;
                            if (SeaDrive.this.gameTime <= 0 && SeaDrive.this.lifes > 0) {
                                this.finalAnimation = true;
                            }
                            if (SeaDrive.this.gameTime < 30) {
                                this.usrSpeed = 18;
                                if (this.levelY > this.HT && SeaDrive.this.currentLevel < 4) {
                                    SeaDrive.this.currentLevel = 4;
                                    this.levelText = "Sea Sick";
                                    this.levelY = -20;
                                }
                            } else if (SeaDrive.this.gameTime < 60) {
                                this.usrSpeed = 14;
                                if (this.levelY > this.HT && SeaDrive.this.currentLevel < 3) {
                                    SeaDrive.this.currentLevel = 3;
                                    this.levelText = "Making Waves";
                                    this.levelY = -20;
                                }
                            } else if (SeaDrive.this.gameTime < 120) {
                                this.usrSpeed = 10;
                                if (this.levelY > this.HT && SeaDrive.this.currentLevel < 2) {
                                    SeaDrive.this.currentLevel = 2;
                                    this.levelText = "Surfs Up";
                                    this.levelY = -20;
                                }
                            }
                        }
                    }
                }
                if (this.ctr > 1000) {
                    this.ctr = 0;
                }
                ++this.ctr;
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        class GameElement {
            int x;
            int y;
            int wd;
            int ht;
            int id;
            public boolean scr;

            GameElement(int n, int n2, int n3, int n4, int n5, boolean bl) {
                this.x = n;
                this.y = n2;
                this.wd = n3;
                this.ht = n4;
                this.id = n5;
                this.scr = bl;
            }

            public int getX() {
                return this.x;
            }

            public int getY() {
                return this.y;
            }

            public int getWD() {
                return this.wd;
            }

            public int getHT() {
                return this.ht;
            }

            public int getId() {
                return this.id;
            }

            public void set(int n, int n2, int n3) {
                this.x = n;
                this.y = n2;
                this.id = n3;
            }

            public void setX(int n) {
                this.x = n;
            }

            public void setY(int n) {
                this.y = n;
            }

            public void setId(int n) {
                this.id = n;
            }
        }
    }

    class Intro
    extends FullCanvas {
        public String[] menu = new String[]{"Start2play", "Game2play", "How2play", "Sound (on)", "Top Score", "Exit"};
        public String[] game2Play = new String[]{"Water Sports are fun. You are", "surfing on a swimming tube,", "being dragged by a motorboat.", "Avoid logs, crocs and garbage.", "Score points by surfing over", "ramps and flags. You have 3 ", "lives and 180 seconds to survive.", "You get one life for every 5 ", "ramps you ski over."};
        public String[] how2Play = new String[]{"Surf Left: LEFT", "Surf Right: RIGHT"};
        public int option = -1;
        private int selOption = 0;
        public String mnuState;
        public int mnuIndex;
        private int mnuX;
        private int mnuY;
        private boolean gameBG;
        public boolean con2play = false;
        private int WD = this.getWidth();
        private int HT = this.getHeight();
        private boolean tubeState;
        private int ctr = 0;
        private int g2pY;
        private int g2pLine;
        private boolean lnding = true;
        private int loadctr = 0;
        public boolean mnu = false;
        private boolean visible = true;

        Intro() {
        }

        public void introScreen() {
            this.startAnimator();
        }

        public void startAnimator() {
            this.g2pY = 70;
            this.g2pLine = 12;
            this.ctr = 0;
            this.option = -1;
        }

        public void setPlayAgain() {
            this.menu[0] = "Play Again";
        }

        public void setContinue2play() {
            ((SeaDrive)SeaDrive.this).intro.menu[0] = "Continue2play";
            ((SeaDrive)SeaDrive.this).intro.con2play = true;
        }

        public synchronized void paint(Graphics graphics) {
            DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (!this.mnu) {
                if (this.lnding) {
                    graphics.drawImage(SeaDrive.this.loading, 0, 0, 20);
                    graphics.setColor(255, 0, 0);
                    graphics.fillRect(39, 194, 105, 8);
                    graphics.setColor(0, 0, 0);
                    graphics.fillRect(39, 194, this.loadctr * 5, 8);
                } else {
                    graphics.drawImage(SeaDrive.this.imgintro, 0, 0, 20);
                    if (this.visible) {
                        graphics.drawImage(SeaDrive.this.joystick, 42, 162, 20);
                    }
                }
            } else {
                graphics.setColor(96, 155, 243);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.mnuIndex == this.menu.length) {
                    if (this.option == 1) {
                        Menu.drawGame2Play(graphics, this.game2Play, this.getWidth(), this.getHeight(), this.g2pY);
                    } else if (this.option == 2) {
                        Menu.drawHow2Play(graphics, this.how2Play, this.getWidth(), this.getHeight());
                    } else if (this.option == 3) {
                        if (SeaDrive.this.snd) {
                            SeaDrive.this.snd = false;
                            this.menu[3] = "Sound (off)";
                        } else {
                            SeaDrive.this.snd = true;
                            this.menu[3] = "Sound (on)";
                        }
                        this.option = -1;
                    } else if (this.option == 4) {
                        graphics.setColor(0, 0, 0);
                        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
                        graphics.drawString("Top Score", this.getWidth() / 2, 95, 17);
                        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                        graphics.drawString("Score : " + String.valueOf(SeaDrive.this.HighScoreDisplayDB()), this.getWidth() / 2, 115, 17);
                    }
                    if (this.option == -1) {
                        Menu.drawMenu(graphics, this.menu, 60, 95, this.selOption, this.getWidth());
                        if (this.tubeState) {
                            graphics.drawImage(SeaDrive.this.tube, 22, 95 + this.selOption * 16, 20);
                        } else {
                            graphics.drawImage(SeaDrive.this.tube, 24, 95 + this.selOption * 16, 20);
                        }
                    }
                } else if (this.mnuIndex < this.menu.length) {
                    try {
                        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                        int n = 0;
                        while (n < this.mnuIndex) {
                            graphics.setColor(255, 255, 255);
                            graphics.drawString(this.menu[n], 61, 95 + n * 16 + 1, 20);
                            graphics.setColor(0, 0, 128);
                            graphics.drawString(this.menu[n], 60, 95 + n * 16, 20);
                            ++n;
                        }
                        graphics.setColor(255, 255, 255);
                        graphics.drawString(this.menu[this.mnuIndex], this.mnuX + 1, this.mnuY + 1, 20);
                        graphics.setColor(0, 0, 128);
                        graphics.drawString(this.menu[this.mnuIndex], this.mnuX, this.mnuY, 20);
                        graphics.drawImage(SeaDrive.this.tube, this.mnuX + 120, this.mnuY, 20);
                    }
                    catch (Exception exception) {
                        this.mnuIndex = this.menu.length;
                    }
                }
                graphics.setColor(96, 155, 243);
                graphics.fillRect(0, 0, this.getWidth(), 35);
                graphics.drawImage(SeaDrive.this.menuimg, 0, 0, 20);
                graphics.fillRect(0, this.HT - 5, this.getWidth(), 5);
                graphics.drawImage(SeaDrive.this.m2w, this.WD / 2, this.HT - 11, 17);
            }
        }

        protected synchronized void keyPressed(int n) {
            block16: {
                try {
                    if (this.mnuIndex == this.menu.length) {
                        switch (this.getGameAction(n)) {
                            case 1: 
                            case 50: {
                                if (this.mnu && this.option == -1) {
                                    this.selOption = this.selOption <= 0 ? this.selOption + (this.menu.length - 1) : this.selOption - 1;
                                    this.repaint();
                                } else if (this.mnu && this.option == 1 && this.g2pY < 70) {
                                    this.g2pY += this.g2pLine;
                                }
                                this.repaint();
                                break;
                            }
                            case 6: 
                            case 56: {
                                if (this.mnu && this.option == -1) {
                                    this.selOption = this.selOption >= this.menu.length - 1 ? 0 : this.selOption + 1;
                                    this.repaint();
                                } else if (this.mnu && this.option == 1 && this.g2pY + this.g2pLine * this.game2Play.length + 20 > this.getHeight() - 5) {
                                    this.g2pY -= this.g2pLine;
                                }
                                this.repaint();
                                break;
                            }
                            case 8: 
                            case 53: {
                                this.pressFire();
                                break;
                            }
                            default: {
                                if (n == -6) {
                                    this.pressFire();
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block16;
                    }
                    if (!(n != -6 && this.getGameAction(n) != 8 || this.mnu || this.lnding)) {
                        this.selOption = this.selOption < 0 ? this.selOption * -1 : this.selOption;
                        this.option = -1;
                        this.mnu = true;
                        this.mnuIndex = 0;
                        this.mnuX = -100;
                        this.mnuY = 95;
                        this.startAnimator();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void pressFire() {
            if (!this.mnu) {
                this.selOption = this.selOption < 0 ? this.selOption * -1 : this.selOption;
                this.option = -1;
                this.mnuIndex = this.menu.length;
                this.mnuX = -100;
                this.mnuY = 95;
            } else if (this.mnu) {
                switch (this.selOption) {
                    case 0: {
                        SeaDrive.this.gameState = 2;
                        SeaDrive.this.disp.setCurrent((Displayable)SeaDrive.this.game);
                        break;
                    }
                    case 1: {
                        this.g2pY = 70;
                        this.option = this.selOption;
                        this.selOption *= -1;
                        break;
                    }
                    case 2: {
                        this.option = this.selOption;
                        this.selOption *= -1;
                        break;
                    }
                    case 3: {
                        this.option = this.selOption;
                        break;
                    }
                    case 4: {
                        this.option = this.selOption;
                        this.selOption *= -1;
                        break;
                    }
                    case 5: {
                        SeaDrive.this.destroyApp(false);
                        SeaDrive.this.notifyDestroyed();
                    }
                    default: {
                        if (this.selOption >= 0) break;
                        this.selOption *= -1;
                        this.option = -1;
                    }
                }
            }
        }

        public void animate() {
            try {
                if (this.mnu) {
                    if (this.mnuIndex < this.menu.length) {
                        this.mnuX += 20;
                        if (this.mnuX >= 60) {
                            this.mnuX = -140;
                            this.mnuY += 16;
                            ++this.mnuIndex;
                        }
                    } else if (this.ctr % 4 == 0) {
                        this.tubeState = !this.tubeState;
                    }
                } else {
                    if (this.ctr % 2 == 0 && this.lnding) {
                        ++this.loadctr;
                        if (this.loadctr > 20) {
                            this.lnding = false;
                            try {
                                if (SeaDrive.this.snd) {
                                    SeaDrive.this.sound1.stop();
                                    SeaDrive.this.sound2.stop();
                                    SeaDrive.this.sound3.stop();
                                    SeaDrive.this.sound4.stop();
                                    SeaDrive.this.sound1.play(1);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.ctr % 5 == 0) {
                        this.visible = !this.visible;
                    }
                }
                this.repaint();
                if (this.ctr >= 1000) {
                    this.ctr = 0;
                }
                ++this.ctr;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class GameOver
    extends FullCanvas {
        public boolean win;
        private Image gamewin;

        GameOver() {
        }

        public void paint(Graphics graphics) {
            if (this.win) {
                this.drawGameWin(graphics);
            } else {
                this.drawGameOver(graphics);
            }
            if (SeaDrive.this.snd) {
                try {
                    SeaDrive.this.sound3.stop();
                    SeaDrive.this.sound1.stop();
                    SeaDrive.this.sound2.stop();
                    SeaDrive.this.sound4.stop();
                    SeaDrive.this.sound2.play(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void drawGameOver(Graphics graphics) {
            graphics.drawImage(SeaDrive.this.imggameover, 0, 0, 20);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, this.getHeight() - 20, this.getWidth(), 20);
            graphics.setColor(255, 255, 255);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString("Score " + SeaDrive.this.gameScore, this.getWidth() / 2, this.getHeight() - 15, 17);
        }

        private void drawGameWin(Graphics graphics) {
            graphics.drawImage(SeaDrive.this.uwon, 0, 0, 20);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, this.getHeight() - 20, this.getWidth(), 20);
            graphics.setColor(255, 255, 255);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString("Score " + SeaDrive.this.gameScore, this.getWidth() / 2, this.getHeight() - 15, 17);
        }

        protected void keyPressed(int n) {
            if (SeaDrive.this.HighScoreDisplayDB() < SeaDrive.this.gameScore) {
                SeaDrive.this.HighScore(SeaDrive.this.gameScore);
            }
            switch (this.getGameAction(n)) {
                case 8: 
                case 53: {
                    ((SeaDrive)SeaDrive.this).intro.mnu = true;
                    SeaDrive.this.intro.setPlayAgain();
                    SeaDrive.this.game.startGame();
                    SeaDrive.this.game.init();
                    ((SeaDrive)SeaDrive.this).intro.option = -1;
                    ((SeaDrive)SeaDrive.this).intro.mnuIndex = ((SeaDrive)SeaDrive.this).intro.menu.length;
                    SeaDrive.this.intro.startAnimator();
                    SeaDrive.this.disp.setCurrent((Displayable)SeaDrive.this.intro);
                    SeaDrive.this.gameState = 1;
                    ((SeaDrive)SeaDrive.this).intro.con2play = false;
                    SeaDrive.this.gameScore = 0;
                    SeaDrive.this.lifes = 3;
                    SeaDrive.this.currentLevel = 1;
                    break;
                }
                default: {
                    if (n != -6) break;
                    ((SeaDrive)SeaDrive.this).intro.mnu = true;
                    SeaDrive.this.intro.setPlayAgain();
                    SeaDrive.this.game.startGame();
                    SeaDrive.this.game.init();
                    ((SeaDrive)SeaDrive.this).intro.option = -1;
                    ((SeaDrive)SeaDrive.this).intro.mnuIndex = ((SeaDrive)SeaDrive.this).intro.menu.length;
                    SeaDrive.this.intro.startAnimator();
                    SeaDrive.this.disp.setCurrent((Displayable)SeaDrive.this.intro);
                    SeaDrive.this.gameState = 1;
                    ((SeaDrive)SeaDrive.this).intro.con2play = false;
                    SeaDrive.this.gameScore = 0;
                    SeaDrive.this.lifes = 3;
                    SeaDrive.this.currentLevel = 1;
                }
            }
        }
    }
}

