/*
 * Decompiled with CFR 0.152.
 */
public final class KDTree2D {
    protected Node[] m_pNodeBuffer;
    protected int m_iBufferSize;
    protected int m_iWaterMarker;
    protected int m_iRootIndex;
    protected int m_iNumSplits;

    public final void build(vLinkedList srcList) {
        if (this.m_pNodeBuffer != null) {
            System.out.println("VASSERT failed ::m_pNodeBuffer == null");
        }
        this.m_iWaterMarker = 0;
        this.m_iBufferSize = (srcList.m_iSize << 1) - 1 + 32;
        this.m_pNodeBuffer = new Node[this.m_iBufferSize];
        if (this.m_pNodeBuffer == null) {
            System.out.println("VASSERT failed ::m_pNodeBuffer != null");
        }
        for (int i = 0; i < this.m_iBufferSize; ++i) {
            this.m_pNodeBuffer[i] = new Node(this);
        }
        this.m_iRootIndex = 1 + this.buildSubtree(srcList, 0);
        if (this.getNumberLeaves(this.m_iRootIndex) < srcList.m_iSize) {
            System.out.println("VASSERT failed ::getNumberLeaves( m_iRootIndex ) >= srcList.getSize()");
        }
    }

    public final void clear() {
        this.m_pNodeBuffer = null;
        this.m_iBufferSize = 0;
        this.m_iWaterMarker = 0;
        this.m_iRootIndex = 0;
        this.m_iNumSplits = 0;
    }

    public final int find(int iX, int iY) {
        int userData = 0;
        int[] pFindArray = new int[]{iX, iY};
        int iNodeIndex = this.m_iRootIndex;
        int iAxis = 0;
        while (iNodeIndex != 0) {
            if (iNodeIndex > 0) {
                Node pNode = this.getNode(iNodeIndex - 1);
                iNodeIndex = pFindArray[iAxis] < pNode.m_iSplitter ? pNode.m_iBackChild : pNode.m_iFrontChild;
                iAxis ^= 1;
                continue;
            }
            userData = -iNodeIndex;
            return userData;
        }
        return 0;
    }

    private Node getNode(int iIndex) {
        if (iIndex < 0) {
            System.out.println("VASSERT failed ::iIndex >= 0");
        }
        if (iIndex >= this.m_iBufferSize) {
            System.out.println("VASSERT failed ::iIndex < m_iBufferSize");
        }
        if (this.m_pNodeBuffer == null) {
            System.out.println("VASSERT failed ::m_pNodeBuffer != null");
        }
        return this.m_pNodeBuffer[iIndex];
    }

    private int getNumberLeaves(int iIndex) {
        if (iIndex > 0) {
            Node pNode = this.getNode(iIndex - 1);
            return this.getNumberLeaves(pNode.m_iFrontChild) + this.getNumberLeaves(pNode.m_iBackChild);
        }
        if (iIndex < 0) {
            return 1;
        }
        return 0;
    }

    private int buildSubtree(vLinkedList q, int iDepth) {
        Sector pKDNode;
        if (q.isEmpty()) {
            return 0;
        }
        if (q.m_iSize <= 1) {
            System.out.println("VASSERT failed ::q.getSize() > 1");
        }
        int iBestSplits = Integer.MAX_VALUE;
        int iBestBalanceDifference = Integer.MAX_VALUE;
        int iBestSplitterValue = Integer.MAX_VALUE;
        Sector pBestSrc = null;
        int iAxis = iDepth & 1;
        vNode pSlitter = q.m_pFirst;
        while (pSlitter != null) {
            for (int iSide = 0; iSide < 2; ++iSide) {
                int iSplitterValue;
                Sector pKDSplitter = (Sector)pSlitter;
                int iSplits = 0;
                int iBackSideCount = 0;
                int iFrontSideCount = 0;
                vRect kSplitterRect = pKDSplitter.m_area;
                if (iSide == 0) {
                    if (iAxis == 0) {
                        iSplitterValue = kSplitterRect.x;
                    } else {
                        if (iAxis != 1) {
                            System.out.println("VASSERT failed ::iAxis == 1");
                        }
                        iSplitterValue = kSplitterRect.y;
                    }
                } else {
                    if (iSide != 1) {
                        System.out.println("VASSERT failed ::iSide == 1");
                    }
                    if (iAxis == 0) {
                        iSplitterValue = kSplitterRect.x + kSplitterRect.dx;
                    } else {
                        if (iAxis != 1) {
                            System.out.println("VASSERT failed ::iAxis == 1");
                        }
                        iSplitterValue = kSplitterRect.y + kSplitterRect.dy;
                    }
                }
                vNode pCompare = q.m_pFirst;
                while (pCompare != null) {
                    Sector pKDCompare = (Sector)pCompare;
                    vRect kCompareRect = pKDCompare.m_area;
                    int iIncrementCount = 0;
                    switch (iAxis) {
                        case 0: {
                            if (kCompareRect.x + kCompareRect.dx > iSplitterValue) {
                                ++iFrontSideCount;
                                ++iIncrementCount;
                            }
                            if (kCompareRect.x >= iSplitterValue) break;
                            ++iBackSideCount;
                            ++iIncrementCount;
                            break;
                        }
                        case 1: {
                            if (kCompareRect.y + kCompareRect.dy > iSplitterValue) {
                                ++iFrontSideCount;
                                ++iIncrementCount;
                            }
                            if (kCompareRect.y >= iSplitterValue) break;
                            ++iBackSideCount;
                            ++iIncrementCount;
                        }
                    }
                    if (iIncrementCount == 2) {
                        ++iSplits;
                    }
                    pCompare = pCompare.m_pNext;
                }
                int iBalanceDifference = Math.abs(iFrontSideCount - iBackSideCount) + (iSplits << 1);
                if (iBalanceDifference >= iBestBalanceDifference && (iBalanceDifference != iBestBalanceDifference || iSplits >= iBestSplits)) continue;
                iBestSplitterValue = iSplitterValue;
                iBestBalanceDifference = iBalanceDifference;
                iBestSplits = iSplits;
                pBestSrc = pKDSplitter;
            }
            pSlitter = pSlitter.m_pNext;
        }
        if (pBestSrc == null) {
            System.out.println("VASSERT failed ::pBestSrc != null");
        }
        this.m_iNumSplits += iBestSplits;
        int iBestNodeIndex = this.allocateNode();
        Node pBestNode = this.getNode(iBestNodeIndex);
        this.getNode(iBestNodeIndex).m_iSplitter = iBestSplitterValue;
        vLinkedList subList = new vLinkedList();
        vNode n = q.m_pFirst;
        while (n != null) {
            vNode next = n.m_pNext;
            pKDNode = (Sector)n;
            if (iAxis == 0) {
                if (pKDNode.m_area.x + pKDNode.m_area.dx > iBestSplitterValue) {
                    q.remove(n);
                    subList.insertLast(pKDNode);
                }
            } else {
                if (iAxis != 1) {
                    System.out.println("VASSERT failed ::iAxis == 1");
                }
                if (pKDNode.m_area.y + pKDNode.m_area.dy > iBestSplitterValue) {
                    q.remove(n);
                    subList.insertLast(pKDNode);
                }
            }
            n = next;
        }
        if (subList.m_iSize > 1) {
            pBestNode.m_iFrontChild = 1 + this.buildSubtree(subList, iDepth + 1);
        } else if (subList.m_iSize == 1) {
            Sector pSrcUserNode = (Sector)subList.m_pFirst;
            pBestNode.m_iFrontChild = -pSrcUserNode.m_iID;
        } else {
            pBestNode.m_iFrontChild = 0;
        }
        while (!subList.isEmpty()) {
            q.insertLast(subList.removeFirst());
        }
        n = q.m_pFirst;
        while (n != null) {
            vNode next = n.m_pNext;
            pKDNode = (Sector)n;
            if (iAxis == 0) {
                if (pKDNode.m_area.x < iBestSplitterValue) {
                    q.remove(pKDNode);
                    subList.insertLast(pKDNode);
                }
            } else {
                if (iAxis != 1) {
                    System.out.println("VASSERT failed ::iAxis == 1");
                }
                if (pKDNode.m_area.y < iBestSplitterValue) {
                    q.remove(pKDNode);
                    subList.insertLast(pKDNode);
                }
            }
            n = next;
        }
        if (subList.m_iSize > 1) {
            pBestNode.m_iBackChild = 1 + this.buildSubtree(subList, iDepth + 1);
        } else if (subList.m_iSize == 1) {
            Sector pSrcUserNode = (Sector)subList.m_pFirst;
            pBestNode.m_iBackChild = -pSrcUserNode.m_iID;
        } else {
            pBestNode.m_iBackChild = 0;
        }
        while (!subList.isEmpty()) {
            q.insertLast(subList.removeFirst());
        }
        return iBestNodeIndex;
    }

    private int allocateNode() {
        if (this.m_iWaterMarker >= this.m_iBufferSize - 1) {
            System.out.println("VASSERT failed ::m_iWaterMarker < m_iBufferSize - 1");
        }
        return ++this.m_iWaterMarker;
    }

    public final class Node {
        public int m_iSplitter;
        public int m_iFrontChild;
        public int m_iBackChild;

        public Node(KDTree2D this$0) {
        }
    }
}

