/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public final class vSprite {
    protected vRect m_tempRect = new vRect();
    public vRect m_frameRect = new vRect();
    public vRect m_paintRect = new vRect();
    public Image m_image;
    public short[] m_pixels;
    public vSpriteData m_spriteData;
    protected int m_iRenderFlags;
    protected int m_iTime;
    protected int m_iAnimStartTime;
    protected int m_iAnimEndTime;
    public int m_iPosX;
    protected int m_iPosY;
    protected int m_iFlags;
    public int m_iAnim;
    public int m_iFrame;
    protected int m_iPaintFrame;

    public vSprite(vSprite copy) {
        this.m_image = copy.m_image;
        this.m_pixels = copy.m_pixels;
        this.m_spriteData = copy.m_spriteData;
        this.m_iTime = copy.m_iTime;
        this.m_iAnimStartTime = copy.m_iAnimStartTime;
        this.m_iAnimEndTime = copy.m_iAnimEndTime;
        this.m_iPosX = copy.m_iPosX;
        this.m_iPosY = copy.m_iPosY;
        this.m_iFrame = copy.m_iFrame;
        this.m_iPaintFrame = copy.m_iPaintFrame;
        this.m_iRenderFlags = copy.m_iRenderFlags;
        this.m_iAnim = -1;
        this.updateFrameRect();
        this.updatePaintRect();
        this.updateRenderFlags();
    }

    public vSprite(Image image, vSpriteData data) {
        this.m_image = image;
        this.m_spriteData = data;
        this.m_iAnim = -1;
        this.updateFrameRect();
        this.updatePaintRect();
        this.updateRenderFlags();
    }

    public vSprite(short[] pixels, vSpriteData data) {
        this.m_pixels = pixels;
        this.m_spriteData = data;
        this.m_iAnim = -1;
        this.updateFrameRect();
        this.updatePaintRect();
        this.updateRenderFlags();
    }

    public final void free() {
        this.m_image = null;
        this.m_pixels = null;
        this.m_spriteData = null;
    }

    public final void setPosition(int iX, int iY) {
        this.m_iPosX = iX;
        this.m_iPosY = iY;
        this.updateFrameRect();
        this.updatePaintRect();
    }

    private int getAnimationDuration(int iAnim) {
        if (this.m_spriteData == null) {
            System.out.println("VASSERT failed ::m_spriteData != null");
        }
        if (iAnim >= this.m_spriteData.iAnimCount) {
            System.out.println("VASSERT failed ::iAnim < m_spriteData.iAnimCount");
        }
        int iRate = this.m_spriteData.animFlags[iAnim] & 0x3F;
        byte iLength = this.m_spriteData.animLength[iAnim];
        return iLength * 1000 / iRate;
    }

    public final int getWidth() {
        return this.m_frameRect.dx;
    }

    public final int getHeight() {
        return this.m_frameRect.dy;
    }

    public final void getRect(vRect rect, int iX, int iY) {
        short iHeight;
        short iWidth;
        int iRefY;
        int iRefX;
        if (this.m_spriteData == null) {
            if (this.m_pixels != null) {
                rect.set(iX, iY, this.m_pixels[this.m_pixels.length - 2], this.m_pixels[this.m_pixels.length - 1]);
                return;
            }
            rect.set(iX, iY, this.m_image.getWidth(), this.m_image.getHeight());
            return;
        }
        if (this.m_iAnim == -1) {
            iRefX = this.m_spriteData.imageRefX[this.m_iPaintFrame];
            iRefY = this.m_spriteData.imageRefY[this.m_iPaintFrame];
            iWidth = this.m_spriteData.imageFrameWidth[this.m_iPaintFrame];
            iHeight = this.m_spriteData.imageFrameHeight[this.m_iPaintFrame];
        } else {
            iRefX = this.m_spriteData.animRefX[this.m_iAnim];
            iRefY = this.m_spriteData.animRefY[this.m_iAnim];
            iWidth = this.m_spriteData.animWidth[this.m_iAnim];
            iHeight = this.m_spriteData.animHeight[this.m_iAnim];
        }
        if ((this.m_iFlags & 2) != 0) {
            iRefX = iWidth - 1 - iRefX;
        }
        if ((this.m_iFlags & 1) != 0) {
            iRefY = iHeight - 1 - iRefY;
        }
        rect.set(iX - iRefX, iY - iRefY, iWidth, iHeight);
    }

    public final void getPaintRect(vRect rect, int iX, int iY) {
        if (this.m_spriteData == null) {
            if (this.m_pixels != null) {
                rect.set(iX, iY, this.m_pixels[this.m_pixels.length - 2], this.m_pixels[this.m_pixels.length - 1]);
                return;
            }
            rect.set(iX, iY, this.m_image.getWidth(), this.m_image.getHeight());
            return;
        }
        int iRefX = this.m_spriteData.imageRefX[this.m_iPaintFrame] - this.m_spriteData.imageFrameX[this.m_iPaintFrame];
        int iRefY = this.m_spriteData.imageRefY[this.m_iPaintFrame] - this.m_spriteData.imageFrameY[this.m_iPaintFrame];
        short iPaintFrameSrcWidth = this.m_spriteData.imageSrcWidth[this.m_iPaintFrame];
        short iPaintFrameSrcHeight = this.m_spriteData.imageSrcHeight[this.m_iPaintFrame];
        if (this.m_iAnim != -1) {
            if ((this.m_spriteData.animFrameFlags[this.m_iAnim][this.m_iFrame] & 2) != 0) {
                iRefX = iPaintFrameSrcWidth - 1 - iRefX;
            }
            if ((this.m_spriteData.animFrameFlags[this.m_iAnim][this.m_iFrame] & 1) != 0) {
                iRefY = iPaintFrameSrcHeight - 1 - iRefY;
            }
            iRefX -= this.m_spriteData.animFrameX[this.m_iAnim][this.m_iFrame];
            iRefY -= this.m_spriteData.animFrameY[this.m_iAnim][this.m_iFrame];
        }
        if ((this.m_iFlags & 2) != 0) {
            iRefX = iPaintFrameSrcWidth - 1 - iRefX;
        }
        if ((this.m_iFlags & 1) != 0) {
            iRefY = iPaintFrameSrcHeight - 1 - iRefY;
        }
        rect.set(iX - iRefX, iY - iRefY, iPaintFrameSrcWidth, iPaintFrameSrcHeight);
    }

    public final boolean isFinished$134632() {
        if (this.m_spriteData != null && this.m_iAnim != -1) {
            if ((this.m_spriteData.animFlags[this.m_iAnim] & 0x40) != 0) {
                return false;
            }
            return this.m_iTime > this.m_iAnimEndTime;
        }
        return true;
    }

    public final void setReverseAnimation(boolean bReverse) {
        if (bReverse) {
            this.m_iFlags |= 4;
            return;
        }
        this.m_iFlags &= 0xFFFFFFFB;
    }

    public final void setVisible(boolean bVisible) {
        if (!bVisible) {
            this.m_iFlags |= 8;
            return;
        }
        this.m_iFlags &= 0xFFFFFFF7;
    }

    public final boolean isAnimationReversed() {
        return (this.m_iFlags & 4) != 0;
    }

    public final boolean isVisible() {
        return (this.m_iFlags & 8) == 0;
    }

    public final void setAnimation(int iAnim, int iTime) {
        if (iAnim == -1) {
            this.m_iAnim = iAnim;
            this.m_iFrame = this.m_iPaintFrame;
            this.m_iAnimStartTime = iTime;
            this.m_iAnimEndTime = iTime;
            this.updateFrameRect();
            this.updatePaintRect();
            this.updateRenderFlags();
            return;
        }
        this.m_iFrame = 0;
        this.m_iAnimStartTime = iTime;
        this.m_iAnimEndTime = iTime + this.getAnimationDuration(iAnim);
        this.m_iAnim = iAnim;
        this.setTime(this.m_iTime);
        this.updatePaintFrame();
        this.updateFrameRect();
        this.updatePaintRect();
        this.updateRenderFlags();
    }

    public final void setFrame(int iFrame) {
        if (this.m_spriteData == null) {
            return;
        }
        this.m_iFrame = iFrame;
        this.updatePaintFrame();
        this.updateFrameRect();
        this.updatePaintRect();
        this.updateRenderFlags();
    }

    public final boolean setTime(int iTime) {
        if (this.m_iAnim == -1) {
            return false;
        }
        if (this.m_spriteData == null) {
            System.out.println("VASSERT failed ::m_spriteData != null");
        }
        if (this.m_iAnim >= this.m_spriteData.iAnimCount) {
            System.out.println("VASSERT failed ::m_iAnim < m_spriteData.iAnimCount");
        }
        int iOld = this.m_iFrame;
        this.m_iTime = iTime;
        int iDeltaTime = this.m_iTime - this.m_iAnimStartTime;
        int iRate = this.m_spriteData.animFlags[this.m_iAnim] & 0x3F;
        int iFrame = iDeltaTime * iRate / 1000;
        if ((this.m_iFlags & 4) != 0) {
            iFrame = this.m_spriteData.animLength[this.m_iAnim] - iFrame - 1;
        }
        if ((this.m_spriteData.animFlags[this.m_iAnim] & 0x40) != 0) {
            byte iAnimLength = this.m_spriteData.animLength[this.m_iAnim];
            this.m_iFrame = iFrame < 0 ? (iFrame + 1) % iAnimLength + iAnimLength - 1 : iFrame % iAnimLength;
        } else {
            this.m_iFrame = iFrame < 0 ? 0 : (iFrame >= this.m_spriteData.animLength[this.m_iAnim] ? this.m_spriteData.animLength[this.m_iAnim] - 1 : iFrame);
        }
        if (this.m_iFrame < 0) {
            System.out.println("VASSERT failed ::m_iFrame >= 0");
        }
        if (this.m_iFrame >= this.m_spriteData.animLength[this.m_iAnim]) {
            System.out.println("VASSERT failed ::m_iFrame < m_spriteData.animLength[m_iAnim]");
        }
        if (iOld != this.m_iFrame) {
            this.updatePaintFrame();
            this.updateFrameRect();
            this.updatePaintRect();
            this.updateRenderFlags();
            return true;
        }
        return false;
    }

    public final boolean paint(vGraphics graphics) {
        return this.paint(graphics, this.m_iPosX, this.m_iPosY);
    }

    public final boolean paint(vGraphics graphics, int x, int y) {
        if ((this.m_iFlags & 8) != 0) {
            return false;
        }
        this.m_tempRect.set(this.m_paintRect);
        if (x != this.m_iPosX || y != this.m_iPosY) {
            this.getPaintRect(this.m_tempRect, x, y);
        }
        boolean bDrawn = this.m_spriteData == null ? (this.m_pixels != null ? graphics.drawPixels(this.m_pixels, this.m_tempRect.x, this.m_tempRect.y, this.m_iRenderFlags) : (this.m_iRenderFlags == 0 ? graphics.drawImage(this.m_image, this.m_tempRect.x, this.m_tempRect.y) : graphics.drawImage(this.m_image, this.m_tempRect.x, this.m_tempRect.y, this.m_iRenderFlags))) : (this.m_pixels != null ? graphics.drawPixels(this.m_pixels, this.m_tempRect.x, this.m_tempRect.y, this.m_tempRect.dx, this.m_tempRect.dy, this.m_spriteData.imageSrcX[this.m_iPaintFrame], this.m_spriteData.imageSrcY[this.m_iPaintFrame], this.m_iRenderFlags) : (this.m_iRenderFlags == 0 ? graphics.drawImage(this.m_image, this.m_tempRect.x, this.m_tempRect.y, this.m_tempRect.dx, this.m_tempRect.dy, this.m_spriteData.imageSrcX[this.m_iPaintFrame], this.m_spriteData.imageSrcY[this.m_iPaintFrame]) : graphics.drawImage(this.m_image, this.m_tempRect.x, this.m_tempRect.y, this.m_tempRect.dx, this.m_tempRect.dy, this.m_spriteData.imageSrcX[this.m_iPaintFrame], this.m_spriteData.imageSrcY[this.m_iPaintFrame], this.m_iRenderFlags)));
        return bDrawn;
    }

    public final boolean paint(vGraphics g, int x, int y, int iPaintFrame) {
        if (this.m_spriteData == null) {
            System.out.println("VASSERT failed ::m_spriteData != null");
        }
        if (iPaintFrame >= this.m_spriteData.iFrameCount) {
            System.out.println("VASSERT failed ::iPaintFrame < m_spriteData.iFrameCount");
        }
        if (this.m_pixels != null) {
            return g.drawPixels(this.m_pixels, x - (this.m_spriteData.imageRefX[iPaintFrame] - this.m_spriteData.imageFrameX[iPaintFrame]), y - (this.m_spriteData.imageRefY[iPaintFrame] - this.m_spriteData.imageFrameY[iPaintFrame]), this.m_spriteData.imageSrcWidth[iPaintFrame], this.m_spriteData.imageSrcHeight[iPaintFrame], this.m_spriteData.imageSrcX[iPaintFrame], this.m_spriteData.imageSrcY[iPaintFrame], this.m_iRenderFlags);
        }
        if (this.m_image == null) {
            System.out.println("VASSERT failed ::m_image != null");
        }
        if (this.m_iRenderFlags == 0) {
            return g.drawImage(this.m_image, x - (this.m_spriteData.imageRefX[iPaintFrame] - this.m_spriteData.imageFrameX[iPaintFrame]), y - (this.m_spriteData.imageRefY[iPaintFrame] - this.m_spriteData.imageFrameY[iPaintFrame]), this.m_spriteData.imageSrcWidth[iPaintFrame], this.m_spriteData.imageSrcHeight[iPaintFrame], this.m_spriteData.imageSrcX[iPaintFrame], this.m_spriteData.imageSrcY[iPaintFrame]);
        }
        return g.drawImage(this.m_image, x - (this.m_spriteData.imageRefX[iPaintFrame] - this.m_spriteData.imageFrameX[iPaintFrame]), y - (this.m_spriteData.imageRefY[iPaintFrame] - this.m_spriteData.imageFrameY[iPaintFrame]), this.m_spriteData.imageSrcWidth[iPaintFrame], this.m_spriteData.imageSrcHeight[iPaintFrame], this.m_spriteData.imageSrcX[iPaintFrame], this.m_spriteData.imageSrcY[iPaintFrame], this.m_iRenderFlags);
    }

    private void updateFrameRect() {
        this.getRect(this.m_frameRect, this.m_iPosX, this.m_iPosY);
    }

    private void updatePaintRect() {
        this.getPaintRect(this.m_paintRect, this.m_iPosX, this.m_iPosY);
    }

    private void updatePaintFrame() {
        if (this.m_iAnim == -1) {
            this.m_iPaintFrame = this.m_iFrame;
            return;
        }
        if (this.m_spriteData == null) {
            System.out.println("VASSERT failed ::m_spriteData != null");
        }
        this.m_iPaintFrame = this.m_spriteData.animFrameID[this.m_iAnim][this.m_iFrame];
    }

    private void updateRenderFlags() {
        this.m_iRenderFlags = 0;
        if (this.m_spriteData == null || this.m_iAnim == -1) {
            if ((this.m_iFlags & 2) != 0) {
                this.m_iRenderFlags |= Integer.MIN_VALUE;
            }
            if ((this.m_iFlags & 1) != 0) {
                this.m_iRenderFlags |= 0x40000000;
                return;
            }
        } else {
            byte iFlags;
            if ((this.m_iFlags & 2) != 0 ^ ((iFlags = this.m_spriteData.animFrameFlags[this.m_iAnim][this.m_iFrame]) & 2) != 0) {
                this.m_iRenderFlags |= Integer.MIN_VALUE;
            }
            if ((this.m_iFlags & 1) != 0 ^ (iFlags & 1) != 0) {
                this.m_iRenderFlags |= 0x40000000;
            }
        }
    }

    public final void save(DataOutputStream dos) throws IOException {
        dos.writeShort(0);
        dos.writeShort(1);
        dos.writeInt(this.m_iRenderFlags);
        dos.writeShort(this.m_iPosX);
        dos.writeShort(this.m_iPosY);
        dos.writeShort(this.m_iFlags);
        dos.writeByte(this.m_iAnim);
        if (this.m_iAnim != -1) {
            dos.writeInt(this.m_iTime);
            dos.writeInt(this.m_iAnimStartTime);
            return;
        }
        dos.writeByte(this.m_iFrame);
    }

    public final void open(DataInputStream dis) throws IOException {
        int uiMagicID = dis.readUnsignedShort();
        int uiVersion = dis.readUnsignedShort();
        if (uiMagicID != 0) {
            System.out.println("VASSERT failed ::uiMagicID == kMagicID");
        }
        if (uiVersion != 1) {
            System.out.println("VASSERT failed ::uiVersion == kVersion");
        }
        this.m_iRenderFlags = dis.readInt();
        this.m_iPosX = dis.readShort();
        this.m_iPosY = dis.readShort();
        this.m_iFlags = dis.readShort();
        this.m_iAnim = dis.readByte();
        if (this.m_iAnim != -1) {
            this.m_iTime = dis.readInt();
            this.m_iAnimStartTime = dis.readInt();
            this.m_iAnimEndTime = this.m_iAnimStartTime + this.getAnimationDuration(this.m_iAnim);
            this.setTime(this.m_iTime);
        } else {
            this.m_iFrame = dis.readByte();
        }
        this.updatePaintFrame();
        this.updateFrameRect();
        this.updatePaintRect();
    }

    public final int getWidth(int uiPaintFrame) {
        if (this.m_spriteData == null) {
            System.out.println("VASSERT failed ::m_spriteData != null");
        }
        if (uiPaintFrame >= this.m_spriteData.iFrameCount) {
            System.out.println("VASSERT failed ::uiPaintFrame < m_spriteData.iFrameCount");
        }
        return this.m_spriteData.imageFrameWidth[uiPaintFrame];
    }

    public final int getHeight(int uiPaintFrame) {
        if (this.m_spriteData == null) {
            System.out.println("VASSERT failed ::m_spriteData != null");
        }
        if (uiPaintFrame >= this.m_spriteData.iFrameCount) {
            System.out.println("VASSERT failed ::uiPaintFrame < m_spriteData.iFrameCount");
        }
        return this.m_spriteData.imageFrameHeight[uiPaintFrame];
    }
}

