/*
 * Decompiled with CFR 0.152.
 */
public final class vRect {
    public int x;
    public int y;
    public int dx;
    public int dy;

    public vRect() {
    }

    public vRect(int iX, int iY, int iWidth, int iHeight) {
        this.x = iX;
        this.y = iY;
        this.dx = iWidth;
        this.dy = iHeight;
    }

    public final void set(int iX, int iY, int iWidth, int iHeight) {
        this.x = iX;
        this.y = iY;
        this.dx = iWidth;
        this.dy = iHeight;
    }

    public final void set(vRect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.dx = rect.dx;
        this.dy = rect.dy;
    }

    public final void setEmpty() {
        this.dy = 0;
        this.dx = 0;
        this.y = 0;
        this.x = 0;
    }

    public final boolean intersect(vRect rect) {
        if (rect.x >= this.x + this.dx || rect.y >= this.y + this.dy || this.x >= rect.x + rect.dx || this.y >= rect.y + rect.dy) {
            this.dy = 0;
            this.dx = 0;
            this.y = 0;
            this.x = 0;
            return false;
        }
        if (this.x < rect.x) {
            this.dx -= rect.x - this.x;
            this.x = rect.x;
        }
        if (this.y < rect.y) {
            this.dy -= rect.y - this.y;
            this.y = rect.y;
        }
        if (this.x + this.dx > rect.x + rect.dx) {
            this.dx = rect.x + rect.dx - this.x;
        }
        if (this.y + this.dy > rect.y + rect.dy) {
            this.dy = rect.y + rect.dy - this.y;
        }
        return this.dx > 0 && this.dy > 0;
    }

    public final boolean intersects(vRect rect) {
        return rect.x < this.x + this.dx && rect.y < this.y + this.dy && this.x < rect.x + rect.dx && this.y < rect.y + rect.dy;
    }

    public final void unionRect(vRect rect) {
        this.unionRect(rect.x, rect.y, rect.dx, rect.dy);
    }

    private void unionRect(int iX, int iY, int iWidth, int iHeight) {
        int right = this.x + this.dx;
        int r_right = iX + iWidth;
        if (iX < this.x) {
            this.x = iX;
        }
        this.dx = right > r_right ? right - this.x : r_right - this.x;
        int bottom = this.y + this.dy;
        int r_bottom = iY + iHeight;
        if (iY < this.y) {
            this.y = iY;
        }
        if (bottom > r_bottom) {
            this.dy = bottom - this.y;
            return;
        }
        this.dy = r_bottom - this.y;
    }

    public final boolean contains(int iX, int iY) {
        return iX >= this.x && iY >= this.y && iX < this.x + this.dx && iY < this.y + this.dy;
    }

    public final boolean contains(vRect rect) {
        return rect.x >= this.x && rect.y >= this.y && rect.x + rect.dx <= this.x + this.dx && rect.dy <= this.y + this.dy;
    }

    public final boolean isEqual(vRect rect) {
        return this.x == rect.x && this.y == rect.y && this.dx == rect.dx && this.dy == rect.dy;
    }

    public final String toString() {
        return new String("{ x=" + this.x + " y=" + this.y + " dx=" + this.dx + " dy=" + this.dy + " }");
    }
}

