/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Entity
extends vNode {
    private vBaseCanvas m_canvas;
    public short m_iRefCount;
    public Engine m_pEngine;
    public Sector m_pSector;
    public int m_iUniqueIndex;
    public int m_iCRC32;
    public final Definition m_definition;
    public int m_fpSortValue;
    public int m_fpSortBias;
    public vVector3 m_position = new vVector3();
    public int m_iFlags;
    public int[] m_pPropertyListData;
    private byte[] m_pEventInfo_type;
    private byte[] m_pEventInfo_depid;
    private int[][] m_pEventInfo_trigdata;
    private Entity[] m_pUserEntities;
    private vSprite[] m_pUserSprites;
    private short[] m_iUserSpritesFile;
    private byte[] m_iUserSpritesImage;
    private byte[] m_iUserSpritesData;
    private byte[] m_iUserSpritesPal;
    private byte m_iNumWaypoints;
    private int[] m_pWaypointsTime;
    private byte[] m_pWaypointsX;
    private byte[] m_pWaypointsY;
    public short m_iScreenX;
    public short m_iScreenY;
    private byte m_iNumEvents;
    private short m_iPropertyListSize;
    private byte m_iFacing;
    public byte m_eMovableFacing;
    public byte m_iWidth;
    public byte m_iHeight;
    public byte m_iTileX;
    public byte m_iTileY;
    private byte m_iBBHeightInTiles;
    private byte m_iMovableSrcX;
    private byte m_iMovableSrcY;
    private byte m_iMovableDstX;
    private byte m_iMovableDstY;
    private boolean m_bMoving;
    private boolean m_bContinueMoving;

    public final void addRef() {
        this.m_iRefCount = (short)(this.m_iRefCount + 1);
    }

    public final boolean release() {
        this.m_iRefCount = (short)(this.m_iRefCount - 1);
        return this.m_iRefCount <= 0;
    }

    protected Entity(vBaseCanvas canvas, Engine pGameEngine, Definition definition, int iUniqueIndex) {
        this.m_canvas = canvas;
        this.m_pEngine = pGameEngine;
        this.m_iUniqueIndex = iUniqueIndex;
        this.m_definition = definition;
        this.m_iFlags = definition.m_iFlags;
        this.m_iWidth = definition.m_iWidth;
        this.m_iHeight = definition.m_iHeight;
        this.m_iBBHeightInTiles = (byte)-1;
        this.m_fpSortBias = 32768;
    }

    protected final void init(DataInputStream dis, int iTime) throws IOException {
        byte iInit;
        this.m_iCRC32 = dis.readInt();
        this.m_iTileX = dis.readByte();
        this.m_iTileY = dis.readByte();
        this.m_position.x = vBaseCanvas.intToFP(this.m_iTileX);
        this.m_position.y = vBaseCanvas.intToFP(this.m_iTileY);
        this.m_position.z = 0;
        this.updateCache();
        this.readEvents(dis);
        this.readWaypoints(dis);
        this.m_iPropertyListSize = this.m_definition.m_iPropertyListSize;
        if (this.m_iPropertyListSize > 0) {
            this.m_pPropertyListData = new int[this.m_iPropertyListSize];
            for (int i = 0; i < this.m_iPropertyListSize; ++i) {
                this.m_pPropertyListData[i] = this.m_definition.m_pDefaultPropertyValues[i];
            }
        }
        if ((this.m_iFlags & 0x20) != 0) {
            this.m_iFacing = this.m_definition.m_iFacing;
            this.m_eMovableFacing = this.m_definition.m_iFacing;
            this.m_bMoving = false;
            this.m_bContinueMoving = false;
        }
        if ((this.m_iFlags & 0x10) != 0) {
            this.m_pEngine.markTilesAsOccupied(this, true);
        }
        if ((iInit = this.m_definition.m_iOnInit) != -1) {
            this.m_pEngine.callFunctionByIndex(iInit, this, iTime, 0, null);
        }
    }

    public final void shutdown() throws IOException {
        byte iShutdown = this.m_definition.m_iOnShutdown;
        if (iShutdown != -1) {
            this.m_pEngine.callFunctionByIndex(iShutdown, this, 0, 0, null);
        }
        this.releaseUserEntities();
        this.m_pWaypointsTime = null;
        this.m_pWaypointsX = null;
        this.m_pWaypointsY = null;
        this.m_pEventInfo_type = null;
        this.m_pEventInfo_depid = null;
        this.m_pEventInfo_trigdata = null;
        this.m_pPropertyListData = null;
    }

    protected final void releaseUserEntities() throws IOException {
        if (this.m_pUserEntities == null) {
            return;
        }
        int size = this.m_pUserEntities.length;
        for (int i = 0; i < size; ++i) {
            if (this.m_pUserEntities[i] == null) continue;
            this.m_pEngine.releaseEntity(this.m_pUserEntities[i]);
            this.m_pUserEntities[i] = null;
        }
    }

    private void readEvents(DataInputStream dis) throws IOException {
        this.m_iNumEvents = (byte)dis.readUnsignedByte();
        if (this.m_iNumEvents > 0) {
            this.m_pEventInfo_type = new byte[this.m_iNumEvents];
            this.m_pEventInfo_depid = new byte[this.m_iNumEvents];
            this.m_pEventInfo_trigdata = new int[this.m_iNumEvents][];
            for (int i = 0; i < this.m_iNumEvents; ++i) {
                this.m_pEventInfo_type[i] = (byte)dis.readShort();
                this.m_pEventInfo_depid[i] = (byte)dis.readShort();
                int iNumTriggers = dis.readUnsignedByte();
                if (iNumTriggers <= 0) continue;
                this.m_pEventInfo_trigdata[i] = new int[1 + (iNumTriggers << 1)];
                this.m_pEventInfo_trigdata[i][0] = iNumTriggers;
                for (int j = 0; j < iNumTriggers; ++j) {
                    int iTriggerIndex = dis.readInt();
                    int iTriggerArgument = dis.readInt();
                    int iOffset = j << 1;
                    this.m_pEventInfo_trigdata[i][1 + iOffset] = iTriggerIndex;
                    this.m_pEventInfo_trigdata[i][2 + iOffset] = iTriggerArgument;
                }
            }
        }
    }

    private void readWaypoints(DataInputStream dis) throws IOException {
        this.m_iNumWaypoints = (byte)dis.readUnsignedByte();
        int iNumWaypoints = this.m_iNumWaypoints & 0xFFFFFF7F;
        if (iNumWaypoints > 0) {
            this.m_pWaypointsTime = new int[iNumWaypoints];
            this.m_pWaypointsX = new byte[iNumWaypoints];
            this.m_pWaypointsY = new byte[iNumWaypoints];
            for (int i = 0; i < iNumWaypoints; ++i) {
                this.m_pWaypointsX[i] = (byte)dis.readUnsignedByte();
                this.m_pWaypointsY[i] = (byte)dis.readUnsignedByte();
                this.m_pWaypointsTime[i] = dis.readInt();
            }
        }
    }

    protected final void save(DataOutputStream dos) throws IOException {
        int i;
        dos.writeInt(this.m_iUniqueIndex);
        dos.writeInt(this.m_definition.m_iDefinitionCRC32);
        dos.writeShort(61306);
        dos.writeShort(10);
        dos.writeInt(this.m_iCRC32);
        dos.writeInt(this.m_iFlags);
        dos.writeInt(this.m_position.x);
        dos.writeInt(this.m_position.y);
        dos.writeInt(this.m_position.z);
        dos.writeInt(this.m_fpSortBias);
        dos.writeByte(this.m_iWidth);
        dos.writeByte(this.m_iHeight);
        if (this.m_iPropertyListSize > 0) {
            int j;
            int iChangedBits = 0;
            int iLength = 0;
            int iBaseIndex = 0;
            for (i = 0; i < this.m_iPropertyListSize; ++i) {
                if (this.m_pPropertyListData[i] != this.m_definition.m_pDefaultPropertyValues[i]) {
                    iChangedBits |= 1 << iLength;
                }
                if (++iLength != 8) continue;
                dos.writeByte(iChangedBits);
                if (iChangedBits != 0) {
                    for (j = 0; j < 8; ++j) {
                        if ((iChangedBits & 1 << j) == 0) continue;
                        dos.writeInt(this.m_pPropertyListData[iBaseIndex + j]);
                    }
                }
                iBaseIndex += 8;
                iChangedBits = 0;
                iLength = 0;
            }
            if (iLength != 0) {
                dos.writeByte(iChangedBits);
                if (iChangedBits != 0) {
                    for (j = 0; j < 8; ++j) {
                        if ((iChangedBits & 1 << j) == 0) continue;
                        dos.writeInt(this.m_pPropertyListData[iBaseIndex + j]);
                    }
                }
            }
        }
        dos.writeByte(this.m_iNumEvents);
        for (i = 0; i < this.m_iNumEvents; ++i) {
            dos.writeShort(this.m_pEventInfo_type[i]);
            dos.writeShort(this.m_pEventInfo_depid[i]);
            if (this.m_pEventInfo_trigdata[i] != null) {
                int iNumTriggers = this.m_pEventInfo_trigdata[i][0];
                dos.writeByte(iNumTriggers);
                for (int j = 0; j < iNumTriggers; ++j) {
                    int iOffset = j << 1;
                    byte iTriggerIndex = (byte)this.m_pEventInfo_trigdata[i][1 + iOffset];
                    int iTriggerArgument = this.m_pEventInfo_trigdata[i][2 + iOffset];
                    dos.writeInt(iTriggerIndex);
                    dos.writeInt(iTriggerArgument);
                }
                continue;
            }
            dos.writeByte(0);
        }
        dos.writeByte(this.m_iNumWaypoints);
        int iNumWaypoints = this.m_iNumWaypoints & 0xFFFFFF7F;
        if (iNumWaypoints > 0) {
            for (i = 0; i < iNumWaypoints; ++i) {
                dos.writeByte(this.m_pWaypointsX[i]);
                dos.writeByte(this.m_pWaypointsY[i]);
                dos.writeInt(this.m_pWaypointsTime[i]);
            }
        }
        if (this.isMovable()) {
            dos.writeByte(this.m_iFacing);
            dos.writeByte(this.m_eMovableFacing);
            dos.writeByte(this.m_iMovableSrcX);
            dos.writeByte(this.m_iMovableSrcY);
            dos.writeByte(this.m_iMovableDstX);
            dos.writeByte(this.m_iMovableDstY);
            dos.writeBoolean(this.m_bMoving);
            dos.writeBoolean(this.m_bContinueMoving);
        }
    }

    protected final void open(DataInputStream dis) throws IOException {
        int iMagicID = dis.readUnsignedShort();
        int iVersion = dis.readUnsignedShort();
        if (iMagicID != 61306) {
            System.out.println("VASSERT failed ::iMagicID == kMagicID");
        }
        if (iVersion != 10) {
            System.out.println("VASSERT failed ::iVersion == kVersion");
        }
        this.m_iCRC32 = dis.readInt();
        this.m_iFlags = dis.readInt();
        this.m_position.x = dis.readInt();
        this.m_position.y = dis.readInt();
        this.m_position.z = dis.readInt();
        this.m_fpSortBias = dis.readInt();
        this.m_iWidth = (byte)dis.readUnsignedByte();
        this.m_iHeight = (byte)dis.readUnsignedByte();
        this.updateCache();
        this.m_iPropertyListSize = this.m_definition.m_iPropertyListSize;
        if (this.m_iPropertyListSize > 0) {
            this.m_pPropertyListData = new int[this.m_iPropertyListSize];
            for (int i = 0; i < this.m_iPropertyListSize; ++i) {
                this.m_pPropertyListData[i] = this.m_definition.m_pDefaultPropertyValues[i];
            }
            short iBaseIndex = 0;
            int iAlteredByte = 0;
            int iLength = 8;
            do {
                if (iLength == 8) {
                    iAlteredByte = dis.readUnsignedByte();
                    if (iAlteredByte == 0) {
                        iBaseIndex += 8;
                        continue;
                    }
                    iLength = 0;
                }
                if ((iAlteredByte & 1 << iLength) != 0) {
                    this.m_pPropertyListData[iBaseIndex] = dis.readInt();
                }
                ++iLength;
                ++iBaseIndex;
            } while (iBaseIndex < this.m_iPropertyListSize);
        }
        this.readEvents(dis);
        this.readWaypoints(dis);
        if (this.isMovable()) {
            this.m_iFacing = (byte)dis.readUnsignedByte();
            this.m_eMovableFacing = (byte)dis.readUnsignedByte();
            this.m_iMovableSrcX = (byte)dis.readUnsignedByte();
            this.m_iMovableSrcY = (byte)dis.readUnsignedByte();
            this.m_iMovableDstX = (byte)dis.readUnsignedByte();
            this.m_iMovableDstY = (byte)dis.readUnsignedByte();
            this.m_bMoving = dis.readBoolean();
            this.m_bContinueMoving = dis.readBoolean();
        }
        if ((this.m_iFlags & 0x10) != 0) {
            this.m_pEngine.markTilesAsOccupied(this, true);
        }
        this.updateCache();
        if (this.m_pSector != null) {
            this.m_pSector.remove(this);
            this.m_pSector = null;
        }
    }

    final void postSave(DataOutputStream dos) throws IOException {
        vSprite pSprite;
        int i;
        int iValidBits = 0;
        int iLength = 0;
        int entSize = this.m_pUserEntities != null ? this.m_pUserEntities.length : 0;
        for (i = 0; i < entSize; ++i) {
            Entity pEntity = this.m_pUserEntities[i];
            if (pEntity != null) {
                iValidBits |= 1 << iLength;
            }
            ++iLength;
        }
        int sprSize = this.m_pUserSprites != null ? this.m_pUserSprites.length : 0;
        for (i = 0; i < sprSize; ++i) {
            pSprite = this.m_pUserSprites[i];
            if (pSprite != null) {
                iValidBits |= 1 << iLength;
            }
            ++iLength;
        }
        dos.writeByte(iValidBits);
        dos.writeByte(entSize);
        dos.writeByte(sprSize);
        for (i = 0; i < entSize; ++i) {
            Entity pEntity = this.m_pUserEntities[i];
            if (pEntity == null) continue;
            dos.writeInt(pEntity.m_iUniqueIndex);
        }
        for (i = 0; i < sprSize; ++i) {
            pSprite = this.m_pUserSprites[i];
            if (pSprite == null) continue;
            pSprite.save(dos);
            dos.writeShort(this.m_iUserSpritesFile[i]);
            dos.writeByte(this.m_iUserSpritesImage[i]);
            dos.writeByte(this.m_iUserSpritesData[i]);
            dos.writeByte(this.m_iUserSpritesPal[i]);
        }
    }

    protected final void postOpen(DataInputStream dis, int iTime) throws IOException {
        int i;
        int sprSize;
        int iValidBits = dis.readUnsignedByte();
        int entSize = dis.readUnsignedByte();
        if (entSize > 0) {
            this.m_pUserEntities = new Entity[entSize];
        }
        if ((sprSize = dis.readUnsignedByte()) > 0) {
            this.m_pUserSprites = new vSprite[sprSize];
            this.m_iUserSpritesFile = new short[sprSize];
            this.m_iUserSpritesImage = new byte[sprSize];
            this.m_iUserSpritesData = new byte[sprSize];
            this.m_iUserSpritesPal = new byte[sprSize];
        }
        int iLength = 0;
        for (i = 0; i < entSize; ++i) {
            if ((iValidBits & 1 << iLength) != 0) {
                int iUniqueIndex = dis.readInt();
                this.m_pUserEntities[i] = this.m_pEngine.getEntityByUniqueIndex(iUniqueIndex);
                if (this.m_pUserEntities[i] == null) {
                    System.out.println("VASSERT failed ::m_pUserEntities[i] != null");
                }
                Engine.acquireEntity(this.m_pUserEntities[i]);
            }
            ++iLength;
        }
        byte iInit = this.m_definition.m_iOnInit;
        if (iInit != -1) {
            this.m_pEngine.callFunctionByIndex(iInit, this, iTime, 1, null);
        }
        for (i = 0; i < sprSize; ++i) {
            if ((iValidBits & 1 << iLength) != 0) {
                if (this.m_pUserSprites[i] == null) {
                    System.out.println("VASSERT failed ::m_pUserSprites[i] != null");
                }
                this.m_pUserSprites[i].open(dis);
                this.m_iUserSpritesFile[i] = dis.readShort();
                this.m_iUserSpritesImage[i] = dis.readByte();
                this.m_iUserSpritesData[i] = dis.readByte();
                this.m_iUserSpritesPal[i] = dis.readByte();
            }
            ++iLength;
        }
    }

    final void onEvent(Entity pSender, byte eEvent, int iTime) throws IOException {
        byte tableID;
        int iEventIndex = this.getInfoForEvent(eEvent);
        if (iEventIndex != -1 && (tableID = this.m_pEventInfo_depid[iEventIndex]) != -1 && !this.m_pEngine.getDependencyTable(tableID)) {
            System.out.println("Event " + eEvent + " blocked by dependency table " + tableID);
            return;
        }
        byte iEvent = this.m_definition.m_iOnEvent;
        if (iEvent != -1) {
            this.m_pEngine.callFunctionByIndex(iEvent, this, eEvent, iTime, pSender);
        }
        if (iEventIndex != -1 && this.m_pEventInfo_trigdata[iEventIndex] != null) {
            int iNumTriggers = this.m_pEventInfo_trigdata[iEventIndex][0];
            for (int i = 0; i < iNumTriggers; ++i) {
                int iOffset = i << 1;
                byte iTrigger = (byte)this.m_pEventInfo_trigdata[iEventIndex][1 + iOffset];
                int iArgument = this.m_pEventInfo_trigdata[iEventIndex][2 + iOffset];
                if (iTrigger == -1) continue;
                this.m_pEngine.callTriggerByIndex(iTrigger, this, iArgument, iTime);
            }
        }
    }

    public final boolean isVisible() {
        return (this.m_iFlags & 1) != 0;
    }

    public final void setVisible(boolean bVis) {
        if (bVis) {
            this.m_iFlags |= 1;
            return;
        }
        this.m_iFlags &= 0xFFFFFFFE;
    }

    public final void setCollidable(boolean bCollidable) {
        if (bCollidable) {
            this.m_iFlags |= 2;
            return;
        }
        this.m_iFlags &= 0xFFFFFFFD;
    }

    public final boolean doesOccupy() {
        return (this.m_iFlags & 0x10) != 0;
    }

    public final boolean setOccupies(boolean bOccupy) {
        boolean bCurrentlyOccupies = (this.m_iFlags & 0x10) != 0;
        if (bCurrentlyOccupies != bOccupy) {
            if (bOccupy && this.m_pEngine.areTilesOccupied(this)) {
                return false;
            }
            this.m_pEngine.markTilesAsOccupied(this, bOccupy);
            this.m_iFlags = bOccupy ? (this.m_iFlags |= 0x10) : (this.m_iFlags &= 0xFFFFFFEF);
        }
        return true;
    }

    public final boolean isMovable() {
        return (this.m_iFlags & 0x20) != 0;
    }

    public final void setRenderingAsFloor(boolean bRenderAsFloor) {
        if (bRenderAsFloor) {
            this.m_iFlags |= 0x100;
            return;
        }
        this.m_iFlags &= 0xFFFFFEFF;
    }

    public final int getUserFlags() {
        return this.m_iFlags & 0xFFFF0000;
    }

    public final void setUserFlags(int iFlags) {
        if ((iFlags & 0xFFFF) != 0) {
            System.out.println("VASSERT failed ::(iFlags & ~Definition.kFlags_UserMask) == 0");
        }
        this.m_iFlags &= 0xFFFF;
        this.m_iFlags |= iFlags;
    }

    public final vSprite getUserSprite(int iIndex) {
        if (this.m_pUserSprites == null || iIndex >= this.m_pUserSprites.length) {
            return null;
        }
        return this.m_pUserSprites[iIndex];
    }

    public final void setUserSprite(int iIndex, vSprite pSprite, int iFile, int iImageIndex, int iDataIndex, int iPalIndex) {
        if (this.m_pUserSprites == null || iIndex >= this.m_pUserSprites.length) {
            vSprite[] newSprites = new vSprite[iIndex + 1];
            short[] newFiles = new short[iIndex + 1];
            byte[] newImages = new byte[iIndex + 1];
            byte[] newData = new byte[iIndex + 1];
            byte[] newPals = new byte[iIndex + 1];
            if (this.m_pUserSprites != null) {
                System.arraycopy(this.m_pUserSprites, 0, newSprites, 0, this.m_pUserSprites.length);
                System.arraycopy(this.m_iUserSpritesFile, 0, newFiles, 0, this.m_iUserSpritesFile.length);
                System.arraycopy(this.m_iUserSpritesImage, 0, newImages, 0, this.m_iUserSpritesImage.length);
                System.arraycopy(this.m_iUserSpritesData, 0, newData, 0, this.m_iUserSpritesData.length);
                System.arraycopy(this.m_iUserSpritesPal, 0, newPals, 0, this.m_iUserSpritesPal.length);
            }
            this.m_pUserSprites = newSprites;
            this.m_iUserSpritesFile = newFiles;
            this.m_iUserSpritesImage = newImages;
            this.m_iUserSpritesData = newData;
            this.m_iUserSpritesPal = newPals;
        }
        this.m_pUserSprites[iIndex] = pSprite;
        this.m_iUserSpritesFile[iIndex] = (short)iFile;
        this.m_iUserSpritesImage[iIndex] = (byte)iImageIndex;
        this.m_iUserSpritesData[iIndex] = (byte)iDataIndex;
        this.m_iUserSpritesPal[iIndex] = (byte)iPalIndex;
    }

    public final void deallocateUserSprites() {
        if (this.m_pUserSprites == null) {
            return;
        }
        int size = this.m_pUserSprites.length;
        for (int i = 0; i < size; ++i) {
            if (this.m_pUserSprites[i] == null) continue;
            this.m_pUserSprites[i].free();
        }
    }

    public final void reallocateUserSprites() throws IOException {
        if (this.m_pUserSprites == null) {
            return;
        }
        this.deallocateUserSprites();
        int size = this.m_pUserSprites.length;
        for (int i = 0; i < size; ++i) {
            if (this.m_pUserSprites[i] == null) continue;
            if (this.m_iUserSpritesPal[i] >= 0) {
                this.m_pUserSprites[i].m_pixels = vBaseCanvas.loadPalPixels(this.m_iUserSpritesFile[i], this.m_iUserSpritesImage[i], this.m_iUserSpritesFile[i], this.m_iUserSpritesPal[i]);
            } else {
                this.m_pUserSprites[i].m_image = vBaseCanvas.loadImage(this.m_iUserSpritesFile[i], this.m_iUserSpritesImage[i]);
            }
            this.m_pUserSprites[i].m_spriteData = this.m_canvas.loadSpriteData(this.m_iUserSpritesFile[i], this.m_iUserSpritesData[i]);
        }
    }

    public final Entity getUserEntity(int iIndex) {
        if (this.m_pUserEntities == null || iIndex >= this.m_pUserEntities.length) {
            return null;
        }
        return this.m_pUserEntities[iIndex];
    }

    public final void setUserEntity(int iIndex, Entity pEntity) throws IOException {
        if (this.m_pUserEntities == null || iIndex >= this.m_pUserEntities.length) {
            Entity[] newArray = new Entity[iIndex + 1];
            if (this.m_pUserEntities != null) {
                System.arraycopy(this.m_pUserEntities, 0, newArray, 0, this.m_pUserEntities.length);
            }
            this.m_pUserEntities = newArray;
        }
        if (this.m_pUserEntities[iIndex] != null) {
            this.m_pEngine.releaseEntity(this.m_pUserEntities[iIndex]);
        }
        this.m_pUserEntities[iIndex] = pEntity;
        if (pEntity != null) {
            Engine.acquireEntity(pEntity);
        }
    }

    public final int getProperty(int iIndex) {
        if (this.m_pPropertyListData == null) {
            System.out.println("VASSERT failed ::m_pPropertyListData != null");
        }
        if (iIndex < 0 || iIndex >= this.m_iPropertyListSize) {
            System.out.println("VASSERT failed ::iIndex >= 0 && iIndex < m_iPropertyListSize");
        }
        return this.m_pPropertyListData[iIndex];
    }

    public final void setProperty(int iIndex, int iValue) {
        if (this.m_pPropertyListData == null) {
            System.out.println("VASSERT failed ::m_pPropertyListData != null");
        }
        if (iIndex < 0 || iIndex >= this.m_iPropertyListSize) {
            System.out.println("VASSERT failed ::iIndex >= 0 && iIndex < m_iPropertyListSize");
        }
        this.m_pPropertyListData[iIndex] = iValue;
    }

    public final int getX() {
        return this.m_position.x;
    }

    public final int getY() {
        return this.m_position.y;
    }

    public final int getZ() {
        return this.m_position.z;
    }

    public final void getRect(vRect outRect) {
        outRect.x = this.m_iTileX;
        outRect.y = this.m_iTileY - this.m_iHeight + 1;
        outRect.dx = this.m_iWidth;
        outRect.dy = this.m_iHeight;
    }

    public final byte getConversationID() {
        if ((this.m_iFlags & 0x80) != 0) {
            int iPropertyIndex = (this.m_iFlags & 0x40) != 0 ? 5 : 0;
            return (byte)this.getProperty(iPropertyIndex);
        }
        System.out.println("VASSERT_MSG failed ::false | WARNING . you are querying for a conversation from an entity that doesn't support it...");
        return -1;
    }

    public final void setConversationID(byte id) {
        if ((this.m_iFlags & 0x80) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & Definition.kFlags_IsConversation) != 0");
        }
        if (id >= this.m_definition.m_iSnippetListSize + this.m_definition.m_iSnippetCollectionListSize) {
            System.out.println("VASSERT failed ::id < m_definition.getSnippetCount()+m_definition.getSnippetCollectionCount()");
        }
        int iPropertyIndex = (this.m_iFlags & 0x40) != 0 ? 5 : 0;
        this.setProperty(iPropertyIndex, id);
    }

    public final byte getFacing() {
        if ((this.m_iFlags & 0x20) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & Definition.kFlags_IsMovable) != 0");
        }
        return this.m_iFacing;
    }

    public final void setFacing(byte iFacing) {
        if ((this.m_iFlags & 0x20) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & Definition.kFlags_IsMovable) != 0");
        }
        if (this.isMoving()) {
            System.out.println("VASSERT failed ::!isMoving()");
        }
        this.m_iFacing = iFacing;
    }

    public final boolean isMoving() {
        if ((this.m_iFlags & 0x20) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & Definition.kFlags_IsMovable) != 0");
        }
        return this.m_bMoving;
    }

    public final boolean beginMoving(byte eMovement) {
        if ((this.m_iFlags & 0x20) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & Definition.kFlags_IsMovable) != 0");
        }
        if (this.isMoving()) {
            System.out.println("VASSERT failed ::!isMoving()");
        }
        byte iDstTileX = this.m_iTileX;
        byte iDstTileY = this.m_iTileY;
        this.m_eMovableFacing = eMovement;
        this.m_iMovableSrcX = iDstTileX;
        this.m_iMovableSrcY = iDstTileY;
        switch (this.m_eMovableFacing) {
            case 0: {
                iDstTileX = (byte)(iDstTileX + 1);
                break;
            }
            case 1: {
                iDstTileY = (byte)(iDstTileY - 1);
                break;
            }
            case 2: {
                iDstTileY = (byte)(iDstTileY + 1);
                break;
            }
            case 3: {
                iDstTileX = (byte)(iDstTileX - 1);
            }
        }
        this.m_iMovableDstX = iDstTileX;
        this.m_iMovableDstY = iDstTileY;
        if ((this.m_iFlags & 0x10) != 0) {
            if (this.m_pEngine.areTilesOccupied(this, iDstTileX, iDstTileY)) {
                return false;
            }
            this.m_pEngine.markTilesAsOccupied(this, iDstTileX, iDstTileY, true);
        }
        this.m_bMoving = true;
        this.m_bContinueMoving = true;
        return true;
    }

    public final void endMoving() {
        if ((this.m_iFlags & 0x20) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & Definition.kFlags_IsMovable) != 0");
        }
        this.m_bContinueMoving = false;
    }

    public final boolean processMoving(int fpDistance, int iTime) throws IOException {
        if (fpDistance == 0) {
            return false;
        }
        if ((this.m_iFlags & 0x20) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & Definition.kFlags_IsMovable) != 0");
        }
        if (!this.isMoving()) {
            System.out.println("VASSERT failed ::isMoving()");
        }
        int fpOldX = this.m_position.x;
        int fpOldY = this.m_position.y;
        switch (this.m_eMovableFacing) {
            case 0: {
                this.m_position.x += fpDistance;
                break;
            }
            case 1: {
                this.m_position.y -= fpDistance;
                break;
            }
            case 2: {
                this.m_position.y += fpDistance;
                break;
            }
            case 3: {
                this.m_position.x -= fpDistance;
            }
        }
        int fpHalfTileX = vBaseCanvas.intToFP(vBaseCanvas.toInt(this.m_position.x + 32768));
        int fpHalfTileY = vBaseCanvas.intToFP(vBaseCanvas.toInt(this.m_position.y + 32768));
        boolean bNewTile = false;
        if (fpOldX > fpHalfTileX && this.m_position.x <= fpHalfTileX || fpOldX < fpHalfTileX && this.m_position.x >= fpHalfTileX || fpOldY > fpHalfTileY && this.m_position.y <= fpHalfTileY || fpOldY < fpHalfTileY && this.m_position.y >= fpHalfTileY) {
            this.m_position.x = fpHalfTileX;
            this.m_position.y = fpHalfTileY;
            this.updateCache();
            bNewTile = true;
            if ((this.m_iFlags & 0x10) != 0) {
                this.m_pEngine.markTilesAsOccupied(this, this.m_iMovableSrcX, this.m_iMovableSrcY, false);
                this.m_pEngine.markTilesAsOccupied(this, this.m_iMovableDstX, this.m_iMovableDstY, false);
                this.m_pEngine.markTilesAsOccupied(this, this.m_iTileX, this.m_iTileY, true);
            }
            if ((this.m_iFlags & 2) != 0) {
                this.m_pEngine.checkForEntityCollision(this, iTime);
            }
            if (this.m_bMoving) {
                this.m_bMoving = false;
                if (this.m_bContinueMoving) {
                    this.beginMoving(this.m_eMovableFacing);
                }
            }
        } else {
            this.updateCache();
        }
        return bNewTile;
    }

    public final boolean terminateMoving() {
        if (!this.isMoving()) {
            return false;
        }
        if ((this.m_iFlags & 0x10) != 0) {
            this.m_pEngine.markTilesAsOccupied(this, this.m_iMovableSrcX, this.m_iMovableSrcY, false);
            this.m_pEngine.markTilesAsOccupied(this, this.m_iMovableDstX, this.m_iMovableDstY, false);
        }
        this.updateCache();
        this.m_pEngine.markTilesAsOccupied(this, this.m_iTileX, this.m_iTileY, true);
        this.m_bMoving = false;
        this.m_bContinueMoving = false;
        return true;
    }

    public final int getNumWaypoints() {
        return this.m_iNumWaypoints & 0xFFFFFF7F;
    }

    public final boolean doWaypointsLoop() {
        return (this.m_iNumWaypoints & 0x80) != 0;
    }

    public final int getWaypointX(int iIndex) {
        if (iIndex < 0) {
            System.out.println("VASSERT failed ::iIndex >= 0");
        }
        if (iIndex >= this.getNumWaypoints()) {
            System.out.println("VASSERT failed ::iIndex < getNumWaypoints()");
        }
        return this.m_pWaypointsX[iIndex];
    }

    public final int getWaypointY(int iIndex) {
        if (iIndex < 0) {
            System.out.println("VASSERT failed ::iIndex >= 0");
        }
        if (iIndex >= this.getNumWaypoints()) {
            System.out.println("VASSERT failed ::iIndex < getNumWaypoints()");
        }
        return this.m_pWaypointsY[iIndex];
    }

    public final int getWaypointTime(int iIndex) {
        if (iIndex < 0) {
            System.out.println("VASSERT failed ::iIndex >= 0");
        }
        if (iIndex >= this.getNumWaypoints()) {
            System.out.println("VASSERT failed ::iIndex < getNumWaypoints()");
        }
        return this.m_pWaypointsTime[iIndex];
    }

    public final void updateCache() {
        byte iOldTileX = this.m_iTileX;
        byte iOldTileY = this.m_iTileY;
        this.m_iTileX = (byte)vBaseCanvas.toInt(this.m_position.x + 32768);
        this.m_iTileY = (byte)vBaseCanvas.toInt(this.m_position.y + 32768);
        if (iOldTileX != this.m_iTileX || iOldTileY != this.m_iTileY) {
            Sector pOldSector = this.m_pSector;
            this.m_pSector = this.m_pEngine.getSector(this.m_iTileX, this.m_iTileY);
            if (this.m_pSector != pOldSector) {
                if (pOldSector != null) {
                    pOldSector.remove(this);
                }
                if (this.m_pSector != null) {
                    this.m_pSector.add(this);
                }
            }
            if (this.m_pSector == null) {
                this.m_pSector = this.m_pEngine.addToMasterSector(this);
            }
        }
        this.m_pEngine.worldToScreen(this.m_position);
        this.m_iScreenX = (short)this.m_pEngine.m_iWorldToScreenX;
        this.m_iScreenY = (short)this.m_pEngine.m_iWorldToScreenY;
        int fpLevelWidth = vBaseCanvas.intToFP(this.m_pEngine.m_iLevelWidth);
        int fpTileX = vBaseCanvas.intToFP(this.m_iTileX);
        int fpTileY = vBaseCanvas.intToFP(this.m_iTileY);
        this.m_fpSortValue = vBaseCanvas.mul(fpTileY, fpLevelWidth) + fpTileX + this.m_fpSortBias;
    }

    public final void updateBoundingBox$255f295(int iPixelsTall) {
        int iTileHeightInPixels = this.m_pEngine.m_iTilePixelY;
        int iBBHeightInTiles = (iPixelsTall + iTileHeightInPixels - 1) / iTileHeightInPixels;
        if (iBBHeightInTiles >= 256) {
            System.out.println("VASSERT failed ::iBBHeightInTiles < 256");
        }
        this.m_iBBHeightInTiles = (byte)iBBHeightInTiles;
    }

    public final int getBoundBoxHeightInTiles() {
        if (this.m_iBBHeightInTiles < 0) {
            System.out.println("VASSERT failed ::m_iBBHeightInTiles >= 0");
        }
        return this.m_iBBHeightInTiles;
    }

    public final boolean isDead() {
        return (this.m_iFlags & 8) != 0;
    }

    public final void markAsDead() {
        this.m_iFlags |= 8;
    }

    private int getInfoForEvent(byte iSearchingForEventType) {
        int iLeft = 0;
        int iRight = this.m_iNumEvents - 1;
        while (iLeft <= iRight) {
            int iMiddleIndex = iLeft + iRight >> 1;
            byte iEventType = this.m_pEventInfo_type[iMiddleIndex];
            if (iSearchingForEventType == iEventType) {
                return iMiddleIndex;
            }
            if (iSearchingForEventType < iEventType) {
                iRight = iMiddleIndex - 1;
                continue;
            }
            iLeft = iMiddleIndex + 1;
        }
        return -1;
    }
}

