/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public final class Definition
extends vNode {
    public int m_iTemplateCRC32;
    public int m_iDefinitionCRC32;
    public int m_iFlags;
    public byte m_iOnInit;
    public byte m_iOnShutdown;
    public byte m_iOnProcess;
    public byte m_iOnRender;
    public byte m_iOnEvent;
    public int m_iFriendlyNameIndex;
    public int[] m_pDefaultPropertyValues;
    public ConversationSnippet[] m_pSnippets;
    public ConversationSnippetCollection[] m_pSnippetCollections;
    public vDictionary m_dictionary;
    public byte m_iWidth;
    public byte m_iHeight;
    public short m_iPropertyListSize;
    public short m_iSnippetListSize;
    public short m_iSnippetCollectionListSize;
    public byte m_iFacing;

    final void init(DataInputStream dis) throws IOException {
        int i;
        int magicID = dis.readUnsignedShort();
        int version = dis.readUnsignedShort();
        if (magicID != 50051) {
            System.out.println("VASSERT failed ::magicID == kMagicID");
        }
        if (version != 7) {
            System.out.println("VASSERT failed ::version == kVersion");
        }
        this.m_iTemplateCRC32 = dis.readInt();
        this.m_iDefinitionCRC32 = dis.readInt();
        this.m_iWidth = (byte)dis.readUnsignedByte();
        this.m_iHeight = (byte)dis.readUnsignedByte();
        this.m_iFlags = dis.readInt();
        this.m_iOnInit = (byte)dis.readInt();
        this.m_iOnShutdown = (byte)dis.readInt();
        this.m_iOnProcess = (byte)dis.readInt();
        this.m_iOnRender = (byte)dis.readInt();
        this.m_iOnEvent = (byte)dis.readInt();
        this.m_iFriendlyNameIndex = dis.readInt();
        this.m_dictionary = new vDictionary();
        if ((this.m_iFlags & 0x20) != 0) {
            this.m_iFacing = (byte)dis.readUnsignedByte();
        }
        this.m_iPropertyListSize = (short)dis.readUnsignedShort();
        if (this.m_iPropertyListSize > 0) {
            this.m_pDefaultPropertyValues = new int[this.m_iPropertyListSize];
            for (i = 0; i < this.m_iPropertyListSize; ++i) {
                this.m_pDefaultPropertyValues[i] = dis.readInt();
            }
        }
        if ((this.m_iFlags & 0x80) != 0) {
            this.m_iSnippetListSize = (short)dis.readUnsignedByte();
            this.m_iSnippetCollectionListSize = (short)dis.readUnsignedByte();
            if (this.m_iSnippetListSize > 0) {
                this.m_pSnippets = new ConversationSnippet[this.m_iSnippetListSize];
                for (i = 0; i < this.m_iSnippetListSize; ++i) {
                    this.m_pSnippets[i] = new ConversationSnippet();
                    this.m_pSnippets[i].init(this.m_dictionary, dis);
                }
            }
            if (this.m_iSnippetCollectionListSize > 0) {
                this.m_pSnippetCollections = new ConversationSnippetCollection[this.m_iSnippetCollectionListSize];
                for (i = 0; i < this.m_iSnippetCollectionListSize; ++i) {
                    this.m_pSnippetCollections[i] = new ConversationSnippetCollection();
                    this.m_pSnippetCollections[i].init(dis);
                }
            }
            if (this.m_iSnippetListSize > 0) {
                this.m_dictionary.init(dis);
                return;
            }
        } else {
            this.m_iSnippetListSize = 0;
            this.m_iSnippetCollectionListSize = 0;
        }
    }

    final void shutdown() {
        this.m_pDefaultPropertyValues = null;
        this.m_pSnippetCollections = null;
        this.m_pSnippets = null;
    }

    final ConversationSnippet getSnippet(int iIndex) {
        if ((this.m_iFlags & 0x80) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & kFlags_IsConversation) != 0");
        }
        if (iIndex < 0 || iIndex >= this.m_iSnippetListSize) {
            System.out.println("VASSERT failed ::iIndex >= 0 && iIndex < m_iSnippetListSize");
        }
        return this.m_pSnippets[iIndex];
    }

    final ConversationSnippetCollection getSnippetCollection(int iIndex) {
        if ((this.m_iFlags & 0x80) == 0) {
            System.out.println("VASSERT failed ::(m_iFlags & kFlags_IsConversation) != 0");
        }
        if (iIndex < this.m_iSnippetListSize || iIndex >= this.m_iSnippetListSize + this.m_iSnippetCollectionListSize) {
            System.out.println("VASSERT failed ::iIndex >= m_iSnippetListSize && iIndex < m_iSnippetListSize+m_iSnippetCollectionListSize");
        }
        return this.m_pSnippetCollections[iIndex - this.m_iSnippetListSize];
    }

    final boolean isSnippetCollection(int iIndex) {
        return iIndex >= this.m_iSnippetListSize && iIndex < this.m_iSnippetListSize + this.m_iSnippetCollectionListSize;
    }
}

