/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public final class ConversationSnippet {
    private vDictionary m_pDictionary;
    private int m_iStringID;
    int m_iSpeakerTypeCRC32;
    private ConversationResponse[] m_pResponses;

    public final void init(vDictionary pDictionary, DataInputStream dis) throws IOException {
        int magicID = dis.readUnsignedShort();
        int version = dis.readUnsignedShort();
        if (magicID != 1261) {
            System.out.println("VASSERT failed ::magicID == kMagicID");
        }
        if (version != 1) {
            System.out.println("VASSERT failed ::version == kVersion");
        }
        this.m_iSpeakerTypeCRC32 = dis.readInt();
        this.m_iStringID = dis.readShort();
        int iRespCount = dis.readUnsignedByte();
        if (iRespCount > 0) {
            this.m_pResponses = new ConversationResponse[iRespCount];
            for (int i = 0; i < iRespCount; ++i) {
                this.m_pResponses[i] = new ConversationResponse();
                this.m_pResponses[i].init(pDictionary, dis);
            }
        }
        this.m_pDictionary = pDictionary;
    }

    final String getString() {
        if (this.m_pDictionary == null) {
            System.out.println("VASSERT failed ::m_pDictionary != null");
        }
        return this.m_pDictionary.getString(this.m_iStringID);
    }

    final int getResponseCount() {
        if (this.m_pResponses == null) {
            return 0;
        }
        return this.m_pResponses.length;
    }

    final ConversationResponse getResponse(int iIndex) {
        if (iIndex < 0 || iIndex >= this.m_pResponses.length) {
            System.out.println("VASSERT failed ::iIndex >= 0 && iIndex < m_pResponses.length");
        }
        if (this.m_pResponses == null) {
            System.out.println("VASSERT failed ::m_pResponses != null");
        }
        return this.m_pResponses[iIndex];
    }
}

