/*
 * Decompiled with CFR 0.152.
 */
package midlettocoreletlib.rms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import midlettocoreletlib.rms.Record;
import midlettocoreletlib.rms.RecordEnumerationImpl;
import midlettocoreletlib.rms.RecordListener;

public class RecordStore {
    private static final String PRIMARY_RMS_DIR = "file:///b/Corelet/Rms/";
    private static final String SECONDARY_RMS_DIR = "file:///c/";
    private static final int RECORD_STORE_MAX_SIZE = 262144;
    public static final int AUTHMODE_ANY = 1;
    public static final int AUTHMODE_PRIVATE = 0;
    static Object RmsLock = new Object();
    static Vector openedRecordStores_ = new Vector();
    String name_;
    int nextId_ = 1;
    int version_ = 0;
    long modified_ = 0L;
    Vector records_;
    Vector recordListeners_;
    int opened_ = 0;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RecordStore(String string, boolean bl) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        this.name_ = string;
        this.records_ = new Vector();
        this.recordListeners_ = new Vector();
        FileConnection fileConnection = null;
        FilterInputStream filterInputStream = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)(RecordStore.getRmsDir() + RecordStore.validate(string) + ".crms"));
            if (!fileConnection.exists()) {
                if (!bl) throw new RecordStoreNotFoundException("RecordStore not found and createIfNecessary is false");
                fileConnection.create();
            }
            filterInputStream = fileConnection.openDataInputStream();
            try {
                this.nextId_ = ((DataInputStream)filterInputStream).readInt();
                this.version_ = ((DataInputStream)filterInputStream).readInt();
                this.modified_ = ((DataInputStream)filterInputStream).readLong();
                while (true) {
                    int n = ((DataInputStream)filterInputStream).readInt();
                    int n2 = ((DataInputStream)filterInputStream).readInt();
                    byte[] byArray = null;
                    if (n2 > 0) {
                        byArray = new byte[n2];
                        ((DataInputStream)filterInputStream).read(byArray, 0, n2);
                    }
                    this.records_.addElement(new Record(n, byArray));
                }
            }
            catch (EOFException eOFException) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileConnection.close();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            try {
                throw recordStoreNotFoundException;
                catch (Exception exception) {
                    throw new RecordStoreException("Open RMS " + string + ": " + exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileConnection.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listRecordStores() {
        Object object = RmsLock;
        synchronized (object) {
            Object[] objectArray;
            Vector<String> vector = new Vector<String>();
            FileConnection fileConnection = null;
            try {
                fileConnection = (FileConnection)Connector.open((String)RecordStore.getRmsDir());
                objectArray = fileConnection.list("*.crms", true);
                while (objectArray.hasMoreElements()) {
                    String string = (String)objectArray.nextElement();
                    string = string.substring(0, string.indexOf("."));
                    vector.addElement(string);
                }
            }
            catch (Exception exception) {
                System.out.println("Get RMS list: " + exception);
            }
            finally {
                try {
                    fileConnection.close();
                }
                catch (Exception exception) {}
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String string, boolean bl) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Object object = RmsLock;
        synchronized (object) {
            RecordStore recordStore = RecordStore.getOpenedRecordStore(string);
            if (recordStore == null) {
                recordStore = new RecordStore(string, bl);
                openedRecordStores_.addElement(recordStore);
            }
            ++recordStore.opened_;
            return recordStore;
        }
    }

    public static RecordStore openRecordStore(String string, boolean bl, int n, boolean bl2) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        return RecordStore.openRecordStore(string, bl);
    }

    public static RecordStore openRecordStore(String string, String string2, String string3) throws RecordStoreException, RecordStoreNotFoundException {
        return RecordStore.openRecordStore(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecordStore(String string) throws RecordStoreException, RecordStoreNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Object object = RmsLock;
        synchronized (object) {
            if (RecordStore.getOpenedRecordStore(string) != null) {
                throw new RecordStoreException("Delete RMS " + string + ": it is already opened");
            }
            FileConnection fileConnection = null;
            try {
                fileConnection = (FileConnection)Connector.open((String)(RecordStore.getRmsDir() + RecordStore.validate(string) + ".crms"));
                if (fileConnection.exists()) {
                    fileConnection.delete();
                }
            }
            catch (Exception exception) {
                throw new RecordStoreException("Delete RMS " + string + ": " + exception);
            }
            finally {
                try {
                    fileConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        Object object = RmsLock;
        synchronized (object) {
            --this.opened_;
            if (this.opened_ > 0) {
                return;
            }
            if (this.opened_ < 0) {
                throw new RecordStoreNotOpenException();
            }
            openedRecordStores_.removeElement(this);
            FileConnection fileConnection = null;
            FilterOutputStream filterOutputStream = null;
            try {
                fileConnection = (FileConnection)Connector.open((String)(RecordStore.getRmsDir() + this.name_ + ".crms"));
                if (fileConnection.exists()) {
                    fileConnection.delete();
                }
                fileConnection.create();
                filterOutputStream = fileConnection.openDataOutputStream();
                ((DataOutputStream)filterOutputStream).writeInt(this.nextId_);
                ((DataOutputStream)filterOutputStream).writeInt(this.version_);
                ((DataOutputStream)filterOutputStream).writeLong(System.currentTimeMillis());
                Enumeration enumeration = this.records_.elements();
                while (enumeration.hasMoreElements()) {
                    Record record = (Record)enumeration.nextElement();
                    ((DataOutputStream)filterOutputStream).writeInt(record.id);
                    if (record.data == null) {
                        ((DataOutputStream)filterOutputStream).writeInt(0);
                        continue;
                    }
                    ((DataOutputStream)filterOutputStream).writeInt(record.data.length);
                    ((DataOutputStream)filterOutputStream).write(record.data, 0, record.data.length);
                }
                this.name_ = null;
                this.recordListeners_.removeAllElements();
                this.recordListeners_ = null;
                this.records_.removeAllElements();
                this.records_ = null;
            }
            catch (Exception exception) {
                throw new RecordStoreException("Close RMS: " + exception);
            }
            finally {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordListener(RecordListener recordListener) {
        Object object = RmsLock;
        synchronized (object) {
            if (this.recordListeners_ == null) {
                return;
            }
            if (this.recordListeners_.indexOf(recordListener) == -1) {
                this.recordListeners_.addElement(recordListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecordListener(RecordListener recordListener) {
        Object object = RmsLock;
        synchronized (object) {
            if (this.recordListeners_ == null) {
                return;
            }
            this.recordListeners_.removeElement(recordListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws RecordStoreNotOpenException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            return this.name_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() throws RecordStoreNotOpenException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            return this.modified_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() throws RecordStoreNotOpenException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            return this.version_;
        }
    }

    public void setMode(int n, boolean bl) throws RecordStoreException {
        System.out.println("ReocrdStore.setMode(int,boolean) is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            return this.nextId_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRecords() throws RecordStoreNotOpenException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            return this.records_.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRecord(byte[] byArray, int n, int n2) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            byte[] byArray2 = null;
            if (byArray != null) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
            this.records_.addElement(new Record(this.nextId_, byArray2));
            ++this.nextId_;
            ++this.version_;
            this.modified_ = System.currentTimeMillis();
            Enumeration enumeration = this.recordListeners_.elements();
            while (enumeration.hasMoreElements()) {
                RecordListener recordListener = (RecordListener)enumeration.nextElement();
                try {
                    recordListener.recordAdded(this, this.nextId_ - 1);
                }
                catch (Throwable throwable) {
                    System.out.println("recordAdded(RecordStore,int) " + throwable);
                    throwable.printStackTrace();
                }
            }
            return this.nextId_;
        }
    }

    public void deleteRecord(int n) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            for (int i = 0; i < this.records_.size(); ++i) {
                Record record = (Record)this.records_.elementAt(i);
                if (n != record.id) continue;
                this.records_.removeElementAt(i);
                ++this.version_;
                this.modified_ = System.currentTimeMillis();
                Enumeration enumeration = this.recordListeners_.elements();
                while (enumeration.hasMoreElements()) {
                    RecordListener recordListener = (RecordListener)enumeration.nextElement();
                    try {
                        recordListener.recordDeleted(this, n);
                    }
                    catch (Throwable throwable) {
                        System.out.println("recordDeleted(RecordStore,int) " + throwable);
                        throwable.printStackTrace();
                    }
                }
                return;
            }
            throw new InvalidRecordIDException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecord(int n) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = RmsLock;
        synchronized (object) {
            byte[] byArray = new byte[this.getRecordSize(n)];
            this.getRecord(n, byArray, 0);
            return byArray;
        }
    }

    public int getRecord(int n, byte[] byArray, int n2) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            Enumeration enumeration = this.records_.elements();
            while (enumeration.hasMoreElements()) {
                Record record = (Record)enumeration.nextElement();
                if (n != record.id) continue;
                if (record.data != null) {
                    System.arraycopy(record.data, 0, byArray, n2, record.data.length);
                    return record.data.length;
                }
                return 0;
            }
            throw new InvalidRecordIDException();
        }
    }

    public void setRecord(int n, byte[] byArray, int n2, int n3) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            for (int i = 0; i < this.records_.size(); ++i) {
                Record record = (Record)this.records_.elementAt(i);
                if (n != record.id) continue;
                record.data = null;
                if (byArray != null) {
                    record.data = new byte[n3];
                    System.arraycopy(byArray, n2, record.data, 0, n3);
                }
                ++this.version_;
                this.modified_ = System.currentTimeMillis();
                Enumeration enumeration = this.recordListeners_.elements();
                while (enumeration.hasMoreElements()) {
                    RecordListener recordListener = (RecordListener)enumeration.nextElement();
                    try {
                        recordListener.recordChanged(this, n);
                    }
                    catch (Throwable throwable) {
                        System.out.println("recordChanged(RecordStore,int) " + throwable);
                        throwable.printStackTrace();
                    }
                }
                return;
            }
            throw new InvalidRecordIDException();
        }
    }

    public int getRecordSize(int n) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            Enumeration enumeration = this.records_.elements();
            while (enumeration.hasMoreElements()) {
                Record record = (Record)enumeration.nextElement();
                if (n != record.id) continue;
                if (record.data != null) {
                    return record.data.length;
                }
                return 0;
            }
            throw new InvalidRecordIDException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws RecordStoreNotOpenException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            int n = 16;
            Enumeration enumeration = this.records_.elements();
            while (enumeration.hasMoreElements()) {
                Record record = (Record)enumeration.nextElement();
                n += 8;
                if (record.data == null) continue;
                n += record.data.length;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSizeAvailable() throws RecordStoreNotOpenException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            int n = 262144 - this.getSize();
            if (n < 0) {
                n = 0;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordEnumeration enumerateRecords(RecordFilter recordFilter, RecordComparator recordComparator, boolean bl) throws RecordStoreNotOpenException {
        Object object = RmsLock;
        synchronized (object) {
            if (this.opened_ <= 0) {
                throw new RecordStoreNotOpenException();
            }
            return new RecordEnumerationImpl(this, recordFilter, recordComparator, bl);
        }
    }

    private static RecordStore getOpenedRecordStore(String string) {
        Enumeration enumeration = openedRecordStores_.elements();
        while (enumeration.hasMoreElements()) {
            RecordStore recordStore = (RecordStore)enumeration.nextElement();
            if (!recordStore.name_.equals(string)) continue;
            return recordStore;
        }
        return null;
    }

    private static String validate(String string) {
        char c2 = "_".charAt(0);
        char[] cArray = new char[]{"\"".charAt(0), "\\".charAt(0), "|".charAt(0), "?".charAt(0), "*".charAt(0), "<".charAt(0), ">".charAt(0), "/".charAt(0), ":".charAt(0), ".".charAt(0)};
        StringBuffer stringBuffer = new StringBuffer(string);
        block0: for (int i = 0; i < stringBuffer.length(); ++i) {
            for (int j = 0; j < cArray.length; ++j) {
                if (stringBuffer.charAt(i) != cArray[j]) continue;
                stringBuffer.setCharAt(i, c2);
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRmsDir() {
        String string = PRIMARY_RMS_DIR;
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)string);
            if (!fileConnection.isDirectory()) {
                fileConnection.mkdir();
            }
        }
        catch (Exception exception) {
            string = SECONDARY_RMS_DIR;
            System.out.println("Create RMS directories: " + exception);
        }
        finally {
            try {
                fileConnection.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOpen() {
        Object object = RmsLock;
        synchronized (object) {
            return this.opened_ > 0;
        }
    }

    int[] getRecordIDs() {
        int[] nArray = new int[this.records_.size()];
        Enumeration enumeration = this.records_.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            nArray[n] = record.id;
            ++n;
        }
        return nArray;
    }
}

