/*
 * Decompiled with CFR 0.152.
 */
package midlettocoreletlib.rms;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import midlettocoreletlib.rms.RecordListener;
import midlettocoreletlib.rms.RecordStore;

class RecordEnumerationImpl
implements RecordEnumeration,
RecordListener {
    private RecordStore recordStore = null;
    private RecordFilter filter = null;
    private RecordComparator comparator = null;
    private boolean beObserver = false;
    private int index = 0;
    private int[] records = null;
    private static final int NO_SUCH_RECORD = -1;

    public RecordEnumerationImpl(RecordStore recordStore, RecordFilter recordFilter, RecordComparator recordComparator, boolean bl) {
        this.recordStore = recordStore;
        this.filter = recordFilter;
        this.comparator = recordComparator;
        this.records = new int[0];
        this.keepUpdated(bl);
        if (!bl) {
            this.rebuild();
        }
    }

    public int numRecords() {
        this.checkDestroyed();
        return this.records.length;
    }

    public synchronized byte[] nextRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        this.checkDestroyed();
        return this.recordStore.getRecord(this.nextRecordId());
    }

    public synchronized int nextRecordId() throws InvalidRecordIDException {
        this.checkDestroyed();
        if (this.index == this.records.length - 1) {
            throw new InvalidRecordIDException();
        }
        this.index = this.index == -1 ? 0 : ++this.index;
        return this.records[this.index];
    }

    public synchronized byte[] previousRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        this.checkDestroyed();
        return this.recordStore.getRecord(this.previousRecordId());
    }

    public synchronized int previousRecordId() throws InvalidRecordIDException {
        this.checkDestroyed();
        if (this.index == 0 || this.records.length == 0) {
            throw new InvalidRecordIDException();
        }
        this.index = this.index == -1 ? this.records.length - 1 : --this.index;
        return this.records[this.index];
    }

    public boolean hasNextElement() {
        this.checkDestroyed();
        if (!this.recordStore.isOpen()) {
            return false;
        }
        return this.index != this.records.length - 1;
    }

    public boolean hasPreviousElement() {
        this.checkDestroyed();
        if (this.records.length == 0 || !this.recordStore.isOpen()) {
            return false;
        }
        return this.index != 0;
    }

    public void reset() {
        this.checkDestroyed();
        this.index = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        this.checkDestroyed();
        Object object = RecordStore.RmsLock;
        synchronized (object) {
            int[] nArray = this.recordStore.getRecordIDs();
            this.reFilterSort(nArray);
        }
    }

    public void keepUpdated(boolean bl) {
        this.checkDestroyed();
        if (bl != this.beObserver) {
            this.beObserver = bl;
            if (bl) {
                this.recordStore.addRecordListener(this);
                this.rebuild();
            } else {
                this.recordStore.removeRecordListener(this);
            }
        }
    }

    public boolean isKeptUpdated() {
        this.checkDestroyed();
        return this.beObserver;
    }

    public synchronized void recordAdded(RecordStore recordStore, int n) {
        this.checkDestroyed();
        this.filterAdd(n);
    }

    public synchronized void recordChanged(RecordStore recordStore, int n) {
        this.checkDestroyed();
        int n2 = this.findIndexOfRecord(n);
        if (n2 < 0) {
            return;
        }
        this.removeRecordAtIndex(n2);
        this.filterAdd(n);
    }

    public synchronized void recordDeleted(RecordStore recordStore, int n) {
        this.checkDestroyed();
        int n2 = this.findIndexOfRecord(n);
        if (n2 < 0) {
            return;
        }
        this.removeRecordAtIndex(n2);
    }

    public synchronized void destroy() {
        this.checkDestroyed();
        if (this.beObserver) {
            this.recordStore.removeRecordListener(this);
        }
        this.filter = null;
        this.comparator = null;
        this.records = null;
        this.recordStore = null;
    }

    private void checkDestroyed() {
        if (this.recordStore == null) {
            throw new IllegalStateException();
        }
    }

    private void filterAdd(int n) {
        int n2 = -1;
        if (this.filter != null) {
            try {
                if (!this.filter.matches(this.recordStore.getRecord(n))) {
                    return;
                }
            }
            catch (RecordStoreException recordStoreException) {
                return;
            }
        }
        int[] nArray = new int[this.records.length + 1];
        nArray[0] = n;
        System.arraycopy(this.records, 0, nArray, 1, this.records.length);
        this.records = nArray;
        if (this.comparator != null) {
            try {
                n2 = this.sortInsert();
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println("Unexpected exception in filterAdd");
            }
        }
        if (this.index != -1 && n2 != -1 && n2 < this.index) {
            ++this.index;
        }
    }

    private int sortInsert() throws RecordStoreException {
        int n = 0;
        int n2 = 1;
        while (n < this.records.length - 1 && this.comparator.compare(this.recordStore.getRecord(this.records[n]), this.recordStore.getRecord(this.records[n2])) == 1) {
            int n3 = this.records[n];
            this.records[n] = this.records[n2];
            this.records[n2] = n3;
            ++n;
            ++n2;
        }
        return n;
    }

    private int findIndexOfRecord(int n) {
        int n2 = -1;
        for (int i = this.records.length - 1; i >= 0; --i) {
            if (this.records[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private void removeRecordAtIndex(int n) {
        int[] nArray = new int[this.records.length - 1];
        if (n < this.records.length) {
            System.arraycopy(this.records, 0, nArray, 0, n);
            System.arraycopy(this.records, n + 1, nArray, n, this.records.length - n - 1);
        } else {
            System.arraycopy(this.records, 0, nArray, 0, this.records.length - 1);
        }
        this.records = nArray;
        if (this.index != -1 && n <= this.index) {
            --this.index;
        } else if (this.index == this.records.length) {
            --this.index;
        }
    }

    private void reFilterSort(int[] nArray) {
        int n = 0;
        if (this.filter == null) {
            this.records = nArray;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    if (!this.filter.matches(this.recordStore.getRecord(nArray[i]))) continue;
                    if (n != i) {
                        nArray[n++] = nArray[i];
                        continue;
                    }
                    ++n;
                    continue;
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
            this.records = new int[n];
            System.arraycopy(nArray, 0, this.records, 0, n);
        }
        if (this.comparator != null) {
            try {
                this.QuickSort(this.records, 0, this.records.length - 1, this.comparator);
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println("Unexpected exception in reFilterSort");
            }
        }
        this.reset();
    }

    private void QuickSort(int[] nArray, int n, int n2, RecordComparator recordComparator) throws RecordStoreException {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = (n + n2) / 2;
            int n6 = nArray[n5];
            byte[] byArray = this.recordStore.getRecord(n6);
            while (n3 <= n4) {
                while (n3 < n2 && recordComparator.compare(this.recordStore.getRecord(nArray[n3]), byArray) == -1) {
                    ++n3;
                }
                while (n4 > n && recordComparator.compare(this.recordStore.getRecord(nArray[n4]), byArray) == 1) {
                    --n4;
                }
                if (n3 > n4) continue;
                int n7 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n7;
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.QuickSort(nArray, n, n4, recordComparator);
            }
            if (n3 < n2) {
                this.QuickSort(nArray, n3, n2, recordComparator);
            }
        }
    }
}

