/*
 * Decompiled with CFR 0.152.
 */
package midlettocoreletlib.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import midlettocoreletlib.lcdui.Canvas;

public abstract class GameCanvas
extends Canvas {
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 64;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    private int m_KeyState = 0;
    private int m_KeyStateReleased = 0;
    private boolean m_suppressKeyEvents;
    private Image bufferedImage;
    private boolean setClip;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;

    protected GameCanvas(boolean bl) {
        this.setFullScreenMode(true);
        this.bufferedImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.m_suppressKeyEvents = bl;
    }

    public int getKeyStates() {
        int n = this.m_KeyState;
        this.m_KeyState &= ~this.m_KeyStateReleased;
        this.m_KeyStateReleased = 0;
        return n;
    }

    protected boolean keyPressedCare(int n) {
        int n2 = this.getGameAction(n);
        if (n2 != 0) {
            int n3 = 1 << n2;
            this.m_KeyState |= n3;
            this.m_KeyStateReleased &= ~n3;
            return this.m_suppressKeyEvents;
        }
        return false;
    }

    protected boolean keyReleasedCare(int n) {
        int n2 = this.getGameAction(n);
        if (n2 != 0) {
            this.m_KeyStateReleased |= 1 << n2;
            return this.m_suppressKeyEvents;
        }
        return false;
    }

    protected Graphics getGraphics() {
        return this.bufferedImage.getGraphics();
    }

    public void paint(Graphics graphics) {
        if (this.setClip) {
            graphics.clipRect(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.setClip = false;
        }
        graphics.drawImage(this.bufferedImage, 0, 0, 20);
    }

    public void flushGraphics(int n, int n2, int n3, int n4) {
        this.setClip = true;
        this.clipX = n;
        this.clipY = n2;
        this.clipWidth = n3;
        this.clipHeight = n4;
        this.repaint();
        this.serviceRepaints();
    }

    public void flushGraphics() {
        this.repaint();
        this.serviceRepaints();
    }
}

