/*
 * Decompiled with CFR 0.152.
 */
package midlettocoreletlib.lcdui;

import com.motorola.synerj.ui.Adjuster;
import com.motorola.synerj.ui.Colors;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.PrimaryView;
import com.motorola.synerj.ui.UICommandListener;
import com.motorola.synerj.ui.UIGraphics;
import com.motorola.synerj.ui.UIKeyboardListener;
import com.motorola.synerj.ui.dialog.CharEditorDialog;
import java.util.Vector;
import midlettocoreletlib.lcdui.Command;
import midlettocoreletlib.lcdui.Display;
import midlettocoreletlib.lcdui.Formatter;
import midlettocoreletlib.lcdui.TextBox;

class TextBoxImpl
extends PrimaryView
implements UIKeyboardListener,
UICommandListener {
    private final int STRING_H_PADDING;
    private TextBox parent;
    CharEditorDialog ced;
    private boolean uneditabe;
    private Vector strings;
    private int height;
    private int offset;
    private int sb_height;
    private int sb_offset;

    public TextBoxImpl(TextBox textBox) {
        super(Adjuster.getDecorator((int)2));
        this.STRING_H_PADDING = 3;
        this.setBox(0, 0, 0, 0, PrimaryDisplay.getWidth(), PrimaryDisplay.getHeight(), 3);
        this.ced = new CharEditorDialog();
        this.ced.setCommandListener((UICommandListener)this);
        this.strings = new Vector();
        this.parent = textBox;
        this.setKeyboardListener(this);
        this.setCommandListener(this);
    }

    public void setConstraintsImpl(int n) {
        this.ced.setConstraints(n & 0xFFFF);
        this.ced.setIsPassword((n & 0x10000) != 0);
        this.uneditabe = (n & 0x20000) != 0;
    }

    public void setStringImpl() {
        String string = this.ced.getText();
        this.strings.removeAllElements();
        if (string != null) {
            this.strings = Formatter.formatString(string, this.getClientWidth() - 6);
        }
        this.offset = 0;
        this.height = this.strings.size() * Formatter.DEFAULT_FONT_HEIGHT;
        if (this.strings.size() > 0) {
            this.height += 3;
        }
        this.sb_offset = 0;
        this.sb_height = 1;
        if (this.height > this.getClientHeight()) {
            this.sb_height += (this.height - this.getClientHeight()) / Formatter.DEFAULT_FONT_HEIGHT;
            if ((this.height - this.getClientHeight()) % Formatter.DEFAULT_FONT_HEIGHT > 0) {
                ++this.sb_height;
            }
        }
        this.getScrollbar().setScrollbarDims(this.sb_height, 1);
        this.getScrollbar().setSliderPos(this.sb_offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(UIGraphics uIGraphics) {
        Object object = Display.DLock;
        synchronized (object) {
            TextBox textBox = this.parent;
            synchronized (textBox) {
                int n = 0;
                uIGraphics.setColor(Colors.get((int)2));
                for (int i = 0; i < this.strings.size(); ++i) {
                    String string = (String)this.strings.elementAt(i);
                    if (this.ced.getIsPassword()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < string.length(); ++j) {
                            stringBuffer.append("*");
                        }
                        string = stringBuffer.toString();
                    }
                    uIGraphics.drawString(string, 3, n - this.offset, 20);
                    n += Formatter.DEFAULT_FONT_HEIGHT;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyDown(int n) {
        TextBox textBox = this.parent;
        synchronized (textBox) {
            if (!this.uneditabe && this.parent.owner_ != null && (n >= 48 && n <= 57 || n == -20 || n == 42 || n == 35)) {
                this.parent.owner_.setTextEditor(this.ced);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyLongPress(int n) {
        if (n == -102) {
            TextBox textBox = this.parent;
            synchronized (textBox) {
                if (this.parent.owner_ != null) {
                    this.parent.owner_.midlet.notifyBackground();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyReleased(int n) {
        if (n == -1 || n == -6) {
            TextBox textBox = this.parent;
            synchronized (textBox) {
                if (this.height > this.getClientHeight()) {
                    if (n == -1) {
                        this.offset -= Formatter.DEFAULT_FONT_HEIGHT;
                        if (this.offset < 0) {
                            this.offset = 0;
                        }
                        --this.sb_offset;
                        if (this.sb_offset < 0) {
                            this.sb_offset = 0;
                        }
                    }
                    if (n == -6) {
                        this.offset += Formatter.DEFAULT_FONT_HEIGHT;
                        if (this.offset >= this.height - this.getClientHeight()) {
                            this.offset = this.height - this.getClientHeight() - 1;
                        }
                        ++this.sb_offset;
                        if (this.sb_offset >= this.sb_height) {
                            this.sb_offset = this.sb_height - 1;
                        }
                    }
                    this.getScrollbar().setSliderPos(this.sb_offset);
                    this.repaint();
                }
            }
        }
    }

    public void onKeyRepeated(int n) {
        this.onKeyReleased(n);
    }

    public void onKeyShortPress(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(int n) {
        TextBox textBox = this.parent;
        synchronized (textBox) {
            if (n == -1 || n == -2) {
                if (this.parent.owner_ != null) {
                    this.parent.owner_.removeTextEditor();
                }
                this.setStringImpl();
                this.repaint();
                return;
            }
            if (this.parent.listener_ == null) {
                return;
            }
            Command command = this.parent.getCommandById(n);
            if (command == null) {
                return;
            }
            try {
                this.parent.listener_.commandAction(command, this.parent);
            }
            catch (Throwable throwable) {
                System.out.println("commandAction(Command " + n + ",TextBox" + (Object)((Object)this) + ") " + throwable);
                throwable.printStackTrace();
            }
        }
    }
}

