/*
 * Decompiled with CFR 0.152.
 */
package midlettocoreletlib.lcdui;

import com.motorola.synerj.ui.Adjuster;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.PrimaryView;
import com.motorola.synerj.ui.UICommandListener;
import com.motorola.synerj.ui.UIGraphics;
import com.motorola.synerj.ui.UIKeyboardListener;
import midlettocoreletlib.lcdui.Command;
import midlettocoreletlib.lcdui.Display;
import midlettocoreletlib.lcdui.Form;
import midlettocoreletlib.lcdui.Formatter;
import midlettocoreletlib.lcdui.Item;

class FormImpl
extends PrimaryView
implements UIKeyboardListener,
UICommandListener {
    final int TITLE_PADDING_TOP;
    final int TITLE_PADDING_BOTTOM;
    final int TITLE_PADDING_LEFT;
    final int TITLE_PADDING_RIGHT;
    final int ITEM_PADDING_TOP;
    final int ITEM_PADDING_BOTTOM;
    final int SCROLL_SPEED;
    private Form parent;
    int currentItemIndex;
    private int height;
    private int offset;
    private int sb_height;
    private int sb_offset;

    public FormImpl(Form form) {
        super(Adjuster.getDecorator((int)1));
        this.TITLE_PADDING_TOP = 2;
        this.TITLE_PADDING_BOTTOM = 2;
        this.TITLE_PADDING_LEFT = 3;
        this.TITLE_PADDING_RIGHT = 3;
        this.ITEM_PADDING_TOP = 0;
        this.ITEM_PADDING_BOTTOM = 4;
        this.SCROLL_SPEED = 40;
        this.setBox(0, 0, 0, 0, PrimaryDisplay.getWidth(), PrimaryDisplay.getHeight(), 3);
        this.parent = form;
        this.setKeyboardListener(this);
        this.setCommandListener(this);
    }

    private void selectItem(int n, boolean bl) {
        this.currentItemIndex = n;
        if (!this.isFullVisible(n)) {
            this.offset = bl == this.getItemHeight(n) < this.getClientHeight() ? this.getItemOffest(n) - this.getClientHeight() + this.getItemHeight(n) - 1 : this.getItemOffest(n);
        }
        this.repaint();
    }

    private int getItemOffest(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Item item = this.parent.get(i);
            if (item.getLabel() != null) {
                n2 += 2 + Formatter.DEFAULT_FONT_HEIGHT + 2;
            }
            n2 += 0 + item.getPreferredHeight() + 4;
        }
        return n2;
    }

    private int getItemHeight(int n) {
        int n2 = 0;
        Item item = this.parent.get(n);
        if (item.getLabel() != null) {
            n2 += 2 + Formatter.DEFAULT_FONT_HEIGHT + 2;
        }
        return n2 += 0 + item.getPreferredHeight() + 4;
    }

    private boolean isFullVisible(int n) {
        int n2 = this.getItemHeight(n);
        if (n2 > this.getClientHeight()) {
            return false;
        }
        int n3 = this.getItemOffest(n);
        if (n3 - this.offset < 0) {
            return false;
        }
        return n3 - this.offset + n2 <= this.getClientHeight();
    }

    private boolean isVisible(int n) {
        if (n < 0 || n >= this.parent.size()) {
            return false;
        }
        int n2 = this.getItemHeight(n);
        int n3 = this.getItemOffest(n);
        if (n3 - this.offset + n2 < 0) {
            return false;
        }
        return n3 - this.offset <= this.getClientHeight();
    }

    public void recalc() {
        int n;
        this.currentItemIndex = -1;
        this.offset = 0;
        this.height = 0;
        for (n = 0; n < this.parent.size(); ++n) {
            Item item = this.parent.get(n);
            if (item.getLabel() != null) {
                this.height += 2 + Formatter.DEFAULT_FONT_HEIGHT + 2;
            }
            this.height += 0 + item.getPreferredHeight() + 4;
        }
        this.sb_offset = 0;
        this.sb_height = 1;
        n = this.height - this.getClientHeight();
        if (n > 0) {
            this.sb_height += n / 40;
            if (n % 40 > 0) {
                ++this.sb_height;
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(UIGraphics uIGraphics) {
        Object object = Display.DLock;
        synchronized (object) {
            Form form = this.parent;
            synchronized (form) {
                uIGraphics.translate(0, -this.offset);
                for (int i = 0; i < this.parent.size(); ++i) {
                    Item item = this.parent.get(i);
                    uIGraphics.setClip(this.getClientX() - uIGraphics.getTranslateX(), this.getClientY() - uIGraphics.getTranslateY(), this.getClientWidth(), this.getClientHeight());
                    uIGraphics.setColor(0xFFFFFF);
                    uIGraphics.fillRect(0, 0, 320, 320);
                    String string = item.getTruncatedLabel();
                    if (string != null) {
                        uIGraphics.setColor(0);
                        uIGraphics.drawString(string, 3, 2, 20);
                        uIGraphics.translate(0, 2 + Formatter.DEFAULT_FONT_HEIGHT + 2);
                    }
                    uIGraphics.translate(0, 0);
                    uIGraphics.clipRect(0, 0, item.getPreferredWidth(), item.getPreferredHeight());
                    item.paint(uIGraphics, item.getPreferredWidth(), item.getPreferredHeight(), this.currentItemIndex == i);
                    uIGraphics.translate(0, item.getPreferredHeight() + 4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyDown(int n) {
        Form form = this.parent;
        synchronized (form) {
            if (n == -1 || n == -6) {
                if (n == -1) {
                    if (this.isVisible(this.currentItemIndex - 1)) {
                        this.selectItem(this.currentItemIndex - 1, false);
                    } else if (this.height > this.getClientHeight()) {
                        this.offset -= 40;
                        if (this.offset < 0) {
                            this.offset = 0;
                        }
                        --this.sb_offset;
                        if (this.sb_offset < 0) {
                            this.sb_offset = 0;
                        }
                    }
                }
                if (n == -6) {
                    if (this.isVisible(this.currentItemIndex + 1)) {
                        this.selectItem(this.currentItemIndex + 1, true);
                    } else if (this.height > this.getClientHeight()) {
                        this.offset += 40;
                        if (this.offset >= this.height - this.getClientHeight()) {
                            this.offset = this.height - this.getClientHeight() - 1;
                        }
                        ++this.sb_offset;
                        if (this.sb_offset >= this.sb_height) {
                            this.sb_offset = this.sb_height - 1;
                        }
                    }
                }
                this.repaint();
            } else if (this.currentItemIndex >= 0 && this.currentItemIndex < this.parent.size()) {
                this.parent.get(this.currentItemIndex).keyItemCare(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyLongPress(int n) {
        if (n == -102) {
            Form form = this.parent;
            synchronized (form) {
                if (this.parent.owner_ != null) {
                    this.parent.owner_.midlet.notifyBackground();
                }
            }
        }
    }

    public void onKeyReleased(int n) {
    }

    public void onKeyRepeated(int n) {
    }

    public void onKeyShortPress(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(int n) {
        Form form = this.parent;
        synchronized (form) {
            if (this.parent.listener_ == null) {
                return;
            }
            Command command = this.parent.getCommandById(n);
            if (command == null) {
                return;
            }
            try {
                this.parent.listener_.commandAction(command, this.parent);
            }
            catch (Throwable throwable) {
                System.out.println("commandAction(Command " + n + ", Form " + (Object)((Object)this) + ") " + throwable);
                throwable.printStackTrace();
            }
        }
    }

    public int getClientWidthImpl() {
        return this.getClientWidth();
    }

    public int getClientHeightImpl() {
        return this.getClientHeight();
    }
}

