/*
 * Decompiled with CFR 0.152.
 */
package midlettocoreletlib.lcdui;

import java.util.Enumeration;
import javax.microedition.lcdui.Graphics;
import midlettocoreletlib.lcdui.CanvasImpl;
import midlettocoreletlib.lcdui.Command;
import midlettocoreletlib.lcdui.Displayable;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;

    protected Canvas() {
        this.impl_ = new CanvasImpl(this);
    }

    public synchronized void setFullScreenMode(boolean bl) {
        if (bl) {
            this.impl_ = new CanvasImpl(this, true);
            if (this.right_command_ != null) {
                this.impl_.addMenuCommand(this.right_command_.shortLabel, this.right_command_.id, 0);
            }
            if (this.left_command_ != null) {
                this.impl_.addMenuCommand(this.left_command_.shortLabel, this.left_command_.id, 1);
            }
        } else {
            this.impl_ = new CanvasImpl(this);
            if (this.right_command_ != null) {
                this.impl_.setSoftkeyCommand(this.right_command_.shortLabel, this.right_command_.id, 1);
            }
            if (this.left_command_ != null) {
                this.impl_.setSoftkeyCommand(this.left_command_.shortLabel, this.left_command_.id, 0);
            }
        }
        if (this.owner_ != null) {
            this.owner_.reSetCurrent();
        }
        new Thread(new SizeChanger(this)).start();
        Enumeration enumeration = this.menu_commands_.elements();
        while (enumeration.hasMoreElements()) {
            Command command = (Command)enumeration.nextElement();
            this.impl_.addMenuCommand(command.shortLabel, command.id, command.priority);
        }
        if (this.menu_commands_.size() > 0) {
            try {
                this.impl_.setKeepMenuSofkeyIcon(true);
            }
            catch (Throwable throwable) {
                System.out.println("setKeepMenuSofkeyIcon(true) ERROR IN setFullScreenMode()");
            }
        }
        this.impl_.repaint();
    }

    public void setTitle(String string) {
    }

    public int getKeyCode(int n) {
        switch (n) {
            case 1: {
                return -1;
            }
            case 6: {
                return -6;
            }
            case 2: {
                return -2;
            }
            case 5: {
                return -5;
            }
            case 8: {
                return -20;
            }
            case 9: {
                return 49;
            }
            case 10: {
                return 51;
            }
            case 11: {
                return 55;
            }
            case 12: {
                return 57;
            }
        }
        throw new IllegalArgumentException();
    }

    public String getKeyName(int n) {
        switch (n) {
            case -21: {
                return "SOFT1";
            }
            case -22: {
                return "SOFT2";
            }
            case -23: {
                return "SOFT3";
            }
            case -100: {
                return "UP";
            }
            case -101: {
                return "DOWN";
            }
            case -102: {
                return "SELECT";
            }
            case -10: {
                return "SEND";
            }
            case -20: {
                return "SELECT";
            }
            case -1: {
                return "UP";
            }
            case -6: {
                return "DOWN";
            }
            case -2: {
                return "LEFT";
            }
            case -5: {
                return "RIGHT";
            }
            case 48: {
                return "NUM0";
            }
            case 49: {
                return "NUM1";
            }
            case 50: {
                return "NUM2";
            }
            case 51: {
                return "NUM3";
            }
            case 52: {
                return "NUM4";
            }
            case 53: {
                return "NUM5";
            }
            case 54: {
                return "NUM6";
            }
            case 55: {
                return "NUM7";
            }
            case 56: {
                return "NUM8";
            }
            case 57: {
                return "NUM9";
            }
            case 42: {
                return "STAR";
            }
            case 35: {
                return "POUND";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getGameAction(int n) {
        switch (n) {
            case 50: {
                return 1;
            }
            case -1: {
                return 1;
            }
            case 56: {
                return 6;
            }
            case -6: {
                return 6;
            }
            case 52: {
                return 2;
            }
            case -2: {
                return 2;
            }
            case 54: {
                return 5;
            }
            case -5: {
                return 5;
            }
            case 53: {
                return 8;
            }
            case -20: {
                return 8;
            }
            case 49: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 55: {
                return 11;
            }
            case 57: {
                return 12;
            }
        }
        return 0;
    }

    public synchronized void repaint() {
        this.impl_.repaint();
    }

    public synchronized void repaint(int n, int n2, int n3, int n4) {
        this.impl_.repaint(n, n2, n3, n4);
    }

    public void serviceRepaints() {
        if (this.impl_ != null) {
            this.impl_.serviceRepaints();
        }
    }

    public synchronized int getWidth() {
        return this.impl_.getWidth();
    }

    public synchronized int getHeight() {
        return this.impl_.getHeight();
    }

    protected boolean keyPressedCare(int n) {
        return false;
    }

    protected boolean keyReleasedCare(int n) {
        return false;
    }

    protected void keyPressed(int n) {
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
    }

    protected void pointerPressed(int n, int n2) {
    }

    protected void pointerReleased(int n, int n2) {
    }

    protected void pointerDragged(int n, int n2) {
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void sizeChanged(int n, int n2) {
    }

    public abstract void paint(Graphics var1);

    public boolean isDoubleBuffered() {
        return true;
    }

    public boolean hasPointerEvents() {
        return false;
    }

    public boolean hasPointerMotionEvents() {
        return false;
    }

    public boolean hasRepeatEvents() {
        return false;
    }

    class SizeChanger
    implements Runnable {
        private Canvas c;

        public SizeChanger(Canvas canvas2) {
            this.c = canvas2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Canvas canvas = this.c;
            synchronized (canvas) {
                Canvas.this.sizeChanged(this.c.getWidth(), this.c.getHeight());
            }
        }
    }
}

