/*
 * Decompiled with CFR 0.152.
 */
package midlettocoreletlib.lcdui;

import com.motorola.synerj.ui.Adjuster;
import com.motorola.synerj.ui.Colors;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.PrimaryView;
import com.motorola.synerj.ui.UICommandListener;
import com.motorola.synerj.ui.UIGraphics;
import com.motorola.synerj.ui.UIKeyboardListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import midlettocoreletlib.lcdui.Alert;
import midlettocoreletlib.lcdui.Command;
import midlettocoreletlib.lcdui.Display;
import midlettocoreletlib.lcdui.Formatter;

class AlertImpl
extends PrimaryView
implements UICommandListener,
UIKeyboardListener {
    private final int IMAGE_V_PADDING;
    private final int STRING_H_PADDING;
    private Alert parent;
    private Vector strings;
    private boolean alignLeft;
    private int height;
    private int offset;
    private int sb_height;
    private int sb_offset;

    public AlertImpl(Alert alert) {
        super(Adjuster.getDecorator((int)2));
        this.IMAGE_V_PADDING = 4;
        this.STRING_H_PADDING = 3;
        this.setBox(0, 0, 0, 0, PrimaryDisplay.getWidth(), PrimaryDisplay.getHeight(), 3);
        this.strings = new Vector();
        this.parent = alert;
        this.setKeyboardListener(this);
        this.setCommandListener(this);
    }

    public void setStringImpl(String string) {
        this.strings.removeAllElements();
        if (string != null) {
            this.alignLeft = string.length() > 30;
            this.strings = Formatter.formatString(string, this.getClientWidth() - 6);
        }
        this.setImageImpl(this.parent.image_);
    }

    public void setImageImpl(Image image) {
        this.offset = 0;
        this.height = 0;
        if (image != null) {
            this.height = 8 + image.getHeight();
        }
        this.height += this.strings.size() * Formatter.DEFAULT_FONT_HEIGHT;
        if (this.strings.size() > 0) {
            this.height += 3;
        }
        this.sb_offset = 0;
        this.sb_height = 1;
        if (this.height > this.getClientHeight()) {
            this.sb_height += (this.height - this.getClientHeight()) / Formatter.DEFAULT_FONT_HEIGHT;
            if ((this.height - this.getClientHeight()) % Formatter.DEFAULT_FONT_HEIGHT > 0) {
                ++this.sb_height;
            }
        }
        this.getScrollbar().setScrollbarDims(this.sb_height, 1);
        this.getScrollbar().setSliderPos(this.sb_offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(UIGraphics uIGraphics) {
        Object object = Display.DLock;
        synchronized (object) {
            Alert alert = this.parent;
            synchronized (alert) {
                int n = 0;
                if (this.parent.image_ != null && (n = 8 + this.parent.image_.getHeight()) > this.offset) {
                    uIGraphics.drawImage(this.parent.image_, this.getClientWidth() / 2, 4 - this.offset, 17);
                }
                uIGraphics.setColor(Colors.get((int)2));
                Enumeration enumeration = this.strings.elements();
                while (enumeration.hasMoreElements()) {
                    if (this.alignLeft) {
                        uIGraphics.drawString((String)enumeration.nextElement(), 3, n - this.offset, 20);
                    } else {
                        uIGraphics.drawString((String)enumeration.nextElement(), this.getClientWidth() / 2, n - this.offset, 17);
                    }
                    n += Formatter.DEFAULT_FONT_HEIGHT;
                }
            }
        }
    }

    public void onKeyDown(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyLongPress(int n) {
        if (n == -102) {
            Alert alert = this.parent;
            synchronized (alert) {
                if (this.parent.owner_ != null) {
                    this.parent.owner_.midlet.notifyBackground();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyReleased(int n) {
        if (n == -1 || n == -6) {
            Alert alert = this.parent;
            synchronized (alert) {
                if (this.height > this.getClientHeight()) {
                    if (n == -1) {
                        this.offset -= Formatter.DEFAULT_FONT_HEIGHT;
                        if (this.offset < 0) {
                            this.offset = 0;
                        }
                        --this.sb_offset;
                        if (this.sb_offset < 0) {
                            this.sb_offset = 0;
                        }
                    }
                    if (n == -6) {
                        this.offset += Formatter.DEFAULT_FONT_HEIGHT;
                        if (this.offset >= this.height - this.getClientHeight()) {
                            this.offset = this.height - this.getClientHeight() - 1;
                        }
                        ++this.sb_offset;
                        if (this.sb_offset >= this.sb_height) {
                            this.sb_offset = this.sb_height - 1;
                        }
                    }
                    this.getScrollbar().setSliderPos(this.sb_offset);
                    this.repaint();
                }
            }
        }
    }

    public void onKeyRepeated(int n) {
        this.onKeyReleased(n);
    }

    public void onKeyShortPress(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(int n) {
        Alert alert = this.parent;
        synchronized (alert) {
            if (this.parent.listener_ == null) {
                return;
            }
            Command command = this.parent.getCommandById(n);
            if (command == null) {
                return;
            }
            try {
                this.parent.listener_.commandAction(command, this.parent);
            }
            catch (Throwable throwable) {
                System.out.println("commandAction(Command " + n + ", Alert " + (Object)((Object)this) + ") " + throwable);
                throwable.printStackTrace();
            }
        }
    }
}

