/*
 * Decompiled with CFR 0.152.
 */
package VCStalker;

import UIBase.UIInterface;
import com.motorola.synerj.ui.PrimaryDisplay;
import com.motorola.synerj.ui.PrimaryDisplayListener;
import com.motorola.synerj.ui.PrimaryView;
import com.motorola.synerj.ui.PrimaryViewBase;
import java.util.Stack;

public final class DisplayListener
implements PrimaryDisplayListener {
    private PrimaryDisplay dlPrimaryDisplay;
    private Stack pvbStack = new Stack();
    private static DisplayListener dlDisplayListener;

    private final void pushPrimaryView(PrimaryViewBase primaryViewBase) {
        if (this.dlPrimaryDisplay != null) {
            try {
                this.dlPrimaryDisplay.pushView(primaryViewBase);
                if (primaryViewBase == null) {
                    this.pvbStack.pop();
                } else if (primaryViewBase instanceof PrimaryView) {
                    this.pvbStack.push(primaryViewBase);
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (primaryViewBase instanceof PrimaryView) {
            this.setPrimaryView((PrimaryView)primaryViewBase);
        }
    }

    private final void popPrimaryView(PrimaryView primaryView) {
        if (this.dlPrimaryDisplay != null) {
            try {
                this.dlPrimaryDisplay.popView(primaryView);
                if (primaryView == null || ((PrimaryView)this.pvbStack.peek()).equals(primaryView)) {
                    this.pvbStack.pop();
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private final void replacePrimaryView(PrimaryView primaryView) {
        if (this.dlPrimaryDisplay != null) {
            try {
                this.dlPrimaryDisplay.replaceView(primaryView);
                this.pvbStack.pop();
                if (primaryView != null) {
                    this.pvbStack.push(primaryView);
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private final void setPrimaryView(PrimaryView primaryView) {
        if (this.dlPrimaryDisplay == null) {
            this.dlPrimaryDisplay = PrimaryDisplay.getPrimaryDisplay((boolean)true);
            this.dlPrimaryDisplay.setListener((PrimaryDisplayListener)this);
        }
        this.pushPrimaryView((PrimaryViewBase)primaryView);
        this.dlPrimaryDisplay.start();
    }

    private final void clearPrimaryView() {
        try {
            this.pvbStack.removeAllElements();
            if (this.dlPrimaryDisplay != null) {
                this.dlPrimaryDisplay.stop();
                this.dlPrimaryDisplay = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void clearPrimaryViewStack() {
        try {
            this.pvbStack.removeAllElements();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void clearAfterFlip() {
        try {
            if (this.dlPrimaryDisplay != null) {
                this.dlPrimaryDisplay.stop();
                this.dlPrimaryDisplay = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean restoreAllViews() {
        if (!this.pvbStack.empty() && this.pvbStack.size() > 0) {
            Object[] objectArray = new Object[this.pvbStack.size()];
            this.pvbStack.copyInto(objectArray);
            this.pvbStack.removeAllElements();
            for (int i = 0; i < objectArray.length; ++i) {
                this.pushPrimaryView((PrimaryViewBase)objectArray[i]);
            }
            return true;
        }
        return false;
    }

    private final boolean isAlive() {
        return this.dlPrimaryDisplay != null;
    }

    private final PrimaryViewBase getTopView() {
        if (this.dlPrimaryDisplay != null) {
            return this.dlPrimaryDisplay.topView();
        }
        return null;
    }

    public final void gainFocus(PrimaryDisplay primaryDisplay) {
        if (primaryDisplay.topView() instanceof UIInterface) {
            ((UIInterface)primaryDisplay.topView()).gainFocus(primaryDisplay);
        }
    }

    public final void loseFocus(PrimaryDisplay primaryDisplay) {
        if (primaryDisplay.topView() instanceof UIInterface) {
            ((UIInterface)primaryDisplay.topView()).loseFocus(primaryDisplay);
        }
    }

    public final void destroyed(PrimaryDisplay primaryDisplay) {
        if (primaryDisplay.topView() instanceof UIInterface) {
            ((UIInterface)primaryDisplay.topView()).destroyed(primaryDisplay);
        }
    }

    protected static void activateDisplayListener() {
        dlDisplayListener = new DisplayListener();
    }

    protected static void deactivateDisplayListener() {
        dlDisplayListener = null;
    }

    public static void pushView(PrimaryViewBase primaryViewBase) {
        dlDisplayListener.pushPrimaryView(primaryViewBase);
    }

    public static void popView(PrimaryView primaryView) {
        dlDisplayListener.popPrimaryView(primaryView);
    }

    public static void replaseView(PrimaryView primaryView) {
        dlDisplayListener.replacePrimaryView(primaryView);
    }

    protected static void clearView() {
        dlDisplayListener.clearPrimaryView();
    }

    protected static void clearStack() {
        dlDisplayListener.clearPrimaryViewStack();
    }

    protected static void clearFlipView() {
        dlDisplayListener.clearAfterFlip();
    }

    protected static boolean restoreViews() {
        return dlDisplayListener.restoreAllViews();
    }

    public static boolean isViewAlive() {
        return dlDisplayListener.isAlive();
    }

    public static PrimaryViewBase topView() {
        return dlDisplayListener.getTopView();
    }
}

