/*
 * Decompiled with CFR 0.152.
 */
package Modules;

import com.motorola.synerj.svc.auf.FileSystem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public final class CoreletFileSystem {
    private String sFilePath;
    private FileConnection cConnection;

    public CoreletFileSystem(String string) {
        this.sFilePath = string;
    }

    private void close() {
        try {
            this.cConnection.close();
            this.cConnection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean open(int n) {
        try {
            this.cConnection = (FileConnection)Connector.open((String)("file://" + this.sFilePath), (int)n);
            return true;
        }
        catch (Exception exception) {
            this.cConnection = null;
            return false;
        }
    }

    public byte[] read() {
        if (!this.open(1)) {
            return null;
        }
        byte[] byArray = null;
        try {
            long l = this.cConnection.fileSize();
            byArray = new byte[(int)l];
            DataInputStream dataInputStream = this.cConnection.openDataInputStream();
            if (l != (long)dataInputStream.read(byArray)) {
                byArray = null;
            }
            dataInputStream.close();
            dataInputStream = null;
            this.close();
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public boolean write(byte[] byArray) {
        boolean bl = false;
        try {
            this.open(3);
            if (this.cConnection.exists()) {
                this.cConnection.delete();
            }
            this.cConnection.create();
            DataOutputStream dataOutputStream = this.cConnection.openDataOutputStream();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.close();
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean setSystem(boolean bl) {
        try {
            FileSystem.setSystem((String)("file://" + this.sFilePath), (boolean)bl);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte[] readFromJAR() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.sFilePath);
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            inputStream.close();
            inputStream = null;
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean exists() {
        if (!this.open(1)) {
            return false;
        }
        boolean bl = false;
        if (this.cConnection != null) {
            bl = this.cConnection.exists();
            this.close();
        }
        return bl;
    }

    public boolean mkdir() {
        this.open(3);
        if (this.cConnection != null) {
            try {
                if (!this.cConnection.exists()) {
                    this.cConnection.mkdir();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
        }
        return true;
    }
}

