/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class TPuzzleMIDlet
extends MIDlet
implements CommandListener {
    private Display fDisplay;
    private TCanvas fCanvas;
    private Ticker fTicker;
    private Form fForm;
    private TFont[] fFonts;
    private TBoard[] fBoards;
    private int fCurFont = -1;
    private int fCurBoard = -1;
    private int fPosX;
    private int fPosY;
    private int fHelp;
    private int fState;
    Command fPromptCommand = new Command("\u041f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430", 1, 20);
    Command fBoardCommand = new Command("\u0412\u044b\u0431\u043e\u0440 \u043f\u043e\u043b\u044f", 1, 30);
    Command fFontCommand = new Command("\u0412\u044b\u0431\u043e\u0440 \u0448\u0440\u0438\u0444\u0442\u0430", 1, 40);
    Command fHelpCommand = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 5, 50);
    Command fAboutCommand = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 1, 60);
    Command fBackCommand = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 70);
    Command fExitCommand = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 80);
    Command fOkCommand = new Command("OK", 4, 20);

    public TPuzzleMIDlet() {
        this.initBoard();
        this.fDisplay = Display.getDisplay((MIDlet)this);
        this.fCanvas = new TCanvas(this);
        this.fTicker = new Ticker("");
        this.fForm = new Form("");
        this.fCanvas.addCommand(this.fPromptCommand);
        this.fCanvas.addCommand(this.fBoardCommand);
        this.fCanvas.addCommand(this.fFontCommand);
        this.fCanvas.addCommand(this.fHelpCommand);
        this.fCanvas.addCommand(this.fAboutCommand);
        this.fCanvas.addCommand(this.fExitCommand);
        this.fCanvas.setCommandListener(this);
        this.fForm.addCommand(this.fBackCommand);
        this.fForm.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.fDisplay.setCurrent((Displayable)new TSplashScreen(this));
        this.fFonts = new TFont[6];
        int i = 0;
        while (i < 6) {
            this.fFonts[i] = new TFont("/font" + i + ".dat");
            if (this.fFonts[i].loaded() && this.fCurFont < 0) {
                this.fCurFont = i;
            }
            ++i;
        }
        this.fBoards = new TBoard[10];
        i = 0;
        while (i < 10) {
            this.fBoards[i] = new TBoard("/cw" + i + ".dat");
            if (this.fBoards[i].loaded() && this.fCurBoard < 0) {
                this.fCurBoard = i;
            }
            ++i;
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void SplashDone() {
        this.fDisplay.setCurrent((Displayable)this.fCanvas);
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.fFontCommand) {
            this.nextFont();
            this.fDisplay.setCurrent((Displayable)this.fCanvas);
        } else if (c == this.fPromptCommand) {
            this.nextHelp();
            this.fDisplay.setCurrent((Displayable)this.fCanvas);
        } else if (c == this.fOkCommand) {
            this.fDisplay.setCurrent((Displayable)this.fCanvas);
        } else if (c == this.fExitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (c == this.fBoardCommand) {
            this.nextBoard();
            this.fDisplay.setCurrent((Displayable)this.fCanvas);
        } else if (c == this.fHelpCommand) {
            this.fForm.setTitle("\u041f\u0440\u0430\u0432\u0438\u043b\u0430");
            if (this.fForm.size() > 0) {
                this.fForm.delete(0);
            }
            this.fForm.append("\u0426\u0435\u043b\u044c \u0438\u0433\u0440\u044b - \u043d\u0430\u0439\u0442\u0438 \u0438 \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430 \u0438\u0433\u0440\u043e\u0432\u043e\u043c \u043f\u043e\u043b\u0435 \u0441\u043b\u043e\u0432\u0430. \u041a\u043d\u043e\u043f\u043a\u0438: 2,4,6,8 - \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043a\u0443\u0440\u0441\u043e\u0440\u0430, 5 - \u043e\u0442\u043c\u0435\u0442\u043a\u0430, 1 - \u0432\u044b\u0431\u043e\u0440 \u0448\u0440\u0438\u0444\u0442\u0430 (\u043c\u0430\u0441\u0448\u0442\u0430\u0431), 3 - \u0432\u044b\u0431\u043e\u0440 \u043a\u0440\u043e\u0441\u0441\u0432\u043e\u0440\u0434\u0430, 7 - \u043f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430.");
            this.fDisplay.setCurrent((Displayable)this.fForm);
        } else if (c == this.fAboutCommand) {
            this.fForm.setTitle("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435");
            if (this.fForm.size() > 0) {
                this.fForm.delete(0);
            }
            this.fForm.append("\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0438\u043d\u043e\u0432 \u0410\u043d\u0434\u0440\u0435\u0439, 2004\r\nwww.mjsoft.nm.ru\r\nmjsoft@nm.ru");
            this.fDisplay.setCurrent((Displayable)this.fForm);
        } else if (c == this.fBackCommand) {
            this.fDisplay.setCurrent((Displayable)this.fCanvas);
        } else if (c != List.SELECT_COMMAND || s == this.fCanvas) {
            // empty if block
        }
    }

    public synchronized void paint(Graphics g) {
        int x = 0;
        int y = 0;
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        boolean tg = true;
        int ch = this.fFonts[this.fCurFont].getHeight();
        int cw = this.fFonts[this.fCurFont].getMaxWidth();
        int szx = clipw / (cw + 2);
        int szy = cliph / (ch + 2);
        int dx = szx / 2;
        int dy = szy / 2;
        int bclr = 0xFFFFFF;
        g.setColor(bclr);
        g.fillRect(0, 0, clipw, cliph);
        y = 0;
        int i = 0;
        while (i < szy) {
            x = 0;
            int j = 0;
            while (j < szx) {
                int k = this.fBoards[this.fCurBoard].getState(j + this.fPosX - dx, i + this.fPosY - dy);
                tg = true;
                switch (k & 7) {
                    case 0: {
                        tg = false;
                        break;
                    }
                    case 1: {
                        bclr = 0xEFE0E0;
                        if ((i & j & 1) == 1) {
                            bclr = 0xFFF0F0;
                            break;
                        }
                        if (((i | j) & 1) != 0) break;
                        bclr = 0xFFF0F0;
                        break;
                    }
                    case 2: {
                        bclr = 0x6060FF;
                        break;
                    }
                    case 3: {
                        bclr = 0x808080;
                    }
                }
                if (tg) {
                    int fclr;
                    if (this.fHelp == 2 && k >> 3 == this.fState) {
                        bclr = 13680768;
                    }
                    if (j == dx && i == dy) {
                        fclr = 0xFFFF40;
                        bclr = (k & 7) == 2 ? 0xC00000 : 0xFF0000;
                    } else {
                        fclr = 0;
                    }
                    g.setColor(bclr);
                    g.fillRect(x, y, cw + 2, ch + 2);
                    int n = this.fBoards[this.fCurBoard].getChar(j + this.fPosX - dx, i + this.fPosY - dy);
                    k = this.fFonts[this.fCurFont].getWidth(n);
                    g.setColor(fclr);
                    this.fFonts[this.fCurFont].drawChar(g, x + (cw + 2 - k) / 2, y + 1, n);
                }
                x = x + cw + 2;
                ++j;
            }
            y = y + ch + 2;
            ++i;
        }
        if (this.fHelp == 1) {
            byte[] wd = this.fBoards[this.fCurBoard].getWord(this.fPosX, this.fPosY);
            g.setColor(0xFFFF00);
            g.fillRect(0, 0, clipw, this.fFonts[0].getHeight() + 2);
            g.setColor(0xFF0000);
            g.drawRect(0, 0, clipw - 1, this.fFonts[0].getHeight() + 3);
            g.setColor(0);
            x = 2;
            i = 0;
            while (i < wd.length) {
                x = x + this.fFonts[this.fCurFont].drawChar(g, x, 0, wd[i]) + 1;
                ++i;
            }
        }
    }

    public void keyPressed(int keyCode) {
        int action = keyCode;
        boolean move = false;
        this.fState = this.fBoards[this.fCurBoard].getState(this.fPosX, this.fPosY) >> 3;
        switch (action) {
            case 2: 
            case 52: {
                if (this.fPosX > 0) {
                    --this.fPosX;
                }
                this.fHelp = 0;
                break;
            }
            case 5: 
            case 54: {
                if (this.fPosX + 1 < this.fBoards[this.fCurBoard].getWidth()) {
                    ++this.fPosX;
                }
                this.fHelp = 0;
                break;
            }
            case 6: 
            case 56: {
                if (this.fPosY + 1 < this.fBoards[this.fCurBoard].getHeight()) {
                    ++this.fPosY;
                }
                this.fHelp = 0;
                break;
            }
            case 1: 
            case 50: {
                if (this.fPosY > 0) {
                    --this.fPosY;
                }
                this.fHelp = 0;
                break;
            }
            case 8: 
            case 53: {
                this.fBoards[this.fCurBoard].setState(this.fPosX, this.fPosY, 2);
                this.fBoards[this.fCurBoard].checkSolution();
                this.fHelp = 0;
                break;
            }
            case 49: {
                this.nextFont();
                break;
            }
            case 51: {
                this.nextBoard();
                break;
            }
            case 55: {
                this.nextHelp();
                break;
            }
            default: {
                return;
            }
        }
        this.fCanvas.repaint();
    }

    public void nextFont() {
        int k = this.fFonts.length;
        int n = this.fCurFont;
        int i = 0;
        while (i < k) {
            n = n + 1 < k ? ++n : 0;
            if (this.fFonts[n].loaded()) {
                this.fCurFont = n;
                break;
            }
            ++i;
        }
        this.fHelp = 0;
    }

    public void nextBoard() {
        int k = this.fBoards.length;
        int n = this.fCurBoard;
        int i = 0;
        while (i < k) {
            n = n + 1 < k ? ++n : 0;
            if (this.fBoards[n].loaded()) {
                if (this.fCurBoard != n) {
                    this.initBoard();
                }
                this.fCurBoard = n;
                return;
            }
            ++i;
        }
    }

    public void nextHelp() {
        ++this.fHelp;
        if (this.fHelp > 2) {
            this.fHelp = 0;
        }
    }

    public void initBoard() {
        this.fPosX = 3;
        this.fPosY = 3;
        this.fHelp = 0;
        this.fState = 0;
    }
}

