/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.FullCanvas;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class BubbleTroubleGame
extends FullCanvas
implements Runnable {
    private Image offimg;
    private Graphics offg;
    private int w;
    private int h;
    RecordStore recordStore = null;
    Font font;
    Random rand = new Random(System.currentTimeMillis());
    boolean isMenuDisplayed = false;
    boolean loadedRes = false;
    int loadedImage = 0;
    Image imgTitle;
    Image imgGameOver;
    Image imgCursor;
    Image imgTopLine;
    Image imgNormal;
    Image imgTimed;
    Image[] imgSymbolsBig = new Image[5];
    Image[] imgSymbolsSmall = new Image[5];
    Image[] imgSymbolsBlank = new Image[6];
    Image[] imgNums = new Image[10];
    Thread th0;
    Thread th1;
    int mode;
    int pause = 100;
    boolean kLeft = false;
    boolean kRight = false;
    boolean kUp = false;
    boolean kDown = false;
    boolean kFire = false;
    int gameStatus;
    byte gameType = 1;
    int tileWidth = 19;
    int tileHeight = 19;
    int X_BOARDSIZE = 9;
    int Y_BOARDSIZE = 10;
    int[][] board = new int[this.X_BOARDSIZE][this.Y_BOARDSIZE];
    int[][] board2 = new int[this.X_BOARDSIZE][this.Y_BOARDSIZE];
    int selected_x;
    int selected_y;
    int combo;
    int level;
    int selected;
    int anim_counter;
    int anim;
    int score;
    int gameover;
    int ss;
    int repeat;
    int exitgame;
    int[] scores = new int[5];
    String[] topName = new String[5];
    int[] topScore = new int[5];
    String playerName = "ss";
    byte[] saveTopBuffer;
    boolean loadedTopData = false;
    byte speed = (byte)3;
    byte sound = 1;
    byte vibra = 1;
    byte backlight = 1;
    private static final int REFRESH_PAUSE = 30;
    long timer;
    int secsPerLevel;
    int currentSecs;
    BubbleTrouble mainClass;
    private Sound eff = null;

    public BubbleTroubleGame(BubbleTrouble bubbleTrouble) {
        this.mainClass = bubbleTrouble;
        this.saveTopBuffer = new byte[69];
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.setSpeed(this.speed);
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.offimg = Image.createImage((int)this.w, (int)this.h);
        this.offg = this.offimg.getGraphics();
        this.offg.setClip(0, 0, this.w, this.h);
        this.th0 = new Thread(this);
        this.th0.start();
    }

    private void loadResources() {
        if (!this.loadedRes) {
            try {
                while (this.imgTitle == null) {
                    Graphics graphics;
                    int n;
                    Image image;
                    if (this.loadedImage == 1) {
                        image = Image.createImage((String)"/pics/symbols.png");
                        for (n = 0; n < 5; ++n) {
                            this.imgSymbolsBig[n] = Image.createImage((int)this.tileWidth, (int)this.tileHeight);
                            graphics = this.imgSymbolsBig[n].getGraphics();
                            graphics.drawImage(image, 0, -n * this.tileHeight, 20);
                        }
                        for (n = 0; n < 5; ++n) {
                            this.imgSymbolsSmall[n] = Image.createImage((int)this.tileWidth, (int)this.tileHeight);
                            graphics = this.imgSymbolsSmall[n].getGraphics();
                            graphics.drawImage(image, 0, -(n + 5) * this.tileHeight, 20);
                        }
                        for (n = 0; n < 6; ++n) {
                            this.imgSymbolsBlank[n] = Image.createImage((int)this.tileWidth, (int)this.tileHeight);
                            graphics = this.imgSymbolsBlank[n].getGraphics();
                            graphics.drawImage(image, 0, -(n + 10) * this.tileHeight, 20);
                        }
                        image = null;
                    }
                    if (this.loadedImage == 2) {
                        this.loadRMSData();
                    }
                    if (this.loadedImage == 3) {
                        this.imgCursor = Image.createImage((String)"/pics/cursor.png");
                    }
                    if (this.loadedImage == 4) {
                        this.imgTopLine = Image.createImage((String)"/pics/topline.png");
                    }
                    if (this.loadedImage == 5) {
                        this.imgGameOver = Image.createImage((String)"/pics/gameover.png");
                    }
                    if (this.loadedImage == 6) {
                        image = Image.createImage((String)"/pics/digits.png");
                        for (n = 0; n < 10; ++n) {
                            this.imgNums[n] = Image.createImage((int)10, (int)10);
                            graphics = this.imgNums[n].getGraphics();
                            graphics.drawImage(image, 0, -n * 10, 20);
                        }
                        image = null;
                    }
                    if (this.loadedImage == 7) {
                        this.imgNormal = Image.createImage((String)"/pics/normal.png");
                    }
                    if (this.loadedImage == 8) {
                        this.imgTimed = Image.createImage((String)"/pics/timed.png");
                    }
                    if (this.loadedImage == 9) {
                        this.imgTitle = Image.createImage((String)"/pics/title.png");
                    }
                    ++this.loadedImage;
                    this.drawLoadingGauge(this.loadedImage * 100 / 10);
                    this.repaint();
                    this.serviceRepaints();
                    try {
                        Thread.sleep(16L);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException iOException) {
                System.out.println("Failed open resource files.");
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
            this.loadedRes = true;
        }
    }

    void drawStringCenter(String string, int n) {
        this.offg.drawString(string, this.w / 2, n, 17);
    }

    private void drawLoadingGauge(int n) {
        this.offg.setColor(0xFFFFFF);
        this.offg.fillRect(0, 0, this.w, this.h);
        this.offg.setColor(0);
        this.drawStringCenter("Loading... " + n + "%", (this.h - 9) / 2 - this.font.getHeight() - 6);
        this.drawStringCenter("Please wait!", (this.h - 9) / 2 + this.font.getHeight() + 6);
    }

    private void drawNumber(int n, int n2, int n3) {
        String string = String.valueOf(n);
        for (int i = 0; i < string.length(); ++i) {
            this.offg.drawImage(this.imgNums[string.charAt(i) - 48], n2 + (i + 1) * 9 - 4, n3, 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        try {
            BubbleTroubleGame bubbleTroubleGame = this;
            synchronized (bubbleTroubleGame) {
                if (this.th1 != null) {
                    this.wait();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sleep(int n) {
        for (int i = 0; i < n; ++i) {
            this.sleep();
        }
    }

    private void MainLoop() {
        do {
            this.playGame();
        } while (this.mode != 2);
    }

    private void playGame() {
        this.offg.setColor(0xFFFFFF);
        this.offg.fillRect(0, 0, this.w, this.h);
        this.mode = 1;
        this.gameStatus = 1;
        while (this.mode == 1) {
            if (this.gameStatus == 1) {
                if (this.kLeft) {
                    this.gameType = 1;
                    this.kLeft = false;
                }
                if (this.kRight) {
                    this.gameType = (byte)2;
                    this.kRight = false;
                }
                if (this.kFire) {
                    this.InitBoard();
                    this.selected_x = 0;
                    this.selected_y = 0;
                    this.selected = 0;
                    this.anim = 0;
                    this.score = 0;
                    this.level = 0;
                    this.repeat = 0;
                    this.gameover = 0;
                    if (this.gameType == 2) {
                        this.timer = Calendar.getInstance().getTime().getTime();
                        this.secsPerLevel = 200;
                    }
                    this.resetKeys();
                    this.gameStatus = 2;
                }
                this.offg.drawImage(this.imgTitle, 0, 0, 20);
                if (this.gameType == 1) {
                    this.offg.drawImage(this.imgTimed, 106, 151, 20);
                } else {
                    this.offg.drawImage(this.imgNormal, 13, 151, 20);
                }
            } else if (this.gameStatus == 2) {
                boolean bl = false;
                boolean bl2 = false;
                if (this.kLeft && this.selected_x > 0) {
                    --this.selected_x;
                    bl = true;
                }
                if (this.kRight && this.selected_x < this.X_BOARDSIZE - 1) {
                    ++this.selected_x;
                    bl = true;
                }
                if (this.kUp && this.selected_y > 0) {
                    --this.selected_y;
                    bl = true;
                }
                if (this.kDown && this.selected_y < this.Y_BOARDSIZE - 1) {
                    ++this.selected_y;
                    bl = true;
                }
                this.ss = this.board[this.selected_x][this.selected_y];
                if (this.kFire && this.repeat == 0) {
                    this.Selected();
                } else if (!this.kFire) {
                    this.repeat = 0;
                }
                this.DrawBoard();
                if (this.anim == 1) {
                    this.AnimateDestroy();
                }
                if (this.gameType == 2) {
                    this.currentSecs = (int)((Calendar.getInstance().getTime().getTime() - this.timer) / 1000L);
                    if (this.secsPerLevel - this.currentSecs < 0) {
                        this.gameStatus = 3;
                    } else {
                        this.offg.setColor(0xFF0000);
                        this.offg.fillRect(3, 13, (this.secsPerLevel - this.currentSecs) * 170 / this.secsPerLevel, 4);
                    }
                }
                if (this.CheckPairs() == 0 && this.anim == 0) {
                    if (this.BoardFull() == 1) {
                        this.gameStatus = 3;
                    } else {
                        this.UpdatePlayfield();
                        this.playSound(2);
                        ++this.level;
                        if (this.gameType == 2) {
                            this.timer = Calendar.getInstance().getTime().getTime();
                            this.secsPerLevel = 100 + this.level * 10;
                        }
                        this.gameStatus = 2;
                    }
                }
                this.MoveCursor();
                while (this.isMenuDisplayed) {
                }
            } else if (this.gameStatus == 3) {
                this.DrawBoard();
                this.ShowGameOver();
                this.isTopScore();
                this.offg.drawImage(this.imgTitle, 0, 0, 20);
                this.resetKeys();
                this.gameStatus = 1;
            }
            this.repaint();
            this.serviceRepaints();
            this.sleep();
        }
    }

    private void Selected() {
        if (this.ss != 32 && this.ss > 0 && this.anim == 0) {
            this.combo = 0;
            if (this.LookAround(this.selected_x, this.selected_y, this.ss) == 1) {
                this.anim_counter = 0;
                this.anim = 1;
            } else {
                this.Deselect();
            }
        } else if (this.anim == 1 & this.ss > 32) {
            this.playSound(1);
            this.anim = 0;
            this.combo = (this.combo - 2) * (this.combo - 2) + this.level * 2 >> 1;
            this.score += this.combo;
            this.Splash();
            this.ClearSelected();
            this.Remove();
            this.combo = 0;
        } else if (this.anim == 1 && this.ss < 33) {
            this.anim = 0;
            this.playSound(2);
            this.Deselect();
        }
        this.repeat = 1;
    }

    private int abs(int n) {
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    private int LookAround(int n, int n2, int n3) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1 + this.abs(i); j < 2; j += 2) {
                if (n + i >= this.X_BOARDSIZE || n2 + j >= this.Y_BOARDSIZE || n + i < 0 || n2 + j < 0 || this.board[n + i][n2 + j] != n3 || (this.board[n + i][n2 + j] & 0x20) != 0) continue;
                int[] nArray = this.board[n + i];
                int n4 = n2 + j;
                nArray[n4] = nArray[n4] | 0x20;
                ++this.combo;
                this.LookAround(n + i, n2 + j, n3);
            }
        }
        if (this.combo < 3) {
            this.Deselect();
            return 0;
        }
        return 1;
    }

    private void Deselect() {
        this.selected = 0;
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                if (this.board[i][j] <= 32) continue;
                int[] nArray = this.board[i];
                int n = j;
                nArray[n] = nArray[n] - 32;
            }
        }
    }

    private int FindSpaces(int n) {
        int n2 = 0;
        for (int i = 0; i < this.Y_BOARDSIZE - 1; ++i) {
            if (this.board[n][i] <= 0 || this.board[n][i + 1] != 0) continue;
            ++n2;
        }
        return n2;
    }

    private void Remove() {
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            do {
                boolean bl = false;
                for (int j = this.Y_BOARDSIZE - 2; j > -1; --j) {
                    int n = this.board[i][j];
                    int n2 = this.board[i][j + 1];
                    if (n2 != 0) continue;
                    this.board[i][j + 1] = n;
                    this.board[i][j] = 0;
                    bl = true;
                }
            } while (this.FindSpaces(i) > 0);
        }
    }

    private void ClearSelected() {
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                if (this.board[i][j] <= 31) continue;
                this.board[i][j] = 0;
            }
        }
    }

    private int CheckPairs() {
        int n = 0;
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                int n2 = this.board[i][j];
                if (n2 >= 32 || n2 <= 0) continue;
                int n3 = i < this.X_BOARDSIZE - 1 ? this.board[i + 1][j] : 255;
                int n4 = j < this.Y_BOARDSIZE - 1 ? this.board[i][j + 1] : 255;
                int n5 = j > 0 ? this.board[i][j - 1] : 255;
                int n6 = i > 0 ? this.board[i - 1][j] : 255;
                if (!(n2 == n5 && n2 == n4 || n2 == n5 && n2 == n3 || n2 == n4 && n2 == n3 || n2 == n6 && n2 == n3 || n2 == n6 && n2 == n4) && (n2 != n5 || n2 != n6)) continue;
                n = 1;
            }
        }
        return n;
    }

    private void UpdatePlayfield() {
        int n;
        int n2;
        int n3 = this.level > 10 ? 5 : 4;
        for (n2 = 0; n2 < this.X_BOARDSIZE; ++n2) {
            for (n = 0; n < this.Y_BOARDSIZE; ++n) {
                this.board2[n2][n] = 0;
            }
        }
        for (n2 = 0; n2 < this.X_BOARDSIZE; ++n2) {
            for (n = 0; n < this.Y_BOARDSIZE; ++n) {
                if (this.board[n2][n] != 0) continue;
                this.board2[n2][n] = (this.rand.nextInt() >>> 1) % n3 + 1;
            }
        }
        for (int i = this.Y_BOARDSIZE - 1; i >= 0; --i) {
            for (int j = 0; j < this.X_BOARDSIZE; ++j) {
                if (this.board2[j][i] == 0) continue;
                boolean bl = false;
                for (int k = this.Y_BOARDSIZE - (i + 1); k >= 0; --k) {
                    if (this.board[j][k] != 0) {
                        if (!bl) continue;
                        this.board[j][k + 1] = this.board[j][k];
                        continue;
                    }
                    bl = true;
                }
                this.board[j][0] = this.board2[j][i];
            }
        }
    }

    private int BoardFull() {
        int n = 1;
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                if (this.board[i][j] != 0) continue;
                n = 0;
            }
        }
        return n;
    }

    private void InitBoard() {
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                this.board[i][j] = (this.rand.nextInt() >>> 1) % 4 + 1;
            }
        }
        this.level = 1;
        this.anim_counter = 0;
        this.combo = 0;
        this.selected_x = 0;
        this.selected_y = 0;
    }

    private void DrawBoard() {
        this.offg.setColor(0xFFFFFF);
        this.offg.fillRect(0, 0, this.w, this.h);
        this.offg.drawImage(this.imgTopLine, 0, 0, 20);
        this.drawNumber(this.level + 1, 44, 1);
        this.drawNumber(this.score, 126, 1);
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                if (this.board[i][j] > 0 && this.board[i][j] < 6) {
                    this.offg.drawImage(this.imgSymbolsBig[this.board[i][j] - 1], 3 + i * 19, 18 + j * 19, 20);
                    continue;
                }
                this.offg.drawImage(this.imgSymbolsBlank[5], 3 + i * 19, 18 + j * 19, 20);
            }
        }
    }

    private void AnimateDestroy() {
        this.anim_counter ^= 1;
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                int n = this.board[i][j];
                int n2 = n & 7;
                if (n > 32 && this.anim_counter == 1) {
                    if (n2 > 0 && n2 < 6) {
                        this.offg.drawImage(this.imgSymbolsBig[n2 - 1], 3 + i * 19, 18 + j * 19, 20);
                        continue;
                    }
                    this.offg.drawImage(this.imgSymbolsBlank[5], 3 + i * 19, 18 + j * 19, 20);
                    continue;
                }
                if (n <= 32 || this.anim_counter != 0) continue;
                if (n2 > 0 && n2 < 6) {
                    this.offg.drawImage(this.imgSymbolsSmall[n2 - 1], 3 + i * 19, 18 + j * 19, 20);
                    continue;
                }
                this.offg.drawImage(this.imgSymbolsBlank[5], 3 + i * 19, 18 + j * 19, 20);
            }
        }
    }

    private void Splash() {
        this.DrawBoard();
        if (this.gameType == 2) {
            this.offg.setColor(0xFF0000);
            this.offg.fillRect(3, 13, (this.secsPerLevel - this.currentSecs) * 170 / this.secsPerLevel, 4);
        }
        for (int i = 0; i < this.X_BOARDSIZE; ++i) {
            for (int j = 0; j < this.Y_BOARDSIZE; ++j) {
                int n = this.board[i][j];
                if (n <= 31) continue;
                int n2 = n - 32;
                if (n2 > 0 && n2 < 6) {
                    this.offg.drawImage(this.imgSymbolsBlank[n2 - 1], 3 + i * 19, 18 + j * 19, 20);
                    continue;
                }
                this.offg.drawImage(this.imgSymbolsBlank[5], 3 + i * 19, 18 + j * 19, 20);
            }
        }
        this.repaint();
        this.serviceRepaints();
        if (this.gameType == 2) {
            this.sleep(2);
        } else {
            this.sleep(5);
        }
    }

    private void MoveCursor() {
        this.offg.drawImage(this.imgCursor, 11 + this.selected_x * 19, 26 + this.selected_y * 19, 20);
    }

    private void ShowGameOver() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            this.offg.setClip(n + 3, 113, 19, 19);
            this.offg.drawImage(this.imgGameOver, n + 3, 113 - i * 19, 20);
            this.offg.setClip(0, 0, this.w, this.h);
            n += 19;
            if (i == 3) {
                n += 19;
            }
            this.repaint();
            this.serviceRepaints();
            this.sleep(5);
        }
        this.sleep(15);
    }

    private void isTopScore() {
        int n;
        boolean bl = false;
        for (n = 0; n < 5; ++n) {
            if (this.score < this.topScore[n]) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (int i = 4; i > n; --i) {
                this.topName[i] = this.topName[i - 1];
                this.topScore[i] = this.topScore[i - 1];
            }
            this.topScore[n] = this.score;
            BubbleTrouble.isScoreScreen = true;
            BubbleTrouble.displayScoreForm(n + 1);
            this.playerName = "";
            do {
            } while (BubbleTrouble.isScoreScreen);
            if (this.playerName.length() > 9) {
                this.playerName = this.playerName.substring(0, 9);
            }
            this.topName[n] = this.playerName;
            this.saveRMSData();
            this.mainClass.displayHighScoresList();
            BubbleTrouble.isScoreScreen = true;
            do {
            } while (BubbleTrouble.isScoreScreen);
        }
    }

    public void saveRMSData() {
        for (int i = 0; i < 5; ++i) {
            int n = i * 13;
            for (int j = 0; j < 9; ++j) {
                this.saveTopBuffer[j + n] = j >= this.topName[i].length() ? 32 : (byte)this.topName[i].charAt(j);
            }
            this.saveTopBuffer[9 + n] = (byte)(this.topScore[i] & 0xFF);
            this.saveTopBuffer[10 + n] = (byte)(this.topScore[i] >> 8);
            this.saveTopBuffer[11 + n] = (byte)(this.topScore[i] >> 16);
            this.saveTopBuffer[12 + n] = (byte)(this.topScore[i] >> 24);
        }
        this.saveTopBuffer[65] = this.speed;
        this.saveTopBuffer[66] = this.sound;
        this.saveTopBuffer[67] = this.vibra;
        this.saveTopBuffer[68] = this.backlight;
        this.setRecord("Bubble", this.saveTopBuffer, 0);
    }

    private void loadRMSData() {
        int n;
        int n2;
        int n3;
        if (!this.loadedTopData && !this.getRecord("Bubble", this.saveTopBuffer)) {
            String string = "Anonymous";
            for (n3 = 0; n3 < 5; ++n3) {
                n2 = n3 * 13;
                for (n = 0; n < 9; ++n) {
                    this.saveTopBuffer[n + n2] = (byte)string.charAt(n);
                }
                n = 1000 - 200 * n3;
                this.saveTopBuffer[9 + n2] = (byte)(n & 0xFF);
                this.saveTopBuffer[10 + n2] = (byte)(n >> 8);
                this.saveTopBuffer[11 + n2] = (byte)(n >> 16);
                this.saveTopBuffer[12 + n2] = (byte)(n >> 24);
            }
            this.saveTopBuffer[65] = this.speed;
            this.saveTopBuffer[66] = this.sound;
            this.saveTopBuffer[67] = this.vibra;
            this.saveTopBuffer[68] = this.backlight;
        }
        for (int i = 0; i < 5; ++i) {
            n2 = i * 13;
            this.topName[i] = "";
            for (n3 = 0; n3 < 9; ++n3) {
                this.topName[i] = this.topName[i] + String.valueOf((char)this.saveTopBuffer[n3 + n2]);
            }
            n3 = this.saveTopBuffer[9 + n2] & 0xFF;
            n = (this.saveTopBuffer[10 + n2] & 0xFF) << 8;
            int n4 = (this.saveTopBuffer[11 + n2] & 0xFF) << 16;
            int n5 = (this.saveTopBuffer[12 + n2] & 0xFF) << 24;
            this.topScore[i] = n3 | n | n4 | n5;
        }
        this.speed = this.saveTopBuffer[65];
        this.sound = this.saveTopBuffer[66];
        this.vibra = this.saveTopBuffer[67];
        this.backlight = this.saveTopBuffer[68];
        this.setSpeed(this.speed);
        this.loadedTopData = true;
    }

    private void setRecord(String string, byte[] byArray, int n) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            this.recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            this.recordStore.addRecord(byArray, n, byArray.length - n);
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private boolean getRecord(String string, byte[] byArray) {
        boolean bl = false;
        try {
            this.recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            RecordEnumeration recordEnumeration = this.recordStore.enumerateRecords(null, null, true);
            if (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.recordStore.getRecord(n));
                byteArrayInputStream.read(byArray, 0, byArray.length);
                bl = true;
            }
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void destroy() {
        if (this.loadedRes) {
            this.saveRMSData();
        }
        this.th0 = null;
        this.th1 = null;
        this.mode = 2;
    }

    public void resetKeys() {
        this.kLeft = false;
        this.kRight = false;
        this.kUp = false;
        this.kDown = false;
        this.kFire = false;
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n2 == 2 || n == 52) {
            this.kLeft = true;
        }
        if (n2 == 5 || n == 54) {
            this.kRight = true;
        }
        if (n2 == 1 || n == 50) {
            this.kUp = true;
        }
        if (n2 == 6 || n == 56) {
            this.kDown = true;
        }
        if (n2 == 8 || n == 53) {
            this.kFire = true;
        }
        if (n == -6 && this.gameStatus == 2) {
            this.resetKeys();
            this.gameStatus = 1;
        }
        if (n == -7) {
            this.resetKeys();
            if (this.gameStatus != 3) {
                this.isMenuDisplayed = true;
                this.mainClass.pauseApp();
            }
        }
    }

    protected void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        if (this.gameStatus == 2) {
            if (n2 == 2 || n == 52) {
                this.kLeft = false;
            }
            if (n2 == 5 || n == 54) {
                this.kRight = false;
            }
            if (n2 == 1 || n == 50) {
                this.kUp = false;
            }
            if (n2 == 6 || n == 56) {
                this.kDown = false;
            }
            if (n2 == 8 || n == 53) {
                this.kFire = false;
            }
        }
    }

    public void setSpeed(int n) {
        this.speed = (byte)n;
        this.pause = this.speed * 30;
    }

    public void setLight(int n) {
    }

    private void playVibra() {
    }

    private void playSound(int n) {
        if (this.sound == 1) {
            try {
                if (n == 0) {
                    this.eff = new Sound(568, 60L);
                    this.eff.setGain(255);
                    this.eff.play(1);
                } else if (n == 1) {
                    this.eff = new Sound(617, 60L);
                    this.eff.setGain(255);
                    this.eff.play(1);
                } else if (n == 2) {
                    this.eff = new Sound(711, 70L);
                    this.eff.setGain(255);
                    this.eff.play(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.loadResources();
        if (this.th1 == null) {
            this.th1 = new Thread(this);
            this.th1.start();
            this.MainLoop();
        } else {
            Thread thread = Thread.currentThread();
            while (thread == this.th1) {
                try {
                    BubbleTroubleGame bubbleTroubleGame = this;
                    synchronized (bubbleTroubleGame) {
                        this.notify();
                        this.wait(this.pause);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.offimg, 0, 0, 0x10 | 4);
    }
}

